/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLDataFactoryInternalsImpl
implements OWLDataFactoryInternals {
    private WeakHashMap<IRI, WeakReference<? extends OWLEntity>> classesByURI;
    private final WeakHashMap<IRI, WeakReference<? extends OWLEntity>> objectPropertiesByURI;
    private final WeakHashMap<IRI, WeakReference<? extends OWLEntity>> dataPropertiesByURI;
    private final WeakHashMap<IRI, WeakReference<? extends OWLEntity>> datatypesByURI;
    private final WeakHashMap<IRI, WeakReference<? extends OWLEntity>> individualsByURI;
    private final WeakHashMap<IRI, WeakReference<? extends OWLEntity>> annotationPropertiesByURI;
    private final OWLDataFactory factory;

    public OWLDataFactoryInternalsImpl(OWLDataFactory f) {
        this.factory = f;
        this.classesByURI = new WeakHashMap();
        this.objectPropertiesByURI = new WeakHashMap();
        this.dataPropertiesByURI = new WeakHashMap();
        this.datatypesByURI = new WeakHashMap();
        this.individualsByURI = new WeakHashMap();
        this.annotationPropertiesByURI = new WeakHashMap();
    }

    private OWLEntity unwrap(Map<IRI, WeakReference<? extends OWLEntity>> map, IRI iri, BuildableObjects type) {
        OWLEntity toReturn = null;
        while (toReturn == null) {
            WeakReference<? extends OWLEntity> r = this.safeRead(map, iri, type);
            if (r == null || r.get() == null) {
                toReturn = type.build(this.factory, iri);
                r = new WeakReference<OWLEntity>(toReturn);
                this.safeWrite(map, iri, r, type);
                continue;
            }
            toReturn = (OWLEntity)r.get();
        }
        return toReturn;
    }

    private WeakReference<? extends OWLEntity> safeRead(Map<IRI, WeakReference<? extends OWLEntity>> map, IRI iri, BuildableObjects type) {
        return map.get(iri);
    }

    private void safeWrite(Map<IRI, WeakReference<? extends OWLEntity>> map, IRI iri, WeakReference<? extends OWLEntity> value, BuildableObjects type) {
        map.put(iri, value);
    }

    @Override
    public OWLClass getOWLClass(IRI iri) {
        return (OWLClass)this.unwrap(this.classesByURI, iri, BuildableObjects.OWLCLASS);
    }

    private void clear(Map<?, ?> map) {
        map.clear();
    }

    @Override
    public void purge() {
        this.clear(this.classesByURI);
        this.clear(this.objectPropertiesByURI);
        this.clear(this.dataPropertiesByURI);
        this.clear(this.datatypesByURI);
        this.clear(this.individualsByURI);
        this.clear(this.annotationPropertiesByURI);
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return (OWLObjectProperty)this.unwrap(this.objectPropertiesByURI, iri, BuildableObjects.OWLOBJECTPROPERTY);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return (OWLDataProperty)this.unwrap(this.dataPropertiesByURI, iri, BuildableObjects.OWLDATAPROPERTY);
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return (OWLNamedIndividual)this.unwrap(this.individualsByURI, iri, BuildableObjects.OWLNAMEDINDIVIDUAL);
    }

    @Override
    public OWLDatatype getOWLDatatype(IRI iri) {
        return (OWLDatatype)this.unwrap(this.datatypesByURI, iri, BuildableObjects.OWLDATATYPE);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return (OWLAnnotationProperty)this.unwrap(this.annotationPropertiesByURI, iri, BuildableObjects.OWLANNOTATIONPROPERTY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BuildableObjects {
        OWLCLASS{

            OWLEntity build(OWLDataFactory f, IRI iri) {
                return new OWLClassImpl(f, iri);
            }
        }
        ,
        OWLOBJECTPROPERTY{

            OWLEntity build(OWLDataFactory f, IRI iri) {
                return new OWLObjectPropertyImpl(f, iri);
            }
        }
        ,
        OWLDATAPROPERTY{

            OWLEntity build(OWLDataFactory f, IRI iri) {
                return new OWLDataPropertyImpl(f, iri);
            }
        }
        ,
        OWLNAMEDINDIVIDUAL{

            OWLEntity build(OWLDataFactory f, IRI iri) {
                return new OWLNamedIndividualImpl(f, iri);
            }
        }
        ,
        OWLDATATYPE{

            OWLEntity build(OWLDataFactory f, IRI iri) {
                return new OWLDatatypeImpl(f, iri);
            }
        }
        ,
        OWLANNOTATIONPROPERTY{

            OWLEntity build(OWLDataFactory f, IRI iri) {
                return new OWLAnnotationPropertyImpl(f, iri);
            }
        };


        abstract OWLEntity build(OWLDataFactory var1, IRI var2);
    }
}

