/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLEntityCollector;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyImplInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyImplInternalsDefaultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologyImpl
extends OWLObjectImpl
implements OWLMutableOntology {
    private final OWLOntologyManager manager;
    private OWLOntologyID ontologyID;
    protected OWLOntologyImplInternals internals;

    public OWLOntologyImpl(OWLOntologyManager manager, OWLOntologyID ontologyID) {
        super(manager.getOWLDataFactory());
        this.manager = manager;
        this.ontologyID = ontologyID;
        this.internals = new OWLOntologyImplInternalsDefaultImpl();
    }

    @Override
    public OWLOntologyManager getOWLOntologyManager() {
        return this.manager;
    }

    @Override
    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    @Override
    public boolean isAnonymous() {
        return this.getOntologyID().isAnonymous();
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        if (object == this) {
            return 0;
        }
        OWLOntology other = (OWLOntology)object;
        return this.getOntologyID().compareTo(other.getOntologyID());
    }

    @Override
    public boolean isEmpty() {
        for (AxiomType type : this.internals.getAxiomsByType().keySet()) {
            Set<OWLAxiom> axiomSet = this.internals.getAxiomsByType().get(type);
            if (axiomSet == null || axiomSet.isEmpty()) continue;
            return false;
        }
        return this.internals.getOntologyAnnotations().isEmpty();
    }

    @Override
    public int getAxiomCount() {
        int count = 0;
        for (AxiomType type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> axiomSet = this.internals.getAxiomsByType().get(type);
            if (axiomSet == null) continue;
            count += axiomSet.size();
        }
        return count;
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        Set<OWLAxiom> axioms = CollectionFactory.createSet();
        for (AxiomType type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> owlAxiomSet = this.internals.getAxiomsByType().get(type);
            if (owlAxiomSet == null) continue;
            axioms.addAll(owlAxiomSet);
        }
        return axioms;
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType) {
        return this.internals.getAxioms(axiomType, this.internals.getAxiomsByType(), false);
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getAxioms(axiomType);
        }
        Set result = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getAxioms(axiomType));
        }
        return result;
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        Set<OWLAxiom> axioms = this.internals.getAxiomsByType().get(axiomType);
        if (axioms == null) {
            return 0;
        }
        return axioms.size();
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getAxiomCount(axiomType);
        }
        int result = 0;
        for (OWLOntology ont : this.getImportsClosure()) {
            result += ont.getAxiomCount(axiomType);
        }
        return result;
    }

    @Override
    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        Set<OWLLogicalAxiom> axioms = CollectionFactory.createSet();
        for (AxiomType type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> axiomSet;
            if (!type.isLogical() || (axiomSet = this.internals.getAxiomsByType().get(type)) == null) continue;
            for (OWLAxiom ax : axiomSet) {
                axioms.add((OWLLogicalAxiom)ax);
            }
        }
        return axioms;
    }

    @Override
    public int getLogicalAxiomCount() {
        int count = 0;
        for (AxiomType type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> axiomSet;
            if (!type.isLogical() || (axiomSet = this.internals.getAxiomsByType().get(type)) == null) continue;
            count += axiomSet.size();
        }
        return count;
    }

    @Override
    public Set<OWLAnnotation> getAnnotations() {
        return this.internals.getReturnSet(this.internals.getOntologyAnnotations());
    }

    @Override
    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(OWLAnnotationProperty subProperty) {
        Set<OWLSubAnnotationPropertyOfAxiom> result = CollectionFactory.createSet();
        for (OWLSubAnnotationPropertyOfAxiom ax : this.internals.getAxiomsInternal(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            if (!ax.getSubProperty().equals(subProperty)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(OWLAnnotationProperty property) {
        Set<OWLAnnotationPropertyDomainAxiom> result = CollectionFactory.createSet();
        for (OWLAnnotationPropertyDomainAxiom ax : this.internals.getAxiomsInternal(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            if (!ax.getProperty().equals(property)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(OWLAnnotationProperty property) {
        Set<OWLAnnotationPropertyRangeAxiom> result = CollectionFactory.createSet();
        for (OWLAnnotationPropertyRangeAxiom ax : this.internals.getAxiomsInternal(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            if (!ax.getProperty().equals(property)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLDeclarationAxiom> getDeclarationAxioms(OWLEntity entity) {
        return this.internals.getReturnSet(this.internals.getAxioms(entity, this.internals.getDeclarationsByEntity(), false));
    }

    @Override
    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject subject) {
        Set<OWLAnnotationAssertionAxiom> axioms = CollectionFactory.createSet();
        axioms.addAll(this.internals.getAnnotationAssertionAxiomsBySubject(subject));
        return axioms;
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(IRI subject) {
        return this.internals.getAnnotationAssertionAxiomsBySubject(subject);
    }

    @Override
    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return this.internals.getReturnSet(this.internals.getGeneralClassAxioms());
    }

    public Set<OWLSubPropertyChainOfAxiom> getPropertyChainSubPropertyAxioms() {
        return this.internals.getReturnSet(this.internals.getPropertyChainSubPropertyAxioms());
    }

    @Override
    public boolean containsAxiom(OWLAxiom axiom) {
        Set<OWLAxiom> axioms = this.internals.getAxiomsByType().get(axiom.getAxiomType());
        return axioms != null && axioms.contains(axiom);
    }

    @Override
    public boolean containsAxiom(OWLAxiom axiom, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsAxiom(axiom);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsAxiom(axiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom) {
        if (axiom.isAnnotated()) {
            return this.internals.getLogicalAxiom2AnnotatedAxiomMap().containsKey(axiom.getAxiomWithoutAnnotations());
        }
        return this.containsAxiom(axiom) || this.internals.getLogicalAxiom2AnnotatedAxiomMap().containsKey(axiom);
    }

    @Override
    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsAxiomIgnoreAnnotations(axiom);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsAxiomIgnoreAnnotations(axiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom) {
        Set<OWLAxiom> annotated;
        Set<OWLAxiom> result = CollectionFactory.createSet();
        if (this.containsAxiom(axiom)) {
            result.add(axiom);
        }
        if ((annotated = this.internals.getLogicalAxiom2AnnotatedAxiomMap().get(axiom.getAxiomWithoutAnnotations())) != null) {
            result.addAll(annotated);
        }
        return result;
    }

    @Override
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getAxiomsIgnoreAnnotations(axiom);
        }
        Set<OWLAxiom> result = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getAxiomsIgnoreAnnotations(axiom));
        }
        return result;
    }

    @Override
    public boolean containsClassInSignature(IRI owlClassIRI) {
        return this.internals.getOwlClassReferences().containsKey(this.getOWLDataFactory().getOWLClass(owlClassIRI));
    }

    @Override
    public boolean containsClassInSignature(IRI owlClassIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsClassInSignature(owlClassIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI propIRI) {
        return this.internals.getOwlObjectPropertyReferences().containsKey(this.getOWLDataFactory().getOWLObjectProperty(propIRI));
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI propIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsObjectPropertyInSignature(propIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI propIRI) {
        return this.internals.getOwlDataPropertyReferences().containsKey(this.getOWLDataFactory().getOWLDataProperty(propIRI));
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI propIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsDataPropertyInSignature(propIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI propIRI) {
        boolean b = this.internals.getOwlAnnotationPropertyReferences().containsKey(this.getOWLDataFactory().getOWLAnnotationProperty(propIRI));
        if (b) {
            return true;
        }
        for (OWLAnnotation anno : this.internals.getOntologyAnnotations()) {
            if (!anno.getProperty().getIRI().equals(propIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI propIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsAnnotationPropertyInSignature(propIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsIndividualInSignature(IRI individualIRI) {
        return this.internals.getOwlIndividualReferences().containsKey(this.getOWLDataFactory().getOWLNamedIndividual(individualIRI));
    }

    @Override
    public boolean containsIndividualInSignature(IRI individualIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsIndividualInSignature(individualIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDatatypeInSignature(IRI datatypeIRI) {
        return this.internals.getOwlDatatypeReferences().containsKey(this.getOWLDataFactory().getOWLDatatype(datatypeIRI));
    }

    @Override
    public boolean containsDatatypeInSignature(IRI datatypeIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsDatatypeInSignature(datatypeIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLEntity> getEntitiesInSignature(IRI iri) {
        Set<OWLEntity> result = CollectionFactory.createSet(6);
        if (this.containsClassInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLClass(iri));
        }
        if (this.containsObjectPropertyInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLObjectProperty(iri));
        }
        if (this.containsDataPropertyInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLDataProperty(iri));
        }
        if (this.containsIndividualInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLNamedIndividual(iri));
        }
        if (this.containsDatatypeInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLDatatype(iri));
        }
        if (this.containsAnnotationPropertyInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLAnnotationProperty(iri));
        }
        return result;
    }

    @Override
    public Set<OWLEntity> getEntitiesInSignature(IRI iri, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getEntitiesInSignature(iri);
        }
        Set<OWLEntity> result = CollectionFactory.createSet(6);
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getEntitiesInSignature(iri));
        }
        return result;
    }

    public boolean containsReference(OWLClass owlClass) {
        return this.internals.getOwlClassReferences().containsKey(owlClass);
    }

    public boolean containsReference(OWLObjectProperty prop) {
        return this.internals.getOwlObjectPropertyReferences().containsKey(prop);
    }

    public boolean containsReference(OWLDataProperty prop) {
        return this.internals.getOwlDataPropertyReferences().containsKey(prop);
    }

    public boolean containsReference(OWLNamedIndividual ind) {
        return this.internals.getOwlIndividualReferences().containsKey(ind);
    }

    public boolean containsReference(OWLDatatype dt) {
        return this.internals.getOwlDatatypeReferences().containsKey(dt);
    }

    public boolean containsReference(OWLAnnotationProperty property) {
        return this.internals.getOwlAnnotationPropertyReferences().containsKey(property);
    }

    @Override
    public boolean isDeclared(OWLEntity owlEntity) {
        OWLDeclarationAxiom ax = this.getOWLDataFactory().getOWLDeclarationAxiom(owlEntity);
        return this.internals.getAxiomsInternal(AxiomType.DECLARATION).contains(ax);
    }

    @Override
    public boolean isDeclared(OWLEntity owlEntity, boolean includeImportsClosure) {
        if (this.isDeclared(owlEntity)) {
            return true;
        }
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (ont.equals(this) || !ont.isDeclared(owlEntity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        OWLEntityReferenceChecker entityReferenceChecker = new OWLEntityReferenceChecker();
        return entityReferenceChecker.containsReference(owlEntity);
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsEntityInSignature(owlEntity);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsEntityInSignature(owlEntity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntityInSignature(IRI entityIRI) {
        if (this.containsClassInSignature(entityIRI)) {
            return true;
        }
        if (this.containsObjectPropertyInSignature(entityIRI)) {
            return true;
        }
        if (this.containsDataPropertyInSignature(entityIRI)) {
            return true;
        }
        if (this.containsIndividualInSignature(entityIRI)) {
            return true;
        }
        if (this.containsDatatypeInSignature(entityIRI)) {
            return true;
        }
        return this.containsAnnotationPropertyInSignature(entityIRI);
    }

    @Override
    public boolean containsEntityInSignature(IRI entityIRI, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsEntityInSignature(entityIRI);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsEntityInSignature(entityIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity) {
        Set<OWLAxiom> axioms = owlEntity instanceof OWLClass ? this.internals.getAxioms(owlEntity.asOWLClass(), this.internals.getOwlClassReferences(), false) : (owlEntity instanceof OWLObjectProperty ? this.internals.getAxioms(owlEntity.asOWLObjectProperty(), this.internals.getOwlObjectPropertyReferences(), false) : (owlEntity instanceof OWLDataProperty ? this.internals.getAxioms(owlEntity.asOWLDataProperty(), this.internals.getOwlDataPropertyReferences(), false) : (owlEntity instanceof OWLNamedIndividual ? this.internals.getAxioms(owlEntity.asOWLNamedIndividual(), this.internals.getOwlIndividualReferences(), false) : (owlEntity instanceof OWLDatatype ? this.internals.getAxioms(owlEntity.asOWLDatatype(), this.internals.getOwlDatatypeReferences(), false) : (owlEntity instanceof OWLAnnotationProperty ? this.internals.getAxioms(owlEntity.asOWLAnnotationProperty(), this.internals.getOwlAnnotationPropertyReferences(), false) : Collections.emptySet())))));
        return CollectionFactory.createSet(axioms);
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getReferencingAxioms(owlEntity);
        }
        Set<OWLAxiom> result = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getReferencingAxioms(owlEntity));
        }
        return result;
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLAnonymousIndividual individual) {
        return this.internals.getReturnSet(this.internals.getAxioms(individual, this.internals.getOwlAnonymousIndividualReferences(), false));
    }

    @Override
    public Set<OWLClassAxiom> getAxioms(OWLClass cls) {
        return this.internals.getAxioms(cls);
    }

    @Override
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression prop) {
        Set<OWLObjectPropertyAxiom> result = CollectionFactory.createSet(50);
        result.addAll(this.getAsymmetricObjectPropertyAxioms(prop));
        result.addAll(this.getReflexiveObjectPropertyAxioms(prop));
        result.addAll(this.getSymmetricObjectPropertyAxioms(prop));
        result.addAll(this.getIrreflexiveObjectPropertyAxioms(prop));
        result.addAll(this.getTransitiveObjectPropertyAxioms(prop));
        result.addAll(this.getInverseFunctionalObjectPropertyAxioms(prop));
        result.addAll(this.getFunctionalObjectPropertyAxioms(prop));
        result.addAll(this.getInverseObjectPropertyAxioms(prop));
        result.addAll(this.getObjectPropertyDomainAxioms(prop));
        result.addAll(this.getEquivalentObjectPropertiesAxioms(prop));
        result.addAll(this.getDisjointObjectPropertiesAxioms(prop));
        result.addAll(this.getObjectPropertyRangeAxioms(prop));
        result.addAll(this.getObjectSubPropertyAxiomsForSubProperty(prop));
        return result;
    }

    @Override
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty prop) {
        Set<OWLAnnotationAxiom> result = CollectionFactory.createSet();
        for (OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom : this.getAxioms(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            if (!oWLSubAnnotationPropertyOfAxiom.getSubProperty().equals(prop)) continue;
            result.add(oWLSubAnnotationPropertyOfAxiom);
        }
        for (OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom : this.getAxioms(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            if (!oWLAnnotationPropertyRangeAxiom.getProperty().equals(prop)) continue;
            result.add(oWLAnnotationPropertyRangeAxiom);
        }
        for (OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom : this.getAxioms(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            if (!oWLAnnotationPropertyDomainAxiom.getProperty().equals(prop)) continue;
            result.add(oWLAnnotationPropertyDomainAxiom);
        }
        return result;
    }

    @Override
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty prop) {
        Set<OWLDataPropertyAxiom> result = CollectionFactory.createSet();
        result.addAll(this.getDataPropertyDomainAxioms(prop));
        result.addAll(this.getEquivalentDataPropertiesAxioms(prop));
        result.addAll(this.getDisjointDataPropertiesAxioms(prop));
        result.addAll(this.getDataPropertyRangeAxioms(prop));
        result.addAll(this.getFunctionalDataPropertyAxioms(prop));
        result.addAll(this.getDataSubPropertyAxiomsForSubProperty(prop));
        return result;
    }

    @Override
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual) {
        Set<OWLIndividualAxiom> result = CollectionFactory.createSet();
        result.addAll(this.getClassAssertionAxioms(individual));
        result.addAll(this.getObjectPropertyAssertionAxioms(individual));
        result.addAll(this.getDataPropertyAssertionAxioms(individual));
        result.addAll(this.getNegativeObjectPropertyAssertionAxioms(individual));
        result.addAll(this.getNegativeDataPropertyAssertionAxioms(individual));
        result.addAll(this.getSameIndividualAxioms(individual));
        result.addAll(this.getDifferentIndividualAxioms(individual));
        return result;
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype) {
        return this.getDatatypeDefinitions(datatype);
    }

    public Set<OWLNamedObject> getReferencedObjects() {
        Set<OWLNamedObject> result = CollectionFactory.createSet();
        result.addAll(this.internals.getOwlClassReferences().keySet());
        for (OWLObjectProperty prop : this.internals.getOwlObjectPropertyReferences().keySet()) {
            if (prop.isAnonymous()) continue;
            result.add(prop);
        }
        result.addAll(this.internals.getOwlDataPropertyReferences().keySet());
        result.addAll(this.internals.getOwlIndividualReferences().keySet());
        return result;
    }

    @Override
    public Set<OWLEntity> getSignature() {
        Set<OWLEntity> entities = CollectionFactory.createSet();
        entities.addAll(this.getClassesInSignature());
        entities.addAll(this.getObjectPropertiesInSignature());
        entities.addAll(this.getDataPropertiesInSignature());
        entities.addAll(this.getIndividualsInSignature());
        entities.addAll(this.getDatatypesInSignature());
        entities.addAll(this.getAnnotationPropertiesInSignature());
        return entities;
    }

    @Override
    public Set<OWLEntity> getSignature(boolean includeImportsClosure) {
        Set<OWLEntity> entities = this.getSignature();
        if (includeImportsClosure) {
            for (OWLOntology ont : this.getImportsClosure()) {
                if (ont.equals(this)) continue;
                entities.addAll(ont.getSignature());
            }
        }
        return entities;
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        return this.internals.getReturnSet(this.internals.getOwlClassReferences().keySet());
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return this.internals.getReturnSet(this.internals.getOwlDataPropertyReferences().keySet());
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return this.internals.getReturnSet(this.internals.getOwlObjectPropertyReferences().keySet());
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return this.internals.getReturnSet(this.internals.getOwlIndividualReferences().keySet());
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature() {
        return this.internals.getReturnSet(this.internals.getOwlDatatypeReferences().keySet());
    }

    @Override
    public Set<OWLClass> getClassesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getClassesInSignature();
        }
        Set<OWLClass> results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getClassesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getObjectPropertiesInSignature();
        }
        Set<OWLObjectProperty> results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getObjectPropertiesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getDataPropertiesInSignature();
        }
        Set<OWLDataProperty> results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getDataPropertiesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getIndividualsInSignature();
        }
        Set<OWLNamedIndividual> results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getIndividualsInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals() {
        return this.internals.getReturnSet(this.internals.getOwlAnonymousIndividualReferences().keySet());
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getDatatypesInSignature();
        }
        Set<OWLDatatype> results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getDatatypesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        Set<OWLAnnotationProperty> props = CollectionFactory.createSet(this.internals.getOwlAnnotationPropertyReferences().keySet());
        for (OWLAnnotation anno : this.internals.getOntologyAnnotations()) {
            props.add(anno.getProperty());
        }
        return this.internals.getReturnSet(props);
    }

    public Set<OWLAnnotationProperty> getReferencedAnnotationProperties(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getAnnotationPropertiesInSignature();
        }
        Set<OWLAnnotationProperty> results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getAnnotationPropertiesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return this.internals.getReturnSet(this.internals.getImportsDeclarations());
    }

    @Override
    public Set<IRI> getDirectImportsDocuments() throws UnknownOWLOntologyException {
        Set<IRI> result = CollectionFactory.createSet();
        for (OWLImportsDeclaration importsDeclaration : this.internals.getImportsDeclarations()) {
            result.add(importsDeclaration.getIRI());
        }
        return result;
    }

    @Override
    public Set<OWLOntology> getImports() throws UnknownOWLOntologyException {
        return this.manager.getImports(this);
    }

    @Override
    public Set<OWLOntology> getDirectImports() throws UnknownOWLOntologyException {
        return this.manager.getDirectImports(this);
    }

    @Override
    public Set<OWLOntology> getImportsClosure() throws UnknownOWLOntologyException {
        return this.getOWLOntologyManager().getImportsClosure(this);
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(OWLDatatype datatype) {
        Set<OWLDatatypeDefinitionAxiom> result = CollectionFactory.createSet();
        Set<OWLDatatypeDefinitionAxiom> axioms = this.internals.getAxiomsInternal(AxiomType.DATATYPE_DEFINITION);
        for (OWLDatatypeDefinitionAxiom ax : axioms) {
            if (!ax.getDatatype().equals(datatype)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(OWLClass cls) {
        return this.internals.getSubClassAxiomsForSubClass(cls);
    }

    @Override
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(OWLClass cls) {
        return this.internals.getSubClassAxiomsForSuperClass(cls);
    }

    @Override
    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLClass cls) {
        return this.internals.getEquivalentClassesAxioms(cls);
    }

    @Override
    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLClass cls) {
        return this.internals.getDisjointClassesAxioms(cls);
    }

    @Override
    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLClass owlClass) {
        return this.internals.getDisjointUnionAxioms(owlClass);
    }

    @Override
    public Set<OWLHasKeyAxiom> getHasKeyAxioms(OWLClass cls) {
        return this.internals.getHasKeyAxioms(cls);
    }

    @Override
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression property) {
        return this.internals.getObjectSubPropertyAxiomsForSubProperty(property);
    }

    @Override
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression property) {
        return this.internals.getObjectSubPropertyAxiomsForSuperProperty(property);
    }

    @Override
    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getObjectPropertyDomainAxioms(property);
    }

    @Override
    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getObjectPropertyRangeAxioms(property);
    }

    @Override
    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getInverseObjectPropertyAxioms(property);
    }

    @Override
    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getEquivalentObjectPropertiesAxioms(property);
    }

    @Override
    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getDisjointObjectPropertiesAxioms(property);
    }

    @Override
    public Set<OWLFunctionalObjectPropertyAxiom> getFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getFunctionalObjectPropertyAxioms(property);
    }

    @Override
    public Set<OWLInverseFunctionalObjectPropertyAxiom> getInverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getInverseFunctionalObjectPropertyAxioms(property);
    }

    @Override
    public Set<OWLSymmetricObjectPropertyAxiom> getSymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getSymmetricObjectPropertyAxioms(property);
    }

    @Override
    public Set<OWLAsymmetricObjectPropertyAxiom> getAsymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getAsymmetricObjectPropertyAxioms(property);
    }

    @Override
    public Set<OWLReflexiveObjectPropertyAxiom> getReflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getReflexiveObjectPropertyAxioms(property);
    }

    @Override
    public Set<OWLIrreflexiveObjectPropertyAxiom> getIrreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getIrreflexiveObjectPropertyAxioms(property);
    }

    @Override
    public Set<OWLTransitiveObjectPropertyAxiom> getTransitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getTransitiveObjectPropertyAxioms(property);
    }

    @Override
    public Set<OWLFunctionalDataPropertyAxiom> getFunctionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        return this.internals.getFunctionalDataPropertyAxioms(property);
    }

    @Override
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSubProperty(OWLDataProperty lhsProperty) {
        return this.internals.getDataSubPropertyAxiomsForSubProperty(lhsProperty);
    }

    @Override
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression property) {
        return this.internals.getDataSubPropertyAxiomsForSuperProperty(property);
    }

    @Override
    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(OWLDataProperty property) {
        return this.internals.getDataPropertyDomainAxioms(property);
    }

    @Override
    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxioms(OWLDataProperty property) {
        return this.internals.getDataPropertyRangeAxioms(property);
    }

    @Override
    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxioms(OWLDataProperty property) {
        return this.internals.getEquivalentDataPropertiesAxioms(property);
    }

    @Override
    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxioms(OWLDataProperty property) {
        return this.internals.getDisjointDataPropertiesAxioms(property);
    }

    @Override
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLIndividual individual) {
        return this.internals.getClassAssertionAxioms(individual);
    }

    @Override
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLClass type) {
        return this.internals.getClassAssertionAxioms(type);
    }

    @Override
    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.internals.getDataPropertyAssertionAxioms(individual);
    }

    @Override
    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.internals.getObjectPropertyAssertionAxioms(individual);
    }

    @Override
    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.internals.getNegativeObjectPropertyAssertionAxioms(individual);
    }

    @Override
    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.internals.getNegativeDataPropertyAssertionAxioms(individual);
    }

    @Override
    public Set<OWLSameIndividualAxiom> getSameIndividualAxioms(OWLIndividual individual) {
        return this.internals.getSameIndividualAxioms(individual);
    }

    @Override
    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(OWLIndividual individual) {
        return this.internals.getDifferentIndividualAxioms(individual);
    }

    @Override
    public List<OWLOntologyChange> applyChange(OWLOntologyChange change) {
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>(2);
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        change.accept(changeFilter);
        List<OWLOntologyChange> applied = changeFilter.getAppliedChanges();
        if (applied.size() == 1) {
            appliedChanges.add(change);
        } else {
            appliedChanges.addAll(applied);
        }
        return appliedChanges;
    }

    @Override
    public List<OWLOntologyChange> applyChanges(List<OWLOntologyChange> changes) {
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        for (OWLOntologyChange change : changes) {
            change.accept(changeFilter);
            appliedChanges.addAll(changeFilter.getAppliedChanges());
            changeFilter.reset();
        }
        return appliedChanges;
    }

    private void handleAxiomAdded(OWLAxiom axiom) {
        OWLEntityCollector entityCollector = new OWLEntityCollector();
        OWLNamedObjectReferenceAdder referenceAdder = new OWLNamedObjectReferenceAdder();
        axiom.accept(entityCollector);
        for (OWLEntity object : entityCollector.getObjects()) {
            referenceAdder.setAxiom(axiom);
            object.accept(referenceAdder);
        }
        for (OWLAnonymousIndividual ind : entityCollector.getAnonymousIndividuals()) {
            this.internals.addToIndexedSet(ind, this.internals.getOwlAnonymousIndividualReferences(), axiom);
        }
        if (axiom.isAnnotated()) {
            this.internals.addToIndexedSet(axiom.getAxiomWithoutAnnotations(), this.internals.getLogicalAxiom2AnnotatedAxiomMap(), axiom);
        }
    }

    private void handleAxiomRemoved(OWLAxiom axiom) {
        OWLEntityCollector entityCollector = new OWLEntityCollector();
        OWLNamedObjectReferenceRemover referenceRemover = new OWLNamedObjectReferenceRemover();
        axiom.accept(entityCollector);
        for (OWLEntity object : entityCollector.getObjects()) {
            referenceRemover.setAxiom(axiom);
            object.accept(referenceRemover);
        }
        for (OWLAnonymousIndividual ind : entityCollector.getAnonymousIndividuals()) {
            this.internals.removeAxiomFromSet(ind, this.internals.getOwlAnonymousIndividualReferences(), axiom, true);
        }
        if (axiom.isAnnotated()) {
            this.internals.removeAxiomFromSet(axiom.getAxiomWithoutAnnotations(), this.internals.getLogicalAxiom2AnnotatedAxiomMap(), axiom, true);
        }
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLOntology)) {
            return false;
        }
        OWLOntology other = (OWLOntology)obj;
        return this.ontologyID.equals(other.getOntologyID());
    }

    private class OWLEntityReferenceChecker
    implements OWLEntityVisitor {
        private boolean ref;

        private OWLEntityReferenceChecker() {
        }

        public boolean containsReference(OWLEntity entity) {
            this.ref = false;
            entity.accept(this);
            return this.ref;
        }

        public void visit(OWLClass cls) {
            this.ref = OWLOntologyImpl.this.containsReference(cls);
        }

        public void visit(OWLDatatype datatype) {
            this.ref = OWLOntologyImpl.this.containsReference(datatype);
        }

        public void visit(OWLNamedIndividual individual) {
            this.ref = OWLOntologyImpl.this.containsReference(individual);
        }

        public void visit(OWLDataProperty property) {
            this.ref = OWLOntologyImpl.this.containsReference(property);
        }

        public void visit(OWLObjectProperty property) {
            this.ref = OWLOntologyImpl.this.containsReference(property);
        }

        public void visit(OWLAnnotationProperty property) {
            this.ref = OWLOntologyImpl.this.containsReference(property);
        }
    }

    private class ChangeAxiomVisitor
    implements OWLAxiomVisitor {
        private boolean addAxiom = false;

        private ChangeAxiomVisitor() {
        }

        public void setAddAxiom(boolean addAxiom) {
            this.addAxiom = addAxiom;
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.SUBCLASS_OF, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                if (!axiom.getSubClass().isAnonymous()) {
                    OWLClass subClass = (OWLClass)axiom.getSubClass();
                    OWLOntologyImpl.this.internals.addToIndexedSet(subClass, OWLOntologyImpl.this.internals.getSubClassAxiomsByLHS(), axiom);
                    OWLOntologyImpl.this.internals.addToIndexedSet(subClass, OWLOntologyImpl.this.internals.getClassAxiomsByClass(), axiom);
                } else {
                    OWLOntologyImpl.this.internals.getGeneralClassAxioms().add(axiom);
                }
                if (!axiom.getSuperClass().isAnonymous()) {
                    OWLOntologyImpl.this.internals.addToIndexedSet((OWLClass)axiom.getSuperClass(), OWLOntologyImpl.this.internals.getSubClassAxiomsByRHS(), axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.SUBCLASS_OF, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                if (!axiom.getSubClass().isAnonymous()) {
                    OWLClass subClass = (OWLClass)axiom.getSubClass();
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(subClass, OWLOntologyImpl.this.internals.getSubClassAxiomsByLHS(), axiom, true);
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(subClass, OWLOntologyImpl.this.internals.getClassAxiomsByClass(), axiom, true);
                } else {
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom, OWLOntologyImpl.this.internals.getGeneralClassAxioms());
                }
                if (!axiom.getSuperClass().isAnonymous()) {
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getSuperClass().asOWLClass(), OWLOntologyImpl.this.internals.getSubClassAxiomsByRHS(), axiom, true);
                }
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.internals.getNegativeObjectPropertyAssertionAxiomsByIndividual(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.internals.getNegativeObjectPropertyAssertionAxiomsByIndividual(), axiom, true);
            }
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getAsymmetricPropertyAxiomsByProperty(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getAsymmetricPropertyAxiomsByProperty(), axiom, true);
            }
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getReflexivePropertyAxiomsByProperty(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.REFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.REFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getReflexivePropertyAxiomsByProperty(), axiom, true);
            }
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.DISJOINT_CLASSES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                boolean allAnon = true;
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    OWLClass cls = (OWLClass)desc;
                    OWLOntologyImpl.this.internals.addToIndexedSet(cls, OWLOntologyImpl.this.internals.getDisjointClassesAxiomsByClass(), axiom);
                    OWLOntologyImpl.this.internals.addToIndexedSet(cls, OWLOntologyImpl.this.internals.getClassAxiomsByClass(), axiom);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.internals.getGeneralClassAxioms().add(axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.DISJOINT_CLASSES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                boolean allAnon = true;
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    OWLClass cls = (OWLClass)desc;
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(cls, OWLOntologyImpl.this.internals.getDisjointClassesAxiomsByClass(), axiom, true);
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(cls, OWLOntologyImpl.this.internals.getClassAxiomsByClass(), axiom, true);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.internals.getGeneralClassAxioms().remove(axiom);
                }
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.DATA_PROPERTY_DOMAIN, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getDataPropertyDomainAxiomsByProperty(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.DATA_PROPERTY_DOMAIN, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getDataPropertyDomainAxiomsByProperty(), axiom, true);
            }
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.OBJECT_PROPERTY_DOMAIN, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                if (axiom.getProperty() instanceof OWLObjectProperty) {
                    OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getObjectPropertyDomainAxiomsByProperty(), axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.OBJECT_PROPERTY_DOMAIN, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                if (axiom.getProperty() instanceof OWLObjectProperty) {
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getObjectPropertyDomainAxiomsByProperty(), axiom, true);
                }
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.this.internals.addToIndexedSet(prop, OWLOntologyImpl.this.internals.getEquivalentObjectPropertyAxiomsByProperty(), axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(prop, OWLOntologyImpl.this.internals.getEquivalentObjectPropertyAxiomsByProperty(), axiom, true);
                }
            }
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.INVERSE_OBJECT_PROPERTIES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getFirstProperty(), OWLOntologyImpl.this.internals.getInversePropertyAxiomsByProperty(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getSecondProperty(), OWLOntologyImpl.this.internals.getInversePropertyAxiomsByProperty(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.INVERSE_OBJECT_PROPERTIES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getFirstProperty(), OWLOntologyImpl.this.internals.getInversePropertyAxiomsByProperty(), axiom, false);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getSecondProperty(), OWLOntologyImpl.this.internals.getInversePropertyAxiomsByProperty(), axiom, false);
            }
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.internals.getNegativeDataPropertyAssertionAxiomsByIndividual(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.internals.getNegativeDataPropertyAssertionAxiomsByIndividual(), axiom, true);
            }
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            if (this.addAxiom) {
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.this.internals.addToIndexedSet(ind, OWLOntologyImpl.this.internals.getDifferentIndividualsAxiomsByIndividual(), axiom);
                    OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.DIFFERENT_INDIVIDUALS, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.DIFFERENT_INDIVIDUALS, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(ind, OWLOntologyImpl.this.internals.getDifferentIndividualsAxiomsByIndividual(), axiom, true);
                }
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.DISJOINT_DATA_PROPERTIES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.this.internals.addToIndexedSet(prop, OWLOntologyImpl.this.internals.getDisjointDataPropertyAxiomsByProperty(), axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.DISJOINT_DATA_PROPERTIES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(prop, OWLOntologyImpl.this.internals.getDisjointDataPropertyAxiomsByProperty(), axiom, true);
                }
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.DISJOINT_OBJECT_PROPERTIES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.this.internals.addToIndexedSet(prop, OWLOntologyImpl.this.internals.getDisjointObjectPropertyAxiomsByProperty(), axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.DISJOINT_OBJECT_PROPERTIES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(prop, OWLOntologyImpl.this.internals.getDisjointObjectPropertyAxiomsByProperty(), axiom, true);
                }
            }
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.OBJECT_PROPERTY_RANGE, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getObjectPropertyRangeAxiomsByProperty(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.OBJECT_PROPERTY_RANGE, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getObjectPropertyRangeAxiomsByProperty(), axiom, true);
            }
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.internals.getObjectPropertyAssertionsByIndividual(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.internals.getObjectPropertyAssertionsByIndividual(), axiom, true);
            }
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getFunctionalObjectPropertyAxiomsByProperty(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getFunctionalObjectPropertyAxiomsByProperty(), axiom, true);
            }
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.SUB_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getSubProperty(), OWLOntologyImpl.this.internals.getObjectSubPropertyAxiomsByLHS(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getSuperProperty(), OWLOntologyImpl.this.internals.getObjectSubPropertyAxiomsByRHS(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.SUB_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getSubProperty(), OWLOntologyImpl.this.internals.getObjectSubPropertyAxiomsByLHS(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getSuperProperty(), OWLOntologyImpl.this.internals.getObjectSubPropertyAxiomsByRHS(), axiom, true);
            }
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.DISJOINT_UNION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getOWLClass(), OWLOntologyImpl.this.internals.getDisjointUnionAxiomsByClass(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getOWLClass(), OWLOntologyImpl.this.internals.getClassAxiomsByClass(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.DISJOINT_UNION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getOWLClass(), OWLOntologyImpl.this.internals.getDisjointUnionAxiomsByClass(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getOWLClass(), OWLOntologyImpl.this.internals.getClassAxiomsByClass(), axiom, true);
            }
        }

        public void visit(OWLDeclarationAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.DECLARATION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getEntity(), OWLOntologyImpl.this.internals.getDeclarationsByEntity(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.DECLARATION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getEntity(), OWLOntologyImpl.this.internals.getDeclarationsByEntity(), axiom, true);
            }
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.ANNOTATION_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.internals.getAnnotationAssertionAxiomsBySubject(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.ANNOTATION_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.internals.getAnnotationAssertionAxiomsBySubject(), axiom, true);
            }
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.ANNOTATION_PROPERTY_DOMAIN, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.ANNOTATION_PROPERTY_DOMAIN, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
            }
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.ANNOTATION_PROPERTY_RANGE, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.ANNOTATION_PROPERTY_RANGE, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
            }
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.SUB_ANNOTATION_PROPERTY_OF, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.SUB_ANNOTATION_PROPERTY_OF, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
            }
        }

        public void visit(OWLHasKeyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.HAS_KEY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                if (!axiom.getClassExpression().isAnonymous()) {
                    OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getClassExpression().asOWLClass(), OWLOntologyImpl.this.internals.getHasKeyAxiomsByClass(), axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.HAS_KEY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                if (!axiom.getClassExpression().isAnonymous()) {
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getClassExpression().asOWLClass(), OWLOntologyImpl.this.internals.getHasKeyAxiomsByClass(), axiom, true);
                }
            }
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.SYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getSymmetricPropertyAxiomsByProperty(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.SYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getSymmetricPropertyAxiomsByProperty(), axiom, true);
            }
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.DATA_PROPERTY_RANGE, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getDataPropertyRangeAxiomsByProperty(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.DATA_PROPERTY_RANGE, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getDataPropertyRangeAxiomsByProperty(), axiom, true);
            }
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.FUNCTIONAL_DATA_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getFunctionalDataPropertyAxiomsByProperty(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.FUNCTIONAL_DATA_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getFunctionalDataPropertyAxiomsByProperty(), axiom, true);
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.EQUIVALENT_DATA_PROPERTIES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.this.internals.addToIndexedSet(prop, OWLOntologyImpl.this.internals.getEquivalentDataPropertyAxiomsByProperty(), axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.EQUIVALENT_DATA_PROPERTIES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(prop, OWLOntologyImpl.this.internals.getEquivalentDataPropertyAxiomsByProperty(), axiom, true);
                }
            }
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getIndividual(), OWLOntologyImpl.this.internals.getClassAssertionAxiomsByIndividual(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.CLASS_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                if (!axiom.getClassExpression().isAnonymous()) {
                    OWLOntologyImpl.this.internals.addToIndexedSet((OWLClass)axiom.getClassExpression(), OWLOntologyImpl.this.internals.getClassAssertionAxiomsByClass(), axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.CLASS_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getIndividual(), OWLOntologyImpl.this.internals.getClassAssertionAxiomsByIndividual(), axiom, true);
                if (!axiom.getClassExpression().isAnonymous()) {
                    OWLOntologyImpl.this.internals.removeAxiomFromSet((OWLClass)axiom.getClassExpression(), OWLOntologyImpl.this.internals.getClassAssertionAxiomsByClass(), axiom, true);
                }
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.EQUIVALENT_CLASSES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                boolean allAnon = true;
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.this.internals.addToIndexedSet((OWLClass)desc, OWLOntologyImpl.this.internals.getEquivalentClassesAxiomsByClass(), axiom);
                    OWLOntologyImpl.this.internals.addToIndexedSet((OWLClass)desc, OWLOntologyImpl.this.internals.getClassAxiomsByClass(), axiom);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.internals.getGeneralClassAxioms().add(axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.EQUIVALENT_CLASSES, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                boolean allAnon = true;
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.this.internals.removeAxiomFromSet((OWLClass)desc, OWLOntologyImpl.this.internals.getEquivalentClassesAxiomsByClass(), axiom, true);
                    OWLOntologyImpl.this.internals.removeAxiomFromSet((OWLClass)desc, OWLOntologyImpl.this.internals.getClassAxiomsByClass(), axiom, true);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.internals.getGeneralClassAxioms().remove(axiom);
                }
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.internals.getDataPropertyAssertionsByIndividual(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.internals.getDataPropertyAssertionsByIndividual(), axiom, true);
            }
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.TRANSITIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getTransitivePropertyAxiomsByProperty(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.TRANSITIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getTransitivePropertyAxiomsByProperty(), axiom, true);
            }
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getIrreflexivePropertyAxiomsByProperty(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getIrreflexivePropertyAxiomsByProperty(), axiom, true);
            }
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.SUB_DATA_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getSubProperty(), OWLOntologyImpl.this.internals.getDataSubPropertyAxiomsByLHS(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getSuperProperty(), OWLOntologyImpl.this.internals.getDataSubPropertyAxiomsByRHS(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.SUB_DATA_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getSubProperty(), OWLOntologyImpl.this.internals.getDataSubPropertyAxiomsByLHS(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getSuperProperty(), OWLOntologyImpl.this.internals.getDataSubPropertyAxiomsByRHS(), axiom, true);
            }
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getInverseFunctionalPropertyAxiomsByProperty(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.internals.getInverseFunctionalPropertyAxiomsByProperty(), axiom, true);
            }
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.SAME_INDIVIDUAL, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.this.internals.addToIndexedSet(ind, OWLOntologyImpl.this.internals.getSameIndividualsAxiomsByIndividual(), axiom);
                }
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.SAME_INDIVIDUAL, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.this.internals.removeAxiomFromSet(ind, OWLOntologyImpl.this.internals.getSameIndividualsAxiomsByIndividual(), axiom, true);
                }
            }
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.SUB_PROPERTY_CHAIN_OF, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
                OWLOntologyImpl.this.internals.addAxiomToSet(axiom, OWLOntologyImpl.this.internals.getPropertyChainSubPropertyAxioms());
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.SUB_PROPERTY_CHAIN_OF, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
                OWLOntologyImpl.this.internals.removeAxiomFromSet(axiom, OWLOntologyImpl.this.internals.getPropertyChainSubPropertyAxioms());
            }
        }

        public void visit(SWRLRule rule) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.SWRL_RULE, OWLOntologyImpl.this.internals.getAxiomsByType(), rule);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.SWRL_RULE, OWLOntologyImpl.this.internals.getAxiomsByType(), rule, true);
            }
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.this.internals.addToIndexedSet(AxiomType.DATATYPE_DEFINITION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom);
            } else {
                OWLOntologyImpl.this.internals.removeAxiomFromSet(AxiomType.DATATYPE_DEFINITION, OWLOntologyImpl.this.internals.getAxiomsByType(), axiom, true);
            }
        }
    }

    private class OWLNamedObjectReferenceRemover
    implements OWLEntityVisitor {
        private OWLAxiom axiom;

        private OWLNamedObjectReferenceRemover() {
        }

        public void setAxiom(OWLAxiom axiom) {
            this.axiom = axiom;
        }

        public void visit(OWLClass owlClass) {
            OWLOntologyImpl.this.internals.removeAxiomFromSet(owlClass, OWLOntologyImpl.this.internals.getOwlClassReferences(), this.axiom, true);
        }

        public void visit(OWLObjectProperty property) {
            OWLOntologyImpl.this.internals.removeAxiomFromSet(property, OWLOntologyImpl.this.internals.getOwlObjectPropertyReferences(), this.axiom, true);
        }

        public void visit(OWLDataProperty property) {
            OWLOntologyImpl.this.internals.removeAxiomFromSet(property, OWLOntologyImpl.this.internals.getOwlDataPropertyReferences(), this.axiom, true);
        }

        public void visit(OWLNamedIndividual owlIndividual) {
            OWLOntologyImpl.this.internals.removeAxiomFromSet(owlIndividual, OWLOntologyImpl.this.internals.getOwlIndividualReferences(), this.axiom, true);
        }

        public void visit(OWLAnnotationProperty property) {
            OWLOntologyImpl.this.internals.removeAxiomFromSet(property, OWLOntologyImpl.this.internals.getOwlAnnotationPropertyReferences(), this.axiom, true);
        }

        public void visit(OWLDatatype datatype) {
            OWLOntologyImpl.this.internals.removeAxiomFromSet(datatype, OWLOntologyImpl.this.internals.getOwlDatatypeReferences(), this.axiom, true);
        }
    }

    private class OWLNamedObjectReferenceAdder
    implements OWLEntityVisitor {
        private OWLAxiom axiom;

        private OWLNamedObjectReferenceAdder() {
        }

        public void setAxiom(OWLAxiom axiom) {
            this.axiom = axiom;
        }

        public void visit(OWLClass owlClass) {
            OWLOntologyImpl.this.internals.addToIndexedSet(owlClass, OWLOntologyImpl.this.internals.getOwlClassReferences(), this.axiom);
        }

        public void visit(OWLObjectProperty property) {
            OWLOntologyImpl.this.internals.addToIndexedSet(property, OWLOntologyImpl.this.internals.getOwlObjectPropertyReferences(), this.axiom);
        }

        public void visit(OWLDataProperty property) {
            OWLOntologyImpl.this.internals.addToIndexedSet(property, OWLOntologyImpl.this.internals.getOwlDataPropertyReferences(), this.axiom);
        }

        public void visit(OWLNamedIndividual owlIndividual) {
            OWLOntologyImpl.this.internals.addToIndexedSet(owlIndividual, OWLOntologyImpl.this.internals.getOwlIndividualReferences(), this.axiom);
        }

        public void visit(OWLAnnotationProperty property) {
            OWLOntologyImpl.this.internals.addToIndexedSet(property, OWLOntologyImpl.this.internals.getOwlAnnotationPropertyReferences(), this.axiom);
        }

        public void visit(OWLDatatype datatype) {
            OWLOntologyImpl.this.internals.addToIndexedSet(datatype, OWLOntologyImpl.this.internals.getOwlDatatypeReferences(), this.axiom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OWLOntologyChangeFilter
    implements OWLOntologyChangeVisitor {
        private List<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();

        public List<OWLOntologyChange> getAppliedChanges() {
            return this.appliedChanges;
        }

        public void reset() {
            this.appliedChanges.clear();
        }

        @Override
        public void visit(RemoveAxiom change) {
            OWLAxiom axiom = change.getAxiom();
            if (OWLOntologyImpl.this.containsAxiom(axiom)) {
                ChangeAxiomVisitor changeVisitor = new ChangeAxiomVisitor();
                changeVisitor.setAddAxiom(false);
                axiom.accept(changeVisitor);
                this.appliedChanges.add(change);
                OWLOntologyImpl.this.handleAxiomRemoved(axiom);
            }
        }

        @Override
        public void visit(SetOntologyID change) {
            OWLOntologyID id = change.getNewOntologyID();
            if (!id.equals(OWLOntologyImpl.this.ontologyID)) {
                this.appliedChanges.add(change);
                OWLOntologyImpl.this.ontologyID = id;
            }
        }

        @Override
        public void visit(AddAxiom change) {
            OWLAxiom axiom = change.getAxiom();
            if (!OWLOntologyImpl.this.containsAxiom(axiom)) {
                ChangeAxiomVisitor changeVisitor = new ChangeAxiomVisitor();
                changeVisitor.setAddAxiom(true);
                axiom.accept(changeVisitor);
                this.appliedChanges.add(change);
                OWLOntologyImpl.this.handleAxiomAdded(axiom);
            }
        }

        @Override
        public void visit(AddImport change) {
            if (!OWLOntologyImpl.this.internals.getImportsDeclarations().contains(change.getImportDeclaration())) {
                this.appliedChanges.add(change);
                OWLOntologyImpl.this.internals.getImportsDeclarations().add(change.getImportDeclaration());
            }
        }

        @Override
        public void visit(RemoveImport change) {
            if (OWLOntologyImpl.this.internals.getImportsDeclarations().contains(change.getImportDeclaration())) {
                this.appliedChanges.add(change);
                OWLOntologyImpl.this.internals.getImportsDeclarations().remove(change.getImportDeclaration());
            }
        }

        @Override
        public void visit(AddOntologyAnnotation change) {
            if (OWLOntologyImpl.this.internals.getOntologyAnnotations().add(change.getAnnotation())) {
                this.appliedChanges.add(change);
            }
        }

        @Override
        public void visit(RemoveOntologyAnnotation change) {
            if (OWLOntologyImpl.this.internals.getOntologyAnnotations().remove(change.getAnnotation())) {
                this.appliedChanges.add(change);
            }
        }
    }
}

