/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntax;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLAxiomFilter;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxObjectRenderer;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxPrefixNameShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RendererEvent;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RendererListener;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RenderingDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterOWLSyntaxFrameRenderer
extends ManchesterOWLSyntaxObjectRenderer
implements OWLEntityVisitor {
    private OWLOntology defaultOntology;
    private Set<OWLOntology> ontologies;
    private OntologyIRIShortFormProvider shortFormProvider = new OntologyIRIShortFormProvider();
    private Set<AxiomType> filteredAxiomTypes = new HashSet<AxiomType>();
    private boolean renderExtensions = false;
    private List<RendererListener> listeners = new ArrayList<RendererListener>();
    private OWLAxiomFilter axiomFilter = new OWLAxiomFilter(){

        public boolean passes(OWLAxiom axiom) {
            return true;
        }
    };
    private RenderingDirector renderingDirector = new DefaultRenderingDirector();
    private RendererEvent event;

    public ManchesterOWLSyntaxFrameRenderer(OWLOntologyManager owlOntologyManager, OWLOntology ontology, Writer writer, ShortFormProvider entityShortFormProvider) {
        this(owlOntologyManager, Collections.singleton(ontology), ontology, writer, entityShortFormProvider);
    }

    public ManchesterOWLSyntaxFrameRenderer(OWLOntologyManager owlOntologyManager, Set<OWLOntology> ontologies, OWLOntology defaultOntology, Writer writer, ShortFormProvider entityShortFormProvider) {
        super(writer, entityShortFormProvider);
        this.ontologies = new LinkedHashSet<OWLOntology>(ontologies);
        this.defaultOntology = defaultOntology;
    }

    public void setRenderingDirector(RenderingDirector renderingDirector) {
        this.renderingDirector = renderingDirector;
    }

    public void addRendererListener(RendererListener listener) {
        this.listeners.add(listener);
    }

    public void removeRendererListener(RendererListener listener) {
        this.listeners.remove(listener);
    }

    public void setAxiomFilter(OWLAxiomFilter axiomFilter) {
        this.axiomFilter = axiomFilter;
    }

    public void clearFilteredAxiomTypes() {
        this.filteredAxiomTypes.clear();
    }

    public void addFilteredAxiomType(AxiomType axiomType) {
        this.filteredAxiomTypes.add(axiomType);
    }

    public void setRenderExtensions(boolean renderExtensions) {
        this.renderExtensions = renderExtensions;
    }

    public Set<OWLOntology> getOntologies() {
        return this.ontologies;
    }

    public void writeOntology() throws OWLRendererException {
        HashMap<Set<OWLObject>, Set<OWLAnnotation>> map;
        if (this.ontologies.size() != 1) {
            throw new RuntimeException("Can only render one ontology");
        }
        OWLOntology ontology = this.getOntologies().iterator().next();
        this.writePrefixMap();
        this.writeNewLine();
        this.writeOntologyHeader(ontology);
        for (OWLAnnotationProperty oWLAnnotationProperty : ontology.getAnnotationPropertiesInSignature()) {
            this.write(oWLAnnotationProperty);
        }
        for (OWLDatatype oWLDatatype : ontology.getDatatypesInSignature()) {
            this.write(oWLDatatype);
        }
        for (OWLObjectProperty oWLObjectProperty : ontology.getObjectPropertiesInSignature()) {
            this.write(oWLObjectProperty);
            OWLObjectPropertyExpression invProp = oWLObjectProperty.getInverseProperty();
            if (ontology.getAxioms(invProp).isEmpty()) continue;
            this.write(invProp);
        }
        for (OWLDataProperty oWLDataProperty : ontology.getDataPropertiesInSignature()) {
            this.write(oWLDataProperty);
        }
        for (OWLClass oWLClass : ontology.getClassesInSignature()) {
            this.write(oWLClass);
        }
        for (OWLNamedIndividual oWLNamedIndividual : ontology.getIndividualsInSignature()) {
            this.write(oWLNamedIndividual);
        }
        for (OWLAnonymousIndividual oWLAnonymousIndividual : ontology.getReferencedAnonymousIndividuals()) {
            this.write(oWLAnonymousIndividual);
        }
        this.event = new RendererEvent(this, ontology);
        for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : ontology.getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (oWLDisjointClassesAxiom.getClassExpressions().size() <= 2) continue;
            map = new HashMap<Set<OWLObject>, Set<OWLAnnotation>>();
            map.put(oWLDisjointClassesAxiom.getClassExpressions(), oWLDisjointClassesAxiom.getAnnotations());
            this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, map, ",", false, ontology);
        }
        for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : ontology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
            if (oWLEquivalentClassesAxiom.getClassExpressions().size() <= 2) continue;
            map = new HashMap();
            map.put(oWLEquivalentClassesAxiom.getClassExpressions(), oWLEquivalentClassesAxiom.getAnnotations());
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_CLASSES, map, ",", false, ontology);
        }
        for (OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom : ontology.getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            if (oWLDisjointObjectPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new HashMap();
            map.put(oWLDisjointObjectPropertiesAxiom.getProperties(), oWLDisjointObjectPropertiesAxiom.getAnnotations());
            this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom : ontology.getAxioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            if (oWLEquivalentObjectPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new HashMap();
            map.put(oWLEquivalentObjectPropertiesAxiom.getProperties(), oWLEquivalentObjectPropertiesAxiom.getAnnotations());
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom : ontology.getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            if (oWLDisjointDataPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new HashMap();
            map.put(oWLDisjointDataPropertiesAxiom.getProperties(), oWLDisjointDataPropertiesAxiom.getAnnotations());
            this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom : ontology.getAxioms(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            if (oWLEquivalentDataPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new HashMap();
            map.put(oWLEquivalentDataPropertiesAxiom.getProperties(), oWLEquivalentDataPropertiesAxiom.getAnnotations());
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom : ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS)) {
            if (oWLDifferentIndividualsAxiom.getIndividuals().size() <= 2) continue;
            map = new HashMap();
            map.put(oWLDifferentIndividualsAxiom.getIndividuals(), oWLDifferentIndividualsAxiom.getAnnotations());
            this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, map, ",", false, ontology);
        }
        for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
            this.writeSection(ManchesterOWLSyntax.RULE, Collections.singleton(sWRLRule), ", ", false, new OWLOntology[0]);
        }
        this.flush();
    }

    public void writeOntologyHeader(OWLOntology ontology) {
        this.event = new RendererEvent(this, ontology);
        this.fireFrameRenderingPrepared(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(":");
        this.writeSpace();
        if (!ontology.isAnonymous()) {
            int indent = this.getIndent();
            this.writeFullURI(ontology.getOntologyID().getOntologyIRI().toString());
            this.writeNewLine();
            this.pushTab(indent);
            if (ontology.getOntologyID().getVersionIRI() != null) {
                this.writeFullURI(ontology.getOntologyID().getVersionIRI().toString());
            }
            this.popTab();
        }
        this.fireFrameRenderingStarted(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.writeNewLine();
        for (OWLImportsDeclaration decl : ontology.getImportsDeclarations()) {
            this.fireSectionItemPrepared(ManchesterOWLSyntax.IMPORT.toString());
            this.write(ManchesterOWLSyntax.IMPORT.toString());
            this.write(":");
            this.writeSpace();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.IMPORT.toString());
            this.writeFullURI(decl.getURI().toString());
            this.writeNewLine();
            this.fireSectionRenderingFinished(ManchesterOWLSyntax.IMPORT.toString());
        }
        this.writeNewLine();
        this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, ontology.getAnnotations(), ",", true, new OWLOntology[0]);
        this.fireFrameRenderingFinished(ManchesterOWLSyntax.ONTOLOGY.toString());
    }

    public void writePrefixMap() {
        ShortFormProvider sfp = this.getShortFormProvider();
        if (!(sfp instanceof ManchesterOWLSyntaxPrefixNameShortFormProvider)) {
            return;
        }
        ManchesterOWLSyntaxPrefixNameShortFormProvider prov = (ManchesterOWLSyntaxPrefixNameShortFormProvider)sfp;
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        for (String prefixName : prov.getPrefixManager().getPrefixName2PrefixMap().keySet()) {
            String prefix = prov.getPrefixManager().getPrefix(prefixName);
            prefixMap.put(prefixName, prefix);
            this.write(ManchesterOWLSyntax.PREFIX.toString());
            this.write(": ");
            this.write(prefixName);
            this.write(" ");
            this.writeFullURI(prefix);
            this.writeNewLine();
        }
        if (!prefixMap.isEmpty()) {
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeFullURI(String uri) {
        this.write("<");
        this.write(uri);
        this.write(">");
    }

    public boolean isFiltered(AxiomType axiomType) {
        return this.filteredAxiomTypes.contains(axiomType);
    }

    public boolean isDisplayed(OWLAxiom axiom) {
        if (axiom == null) {
            return false;
        }
        return this.axiomFilter.passes(axiom);
    }

    public Set<OWLAxiom> writeFrame(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return this.write(entity.asOWLClass());
        }
        if (entity.isOWLObjectProperty()) {
            return this.write(entity.asOWLObjectProperty());
        }
        if (entity.isOWLDataProperty()) {
            return this.write(entity.asOWLDataProperty());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.write(entity.asOWLNamedIndividual());
        }
        if (entity.isOWLAnnotationProperty()) {
            return this.write(entity.asOWLAnnotationProperty());
        }
        if (entity.isOWLDatatype()) {
            return this.write(entity.asOWLDatatype());
        }
        return Collections.emptySet();
    }

    public Set<OWLAxiom> write(OWLClass cls) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.CLASS, cls));
        if (!this.isFiltered(AxiomType.EQUIVALENT_CLASSES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeMap<OWLClassExpression, Set<OWLAnnotation>> equivalentClasses = new TreeMap<OWLClassExpression, Set<OWLAnnotation>>();
                for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : ontology.getEquivalentClassesAxioms(cls)) {
                    if (oWLEquivalentClassesAxiom.getClassExpressions().size() != 2 || !this.isDisplayed(oWLEquivalentClassesAxiom)) continue;
                    for (OWLClassExpression equivCls : oWLEquivalentClassesAxiom.getClassExpressionsMinus(cls)) {
                        equivalentClasses.put(equivCls, oWLEquivalentClassesAxiom.getAnnotations());
                    }
                    axioms.add(oWLEquivalentClassesAxiom);
                }
                equivalentClasses.remove(cls);
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, equivalentClasses, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUBCLASS_OF)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeMap<OWLClassExpression, Set<OWLAnnotation>> superclasses = new TreeMap<OWLClassExpression, Set<OWLAnnotation>>();
                for (OWLSubClassOfAxiom oWLSubClassOfAxiom : ontology.getSubClassAxiomsForSubClass(cls)) {
                    if (!this.isDisplayed(oWLSubClassOfAxiom)) continue;
                    superclasses.put(oWLSubClassOfAxiom.getSuperClass(), oWLSubClassOfAxiom.getAnnotations());
                    axioms.add(oWLSubClassOfAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.SUBCLASS_OF, superclasses, ",", true, ontology);
            }
            if (this.renderExtensions) {
                for (OWLOntology ont : this.getOntologies()) {
                    TreeSet<OWLClassExpression> subClasses = new TreeSet<OWLClassExpression>();
                    for (OWLSubClassOfAxiom oWLSubClassOfAxiom : ont.getSubClassAxiomsForSuperClass(cls)) {
                        if (!this.isDisplayed(oWLSubClassOfAxiom)) continue;
                        subClasses.add(oWLSubClassOfAxiom.getSubClass());
                        axioms.add(oWLSubClassOfAxiom);
                    }
                    this.writeSection(ManchesterOWLSyntax.SUPERCLASS_OF, subClasses, ",", true, ont);
                }
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_CLASSES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet<OWLDisjointClassesAxiom> pairwiseDisjointClassesAxioms = new HashSet<OWLDisjointClassesAxiom>();
                TreeMap<OWLClassExpression, Set<OWLAnnotation>> disjointClasses = new TreeMap<OWLClassExpression, Set<OWLAnnotation>>();
                for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(cls)) {
                    if (!this.isDisplayed(ax)) continue;
                    if (ax.getClassExpressions().size() == 2) {
                        pairwiseDisjointClassesAxioms.add(ax);
                        OWLClassExpression disjointWith = ax.getClassExpressionsMinus(cls).iterator().next();
                        disjointClasses.put(disjointWith, ax.getAnnotations());
                    }
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, disjointClasses, ", ", false, ontology);
                if (!this.renderExtensions) continue;
                TreeSet<OWLClassExpression> treeSet = new TreeSet<OWLClassExpression>();
                for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(cls)) {
                    if (!this.isDisplayed(ax) || ax.getClassExpressions().size() <= 2) continue;
                    TreeSet<OWLClassExpression> allDisjointClasses = new TreeSet<OWLClassExpression>(ax.getClassExpressions());
                    allDisjointClasses.remove(cls);
                    treeSet.addAll(allDisjointClasses);
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, treeSet, ", ", false, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.HAS_KEY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                for (OWLHasKeyAxiom ax : ontology.getHasKeyAxioms(cls)) {
                    if (!this.isDisplayed(ax)) continue;
                    HashMap<Set<OWLPropertyExpression>, Set<OWLAnnotation>> hashMap = new HashMap<Set<OWLPropertyExpression>, Set<OWLAnnotation>>();
                    hashMap.put(ax.getPropertyExpressions(), ax.getAnnotations());
                    this.writeSection(ManchesterOWLSyntax.HAS_KEY, hashMap, ", ", true, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeMap<OWLIndividual, Set<OWLAnnotation>> individuals = new TreeMap<OWLIndividual, Set<OWLAnnotation>>();
                for (OWLClassAssertionAxiom oWLClassAssertionAxiom : ontology.getClassAssertionAxioms(cls)) {
                    if (!this.isDisplayed(oWLClassAssertionAxiom) || !this.renderExtensions && !oWLClassAssertionAxiom.getIndividual().isAnonymous()) continue;
                    individuals.put(oWLClassAssertionAxiom.getIndividual(), oWLClassAssertionAxiom.getAnnotations());
                    axioms.add(oWLClassAssertionAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.INDIVIDUALS, individuals, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet rules = new HashSet();
                block15: for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed(sWRLRule)) continue;
                    for (SWRLAtom atom : sWRLRule.getHead()) {
                        if (!atom.getPredicate().equals(cls)) continue;
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, ", ", true, ontology);
                        continue block15;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.CLASS.toString());
        return axioms;
    }

    protected void writeEntitySectionEnd(String type) {
        this.fireFrameRenderingFinished(type);
        this.popTab();
        this.writeNewLine();
    }

    public Set<OWLAxiom> write(OWLObjectPropertyExpression property) {
        TreeMap<OWLClassExpression, Set<OWLAnnotation>> expressions;
        Set<OWLObjectPropertyExpression> props;
        Cloneable properties;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.OBJECT_PROPERTY, property));
        if (!this.isFiltered(AxiomType.SUB_OBJECT_PROPERTY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new TreeMap<Object, Set<OWLAnnotation>>();
                for (OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom : ontology.getObjectSubPropertyAxiomsForSubProperty(property)) {
                    if (!this.isDisplayed(oWLSubObjectPropertyOfAxiom)) continue;
                    properties.put(oWLSubObjectPropertyOfAxiom.getSuperProperty(), oWLSubObjectPropertyOfAxiom.getAnnotations());
                    axioms.add(oWLSubObjectPropertyOfAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, (Map<? extends Object, Set<OWLAnnotation>>)((Object)properties), ",", true, ontology);
            }
            if (this.renderExtensions) {
                for (OWLOntology ontology : this.getOntologies()) {
                    properties = new TreeMap();
                    for (OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom : ontology.getObjectSubPropertyAxiomsForSuperProperty(property)) {
                        if (!this.isDisplayed(oWLSubObjectPropertyOfAxiom)) continue;
                        properties.put(oWLSubObjectPropertyOfAxiom.getSubProperty(), oWLSubObjectPropertyOfAxiom.getAnnotations());
                        axioms.add(oWLSubObjectPropertyOfAxiom);
                    }
                    this.writeSection(ManchesterOWLSyntax.SUPER_PROPERTY_OF, (Map<? extends Object, Set<OWLAnnotation>>)((Object)properties), ",", true, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new TreeMap();
                for (OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom : ontology.getEquivalentObjectPropertiesAxioms(property)) {
                    if (!this.isDisplayed(oWLEquivalentObjectPropertiesAxiom) || oWLEquivalentObjectPropertiesAxiom.getProperties().size() != 2) continue;
                    props = oWLEquivalentObjectPropertiesAxiom.getPropertiesMinus(property);
                    properties.put(props.iterator().next(), oWLEquivalentObjectPropertiesAxiom.getAnnotations());
                    axioms.add(oWLEquivalentObjectPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, (Map<? extends Object, Set<OWLAnnotation>>)((Object)properties), ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new TreeMap();
                for (OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom : ontology.getDisjointObjectPropertiesAxioms(property)) {
                    if (oWLDisjointObjectPropertiesAxiom.getProperties().size() != 2 || !this.isDisplayed(oWLDisjointObjectPropertiesAxiom)) continue;
                    props = oWLDisjointObjectPropertiesAxiom.getPropertiesMinus(property);
                    properties.put(props.iterator().next(), oWLDisjointObjectPropertiesAxiom.getAnnotations());
                    axioms.add(oWLDisjointObjectPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, (Map<? extends Object, Set<OWLAnnotation>>)((Object)properties), ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
            for (OWLOntology ontology : this.getOntologies()) {
                for (OWLSubPropertyChainOfAxiom ax : ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
                    if (!ax.getSuperProperty().equals(property) || !this.isDisplayed(ax)) continue;
                    HashMap<List<OWLObjectPropertyExpression>, Set<OWLAnnotation>> hashMap = new HashMap<List<OWLObjectPropertyExpression>, Set<OWLAnnotation>>();
                    hashMap.put(ax.getPropertyChain(), ax.getAnnotations());
                    this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_CHAIN, hashMap, " o ", false, ontology);
                    axioms.add(ax);
                }
            }
        }
        for (OWLOntology ontology : this.getOntologies()) {
            LinkedHashMap<String, Set<OWLAnnotation>> characteristics = new LinkedHashMap<String, Set<OWLAnnotation>>();
            if (!this.isFiltered(AxiomType.FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom : ontology.getFunctionalObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLFunctionalObjectPropertyAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.FUNCTIONAL.toString(), oWLFunctionalObjectPropertyAxiom.getAnnotations());
                    axioms.add(oWLFunctionalObjectPropertyAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom : ontology.getInverseFunctionalObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLInverseFunctionalObjectPropertyAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString(), oWLInverseFunctionalObjectPropertyAxiom.getAnnotations());
                    axioms.add(oWLInverseFunctionalObjectPropertyAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.SYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom : ontology.getSymmetricObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLSymmetricObjectPropertyAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.SYMMETRIC.toString(), oWLSymmetricObjectPropertyAxiom.getAnnotations());
                    axioms.add(oWLSymmetricObjectPropertyAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.TRANSITIVE_OBJECT_PROPERTY)) {
                for (OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom : ontology.getTransitiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLTransitiveObjectPropertyAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.TRANSITIVE.toString(), oWLTransitiveObjectPropertyAxiom.getAnnotations());
                    axioms.add(oWLTransitiveObjectPropertyAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.REFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom : ontology.getReflexiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLReflexiveObjectPropertyAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.REFLEXIVE.toString(), oWLReflexiveObjectPropertyAxiom.getAnnotations());
                    axioms.add(oWLReflexiveObjectPropertyAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom : ontology.getIrreflexiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLIrreflexiveObjectPropertyAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.IRREFLEXIVE.toString(), oWLIrreflexiveObjectPropertyAxiom.getAnnotations());
                    axioms.add(oWLIrreflexiveObjectPropertyAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.ASYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom : ontology.getAsymmetricObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAsymmetricObjectPropertyAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.ASYMMETRIC.toString(), oWLAsymmetricObjectPropertyAxiom.getAnnotations());
                    axioms.add(oWLAsymmetricObjectPropertyAxiom);
                }
            }
            this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
        }
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_DOMAIN)) {
            for (OWLOntology ontology : this.getOntologies()) {
                expressions = new TreeMap<OWLClassExpression, Set<OWLAnnotation>>();
                for (OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom : ontology.getObjectPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed(oWLObjectPropertyDomainAxiom)) continue;
                    expressions.put(oWLObjectPropertyDomainAxiom.getDomain(), oWLObjectPropertyDomainAxiom.getAnnotations());
                    axioms.add(oWLObjectPropertyDomainAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, expressions, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_RANGE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                expressions = new TreeMap();
                for (OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom : ontology.getObjectPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed(oWLObjectPropertyRangeAxiom)) continue;
                    expressions.put((OWLClassExpression)oWLObjectPropertyRangeAxiom.getRange(), oWLObjectPropertyRangeAxiom.getAnnotations());
                    axioms.add(oWLObjectPropertyRangeAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, expressions, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.INVERSE_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new TreeSet();
                for (OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom : ontology.getInverseObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLInverseObjectPropertiesAxiom)) continue;
                    if (oWLInverseObjectPropertiesAxiom.getFirstProperty().equals(property)) {
                        properties.add(oWLInverseObjectPropertiesAxiom.getSecondProperty());
                    } else {
                        properties.add(oWLInverseObjectPropertiesAxiom.getFirstProperty());
                    }
                    axioms.add(oWLInverseObjectPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.INVERSE_OF, (Collection<? extends Object>)((Object)properties), ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet<SWRLRule> rules = new HashSet<SWRLRule>();
                block25: for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed(sWRLRule)) continue;
                    for (SWRLAtom atom : sWRLRule.getHead()) {
                        if (!atom.getPredicate().equals(property)) continue;
                        rules.add(sWRLRule);
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, "\u00d4\u00f8\u03a9", true, ontology);
                        continue block25;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.OBJECT_PROPERTY.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(OWLDataProperty property) {
        TreeMap<OWLDataProperty, Set<OWLAnnotation>> props;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATA_PROPERTY, property));
        if (!this.isFiltered(AxiomType.FUNCTIONAL_DATA_PROPERTY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashMap<String, Set<OWLAnnotation>> characteristics = new HashMap<String, Set<OWLAnnotation>>();
                for (OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom : ontology.getFunctionalDataPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLFunctionalDataPropertyAxiom)) continue;
                    characteristics.put(ManchesterOWLSyntax.FUNCTIONAL.toString(), oWLFunctionalDataPropertyAxiom.getAnnotations());
                    axioms.add(oWLFunctionalDataPropertyAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_DOMAIN)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeMap<OWLClassExpression, Set<OWLAnnotation>> domains = new TreeMap<OWLClassExpression, Set<OWLAnnotation>>();
                for (OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom : ontology.getDataPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed(oWLDataPropertyDomainAxiom)) continue;
                    domains.put(oWLDataPropertyDomainAxiom.getDomain(), oWLDataPropertyDomainAxiom.getAnnotations());
                    axioms.add(oWLDataPropertyDomainAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, domains, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_RANGE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeMap ranges = new TreeMap();
                for (OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom : ontology.getDataPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed(oWLDataPropertyRangeAxiom)) continue;
                    ranges.put(oWLDataPropertyRangeAxiom.getRange(), oWLDataPropertyRangeAxiom.getAnnotations());
                    axioms.add(oWLDataPropertyRangeAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, ranges, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_DATA_PROPERTY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeMap supers = new TreeMap();
                for (OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom : ontology.getDataSubPropertyAxiomsForSubProperty(property)) {
                    if (!this.isDisplayed(oWLSubDataPropertyOfAxiom)) continue;
                    supers.put(oWLSubDataPropertyOfAxiom.getSuperProperty(), oWLSubDataPropertyOfAxiom.getAnnotations());
                    axioms.add(oWLSubDataPropertyOfAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, supers, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                props = new TreeMap<OWLDataProperty, Set<OWLAnnotation>>();
                for (OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom : ontology.getEquivalentDataPropertiesAxioms(property)) {
                    if (!this.isDisplayed(oWLEquivalentDataPropertiesAxiom) || oWLEquivalentDataPropertiesAxiom.getProperties().size() != 2) continue;
                    props.put(oWLEquivalentDataPropertiesAxiom.getPropertiesMinus(property).iterator().next(), oWLEquivalentDataPropertiesAxiom.getAnnotations());
                    axioms.add(oWLEquivalentDataPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, props, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                props = new TreeMap();
                for (OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom : ontology.getDisjointDataPropertiesAxioms(property)) {
                    if (oWLDisjointDataPropertiesAxiom.getProperties().size() != 2 || !this.isDisplayed(oWLDisjointDataPropertiesAxiom)) continue;
                    props.put(oWLDisjointDataPropertiesAxiom.getPropertiesMinus(property).iterator().next(), oWLDisjointDataPropertiesAxiom.getAnnotations());
                    axioms.add(oWLDisjointDataPropertiesAxiom);
                }
                props.remove(property);
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, props, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet rules = new HashSet();
                block13: for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed(sWRLRule)) continue;
                    for (SWRLAtom atom : sWRLRule.getHead()) {
                        if (!atom.getPredicate().equals(property)) continue;
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, "", true, ontology);
                        continue block13;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATA_PROPERTY.toString());
        return axioms;
    }

    /*
     * WARNING - void declaration
     */
    public Set<OWLAxiom> write(OWLIndividual individual) {
        TreeSet<OWLIndividual> inds;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.INDIVIDUAL, individual));
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeMap<OWLClassExpression, Set<OWLAnnotation>> expressions = new TreeMap<OWLClassExpression, Set<OWLAnnotation>>();
                for (OWLClassAssertionAxiom oWLClassAssertionAxiom : ontology.getClassAssertionAxioms(individual)) {
                    if (!this.isDisplayed(oWLClassAssertionAxiom)) continue;
                    expressions.put(oWLClassAssertionAxiom.getClassExpression(), oWLClassAssertionAxiom.getAnnotations());
                    axioms.add(oWLClassAssertionAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.TYPES, expressions, ",", true, ontology);
            }
        }
        for (OWLOntology ontology : this.getOntologies()) {
            TreeMap objectMap = new TreeMap();
            if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
                for (OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom : ontology.getObjectPropertyAssertionAxioms(individual)) {
                    void var8_24;
                    if (!this.isDisplayed(oWLObjectPropertyAssertionAxiom)) continue;
                    axioms.add(oWLObjectPropertyAssertionAxiom);
                    Map map = (Map)objectMap.get(oWLObjectPropertyAssertionAxiom.getProperty());
                    if (map == null) {
                        TreeMap treeMap = new TreeMap();
                        objectMap.put(oWLObjectPropertyAssertionAxiom.getProperty(), treeMap);
                    }
                    var8_24.put(oWLObjectPropertyAssertionAxiom.getObject(), oWLObjectPropertyAssertionAxiom.getAnnotations());
                }
            }
            TreeMap dataMap = new TreeMap();
            if (!this.isFiltered(AxiomType.DATA_PROPERTY_ASSERTION)) {
                for (OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom : ontology.getDataPropertyAssertionAxioms(individual)) {
                    if (!this.isDisplayed(oWLDataPropertyAssertionAxiom)) continue;
                    axioms.add(oWLDataPropertyAssertionAxiom);
                    TreeMap objs = (TreeMap)dataMap.get(oWLDataPropertyAssertionAxiom.getProperty());
                    if (objs == null) {
                        objs = new TreeMap();
                        dataMap.put(oWLDataPropertyAssertionAxiom.getProperty(), objs);
                    }
                    objs.put(oWLDataPropertyAssertionAxiom.getObject(), oWLDataPropertyAssertionAxiom.getAnnotations());
                }
            }
            TreeMap treeMap = new TreeMap();
            if (!this.isFiltered(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION)) {
                for (OWLNegativeObjectPropertyAssertionAxiom ax : ontology.getNegativeObjectPropertyAssertionAxioms(individual)) {
                    if (!this.isDisplayed(ax)) continue;
                    axioms.add(ax);
                    TreeMap inds3 = (TreeMap)objectMap.get(ax.getProperty());
                    if (inds3 == null) {
                        inds3 = new TreeMap();
                        treeMap.put(ax.getProperty(), inds3);
                    }
                    inds3.put(ax.getObject(), ax.getAnnotations());
                }
            }
            TreeMap treeMap2 = new TreeMap();
            if (!this.isFiltered(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION)) {
                for (OWLNegativeDataPropertyAssertionAxiom ax : ontology.getNegativeDataPropertyAssertionAxioms(individual)) {
                    if (!this.isDisplayed(ax)) continue;
                    axioms.add(ax);
                    TreeMap objs = (TreeMap)treeMap2.get(ax.getProperty());
                    if (objs == null) {
                        objs = new TreeMap();
                        treeMap2.put(ax.getProperty(), objs);
                    }
                    objs.put(ax.getObject(), ax.getAnnotations());
                }
            }
            if (objectMap.isEmpty() && dataMap.isEmpty() && treeMap.isEmpty() && treeMap2.isEmpty()) continue;
            this.fireSectionRenderingPrepared(ManchesterOWLSyntax.FACTS.toString());
            this.writeSection(ManchesterOWLSyntax.FACTS);
            this.writeSpace();
            this.writeOntologiesList(ontology);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.FACTS.toString());
            this.writeFacts(objectMap, false);
            if (!(objectMap.isEmpty() || dataMap.isEmpty() && treeMap.isEmpty() && treeMap2.isEmpty())) {
                this.write(",");
                this.writeNewLine();
            }
            this.writeFacts(dataMap, false);
            if (!(dataMap.isEmpty() || treeMap.isEmpty() && treeMap2.isEmpty())) {
                this.write(",");
                this.writeNewLine();
            }
            this.writeFacts(treeMap, true);
            if (!treeMap2.isEmpty() && !treeMap.isEmpty()) {
                this.write(",");
                this.writeNewLine();
            }
            this.writeFacts(treeMap2, true);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
        if (!this.isFiltered(AxiomType.SAME_INDIVIDUAL)) {
            for (OWLOntology ontology : this.getOntologies()) {
                inds = new TreeSet<OWLIndividual>();
                for (OWLSameIndividualAxiom oWLSameIndividualAxiom : ontology.getSameIndividualAxioms(individual)) {
                    if (!this.isDisplayed(oWLSameIndividualAxiom)) continue;
                    inds.addAll(oWLSameIndividualAxiom.getIndividuals());
                    axioms.add(oWLSameIndividualAxiom);
                }
                inds.remove(individual);
                this.writeSection(ManchesterOWLSyntax.SAME_AS, inds, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DIFFERENT_INDIVIDUALS)) {
            for (OWLOntology ontology : this.getOntologies()) {
                inds = new TreeSet();
                TreeSet<OWLDifferentIndividualsAxiom> nary = new TreeSet<OWLDifferentIndividualsAxiom>();
                for (OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom : ontology.getDifferentIndividualAxioms(individual)) {
                    if (oWLDifferentIndividualsAxiom.getIndividuals().size() == 2 && this.isDisplayed(oWLDifferentIndividualsAxiom)) {
                        inds.addAll(oWLDifferentIndividualsAxiom.getIndividuals());
                        axioms.add(oWLDifferentIndividualsAxiom);
                        continue;
                    }
                    nary.add(oWLDifferentIndividualsAxiom);
                }
                inds.remove(individual);
                this.writeSection(ManchesterOWLSyntax.DIFFERENT_FROM, inds, ",", true, ontology);
                if (!this.renderExtensions) continue;
                for (OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom : nary) {
                    this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, oWLDifferentIndividualsAxiom.getIndividuals(), ", ", false, ontology);
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.INDIVIDUAL.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(OWLDatatype datatype) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATATYPE, datatype));
        if (!this.isFiltered(AxiomType.DATATYPE_DEFINITION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeSet<OWLDataRange> dataRanges = new TreeSet<OWLDataRange>();
                for (OWLDatatypeDefinitionAxiom ax : ontology.getDatatypeDefinitions(datatype)) {
                    if (!this.isDisplayed(ax)) continue;
                    axioms.add(ax);
                    dataRanges.add(ax.getDataRange());
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, dataRanges, ",", true, ontology);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATATYPE.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(SWRLRule rule) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>(1);
        for (OWLOntology ontology : this.getOntologies()) {
            if (!ontology.containsAxiom(rule)) continue;
            this.writeSection(ManchesterOWLSyntax.RULE, Collections.singleton(rule), "", true, ontology);
            axioms.add(rule);
        }
        return axioms;
    }

    public Set<OWLAxiom> write(OWLAnnotationProperty property) {
        TreeSet<IRI> iris;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.ANNOTATION_PROPERTY, property));
        if (!this.isFiltered(AxiomType.ANNOTATION_ASSERTION)) {
            for (OWLOntology ont : this.getOntologies()) {
                TreeSet<OWLAnnotation> annos = new TreeSet<OWLAnnotation>();
                for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : ont.getAnnotationAssertionAxioms(property.getIRI())) {
                    if (!this.isDisplayed(oWLAnnotationAssertionAxiom)) continue;
                    annos.add(oWLAnnotationAssertionAxiom.getAnnotation());
                }
                this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, annos, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            for (OWLOntology ont : this.getOntologies()) {
                TreeSet<OWLAnnotationProperty> props = new TreeSet<OWLAnnotationProperty>();
                for (OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom : ont.getSubAnnotationPropertyOfAxioms(property)) {
                    if (!this.isDisplayed(oWLSubAnnotationPropertyOfAxiom)) continue;
                    props.add(oWLSubAnnotationPropertyOfAxiom.getSuperProperty());
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, props, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            for (OWLOntology ont : this.getOntologies()) {
                iris = new TreeSet<IRI>();
                for (OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom : ont.getAnnotationPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed(oWLAnnotationPropertyDomainAxiom)) continue;
                    iris.add(oWLAnnotationPropertyDomainAxiom.getDomain());
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, iris, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            for (OWLOntology ont : this.getOntologies()) {
                iris = new TreeSet();
                for (OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom : ont.getAnnotationPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed(oWLAnnotationPropertyRangeAxiom)) continue;
                    iris.add(oWLAnnotationPropertyRangeAxiom.getRange());
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, iris, ",", true, ont);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.ANNOTATION_PROPERTY.toString());
        return axioms;
    }

    private <K extends OWLObject, V extends OWLObject> void writeFacts(Map<K, Map<V, Set<OWLAnnotation>>> relationshipsMap, boolean negative) {
        Iterator<K> propIt = relationshipsMap.keySet().iterator();
        while (propIt.hasNext()) {
            OWLObject prop = (OWLObject)propIt.next();
            Map<V, Set<OWLAnnotation>> object2AnnotationsMap = relationshipsMap.get(prop);
            Iterator<V> it = object2AnnotationsMap.keySet().iterator();
            while (it.hasNext()) {
                this.fireSectionItemPrepared(ManchesterOWLSyntax.FACTS.toString());
                OWLObject ind = (OWLObject)it.next();
                Set<OWLAnnotation> annotations = object2AnnotationsMap.get(ind);
                if (!annotations.isEmpty()) {
                    this.write(ManchesterOWLSyntax.ANNOTATIONS.toString());
                    this.write(": ");
                    this.pushTab(this.getIndent() + 1);
                    Iterator<OWLAnnotation> annoIt = annotations.iterator();
                    while (annoIt.hasNext()) {
                        OWLAnnotation anno = annoIt.next();
                        anno.accept(this);
                        if (!annoIt.hasNext()) continue;
                        this.write(", ");
                        this.writeNewLine();
                    }
                    this.popTab();
                    this.writeNewLine();
                    this.writeNewLine();
                }
                if (negative) {
                    this.write(ManchesterOWLSyntax.NOT);
                    this.writeSpace();
                }
                prop.accept(this);
                this.writeSpace();
                this.writeSpace();
                ind.accept(this);
                this.fireSectionItemFinished(ManchesterOWLSyntax.FACTS.toString());
                if (!it.hasNext()) continue;
                this.write(",");
                this.writeNewLine();
            }
            if (!propIt.hasNext()) continue;
            this.write(",");
            this.writeNewLine();
        }
    }

    private Set<OWLAnnotationAssertionAxiom> writeEntityStart(ManchesterOWLSyntax keyword, OWLObject entity) {
        this.event = new RendererEvent(this, entity);
        String kw = keyword.toString();
        this.fireFrameRenderingPrepared(kw);
        this.writeSection(keyword);
        entity.accept(this);
        this.fireFrameRenderingStarted(kw);
        this.writeNewLine();
        this.incrementTab(4);
        this.writeNewLine();
        if (entity instanceof OWLEntity) {
            return this.writeAnnotations(((OWLEntity)entity).getIRI());
        }
        if (entity instanceof OWLAnonymousIndividual) {
            return this.writeAnnotations((OWLAnonymousIndividual)entity);
        }
        return Collections.emptySet();
    }

    public Set<OWLAnnotationAssertionAxiom> writeAnnotations(OWLAnnotationSubject subject) {
        HashSet<OWLAnnotationAssertionAxiom> axioms = new HashSet<OWLAnnotationAssertionAxiom>();
        if (!this.isFiltered(AxiomType.ANNOTATION_ASSERTION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeSet<OWLAnnotation> annos = new TreeSet<OWLAnnotation>();
                for (OWLAnnotationAssertionAxiom ax : ontology.getAnnotationAssertionAxioms(subject)) {
                    if (!this.isDisplayed(ax)) continue;
                    axioms.add(ax);
                    annos.add(ax.getAnnotation());
                }
                this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, annos, ",", true, ontology);
            }
        }
        return axioms;
    }

    public void writeSection(ManchesterOWLSyntax keyword) {
        this.write("", keyword, "");
        this.write(":");
        this.writeSpace();
    }

    public void writeSection(ManchesterOWLSyntax keyword, Map<? extends Object, Set<OWLAnnotation>> content, String delimeter, boolean newline, OWLOntology ... ontologies) {
        String sec = keyword.toString();
        if (!content.isEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologies)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologies);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<? extends Object> it = content.keySet().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                this.fireSectionItemPrepared(sec);
                Set<OWLAnnotation> annos = content.get(obj);
                if (!annos.isEmpty()) {
                    this.write(ManchesterOWLSyntax.ANNOTATIONS.toString());
                    this.write(": ");
                    this.pushTab(this.getIndent() + 1);
                    Iterator<OWLAnnotation> annoIt = annos.iterator();
                    while (annoIt.hasNext()) {
                        annoIt.next().accept(this);
                        if (!annoIt.hasNext()) continue;
                        this.write(", ");
                        this.writeNewLine();
                    }
                    this.popTab();
                    this.writeNewLine();
                    this.writeNewLine();
                }
                if (obj instanceof OWLObject) {
                    ((OWLObject)obj).accept(this);
                } else if (obj instanceof Collection) {
                    Iterator listIt = ((Collection)obj).iterator();
                    while (listIt.hasNext()) {
                        Object o = listIt.next();
                        if (o instanceof OWLObject) {
                            ((OWLObject)o).accept(this);
                        } else {
                            this.write(o.toString());
                        }
                        if (!listIt.hasNext()) continue;
                        this.write(delimeter);
                        if (!newline) continue;
                        this.writeNewLine();
                    }
                } else {
                    this.write(obj.toString());
                }
                if (it.hasNext()) {
                    this.write(delimeter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeSection(ManchesterOWLSyntax keyword, Collection<? extends Object> content, String delimeter, boolean newline, OWLOntology ... ontologies) {
        String sec = keyword.toString();
        if (!content.isEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologies)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologies);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<? extends Object> it = content.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                this.fireSectionItemPrepared(sec);
                if (obj instanceof OWLObject) {
                    ((OWLObject)obj).accept(this);
                } else {
                    this.write(obj.toString());
                }
                if (it.hasNext()) {
                    this.write(delimeter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeComment(String comment, boolean placeOnNewline) {
        this.writeComment("#", comment, placeOnNewline);
    }

    public void writeComment(String commentDelim, String comment, boolean placeOnNewline) {
        if (placeOnNewline) {
            this.writeNewLine();
        }
        this.write(commentDelim);
        this.write(comment);
        this.writeNewLine();
    }

    private void writeOntologiesList(OWLOntology ... ontologies) {
        if (!this.renderExtensions) {
            return;
        }
        if (ontologies.length == 0) {
            return;
        }
        if (ontologies.length != 1 || this.defaultOntology != null) {
            // empty if block
        }
        this.write("[in ");
        int count = 0;
        for (OWLOntology ont : ontologies) {
            this.write(this.shortFormProvider.getShortForm(ont));
            if (++count >= ontologies.length) continue;
            this.write(", ");
        }
        this.write("]");
    }

    private void fireFrameRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingPrepared(section, this.event);
        }
    }

    private void fireFrameRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingStarted(section, this.event);
        }
    }

    private void fireFrameRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingFinished(section, this.event);
        }
    }

    private void fireSectionRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingPrepared(section, this.event);
        }
    }

    private void fireSectionRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingStarted(section, this.event);
        }
    }

    private void fireSectionRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingFinished(section, this.event);
        }
    }

    private void fireSectionItemPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemPrepared(section, this.event);
        }
    }

    private void fireSectionItemFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemFinished(section, this.event);
        }
    }

    private class DefaultRenderingDirector
    implements RenderingDirector {
        private DefaultRenderingDirector() {
        }

        public boolean renderEmptyFrameSection(ManchesterOWLSyntax frameSectionKeyword, OWLOntology ... ontologies) {
            return false;
        }
    }
}

