package org.semanticweb.owlapi.model;
/*
 * Copyright (C) 2006, University of Manchester
 *
 * Modifications to the initial code base are copyright of their
 * respective authors, or their employers as appropriate.  Authorship
 * of the modifications may be determined from the ChangeLog placed at
 * the end of this file.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * Author: Matthew Horridge<br>
 * The University Of Manchester<br>
 * Bio-Health Informatics Group
 * Date: 24-Oct-2006
 */
public interface OWLCardinalityRestriction<R extends OWLPropertyRange, P extends OWLPropertyExpression<R, P>, F extends OWLPropertyRange> extends OWLQuantifiedRestriction<R, P, F> {

    /**
     * Gets the cardinality of this restriction
     * @return The cardinality of this restriction
     */
    int getCardinality();


    /**
     * Determines if this restriction is qualified.  Qualified cardinality restrictions
     * are defined to be cardinality restrictions that have fillers which aren't TOP (owl:Thing
     * or rdfs:Literal).  An object restriction is unqualified if it has a filler that is owl:Thing.
     * A data restriction is unqualified if it has a filler which is the top data type (rdfs:Literal).
     * @return <code>true</code> if this restriction is qualified, or <code>false</code> if
     * this restriction is unqualified.
     */
    boolean isQualified();
}
