/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.AbstractDataRestrictionTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public abstract class AbstractDataCardinalityTranslator
extends AbstractDataRestrictionTranslator {
    private IRI cardinalityPredicate;

    public AbstractDataCardinalityTranslator(OWLRDFConsumer consumer, IRI cardinalityPredicate) {
        super(consumer);
        this.cardinalityPredicate = cardinalityPredicate;
    }

    public boolean matches(IRI mainNode) {
        if (!super.matches(mainNode)) {
            return false;
        }
        OWLLiteral cardinalityLiteral = this.getConsumer().getLiteralObject(mainNode, this.cardinalityPredicate, false);
        if (cardinalityLiteral == null) {
            return false;
        }
        if (this.getConsumer().getConfiguration().isStrict()) {
            OWL2Datatype xsdNNI = OWL2Datatype.XSD_NON_NEGATIVE_INTEGER;
            IRI strictType = xsdNNI.getIRI();
            if (!cardinalityLiteral.getDatatype().getIRI().equals(strictType)) {
                return false;
            }
            if (!xsdNNI.isInLexicalSpace(cardinalityLiteral.getLiteral())) {
                return false;
            }
        }
        return true;
    }

    public int translateCardinality(IRI mainNode) {
        OWLLiteral cardiObject = this.getConsumer().getLiteralObject(mainNode, this.cardinalityPredicate, true);
        return Integer.parseInt(cardiObject.getLiteral().trim());
    }
}

