/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPPropertyRangeHandler
extends TriplePredicateHandler {
    public TPPropertyRangeHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_RANGE.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        this.inferTypes(subject, object);
        return false;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.getConsumer().isObjectProperty(subject) && this.getConsumer().isClassExpression(object)) {
            OWLObjectPropertyExpression property = this.translateObjectProperty(subject);
            OWLClassExpression range = this.translateClassExpression(object);
            this.addAxiom(this.getDataFactory().getOWLObjectPropertyRangeAxiom(property, range, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isDataProperty(subject) && this.getConsumer().isDataRange(object)) {
            OWLDataPropertyExpression property = this.translateDataProperty(subject);
            OWLDataRange dataRange = this.translateDataRange(object);
            this.addAxiom(this.getDataFactory().getOWLDataPropertyRangeAxiom(property, dataRange, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isAnnotationProperty(subject) && !this.getConsumer().isAnonymousNode(object)) {
            OWLAnnotationProperty prop = this.getDataFactory().getOWLAnnotationProperty(subject);
            this.addAxiom(this.getDataFactory().getOWLAnnotationPropertyRangeAxiom(prop, object, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (!this.isStrict()) {
            OWLAnnotationProperty prop = this.getDataFactory().getOWLAnnotationProperty(subject);
            this.addAxiom(this.getDataFactory().getOWLAnnotationPropertyRangeAxiom(prop, object, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }
}

