/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owlapi.util.OWLEntityCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JustificationMap {
    private Set<OWLAxiom> axioms;
    private Set<OWLAxiom> rootAxioms;
    private Set<OWLAxiom> usedAxioms;
    private Map<OWLAxiom, Set<OWLAxiom>> map;
    private Map<OWLEntity, Set<OWLAxiom>> axiomsByRHS;
    private Map<OWLEntity, Set<OWLAxiom>> axiomsByLHS;
    private OWLClassExpression desc;

    public JustificationMap(OWLClassExpression desc, Set<OWLAxiom> axioms) {
        this.axioms = axioms;
        this.desc = desc;
        this.rootAxioms = new HashSet<OWLAxiom>();
        this.map = new HashMap<OWLAxiom, Set<OWLAxiom>>();
        this.usedAxioms = new HashSet<OWLAxiom>();
        this.axiomsByRHS = new HashMap<OWLEntity, Set<OWLAxiom>>();
        this.axiomsByLHS = new HashMap<OWLEntity, Set<OWLAxiom>>();
        this.createMap();
    }

    private void createMap() {
        for (OWLAxiom ax : this.axioms) {
            OWLAxiomPartExtractor extractor = new OWLAxiomPartExtractor();
            ax.accept(extractor);
            HashSet<OWLEntity> rhscollected = new HashSet<OWLEntity>();
            OWLEntityCollector rhsCollector = new OWLEntityCollector(rhscollected);
            for (OWLObject rhsObject : extractor.getRHS()) {
                rhsObject.accept(rhsCollector);
            }
            for (OWLEntity rhsEntity : rhscollected) {
                JustificationMap.index(rhsEntity, this.axiomsByRHS, ax);
            }
            HashSet<OWLEntity> lhscollected = new HashSet<OWLEntity>();
            OWLEntityCollector lhsCollector = new OWLEntityCollector(lhscollected);
            for (OWLObject lhsObject : extractor.getLHS()) {
                lhsObject.accept(lhsCollector);
            }
            for (OWLEntity lhsEntity : lhscollected) {
                JustificationMap.index(lhsEntity, this.axiomsByLHS, ax);
            }
        }
        this.buildChildren(this.desc);
    }

    private Set<OWLAxiom> getAxiomsByLHS(OWLEntity lhs) {
        Set<OWLAxiom> axioms = this.axiomsByLHS.get(lhs);
        if (axioms != null) {
            TreeSet<OWLAxiom> ts = new TreeSet<OWLAxiom>(new OWLAxiomComparator());
            ts.addAll(axioms);
            return ts;
        }
        return Collections.emptySet();
    }

    private void buildChildren(OWLClassExpression seed) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLEntity ent : seed.getSignature()) {
            Set<OWLAxiom> axs = this.getAxiomsByLHS(ent);
            for (OWLAxiom ax : axs) {
                result.add(ax);
                this.usedAxioms.add(ax);
            }
        }
        this.rootAxioms.addAll(result);
        this.buildChildren(result);
    }

    private void buildChildren(Set<OWLAxiom> axioms) {
        ArrayList<Set<OWLAxiom>> axiomChildren = new ArrayList<Set<OWLAxiom>>();
        for (OWLAxiom oWLAxiom : axioms) {
            Set<OWLAxiom> children = this.build(oWLAxiom);
            for (OWLAxiom childAx : children) {
                JustificationMap.index(oWLAxiom, this.map, childAx);
            }
            axiomChildren.add(children);
        }
        for (Set set : axiomChildren) {
            this.buildChildren(set);
        }
    }

    private Set<OWLAxiom> build(OWLAxiom parentAxiom) {
        this.usedAxioms.add(parentAxiom);
        OWLAxiomPartExtractor extractor = new OWLAxiomPartExtractor();
        parentAxiom.accept(extractor);
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLObject obj : extractor.getRHS()) {
            for (OWLEntity ent : obj.getSignature()) {
                Set<OWLAxiom> axs = this.getAxiomsByLHS(ent);
                for (OWLAxiom ax : axs) {
                    if (this.usedAxioms.contains(ax)) continue;
                    result.add(ax);
                    this.usedAxioms.add(ax);
                }
            }
        }
        return result;
    }

    private static <K, V> void index(K key, Map<K, Set<V>> map, V value) {
        Set<V> values = map.get(key);
        if (values == null) {
            values = new HashSet<V>();
            map.put(key, values);
        }
        values.add(value);
    }

    public Set<OWLAxiom> getRootAxioms() {
        return this.rootAxioms;
    }

    public Set<OWLAxiom> getChildAxioms(OWLAxiom ax) {
        Set<OWLAxiom> result = this.map.get(ax);
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OWLAxiomComparator
    extends OWLAxiomVisitorAdapter
    implements Comparator<OWLAxiom> {
        private int result;

        private OWLAxiomComparator() {
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            this.result = 0;
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.result = 1;
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            this.result = 2;
        }

        @Override
        public int compare(OWLAxiom o1, OWLAxiom o2) {
            this.result = 0;
            o1.accept(this);
            int result1 = this.result;
            o2.accept(this);
            int result2 = this.result;
            int diff = result2 - result1;
            if (diff != 0) {
                return diff;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OWLAxiomPartExtractor
    extends OWLAxiomVisitorAdapter {
        private Set<OWLObject> rhs = new HashSet<OWLObject>();
        private Set<OWLObject> lhs = new HashSet<OWLObject>();

        public Set<OWLObject> getRHS() {
            return this.rhs;
        }

        public Set<OWLObject> getLHS() {
            return this.lhs;
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            this.rhs.add(axiom.getSuperClass());
            this.lhs.add(axiom.getSubClass());
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getObject());
            this.rhs.add((OWLObject)axiom.getProperty());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            this.rhs.addAll(axiom.getClassExpressions());
            this.lhs.addAll(axiom.getClassExpressions());
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            this.rhs.add(axiom.getDomain());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            this.rhs.add(axiom.getDomain());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            this.rhs.addAll(axiom.getProperties());
            this.lhs.addAll(axiom.getProperties());
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
            this.rhs.add((OWLObject)axiom.getObject());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            this.rhs.addAll(axiom.getIndividuals());
            this.lhs.addAll(axiom.getIndividuals());
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.rhs.addAll(axiom.getProperties());
            this.lhs.addAll(axiom.getProperties());
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            this.rhs.addAll(axiom.getProperties());
            this.lhs.addAll(axiom.getProperties());
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getRange());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
            this.rhs.add((OWLObject)axiom.getObject());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getSuperProperty());
            this.lhs.add((OWLObject)axiom.getSubProperty());
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            this.rhs.addAll(axiom.getClassExpressions());
            this.rhs.add(axiom.getOWLClass());
            this.lhs.add(axiom.getOWLClass());
            this.lhs.addAll(axiom.getClassExpressions());
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getRange());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            this.rhs.addAll(axiom.getProperties());
            this.lhs.addAll(axiom.getProperties());
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            this.rhs.add(axiom.getClassExpression());
            this.lhs.add(axiom.getIndividual());
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.rhs.addAll(axiom.getClassExpressions());
            this.lhs.addAll(axiom.getClassExpressions());
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getSuperProperty());
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            this.rhs.addAll(axiom.getIndividuals());
            this.lhs.addAll(axiom.getIndividuals());
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            this.rhs.add(axiom.getSuperProperty());
            this.lhs.addAll(axiom.getPropertyChain());
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.rhs.addAll(axiom.getProperties());
            this.lhs.addAll(axiom.getProperties());
        }

        @Override
        public void visit(SWRLRule rule) {
        }
    }
}

