/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.turtle.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.coode.owlapi.turtle.TurtleOntologyFormat;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserIOException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.ConsoleTripleHandler;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.OWLRDFConsumerAdapter;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.ParseException;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TripleHandler;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TurtleParser;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TurtleParserException;

public class TurtleOntologyParser
extends AbstractOWLParser {
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, UnloadableImportException, IOException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        try {
            TurtleParser parser = documentSource.isReaderAvailable() ? new TurtleParser(documentSource.getReader(), (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI().toString()) : (documentSource.isInputStreamAvailable() ? new TurtleParser(documentSource.getInputStream(), (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI().toString()) : new TurtleParser(new BufferedInputStream(documentSource.getDocumentIRI().toURI().toURL().openStream()), (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI().toString()));
            OWLRDFConsumerAdapter consumer = new OWLRDFConsumerAdapter(ontology, parser, configuration);
            parser.setTripleHandler(consumer);
            parser.parseDocument();
            TurtleOntologyFormat format = new TurtleOntologyFormat();
            DefaultPrefixManager prefixManager = parser.getPrefixManager();
            for (String prefixName : prefixManager.getPrefixNames()) {
                format.setPrefix(prefixName, prefixManager.getPrefix(prefixName));
            }
            return format;
        }
        catch (ParseException e) {
            throw new TurtleParserException(e);
        }
        catch (IOException e) {
            throw new OWLParserIOException(e);
        }
    }
}

