/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeListener;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeProgressListener;
import org.semanticweb.owlapi.model.OWLOntologyChangesVetoedListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyRenameException;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLOntologyStorer;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.model.UnloadableImportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface OWLOntologyManager
extends OWLOntologySetProvider {
    public OWLDataFactory getOWLDataFactory();

    @Override
    public Set<OWLOntology> getOntologies();

    public Set<OWLOntology> getOntologies(OWLAxiom var1);

    public Set<OWLOntology> getVersions(IRI var1);

    public boolean contains(IRI var1);

    public boolean contains(OWLOntologyID var1);

    public OWLOntology getOntology(IRI var1);

    public OWLOntology getOntology(OWLOntologyID var1);

    public OWLOntology getImportedOntology(OWLImportsDeclaration var1);

    public Set<OWLOntology> getDirectImports(OWLOntology var1);

    public Set<OWLOntology> getImports(OWLOntology var1);

    public Set<OWLOntology> getImportsClosure(OWLOntology var1);

    public List<OWLOntology> getSortedImportsClosure(OWLOntology var1);

    public List<OWLOntologyChange> applyChanges(List<? extends OWLOntologyChange> var1) throws OWLOntologyRenameException;

    public List<OWLOntologyChange> addAxioms(OWLOntology var1, Set<? extends OWLAxiom> var2);

    public List<OWLOntologyChange> addAxiom(OWLOntology var1, OWLAxiom var2);

    public List<OWLOntologyChange> removeAxiom(OWLOntology var1, OWLAxiom var2);

    public List<OWLOntologyChange> removeAxioms(OWLOntology var1, Set<? extends OWLAxiom> var2);

    public List<OWLOntologyChange> applyChange(OWLOntologyChange var1) throws OWLOntologyRenameException;

    public OWLOntology createOntology() throws OWLOntologyCreationException;

    public OWLOntology createOntology(Set<OWLAxiom> var1) throws OWLOntologyCreationException;

    public OWLOntology createOntology(Set<OWLAxiom> var1, IRI var2) throws OWLOntologyCreationException;

    public OWLOntology createOntology(IRI var1) throws OWLOntologyCreationException;

    public OWLOntology createOntology(OWLOntologyID var1) throws OWLOntologyCreationException;

    public OWLOntology createOntology(IRI var1, Set<OWLOntology> var2, boolean var3) throws OWLOntologyCreationException;

    public OWLOntology createOntology(IRI var1, Set<OWLOntology> var2) throws OWLOntologyCreationException;

    public OWLOntology loadOntology(IRI var1) throws OWLOntologyCreationException;

    public OWLOntology loadOntologyFromOntologyDocument(IRI var1) throws OWLOntologyCreationException;

    public OWLOntology loadOntologyFromOntologyDocument(File var1) throws OWLOntologyCreationException;

    public OWLOntology loadOntologyFromOntologyDocument(InputStream var1) throws OWLOntologyCreationException;

    public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource var1) throws OWLOntologyCreationException;

    public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource var1, OWLOntologyLoaderConfiguration var2) throws OWLOntologyCreationException;

    public void removeOntology(OWLOntology var1);

    public IRI getOntologyDocumentIRI(OWLOntology var1);

    public void setOntologyDocumentIRI(OWLOntology var1, IRI var2) throws UnknownOWLOntologyException;

    public OWLOntologyFormat getOntologyFormat(OWLOntology var1) throws UnknownOWLOntologyException;

    public void setOntologyFormat(OWLOntology var1, OWLOntologyFormat var2);

    public void saveOntology(OWLOntology var1) throws OWLOntologyStorageException;

    public void saveOntology(OWLOntology var1, IRI var2) throws OWLOntologyStorageException;

    public void saveOntology(OWLOntology var1, OutputStream var2) throws OWLOntologyStorageException;

    public void saveOntology(OWLOntology var1, OWLOntologyFormat var2) throws OWLOntologyStorageException;

    public void saveOntology(OWLOntology var1, OWLOntologyFormat var2, IRI var3) throws OWLOntologyStorageException;

    public void saveOntology(OWLOntology var1, OWLOntologyFormat var2, OutputStream var3) throws OWLOntologyStorageException;

    public void saveOntology(OWLOntology var1, OWLOntologyDocumentTarget var2) throws OWLOntologyStorageException;

    public void saveOntology(OWLOntology var1, OWLOntologyFormat var2, OWLOntologyDocumentTarget var3) throws OWLOntologyStorageException;

    public void addIRIMapper(OWLOntologyIRIMapper var1);

    public void removeIRIMapper(OWLOntologyIRIMapper var1);

    public void clearIRIMappers();

    public void addOntologyFactory(OWLOntologyFactory var1);

    public void removeOntologyFactory(OWLOntologyFactory var1);

    public Collection<OWLOntologyFactory> getOntologyFactories();

    public void addOntologyStorer(OWLOntologyStorer var1);

    public void removeOntologyStorer(OWLOntologyStorer var1);

    public void addOntologyChangeListener(OWLOntologyChangeListener var1);

    public void addOntologyChangeListener(OWLOntologyChangeListener var1, OWLOntologyChangeBroadcastStrategy var2);

    public void addImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener var1);

    public void removeImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener var1);

    public void addOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener var1);

    public void removeOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener var1);

    public void setDefaultChangeBroadcastStrategy(OWLOntologyChangeBroadcastStrategy var1);

    public void removeOntologyChangeListener(OWLOntologyChangeListener var1);

    @Deprecated
    public void makeLoadImportRequest(OWLImportsDeclaration var1) throws UnloadableImportException;

    public void makeLoadImportRequest(OWLImportsDeclaration var1, OWLOntologyLoaderConfiguration var2) throws UnloadableImportException;

    @Deprecated
    public void setSilentMissingImportsHandling(boolean var1);

    @Deprecated
    public boolean isSilentMissingImportsHandling();

    public void addMissingImportListener(MissingImportListener var1);

    public void removeMissingImportListener(MissingImportListener var1);

    public void addOntologyLoaderListener(OWLOntologyLoaderListener var1);

    public void removeOntologyLoaderListener(OWLOntologyLoaderListener var1);

    public void addOntologyChangeProgessListener(OWLOntologyChangeProgressListener var1);

    public void removeOntologyChangeProgessListener(OWLOntologyChangeProgressListener var1);
}

