/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectDuplicator
implements OWLObjectVisitor,
SWRLObjectVisitor {
    private OWLDataFactory dataFactory;
    private Object obj;
    private Map<OWLEntity, IRI> replacementMap;

    public OWLObjectDuplicator(OWLDataFactory dataFactory) {
        this(new HashMap<OWLEntity, IRI>(), dataFactory);
    }

    public OWLObjectDuplicator(OWLDataFactory dataFactory, Map<IRI, IRI> iriReplacementMap) {
        this.dataFactory = dataFactory;
        this.replacementMap = new HashMap<OWLEntity, IRI>();
        for (IRI iri : iriReplacementMap.keySet()) {
            IRI repIRI = iriReplacementMap.get(iri);
            this.replacementMap.put(dataFactory.getOWLClass(iri), repIRI);
            this.replacementMap.put(dataFactory.getOWLObjectProperty(iri), repIRI);
            this.replacementMap.put(dataFactory.getOWLDataProperty(iri), repIRI);
            this.replacementMap.put(dataFactory.getOWLNamedIndividual(iri), repIRI);
            this.replacementMap.put(dataFactory.getOWLDatatype(iri), repIRI);
            this.replacementMap.put(dataFactory.getOWLAnnotationProperty(iri), repIRI);
        }
    }

    public OWLObjectDuplicator(Map<OWLEntity, IRI> entityIRIReplacementMap, OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
        this.replacementMap = new HashMap<OWLEntity, IRI>(entityIRIReplacementMap);
    }

    public <O extends OWLObject> O duplicateObject(OWLObject object) {
        object.accept(this);
        return (O)((OWLObject)this.obj);
    }

    protected void setLastObject(Object obj) {
        this.obj = obj;
    }

    private IRI getIRI(OWLEntity entity) {
        IRI replacement = this.replacementMap.get(entity);
        if (replacement != null) {
            return replacement;
        }
        return entity.getIRI();
    }

    private Set<OWLAnnotation> duplicateAxiomAnnotations(OWLAxiom axiom) {
        HashSet<OWLAnnotation> duplicatedAnnos = new HashSet<OWLAnnotation>();
        for (OWLAnnotation anno : axiom.getAnnotations()) {
            anno.accept(this);
            duplicatedAnnos.add((OWLAnnotation)this.obj);
        }
        return duplicatedAnnos;
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.obj, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept(this);
        OWLIndividual ind = (OWLIndividual)this.obj;
        axiom.getClassExpression().accept(this);
        OWLClassExpression type = (OWLClassExpression)this.obj;
        this.obj = this.dataFactory.getOWLClassAssertionAxiom(type, ind, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual subj = (OWLIndividual)this.obj;
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLLiteral)axiom.getObject()).accept(this);
        OWLLiteral con = (OWLLiteral)this.obj;
        this.obj = this.dataFactory.getOWLDataPropertyAssertionAxiom(prop, subj, con, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        axiom.getDomain().accept(this);
        OWLClassExpression domain = (OWLClassExpression)this.obj;
        this.obj = this.dataFactory.getOWLDataPropertyDomainAxiom(prop, domain, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)axiom.getRange()).accept(this);
        OWLDataRange range = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataPropertyRangeAxiom(prop, range, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        OWLDataPropertyExpression subProp = (OWLDataPropertyExpression)this.obj;
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        OWLDataPropertyExpression supProp = (OWLDataPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLSubDataPropertyOfAxiom(subProp, supProp, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        axiom.getEntity().accept(this);
        OWLEntity ent = (OWLEntity)this.obj;
        this.obj = this.dataFactory.getOWLDeclarationAxiom(ent, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        Set<OWLIndividual> inds = this.duplicateSet(axiom.getIndividuals());
        this.obj = this.dataFactory.getOWLDifferentIndividualsAxiom(inds, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        Set<OWLClassExpression> descs = this.duplicateSet(axiom.getClassExpressions());
        this.obj = this.dataFactory.getOWLDisjointClassesAxiom(descs, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLDisjointDataPropertiesAxiom(props, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLDisjointObjectPropertiesAxiom(props, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        axiom.getOWLClass().accept(this);
        OWLClass cls = (OWLClass)this.obj;
        Set<OWLClassExpression> ops = this.duplicateSet(axiom.getClassExpressions());
        this.obj = this.dataFactory.getOWLDisjointUnionAxiom(cls, ops, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLAnnotationSubject subject = (OWLAnnotationSubject)this.obj;
        axiom.getProperty().accept(this);
        OWLAnnotationProperty prop = (OWLAnnotationProperty)this.obj;
        axiom.getValue().accept(this);
        OWLAnnotationValue value = (OWLAnnotationValue)this.obj;
        this.obj = this.dataFactory.getOWLAnnotationAssertionAxiom(prop, subject, value, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        Set<OWLClassExpression> descs = this.duplicateSet(axiom.getClassExpressions());
        this.obj = this.dataFactory.getOWLEquivalentClassesAxiom(descs, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLEquivalentDataPropertiesAxiom(props, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(props, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.obj, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.obj, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.obj, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        axiom.getFirstProperty().accept(this);
        OWLObjectPropertyExpression propA = (OWLObjectPropertyExpression)this.obj;
        axiom.getSecondProperty().accept(this);
        OWLObjectPropertyExpression propB = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLInverseObjectPropertiesAxiom(propA, propB, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.obj, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual ind = (OWLIndividual)this.obj;
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLLiteral)axiom.getObject()).accept(this);
        OWLLiteral con = (OWLLiteral)this.obj;
        this.obj = this.dataFactory.getOWLNegativeDataPropertyAssertionAxiom(prop, ind, con, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual ind = (OWLIndividual)this.obj;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLIndividual)axiom.getObject()).accept(this);
        OWLIndividual ind2 = (OWLIndividual)this.obj;
        this.obj = this.dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(prop, ind, ind2, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual ind = (OWLIndividual)this.obj;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLIndividual)axiom.getObject()).accept(this);
        OWLIndividual ind2 = (OWLIndividual)this.obj;
        this.obj = this.dataFactory.getOWLObjectPropertyAssertionAxiom(prop, ind, ind2, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        axiom.getSuperProperty().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression p : axiom.getPropertyChain()) {
            p.accept(this);
            chain.add((OWLObjectPropertyExpression)this.obj);
        }
        this.obj = this.dataFactory.getOWLSubPropertyChainOfAxiom(chain, prop, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        axiom.getDomain().accept(this);
        OWLClassExpression domain = (OWLClassExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectPropertyDomainAxiom(prop, domain, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLClassExpression)axiom.getRange()).accept(this);
        OWLClassExpression range = (OWLClassExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, range, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        OWLObjectPropertyExpression subProp = (OWLObjectPropertyExpression)this.obj;
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        OWLObjectPropertyExpression supProp = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLSubObjectPropertyOfAxiom(subProp, supProp, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        Set<OWLIndividual> individuals = this.duplicateSet(axiom.getIndividuals());
        this.obj = this.dataFactory.getOWLSameIndividualAxiom(individuals, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept(this);
        OWLClassExpression subClass = (OWLClassExpression)this.obj;
        axiom.getSuperClass().accept(this);
        OWLClassExpression supClass = (OWLClassExpression)this.obj;
        this.obj = this.dataFactory.getOWLSubClassOfAxiom(subClass, supClass, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLClass desc) {
        IRI uri = this.getIRI(desc);
        this.obj = this.dataFactory.getOWLClass(uri);
    }

    @Override
    public void visit(OWLDataAllValuesFrom desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataAllValuesFrom(prop, filler);
    }

    @Override
    public void visit(OWLDataExactCardinality desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataExactCardinality(desc.getCardinality(), prop, filler);
    }

    @Override
    public void visit(OWLDataMaxCardinality desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataMaxCardinality(desc.getCardinality(), prop, filler);
    }

    @Override
    public void visit(OWLDataMinCardinality desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataMinCardinality(desc.getCardinality(), prop, filler);
    }

    @Override
    public void visit(OWLDataSomeValuesFrom desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataSomeValuesFrom(prop, filler);
    }

    @Override
    public void visit(OWLDataHasValue desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLLiteral)desc.getValue()).accept(this);
        OWLLiteral val = (OWLLiteral)this.obj;
        this.obj = this.dataFactory.getOWLDataHasValue(prop, val);
    }

    @Override
    public void visit(OWLObjectAllValuesFrom desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLClassExpression)desc.getFiller()).accept(this);
        OWLClassExpression filler = (OWLClassExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectAllValuesFrom(prop, filler);
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        desc.getOperand().accept(this);
        OWLClassExpression op = (OWLClassExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectComplementOf(op);
    }

    @Override
    public void visit(OWLObjectExactCardinality desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLClassExpression)desc.getFiller()).accept(this);
        OWLClassExpression filler = (OWLClassExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectExactCardinality(desc.getCardinality(), prop, filler);
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        Set<OWLClassExpression> ops = this.duplicateSet(desc.getOperands());
        this.obj = this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    @Override
    public void visit(OWLObjectMaxCardinality desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLClassExpression)desc.getFiller()).accept(this);
        OWLClassExpression filler = (OWLClassExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectMaxCardinality(desc.getCardinality(), prop, filler);
    }

    @Override
    public void visit(OWLObjectMinCardinality desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLClassExpression)desc.getFiller()).accept(this);
        OWLClassExpression filler = (OWLClassExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectMinCardinality(desc.getCardinality(), prop, filler);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        Set<OWLIndividual> inds = this.duplicateSet(desc.getIndividuals());
        this.obj = this.dataFactory.getOWLObjectOneOf(inds);
    }

    @Override
    public void visit(OWLObjectHasSelf desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectHasSelf(prop);
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLClassExpression)desc.getFiller()).accept(this);
        OWLClassExpression filler = (OWLClassExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        Set<OWLClassExpression> ops = this.duplicateSet(desc.getOperands());
        this.obj = this.dataFactory.getOWLObjectUnionOf(ops);
    }

    @Override
    public void visit(OWLObjectHasValue desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLIndividual)desc.getValue()).accept(this);
        OWLIndividual value = (OWLIndividual)this.obj;
        this.obj = this.dataFactory.getOWLObjectHasValue(prop, value);
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        node.getDataRange().accept(this);
        OWLDataRange dr = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataComplementOf(dr);
    }

    @Override
    public void visit(OWLDataOneOf node) {
        Set<OWLLiteral> vals = this.duplicateSet(node.getValues());
        this.obj = this.dataFactory.getOWLDataOneOf(vals);
    }

    @Override
    public void visit(OWLDatatype node) {
        IRI iri = this.getIRI(node);
        this.obj = this.dataFactory.getOWLDatatype(iri);
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        node.getDatatype().accept(this);
        OWLDatatype dr = (OWLDatatype)this.obj;
        HashSet<OWLFacetRestriction> restrictions = new HashSet<OWLFacetRestriction>();
        for (OWLFacetRestriction restriction : node.getFacetRestrictions()) {
            restriction.accept(this);
            restrictions.add((OWLFacetRestriction)this.obj);
        }
        this.obj = this.dataFactory.getOWLDatatypeRestriction(dr, restrictions);
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        node.getFacetValue().accept(this);
        OWLLiteral val = (OWLLiteral)this.obj;
        this.obj = this.dataFactory.getOWLFacetRestriction(node.getFacet(), val);
    }

    @Override
    public void visit(OWLLiteral node) {
        node.getDatatype().accept(this);
        OWLDatatype dt = (OWLDatatype)this.obj;
        this.obj = node.hasLang() ? this.dataFactory.getOWLLiteral(node.getLiteral(), node.getLang()) : this.dataFactory.getOWLLiteral(node.getLiteral(), dt);
    }

    @Override
    public void visit(OWLDataProperty property) {
        IRI iri = this.getIRI(property);
        this.obj = this.dataFactory.getOWLDataProperty(iri);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        IRI iri = this.getIRI(property);
        this.obj = this.dataFactory.getOWLObjectProperty(iri);
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        property.getInverse().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectInverseOf(prop);
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        IRI iri = this.getIRI(individual);
        this.obj = this.dataFactory.getOWLNamedIndividual(iri);
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.obj = ontology;
    }

    @Override
    public void visit(SWRLRule rule) {
        HashSet<SWRLAtom> antecedents = new HashSet<SWRLAtom>();
        HashSet<SWRLAtom> consequents = new HashSet<SWRLAtom>();
        for (SWRLAtom atom : rule.getBody()) {
            atom.accept(this);
            antecedents.add((SWRLAtom)this.obj);
        }
        for (SWRLAtom atom : rule.getHead()) {
            atom.accept(this);
            consequents.add((SWRLAtom)this.obj);
        }
        this.obj = this.dataFactory.getSWRLRule(antecedents, consequents);
    }

    @Override
    public void visit(SWRLClassAtom node) {
        node.getPredicate().accept(this);
        OWLClassExpression desc = (OWLClassExpression)this.obj;
        ((SWRLIArgument)node.getArgument()).accept(this);
        SWRLIArgument atom = (SWRLIArgument)this.obj;
        this.obj = this.dataFactory.getSWRLClassAtom(desc, atom);
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        node.getPredicate().accept(this);
        OWLDataRange rng = (OWLDataRange)this.obj;
        ((SWRLDArgument)node.getArgument()).accept(this);
        SWRLDArgument atom = (SWRLDArgument)this.obj;
        this.obj = this.dataFactory.getSWRLDataRangeAtom(rng, atom);
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        node.getPredicate().accept(this);
        OWLObjectPropertyExpression exp = (OWLObjectPropertyExpression)this.obj;
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        SWRLIArgument arg0 = (SWRLIArgument)this.obj;
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        SWRLIArgument arg1 = (SWRLIArgument)this.obj;
        this.obj = this.dataFactory.getSWRLObjectPropertyAtom(exp, arg0, arg1);
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        node.getPredicate().accept(this);
        OWLDataPropertyExpression exp = (OWLDataPropertyExpression)this.obj;
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        SWRLIArgument arg0 = (SWRLIArgument)this.obj;
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
        SWRLDArgument arg1 = (SWRLDArgument)this.obj;
        this.obj = this.dataFactory.getSWRLDataPropertyAtom(exp, arg0, arg1);
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        ArrayList<SWRLDArgument> atomObjects = new ArrayList<SWRLDArgument>();
        for (SWRLDArgument atomObject : node.getArguments()) {
            atomObject.accept(this);
            atomObjects.add((SWRLDArgument)this.obj);
        }
        this.obj = this.dataFactory.getSWRLBuiltInAtom(node.getPredicate(), atomObjects);
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        SWRLIArgument arg0 = (SWRLIArgument)this.obj;
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        SWRLIArgument arg1 = (SWRLIArgument)this.obj;
        this.obj = this.dataFactory.getSWRLDifferentIndividualsAtom(arg0, arg1);
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        SWRLIArgument arg0 = (SWRLIArgument)this.obj;
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        SWRLIArgument arg1 = (SWRLIArgument)this.obj;
        this.obj = this.dataFactory.getSWRLSameIndividualAtom(arg0, arg1);
    }

    @Override
    public void visit(SWRLVariable variable) {
        variable.getIRI().accept(this);
        IRI iri = (IRI)this.obj;
        this.obj = this.dataFactory.getSWRLVariable(iri);
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
        OWLIndividual ind = (OWLIndividual)this.obj;
        this.obj = this.dataFactory.getSWRLIndividualArgument(ind);
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
        OWLLiteral con = (OWLLiteral)this.obj;
        this.obj = this.dataFactory.getSWRLLiteralArgument(con);
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        axiom.getClassExpression().accept(this);
        OWLClassExpression ce = (OWLClassExpression)this.obj;
        Set<OWLPropertyExpression<?, ?>> props = this.duplicateSet(axiom.getPropertyExpressions());
        this.obj = this.dataFactory.getOWLHasKeyAxiom(ce, props, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        Set<OWLDataRange> ranges = this.duplicateSet(node.getOperands());
        this.obj = this.dataFactory.getOWLDataIntersectionOf(ranges);
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        Set<OWLDataRange> ranges = this.duplicateSet(node.getOperands());
        this.obj = this.dataFactory.getOWLDataUnionOf(ranges);
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.obj = this.dataFactory.getOWLAnnotationProperty(this.getIRI(property));
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        axiom.getProperty().accept(this);
        OWLAnnotationProperty prop = (OWLAnnotationProperty)this.obj;
        axiom.getDomain().accept(this);
        IRI domain = (IRI)this.obj;
        this.obj = this.dataFactory.getOWLAnnotationPropertyDomainAxiom(prop, domain, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        axiom.getProperty().accept(this);
        OWLAnnotationProperty prop = (OWLAnnotationProperty)this.obj;
        axiom.getRange().accept(this);
        IRI range = (IRI)this.obj;
        this.obj = this.dataFactory.getOWLAnnotationPropertyRangeAxiom(prop, range, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        axiom.getSubProperty().accept(this);
        OWLAnnotationProperty sub = (OWLAnnotationProperty)this.obj;
        axiom.getSuperProperty().accept(this);
        OWLAnnotationProperty sup = (OWLAnnotationProperty)this.obj;
        this.obj = this.dataFactory.getOWLSubAnnotationPropertyOfAxiom(sub, sup, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(OWLAnnotation node) {
        node.getProperty().accept(this);
        OWLAnnotationProperty prop = (OWLAnnotationProperty)this.obj;
        node.getValue().accept(this);
        OWLAnnotationValue val = (OWLAnnotationValue)this.obj;
        this.obj = this.dataFactory.getOWLAnnotation(prop, val);
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.obj = individual;
    }

    @Override
    public void visit(IRI iri) {
        for (OWLEntity entity : this.replacementMap.keySet()) {
            if (!entity.getIRI().equals(iri)) continue;
            this.obj = this.replacementMap.get(entity);
            return;
        }
        this.obj = iri;
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        axiom.getDatatype().accept(this);
        OWLDatatype dt = (OWLDatatype)this.obj;
        axiom.getDataRange().accept(this);
        OWLDataRange rng = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDatatypeDefinitionAxiom(dt, rng, this.duplicateAxiomAnnotations(axiom));
    }

    private <O extends OWLObject> Set<O> duplicateSet(Set<O> objects) {
        HashSet<OWLObject> dup = new HashSet<OWLObject>();
        for (OWLObject o : objects) {
            o.accept(this);
            dup.add((OWLObject)this.obj);
        }
        return dup;
    }
}

