/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.FmtUtils;
import org.topbraid.shacl.arq.SHACLFunctionsCache;
import org.topbraid.shacl.model.SHACLConstraintComponent;
import org.topbraid.shacl.model.SHACLFunction;
import org.topbraid.shacl.model.SHACLParameter;
import org.topbraid.shacl.model.SHACLParameterizable;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;
import org.topbraid.spin.arq.SPINFunctionFactory;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.statistics.SPINStatisticsManager;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;

public class SHACLARQFunction
implements Function,
SPINFunctionFactory {
    private Query arqQuery;
    private boolean cachable;
    private List<String> paramNames = new ArrayList<String>();
    private String queryString;
    private SHACLFunction shaclFunction;

    public SHACLARQFunction(SHACLConstraintComponent component, Resource askValidator) {
        try {
            this.queryString = JenaUtil.getStringProperty(askValidator, SH.sparql);
            this.arqQuery = ARQFactory.get().createQuery(askValidator.getModel(), this.queryString);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Function " + this.shaclFunction.getURI() + " does not define a valid body", ex);
        }
        if (!this.arqQuery.isAskType()) {
            throw new ExprEvalException("Body must be ASK query");
        }
        this.paramNames.add("value");
        this.addParameters(component);
        this.paramNames.add("shapesGraph");
    }

    public SHACLARQFunction(SHACLFunction shaclFunction) {
        this.shaclFunction = shaclFunction;
        this.cachable = shaclFunction.hasProperty(DASH.cachable, (RDFNode)JenaDatatypes.TRUE);
        try {
            this.queryString = shaclFunction.getSPARQL();
            this.arqQuery = ARQFactory.get().createQuery(shaclFunction.getModel(), this.queryString);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Function " + shaclFunction.getURI() + " does not define a valid body", ex);
        }
        if (!this.arqQuery.isAskType() && !this.arqQuery.isSelectType()) {
            throw new ExprEvalException("Body must be ASK or SELECT query");
        }
        this.addParameters(shaclFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addParameters(SHACLParameterizable parameterizable) {
        JenaUtil.setGraphReadOptimization(true);
        try {
            for (SHACLParameter param : parameterizable.getOrderedParameters()) {
                String varName = param.getVarName();
                if (varName == null) {
                    throw new IllegalStateException("Parameter " + param + " of " + parameterizable + " does not have a valid predicate");
                }
                this.paramNames.add(varName);
            }
        }
        finally {
            JenaUtil.setGraphReadOptimization(false);
        }
    }

    public void build(String uri, ExprList args) {
    }

    public Function create(String uri) {
        return this;
    }

    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        Graph activeGraph = env.getActiveGraph();
        Model model = activeGraph != null ? ModelFactory.createModelForGraph((Graph)activeGraph) : ModelFactory.createDefaultModel();
        QuerySolutionMap bindings = new QuerySolutionMap();
        Node[] paramsForCache = this.cachable ? new Node[args.size()] : null;
        for (int i = 0; i < args.size(); ++i) {
            NodeValue x;
            Expr expr = args.get(i);
            if (expr == null || expr.isVariable() && !binding.contains(expr.asVar()) || (x = expr.eval(binding, env)) == null) continue;
            String paramName = i < this.paramNames.size() ? this.paramNames.get(i) : "arg" + (i + 1);
            bindings.add(paramName, model.asRDFNode(x.asNode()));
            if (!this.cachable) continue;
            paramsForCache[i] = x.asNode();
        }
        Dataset dataset = DatasetImpl.wrap((DatasetGraph)env.getDataset());
        if (SPINStatisticsManager.get().isRecording() && SPINStatisticsManager.get().isRecordingSPINFunctions()) {
            NodeValue result;
            StringBuffer sb = new StringBuffer();
            sb.append("SHACL Function ");
            sb.append(SSE.format((Node)NodeFactory.createURI((String)uri), (PrefixMapping)model));
            sb.append("(");
            for (int i = 0; i < args.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                Expr expr = args.get(i);
                if ((expr = Substitute.substitute((Expr)expr, (Binding)binding)) == null) {
                    sb.append("?unbound");
                    continue;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IndentedWriter iOut = new IndentedWriter((OutputStream)bos);
                ExprUtils.fmtSPARQL((IndentedWriter)iOut, (Expr)expr, (SerializationContext)new SerializationContext((PrefixMapping)model));
                iOut.flush();
                sb.append(bos.toString());
            }
            sb.append(")");
            long startTime = System.currentTimeMillis();
            try {
                result = this.cachable ? SHACLFunctionsCache.get().execute(this, dataset, model, (QuerySolution)bindings, paramsForCache) : this.executeBody(dataset, model, (QuerySolution)bindings);
                sb.append(" = ");
                sb.append(FmtUtils.stringForNode((Node)result.asNode(), (PrefixMapping)model));
            }
            catch (ExprEvalException ex) {
                sb.append(" : ");
                sb.append(ex.getLocalizedMessage());
                throw ex;
            }
            finally {
                long endTime = System.currentTimeMillis();
                SPINStatistics stats = new SPINStatistics(sb.toString(), this.queryString, endTime - startTime, startTime, NodeFactory.createURI((String)uri));
                SPINStatisticsManager.get().addSilently(Collections.singleton(stats));
            }
            return result;
        }
        if (this.cachable) {
            return SHACLFunctionsCache.get().execute(this, dataset, model, (QuerySolution)bindings, paramsForCache);
        }
        return this.executeBody(dataset, model, (QuerySolution)bindings);
    }

    public NodeValue executeBody(Model model, QuerySolution bindings) {
        return this.executeBody(null, model, bindings);
    }

    private QueryExecution createQueryExecution(Dataset dataset, Model defaultModel, QuerySolution bindings) {
        if (dataset == null) {
            return ARQFactory.get().createQueryExecution(this.arqQuery, defaultModel, bindings);
        }
        DatasetWithDifferentDefaultModel newDataset = new DatasetWithDifferentDefaultModel(defaultModel, dataset);
        return ARQFactory.get().createQueryExecution(this.arqQuery, newDataset, bindings);
    }

    public NodeValue executeBody(Dataset dataset, Model defaultModel, QuerySolution bindings) {
        Throwable throwable = null;
        try (QueryExecution qexec = this.createQueryExecution(dataset, defaultModel, bindings);){
            List resultVars;
            String varName;
            QuerySolution s;
            RDFNode resultNode;
            if (this.arqQuery.isAskType()) {
                boolean result = qexec.execAsk();
                NodeValue nodeValue = NodeValue.makeBoolean((boolean)result);
                return nodeValue;
            }
            ResultSet rs = qexec.execSelect();
            if (rs.hasNext() && (resultNode = (s = rs.nextSolution()).get(varName = (String)(resultVars = rs.getResultVars()).get(0))) != null) {
                NodeValue nodeValue = NodeValue.makeNode((Node)resultNode.asNode());
                return nodeValue;
            }
            try {
                throw new ExprEvalException("Empty result set for SHACL function");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Query getBodyQuery() {
        return this.arqQuery;
    }

    public SHACLFunction getSHACLFunction() {
        return this.shaclFunction;
    }

    public String[] getParamNames() {
        return this.paramNames.toArray(new String[0]);
    }
}

