/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.topbraid.shacl.arq.SHACLARQFunction;
import org.topbraid.shacl.model.SHACLConstraintComponent;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.SPINFunctionDrivers;
import org.topbraid.spin.arq.SPINFunctionFactory;
import org.topbraid.spin.util.JenaUtil;

public class SHACLFunctions {
    public static void registerFunction(Resource resource) {
        SPINFunctionFactory arqFunction = SPINFunctionDrivers.get().create(resource);
        if (arqFunction != null) {
            FunctionRegistry.get().put(resource.getURI(), (FunctionFactory)arqFunction);
        }
    }

    public static void registerFunctions(Model model) {
        Resource shaclFunctionClass = SH.Function.inModel(model);
        for (Resource resource : JenaUtil.getAllInstances(shaclFunctionClass)) {
            if (!resource.isURIResource()) continue;
            SHACLFunctions.registerFunction(resource);
        }
        Resource ccClass = SH.ConstraintComponent.inModel(model);
        for (Resource resource : JenaUtil.getAllInstances(ccClass)) {
            SHACLFunctions.perhapsRegisterFunction((SHACLConstraintComponent)resource.as(SHACLConstraintComponent.class), SH.nodeValidator);
            SHACLFunctions.perhapsRegisterFunction((SHACLConstraintComponent)resource.as(SHACLConstraintComponent.class), SH.propertyValidator);
            SHACLFunctions.perhapsRegisterFunction((SHACLConstraintComponent)resource.as(SHACLConstraintComponent.class), SH.inversePropertyValidator);
        }
    }

    private static void perhapsRegisterFunction(SHACLConstraintComponent component, Property predicate) {
        for (Resource validator : JenaUtil.getResourceProperties(component, predicate)) {
            SHACLARQFunction arqFunction;
            if (!validator.isURIResource() || FunctionRegistry.get().isRegistered(validator.getURI()) || !JenaUtil.hasIndirectType(validator, SH.SPARQLAskValidator) || (arqFunction = new SHACLARQFunction(component, validator)) == null) continue;
            FunctionRegistry.get().put(validator.getURI(), (FunctionFactory)arqFunction);
        }
    }
}

