/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq.functions;

import java.net.URI;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.shacl.arq.functions.SHACLRecursionGuard;
import org.topbraid.shacl.constraints.AbstractConstraintValidator;
import org.topbraid.shacl.constraints.FailureLog;
import org.topbraid.shacl.constraints.ResourceConstraintValidator;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.AbstractFunction4;
import org.topbraid.spin.util.JenaDatatypes;

public class HasShapeFunction
extends AbstractFunction4 {
    private static ThreadLocal<Boolean> recursionIsErrorFlag = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NodeValue exec(Node resourceNode, Node shapeNode, Node shapesGraphNode, Node recursionIsError, FunctionEnv env) {
        Boolean oldFlag = recursionIsErrorFlag.get();
        if (JenaDatatypes.TRUE.asNode().equals((Object)recursionIsError)) {
            recursionIsErrorFlag.set(true);
        }
        try {
            NodeValue nodeValue;
            if (SHACLRecursionGuard.start(resourceNode, shapeNode)) {
                if (JenaDatatypes.TRUE.asNode().equals((Object)recursionIsError) || oldFlag != null && oldFlag.booleanValue()) {
                    String message = "Unsupported recursion";
                    Model resultsModel = AbstractConstraintValidator.getCurrentResultsModel();
                    if (resultsModel != null) {
                        Resource failure = resultsModel.createResource(DASH.FailureResult);
                        failure.addProperty(SH.message, message);
                        failure.addProperty(SH.focusNode, resultsModel.asRDFNode(resourceNode));
                        failure.addProperty(SH.sourceShape, resultsModel.asRDFNode(shapeNode));
                    }
                    FailureLog.get().logFailure(message);
                    throw new ExprEvalException("Unsupported recursion");
                }
                SHACLRecursionGuard.end(resourceNode, shapeNode);
                NodeValue message = NodeValue.TRUE;
                return message;
            }
            try {
                Model model = ModelFactory.createModelForGraph((Graph)env.getActiveGraph());
                RDFNode resource = model.asRDFNode(resourceNode);
                Dataset dataset = DatasetImpl.wrap((DatasetGraph)env.getDataset());
                Resource shape = (Resource)dataset.getDefaultModel().asRDFNode(shapeNode);
                Model results = this.doRun(resource, shape, dataset, shapesGraphNode);
                if (results.contains(null, RDF.type, (RDFNode)DASH.FailureResult)) {
                    throw new ExprEvalException("Propagating failure from nested shapes");
                }
                nodeValue = NodeValue.makeBoolean((boolean)results.isEmpty());
            }
            catch (Throwable throwable) {
                SHACLRecursionGuard.end(resourceNode, shapeNode);
                throw throwable;
            }
            SHACLRecursionGuard.end(resourceNode, shapeNode);
            return nodeValue;
        }
        finally {
            recursionIsErrorFlag.set(oldFlag);
        }
    }

    protected Model doRun(RDFNode resource, Resource shape, Dataset dataset, Node shapesGraphNode) {
        return ResourceConstraintValidator.get().validateNodeAgainstShape(dataset, URI.create(shapesGraphNode.getURI()), resource.asNode(), shape.asNode(), SH.Violation, null);
    }
}

