/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq.functions;

import java.util.HashSet;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterExtendByVar;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.topbraid.shacl.util.SHACLUtil;

public class ScopeContainsPFunction
extends PropertyFunctionBase {
    public static final String URI = "http://topbraid.org/shacl/tbsh#scopeContains";

    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        argSubject = Substitute.substitute((PropFuncArg)argSubject, (Binding)binding);
        if (!(argObject = Substitute.substitute((PropFuncArg)argObject, (Binding)binding)).getArg().isVariable()) {
            throw new ExprEvalException("Right hand side http://topbraid.org/shacl/tbsh#scopeContains must be a variable");
        }
        Node scopeNode = (Node)argSubject.getArgList().get(0);
        Node shapesGraphNode = (Node)argSubject.getArgList().get(1);
        Dataset dataset = DatasetImpl.wrap((DatasetGraph)execCxt.getDataset());
        Model model = dataset.getNamedModel(shapesGraphNode.getURI());
        Resource scope = (Resource)model.asRDFNode(scopeNode);
        HashSet<Node> focusNodes = new HashSet<Node>();
        SHACLUtil.addNodesInScope(scope, dataset, focusNodes);
        return new QueryIterExtendByVar(binding, (Var)argObject.getArg(), focusNodes.iterator(), execCxt);
    }
}

