/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.constraints;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.constraints.ConstraintExecutable;
import org.topbraid.shacl.constraints.ExecutionLanguage;
import org.topbraid.shacl.constraints.ValidationListener;

public class AbstractConstraintValidator {
    private static ThreadLocal<Model> currentResultsModel = new ThreadLocal();
    private List<ValidationListener> listeners = new ArrayList<ValidationListener>();
    private Model oldResultsModel;

    public static Model getCurrentResultsModel() {
        return currentResultsModel.get();
    }

    protected void setCurrentResultsModel(Model value) {
        if (value != null) {
            currentResultsModel.set(value);
        } else {
            currentResultsModel.remove();
        }
    }

    public void addValidationListener(ValidationListener listener) {
        this.listeners.add(listener);
    }

    protected void notifyValidationFinished(Resource shape, ConstraintExecutable executable, RDFNode focusNode, ExecutionLanguage lang, Model results) {
        for (ValidationListener listener : this.listeners) {
            listener.validationFinished(shape, executable, focusNode, lang, results);
        }
        if (this.oldResultsModel != null) {
            currentResultsModel.set(this.oldResultsModel);
        } else {
            currentResultsModel.remove();
        }
    }

    protected void notifyValidationStarting(Resource shape, ConstraintExecutable executable, RDFNode focusNode, ExecutionLanguage lang, Model results) {
        this.oldResultsModel = currentResultsModel.get();
        currentResultsModel.set(results);
        for (ValidationListener listener : this.listeners) {
            listener.validationStarting(shape, executable, focusNode, lang, results);
        }
    }

    public void removeValidationListener(ValidationListener listener) {
        this.listeners.remove(listener);
    }
}

