/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.constraints;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.constraints.ConstraintExecutable;
import org.topbraid.shacl.model.SHACLConstraintComponent;
import org.topbraid.shacl.model.SHACLFactory;
import org.topbraid.shacl.model.SHACLParameter;
import org.topbraid.shacl.model.SHACLParameterizableConstraint;
import org.topbraid.shacl.model.SHACLShape;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.util.JenaUtil;

public class ComponentConstraintExecutable
extends ConstraintExecutable {
    private SHACLConstraintComponent component;
    private SHACLParameterizableConstraint constraint;
    private RDFNode parameterValue;

    public ComponentConstraintExecutable(SHACLParameterizableConstraint constraint, SHACLConstraintComponent component) {
        super(constraint);
        this.constraint = constraint;
        this.component = component;
    }

    public ComponentConstraintExecutable(SHACLParameterizableConstraint constraint, SHACLConstraintComponent component, RDFNode parameterValue) {
        this(constraint, component);
        this.parameterValue = parameterValue;
    }

    public void addBindings(QuerySolutionMap map) {
        if (SHACLFactory.isPropertyConstraint(this.constraint) || SHACLFactory.isInversePropertyConstraint(this.constraint) || SHACLFactory.isParameter(this.constraint)) {
            Resource predicate = JenaUtil.getResourceProperty(this.constraint, SH.predicate);
            String varName = SH.predicateVar.getVarName();
            if (predicate != null && !map.contains(varName)) {
                map.add(varName, (RDFNode)predicate);
            }
        }
        List<SHACLParameter> params = this.getComponent().getParameters();
        if (this.parameterValue != null) {
            SHACLParameter param = params.get(0);
            if (!map.contains(param.getVarName())) {
                map.add(param.getVarName(), this.parameterValue);
            }
        } else {
            Map<String, SHACLParameter> args = this.getComponent().getParametersMap();
            for (String varName : args.keySet()) {
                SHACLParameter param;
                RDFNode parameterValue;
                if (map.contains(varName) || (parameterValue = JenaUtil.getProperty(this.constraint, (param = args.get(varName)).getPredicate())) == null) continue;
                map.add(varName, parameterValue);
            }
        }
    }

    public SHACLConstraintComponent getComponent() {
        return this.component;
    }

    @Override
    public List<SHACLShape> getFilterShapes() {
        LinkedList<SHACLShape> results = new LinkedList<SHACLShape>();
        for (Resource scope : JenaUtil.getResourceProperties(this.constraint, SH.filterShape)) {
            results.add(SHACLFactory.asShape((RDFNode)scope));
        }
        return results;
    }

    @Override
    public List<Literal> getMessages() {
        Resource validator = this.getValidator();
        if (validator != null) {
            return JenaUtil.getLiteralProperties(validator, SH.message);
        }
        return Collections.emptyList();
    }

    public RDFNode getParameterValue() {
        return this.parameterValue;
    }

    @Override
    public Resource getSeverity() {
        Resource override = JenaUtil.getResourceProperty(this.constraint, SH.severity);
        if (override != null) {
            return override;
        }
        return super.getSeverity();
    }

    public Resource getValidator() {
        if (SHACLFactory.isNodeConstraint(this.constraint)) {
            return JenaUtil.getResourceProperty(this.component, SH.nodeValidator);
        }
        if (SHACLFactory.isInversePropertyConstraint(this.constraint)) {
            return JenaUtil.getResourceProperty(this.component, SH.inversePropertyValidator);
        }
        return JenaUtil.getResourceProperty(this.component, SH.propertyValidator);
    }

    public boolean isComplete() {
        for (SHACLParameter param : this.component.getParameters()) {
            if (param.isOptional() || this.constraint.hasProperty(param.getPredicate())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return SPINLabels.get().getLabel(this.component);
    }
}

