/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.constraints;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.constraints.ConstraintExecutable;
import org.topbraid.shacl.constraints.ExecutionLanguage;
import org.topbraid.shacl.constraints.FallbackExecutionLanguage;
import org.topbraid.shacl.constraints.sparql.SPARQLExecutionLanguage;

public class ExecutionLanguageSelector {
    private static ExecutionLanguageSelector singleton = new ExecutionLanguageSelector();
    private final List<ExecutionLanguage> languages = new LinkedList<ExecutionLanguage>();

    public static ExecutionLanguageSelector get() {
        return singleton;
    }

    public ExecutionLanguageSelector() {
        this.languages.add(SPARQLExecutionLanguage.get());
        this.languages.add(new FallbackExecutionLanguage());
    }

    public void addLanguage(ExecutionLanguage language) {
        this.languages.add(1, language);
    }

    public ExecutionLanguage getLanguageForConstraint(ConstraintExecutable executable) {
        for (ExecutionLanguage lang : this.languages) {
            if (!lang.canExecuteConstraint(executable)) continue;
            return lang;
        }
        return null;
    }

    public ExecutionLanguage getLanguageForScope(Resource executable) {
        for (ExecutionLanguage lang : this.languages) {
            if (!lang.canExecuteScope(executable)) continue;
            return lang;
        }
        return null;
    }
}

