/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.constraints;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.constraints.AbstractConstraintValidator;
import org.topbraid.shacl.constraints.ConstraintExecutable;
import org.topbraid.shacl.constraints.ExecutionLanguage;
import org.topbraid.shacl.constraints.ExecutionLanguageSelector;
import org.topbraid.shacl.model.SHACLConstraint;
import org.topbraid.shacl.model.SHACLFactory;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.progress.ProgressMonitor;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.util.JenaUtil;

public class ModelConstraintValidator
extends AbstractConstraintValidator {
    public static final String FILTER_VAR_NAME = "FILTER_SHAPE";
    private static ModelConstraintValidator singleton = new ModelConstraintValidator();

    public static ModelConstraintValidator get() {
        return singleton;
    }

    public static void set(ModelConstraintValidator value) {
        singleton = value;
    }

    public Model validateModel(Dataset dataset, URI shapesGraphURI, Resource minSeverity, boolean validateShapes, ProgressMonitor monitor) throws InterruptedException {
        if (dataset.getDefaultModel() == null) {
            throw new IllegalArgumentException("Dataset requires a default model");
        }
        Model shapesModel = dataset.getNamedModel(shapesGraphURI.toString());
        if (monitor != null) {
            monitor.subTask("Preparing execution plan");
        }
        List<Property> constraintProperties = SHACLUtil.getAllConstraintProperties(validateShapes);
        Map<Resource, List<SHACLConstraint>> map = this.buildShape2ConstraintsMap(shapesModel, dataset.getDefaultModel(), constraintProperties, validateShapes);
        if (monitor != null) {
            monitor.subTask("");
        }
        if (monitor != null) {
            monitor.beginTask("Validating constraints for " + map.size() + " shapes...", map.size());
        }
        Model results = JenaUtil.createMemoryModel();
        for (Resource shape : map.keySet()) {
            for (SHACLConstraint constraint : map.get(shape)) {
                this.validateConstraintForShape(dataset, shapesGraphURI, minSeverity, constraint, shape, results, monitor);
                if (monitor == null) continue;
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        return results;
    }

    private Map<Resource, List<SHACLConstraint>> buildShape2ConstraintsMap(Model shapesModel, Model dataModel, List<Property> constraintProperties, boolean validateShapes) {
        HashMap<Resource, List<SHACLConstraint>> map = new HashMap<Resource, List<SHACLConstraint>>();
        for (Property constraintProperty : constraintProperties) {
            for (Statement s : shapesModel.listStatements(null, constraintProperty, (RDFNode)null).toList()) {
                Resource c;
                Resource type;
                Resource shape;
                if (!s.getObject().isResource() || !this.hasScope(shape = s.getSubject(), dataModel, validateShapes)) continue;
                LinkedList<SHACLConstraint> list = (LinkedList<SHACLConstraint>)map.get(shape);
                if (list == null) {
                    list = new LinkedList<SHACLConstraint>();
                    map.put(shape, list);
                }
                if ((type = JenaUtil.getType(c = s.getResource())) == null) {
                    type = SHACLUtil.getResourceDefaultType(c);
                }
                if (type == null) continue;
                if (JenaUtil.hasIndirectType(c, SH.SPARQLConstraint)) {
                    list.add(SHACLFactory.asSPARQLConstraint((RDFNode)c));
                    continue;
                }
                if (!JenaUtil.hasSuperClass(type, SH.Constraint) || !SH.constraint.equals(constraintProperty) && !c.hasProperty(SH.predicate)) continue;
                list.add(SHACLFactory.asParameterizableConstraint((RDFNode)c));
            }
        }
        return map;
    }

    private boolean hasScope(Resource shape, Model dataModel, boolean validateShapes) {
        if (JenaUtil.hasIndirectType(shape, RDFS.Class)) {
            return true;
        }
        if (shape.hasProperty(SH.scope)) {
            return true;
        }
        if (shape.hasProperty(SH.scopeClass)) {
            return true;
        }
        if (shape.hasProperty(SH.scopeNode)) {
            return true;
        }
        return validateShapes && shape.hasProperty(SH.context);
    }

    private void validateConstraintForShape(Dataset dataset, URI shapesGraphURI, Resource minSeverity, SHACLConstraint constraint, Resource shape, Model results, ProgressMonitor monitor) {
        for (ConstraintExecutable executable : constraint.getExecutables()) {
            Resource severity = executable.getSeverity();
            if (!SHACLUtil.hasMinSeverity(severity, minSeverity)) continue;
            if (monitor != null) {
                monitor.subTask("Validating Shape " + SPINLabels.get().getLabel(shape));
            }
            ExecutionLanguage lang = ExecutionLanguageSelector.get().getLanguageForConstraint(executable);
            this.notifyValidationStarting(shape, executable, null, lang, results);
            lang.executeConstraint(dataset, shape, shapesGraphURI, executable, null, results);
            this.notifyValidationFinished(shape, executable, null, lang, results);
        }
    }
}

