/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.constraints;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.shacl.constraints.AbstractConstraintValidator;
import org.topbraid.shacl.constraints.ConstraintExecutable;
import org.topbraid.shacl.constraints.ExecutionLanguage;
import org.topbraid.shacl.constraints.ExecutionLanguageSelector;
import org.topbraid.shacl.model.SHACLConstraint;
import org.topbraid.shacl.model.SHACLFactory;
import org.topbraid.shacl.model.SHACLParameterizableScope;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.progress.ProgressMonitor;
import org.topbraid.spin.util.JenaUtil;

public class ResourceConstraintValidator
extends AbstractConstraintValidator {
    private static ResourceConstraintValidator singleton = new ResourceConstraintValidator();

    public static ResourceConstraintValidator get() {
        return singleton;
    }

    public static void set(ResourceConstraintValidator value) {
        singleton = value;
    }

    public Set<Resource> getShapesForResource(Resource resource, Dataset dataset, Model shapesModel) {
        HashSet<Resource> shapes = new HashSet<Resource>();
        shapes.addAll(shapesModel.listSubjectsWithProperty(SH.scopeNode, (RDFNode)resource).toList());
        for (Resource type : JenaUtil.getAllTypes(resource)) {
            if (JenaUtil.hasIndirectType(type.inModel(shapesModel), SH.Shape)) {
                shapes.add(type);
            }
            for (Statement s : shapesModel.listStatements(null, SH.scopeClass, (RDFNode)type).toList()) {
                shapes.add(s.getSubject());
            }
            for (Statement s : shapesModel.listStatements(null, SH.context, (RDFNode)type).toList()) {
                shapes.add(s.getSubject());
            }
        }
        for (Statement s : shapesModel.listStatements(null, SH.scope, (RDFNode)null).toList()) {
            if (!this.isInScope(resource, dataset, s.getResource())) continue;
            shapes.add(s.getSubject());
        }
        return shapes;
    }

    public Model validateNode(Dataset dataset, URI shapesGraphURI, Node focusNode, Resource minSeverity, ProgressMonitor monitor) throws InterruptedException {
        Model results = JenaUtil.createMemoryModel();
        Model shapesModel = dataset.getNamedModel(shapesGraphURI.toString());
        List<Property> properties = SHACLUtil.getAllConstraintProperties(true);
        Resource resource = (Resource)dataset.getDefaultModel().asRDFNode(focusNode);
        Set<Resource> shapes = this.getShapesForResource(resource, dataset, shapesModel);
        for (Resource shape : shapes) {
            if (monitor != null && monitor.isCanceled()) {
                throw new InterruptedException();
            }
            this.addResourceViolations(dataset, shapesGraphURI, focusNode, shape.asNode(), properties, minSeverity, results, monitor);
        }
        return results;
    }

    public Model validateNodeAgainstShape(Dataset dataset, URI shapesGraphURI, Node focusNode, Node shape, Resource minSeverity, ProgressMonitor monitor) {
        Model results = JenaUtil.createMemoryModel();
        Model oldResults = ResourceConstraintValidator.getCurrentResultsModel();
        this.setCurrentResultsModel(results);
        this.addResourceViolations(dataset, shapesGraphURI, focusNode, shape, SHACLUtil.getAllConstraintProperties(true), minSeverity, results, monitor);
        this.setCurrentResultsModel(oldResults);
        return results;
    }

    private void addQueryResults(Model results, SHACLConstraint constraint, Resource shape, RDFNode focusNode, Dataset dataset, URI shapesGraphURI, Resource minSeverity, ProgressMonitor monitor) {
        for (ConstraintExecutable executable : constraint.getExecutables()) {
            Resource severity = executable.getSeverity();
            if (!SHACLUtil.hasMinSeverity(severity, minSeverity)) continue;
            ExecutionLanguage lang = ExecutionLanguageSelector.get().getLanguageForConstraint(executable);
            this.notifyValidationStarting(shape, executable, focusNode, lang, results);
            lang.executeConstraint(dataset, shape, shapesGraphURI, executable, focusNode, results);
            this.notifyValidationFinished(shape, executable, focusNode, lang, results);
        }
    }

    private void addResourceViolations(Dataset dataset, URI shapesGraphURI, Node resourceNode, Node shapeNode, List<Property> constraintProperties, Resource minSeverity, Model results, ProgressMonitor monitor) {
        RDFNode resource = dataset.getDefaultModel().asRDFNode(resourceNode);
        Model shapesModel = dataset.getNamedModel(shapesGraphURI.toString());
        Resource shape = (Resource)shapesModel.asRDFNode(shapeNode);
        for (Property constraintProperty : constraintProperties) {
            for (Resource c : JenaUtil.getResourceProperties(shape, constraintProperty)) {
                SHACLConstraint constraint;
                if (c.hasProperty(RDF.type, (RDFNode)SH.SPARQLConstraint)) {
                    constraint = SHACLFactory.asSPARQLConstraint((RDFNode)c);
                    this.addQueryResults(results, constraint, shape, resource, dataset, shapesGraphURI, minSeverity, monitor);
                    continue;
                }
                if (!SHACLFactory.isParameterizableConstraint((RDFNode)c)) continue;
                constraint = SHACLFactory.asParameterizableConstraint((RDFNode)c);
                this.addQueryResults(results, constraint, shape, resource, dataset, shapesGraphURI, minSeverity, monitor);
            }
        }
    }

    private boolean isInScope(Resource focusNode, Dataset dataset, Resource scope) {
        SHACLParameterizableScope parameterizableScope = null;
        Resource executable = scope;
        if (SHACLFactory.isParameterizableInstance((RDFNode)scope)) {
            parameterizableScope = SHACLFactory.asParameterizableScope((RDFNode)scope);
            executable = parameterizableScope.getParameterizable();
        }
        ExecutionLanguage lang = ExecutionLanguageSelector.get().getLanguageForScope(executable);
        return lang.isNodeInScope((RDFNode)focusNode, dataset, executable, parameterizableScope);
    }
}

