/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.constraints;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.constraints.ComponentConstraintExecutable;
import org.topbraid.shacl.constraints.ConstraintExecutable;
import org.topbraid.shacl.constraints.ExecutionLanguage;
import org.topbraid.shacl.constraints.ValidationListener;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.util.JenaUtil;

public class SuccessRecordingValidationListener
implements ValidationListener {
    private Model model = JenaUtil.createMemoryModel();
    private long oldSize;

    public Model getResults() {
        return this.model;
    }

    @Override
    public void validationFinished(Resource shape, ConstraintExecutable executable, RDFNode focusNode, ExecutionLanguage lang, Model results) {
        if (results.size() == this.oldSize) {
            Resource success = this.model.createResource(DASH.SuccessResult);
            success.addProperty(SH.sourceShape, (RDFNode)shape);
            success.addProperty(SH.sourceConstraint, (RDFNode)executable.getConstraint());
            if (executable instanceof ComponentConstraintExecutable) {
                success.addProperty(SH.sourceConstraintComponent, (RDFNode)((ComponentConstraintExecutable)executable).getComponent());
            }
            if (focusNode != null) {
                success.addProperty(SH.focusNode, focusNode);
            }
        }
    }

    @Override
    public void validationStarting(Resource shape, ConstraintExecutable executable, RDFNode focusNode, ExecutionLanguage lang, Model results) {
        this.oldSize = results.size();
    }
}

