/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.constraints.sparql;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.shacl.constraints.ComponentConstraintExecutable;
import org.topbraid.shacl.constraints.ConstraintExecutable;
import org.topbraid.shacl.constraints.ExecutionLanguage;
import org.topbraid.shacl.constraints.FailureLog;
import org.topbraid.shacl.constraints.SHACLException;
import org.topbraid.shacl.constraints.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.model.SHACLConstraint;
import org.topbraid.shacl.model.SHACLFactory;
import org.topbraid.shacl.model.SHACLParameterizableScope;
import org.topbraid.shacl.model.SHACLShape;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.statistics.SPINStatisticsManager;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;

public class SPARQLExecutionLanguage
implements ExecutionLanguage {
    private static SPARQLExecutionLanguage singleton = new SPARQLExecutionLanguage();

    public static SPARQLExecutionLanguage get() {
        return singleton;
    }

    @Override
    public boolean canExecuteConstraint(ConstraintExecutable executable) {
        if (JenaUtil.hasIndirectType(executable.getConstraint(), SH.SPARQLConstraint) && executable.getConstraint().hasProperty(SH.sparql)) {
            return true;
        }
        if (executable instanceof ComponentConstraintExecutable) {
            ComponentConstraintExecutable cce = (ComponentConstraintExecutable)executable;
            Resource validator = cce.getValidator();
            if (validator != null && validator.hasProperty(SH.sparql)) {
                return true;
            }
            if (SH.DerivedValuesConstraintComponent.equals((Object)cce.getComponent())) {
                Resource valuesDeriver = (Resource)cce.getParameterValue();
                return valuesDeriver != null && valuesDeriver.hasProperty(RDF.type, (RDFNode)SH.SPARQLValuesDeriver) && valuesDeriver.hasProperty(SH.sparql);
            }
        }
        return false;
    }

    @Override
    public boolean canExecuteScope(Resource scope) {
        return scope.hasProperty(SH.sparql);
    }

    private String createDerivedValuesSPARQL(Resource valuesDeriver, boolean inverse) {
        String sparql = JenaUtil.getStringProperty(valuesDeriver, SH.sparql);
        StringBuffer sb = new StringBuffer("SELECT ?this ");
        if (inverse) {
            sb.append("($this AS ?object) $predicate (?value AS ?subject) ?message");
            sb.append("\nWHERE {\n");
            sb.append("    {\n");
            sb.append("        ?value $predicate $this .\n");
            sb.append("        FILTER NOT EXISTS {\n");
            sb.append(sparql);
            sb.append("        }\n");
            sb.append("        BIND (\"Existing value is not among inverse derived values\" AS ?message) .\n");
            sb.append("    }\n");
            sb.append("    UNION {\n");
            sb.append(sparql);
            sb.append("\n");
            sb.append("        FILTER NOT EXISTS {\n");
            sb.append("            ?value $predicate $this .\n");
            sb.append("        }\n");
            sb.append("        BIND (\"Derived value is not among existing inverse values\" AS ?message) .\n");
            sb.append("    }\n");
            sb.append("}");
        } else {
            sb.append("($this AS ?subject) $predicate (?value AS ?object) ?message");
            sb.append("\nWHERE {\n");
            sb.append("    {\n");
            sb.append("        $this $predicate ?value .\n");
            sb.append("        FILTER NOT EXISTS {\n");
            sb.append(sparql);
            sb.append("        }\n");
            sb.append("        BIND (\"Existing value is not among derived values\" AS ?message) .\n");
            sb.append("    }\n");
            sb.append("    UNION {\n");
            sb.append(sparql);
            sb.append("\n");
            sb.append("        FILTER NOT EXISTS {\n");
            sb.append("            $this $predicate ?value .\n");
            sb.append("        }\n");
            sb.append("        BIND (\"Derived value is not among existing values\" AS ?message) .\n");
            sb.append("    }\n");
            sb.append("}");
        }
        return sb.toString();
    }

    @Override
    public void executeConstraint(Dataset dataset, Resource shape, URI shapesGraphURI, ConstraintExecutable executable, RDFNode focusNode, Model results) {
        Query query;
        String sparql = this.getSPARQL(executable);
        SHACLConstraint constraint = executable.getConstraint();
        if (sparql == null) {
            StmtIterator it;
            String message = "Missing sh:" + SH.sparql.getLocalName() + " of " + SPINLabels.get().getLabel(constraint);
            if (constraint.isAnon() && (it = constraint.getModel().listStatements(null, null, (RDFNode)constraint)).hasNext()) {
                Statement s = (Statement)it.next();
                it.close();
                message = message + " at " + SPINLabels.get().getLabel(s.getSubject());
                message = message + " via " + SPINLabels.get().getLabel((Resource)s.getPredicate());
            }
            throw new SHACLException(message);
        }
        String queryString = ARQFactory.get().createPrefixDeclarations(constraint.getModel()) + sparql;
        try {
            query = ARQFactory.get().createQuery(queryString);
        }
        catch (QueryParseException ex) {
            throw new SHACLException("Invalid SPARQL constraint (" + ex.getLocalizedMessage() + "):\n" + queryString);
        }
        if (!query.isSelectType()) {
            throw new IllegalArgumentException("SHACL constraints must be SELECT queries");
        }
        QuerySolutionMap bindings = new QuerySolutionMap();
        if (executable instanceof ComponentConstraintExecutable) {
            ((ComponentConstraintExecutable)executable).addBindings(bindings);
        }
        List<SHACLShape> filters = executable.getFilterShapes();
        for (Resource filter : JenaUtil.getResourceProperties(shape, SH.filterShape)) {
            filters.add(SHACLFactory.asShape((RDFNode)filter));
        }
        if (focusNode == null) {
            query = SPARQLSubstitutions.insertScopeAndFilterClauses(query, filters.size(), shape, dataset, (QuerySolution)bindings);
        } else if (!filters.isEmpty()) {
            query = SPARQLSubstitutions.insertFilterClause(query, filters.size());
        }
        if (focusNode != null) {
            bindings.add(SH.thisVar.getVarName(), focusNode);
        }
        bindings.add(SH.currentShapeVar.getVarName(), (RDFNode)shape);
        bindings.add(SH.shapesGraphVar.getVarName(), (RDFNode)ResourceFactory.createResource((String)shapesGraphURI.toString()));
        for (int i = 0; i < filters.size(); ++i) {
            bindings.add("FILTER_SHAPE" + i, (RDFNode)filters.get(i));
        }
        QueryExecution qexec = SPARQLSubstitutions.createQueryExecution(query, dataset, (QuerySolution)bindings);
        long startTime = System.currentTimeMillis();
        int violationCount = SPARQLExecutionLanguage.executeSelectQuery(results, constraint, shape, focusNode, executable, qexec);
        if (SPINStatisticsManager.get().isRecording()) {
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            String label = executable + " (" + violationCount + " violations)";
            Iterator varNames = bindings.varNames();
            if (varNames.hasNext()) {
                sparql = sparql + "\nBindings:";
                while (varNames.hasNext()) {
                    String varName = (String)varNames.next();
                    sparql = sparql + "\n- ?" + varName + ": " + bindings.get(varName);
                }
            }
            SPINStatistics stats = new SPINStatistics(label, sparql, duration, startTime, focusNode != null ? focusNode.asNode() : constraint.asNode());
            SPINStatisticsManager.get().add(Collections.singletonList(stats));
        }
    }

    private String getSPARQL(ConstraintExecutable executable) {
        SHACLConstraint constraint = executable.getConstraint();
        if (JenaUtil.hasIndirectType(constraint, SH.SPARQLConstraint)) {
            return JenaUtil.getStringProperty(constraint, SH.sparql);
        }
        if (executable instanceof ComponentConstraintExecutable) {
            ComponentConstraintExecutable cce = (ComponentConstraintExecutable)executable;
            Resource validator = cce.getValidator();
            if (validator != null) {
                if (JenaUtil.hasIndirectType(validator, SH.SPARQLAskValidator)) {
                    return this.createSPARQLFromAskValidator(cce, validator);
                }
                if (JenaUtil.hasIndirectType(validator, SH.SPARQLSelectValidator)) {
                    return JenaUtil.getStringProperty(validator, SH.sparql);
                }
            } else if (SH.DerivedValuesConstraintComponent.equals((Object)cce.getComponent())) {
                return this.createDerivedValuesSPARQL((Resource)cce.getParameterValue(), SHACLFactory.isInversePropertyConstraint(constraint));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeSelectQuery(Model results, SHACLConstraint constraint, Resource shape, RDFNode focusNode, ConstraintExecutable executable, QueryExecution qexec) {
        ResultSet rs = qexec.execSelect();
        int violationCount = 0;
        try {
            List<Literal> defaultMessages = executable.getMessages();
            while (rs.hasNext()) {
                RDFNode thisValue;
                RDFNode selectSubject;
                RDFNode selectObject;
                QuerySolution sol = rs.next();
                Resource resultType = SH.ValidationResult;
                Resource severity = executable.getSeverity();
                RDFNode selectMessage = sol.get(SH.message.getLocalName());
                if (JenaDatatypes.TRUE.equals((Object)sol.get(SH.failureVar.getName()))) {
                    resultType = DASH.FailureResult;
                    String message = "Constraint " + SPINLabels.get().getLabel(executable.getConstraint());
                    if (executable instanceof ComponentConstraintExecutable) {
                        message = message + " at component " + SPINLabels.get().getLabel(((ComponentConstraintExecutable)executable).getComponent());
                    }
                    message = message + " has produced ?" + SH.failureVar.getName();
                    if (focusNode != null) {
                        message = message + " for focus node ";
                        message = focusNode.isLiteral() ? message + focusNode : message + SPINLabels.get().getLabel((Resource)focusNode);
                    }
                    FailureLog.get().logFailure(message);
                    selectMessage = ResourceFactory.createTypedLiteral((Object)"Validation Failure: Could not validate shape");
                }
                Resource result = results.createResource(resultType);
                result.addProperty(SH.severity, (RDFNode)severity);
                result.addProperty(SH.sourceConstraint, (RDFNode)constraint);
                result.addProperty(SH.sourceShape, (RDFNode)shape);
                if (executable instanceof ComponentConstraintExecutable) {
                    result.addProperty(SH.sourceConstraintComponent, (RDFNode)((ComponentConstraintExecutable)executable).getComponent());
                }
                if (selectMessage != null) {
                    result.addProperty(SH.message, selectMessage);
                } else {
                    for (Literal defaultMessage : defaultMessages) {
                        if (executable instanceof ComponentConstraintExecutable) {
                            QuerySolutionMap map = new QuerySolutionMap();
                            Iterator varNames = sol.varNames();
                            while (varNames.hasNext()) {
                                String varName = (String)varNames.next();
                                RDFNode value = sol.get(varName);
                                if (value == null) continue;
                                map.add(varName, value);
                            }
                            ((ComponentConstraintExecutable)executable).addBindings(map);
                            sol = map;
                        }
                        result.addProperty(SH.message, (RDFNode)SPARQLSubstitutions.withSubstitutions(defaultMessage, sol));
                    }
                }
                RDFNode selectPath = sol.get(SH.predicateVar.getVarName());
                if (selectPath instanceof Resource) {
                    result.addProperty(SH.predicate, selectPath);
                }
                if ((selectObject = sol.get(SH.objectVar.getVarName())) != null) {
                    result.addProperty(SH.object, selectObject);
                }
                if ((selectSubject = sol.get(SH.subjectVar.getVarName())) instanceof Resource) {
                    result.addProperty(SH.subject, selectSubject);
                }
                if ((thisValue = sol.get(SH.thisVar.getVarName())) != null) {
                    result.addProperty(SH.focusNode, thisValue);
                }
                ++violationCount;
            }
        }
        finally {
            qexec.close();
        }
        return violationCount;
    }

    @Override
    public Iterable<RDFNode> executeScope(Dataset dataset, Resource scope, SHACLParameterizableScope parameterizableScope) {
        Query query;
        String sparql = JenaUtil.getStringProperty(scope, SH.sparql);
        String queryString = ARQFactory.get().createPrefixDeclarations(scope.getModel()) + sparql;
        try {
            query = SPARQLExecutionLanguage.getSPARQLWithSelect(scope);
        }
        catch (QueryParseException ex) {
            throw new SHACLException("Invalid SPARQL scope (" + ex.getLocalizedMessage() + "):\n" + queryString);
        }
        QuerySolutionMap bindings = null;
        if (parameterizableScope != null) {
            bindings = new QuerySolutionMap();
            parameterizableScope.addBindings(bindings);
        }
        try (QueryExecution qexec = SPARQLSubstitutions.createQueryExecution(query, dataset, (QuerySolution)bindings);){
            HashSet<RDFNode> results = new HashSet<RDFNode>();
            ResultSet rs = qexec.execSelect();
            List varNames = rs.getResultVars();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                for (String varName : varNames) {
                    RDFNode value = qs.get(varName);
                    if (value == null) continue;
                    results.add(value);
                }
            }
            HashSet<RDFNode> hashSet = results;
            return hashSet;
        }
    }

    @Override
    public boolean isNodeInScope(RDFNode focusNode, Dataset dataset, Resource executable, SHACLParameterizableScope parameterizableScope) {
        Query query;
        String sparql = JenaUtil.getStringProperty(executable, SH.sparql);
        String queryString = ARQFactory.get().createPrefixDeclarations(executable.getModel()) + sparql;
        try {
            query = ARQFactory.get().createQuery(queryString);
        }
        catch (QueryParseException ex) {
            throw new SHACLException("Invalid SPARQL scope (" + ex.getLocalizedMessage() + "):\n" + queryString);
        }
        QuerySolutionMap bindings = new QuerySolutionMap();
        bindings.add(SH.thisVar.getVarName(), focusNode);
        if (parameterizableScope != null) {
            parameterizableScope.addBindings(bindings);
        }
        try (QueryExecution qexec = SPARQLSubstitutions.createQueryExecution(query, dataset, (QuerySolution)bindings);){
            boolean hasNext;
            ResultSet rs = qexec.execSelect();
            boolean bl = hasNext = rs.hasNext();
            return bl;
        }
    }

    private String createSPARQLFromAskValidator(ComponentConstraintExecutable executable, Resource validator) {
        String valueVar = "?value";
        while (executable.getComponent().getParametersMap().containsKey(valueVar)) {
            valueVar = valueVar + "_";
        }
        StringBuffer sb = new StringBuffer("SELECT ?this ");
        if (SHACLFactory.isNodeConstraint(executable.getConstraint())) {
            sb.append("\nWHERE {\n");
            sb.append("    BIND ($this AS ");
            sb.append(valueVar);
            sb.append(") .\n");
        } else {
            boolean inverse = SHACLFactory.isInversePropertyConstraint(executable.getConstraint());
            if (inverse) {
                sb.append("(" + valueVar + " AS ?subject) $predicate ($this AS ?object)");
            } else {
                sb.append("($this AS ?subject) $predicate (" + valueVar + " AS ?object)");
            }
            HashSet<String> otherVarNames = new HashSet<String>();
            for (Literal message : executable.getMessages()) {
                SPARQLSubstitutions.addMessageVarNames(message.getLexicalForm(), otherVarNames);
            }
            otherVarNames.remove("subject");
            otherVarNames.remove("predicate");
            otherVarNames.remove("object");
            for (String varName : otherVarNames) {
                sb.append(" ?" + varName);
            }
            sb.append("\nWHERE {\n");
            if (inverse) {
                sb.append("    " + valueVar + " $predicate $this .\n");
            } else {
                sb.append("    $this $predicate " + valueVar + " .\n");
            }
        }
        String sparql = JenaUtil.getStringProperty(validator, SH.sparql);
        int firstIndex = sparql.indexOf(123);
        int lastIndex = sparql.lastIndexOf(125);
        String body = "{ BIND(true AS ?qyueyru). " + sparql.substring(firstIndex + 1, lastIndex + 1);
        sb.append("    FILTER NOT EXISTS " + body + "\n}");
        return sb.toString();
    }

    private static Query getSPARQLWithSelect(Resource host) {
        String sparql = JenaUtil.getStringProperty(host, SH.sparql);
        if (sparql == null) {
            throw new SHACLException("Missing sh:sparql at " + host);
        }
        try {
            return ARQFactory.get().createQuery(host.getModel(), sparql);
        }
        catch (Exception ex) {
            return ARQFactory.get().createQuery(host.getModel(), "SELECT ?this WHERE {" + sparql + "}");
        }
    }
}

