/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.constraints.sparql;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.constraints.SHACLException;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.util.JenaUtil;

class SPARQLSubstitutions {
    private static boolean USE_TRANSFORM = true;

    SPARQLSubstitutions() {
    }

    public static void addMessageVarNames(String labelTemplate, Set<String> results) {
        for (int i = 0; i < labelTemplate.length(); ++i) {
            int varEnd;
            if (i >= labelTemplate.length() - 3 || labelTemplate.charAt(i) != '{' || labelTemplate.charAt(i + 1) != '?') continue;
            for (varEnd = i + 2; varEnd < labelTemplate.length(); ++varEnd) {
                if (labelTemplate.charAt(varEnd) != '}') continue;
                String varName = labelTemplate.substring(i + 2, varEnd);
                results.add(varName);
                break;
            }
            i = varEnd;
        }
    }

    static QueryExecution createQueryExecution(Query query, Dataset dataset, QuerySolution bindings) {
        if (USE_TRANSFORM && bindings != null) {
            HashMap<Var, Node> substitutions = new HashMap<Var, Node>();
            Iterator varNames = bindings.varNames();
            while (varNames.hasNext()) {
                String varName = (String)varNames.next();
                substitutions.put(Var.alloc((String)varName), bindings.get(varName).asNode());
            }
            Query newQuery = QueryTransformOps.transform((Query)query, substitutions);
            return ARQFactory.get().createQueryExecution(newQuery, dataset);
        }
        return ARQFactory.get().createQueryExecution(query, dataset, bindings);
    }

    static Query insertFilterClause(Query query, int scopeCount) {
        String str = query.toString();
        Pattern pattern = Pattern.compile("(?i)WHERE\\s*\\{");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            int index = matcher.end();
            StringBuilder sb = new StringBuilder(str);
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < scopeCount; ++i) {
                s.append("{ FILTER <");
                s.append(SH.hasShape.getURI());
                s.append(">(?this, ?");
                s.append("FILTER_SHAPE" + i);
                s.append(", ?" + SH.shapesGraphVar.getVarName() + ") }");
            }
            sb.insert(index, s.toString());
            return ARQFactory.get().createQuery(sb.toString());
        }
        throw new IllegalArgumentException("Cannot find first '{' in query string: " + str);
    }

    static Query insertScopeAndFilterClauses(Query query, int filterCount, Resource shape, Dataset dataset, QuerySolution binding) {
        String str = query.toString();
        Pattern pattern = Pattern.compile("(?i)WHERE\\s*\\{");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            int index = matcher.end();
            StringBuilder sb = new StringBuilder(str);
            StringBuffer s = new StringBuffer();
            s.append("    {\n        SELECT DISTINCT ?" + SH.thisVar.getName() + " ?" + SH.shapesGraphVar.getName() + " ?" + SH.currentShapeVar.getName());
            Iterator varNames = binding.varNames();
            while (varNames.hasNext()) {
                String varName = (String)varNames.next();
                s.append(" ?" + varName);
            }
            s.append("\nWHERE {\n");
            SPARQLSubstitutions.appendScopes(s, shape, dataset);
            s.append("        }    }\n");
            for (int i = 0; i < filterCount; ++i) {
                s.append("    FILTER <");
                s.append(SH.hasShape.getURI());
                s.append(">(?this, ?");
                s.append("FILTER_SHAPE" + i);
                s.append(", ?" + SH.shapesGraphVar.getVarName() + ") .");
            }
            sb.insert(index, s.toString());
            try {
                return ARQFactory.get().createQuery(sb.toString());
            }
            catch (QueryParseException ex) {
                System.err.println("Failed to parse query:\n" + sb);
                throw ex;
            }
        }
        throw new IllegalArgumentException("Cannot find first '{' in query string: " + str);
    }

    static Literal withSubstitutions(Literal template, QuerySolution bindings) {
        StringBuffer buffer = new StringBuffer();
        String labelTemplate = template.getLexicalForm();
        for (int i = 0; i < labelTemplate.length(); ++i) {
            if (i < labelTemplate.length() - 3 && labelTemplate.charAt(i) == '{' && (labelTemplate.charAt(i + 1) == '?' || labelTemplate.charAt(i + 1) == '$')) {
                int varEnd;
                for (varEnd = i + 2; varEnd < labelTemplate.length(); ++varEnd) {
                    if (labelTemplate.charAt(varEnd) != '}') continue;
                    String varName = labelTemplate.substring(i + 2, varEnd);
                    RDFNode varValue = bindings.get(varName);
                    if (varValue instanceof Resource) {
                        buffer.append(SPINLabels.get().getLabel((Resource)varValue));
                        break;
                    }
                    if (!(varValue instanceof Literal)) break;
                    buffer.append(varValue.asNode().getLiteralLexicalForm());
                    break;
                }
                i = varEnd;
                continue;
            }
            buffer.append(labelTemplate.charAt(i));
        }
        if (template.getLanguage().isEmpty()) {
            return ResourceFactory.createTypedLiteral((Object)buffer.toString());
        }
        return ResourceFactory.createLangLiteral((String)buffer.toString(), (String)template.getLanguage());
    }

    private static void appendScopes(StringBuffer sb, Resource shape, Dataset dataset) {
        String varName;
        LinkedList<String> scopes = new LinkedList<String>();
        if (shape.getModel().contains(shape, SH.scopeNode, (RDFNode)null)) {
            scopes.add("        GRAPH $shapesGraph { $" + SH.currentShapeVar.getName() + " <" + SH.scopeNode + "> ?this } .\n");
        }
        if (JenaUtil.hasIndirectType(shape, RDFS.Class)) {
            Iterator<Resource> varName2 = "?CLASS_VAR";
            scopes.add("        " + (String)((Object)varName2) + " <" + RDFS.subClassOf + ">* $" + SH.currentShapeVar.getName() + " .\n            ?this a " + varName2 + " .\n");
        }
        for (Resource cls : JenaUtil.getResourceProperties(shape, SH.scopeClass)) {
            varName = "?SHAPE_CLASS_VAR";
            scopes.add("        " + varName + " <" + RDFS.subClassOf + ">* <" + cls + "> .\n            ?this a " + varName + " .\n");
        }
        for (Resource cls : JenaUtil.getResourceProperties(shape, SH.context)) {
            varName = "?CONTEXT_VAR";
            scopes.add("        " + varName + " <" + RDFS.subClassOf + ">* <" + cls + "> .\n            ?this a " + varName + " .\n");
        }
        if (shape.hasProperty(SH.scope)) {
            scopes.add(SPARQLSubstitutions.createScopes(shape));
        }
        if (scopes.isEmpty()) {
            throw new SHACLException("Unscoped shape " + shape);
        }
        if (scopes.size() == 1) {
            sb.append((String)scopes.get(0));
        } else {
            for (int i = 0; i < scopes.size(); ++i) {
                sb.append("        {");
                sb.append((String)scopes.get(i));
                sb.append("        }");
                if (i >= scopes.size() - 1) continue;
                sb.append("        UNION\n");
            }
        }
    }

    private static String createScopes(Resource shape) {
        String scopeVar = "?scpe_" + (int)(Math.random() * 10000.0);
        return "        GRAPH $" + SH.shapesGraphVar.getName() + " { $" + SH.currentShapeVar.getName() + " <" + SH.scope + "> " + scopeVar + "} .\n" + "        (" + scopeVar + " $" + SH.shapesGraphVar.getName() + ") <" + "http://topbraid.org/shacl/tbsh#scopeContains" + "> ?this .\n";
    }
}

