/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.entailment;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;

public class SPARQLEntailment {
    public static final Resource RDFS = ResourceFactory.createResource((String)"http://www.w3.org/ns/entailment/RDFS");
    private static SPARQLEntailment singleton = new SPARQLEntailment();
    private Map<String, Engine> engines = new HashMap<String, Engine>();

    public static SPARQLEntailment get() {
        return singleton;
    }

    protected SPARQLEntailment() {
        this.setEngine(RDFS.getURI(), new Engine(){

            @Override
            public Model createModelWithEntailment(Model model) {
                return ModelFactory.createRDFSModel((Model)model);
            }
        });
    }

    public Engine getEngine(String uri) {
        return this.engines.get(uri);
    }

    public void setEngine(String uri, Engine engine) {
        this.engines.put(uri, engine);
    }

    public Dataset withEntailment(Dataset dataset, Resource entailment) {
        if (entailment == null || dataset.getDefaultModel() == null) {
            return dataset;
        }
        Engine engine = this.getEngine(entailment.getURI());
        if (engine != null) {
            Model newDefaultModel = engine.createModelWithEntailment(dataset.getDefaultModel());
            return new DatasetWithDifferentDefaultModel(newDefaultModel, dataset);
        }
        return null;
    }

    public static interface Engine {
        public Model createModelWithEntailment(Model var1);
    }
}

