/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.model;

import org.apache.jena.enhanced.BuiltinPersonalities;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.arq.functions.HasShapeFunction;
import org.topbraid.shacl.arq.functions.ScopeContainsPFunction;
import org.topbraid.shacl.model.SHACLConstraintComponent;
import org.topbraid.shacl.model.SHACLFunction;
import org.topbraid.shacl.model.SHACLInversePropertyConstraint;
import org.topbraid.shacl.model.SHACLParameter;
import org.topbraid.shacl.model.SHACLParameterizable;
import org.topbraid.shacl.model.SHACLParameterizableConstraint;
import org.topbraid.shacl.model.SHACLParameterizableInstance;
import org.topbraid.shacl.model.SHACLParameterizableScope;
import org.topbraid.shacl.model.SHACLPropertyConstraint;
import org.topbraid.shacl.model.SHACLResult;
import org.topbraid.shacl.model.SHACLSPARQLConstraint;
import org.topbraid.shacl.model.SHACLSPARQLScope;
import org.topbraid.shacl.model.SHACLShape;
import org.topbraid.shacl.model.impl.SHACLConstraintComponentImpl;
import org.topbraid.shacl.model.impl.SHACLFunctionImpl;
import org.topbraid.shacl.model.impl.SHACLInversePropertyConstraintImpl;
import org.topbraid.shacl.model.impl.SHACLParameterImpl;
import org.topbraid.shacl.model.impl.SHACLParameterizableConstraintImpl;
import org.topbraid.shacl.model.impl.SHACLParameterizableImpl;
import org.topbraid.shacl.model.impl.SHACLParameterizableInstanceImpl;
import org.topbraid.shacl.model.impl.SHACLParameterizableScopeImpl;
import org.topbraid.shacl.model.impl.SHACLPropertyConstraintImpl;
import org.topbraid.shacl.model.impl.SHACLResultImpl;
import org.topbraid.shacl.model.impl.SHACLSPARQLConstraintImpl;
import org.topbraid.shacl.model.impl.SHACLSPARQLScopeImpl;
import org.topbraid.shacl.model.impl.SHACLShapeImpl;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.SimpleImplementation;

public class SHACLFactory {
    private static void init(Personality<RDFNode> p) {
        p.add(SHACLConstraintComponent.class, (Implementation)new SimpleImplementation(SH.ConstraintComponent.asNode(), SHACLConstraintComponentImpl.class));
        p.add(SHACLFunction.class, (Implementation)new SimpleImplementation(SH.Function.asNode(), SHACLFunctionImpl.class));
        p.add(SHACLInversePropertyConstraint.class, (Implementation)new SimpleImplementation(SH.InversePropertyConstraint.asNode(), SHACLInversePropertyConstraintImpl.class));
        p.add(SHACLParameter.class, (Implementation)new SimpleImplementation(SH.Parameter.asNode(), SHACLParameterImpl.class));
        p.add(SHACLParameterizable.class, (Implementation)new SimpleImplementation(SH.Parameterizable.asNode(), SHACLParameterizableImpl.class));
        p.add(SHACLParameterizableInstance.class, (Implementation)new SimpleImplementation(RDFS.Resource.asNode(), SHACLParameterizableInstanceImpl.class));
        p.add(SHACLParameterizableConstraint.class, (Implementation)new SimpleImplementation(SH.Constraint.asNode(), SHACLParameterizableConstraintImpl.class));
        p.add(SHACLParameterizableScope.class, (Implementation)new SimpleImplementation(SH.Scope.asNode(), SHACLParameterizableScopeImpl.class));
        p.add(SHACLPropertyConstraint.class, (Implementation)new SimpleImplementation(SH.PropertyConstraint.asNode(), SHACLPropertyConstraintImpl.class));
        p.add(SHACLResult.class, (Implementation)new SimpleImplementation(SH.AbstractResult.asNode(), SHACLResultImpl.class));
        p.add(SHACLShape.class, (Implementation)new SimpleImplementation(SH.Shape.asNode(), SHACLShapeImpl.class));
        p.add(SHACLSPARQLConstraint.class, (Implementation)new SimpleImplementation(SH.SPARQLConstraint.asNode(), SHACLSPARQLConstraintImpl.class));
        p.add(SHACLSPARQLScope.class, (Implementation)new SimpleImplementation(SH.SPARQLScope.asNode(), SHACLSPARQLScopeImpl.class));
        FunctionRegistry.get().put(SH.hasShape.getURI(), HasShapeFunction.class);
        PropertyFunctionRegistry.get().put("http://topbraid.org/shacl/tbsh#scopeContains", ScopeContainsPFunction.class);
    }

    public static SHACLConstraintComponent asConstraintComponent(RDFNode resource) {
        return (SHACLConstraintComponent)resource.as(SHACLConstraintComponent.class);
    }

    public static SHACLFunction asFunction(RDFNode resource) {
        return (SHACLFunction)resource.as(SHACLFunction.class);
    }

    public static SHACLInversePropertyConstraint asInversePropertyConstraint(RDFNode node) {
        return (SHACLInversePropertyConstraint)node.as(SHACLInversePropertyConstraint.class);
    }

    public static SHACLParameter asParameter(RDFNode resource) {
        return (SHACLParameter)resource.as(SHACLParameter.class);
    }

    public static SHACLParameterizable asParameterizable(RDFNode resource) {
        return (SHACLParameterizable)resource.as(SHACLParameterizable.class);
    }

    public static SHACLPropertyConstraint asPropertyConstraint(RDFNode node) {
        return (SHACLPropertyConstraint)node.as(SHACLPropertyConstraint.class);
    }

    public static SHACLShape asShape(RDFNode node) {
        return (SHACLShape)node.as(SHACLShape.class);
    }

    public static SHACLSPARQLConstraint asSPARQLConstraint(RDFNode node) {
        return (SHACLSPARQLConstraint)node.as(SHACLSPARQLConstraint.class);
    }

    public static SHACLSPARQLScope asSPARQLScope(RDFNode node) {
        return (SHACLSPARQLScope)node.as(SHACLSPARQLScope.class);
    }

    public static SHACLParameterizableInstance asTemplateCall(RDFNode resource) {
        return (SHACLParameterizableInstance)resource.as(SHACLParameterizableInstance.class);
    }

    public static SHACLParameterizableConstraint asParameterizableConstraint(RDFNode node) {
        return (SHACLParameterizableConstraint)node.as(SHACLParameterizableConstraint.class);
    }

    public static SHACLParameterizableScope asParameterizableScope(RDFNode node) {
        return (SHACLParameterizableScope)node.as(SHACLParameterizableScope.class);
    }

    public static boolean isInversePropertyConstraint(Resource resource) {
        return resource.hasProperty(RDF.type, (RDFNode)SH.InversePropertyConstraint) || !resource.hasProperty(RDF.type) && resource.getModel().contains(null, SH.inverseProperty, (RDFNode)resource);
    }

    public static boolean isNodeConstraint(Resource resource) {
        return resource.hasProperty(RDF.type, (RDFNode)SH.NodeConstraint) || !resource.hasProperty(RDF.type) && resource.getModel().contains(null, SH.constraint, (RDFNode)resource);
    }

    public static boolean isSPARQLConstraint(RDFNode node) {
        return node instanceof Resource && JenaUtil.hasIndirectType((Resource)node, SH.SPARQLConstraint);
    }

    public static boolean isSPARQLScope(RDFNode node) {
        return node instanceof Resource && JenaUtil.hasIndirectType((Resource)node, SH.SPARQLScope);
    }

    public static boolean isShape(RDFNode node) {
        if (node instanceof Resource) {
            if (JenaUtil.hasIndirectType((Resource)node, SH.Shape)) {
                return true;
            }
            if (node.isAnon() && !((Resource)node).hasProperty(RDF.type) && (node.getModel().contains(null, SH.shape, node) || node.getModel().contains(null, SH.filterShape, node))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isParameterizableConstraint(RDFNode node) {
        if (node instanceof Resource) {
            Resource r = (Resource)node;
            if (!r.hasProperty(RDF.type)) {
                return node.getModel().contains(null, SH.property, node) || node.getModel().contains(null, SH.parameter, node) || node.getModel().contains(null, SH.inverseProperty, node) || node.getModel().contains(null, SH.constraint, node);
            }
            if (r.hasProperty(RDF.type, (RDFNode)SH.NodeConstraint) || r.hasProperty(RDF.type, (RDFNode)SH.PropertyConstraint) || r.hasProperty(RDF.type, (RDFNode)SH.InversePropertyConstraint) || r.hasProperty(RDF.type, (RDFNode)SH.Parameter)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isParameter(Resource resource) {
        return resource.hasProperty(RDF.type, (RDFNode)SH.Parameter) || !resource.hasProperty(RDF.type) && resource.getModel().contains(null, SH.parameter, (RDFNode)resource);
    }

    public static boolean isParameterizableInstance(RDFNode node) {
        if (node instanceof Resource) {
            Resource dt;
            Resource resource = (Resource)node;
            for (Resource type : JenaUtil.getTypes(resource)) {
                if (!JenaUtil.hasIndirectType(type, SH.Parameterizable)) continue;
                return true;
            }
            if (!resource.hasProperty(RDF.type) && (dt = SHACLUtil.getResourceDefaultType(resource)) != null && JenaUtil.hasIndirectType(dt, SH.Parameterizable)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPropertyConstraint(Resource resource) {
        return resource.hasProperty(RDF.type, (RDFNode)SH.PropertyConstraint) || !resource.hasProperty(RDF.type) && resource.getModel().contains(null, SH.property, (RDFNode)resource);
    }

    static {
        SHACLFactory.init((Personality<RDFNode>)BuiltinPersonalities.model);
    }
}

