/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.model.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.topbraid.shacl.model.SHACLParameter;
import org.topbraid.shacl.model.SHACLParameterizable;
import org.topbraid.shacl.model.impl.SHACLResourceImpl;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.util.JenaUtil;

public class SHACLParameterizableImpl
extends SHACLResourceImpl
implements SHACLParameterizable {
    public SHACLParameterizableImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SHACLParameter> getParameters() {
        LinkedList<SHACLParameter> results = new LinkedList<SHACLParameter>();
        StmtIterator it = null;
        JenaUtil.setGraphReadOptimization(true);
        try {
            Set<Resource> classes = JenaUtil.getAllSuperClasses(this);
            classes.add(this);
            for (Resource cls : classes) {
                it = cls.listProperties(SH.parameter);
                while (it.hasNext()) {
                    Resource param = ((Statement)it.next()).getResource();
                    results.add((SHACLParameter)param.as(SHACLParameter.class));
                }
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
            JenaUtil.setGraphReadOptimization(false);
        }
        return results;
    }

    @Override
    public Map<String, SHACLParameter> getParametersMap() {
        HashMap<String, SHACLParameter> results = new HashMap<String, SHACLParameter>();
        for (SHACLParameter parameter : this.getParameters()) {
            Property property = parameter.getPredicate();
            if (property == null) continue;
            results.put(property.getLocalName(), parameter);
        }
        return results;
    }

    @Override
    public String getLabelTemplate() {
        return JenaUtil.getStringProperty(this, SH.labelTemplate);
    }

    @Override
    public List<SHACLParameter> getOrderedParameters() {
        List<SHACLParameter> results = this.getParameters();
        Collections.sort(results, new Comparator<SHACLParameter>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int compare(SHACLParameter param1, SHACLParameter param2) {
                Property p1 = param1.getPredicate();
                Property p2 = param2.getPredicate();
                if (p1 == null || p2 == null) return 0;
                Integer index1 = param1.getOrder();
                Integer index2 = param2.getOrder();
                if (index1 != null) {
                    if (index2 == null) return -1;
                    int comp = index1.compareTo(index2);
                    if (comp == 0) return p1.getLocalName().compareTo(p2.getLocalName());
                    return comp;
                }
                if (index2 == null) return p1.getLocalName().compareTo(p2.getLocalName());
                return 1;
            }
        });
        return results;
    }
}

