/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.testcases;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public abstract class TestCase {
    private Resource graph;
    private Resource resource;

    public TestCase(Resource graph, Resource resource) {
        this.graph = graph;
        this.resource = resource;
    }

    public Resource createFailure(Model results, String message) {
        Resource failure = this.createResult(results, DASH.FailureTestCaseResult);
        failure.addProperty(SH.message, message);
        return failure;
    }

    protected Resource createResult(Model results, Resource type) {
        Resource result = results.createResource(type);
        result.addProperty(DASH.testCase, (RDFNode)this.resource);
        result.addProperty(DASH.testGraph, (RDFNode)this.graph);
        return result;
    }

    public Resource getGraph() {
        return this.graph;
    }

    public Resource getResource() {
        return this.resource;
    }

    public abstract void run(Model var1) throws Exception;
}

