/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.util;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.constraints.ExecutionLanguage;
import org.topbraid.shacl.constraints.ExecutionLanguageSelector;
import org.topbraid.shacl.model.SHACLFactory;
import org.topbraid.shacl.model.SHACLParameter;
import org.topbraid.shacl.model.SHACLParameterizableScope;
import org.topbraid.shacl.model.SHACLPropertyConstraint;
import org.topbraid.shacl.model.SHACLResult;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.util.JenaUtil;

public class SHACLUtil {
    public static final String MACROS_FILE_PART = ".macros.";
    public static final String SHAPES_FILE_PART = ".shapes.";
    private static final Set<Resource> classesWithDefaultType = new HashSet<Resource>();
    private static final List<Property> constraintProperties;
    private static final List<Property> constraintPropertiesIncludingParameter;
    private static Query propertyLabelQuery;

    public static void addDirectPropertiesOfClass(Resource cls, Collection<Property> results) {
        Resource predicate;
        for (Resource argument : JenaUtil.getResourceProperties(cls, SH.parameter)) {
            predicate = JenaUtil.getPropertyResourceValue(argument, SH.predicate);
            if (predicate == null || !predicate.isURIResource() || results.contains(predicate)) continue;
            results.add(JenaUtil.asProperty(predicate));
        }
        for (Resource property : JenaUtil.getResourceProperties(cls, SH.property)) {
            predicate = JenaUtil.getPropertyResourceValue(property, SH.predicate);
            if (predicate == null || !predicate.isURIResource() || results.contains(predicate)) continue;
            results.add(JenaUtil.asProperty(predicate));
        }
    }

    private static void addIncludes(Graph model, String uri, Set<Graph> graphs, Set<String> reachedURIs) {
        graphs.add(model);
        reachedURIs.add(uri);
        for (Triple t : model.find(null, OWL.imports.asNode(), null).toList()) {
            Model includeModel;
            String includeURI;
            if (!t.getObject().isURI() || reachedURIs.contains(includeURI = t.getObject().getURI()) || (includeModel = ARQFactory.getNamedModel(includeURI)) == null) continue;
            Graph includeGraph = includeModel.getGraph();
            SHACLUtil.addIncludes(includeGraph, includeURI, graphs, reachedURIs);
        }
    }

    public static void addNodesInScope(Resource scope, Dataset dataset, Set<Node> results) {
        for (RDFNode focusNode : SHACLUtil.getResourcesInScope(scope, dataset)) {
            results.add(focusNode.asNode());
        }
    }

    public static Model createDefaultValueTypesModel(Model model) {
        String sparql = JenaUtil.getStringProperty(SH.DefaultValueTypeRule.inModel(model), SH.sparql);
        if (sparql == null) {
            throw new IllegalArgumentException("Shapes graph does not include sh:" + SH.DefaultValueTypeRule);
        }
        Model resultModel = JenaUtil.createMemoryModel();
        MultiUnion multiUnion = new MultiUnion(new Graph[]{model.getGraph(), resultModel.getGraph()});
        Model unionModel = ModelFactory.createModelForGraph((Graph)multiUnion);
        Query query = ARQFactory.get().createQuery(model, sparql);
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(query, unionModel);){
            qexec.execConstruct(resultModel);
            Model model2 = resultModel;
            return model2;
        }
    }

    public static Model createIncludesModel(Model model, String graphURI) {
        HashSet<Graph> graphs = new HashSet<Graph>();
        Graph baseGraph = model.getGraph();
        SHACLUtil.addIncludes(baseGraph, graphURI, graphs, new HashSet<String>());
        if (graphs.size() == 1) {
            return model;
        }
        MultiUnion union = new MultiUnion(graphs.iterator());
        union.setBaseGraph(baseGraph);
        return ModelFactory.createModelForGraph((Graph)union);
    }

    public static List<Property> getAllConstraintProperties(boolean validateShapes) {
        return validateShapes ? constraintPropertiesIncludingParameter : constraintProperties;
    }

    public static List<SHACLResult> getAllResults(Model model) {
        LinkedList<SHACLResult> results = new LinkedList<SHACLResult>();
        for (Resource r : model.listResourcesWithProperty(RDF.type, (RDFNode)SH.ValidationResult).toList()) {
            results.add((SHACLResult)r.as(SHACLResult.class));
        }
        for (Resource r : model.listResourcesWithProperty(RDF.type, (RDFNode)DASH.FailureResult).toList()) {
            results.add((SHACLResult)r.as(SHACLResult.class));
        }
        for (Resource r : model.listResourcesWithProperty(RDF.type, (RDFNode)DASH.SuccessResult).toList()) {
            results.add((SHACLResult)r.as(SHACLResult.class));
        }
        return results;
    }

    public static Set<Resource> getAllSuperClassesAndShapesStar(Resource cls) {
        HashSet<Resource> results = new HashSet<Resource>();
        SHACLUtil.getAllSuperClassesAndShapesStarHelper(cls, results);
        return results;
    }

    private static void getAllSuperClassesAndShapesStarHelper(Resource node, Set<Resource> results) {
        if (!results.contains(node)) {
            results.add(node);
            StmtIterator it = node.listProperties(RDFS.subClassOf);
            while (it.hasNext()) {
                Statement s = (Statement)it.next();
                if (!s.getObject().isResource()) continue;
                SHACLUtil.getAllSuperClassesAndShapesStarHelper(s.getResource(), results);
            }
            it = node.getModel().listStatements(null, SH.scopeClass, (RDFNode)node);
            while (it.hasNext()) {
                SHACLUtil.getAllSuperClassesAndShapesStarHelper(((Statement)it.next()).getSubject(), results);
            }
            it = node.getModel().listStatements(null, SH.context, (RDFNode)node);
            while (it.hasNext()) {
                SHACLUtil.getAllSuperClassesAndShapesStarHelper(((Statement)it.next()).getSubject(), results);
            }
        }
    }

    public static SHACLParameter getParameterAtClass(Resource cls, Property predicate) {
        for (Resource c : JenaUtil.getAllSuperClassesStar(cls)) {
            for (Resource arg : JenaUtil.getResourceProperties(c, SH.parameter)) {
                if (!arg.hasProperty(SH.predicate, (RDFNode)predicate)) continue;
                return SHACLFactory.asParameter((RDFNode)arg);
            }
        }
        return null;
    }

    public static SHACLParameter getParameterAtInstance(Resource instance, Property predicate) {
        for (Resource type : JenaUtil.getTypes(instance)) {
            SHACLParameter argument = SHACLUtil.getParameterAtClass(type, predicate);
            if (argument == null) continue;
            return argument;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getResourceDefaultType(Resource resource) {
        try (StmtIterator it = resource.getModel().listStatements(null, null, (RDFNode)resource);){
            while (it.hasNext()) {
                Statement s = (Statement)it.next();
                Resource defaultValueType = JenaUtil.getResourceProperty((Resource)s.getPredicate(), SH.defaultValueType);
                if (defaultValueType == null) continue;
                Resource resource2 = defaultValueType;
                return resource2;
            }
        }
        return null;
    }

    public static String getLocalPropertyLabel(Resource property, Resource context) {
        QuerySolutionMap binding = new QuerySolutionMap();
        binding.add("arg1", (RDFNode)property);
        binding.add("arg2", (RDFNode)context);
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(propertyLabelQuery, property.getModel(), (QuerySolution)binding);){
            ResultSet rs = qexec.execSelect();
            if (rs.hasNext()) {
                String string = rs.next().get("label").asLiteral().getLexicalForm();
                return string;
            }
        }
        return null;
    }

    public static SHACLPropertyConstraint getPropertyConstraintAtClass(Resource cls, Property predicate) {
        for (Resource c : JenaUtil.getAllSuperClassesStar(cls)) {
            for (Resource arg : JenaUtil.getResourceProperties(c, SH.property)) {
                if (!arg.hasProperty(SH.predicate, (RDFNode)predicate)) continue;
                return SHACLFactory.asPropertyConstraint((RDFNode)arg);
            }
        }
        return null;
    }

    public static SHACLPropertyConstraint getPropertyConstraintAtInstance(Resource instance, Property predicate) {
        for (Resource type : JenaUtil.getTypes(instance)) {
            SHACLPropertyConstraint property = SHACLUtil.getPropertyConstraintAtClass(type, predicate);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public static List<Property> getPropertiesOfClass(Resource cls) {
        LinkedList<Property> results = new LinkedList<Property>();
        for (Resource c : SHACLUtil.getAllSuperClassesAndShapesStar(cls)) {
            SHACLUtil.addDirectPropertiesOfClass(c, results);
        }
        return results;
    }

    public static Iterable<RDFNode> getResourcesInScope(Resource scope, Dataset dataset) {
        Resource executable;
        Resource type = JenaUtil.getType(scope);
        SHACLParameterizableScope parameterizableScope = null;
        if (SHACLFactory.isSPARQLScope((RDFNode)scope)) {
            executable = scope;
        } else {
            executable = type;
            parameterizableScope = SHACLFactory.asParameterizableScope((RDFNode)scope);
        }
        ExecutionLanguage language = ExecutionLanguageSelector.get().getLanguageForScope(executable);
        return language.executeScope(dataset, executable, parameterizableScope);
    }

    public static List<Resource> getTypes(Resource subject) {
        Resource defaultType;
        List<Resource> types = JenaUtil.getTypes(subject);
        if (types.isEmpty() && (defaultType = SHACLUtil.getResourceDefaultType(subject)) != null) {
            return Collections.singletonList(defaultType);
        }
        return types;
    }

    public static boolean hasMinSeverity(Resource severity, Resource minSeverity) {
        if (minSeverity == null || SH.Info.equals((Object)minSeverity)) {
            return true;
        }
        if (SH.Warning.equals((Object)minSeverity)) {
            return !SH.Info.equals((Object)severity);
        }
        return SH.Violation.equals((Object)severity);
    }

    public static boolean isParameterAtInstance(Resource subject, Property predicate) {
        for (Resource type : SHACLUtil.getTypes(subject)) {
            SHACLParameter arg = SHACLUtil.getParameterAtClass(type, predicate);
            if (arg == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassWithDefaultType(Resource cls) {
        return classesWithDefaultType.contains(cls);
    }

    public static boolean exists(Model model) {
        return model != null && "http://www.w3.org/ns/shacl#".equals(model.getNsPrefixURI("sh")) && model.contains(SH.Shape, RDF.type, (RDFNode)null);
    }

    public static Model withDefaultValueTypeInferences(Model model) {
        return ModelFactory.createModelForGraph((Graph)new MultiUnion(new Graph[]{model.getGraph(), SHACLUtil.createDefaultValueTypesModel(model).getGraph()}));
    }

    public static URI withShapesGraph(Dataset dataset) {
        URI shapesGraphURI = URI.create("urn:x-shacl:" + UUID.randomUUID());
        Model shapesModel = SHACLUtil.createShapesModel(dataset);
        dataset.addNamedModel(shapesGraphURI.toString(), shapesModel);
        return shapesGraphURI;
    }

    private static Model createShapesModel(Dataset dataset) {
        Model model = dataset.getDefaultModel();
        HashSet<Graph> graphs = new HashSet<Graph>();
        Graph baseGraph = model.getGraph();
        graphs.add(baseGraph);
        for (Statement s : model.listStatements(null, SH.shapesGraph, (RDFNode)null).toList()) {
            if (!s.getObject().isURIResource()) continue;
            String graphURI = s.getResource().getURI();
            Model sm = dataset.getNamedModel(graphURI);
            graphs.add(sm.getGraph());
        }
        if (graphs.size() > 1) {
            MultiUnion union = new MultiUnion(graphs.iterator());
            union.setBaseGraph(baseGraph);
            return ModelFactory.createModelForGraph((Graph)union);
        }
        return model;
    }

    static {
        classesWithDefaultType.add(SH.NodeConstraint);
        classesWithDefaultType.add(SH.Parameter);
        classesWithDefaultType.add(SH.InversePropertyConstraint);
        classesWithDefaultType.add(SH.PropertyConstraint);
        constraintProperties = new LinkedList<Property>();
        constraintProperties.add(SH.constraint);
        constraintProperties.add(SH.inverseProperty);
        constraintProperties.add(SH.property);
        constraintPropertiesIncludingParameter = new LinkedList<Property>();
        constraintPropertiesIncludingParameter.addAll(constraintProperties);
        constraintPropertiesIncludingParameter.add(SH.parameter);
        propertyLabelQuery = ARQFactory.get().createQuery("PREFIX rdfs: <" + RDFS.getURI() + ">\n" + "PREFIX sh: <" + "http://www.w3.org/ns/shacl#" + ">\n" + "SELECT ?label\n" + "WHERE {\n" + "    ?arg2 a ?type .\n" + "    ?type rdfs:subClassOf* ?class .\n" + "    ?shape <" + SH.scopeClass + ">* ?class .\n" + "    ?shape <" + SH.property + ">|<" + SH.parameter + "> ?p .\n" + "    ?p <" + SH.predicate + "> ?arg1 .\n" + "    ?p rdfs:label ?label .\n" + "}");
    }
}

