/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.serializer.SerializationContext;

class PFunctionQueryIterator
extends QueryIteratorBase {
    private Binding parentBinding;
    private QueryExecution qexec;
    private ResultSet rs;
    private List<String> rvs;
    private Map<String, Var> vars;

    PFunctionQueryIterator(ResultSet rs, QueryExecution qexec, Map<String, Var> vars, Binding parentBinding) {
        this.parentBinding = parentBinding;
        this.qexec = qexec;
        this.rs = rs;
        this.rvs = rs.getResultVars();
        this.vars = vars;
    }

    protected void closeIterator() {
        this.qexec.close();
    }

    protected boolean hasNextBinding() {
        return this.rs.hasNext();
    }

    protected Binding moveToNextBinding() {
        QuerySolution s = this.rs.nextSolution();
        BindingHashMap result = new BindingHashMap(this.parentBinding);
        for (String varName : this.rvs) {
            Var var;
            RDFNode resultNode = s.get(varName);
            if (resultNode == null || (var = this.vars.get(varName)) == null) continue;
            result.add(var, resultNode.asNode());
        }
        return result;
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
    }

    protected void requestCancel() {
    }
}

