/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq.functions;

import java.util.Collections;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.AbstractFunction;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;
import org.topbraid.spin.model.Ask;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Select;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.statistics.SPINStatisticsManager;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.SPINExpressions;
import org.topbraid.spin.vocabulary.SP;
import org.topbraid.spin.vocabulary.SPIN;

abstract class AbstractEvalFunction
extends AbstractFunction
implements FunctionFactory {
    private int bindingsStartIndex;

    AbstractEvalFunction(int bindingsStartIndex) {
        this.bindingsStartIndex = bindingsStartIndex;
    }

    private void addStatistics(Node[] nodes, FunctionEnv env, long startTime, String expr, RDFNode result) {
        long endTime = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        sb.append("spin:eval(");
        sb.append(expr);
        for (int i = 1; i < nodes.length; ++i) {
            sb.append(", ");
            if (nodes[i] == null) {
                sb.append("?arg" + (i + 1));
                continue;
            }
            sb.append(SSE.format((Node)nodes[i], (PrefixMapping)env.getActiveGraph().getPrefixMapping()));
        }
        sb.append(")");
        if (result != null) {
            sb.append(" = ");
            sb.append(FmtUtils.stringForNode((Node)result.asNode(), (PrefixMapping)env.getActiveGraph().getPrefixMapping()));
        }
        SPINStatistics stats = new SPINStatistics(sb.toString(), "(spin:eval)", endTime - startTime, startTime, SPIN.eval.asNode());
        SPINStatisticsManager.get().addSilently(Collections.singleton(stats));
    }

    public Function create(String uri) {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected NodeValue exec(Model queryModel, Node[] nodes, FunctionEnv env) {
        if (nodes.length == 0) {
            throw new ExprEvalException("Missing arguments");
        }
        Model baseModel = ModelFactory.createModelForGraph((Graph)env.getActiveGraph());
        Node exprNode = nodes[0];
        if (exprNode == null) {
            throw new ExprEvalException("No expression specified");
        }
        if (exprNode.isLiteral()) {
            return NodeValue.makeNode((Node)exprNode);
        }
        Model model = baseModel;
        if (!model.contains(SPIN._arg1, RDF.type, (RDFNode)SP.Variable)) {
            MultiUnion multiUnion = JenaUtil.createMultiUnion(new Graph[]{env.getActiveGraph(), SPIN.getModel().getGraph()});
            model = ModelFactory.createModelForGraph((Graph)multiUnion);
        }
        Resource exprRDFNode = (Resource)model.asRDFNode(exprNode);
        QuerySolutionMap bindings = this.getBindings(nodes, model);
        Query spinQuery = SPINFactory.asQuery(exprRDFNode);
        DatasetWithDifferentDefaultModel newDataset = new DatasetWithDifferentDefaultModel(queryModel, DatasetImpl.wrap((DatasetGraph)env.getDataset()));
        long startTime = System.currentTimeMillis();
        if (spinQuery instanceof Select || spinQuery instanceof Ask) {
            org.apache.jena.query.Query query = ARQFactory.get().createQuery(spinQuery);
            try (QueryExecution qexec = ARQFactory.get().createQueryExecution(query, newDataset, (QuerySolution)bindings);){
                if (query.isAskType()) {
                    boolean result = qexec.execAsk();
                    if (SPINStatisticsManager.get().isRecording() && SPINStatisticsManager.get().isRecordingSPINFunctions()) {
                        this.addStatistics(nodes, env, startTime, "ASK...", (RDFNode)(result ? JenaDatatypes.TRUE : JenaDatatypes.FALSE));
                    }
                    NodeValue nodeValue = NodeValue.makeBoolean((boolean)result);
                    return nodeValue;
                }
                ResultSet rs = qexec.execSelect();
                String var = (String)rs.getResultVars().get(0);
                if (!rs.hasNext()) throw new ExprEvalException("Expression has no result");
                RDFNode result = rs.next().get(var);
                if (SPINStatisticsManager.get().isRecording() && SPINStatisticsManager.get().isRecordingSPINFunctions()) {
                    this.addStatistics(nodes, env, startTime, "SELECT...", result);
                }
                if (result == null) throw new ExprEvalException("Expression has no result");
                NodeValue nodeValue = NodeValue.makeNode((Node)result.asNode());
                return nodeValue;
            }
        } else {
            RDFNode expr = SPINFactory.asExpression((RDFNode)exprRDFNode);
            RDFNode result = SPINExpressions.evaluate((Resource)expr, newDataset, (QuerySolution)bindings);
            if (SPINStatisticsManager.get().isRecording() && SPINStatisticsManager.get().isRecordingSPINFunctions()) {
                this.addStatistics(nodes, env, startTime, SPINExpressions.getExpressionString(expr), result);
            }
            if (result == null) throw new ExprEvalException("Expression has no result");
            return NodeValue.makeNode((Node)result.asNode());
        }
    }

    private QuerySolutionMap getBindings(Node[] nodes, Model model) {
        QuerySolutionMap bindings = new QuerySolutionMap();
        for (int i = this.bindingsStartIndex; i < nodes.length - 1; i += 2) {
            Node property = nodes[i];
            Node value = nodes[i + 1];
            if (value == null) continue;
            bindings.add(property.getLocalName(), model.asRDFNode(value));
        }
        return bindings;
    }
}

