/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.constraints;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.constraints.ObjectPropertyPath;
import org.topbraid.spin.constraints.SimplePropertyPath;
import org.topbraid.spin.constraints.SubjectPropertyPath;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SPIN;

public class ConstraintViolation {
    private Collection<TemplateCall> fixes;
    private Resource level;
    private String message;
    private Collection<SimplePropertyPath> paths;
    private Resource root;
    private Resource source;
    private RDFNode value;

    public static List<ConstraintViolation> shResults2ConstraintViolations(Model resultsModel) {
        LinkedList<ConstraintViolation> results = new LinkedList<ConstraintViolation>();
        for (Resource shResult : JenaUtil.getAllInstances(SH.ValidationResult.inModel(resultsModel))) {
            results.add(new ConstraintViolation(shResult));
        }
        return results;
    }

    public ConstraintViolation(Resource root, Collection<SimplePropertyPath> paths, Collection<TemplateCall> fixes, String message, Resource source) {
        this.fixes = fixes;
        this.message = message;
        this.root = root;
        this.paths = paths;
        this.source = source;
    }

    public ConstraintViolation(Resource shResult) {
        this.message = JenaUtil.getStringProperty(shResult, SH.message);
        this.root = JenaUtil.getResourceProperty(shResult, SH.focusNode);
        this.paths = new LinkedList<SimplePropertyPath>();
        if (this.root != null) {
            for (Resource predicate : JenaUtil.getResourceProperties(shResult, SH.predicate)) {
                if (shResult.hasProperty(SH.subject, (RDFNode)this.root)) {
                    this.paths.add(new ObjectPropertyPath(this.root, JenaUtil.asProperty(predicate)));
                    continue;
                }
                if (!shResult.hasProperty(SH.object, (RDFNode)this.root)) continue;
                this.paths.add(new SubjectPropertyPath(this.root, JenaUtil.asProperty(predicate)));
            }
        }
        if (shResult.hasProperty(SH.severity, (RDFNode)SH.Violation)) {
            this.level = SPIN.Error;
        } else if (shResult.hasProperty(SH.severity, (RDFNode)SH.Warning)) {
            this.level = SPIN.Warning;
        } else if (shResult.hasProperty(SH.severity, (RDFNode)SH.Info)) {
            this.level = SPIN.Info;
        }
    }

    public Collection<TemplateCall> getFixes() {
        return this.fixes == null ? Collections.emptyList() : this.fixes;
    }

    public Resource getLevel() {
        return this.level == null ? SPIN.Error : this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Collection<SimplePropertyPath> getPaths() {
        return this.paths;
    }

    public Resource getRoot() {
        return this.root;
    }

    public Resource getSource() {
        return this.source;
    }

    public RDFNode getValue() {
        return this.value;
    }

    public boolean isError() {
        return SPIN.Error.equals((Object)this.getLevel()) || SPIN.Fatal.equals((Object)this.getLevel());
    }

    public void setLevel(Resource level) {
        this.level = level;
    }

    public void setValue(RDFNode value) {
        this.value = value;
    }
}

