/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.constraints;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.constraints.ModelConstraintValidator;
import org.topbraid.shacl.constraints.ResourceConstraintValidator;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.constraints.ConstraintViolation;
import org.topbraid.spin.constraints.ObjectPropertyPath;
import org.topbraid.spin.constraints.SimplePropertyPath;
import org.topbraid.spin.constraints.SubjectPropertyPath;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Ask;
import org.topbraid.spin.model.Construct;
import org.topbraid.spin.model.ElementList;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.QueryOrTemplateCall;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.SPINInstance;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.progress.ProgressMonitor;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.system.SPINImports;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.util.CommandWrapper;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.PropertyPathsGetter;
import org.topbraid.spin.util.QueryWrapper;
import org.topbraid.spin.util.SPINQueryFinder;
import org.topbraid.spin.util.SPINUtil;
import org.topbraid.spin.vocabulary.SP;
import org.topbraid.spin.vocabulary.SPIN;

public class SPINConstraints {
    public static boolean INCLUDE_SHACL = false;
    private static List<TemplateCall> NO_FIXES = Collections.emptyList();

    public static void addConstraintViolations(List<ConstraintViolation> results, SPINInstance instance, Property predicate, boolean matchValue, List<SPINStatistics> stats, ProgressMonitor monitor) {
        if (predicate == null) {
            predicate = SPIN.constraint;
        }
        List<QueryOrTemplateCall> qots = instance.getQueriesAndTemplateCalls(predicate);
        for (QueryOrTemplateCall qot : qots) {
            if (qot.getTemplateCall() != null) {
                SPINConstraints.addTemplateCallResults(results, qot, instance, matchValue, monitor);
                continue;
            }
            if (qot.getQuery() == null) continue;
            SPINConstraints.addQueryResults(results, qot, instance, matchValue, stats, monitor);
        }
        if (INCLUDE_SHACL && SHACLUtil.exists(instance.getModel())) {
            Dataset dataset = ARQFactory.get().getDataset(SHACLUtil.withDefaultValueTypeInferences(instance.getModel()));
            URI shapesGraphURI = SHACLUtil.withShapesGraph(dataset);
            try {
                Model resultsModel = ResourceConstraintValidator.get().validateNode(dataset, shapesGraphURI, instance.asNode(), null, monitor);
                results.addAll(ConstraintViolation.shResults2ConstraintViolations(resultsModel));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void addConstraintViolationsRDF(List<ConstraintViolation> cvs, Model result, boolean createSource) {
        for (ConstraintViolation cv : cvs) {
            Resource r = result.createResource(SPIN.ConstraintViolation);
            String message = cv.getMessage();
            if (message != null && message.length() > 0) {
                r.addProperty(RDFS.label, message);
            }
            if (cv.getRoot() != null) {
                r.addProperty(SPIN.violationRoot, (RDFNode)cv.getRoot());
            }
            r.addProperty(SPIN.violationLevel, (RDFNode)cv.getLevel());
            for (SimplePropertyPath path : cv.getPaths()) {
                if (path instanceof ObjectPropertyPath) {
                    r.addProperty(SPIN.violationPath, (RDFNode)path.getPredicate());
                    continue;
                }
                Resource p = result.createResource(SP.ReversePath);
                p.addProperty(SP.path, (RDFNode)path.getPredicate());
                r.addProperty(SPIN.violationPath, (RDFNode)p);
            }
            if (createSource && cv.getSource() != null) {
                r.addProperty(SPIN.violationSource, (RDFNode)cv.getSource());
            }
            if (cv.getValue() == null) continue;
            r.addProperty(SPIN.violationValue, cv.getValue());
        }
    }

    private static void addConstructedProblemReports(Model cm, List<ConstraintViolation> results, Model model, Resource atClass, Resource matchRoot, String label, Resource source) {
        StmtIterator it = cm.listStatements(null, RDF.type, (RDFNode)SPIN.ConstraintViolation);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            Resource vio = s.getSubject();
            Resource root = null;
            Statement rootS = vio.getProperty(SPIN.violationRoot);
            if (rootS != null && rootS.getObject().isResource()) {
                root = rootS.getResource().inModel(model);
            }
            if (matchRoot != null && !matchRoot.equals(root)) continue;
            Statement labelS = vio.getProperty(RDFS.label);
            if (labelS != null && labelS.getObject().isLiteral()) {
                label = labelS.getString();
            } else if (label == null) {
                label = "SPIN constraint at " + SPINLabels.get().getLabel(atClass);
            }
            List<SimplePropertyPath> paths = SPINConstraints.getViolationPaths(model, vio, root);
            List<TemplateCall> fixes = SPINConstraints.getFixes(cm, model, vio);
            results.add(SPINConstraints.createConstraintViolation(paths, JenaUtil.getProperty(vio, SPIN.violationValue), fixes, root, label, source, JenaUtil.getPropertyResourceValue(vio, SPIN.violationLevel)));
        }
    }

    public static void addQueryResults(List<ConstraintViolation> results, QueryOrTemplateCall qot, Resource resource, boolean matchValue, List<SPINStatistics> stats, ProgressMonitor monitor) {
        QuerySolutionMap arqBindings = new QuerySolutionMap();
        String queryString = ARQFactory.get().createCommandString(qot.getQuery());
        arqBindings.add("this", (RDFNode)resource);
        org.apache.jena.query.Query arq = ARQFactory.get().createQuery(queryString);
        Model model = resource.getModel();
        QueryExecution qexec = ARQFactory.get().createQueryExecution(arq, model, (QuerySolution)arqBindings);
        long startTime = System.currentTimeMillis();
        if (arq.isAskType()) {
            if (qexec.execAsk() != matchValue) {
                List<SimplePropertyPath> paths;
                String comment = qot.getQuery().getComment();
                if (comment == null) {
                    comment = JenaUtil.getStringProperty(qot.getQuery(), RDFS.label);
                }
                String message = comment == null ? SPINLabels.get().getLabel(qot.getQuery()) : comment;
                message = message + "\n(SPIN constraint at " + SPINLabels.get().getLabel(qot.getCls()) + ")";
                Resource path = JenaUtil.getPropertyResourceValue(qot.getQuery(), SPIN.violationPath);
                if (path != null && path.isURIResource()) {
                    paths = new ArrayList<SimplePropertyPath>(1);
                    paths.add(new ObjectPropertyPath(resource, JenaUtil.asProperty(path)));
                } else {
                    paths = SPINConstraints.getPropertyPaths(resource, qot.getQuery().getWhere(), null);
                }
                Resource source = SPINConstraints.getSource(qot);
                results.add(SPINConstraints.createConstraintViolation(paths, null, NO_FIXES, resource, message, source, null));
            }
        } else if (arq.isConstructType()) {
            Model cm = qexec.execConstruct();
            qexec.close();
            SPINConstraints.addConstructedProblemReports(cm, results, model, qot.getCls(), resource, qot.getQuery().getComment(), SPINConstraints.getSource(qot));
        }
        long endTime = System.currentTimeMillis();
        if (stats != null) {
            long duration = startTime - endTime;
            String label = qot.toString();
            String queryText = qot.getTemplateCall() != null ? SPINLabels.get().getLabel(qot.getTemplateCall().getTemplate().getBody()) : SPINLabels.get().getLabel(qot.getQuery());
            Node cls = qot.getCls() != null ? qot.getCls().asNode() : null;
            stats.add(new SPINStatistics(label, queryText, duration, startTime, cls));
        }
    }

    public static void addTemplateCallResults(List<ConstraintViolation> results, QueryOrTemplateCall qot, Resource resource, boolean matchValue, ProgressMonitor monitor) {
        TemplateCall templateCall = qot.getTemplateCall();
        org.topbraid.spin.model.Template template = templateCall.getTemplate();
        SPINConstraints.addTemplateCallResults(results, qot, resource, matchValue, templateCall, template);
        for (Resource superClass : JenaUtil.getAllSuperClasses(template)) {
            if (!JenaUtil.hasIndirectType(superClass, SPIN.Template)) continue;
            SPINConstraints.addTemplateCallResults(results, qot, resource, matchValue, templateCall, SPINFactory.asTemplate(superClass));
        }
    }

    private static void addTemplateCallResults(List<ConstraintViolation> results, QueryOrTemplateCall qot, Resource resource, boolean matchValue, TemplateCall templateCall, org.topbraid.spin.model.Template template) {
        Query spinQuery;
        if (template != null && template.getBody() instanceof Query && ((spinQuery = (Query)template.getBody()) instanceof Ask || spinQuery instanceof Construct)) {
            QuerySolutionMap bindings = SPINConstraints.createInitialBindings(resource, templateCall);
            for (Argument arg : template.getArguments(false)) {
                if (arg.isOptional() || bindings.contains(arg.getVarName())) continue;
                return;
            }
            Model model = resource.getModel();
            org.apache.jena.query.Query arq = ARQFactory.get().createQuery(spinQuery);
            QueryExecution qexec = ARQFactory.get().createQueryExecution(arq, model, (QuerySolution)bindings);
            if (spinQuery instanceof Ask) {
                if (qexec.execAsk() != matchValue) {
                    List<SimplePropertyPath> paths = SPINConstraints.getPropertyPaths(resource, spinQuery.getWhere(), templateCall.getArgumentsMapByProperties());
                    String message = SPINLabels.get().getLabel(templateCall);
                    message = message + "\n(SPIN constraint at " + SPINLabels.get().getLabel(qot.getCls()) + ")";
                    results.add(SPINConstraints.createConstraintViolation(paths, null, NO_FIXES, resource, message, templateCall, null));
                }
            } else if (spinQuery instanceof Construct) {
                Model cm = qexec.execConstruct();
                qexec.close();
                Resource source = SPINConstraints.getSource(qot);
                String label = SPINLabels.get().getLabel(templateCall);
                SPINConstraints.addConstructedProblemReports(cm, results, model, qot.getCls(), resource, label, source);
            }
        }
    }

    public static List<ConstraintViolation> check(Resource resource, ProgressMonitor monitor) {
        return SPINConstraints.check(resource, SPIN.constraint, new LinkedList<SPINStatistics>(), monitor);
    }

    public static List<ConstraintViolation> check(Resource resource, Property predicate, ProgressMonitor monitor) {
        return SPINConstraints.check(resource, predicate, new LinkedList<SPINStatistics>(), monitor);
    }

    public static List<ConstraintViolation> check(Resource resource, Property predicate, List<SPINStatistics> stats, ProgressMonitor monitor) {
        LinkedList<ConstraintViolation> results = new LinkedList<ConstraintViolation>();
        try {
            Model importsModel = SPINImports.get().getImportsModel(resource.getModel());
            if (importsModel != resource.getModel()) {
                resource = resource.inModel(importsModel);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        SPINInstance instance = (SPINInstance)resource.as(SPINInstance.class);
        SPINConstraints.addConstraintViolations(results, instance, predicate, false, stats, monitor);
        return results;
    }

    public static List<ConstraintViolation> check(Model model, ProgressMonitor monitor) {
        return SPINConstraints.check(model, SPIN.constraint, null, monitor);
    }

    public static List<ConstraintViolation> check(Model model, Property predicate, ProgressMonitor monitor) {
        return SPINConstraints.check(model, predicate, null, monitor);
    }

    public static List<ConstraintViolation> check(Model model, Property predicate, List<SPINStatistics> stats, ProgressMonitor monitor) {
        LinkedList<ConstraintViolation> results = new LinkedList<ConstraintViolation>();
        SPINConstraints.run(model, predicate, results, stats, monitor);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized org.apache.jena.query.Query convertAskToConstruct(org.apache.jena.query.Query ask, Query spinQuery, String label) {
        Syntax oldSyntax = Syntax.defaultSyntax;
        try {
            Resource path;
            Syntax.defaultSyntax = ask.getSyntax();
            org.apache.jena.query.Query construct = QueryFactory.create((org.apache.jena.query.Query)ask);
            construct.setQueryConstructType();
            BasicPattern bgp = new BasicPattern();
            Node cv = NodeFactory.createBlankNode();
            bgp.add(Triple.create((Node)cv, (Node)RDF.type.asNode(), (Node)SPIN.ConstraintViolation.asNode()));
            Var thisVar = Var.alloc((String)"this");
            bgp.add(Triple.create((Node)cv, (Node)SPIN.violationRoot.asNode(), (Node)thisVar));
            if (label == null) {
                label = spinQuery.getComment();
            }
            if (label == null) {
                label = JenaUtil.getStringProperty(spinQuery, RDFS.label);
            }
            if (label != null) {
                bgp.add(Triple.create((Node)cv, (Node)RDFS.label.asNode(), (Node)NodeFactory.createLiteral((String)label)));
            }
            if ((path = JenaUtil.getResourceProperty(spinQuery, SPIN.violationPath)) != null && path.isURIResource()) {
                bgp.add(Triple.create((Node)cv, (Node)SPIN.violationPath.asNode(), (Node)path.asNode()));
            }
            Template template = new Template(bgp);
            construct.setConstructTemplate(template);
            Element where = construct.getQueryPattern();
            construct.setQueryPattern(where);
            org.apache.jena.query.Query query = construct;
            return query;
        }
        finally {
            Syntax.defaultSyntax = oldSyntax;
        }
    }

    private static ConstraintViolation createConstraintViolation(Collection<SimplePropertyPath> paths, RDFNode value, Collection<TemplateCall> fixes, Resource instance, String message, Resource source, Resource level) {
        ConstraintViolation result = new ConstraintViolation(instance, paths, fixes, message, source);
        result.setValue(value);
        result.setLevel(level);
        return result;
    }

    private static QuerySolutionMap createInitialBindings(Resource resource, TemplateCall templateCall) {
        QuerySolutionMap arqBindings = new QuerySolutionMap();
        arqBindings.add("this", (RDFNode)resource);
        Map<Argument, RDFNode> args = templateCall.getArgumentsMap();
        for (Argument arg : args.keySet()) {
            RDFNode value = args.get(arg);
            arqBindings.add(arg.getVarName(), value);
        }
        return arqBindings;
    }

    private static List<TemplateCall> getFixes(Model cm, Model model, Resource vio) {
        ArrayList<TemplateCall> fixes = new ArrayList<TemplateCall>();
        StmtIterator fit = vio.listProperties(SPIN.fix);
        while (fit.hasNext()) {
            Statement fs = (Statement)fit.next();
            if (!fs.getObject().isResource()) continue;
            MultiUnion union = JenaUtil.createMultiUnion(new Graph[]{model.getGraph(), cm.getGraph()});
            Model unionModel = ModelFactory.createModelForGraph((Graph)union);
            Resource r = fs.getResource().inModel(unionModel);
            TemplateCall fix = SPINFactory.asTemplateCall((RDFNode)r);
            fixes.add(fix);
        }
        return fixes;
    }

    private static List<SimplePropertyPath> getPropertyPaths(Resource resource, ElementList where, Map<Property, RDFNode> varBindings) {
        if (where != null) {
            PropertyPathsGetter getter = new PropertyPathsGetter(where, varBindings);
            getter.run();
            return new ArrayList<SimplePropertyPath>(getter.getResults());
        }
        return Collections.emptyList();
    }

    private static Resource getSource(QueryOrTemplateCall qot) {
        if (qot.getQuery() != null) {
            return qot.getQuery();
        }
        return qot.getTemplateCall();
    }

    private static List<SimplePropertyPath> getViolationPaths(Model model, Resource vio, Resource root) {
        ArrayList<SimplePropertyPath> paths = new ArrayList<SimplePropertyPath>();
        StmtIterator pit = vio.listProperties(SPIN.violationPath);
        while (pit.hasNext()) {
            Statement reverse;
            Resource path;
            Statement p = pit.nextStatement();
            if (p.getObject().isURIResource()) {
                Property predicate = model.getProperty(p.getResource().getURI());
                paths.add(new ObjectPropertyPath(root, predicate));
                continue;
            }
            if (!p.getObject().isAnon() || !(path = p.getResource()).hasProperty(RDF.type, (RDFNode)SP.ReversePath) || (reverse = path.getProperty(SP.path)) == null || !reverse.getObject().isURIResource()) continue;
            Property predicate = model.getProperty(reverse.getResource().getURI());
            paths.add(new SubjectPropertyPath(root, predicate));
        }
        return paths;
    }

    public static boolean isConstraintProperty(Property property) {
        if (SPIN.constraint.equals(property)) {
            return true;
        }
        return JenaUtil.hasSuperProperty(property, property.getModel().getProperty(SPIN.constraint.getURI()));
    }

    private static void run(Model model, Property predicate, List<ConstraintViolation> results, List<SPINStatistics> stats, ProgressMonitor monitor) {
        if (predicate == null) {
            predicate = SPIN.constraint;
        }
        try {
            model = SPINImports.get().getImportsModel(model);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (monitor != null) {
            monitor.setTaskName("Preparing SPIN Constraints");
        }
        Map<Resource, List<CommandWrapper>> class2Query = SPINQueryFinder.getClass2QueryMap(model, model, predicate, true, true);
        if (monitor != null) {
            int totalWork = 0;
            for (Resource cls : class2Query.keySet()) {
                List<CommandWrapper> arqs = class2Query.get(cls);
                totalWork += arqs.size() + 1;
            }
            monitor.beginTask("Checking SPIN Constraints on " + class2Query.size() + " classes", totalWork);
        }
        for (Resource cls : class2Query.keySet()) {
            List<CommandWrapper> arqs = class2Query.get(cls);
            for (CommandWrapper arqWrapper : arqs) {
                QueryWrapper queryWrapper = (QueryWrapper)arqWrapper;
                org.apache.jena.query.Query arq = queryWrapper.getQuery();
                String label = arqWrapper.getLabel();
                if (arq.isAskType()) {
                    arq = SPINConstraints.convertAskToConstruct(arq, queryWrapper.getSPINQuery(), label);
                }
                SPINConstraints.runQueryOnClass(results, arq, queryWrapper.getSPINQuery(), label, model, cls, queryWrapper.getTemplateBinding(), arqWrapper.isThisUnbound(), arqWrapper.isThisDeep(), arqWrapper.getSource(), stats, monitor);
                if (!arqWrapper.isThisUnbound()) {
                    Set<Resource> subClasses = JenaUtil.getAllSubClasses(cls);
                    for (Resource subClass : subClasses) {
                        SPINConstraints.runQueryOnClass(results, arq, queryWrapper.getSPINQuery(), label, model, subClass, queryWrapper.getTemplateBinding(), arqWrapper.isThisUnbound(), arqWrapper.isThisDeep(), arqWrapper.getSource(), stats, monitor);
                    }
                }
                if (monitor == null) continue;
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                return;
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (INCLUDE_SHACL && SHACLUtil.exists(model)) {
            Dataset dataset = ARQFactory.get().getDataset(SHACLUtil.withDefaultValueTypeInferences(model));
            URI shapesGraphURI = SHACLUtil.withShapesGraph(dataset);
            try {
                Model resultsModel = ModelConstraintValidator.get().validateModel(dataset, shapesGraphURI, null, true, monitor);
                results.addAll(ConstraintViolation.shResults2ConstraintViolations(resultsModel));
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private static void runQueryOnClass(List<ConstraintViolation> results, org.apache.jena.query.Query arq, Query spinQuery, String label, Model model, Resource cls, Map<String, RDFNode> initialBindings, boolean thisUnbound, boolean thisDeep, Resource source, List<SPINStatistics> stats, ProgressMonitor monitor) {
        if (thisUnbound || SPINUtil.isRootClass(cls) || model.contains(null, RDF.type, (RDFNode)cls)) {
            QuerySolutionMap arqBindings = new QuerySolutionMap();
            if (!thisUnbound) {
                arqBindings.add("TYPE_CLASS", (RDFNode)cls);
            }
            if (initialBindings != null) {
                for (String varName : initialBindings.keySet()) {
                    RDFNode value = initialBindings.get(varName);
                    arqBindings.add(varName, value);
                }
            }
            if (monitor != null) {
                monitor.subTask("Checking SPIN constraint on " + SPINLabels.get().getLabel(cls) + (label != null ? ": " + label : ""));
            }
            long startTime = System.currentTimeMillis();
            Model cm = JenaUtil.createDefaultModel();
            if (thisDeep && !thisUnbound) {
                StmtIterator it = model.listStatements(null, RDF.type, (RDFNode)cls);
                while (it.hasNext()) {
                    Resource instance = ((Statement)it.next()).getSubject();
                    arqBindings.add("this", (RDFNode)instance);
                    QueryExecution qexec = ARQFactory.get().createQueryExecution(arq, model, (QuerySolution)arqBindings);
                    Throwable throwable = null;
                    try {
                        qexec.execConstruct(cm);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (qexec == null) continue;
                        if (throwable != null) {
                            try {
                                qexec.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        qexec.close();
                    }
                }
            } else {
                try (QueryExecution qexec = ARQFactory.get().createQueryExecution(arq, model, (QuerySolution)arqBindings);){
                    qexec.execConstruct(cm);
                }
            }
            long endTime = System.currentTimeMillis();
            if (stats != null) {
                long duration = endTime - startTime;
                String queryText = SPINLabels.get().getLabel(spinQuery);
                if (label == null) {
                    label = queryText;
                }
                stats.add(new SPINStatistics(label, queryText, duration, startTime, cls.asNode()));
            }
            SPINConstraints.addConstructedProblemReports(cm, results, model, cls, null, label, source);
        }
    }
}

