/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.spin.arq.Aggregations;
import org.topbraid.spin.model.Aggregation;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.impl.AbstractSPINResourceImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.print.Printable;
import org.topbraid.spin.vocabulary.SP;

public class AggregationImpl
extends AbstractSPINResourceImpl
implements Aggregation {
    public AggregationImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public Variable getAs() {
        Resource as = this.getResource(SP.as);
        if (as != null) {
            return SPINFactory.asVariable((RDFNode)as);
        }
        return null;
    }

    @Override
    public Resource getExpression() {
        return this.getResource(SP.expression);
    }

    @Override
    public boolean isDistinct() {
        return this.hasProperty(SP.distinct, (RDFNode)this.getModel().createTypedLiteral(true));
    }

    @Override
    public void print(PrintContext p) {
        Statement exprS;
        Variable asVar = this.getAs();
        if (asVar != null) {
            p.print("(");
        }
        Resource aggType = this.getResource(RDF.type);
        String aggName = Aggregations.getName(aggType);
        p.printKeyword(aggName);
        p.print("(");
        if (this.isDistinct()) {
            p.print("DISTINCT ");
        }
        if ((exprS = this.getProperty(SP.expression)) != null && exprS.getObject().isResource()) {
            Resource r = exprS.getResource();
            RDFNode expr = SPINFactory.asExpression((RDFNode)r);
            if (expr instanceof Printable) {
                ((Printable)expr).print(p);
            } else {
                p.printURIResource(r);
            }
        } else {
            p.print("*");
        }
        String separator = this.getString(SP.separator);
        if (separator != null) {
            p.print("; ");
            p.printKeyword("SEPARATOR");
            p.print("='" + StrUtils.escapeString((String)separator) + "'");
        }
        if (asVar != null) {
            p.print(") ");
            p.printKeyword("AS");
            p.print(" ");
            p.print(asVar.toString());
        }
        p.print(")");
    }
}

