/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.spin.model.Describe;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.impl.QueryImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.vocabulary.SP;

public class DescribeImpl
extends QueryImpl
implements Describe {
    public DescribeImpl(Node node, EnhGraph eh) {
        super(node, eh);
    }

    @Override
    public List<Resource> getResultNodes() {
        LinkedList<Resource> results = new LinkedList<Resource>();
        for (RDFNode node : this.getList(SP.resultNodes)) {
            Variable variable = SPINFactory.asVariable(node);
            if (variable != null) {
                results.add(variable);
                continue;
            }
            if (!node.isURIResource()) continue;
            results.add((Resource)node);
        }
        return results;
    }

    @Override
    public void printSPINRDF(PrintContext context) {
        this.printComment(context);
        this.printPrefixes(context);
        context.printKeyword("DESCRIBE");
        context.print(" ");
        List<Resource> nodes = this.getResultNodes();
        if (nodes.isEmpty()) {
            context.print("*");
        } else {
            Iterator<Resource> nit = nodes.iterator();
            while (nit.hasNext()) {
                Resource node = nit.next();
                if (node instanceof Variable) {
                    context.print(node.toString());
                } else {
                    DescribeImpl.printVarOrResource(context, node);
                }
                if (!nit.hasNext()) continue;
                context.print(" ");
            }
        }
        this.printStringFrom(context);
        if (!this.getWhereElements().isEmpty()) {
            context.println();
            this.printWhere(context);
        }
        this.printSolutionModifiers(context);
        this.printValues(context);
    }
}

