/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.SubQuery;
import org.topbraid.spin.model.impl.ElementImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.visitor.ElementVisitor;
import org.topbraid.spin.vocabulary.SP;

public class SubQueryImpl
extends ElementImpl
implements SubQuery {
    public SubQueryImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public Query getQuery() {
        Resource r = this.getResource(SP.query);
        if (r != null) {
            return SPINFactory.asQuery(r);
        }
        return null;
    }

    @Override
    public void print(PrintContext p) {
        p.print("{");
        p.println();
        Query query = this.getQuery();
        if (query != null) {
            p.setIndentation(p.getIndentation() + 1);
            boolean oldPP = p.getPrintPrefixes();
            p.setPrintPrefixes(false);
            query.print(p);
            p.setIndentation(p.getIndentation() - 1);
            p.setPrintPrefixes(oldPP);
        } else {
            p.print("<Error: Missing sub-query>");
        }
        p.println();
        p.printIndentation(p.getIndentation());
        p.print("}");
    }

    @Override
    public void visit(ElementVisitor visitor) {
        visitor.visit(this);
    }
}

