/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.spin.model.Values;
import org.topbraid.spin.model.impl.ElementImpl;
import org.topbraid.spin.model.impl.TupleImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.visitor.ElementVisitor;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SP;

public class ValuesImpl
extends ElementImpl
implements Values {
    public ValuesImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public List<Binding> getBindings() {
        List<String> varNames = this.getVarNames();
        LinkedList<Binding> bindings = new LinkedList<Binding>();
        Resource outerList = JenaUtil.getResourceProperty(this, SP.bindings);
        if (outerList != null) {
            for (RDFNode innerList : ((RDFList)outerList.as(RDFList.class)).iterator().toList()) {
                BindingHashMap binding = new BindingHashMap();
                bindings.add((Binding)binding);
                Iterator<String> vars = varNames.iterator();
                ExtendedIterator values = ((RDFList)innerList.as(RDFList.class)).iterator();
                while (vars.hasNext()) {
                    String varName = vars.next();
                    RDFNode value = (RDFNode)values.next();
                    if (SP.undef.equals((Object)value)) continue;
                    binding.add(Var.alloc((String)varName), value.asNode());
                }
            }
        }
        return bindings;
    }

    @Override
    public List<String> getVarNames() {
        LinkedList<String> results = new LinkedList<String>();
        RDFList list = (RDFList)this.getProperty(SP.varNames).getResource().as(RDFList.class);
        for (RDFNode member : list.iterator().toList()) {
            results.add(member.asLiteral().getLexicalForm());
        }
        return results;
    }

    @Override
    public void print(PrintContext p) {
        p.printKeyword("VALUES");
        p.print(" ");
        List<String> varNames = this.getVarNames();
        if (varNames.size() == 1) {
            p.printVariable(varNames.get(0));
        } else {
            p.print("(");
            Iterator<String> vit = varNames.iterator();
            while (vit.hasNext()) {
                p.printVariable(vit.next());
                if (!vit.hasNext()) continue;
                p.print(" ");
            }
            p.print(")");
        }
        p.print(" {");
        p.println();
        for (Binding binding : this.getBindings()) {
            p.printIndentation(p.getIndentation() + 1);
            if (varNames.size() != 1) {
                p.print("(");
            }
            Iterator<String> vit = varNames.iterator();
            while (vit.hasNext()) {
                String varName = vit.next();
                Node value = binding.get(Var.alloc((String)varName));
                if (value == null) {
                    p.printKeyword("UNDEF");
                } else if (value.isURI()) {
                    p.printURIResource((Resource)this.getModel().asRDFNode(value));
                } else {
                    TupleImpl.print(this.getModel(), this.getModel().asRDFNode(value), p);
                }
                if (!vit.hasNext()) continue;
                p.print(" ");
            }
            if (varNames.size() != 1) {
                p.print(")");
            }
            p.println();
        }
        p.printIndentation(p.getIndentation());
        p.print("}");
    }

    @Override
    public void visit(ElementVisitor visitor) {
        visitor.visit(this);
    }
}

