/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.visitor;

import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.spin.model.Bind;
import org.topbraid.spin.model.Element;
import org.topbraid.spin.model.ElementGroup;
import org.topbraid.spin.model.ElementList;
import org.topbraid.spin.model.Exists;
import org.topbraid.spin.model.Filter;
import org.topbraid.spin.model.Minus;
import org.topbraid.spin.model.NamedGraph;
import org.topbraid.spin.model.NotExists;
import org.topbraid.spin.model.Optional;
import org.topbraid.spin.model.Service;
import org.topbraid.spin.model.SubQuery;
import org.topbraid.spin.model.TriplePath;
import org.topbraid.spin.model.TriplePattern;
import org.topbraid.spin.model.Union;
import org.topbraid.spin.model.Values;
import org.topbraid.spin.model.visitor.ElementVisitor;
import org.topbraid.spin.model.visitor.ExpressionVisitor;
import org.topbraid.spin.model.visitor.ExpressionVisitors;
import org.topbraid.spin.model.visitor.ExpressionWalker;

public class ElementWalker
implements ElementVisitor {
    private ElementVisitor elementVisitor;
    private ExpressionVisitor expressionVisitor;

    public ElementWalker(ElementVisitor elementVisitor, ExpressionVisitor expressionVisitor) {
        this.elementVisitor = elementVisitor;
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void visit(Bind bind) {
        this.elementVisitor.visit(bind);
        this.visitExpression(bind.getExpression());
    }

    @Override
    public void visit(ElementList elementList) {
        this.elementVisitor.visit(elementList);
        this.visitChildren(elementList);
    }

    @Override
    public void visit(Exists exists) {
        this.elementVisitor.visit(exists);
        this.visitChildren(exists);
    }

    @Override
    public void visit(Filter filter) {
        this.elementVisitor.visit(filter);
        this.visitExpression(filter.getExpression());
    }

    @Override
    public void visit(Minus minus) {
        this.elementVisitor.visit(minus);
        this.visitChildren(minus);
    }

    @Override
    public void visit(NamedGraph namedGraph) {
        this.elementVisitor.visit(namedGraph);
        this.visitChildren(namedGraph);
    }

    @Override
    public void visit(NotExists notExists) {
        this.elementVisitor.visit(notExists);
        this.visitChildren(notExists);
    }

    @Override
    public void visit(Optional optional) {
        this.elementVisitor.visit(optional);
        this.visitChildren(optional);
    }

    @Override
    public void visit(Service service) {
        this.elementVisitor.visit(service);
        this.visitChildren(service);
    }

    @Override
    public void visit(SubQuery subQuery) {
        this.elementVisitor.visit(subQuery);
    }

    @Override
    public void visit(TriplePath triplePath) {
        this.elementVisitor.visit(triplePath);
    }

    @Override
    public void visit(TriplePattern triplePattern) {
        this.elementVisitor.visit(triplePattern);
    }

    @Override
    public void visit(Union union) {
        this.elementVisitor.visit(union);
        this.visitChildren(union);
    }

    @Override
    public void visit(Values values) {
        this.elementVisitor.visit(values);
    }

    protected void visitChildren(ElementGroup group) {
        List<Element> childElements = group.getElements();
        for (Element childElement : childElements) {
            childElement.visit(this);
        }
    }

    private void visitExpression(RDFNode node) {
        if (this.expressionVisitor != null) {
            ExpressionWalker expressionWalker = new ExpressionWalker(this.expressionVisitor);
            ExpressionVisitors.visit(node, expressionWalker);
        }
    }
}

