/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.visitor;

import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.spin.model.Aggregation;
import org.topbraid.spin.model.FunctionCall;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.visitor.ExpressionVisitor;
import org.topbraid.spin.model.visitor.ExpressionVisitors;

public class ExpressionWalker
implements ExpressionVisitor {
    private ExpressionVisitor visitor;

    public ExpressionWalker(ExpressionVisitor visitor) {
        this.visitor = visitor;
    }

    @Override
    public void visit(Aggregation aggregation) {
        Resource expr;
        this.visitor.visit(aggregation);
        Variable as = aggregation.getAs();
        if (as != null) {
            this.visitor.visit(as);
        }
        if ((expr = aggregation.getExpression()) != null) {
            ExpressionVisitors.visit((RDFNode)expr, this);
        }
    }

    @Override
    public void visit(FunctionCall functionCall) {
        this.visitor.visit(functionCall);
        List<RDFNode> args = functionCall.getArguments();
        for (RDFNode arg : args) {
            ExpressionVisitors.visit(arg, this);
        }
    }

    @Override
    public void visit(RDFNode node) {
        this.visitor.visit(node);
    }

    @Override
    public void visit(Variable variable) {
        this.visitor.visit(variable);
    }
}

