/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.query;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Model;
import org.apache.log4j.Logger;

public class QueryExecutionFactoryFilter {
    static final String LOG_NAME = "QueryLog";
    private Logger logger = Logger.getLogger((String)"QueryLog");
    private static QueryExecutionFactoryFilter singleton = new QueryExecutionFactoryFilter();

    public static QueryExecutionFactoryFilter get() {
        return singleton;
    }

    private QueryExecutionFactoryFilter() {
    }

    public QueryExecution create(Query query, Model model) {
        this.analyzeRequest(query, model, null);
        return QueryExecutionFactory.create((Query)query, (Model)model);
    }

    public QueryExecution create(Query query, Model model, QuerySolution initialBinding) {
        this.analyzeRequest(query, model, initialBinding);
        return QueryExecutionFactory.create((Query)query, (Model)model, (QuerySolution)initialBinding);
    }

    public QueryExecution create(Query query, Dataset dataset) {
        this.analyzeRequest(query, dataset, null);
        return QueryExecutionFactory.create((Query)query, (Dataset)dataset);
    }

    public QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding) {
        this.analyzeRequest(query, dataset, initialBinding);
        return QueryExecutionFactory.create((Query)query, (Dataset)dataset, (QuerySolution)initialBinding);
    }

    public QueryExecution sparqlService(String service, Query query) {
        return QueryExecutionFactory.sparqlService((String)service, (Query)query);
    }

    private void analyzeRequest(Query query, Model model, QuerySolution initialBinding) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("QUERY[" + this.analyzeQuery(query) + "]\nMODEL[" + this.analyzeModel(model) + "]" + this.serializeBindings(initialBinding)));
        }
    }

    private void analyzeRequest(Query query, Dataset dataset, QuerySolution initialBinding) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("QUERY[" + this.analyzeQuery(query) + "]\nDATASET[" + this.analyzeDataset(dataset) + "]" + this.serializeBindings(initialBinding)));
        }
    }

    private String serializeBindings(QuerySolution bindings) {
        if (bindings == null) {
            return "";
        }
        return "\nINITIAL BINDINGS[" + bindings.toString() + "]";
    }

    private String analyzeQuery(Query query) {
        if (query == null) {
            return "null query";
        }
        return query.toString();
    }

    private String analyzeModel(Model model) {
        if (model == null) {
            return "null model";
        }
        return "this space for rent";
    }

    private String analyzeDataset(Dataset dataset) {
        if (dataset == null) {
            return "null dataset";
        }
        return "A Dataset";
    }
}

