/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.spr;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.vocabulary.SPR;

public class SPRResultSets {
    private static Query cellQuery = ARQFactory.get().doCreateQuery("SELECT (<" + SPR.cell.getURI() + ">(?table, ?row, ?col) AS ?result)\n" + "WHERE {\n" + "}");
    private static Query colCountQuery = ARQFactory.get().doCreateQuery("SELECT (<" + SPR.colCount.getURI() + ">(?table) AS ?result)\n" + "WHERE {\n" + "}");
    private static Query colNameQuery = ARQFactory.get().doCreateQuery("SELECT (<" + SPR.colName.getURI() + ">(?table, ?col) AS ?result)\n" + "WHERE {\n" + "}");
    private static Query rowCountQuery = ARQFactory.get().doCreateQuery("SELECT (<" + SPR.rowCount.getURI() + ">(?table) AS ?result)\n" + "WHERE {\n" + "}");

    public static RDFNode getCell(Resource table, int row, int col) {
        Model model = table.getModel();
        QuerySolutionMap bindings = new QuerySolutionMap();
        bindings.add("table", (RDFNode)table);
        bindings.add("row", (RDFNode)JenaDatatypes.createInteger(row));
        bindings.add("col", (RDFNode)JenaDatatypes.createInteger(col));
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(cellQuery, model, (QuerySolution)bindings);){
            ResultSet rs = qexec.execSelect();
            if (rs.hasNext()) {
                RDFNode result;
                RDFNode rDFNode = result = rs.next().get("result");
                return rDFNode;
            }
            RDFNode rDFNode = null;
            return rDFNode;
        }
    }

    public static int getColCount(Resource table) {
        return SPRResultSets.getIntFromFunction(table, colCountQuery);
    }

    public static String getColName(Resource table, int col) {
        Model model = table.getModel();
        QuerySolutionMap bindings = new QuerySolutionMap();
        bindings.add("table", (RDFNode)table);
        bindings.add("col", (RDFNode)JenaDatatypes.createInteger(col));
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(colNameQuery, model, (QuerySolution)bindings);){
            RDFNode result;
            ResultSet rs = qexec.execSelect();
            if (rs.hasNext() && (result = rs.next().get("result")).isLiteral()) {
                String string = ((Literal)result).getString();
                return string;
            }
            String string = null;
            return string;
        }
    }

    public static List<String> getColNames(Resource table) {
        LinkedList<String> results = new LinkedList<String>();
        int colCount = SPRResultSets.getColCount(table);
        for (int i = 0; i < colCount; ++i) {
            results.add(SPRResultSets.getColName(table, i));
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getIntFromFunction(Resource table, Query query) {
        Model model = table.getModel();
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(query, model);){
            RDFNode result;
            QuerySolutionMap bindings = new QuerySolutionMap();
            bindings.add("table", (RDFNode)table);
            qexec.setInitialBinding((QuerySolution)bindings);
            ResultSet rs = qexec.execSelect();
            if (rs.hasNext() && (result = rs.next().get("result")).isLiteral()) {
                int n = ((Literal)result).getInt();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Error trying to query spr: result set " + table, ex);
        }
    }

    public static int getRowCount(Resource table) {
        return SPRResultSets.getIntFromFunction(table, rowCountQuery);
    }
}

