/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.core.DatasetGraphBase;
import org.apache.jena.sparql.core.Quad;

public class DatasetWrappingDatasetGraph
extends DatasetGraphBase {
    private Dataset dataset;

    public DatasetWrappingDatasetGraph(Dataset dataset) {
        this.dataset = dataset;
    }

    public void add(Quad quad) {
        Graph graph = this.getGraph(quad);
        if (graph != null) {
            graph.add(quad.asTriple());
        }
    }

    public boolean containsGraph(Node graphNode) {
        return this.dataset.containsNamedModel(graphNode.getURI());
    }

    public void delete(Quad quad) {
        Graph graph = this.getGraph(quad);
        if (graph != null) {
            graph.delete(quad.asTriple());
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public Iterator<Node> listGraphNodes() {
        LinkedList<Node> results = new LinkedList<Node>();
        Iterator names = this.dataset.listNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            results.add(NodeFactory.createURI((String)name));
        }
        return results.iterator();
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        throw new UnsupportedOperationException();
    }

    public Graph getDefaultGraph() {
        Model defaultModel = this.dataset.getDefaultModel();
        if (defaultModel != null) {
            return defaultModel.getGraph();
        }
        return null;
    }

    public Graph getGraph(Node graphNode) {
        Model model = this.dataset.getNamedModel(graphNode.getURI());
        if (model != null) {
            return model.getGraph();
        }
        return null;
    }

    protected Graph getGraph(Quad quad) {
        if (quad.isDefaultGraph()) {
            return this.getDefaultGraph();
        }
        return this.getGraph(quad.getGraph());
    }

    public Lock getLock() {
        return this.dataset.getLock();
    }

    public long size() {
        int count = 0;
        Iterator<Node> it = this.listGraphNodes();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public void addGraph(Node graphName, Graph graph) {
        throw new UnsupportedOperationException();
    }

    public void removeGraph(Node graphName) {
        throw new UnsupportedOperationException();
    }

    public void begin(ReadWrite readWrite) {
        this.dataset.begin(readWrite);
    }

    public void commit() {
        this.dataset.commit();
    }

    public void abort() {
        this.dataset.abort();
    }

    public boolean isInTransaction() {
        return this.dataset.isInTransaction();
    }

    public void end() {
        this.dataset.end();
    }

    public boolean supportsTransactions() {
        return this.dataset.supportsTransactions();
    }
}

