var mindplot={};
mindplot.util={};
mindplot.commands={};
mindplot.layout={};
mindplot.layout.boards={};
mindplot.layout.boards.original={};
mindplot.widget={};
mindplot.model={};
mindplot.collaboration={};
mindplot.collaboration.framework={};
mindplot.persistence={};
mindplot.layout={};
Class.Mutators.Static=function(items){this.extend(items)
};var web2d={};
web2d.peer={svg:{}};
web2d.peer.utils={};web2d.peer.utils.EventUtils={broadcastChangeEvent:function(elementPeer,type){var listeners=elementPeer.getChangeEventListeners(type);
if($defined(listeners)){for(var i=0;
i<listeners.length;
i++){var listener=listeners[i];
listener.call(elementPeer,null)
}}var children=elementPeer.getChildren();
for(var j=0;
j<children.length;
j++){var child=children[j];
web2d.peer.utils.EventUtils.broadcastChangeEvent(child,type)
}}};web2d.peer.utils.TransformUtil={workoutScale:function(elementPeer){var current=elementPeer.getParent();
var width=1;
var height=1;
while(current){var coordSize=current.getCoordSize();
var size=current.getSize();
width=width*(parseInt(size.width)/coordSize.width);
height=height*(parseInt(size.height)/coordSize.height);
current=current.getParent()
}return{width:width,height:height}
}};web2d.peer.svg.ElementPeer=new Class({initialize:function(svgElement){this._native=svgElement;
if(!this._native.addEvent){for(var key in Element){this._native[key]=Element.prototype[key]
}}this._size={width:1,height:1};
this._changeListeners={}
},setChildren:function(children){this._children=children
},getChildren:function(){var result=this._children;
if(!$defined(result)){result=[];
this._children=result
}return result
},getParent:function(){return this._parent
},setParent:function(parent){this._parent=parent
},appendChild:function(elementPeer){elementPeer.setParent(this);
var children=this.getChildren();
children.include(elementPeer);
this._native.appendChild(elementPeer._native);
web2d.peer.utils.EventUtils.broadcastChangeEvent(this,"strokeStyle")
},removeChild:function(elementPeer){elementPeer.setParent(null);
var children=this.getChildren();
var oldLength=children.length;
children.erase(elementPeer);
$assert(children.length<oldLength,"element could not be removed:"+elementPeer);
this._native.removeChild(elementPeer._native)
},addEvent:function(type,listener){this._native.addEvent(type,listener)
},fireEvent:function(type,event){this._native.fireEvent(type,event)
},cloneEvents:function(from){this._native.cloneEvents(from)
},removeEvent:function(type,listener){this._native.removeEvent(type,listener)
},setSize:function(width,height){if($defined(width)&&this._size.width!=parseInt(width)){this._size.width=parseInt(width);
this._native.setAttribute("width",parseInt(width))
}if($defined(height)&&this._size.height!=parseInt(height)){this._size.height=parseInt(height);
this._native.setAttribute("height",parseInt(height))
}web2d.peer.utils.EventUtils.broadcastChangeEvent(this,"strokeStyle")
},getSize:function(){return{width:this._size.width,height:this._size.height}
},setFill:function(color,opacity){if($defined(color)){this._native.setAttribute("fill",color)
}if($defined(opacity)){this._native.setAttribute("fill-opacity",opacity)
}},getFill:function(){var color=this._native.getAttribute("fill");
var opacity=this._native.getAttribute("fill-opacity");
return{color:color,opacity:Number(opacity)}
},getStroke:function(){var vmlStroke=this._native;
var color=vmlStroke.getAttribute("stroke");
var dashstyle=this._stokeStyle;
var opacity=vmlStroke.getAttribute("stroke-opacity");
var width=vmlStroke.getAttribute("stroke-width");
return{color:color,style:dashstyle,opacity:opacity,width:width}
},setStroke:function(width,style,color,opacity){if($defined(width)){this._native.setAttribute("stroke-width",width+"px")
}if($defined(color)){this._native.setAttribute("stroke",color)
}if($defined(style)){var dashArrayPoints=this.__stokeStyleToStrokDasharray[style];
var scale=1/web2d.peer.utils.TransformUtil.workoutScale(this).width;
var strokeWidth=this._native.getAttribute("stroke-width");
strokeWidth=parseFloat(strokeWidth);
var scaledPoints=[];
for(var i=0;
i<dashArrayPoints.length;
i++){scaledPoints[i]=dashArrayPoints[i]*strokeWidth;
scaledPoints[i]=(scaledPoints[i]*scale)+"px"
}this._stokeStyle=style
}if($defined(opacity)){this._native.setAttribute("stroke-opacity",opacity)
}},setVisibility:function(isVisible){this._native.setAttribute("visibility",(isVisible)?"visible":"hidden")
},isVisible:function(){var visibility=this._native.getAttribute("visibility");
return !(visibility=="hidden")
},updateStrokeStyle:function(){var strokeStyle=this._stokeStyle;
if(this.getParent()){if(strokeStyle&&strokeStyle!="solid"){this.setStroke(null,strokeStyle)
}}},attachChangeEventListener:function(type,listener){var listeners=this.getChangeEventListeners(type);
if(!$defined(listener)){throw"Listener can not be null"
}listeners.push(listener)
},getChangeEventListeners:function(type){var listeners=this._changeListeners[type];
if(!$defined(listeners)){listeners=[];
this._changeListeners[type]=listeners
}return listeners
},positionRelativeTo:function(elem,options){options=!$defined(options)?{}:options;
options.relativeTo=$(this._native);
elem.position(options)
},moveToFront:function(){this._native.parentNode.appendChild(this._native)
},moveToBack:function(){this._native.parentNode.insertBefore(this._native,this._native.parentNode.firstChild)
},setCursor:function(type){this._native.style.cursor=type
}});
web2d.peer.svg.ElementPeer.prototype.svgNamespace="http://www.w3.org/2000/svg";
web2d.peer.svg.ElementPeer.prototype.linkNamespace="http://www.w3.org/1999/xlink";
web2d.peer.svg.ElementPeer.prototype.__stokeStyleToStrokDasharray={solid:[],dot:[1,3],dash:[4,3],longdash:[10,2],dashdot:[5,3,1,3]};web2d.peer.svg.ElipsePeer=new Class({Extends:web2d.peer.svg.ElementPeer,initialize:function(){var svgElement=window.document.createElementNS(this.svgNamespace,"ellipse");
this.parent(svgElement);
this.attachChangeEventListener("strokeStyle",web2d.peer.svg.ElementPeer.prototype.updateStrokeStyle);
this._position={x:0,y:0}
},setSize:function(width,height){this.parent(width,height);
if($defined(width)){this._native.setAttribute("rx",width/2)
}if($defined(height)){this._native.setAttribute("ry",height/2)
}var pos=this.getPosition();
this.setPosition(pos.x,pos.y)
},setPosition:function(cx,cy){var size=this.getSize();
cx=cx+size.width/2;
cy=cy+size.height/2;
if($defined(cx)){this._native.setAttribute("cx",cx)
}if($defined(cy)){this._native.setAttribute("cy",cy)
}},getPosition:function(){return this._position
}});web2d.peer.svg.Font=new Class({initialize:function(){this._size=10;
this._style="normal";
this._weight="normal"
},init:function(args){if($defined(args.size)){this._size=parseInt(args.size)
}if($defined(args.style)){this._style=args.style
}if($defined(args.weight)){this._weight=args.weight
}},getHtmlSize:function(scale){var result=0;
if(this._size==6){result=this._size*scale.height*43/32
}if(this._size==8){result=this._size*scale.height*42/32
}else{if(this._size==10){result=this._size*scale.height*42/32
}else{if(this._size==15){result=this._size*scale.height*42/32
}}}return result
},getGraphSize:function(){return this._size*43/32
},getSize:function(){return parseInt(this._size)
},getStyle:function(){return this._style
},getWeight:function(){return this._weight
},setSize:function(size){this._size=size
},setStyle:function(style){this._style=style
},setWeight:function(weight){this._weight=weight
},getWidthMargin:function(){var result=0;
if(this._size==10||this._size==6){result=4
}return result
}});web2d.peer.svg.ArialFont=new Class({Extends:web2d.peer.svg.Font,initialize:function(){this.parent();
this._fontFamily="Arial"
},getFontFamily:function(){return this._fontFamily
},getFont:function(){return web2d.Font.ARIAL
}});web2d.peer.svg.PolyLinePeer=new Class({Extends:web2d.peer.svg.ElementPeer,initialize:function(){var svgElement=window.document.createElementNS(this.svgNamespace,"polyline");
this.parent(svgElement);
this.setFill("none");
this.breakDistance=10
},setFrom:function(x1,y1){this._x1=x1;
this._y1=y1;
this._updatePath()
},setTo:function(x2,y2){this._x2=x2;
this._y2=y2;
this._updatePath()
},setStrokeWidth:function(width){this._native.setAttribute("stroke-width",width)
},setColor:function(color){this._native.setAttribute("stroke",color)
},setStyle:function(style){this._style=style;
this._updatePath()
},getStyle:function(){return this._style
},_updatePath:function(){if(this._style=="Curved"){this._updateMiddleCurvePath()
}else{if(this._style=="Straight"){this._updateStraightPath()
}else{this._updateCurvePath()
}}},_updateStraightPath:function(){if($defined(this._x1)&&$defined(this._x2)&&$defined(this._y1)&&$defined(this._y2)){var path=web2d.PolyLine.buildStraightPath(this.breakDistance,this._x1,this._y1,this._x2,this._y2);
this._native.setAttribute("points",path)
}},_updateMiddleCurvePath:function(){var x1=this._x1;
var y1=this._y1;
var x2=this._x2;
var y2=this._y2;
if($defined(x1)&&$defined(x2)&&$defined(y1)&&$defined(y2)){var diff=x2-x1;
var middlex=(diff/2)+x1;
var signx=1;
var signy=1;
if(diff<0){signx=-1
}if(y2<y1){signy=-1
}var path=x1+", "+y1+" "+(middlex-10*signx)+", "+y1+" "+middlex+", "+(y1+10*signy)+" "+middlex+", "+(y2-10*signy)+" "+(middlex+10*signx)+", "+y2+" "+x2+", "+y2;
this._native.setAttribute("points",path)
}},_updateCurvePath:function(){if($defined(this._x1)&&$defined(this._x2)&&$defined(this._y1)&&$defined(this._y2)){var path=web2d.PolyLine.buildCurvedPath(this.breakDistance,this._x1,this._y1,this._x2,this._y2);
this._native.setAttribute("points",path)
}}});web2d.peer.svg.CurvedLinePeer=new Class({Extends:web2d.peer.svg.ElementPeer,initialize:function(){var svgElement=window.document.createElementNS(this.svgNamespace,"path");
this.parent(svgElement);
this._style={fill:"#495879"};
this._updateStyle();
this._customControlPoint_1=false;
this._customControlPoint_2=false;
this._control1=new core.Point();
this._control2=new core.Point();
this._lineStyle=true
},setSrcControlPoint:function(control){this._customControlPoint_1=true;
var change=this._control1.x!=control.x||this._control1.y!=control.y;
if($defined(control.x)){this._control1=control;
this._control1.x=parseInt(this._control1.x);
this._control1.y=parseInt(this._control1.y)
}if(change){this._updatePath()
}},setDestControlPoint:function(control){this._customControlPoint_2=true;
var change=this._control2.x!=control.x||this._control2.y!=control.y;
if($defined(control.x)){this._control2=control;
this._control2.x=parseInt(this._control2.x);
this._control2.y=parseInt(this._control2.y)
}if(change){this._updatePath()
}},isSrcControlPointCustom:function(){return this._customControlPoint_1
},isDestControlPointCustom:function(){return this._customControlPoint_2
},setIsSrcControlPointCustom:function(isCustom){this._customControlPoint_1=isCustom
},setIsDestControlPointCustom:function(isCustom){this._customControlPoint_2=isCustom
},getControlPoints:function(){return[this._control1,this._control2]
},setFrom:function(x1,y1){var change=this._x1!=parseInt(x1)||this._y1!=parseInt(y1);
this._x1=parseInt(x1);
this._y1=parseInt(y1);
if(change){this._updatePath()
}},setTo:function(x2,y2){var change=this._x2!=parseInt(x2)||this._y2!=parseInt(y2);
this._x2=parseInt(x2);
this._y2=parseInt(y2);
if(change){this._updatePath()
}},getFrom:function(){return new core.Point(this._x1,this._y1)
},getTo:function(){return new core.Point(this._x2,this._y2)
},setStrokeWidth:function(width){this._style["stroke-width"]=width;
this._updateStyle()
},setColor:function(color){this._style.stroke=color;
this._style.fill=color;
this._updateStyle()
},updateLine:function(avoidControlPointFix){this._updatePath(avoidControlPointFix)
},setLineStyle:function(style){this._lineStyle=style;
if(this._lineStyle){this._style.fill=this._fill
}else{this._fill=this._style.fill;
this._style.fill="none"
}this._updateStyle();
this.updateLine()
},getLineStyle:function(){return this._lineStyle
},setShowEndArrow:function(visible){this._showEndArrow=visible;
this.updateLine()
},isShowEndArrow:function(){return this._showEndArrow
},setShowStartArrow:function(visible){this._showStartArrow=visible;
this.updateLine()
},isShowStartArrow:function(){return this._showStartArrow
},_updatePath:function(avoidControlPointFix){if($defined(this._x1)&&$defined(this._y1)&&$defined(this._x2)&&$defined(this._y2)){this._calculateAutoControlPoints(avoidControlPointFix);
var path="M"+this._x1+","+this._y1+" C"+(this._control1.x+this._x1)+","+(this._control1.y+this._y1)+" "+(this._control2.x+this._x2)+","+(this._control2.y+this._y2)+" "+this._x2+","+this._y2+(this._lineStyle?" "+(this._control2.x+this._x2)+","+(this._control2.y+this._y2+3)+" "+(this._control1.x+this._x1)+","+(this._control1.y+this._y1+5)+" "+this._x1+","+(this._y1+7)+" Z":"");
this._native.setAttribute("d",path)
}},_updateStyle:function(){var style="";
for(var key in this._style){style+=key+":"+this._style[key]+" "
}this._native.setAttribute("style",style)
},_calculateAutoControlPoints:function(avoidControlPointFix){var defaultpoints=mindplot.util.Shape.calculateDefaultControlPoints(new core.Point(this._x1,this._y1),new core.Point(this._x2,this._y2));
if(!this._customControlPoint_1&&!($defined(avoidControlPointFix)&&avoidControlPointFix==0)){this._control1.x=defaultpoints[0].x;
this._control1.y=defaultpoints[0].y
}if(!this._customControlPoint_2&&!($defined(avoidControlPointFix)&&avoidControlPointFix==1)){this._control2.x=defaultpoints[1].x;
this._control2.y=defaultpoints[1].y
}},setDashed:function(length,spacing){if($defined(length)&&$defined(spacing)){this._native.setAttribute("stroke-dasharray",length+","+spacing)
}else{this._native.setAttribute("stroke-dasharray","")
}}});web2d.peer.svg.ArrowPeer=new Class({Extends:web2d.peer.svg.ElementPeer,initialize:function(){var svgElement=window.document.createElementNS(this.svgNamespace,"path");
this.parent(svgElement);
this._style={};
this._controlPoint=new core.Point();
this._fromPoint=new core.Point()
},setFrom:function(x,y){this._fromPoint.x=x;
this._fromPoint.y=y;
this._redraw()
},setControlPoint:function(point){this._controlPoint=point;
this._redraw()
},setStrokeColor:function(color){this.setStroke(null,null,color,null)
},setStrokeWidth:function(width){this.setStroke(width)
},setDashed:function(isDashed,length,spacing){if($defined(isDashed)&&isDashed&&$defined(length)&&$defined(spacing)){this._native.setAttribute("stroke-dasharray",length+","+spacing)
}else{this._native.setAttribute("stroke-dasharray","")
}},_updateStyle:function(){var style="";
for(var key in this._style){style+=key+":"+this._style[key]+" "
}this._native.setAttribute("style",style)
},_redraw:function(){var x,y,xp,yp;
if($defined(this._fromPoint.x)&&$defined(this._fromPoint.y)&&$defined(this._controlPoint.x)&&$defined(this._controlPoint.y)){if(this._controlPoint.y==0){this._controlPoint.y=1
}var y0=this._controlPoint.y;
var x0=this._controlPoint.x;
var x2=x0+y0;
var y2=y0-x0;
var x3=x0-y0;
var y3=y0+x0;
var m=y2/x2;
var mp=y3/x3;
var l=6;
var pow=Math.pow;
x=(x2==0?0:Math.sqrt(pow(l,2)/(1+pow(m,2))));
x*=Math.sign(x2);
y=(x2==0?l*Math.sign(y2):m*x);
xp=(x3==0?0:Math.sqrt(pow(l,2)/(1+pow(mp,2))));
xp*=Math.sign(x3);
yp=(x3==0?l*Math.sign(y3):mp*xp);
var path="M"+this._fromPoint.x+","+this._fromPoint.y+" L"+(x+this._fromPoint.x)+","+(y+this._fromPoint.y)+"M"+this._fromPoint.x+","+this._fromPoint.y+" L"+(xp+this._fromPoint.x)+","+(yp+this._fromPoint.y);
this._native.setAttribute("d",path)
}}});web2d.peer.svg.TextPeer=new Class({Extends:web2d.peer.svg.ElementPeer,initialize:function(){var svgElement=window.document.createElementNS(this.svgNamespace,"text");
this.parent(svgElement);
this._position={x:0,y:0};
this._font=new web2d.Font("Arial",this)
},appendChild:function(element){this._native.appendChild(element._native)
},setTextAlignment:function(align){this._textAlign=align
},getTextAlignment:function(){return $defined(this._textAlign)?this._textAlign:"left"
},setText:function(text){while(this._native.firstChild){this._native.removeChild(this._native.firstChild)
}this._text=text;
if(text){var lines=text.split("\n");
lines.forEach(function(line){var tspan=window.document.createElementNS(this.svgNamespace,"tspan");
tspan.setAttribute("dy","1em");
tspan.setAttribute("x",this.getPosition().x);
tspan.textContent=line.length==0?" ":line;
this._native.appendChild(tspan)
}.bind(this))
}},getText:function(){return this._text
},setPosition:function(x,y){this._position={x:x,y:y};
this._native.setAttribute("y",y);
this._native.setAttribute("x",x);
this._native.getElements("tspan").forEach(function(span){span.setAttribute("x",x)
})
},getPosition:function(){return this._position
},setFont:function(font,size,style,weight){if($defined(font)){this._font=new web2d.Font(font,this)
}if($defined(style)){this._font.setStyle(style)
}if($defined(weight)){this._font.setWeight(weight)
}if($defined(size)){this._font.setSize(size)
}this._updateFontStyle()
},_updateFontStyle:function(){this._native.setAttribute("font-family",this._font.getFontFamily());
this._native.setAttribute("font-size",this._font.getGraphSize());
this._native.setAttribute("font-style",this._font.getStyle());
this._native.setAttribute("font-weight",this._font.getWeight())
},setColor:function(color){this._native.setAttribute("fill",color)
},getColor:function(){return this._native.getAttribute("fill")
},setTextSize:function(size){this._font.setSize(size);
this._updateFontStyle()
},setContentSize:function(width,height){this._native.xTextSize=width.toFixed(1)+","+height.toFixed(1)
},setStyle:function(style){this._font.setStyle(style);
this._updateFontStyle()
},setWeight:function(weight){this._font.setWeight(weight);
this._updateFontStyle()
},setFontFamily:function(family){var oldFont=this._font;
this._font=new web2d.Font(family,this);
this._font.setSize(oldFont.getSize());
this._font.setStyle(oldFont.getStyle());
this._font.setWeight(oldFont.getWeight());
this._updateFontStyle()
},getFont:function(){return{font:this._font.getFont(),size:parseInt(this._font.getSize()),style:this._font.getStyle(),weight:this._font.getWeight()}
},setSize:function(size){this._font.setSize(size);
this._updateFontStyle()
},getWidth:function(){try{var computedWidth=this._native.getBBox().width
}catch(e){computedWidth=10
}var width=parseInt(computedWidth);
width=width+this._font.getWidthMargin();
return width
},getHeight:function(){try{var computedHeight=this._native.getBBox().height
}catch(e){computedHeight=10
}return parseInt(computedHeight)
},getHtmlFontSize:function(){return this._font.getHtmlSize()
}});web2d.peer.svg.WorkspacePeer=new Class({Extends:web2d.peer.svg.ElementPeer,initialize:function(element){this._element=element;
var svgElement=window.document.createElementNS(this.svgNamespace,"svg");
this.parent(svgElement);
this._native.setAttribute("focusable","true");
this._native.setAttribute("id","workspace");
this._native.setAttribute("preserveAspectRatio","true")
},setCoordSize:function(width,height){var viewBox=this._native.getAttribute("viewBox");
var coords=[0,0,0,0];
if(viewBox!=null){coords=viewBox.split(/ /)
}if($defined(width)){coords[2]=width
}if($defined(height)){coords[3]=height
}this._native.setAttribute("viewBox",coords.join(" "));
this._native.setAttribute("preserveAspectRatio","none");
web2d.peer.utils.EventUtils.broadcastChangeEvent(this,"strokeStyle")
},getCoordSize:function(){var viewBox=this._native.getAttribute("viewBox");
var coords=[1,1,1,1];
if(viewBox!=null){coords=viewBox.split(/ /)
}return{width:coords[2],height:coords[3]}
},setCoordOrigin:function(x,y){var viewBox=this._native.getAttribute("viewBox");
var coords=[0,0,0,0];
if(viewBox!=null){coords=viewBox.split(/ /)
}if($defined(x)){coords[0]=x
}if($defined(y)){coords[1]=y
}this._native.setAttribute("viewBox",coords.join(" "))
},appendChild:function(child){this.parent(child);
web2d.peer.utils.EventUtils.broadcastChangeEvent(child,"onChangeCoordSize")
},getCoordOrigin:function(child){var viewBox=this._native.getAttribute("viewBox");
var coords=[1,1,1,1];
if(viewBox!=null){coords=viewBox.split(/ /)
}var x=parseFloat(coords[0]);
var y=parseFloat(coords[1]);
return{x:x,y:y}
},getPosition:function(){return{x:0,y:0}
}});web2d.peer.svg.GroupPeer=new Class({Extends:web2d.peer.svg.ElementPeer,initialize:function(){var svgElement=window.document.createElementNS(this.svgNamespace,"g");
this.parent(svgElement);
this._native.setAttribute("preserveAspectRatio","none");
this._coordSize={width:1,height:1};
this._native.setAttribute("focusable","true");
this._position={x:0,y:0};
this._coordOrigin={x:0,y:0}
},setCoordSize:function(width,height){var change=this._coordSize.width!=width||this._coordSize.height!=height;
this._coordSize.width=width;
this._coordSize.height=height;
if(change){this.updateTransform()
}web2d.peer.utils.EventUtils.broadcastChangeEvent(this,"strokeStyle")
},getCoordSize:function(){return{width:this._coordSize.width,height:this._coordSize.height}
},updateTransform:function(){var sx=this._size.width/this._coordSize.width;
var sy=this._size.height/this._coordSize.height;
var cx=this._position.x-this._coordOrigin.x*sx;
var cy=this._position.y-this._coordOrigin.y*sy;
this._native.setAttribute("transform","translate("+cx+","+cy+") scale("+sx+","+sy+")")
},setOpacity:function(value){this._native.setAttribute("opacity",value)
},setCoordOrigin:function(x,y){var change=x!=this._coordOrigin.x||y!=this._coordOrigin.y;
if($defined(x)){this._coordOrigin.x=x
}if($defined(y)){this._coordOrigin.y=y
}if(change){this.updateTransform()
}},setSize:function(width,height){var change=width!=this._size.width||height!=this._size.height;
this.parent(width,height);
if(change){this.updateTransform()
}},setPosition:function(x,y){var change=x!=this._position.x||y!=this._position.y;
if($defined(x)){this._position.x=parseInt(x)
}if($defined(y)){this._position.y=parseInt(y)
}if(change){this.updateTransform()
}},getPosition:function(){return{x:this._position.x,y:this._position.y}
},appendChild:function(child){this.parent(child);
web2d.peer.utils.EventUtils.broadcastChangeEvent(child,"onChangeCoordSize")
},getCoordOrigin:function(){return{x:this._coordOrigin.x,y:this._coordOrigin.y}
}});web2d.peer.svg.RectPeer=new Class({Extends:web2d.peer.svg.ElementPeer,initialize:function(arc){var svgElement=window.document.createElementNS(this.svgNamespace,"rect");
this.parent(svgElement);
this._arc=arc;
this.attachChangeEventListener("strokeStyle",web2d.peer.svg.ElementPeer.prototype.updateStrokeStyle)
},setPosition:function(x,y){if($defined(x)){this._native.setAttribute("x",parseInt(x))
}if($defined(y)){this._native.setAttribute("y",parseInt(y))
}},getPosition:function(){var x=this._native.getAttribute("x");
var y=this._native.getAttribute("y");
return{x:parseInt(x),y:parseInt(y)}
},setSize:function(width,height){this.parent(width,height);
var min=width<height?width:height;
if($defined(this._arc)){var arc=(min/2)*this._arc;
this._native.setAttribute("rx",arc);
this._native.setAttribute("ry",arc)
}}});web2d.peer.svg.ImagePeer=new Class({Extends:web2d.peer.svg.ElementPeer,initialize:function(){var svgElement=window.document.createElementNS(this.svgNamespace,"image");
this.parent(svgElement);
this._position={x:0,y:0};
this._href="";
this._native.setAttribute("preserveAspectRatio","none")
},setPosition:function(x,y){this._position={x:x,y:y};
this._native.setAttribute("y",y);
this._native.setAttribute("x",x)
},getPosition:function(){return this._position
},setHref:function(url){this._native.setAttributeNS(this.linkNamespace,"href",url);
this._href=url
},getHref:function(){return this._href
}});web2d.peer.svg.TimesFont=new Class({Extends:web2d.peer.svg.Font,initialize:function(){this.parent();
this._fontFamily="times"
},getFontFamily:function(){return this._fontFamily
},getFont:function(){return web2d.Font.TIMES
}});web2d.peer.svg.LinePeer=new Class({Extends:web2d.peer.svg.ElementPeer,initialize:function(){var svgElement=window.document.createElementNS(this.svgNamespace,"line");
this.parent(svgElement);
this.attachChangeEventListener("strokeStyle",web2d.peer.svg.ElementPeer.prototype.updateStrokeStyle)
},setFrom:function(x1,y1){this._x1=x1;
this._y1=y1;
this._native.setAttribute("x1",x1);
this._native.setAttribute("y1",y1)
},setTo:function(x2,y2){this._x2=x2;
this._y2=y2;
this._native.setAttribute("x2",x2);
this._native.setAttribute("y2",y2)
},getFrom:function(){return new core.Point(this._x1,this._y1)
},getTo:function(){return new core.Point(this._x2,this._y2)
},setArrowStyle:function(startStyle,endStyle){if($defined(startStyle)){}if($defined(endStyle)){}}});web2d.peer.svg.TahomaFont=new Class({Extends:web2d.peer.svg.Font,initialize:function(){this.parent();
this._fontFamily="tahoma"
},getFontFamily:function(){return this._fontFamily
},getFont:function(){return web2d.Font.TAHOMA
}});web2d.peer.svg.VerdanaFont=new Class({Extends:web2d.peer.svg.Font,initialize:function(){this.parent();
this._fontFamily="verdana"
},getFontFamily:function(){return this._fontFamily
},getFont:function(){return web2d.Font.VERDANA
}});web2d.Element=new Class({initialize:function(peer,attributes){this._peer=peer;
if(peer==null){throw new Error("Element peer can not be null")
}if($defined(attributes)){this._initialize(attributes)
}},_initialize:function(attributes){var batchExecute={};
for(var key in attributes){var funcName=this._attributeNameToFuncName(key,"set");
var funcArgs=batchExecute[funcName];
if(!$defined(funcArgs)){funcArgs=[]
}var signature=web2d.Element._propertyNameToSignature[key];
var argPositions=signature[1];
if(argPositions!=web2d.Element._SIGNATURE_MULTIPLE_ARGUMENTS){funcArgs[argPositions]=attributes[key]
}else{funcArgs=attributes[key].split(" ")
}batchExecute[funcName]=funcArgs
}for(var key in batchExecute){var func=this[key];
if(!$defined(func)){throw new Error("Could not find function: "+key)
}func.apply(this,batchExecute[key])
}},setSize:function(width,height){this._peer.setSize(width,height)
},setPosition:function(cx,cy){this._peer.setPosition(cx,cy)
},positionRelativeTo:function(elem,options){this._peer.positionRelativeTo(elem,options)
},addEvent:function(type,listener){this._peer.addEvent(type,listener)
},fireEvent:function(type,event){this._peer.fireEvent(type,event)
},cloneEvents:function(from){this._peer.cloneEvents(from)
},removeEvent:function(type,listener){this._peer.removeEvent(type,listener)
},getType:function(){throw new Error("Not implemeneted yet. This method must be implemented by all the inherited objects.")
},getFill:function(){return this._peer.getFill()
},setFill:function(color,opacity){this._peer.setFill(color,opacity)
},getPosition:function(){return this._peer.getPosition()
},setStroke:function(width,style,color,opacity){if(style!=null&&style!=undefined&&style!="dash"&&style!="dot"&&style!="solid"&&style!="longdash"&&style!="dashdot"){throw new Error("Unsupported stroke style: '"+style+"'")
}this._peer.setStroke(width,style,color,opacity)
},_attributeNameToFuncName:function(attributeKey,prefix){var signature=web2d.Element._propertyNameToSignature[attributeKey];
if(!$defined(signature)){throw"Unsupported attribute: "+attributeKey
}var firstLetter=signature[0].charAt(0);
return prefix+firstLetter.toUpperCase()+signature[0].substring(1)
},setAttribute:function(key,value){var funcName=this._attributeNameToFuncName(key,"set");
var signature=web2d.Element._propertyNameToSignature[key];
if(signature==null){throw"Could not find the signature for:"+key
}var argPositions=signature[1];
var args=[];
if(argPositions!==this._SIGNATURE_MULTIPLE_ARGUMENTS){args[argPositions]=value
}else{if(typeof value=="array"){args=value
}else{var strValue=String(value);
args=strValue.split(" ")
}}var setter=this[funcName];
if(setter==null){throw"Could not find the function name:"+funcName
}setter.apply(this,args)
},getAttribute:function(key){var funcName=this._attributeNameToFuncName(key,"get");
var signature=web2d.Element._propertyNameToSignature[key];
if(signature==null){throw"Could not find the signature for:"+key
}var getter=this[funcName];
if(getter==null){throw"Could not find the function name:"+funcName
}var getterResult=getter.apply(this,[]);
var attibuteName=signature[2];
if(!$defined(attibuteName)){throw"Could not find attribute mapping for:"+key
}var result=getterResult[attibuteName];
if(!$defined(result)){throw"Could not find attribute with name:"+attibuteName
}return result
},setOpacity:function(opacity){this._peer.setStroke(null,null,null,opacity);
this._peer.setFill(null,opacity)
},setVisibility:function(isVisible){this._peer.setVisibility(isVisible)
},isVisible:function(){return this._peer.isVisible()
},moveToFront:function(){this._peer.moveToFront()
},moveToBack:function(){this._peer.moveToBack()
},getStroke:function(){return this._peer.getStroke()
},setCursor:function(type){this._peer.setCursor(type)
},getParent:function(){return this._peer.getParent()
}});
web2d.Element._SIGNATURE_MULTIPLE_ARGUMENTS=-1;
web2d.Element._supportedEvents=["click","dblclick","mousemove","mouseout","mouseover","mousedown","mouseup"];
web2d.Element._propertyNameToSignature={size:["size",-1],width:["size",0,"width"],height:["size",1,"height"],position:["position",-1],x:["position",0,"x"],y:["position",1,"y"],stroke:["stroke",-1],strokeWidth:["stroke",0,"width"],strokeStyle:["stroke",1,"style"],strokeColor:["stroke",2,"color"],strokeOpacity:["stroke",3,"opacity"],fill:["fill",-1],fillColor:["fill",0,"color"],fillOpacity:["fill",1,"opacity"],coordSize:["coordSize",-1],coordSizeWidth:["coordSize",0,"width"],coordSizeHeight:["coordSize",1,"height"],coordOrigin:["coordOrigin",-1],coordOriginX:["coordOrigin",0,"x"],coordOriginY:["coordOrigin",1,"y"],visibility:["visibility",0],opacity:["opacity",0]};web2d.Elipse=new Class({Extends:web2d.Element,initialize:function(attributes){var peer=web2d.peer.Toolkit.createElipse();
var defaultAttributes={width:40,height:40,x:5,y:5,stroke:"1 solid black",fillColor:"blue"};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}this.parent(peer,defaultAttributes)
},getType:function(){return"Elipse"
},getSize:function(){return this._peer.getSize()
}});web2d.Font=new Class({initialize:function(fontFamily,textPeer){var font="web2d.peer.Toolkit.create"+fontFamily+"Font();";
this._peer=eval(font);
this._textPeer=textPeer
},getHtmlSize:function(){var scale=web2d.peer.utils.TransformUtil.workoutScale(this._textPeer);
return this._peer.getHtmlSize(scale)
},getGraphSize:function(){var scale=web2d.peer.utils.TransformUtil.workoutScale(this._textPeer);
return this._peer.getGraphSize(scale)
},getFontScale:function(){return web2d.peer.utils.TransformUtil.workoutScale(this._textPeer).height
},getSize:function(){return this._peer.getSize()
},getStyle:function(){return this._peer.getStyle()
},getWeight:function(){return this._peer.getWeight()
},getFontFamily:function(){return this._peer.getFontFamily()
},setSize:function(size){return this._peer.setSize(size)
},setStyle:function(style){return this._peer.setStyle(style)
},setWeight:function(weight){return this._peer.setWeight(weight)
},getFont:function(){return this._peer.getFont()
},getWidthMargin:function(){return this._peer.getWidthMargin()
}});
web2d.Font.ARIAL="Arial";
web2d.Font.TIMES="Times";
web2d.Font.TAHOMA="Tahoma";
web2d.Font.VERDANA="Verdana";web2d.Group=new Class({Extends:web2d.Element,initialize:function(attributes){var peer=web2d.peer.Toolkit.createGroup();
var defaultAttributes={width:50,height:50,x:50,y:50,coordOrigin:"0 0",coordSize:"50 50"};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}this.parent(peer,defaultAttributes)
},removeChild:function(element){if(!$defined(element)){throw"Child element can not be null"
}if(element==this){throw"It's not possible to add the group as a child of itself"
}var elementType=element.getType();
if(elementType==null){throw"It seems not to be an element ->"+element
}this._peer.removeChild(element._peer)
},appendChild:function(element){if(!$defined(element)){throw"Child element can not be null"
}if(element==this){throw"It's not posible to add the group as a child of itself"
}var elementType=element.getType();
if(elementType==null){throw"It seems not to be an element ->"+element
}if(elementType=="Workspace"){throw"A group can not have a workspace as a child"
}this._peer.appendChild(element._peer)
},getType:function(){return"Group"
},setCoordSize:function(width,height){this._peer.setCoordSize(width,height)
},setCoordOrigin:function(x,y){this._peer.setCoordOrigin(x,y)
},getCoordOrigin:function(){return this._peer.getCoordOrigin()
},getSize:function(){return this._peer.getSize()
},setFill:function(color,opacity){throw"Unsupported operation. Fill can not be set to a group"
},setStroke:function(width,style,color,opacity){throw"Unsupported operation. Stroke can not be set to a group"
},getCoordSize:function(){return this._peer.getCoordSize()
},appendDomChild:function(DomElement){if(!$defined(DomElement)){throw"Child element can not be null"
}if(DomElement==this){throw"It's not possible to add the group as a child of itself"
}this._peer._native.appendChild(DomElement)
},setOpacity:function(value){this._peer.setOpacity(value)
}});web2d.Image=new Class({Extends:web2d.Element,initialize:function(attributes){var peer=web2d.peer.Toolkit.createImage();
this.parent(peer,attributes)
},getType:function(){return"Image"
},setHref:function(href){this._peer.setHref(href)
},getHref:function(){return this._peer.getHref()
},getSize:function(){return this._peer.getSize()
}});web2d.Line=new Class({Extends:web2d.Element,initialize:function(attributes){var peer=web2d.peer.Toolkit.createLine();
var defaultAttributes={strokeColor:"#495879",strokeWidth:1,strokeOpacity:1};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}this.parent(peer,defaultAttributes)
},getType:function(){return"Line"
},setFrom:function(x,y){this._peer.setFrom(x,y)
},setTo:function(x,y){this._peer.setTo(x,y)
},getFrom:function(){return this._peer.getFrom()
},getTo:function(){return this._peer.getTo()
},setArrowStyle:function(startStyle,endStyle){this._peer.setArrowStyle(startStyle,endStyle)
},setPosition:function(cx,cy){throw"Unsupported operation"
},setSize:function(width,height){throw"Unsupported operation"
},setFill:function(color,opacity){throw"Unsupported operation"
}});web2d.PolyLine=new Class({Extends:web2d.Element,initialize:function(attributes){var peer=web2d.peer.Toolkit.createPolyLine();
var defaultAttributes={strokeColor:"blue",strokeWidth:1,strokeStyle:"solid",strokeOpacity:1};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}this.parent(peer,defaultAttributes)
},getType:function(){return"PolyLine"
},setFrom:function(x,y){this._peer.setFrom(x,y)
},setTo:function(x,y){this._peer.setTo(x,y)
},setStyle:function(style){this._peer.setStyle(style)
},getStyle:function(){return this._peer.getStyle()
},buildCurvedPath:function(dist,x1,y1,x2,y2){var signx=1;
var signy=1;
if(x2<x1){signx=-1
}if(y2<y1){signy=-1
}var path;
if(Math.abs(y1-y2)>2){var middlex=x1+((x2-x1>0)?dist:-dist);
path=x1.toFixed(1)+", "+y1.toFixed(1)+" "+middlex.toFixed(1)+", "+y1.toFixed(1)+" "+middlex.toFixed(1)+", "+(y2-5*signy).toFixed(1)+" "+(middlex+5*signx).toFixed(1)+", "+y2.toFixed(1)+" "+x2.toFixed(1)+", "+y2.toFixed(1)
}else{path=x1.toFixed(1)+", "+y1.toFixed(1)+" "+x2.toFixed(1)+", "+y2.toFixed(1)
}return path
},buildStraightPath:function(dist,x1,y1,x2,y2){var middlex=x1+((x2-x1>0)?dist:-dist);
return x1+", "+y1+" "+middlex+", "+y1+" "+middlex+", "+y2+" "+x2+", "+y2
}});web2d.CurvedLine=new Class({Extends:web2d.Element,initialize:function(attributes){var peer=web2d.peer.Toolkit.createCurvedLine();
var defaultAttributes={strokeColor:"blue",strokeWidth:1,strokeStyle:"solid",strokeOpacity:1};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}this.parent(peer,defaultAttributes)
},getType:function(){return"CurvedLine"
},setFrom:function(x,y){$assert(!isNaN(x),"x must be defined");
$assert(!isNaN(y),"y must be defined");
this._peer.setFrom(x,y)
},setTo:function(x,y){$assert(!isNaN(x),"x must be defined");
$assert(!isNaN(y),"y must be defined");
this._peer.setTo(x,y)
},getFrom:function(){return this._peer.getFrom()
},getTo:function(){return this._peer.getTo()
},setShowEndArrow:function(visible){this._peer.setShowEndArrow(visible)
},isShowEndArrow:function(){return this._peer.isShowEndArrow()
},setShowStartArrow:function(visible){this._peer.setShowStartArrow(visible)
},isShowStartArrow:function(){return this._peer.isShowStartArrow()
},setSrcControlPoint:function(control){this._peer.setSrcControlPoint(control)
},setDestControlPoint:function(control){this._peer.setDestControlPoint(control)
},getControlPoints:function(){return this._peer.getControlPoints()
},isSrcControlPointCustom:function(){return this._peer.isSrcControlPointCustom()
},isDestControlPointCustom:function(){return this._peer.isDestControlPointCustom()
},setIsSrcControlPointCustom:function(isCustom){this._peer.setIsSrcControlPointCustom(isCustom)
},setIsDestControlPointCustom:function(isCustom){this._peer.setIsDestControlPointCustom(isCustom)
},updateLine:function(avoidControlPointFix){return this._peer.updateLine(avoidControlPointFix)
},setStyle:function(style){this._peer.setLineStyle(style)
},getStyle:function(){return this._peer.getLineStyle()
},setDashed:function(length,spacing){this._peer.setDashed(length,spacing)
}});
web2d.CurvedLine.SIMPLE_LINE=false;
web2d.CurvedLine.NICE_LINE=true;web2d.Arrow=new Class({Extends:web2d.Element,initialize:function(attributes){var peer=web2d.peer.Toolkit.createArrow();
var defaultAttributes={strokeColor:"black",strokeWidth:1,strokeStyle:"solid",strokeOpacity:1};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}this.parent(peer,defaultAttributes)
},getType:function(){return"Arrow"
},setFrom:function(x,y){this._peer.setFrom(x,y)
},setControlPoint:function(point){this._peer.setControlPoint(point)
},setStrokeColor:function(color){this._peer.setStrokeColor(color)
},setStrokeWidth:function(width){this._peer.setStrokeWidth(width)
},setDashed:function(isDashed,length,spacing){this._peer.setDashed(isDashed,length,spacing)
}});web2d.Rect=new Class({Extends:web2d.Element,initialize:function(arc,attributes){if(arc&&arc>1){throw"Arc must be 0<=arc<=1"
}if(arguments.length<=0){var rx=0;
var ry=0
}var peer=web2d.peer.Toolkit.createRect(arc);
var defaultAttributes={width:40,height:40,x:5,y:5,stroke:"1 solid black",fillColor:"green"};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}this.parent(peer,defaultAttributes)
},getType:function(){return"Rect"
},getSize:function(){return this._peer.getSize()
}});web2d.Text=new Class({Extends:web2d.Element,initialize:function(attributes){var peer=web2d.peer.Toolkit.createText();
this.parent(peer,attributes)
},getType:function(){return"Text"
},setText:function(text){this._peer.setText(text)
},setTextAlignment:function(align){$assert(align,"align can not be null");
this._peer.setTextAlignment(align)
},setTextSize:function(width,height){this._peer.setContentSize(width,height)
},getText:function(){return this._peer.getText()
},setFont:function(font,size,style,weight){this._peer.setFont(font,size,style,weight)
},setColor:function(color){this._peer.setColor(color)
},getColor:function(){return this._peer.getColor()
},setStyle:function(style){this._peer.setStyle(style)
},setWeight:function(weight){this._peer.setWeight(weight)
},setFontFamily:function(family){this._peer.setFontFamily(family)
},getFont:function(){return this._peer.getFont()
},setSize:function(size){this._peer.setSize(size)
},getHtmlFontSize:function(){return this._peer.getHtmlFontSize()
},getWidth:function(){return this._peer.getWidth()
},getHeight:function(){return parseInt(this._peer.getHeight())
},getFontHeight:function(){var lines=this._peer.getText().split("\n").length;
return Math.round(this.getHeight()/lines)
}});web2d.peer.ToolkitSVG={init:function(){},createWorkspace:function(element){return new web2d.peer.svg.WorkspacePeer(element)
},createGroup:function(element){return new web2d.peer.svg.GroupPeer()
},createElipse:function(){return new web2d.peer.svg.ElipsePeer()
},createLine:function(){return new web2d.peer.svg.LinePeer()
},createPolyLine:function(){return new web2d.peer.svg.PolyLinePeer()
},createCurvedLine:function(){return new web2d.peer.svg.CurvedLinePeer()
},createArrow:function(){return new web2d.peer.svg.ArrowPeer()
},createText:function(){return new web2d.peer.svg.TextPeer()
},createImage:function(){return new web2d.peer.svg.ImagePeer()
},createRect:function(arc){return new web2d.peer.svg.RectPeer(arc)
},createArialFont:function(){return new web2d.peer.svg.ArialFont()
},createTimesFont:function(){return new web2d.peer.svg.TimesFont()
},createVerdanaFont:function(){return new web2d.peer.svg.VerdanaFont()
},createTahomaFont:function(){return new web2d.peer.svg.TahomaFont()
}};
web2d.peer.Toolkit=web2d.peer.ToolkitSVG;web2d.Workspace=new Class({Extends:web2d.Element,initialize:function(attributes){this._htmlContainer=this._createDivContainer();
var peer=web2d.peer.Toolkit.createWorkspace(this._htmlContainer);
var defaultAttributes={width:"200px",height:"200px",stroke:"1px solid #edf1be",fillColor:"white",coordOrigin:"0 0",coordSize:"200 200"};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}this.parent(peer,defaultAttributes);
this._htmlContainer.appendChild(this._peer._native)
},getType:function(){return"Workspace"
},appendChild:function(element){if(!$defined(element)){throw"Child element can not be null"
}var elementType=element.getType();
if(elementType==null){throw"It seems not to be an element ->"+element
}if(elementType=="Workspace"){throw"A workspace can not have a workspace as a child"
}this._peer.appendChild(element._peer)
},addItAsChildTo:function(element){if(!$defined(element)){throw"Workspace div container can not be null"
}element.appendChild(this._htmlContainer)
},_createDivContainer:function(domElement){var container=window.document.createElement("div");
container.id="workspaceContainer";
container.style.position="relative";
container.style.top="0px";
container.style.left="0px";
container.style.height="688px";
container.style.border="1px solid red";
return container
},setSize:function(width,height){if($defined(width)){this._htmlContainer.style.width=width
}if($defined(height)){this._htmlContainer.style.height=height
}this._peer.setSize(width,height)
},setCoordSize:function(width,height){this._peer.setCoordSize(width,height)
},setCoordOrigin:function(x,y){this._peer.setCoordOrigin(x,y)
},getCoordOrigin:function(){return this._peer.getCoordOrigin()
},_getHtmlContainer:function(){return this._htmlContainer
},setFill:function(color,opacity){this._htmlContainer.style.backgroundColor=color;
if(opacity||opacity===0){throw"Unsupported operation. Opacity not supported."
}},getFill:function(){var color=this._htmlContainer.style.backgroundColor;
return{color:color}
},getSize:function(){var width=this._htmlContainer.style.width;
var height=this._htmlContainer.style.height;
return{width:width,height:height}
},setStroke:function(width,style,color,opacity){if(style!="solid"){throw"Not supported style stroke style:"+style
}this._htmlContainer.style.border=width+" "+style+" "+color;
if(opacity||opacity===0){throw"Unsupported operation. Opacity not supported."
}},getCoordSize:function(){return this._peer.getCoordSize()
},removeChild:function(element){if(!$defined(element)){throw"Child element can not be null"
}if(element==this){throw"It's not possible to add the group as a child of itself"
}var elementType=element.getType();
if(elementType==null){throw"It seems not to be an element ->"+element
}this._peer.removeChild(element._peer)
},dumpNativeChart:function(){var elem=this._htmlContainer;
return elem.innerHTML
}});core.Point=new Class({initialize:function(x,y){this.x=x;
this.y=y
},setValue:function(x,y){this.x=x;
this.y=y
},inspect:function(){return"{x:"+this.x+",y:"+this.y+"}"
},clone:function(){return new core.Point(this.x,this.y)
}});
core.Point.fromString=function(point){var values=point.split(",");
return new core.Point(values[0],values[1])
};mindplot.Messages=new Class({Static:{init:function(locale){locale=$defined(locale)?locale:"en";
var bundle=mindplot.Messages.BUNDLES[locale];
if(bundle==null&&locale.indexOf("_")!=-1){locale=locale.substring(0,locale.indexOf("_"));
bundle=mindplot.Messages.BUNDLES[locale]
}mindplot.Messages.__bundle=bundle
}}});
$msg=function(key){if(!mindplot.Messages.__bundle){mindplot.Messages.init("en")
}var msg=mindplot.Messages.__bundle[key];
return msg?msg:key
};
mindplot.Messages.BUNDLES={};mindplot.TopicEventDispatcher=new Class({Extends:Events,Static:{_instance:null,configure:function(readOnly){this._instance=new mindplot.TopicEventDispatcher(readOnly)
},getInstance:function(){return this._instance
}},initialize:function(readOnly){this._readOnly=readOnly;
this._activeEditor=null;
this._multilineEditor=new mindplot.MultilineTextEditor()
},close:function(update){if(this.isVisible()){this._activeEditor.close(update);
this._activeEditor=null
}},show:function(topic,options){this.process(mindplot.TopicEvent.EDIT,topic,options)
},process:function(eventType,topic,options){$assert(eventType,"eventType can not be null");
if(this.isVisible()){this.close()
}var model=topic.getModel();
if(model.getShapeType()!=mindplot.model.TopicShape.IMAGE&&!this._readOnly&&eventType==mindplot.TopicEvent.EDIT){this._multilineEditor.show(topic,options?options.text:null);
this._activeEditor=this._multilineEditor
}else{this.fireEvent(eventType,{model:model,readOnly:this._readOnly})
}},isVisible:function(){return this._activeEditor!=null&&this._activeEditor.isVisible()
}});
mindplot.TopicEvent={EDIT:"editnode",CLICK:"clicknode"};mindplot.model.IMindmap=new Class({initialize:function(){throw"Unsupported operation"
},getCentralTopic:function(){return this.getBranches()[0]
},getDescription:function(){throw"Unsupported operation"
},setDescription:function(value){throw"Unsupported operation"
},getId:function(){throw"Unsupported operation"
},setId:function(id){throw"Unsupported operation"
},getVersion:function(){throw"Unsupported operation"
},setVersion:function(version){throw"Unsupported operation"
},addBranch:function(nodeModel){throw"Unsupported operation"
},getBranches:function(){throw"Unsupported operation"
},removeBranch:function(node){throw"Unsupported operation"
},getRelationships:function(){throw"Unsupported operation"
},connect:function(parent,child){$assert(!child.getParent(),"Child model seems to be already connected");
parent.appendChild(child);
this.removeBranch(child)
},disconnect:function(child){var parent=child.getParent();
$assert(child,"Child can not be null.");
$assert(parent,"Child model seems to be already connected");
parent.removeChild(child);
this.addBranch(child)
},hasAlreadyAdded:function(node){throw"Unsupported operation"
},createNode:function(type,id){throw"Unsupported operation"
},createRelationship:function(fromNode,toNode){throw"Unsupported operation"
},addRelationship:function(rel){throw"Unsupported operation"
},deleteRelationship:function(relationship){throw"Unsupported operation"
},inspect:function(){var result="";
result="{ ";
var branches=this.getBranches();
result=result+"version:"+this.getVersion();
result=result+" , [";
for(var i=0;
i<branches.length;
i++){var node=branches[i];
if(i!=0){result=result+",\n "
}result=result+"("+i+") =>"+node.inspect()
}result=result+"]";
result=result+" } ";
return result
},copyTo:function(target){var source=this;
var version=source.getVersion();
target.setVersion(version);
var desc=this.getDescription();
target.setDescription(desc);
var sbranchs=source.getBranches();
sbranchs.each(function(snode){var tnode=target.createNode(snode.getType(),snode.getId());
snode.copyTo(tnode);
target.addBranch(tnode)
})
}});mindplot.model.Mindmap=new Class({Extends:mindplot.model.IMindmap,initialize:function(id,version){$assert(id,"Id can not be null");
this._branches=[];
this._description=null;
this._relationships=[];
this._version=$defined(version)?version:mindplot.persistence.ModelCodeName.TANGO;
this._id=id
},getDescription:function(){return this._description
},setDescription:function(value){this._description=value
},getId:function(){return this._id
},setId:function(id){this._id=id
},getVersion:function(){return this._version
},setVersion:function(version){this._version=version
},addBranch:function(nodeModel){$assert(nodeModel&&nodeModel.isNodeModel(),"Add node must be invoked with model objects");
var branches=this.getBranches();
if(branches.length==0){$assert(nodeModel.getType()==mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE,"First element must be the central topic");
nodeModel.setPosition(0,0)
}else{$assert(nodeModel.getType()!=mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE,"Mindmaps only have one cental topic")
}this._branches.push(nodeModel)
},removeBranch:function(nodeModel){$assert(nodeModel&&nodeModel.isNodeModel(),"Remove node must be invoked with model objects");
return this._branches.erase(nodeModel)
},getBranches:function(){return this._branches
},getRelationships:function(){return this._relationships
},hasAlreadyAdded:function(node){var result=false;
var branches=this._branches;
for(var i=0;
i<branches.length;
i++){result=branches[i]._isChildNode(node);
if(result){break
}}},createNode:function(type,id){type=!$defined(type)?mindplot.model.INodeModel.MAIN_TOPIC_TYPE:type;
return new mindplot.model.NodeModel(type,this,id)
},createRelationship:function(sourceNodeId,targetNodeId){$assert($defined(sourceNodeId),"from node cannot be null");
$assert($defined(targetNodeId),"to node cannot be null");
return new mindplot.model.RelationshipModel(sourceNodeId,targetNodeId)
},addRelationship:function(relationship){this._relationships.push(relationship)
},deleteRelationship:function(relationship){this._relationships.erase(relationship)
},findNodeById:function(id){var result=null;
for(var i=0;
i<this._branches.length;
i++){var branch=this._branches[i];
result=branch.findNodeById(id);
if(result){break
}}return result
}});
mindplot.model.Mindmap.buildEmpty=function(mapId){var result=new mindplot.model.Mindmap(mapId);
var node=result.createNode(mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE,0);
result.addBranch(node);
return result
};mindplot.model.INodeModel=new Class({initialize:function(mindmap){$assert(mindmap&&mindmap.getBranches,"mindmap can not be null");
this._mindmap=mindmap
},getId:function(){return this.getProperty("id")
},setId:function(id){if($defined(id)&&id>mindplot.model.INodeModel._uuid){mindplot.model.INodeModel._uuid=id
}if(!$defined(id)){id=mindplot.model.INodeModel._nextUUID()
}this.putProperty("id",id)
},getType:function(){return this.getProperty("type")
},setType:function(type){this.putProperty("type",type)
},setText:function(text){this.putProperty("text",text)
},getText:function(){return this.getProperty("text")
},setPosition:function(x,y){$assert(!isNaN(parseInt(x)),"x position is not valid:"+x);
$assert(!isNaN(parseInt(y)),"y position is not valid:"+y);
this.putProperty("position","{x:"+parseInt(x)+",y:"+parseInt(y)+"}")
},getPosition:function(){var value=this.getProperty("position");
var result=null;
if(value!=null){result=eval("("+value+")")
}return result
},setImageSize:function(width,height){this.putProperty("imageSize","{width:"+width+",height:"+height+"}")
},getImageSize:function(){var value=this.getProperty("imageSize");
var result=null;
if(value!=null){result=eval("("+value+")")
}return result
},setImageUrl:function(url){this.putProperty("imageUrl",url)
},getMetadata:function(){return this.getProperty("metadata")
},setMetadata:function(json){this.putProperty("metadata",json)
},getImageUrl:function(){return this.getProperty("imageUrl")
},getMindmap:function(){return this._mindmap
},disconnect:function(){var mindmap=this.getMindmap();
mindmap.disconnect(this)
},getShapeType:function(){return this.getProperty("shapeType")
},setShapeType:function(type){this.putProperty("shapeType",type)
},setOrder:function(value){$assert(typeof value==="number"&&isFinite(value)||value==null,"Order must be null or a number");
this.putProperty("order",value)
},getOrder:function(){return this.getProperty("order")
},setFontFamily:function(fontFamily){this.putProperty("fontFamily",fontFamily)
},getFontFamily:function(){return this.getProperty("fontFamily")
},setFontStyle:function(fontStyle){this.putProperty("fontStyle",fontStyle)
},getFontStyle:function(){return this.getProperty("fontStyle")
},setFontWeight:function(weight){this.putProperty("fontWeight",weight)
},getFontWeight:function(){return this.getProperty("fontWeight")
},setFontColor:function(color){this.putProperty("fontColor",color)
},getFontColor:function(){return this.getProperty("fontColor")
},setFontSize:function(size){this.putProperty("fontSize",size)
},getFontSize:function(){return this.getProperty("fontSize")
},getBorderColor:function(){return this.getProperty("borderColor")
},setBorderColor:function(color){this.putProperty("borderColor",color)
},getBackgroundColor:function(){return this.getProperty("backgroundColor")
},setBackgroundColor:function(color){this.putProperty("backgroundColor",color)
},areChildrenShrunken:function(){var result=this.getProperty("shrunken");
return $defined(result)?result:false
},setChildrenShrunken:function(value){this.putProperty("shrunken",value)
},isNodeModel:function(){return true
},isConnected:function(){return this.getParent()!=null
},appendChild:function(node){throw"Unsupported operation"
},connectTo:function(parent){$assert(parent,"parent can not be null");
var mindmap=this.getMindmap();
mindmap.connect(parent,this)
},copyTo:function(target){var source=this;
var keys=source.getPropertiesKeys();
keys.each(function(key){var value=source.getProperty(key);
target.putProperty(key,value)
});
var children=this.getChildren();
var tmindmap=target.getMindmap();
children.each(function(snode){var tnode=tmindmap.createNode(snode.getType(),snode.getId());
snode.copyTo(tnode);
target.appendChild(tnode)
});
return target
},deleteNode:function(){var mindmap=this.getMindmap();
var parent=this.getParent();
if($defined(parent)){parent.removeChild(this)
}else{mindmap.removeBranch(this)
}},getPropertiesKeys:function(){throw"Unsupported operation"
},putProperty:function(key,value){throw"Unsupported operation"
},setParent:function(parent){throw"Unsupported operation"
},getChildren:function(){throw"Unsupported operation"
},getParent:function(){throw"Unsupported operation"
},clone:function(){throw"Unsupported operation"
},inspect:function(){var result="{ type: "+this.getType()+" , id: "+this.getId()+" , text: "+this.getText();
var children=this.getChildren();
if(children.length>0){result=result+", children: {(size:"+children.length;
children.each(function(node){result=result+"=> (";
var keys=node.getPropertiesKeys();
keys.each(function(key){var value=node.getProperty(key);
result=result+key+":"+value+","
});
result=result+"}"
}.bind(this))
}result=result+" }";
return result
},removeChild:function(child){throw"Unsupported operation"
}});
mindplot.model.TopicShape={RECTANGLE:"rectagle",ROUNDED_RECT:"rounded rectagle",ELLIPSE:"elipse",LINE:"line",IMAGE:"image"};
mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE="CentralTopic";
mindplot.model.INodeModel.MAIN_TOPIC_TYPE="MainTopic";
mindplot.model.INodeModel.MAIN_TOPIC_TO_MAIN_TOPIC_DISTANCE=220;
mindplot.model.INodeModel._nextUUID=function(){if(!$defined(mindplot.model.INodeModel._uuid)){mindplot.model.INodeModel._uuid=0
}mindplot.model.INodeModel._uuid=mindplot.model.INodeModel._uuid+1;
return mindplot.model.INodeModel._uuid
};
mindplot.model.INodeModel._uuid=0;mindplot.model.NodeModel=new Class({Extends:mindplot.model.INodeModel,initialize:function(type,mindmap,id){$assert(type,"Node type can not be null");
$assert(mindmap,"mindmap can not be null");
this._properties={};
this.parent(mindmap);
this.setId(id);
this.setType(type);
this.areChildrenShrunken(false);
this._children=[];
this._feature=[]
},createFeature:function(type,attributes){return mindplot.TopicFeature.createModel(type,attributes)
},addFeature:function(feature){$assert(feature,"feature can not be null");
this._feature.push(feature)
},getFeatures:function(){return this._feature
},removeFeature:function(feature){$assert(feature,"feature can not be null");
var size=this._feature.length;
this._feature=this._feature.filter(function(f){return feature.getId()!=f.getId()
});
$assert(size-1==this._feature.length,"Could not be removed ...")
},findFeatureByType:function(type){$assert(type,"type can not be null");
return this._feature.filter(function(feature){return feature.getType()==type
})
},findFeatureById:function(id){$assert($defined(id),"id can not be null");
var result=this._feature.filter(function(feature){return feature.getId()==id
});
$assert(result.length==1,"Feature could not be found:"+id);
return result[0]
},getPropertiesKeys:function(){return Object.keys(this._properties)
},putProperty:function(key,value){$defined(key,"key can not be null");
this._properties[key]=value
},getProperties:function(){return this._properties
},getProperty:function(key){$defined(key,"key can not be null");
var result=this._properties[key];
return !$defined(result)?null:result
},clone:function(){var result=new mindplot.model.NodeModel(this.getType(),this._mindmap);
result._children=this._children.map(function(node){var cnode=node.clone();
cnode._parent=result;
return cnode
});
result._properties=Object.clone(this._properties);
result._feature=this._feature.clone();
return result
},deepCopy:function(){var result=new mindplot.model.NodeModel(this.getType(),this._mindmap);
result._children=this._children.map(function(node){var cnode=node.deepCopy();
cnode._parent=result;
return cnode
});
var id=result.getId();
result._properties=Object.clone(this._properties);
result.setId(id);
result._feature=this._feature.clone();
return result
},appendChild:function(child){$assert(child&&child.isNodeModel(),"Only NodeModel can be appended to Mindmap object");
this._children.push(child);
child._parent=this
},removeChild:function(child){$assert(child&&child.isNodeModel(),"Only NodeModel can be appended to Mindmap object.");
this._children.erase(child);
child._parent=null
},getChildren:function(){return this._children
},getParent:function(){return this._parent
},setParent:function(parent){$assert(parent!=this,"The same node can not be parent and child if itself.");
this._parent=parent
},_isChildNode:function(node){var result=false;
if(node==this){result=true
}else{var children=this.getChildren();
for(var i=0;
i<children.length;
i++){var child=children[i];
result=child._isChildNode(node);
if(result){break
}}}return result
},findNodeById:function(id){var result=null;
if(this.getId()==id){result=this
}else{var children=this.getChildren();
for(var i=0;
i<children.length;
i++){var child=children[i];
result=child.findNodeById(id);
if(result){break
}}}return result
}});mindplot.model.RelationshipModel=new Class({Static:{_nextUUID:function(){if(!$defined(mindplot.model.RelationshipModel._uuid)){mindplot.model.RelationshipModel._uuid=0
}mindplot.model.RelationshipModel._uuid=mindplot.model.RelationshipModel._uuid+1;
return mindplot.model.RelationshipModel._uuid
}},initialize:function(sourceTopicId,targetTopicId){$assert($defined(sourceTopicId),"from node type can not be null");
$assert($defined(targetTopicId),"to node type can not be null");
this._id=mindplot.model.RelationshipModel._nextUUID();
this._sourceTargetId=sourceTopicId;
this._targetTopicId=targetTopicId;
this._lineType=mindplot.ConnectionLine.SIMPLE_CURVED;
this._srcCtrlPoint=null;
this._destCtrlPoint=null;
this._endArrow=true;
this._startArrow=false
},getFromNode:function(){return this._sourceTargetId
},getToNode:function(){return this._targetTopicId
},getId:function(){$assert(this._id,"id is null");
return this._id
},getLineType:function(){return this._lineType
},setLineType:function(lineType){this._lineType=lineType
},getSrcCtrlPoint:function(){return this._srcCtrlPoint
},setSrcCtrlPoint:function(srcCtrlPoint){this._srcCtrlPoint=srcCtrlPoint
},getDestCtrlPoint:function(){return this._destCtrlPoint
},setDestCtrlPoint:function(destCtrlPoint){this._destCtrlPoint=destCtrlPoint
},getEndArrow:function(){return this._endArrow
},setEndArrow:function(endArrow){this._endArrow=endArrow
},getStartArrow:function(){return this._startArrow
},setStartArrow:function(startArrow){this._startArrow=startArrow
},clone:function(model){var result=new mindplot.model.RelationshipModel(this._sourceTargetId,this._targetTopicId);
result._id=this._id;
result._lineType=this._lineType;
result._srcCtrlPoint=this._srcCtrlPoint;
result._destCtrlPoint=this._destCtrlPoint;
result._endArrow=this._endArrow;
result._startArrow=this._startArrow;
return result
},inspect:function(){return"(fromNode:"+this.getFromNode().getId()+" , toNode: "+this.getToNode().getId()+")"
}});mindplot.ActionDispatcher=new Class({Implements:[Events],initialize:function(commandContext){$assert(commandContext,"commandContext can not be null")
},addRelationship:function(model,mindmap){throw"method must be implemented."
},addTopics:function(models,parentTopicId){throw"method must be implemented."
},deleteEntities:function(topicsIds,relIds){throw"method must be implemented."
},dragTopic:function(topicId,position,order,parentTopic){throw"method must be implemented."
},moveTopic:function(topicId,position){throw"method must be implemented."
},moveControlPoint:function(ctrlPoint,point){throw"method must be implemented."
},changeFontFamilyToTopic:function(topicIds,fontFamily){throw"method must be implemented."
},changeFontStyleToTopic:function(topicsIds){throw"method must be implemented."
},changeFontColorToTopic:function(topicsIds,color){throw"method must be implemented."
},changeFontSizeToTopic:function(topicsIds,size){throw"method must be implemented."
},changeBackgroundColorToTopic:function(topicsIds,color){throw"method must be implemented."
},changeBorderColorToTopic:function(topicsIds,color){throw"method must be implemented."
},changeShapeTypeToTopic:function(topicsIds,shapeType){throw"method must be implemented."
},changeFontWeightToTopic:function(topicsIds){throw"method must be implemented."
},changeTextToTopic:function(topicsIds,text){throw"method must be implemented."
},shrinkBranch:function(topicsIds,collapse){throw"method must be implemented."
},addFeatureToTopic:function(topicId,type,attributes){throw"method must be implemented."
},changeFeatureToTopic:function(topicId,featureId,attributes){throw"method must be implemented."
},removeFeatureFromTopic:function(topicId,featureId){throw"method must be implemented."
}});
mindplot.ActionDispatcher.setInstance=function(dispatcher){mindplot.ActionDispatcher._instance=dispatcher
};
mindplot.ActionDispatcher.getInstance=function(){return mindplot.ActionDispatcher._instance
};mindplot.StandaloneActionDispatcher=new Class({Extends:mindplot.ActionDispatcher,initialize:function(commandContext){this.parent(commandContext);
this._actionRunner=new mindplot.DesignerActionRunner(commandContext,this)
},addTopics:function(models,parentTopicsId){var command=new mindplot.commands.AddTopicCommand(models,parentTopicsId);
this.execute(command)
},addRelationship:function(model){var command=new mindplot.commands.AddRelationshipCommand(model);
this.execute(command)
},deleteEntities:function(topicsIds,relIds){var command=new mindplot.commands.DeleteCommand(topicsIds,relIds);
this.execute(command)
},dragTopic:function(topicId,position,order,parentTopic){var command=new mindplot.commands.DragTopicCommand(topicId,position,order,parentTopic);
this.execute(command)
},moveTopic:function(topicId,position){$assert($defined(topicId),"topicsId can not be null");
$assert($defined(position),"position can not be null");
var commandFunc=function(topic,value){var result=topic.getPosition();
mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.NodeMoveEvent,{node:topic.getModel(),position:value});
return result
};
var command=new mindplot.commands.GenericFunctionCommand(commandFunc,topicId,position);
this.execute(command)
},moveControlPoint:function(ctrlPoint,point){var command=new mindplot.commands.MoveControlPointCommand(ctrlPoint,point);
this.execute(command)
},changeFontStyleToTopic:function(topicsIds){var commandFunc=function(topic){var result=topic.getFontStyle();
var style=(result=="italic")?"normal":"italic";
topic.setFontStyle(style,true);
return result
};
var command=new mindplot.commands.GenericFunctionCommand(commandFunc,topicsIds);
this.execute(command)
},changeTextToTopic:function(topicsIds,text){$assert($defined(topicsIds),"topicsIds can not be null");
var commandFunc=function(topic,value){var result=topic.getText();
topic.setText(value);
return result
};
commandFunc.commandType="changeTextToTopic";
var command=new mindplot.commands.GenericFunctionCommand(commandFunc,topicsIds,text);
this.execute(command)
},changeFontFamilyToTopic:function(topicIds,fontFamily){$assert(topicIds,"topicIds can not be null");
$assert(fontFamily,"fontFamily can not be null");
var commandFunc=function(topic,fontFamily){var result=topic.getFontFamily();
topic.setFontFamily(fontFamily,true);
topic._adjustShapes();
return result
};
var command=new mindplot.commands.GenericFunctionCommand(commandFunc,topicIds,fontFamily);
this.execute(command)
},changeFontColorToTopic:function(topicsIds,color){$assert(topicsIds,"topicIds can not be null");
$assert(color,"color can not be null");
var commandFunc=function(topic,color){var result=topic.getFontColor();
topic.setFontColor(color,true);
return result
};
var command=new mindplot.commands.GenericFunctionCommand(commandFunc,topicsIds,color);
command.discardDuplicated="fontColorCommandId";
this.execute(command)
},changeBackgroundColorToTopic:function(topicsIds,color){$assert(topicsIds,"topicIds can not be null");
$assert(color,"color can not be null");
var commandFunc=function(topic,color){var result=topic.getBackgroundColor();
topic.setBackgroundColor(color);
return result
};
var command=new mindplot.commands.GenericFunctionCommand(commandFunc,topicsIds,color);
command.discardDuplicated="backColor";
this.execute(command)
},changeBorderColorToTopic:function(topicsIds,color){$assert(topicsIds,"topicIds can not be null");
$assert(color,"topicIds can not be null");
var commandFunc=function(topic,color){var result=topic.getBorderColor();
topic.setBorderColor(color);
return result
};
var command=new mindplot.commands.GenericFunctionCommand(commandFunc,topicsIds,color);
command.discardDuplicated="borderColorCommandId";
this.execute(command)
},changeFontSizeToTopic:function(topicsIds,size){$assert(topicsIds,"topicIds can not be null");
$assert(size,"size can not be null");
var commandFunc=function(topic,size){var result=topic.getFontSize();
topic.setFontSize(size,true);
topic._adjustShapes();
return result
};
var command=new mindplot.commands.GenericFunctionCommand(commandFunc,topicsIds,size);
this.execute(command)
},changeShapeTypeToTopic:function(topicsIds,shapeType){$assert(topicsIds,"topicsIds can not be null");
$assert(shapeType,"shapeType can not be null");
var commandFunc=function(topic,shapeType){var result=topic.getShapeType();
topic.setShapeType(shapeType,true);
return result
};
var command=new mindplot.commands.GenericFunctionCommand(commandFunc,topicsIds,shapeType);
this.execute(command)
},changeFontWeightToTopic:function(topicsIds){$assert(topicsIds,"topicsIds can not be null");
var commandFunc=function(topic){var result=topic.getFontWeight();
var weight=(result=="bold")?"normal":"bold";
topic.setFontWeight(weight,true);
topic._adjustShapes();
return result
};
var command=new mindplot.commands.GenericFunctionCommand(commandFunc,topicsIds);
this.execute(command)
},shrinkBranch:function(topicsIds,collapse){$assert(topicsIds,"topicsIds can not be null");
var commandFunc=function(topic,isShrink){topic.setChildrenShrunken(isShrink);
return !isShrink
};
var command=new mindplot.commands.GenericFunctionCommand(commandFunc,topicsIds,collapse);
this.execute(command,false)
},addFeatureToTopic:function(topicId,featureType,attributes){var command=new mindplot.commands.AddFeatureToTopicCommand(topicId,featureType,attributes);
this.execute(command)
},changeFeatureToTopic:function(topicId,featureId,attributes){var command=new mindplot.commands.ChangeFeatureToTopicCommand(topicId,featureId,attributes);
this.execute(command)
},removeFeatureFromTopic:function(topicId,featureId){var command=new mindplot.commands.RemoveFeatureFromTopicCommand(topicId,featureId);
this.execute(command)
},execute:function(command){this._actionRunner.execute(command)
}});
mindplot.CommandContext=new Class({initialize:function(designer){$assert(designer,"designer can not be null");
this._designer=designer
},findTopics:function(topicsIds){$assert($defined(topicsIds),"topicsIds can not be null");
if(!(topicsIds instanceof Array)){topicsIds=[topicsIds]
}var designerTopics=this._designer.getModel().getTopics();
var result=designerTopics.filter(function(topic){return topicsIds.contains(topic.getId())
});
if(result.length!=topicsIds.length){var ids=designerTopics.map(function(topic){return topic.getId()
});
$assert(result.length==topicsIds.length,"Could not find topic. Result:"+result+", Filter Criteria:"+topicsIds+", Current Topics: ["+ids+"]")
}return result
},deleteTopic:function(topic){this._designer._removeTopic(topic)
},createTopic:function(model){$assert(model,"model can not be null");
return this._designer._nodeModelToNodeGraph(model)
},createModel:function(){var mindmap=this._designer.getMindmap();
return mindmap.createNode(mindplot.NodeModel.MAIN_TOPIC_TYPE)
},connect:function(childTopic,parentTopic){childTopic.connectTo(parentTopic,this._designer._workspace)
},disconnect:function(topic){topic.disconnect(this._designer._workspace)
},addRelationship:function(model){$assert(model,"model cannot be null");
return this._designer._addRelationship(model)
},deleteRelationship:function(relationship){this._designer._deleteRelationship(relationship)
},findRelationships:function(relIds){$assert($defined(relIds),"relId can not be null");
if(!(relIds instanceof Array)){relIds=[relIds]
}var designerRel=this._designer.getModel().getRelationships();
return designerRel.filter(function(rel){return relIds.contains(rel.getId())
})
},moveTopic:function(topic,position){$assert(topic,"topic cannot be null");
$assert(position,"position cannot be null");
mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.NodeMoveEvent,{node:topic.getModel(),position:position})
}});mindplot.DesignerModel=new Class({Implements:[Events],initialize:function(options){this._zoom=options.zoom;
this._topics=[];
this._relationships=[]
},getZoom:function(){return this._zoom
},setZoom:function(zoom){this._zoom=zoom
},getTopics:function(){return this._topics
},getRelationships:function(){return this._relationships
},getCentralTopic:function(){var topics=this.getTopics();
return topics[0]
},filterSelectedTopics:function(){var result=[];
for(var i=0;
i<this._topics.length;
i++){if(this._topics[i].isOnFocus()){result.push(this._topics[i])
}}return result
},filterSelectedRelationships:function(){var result=[];
for(var i=0;
i<this._relationships.length;
i++){if(this._relationships[i].isOnFocus()){result.push(this._relationships[i])
}}return result
},getEntities:function(){var result=[].append(this._topics);
result.append(this._relationships);
return result
},removeTopic:function(topic){$assert(topic,"topic can not be null");
this._topics.erase(topic)
},removeRelationship:function(rel){$assert(rel,"rel can not be null");
this._relationships.erase(rel)
},addTopic:function(topic){$assert(topic,"topic can not be null");
$assert(typeof topic.getId()=="number","id is not a number:"+topic.getId());
this._topics.push(topic)
},addRelationship:function(rel){$assert(rel,"rel can not be null");
this._relationships.push(rel)
},filterTopicsIds:function(validate,errorMsg){var result=[];
var topics=this.filterSelectedTopics();
var isValid=true;
for(var i=0;
i<topics.length;
i++){var selectedNode=topics[i];
if($defined(validate)){isValid=validate(selectedNode)
}if(isValid){result.push(selectedNode.getId())
}else{$notify(errorMsg)
}}return result
},selectedTopic:function(){var topics=this.filterSelectedTopics();
return(topics.length>0)?topics[0]:null
},findTopicById:function(id){var result=null;
for(var i=0;
i<this._topics.length;
i++){var topic=this._topics[i];
if(topic.getId()==id){result=topic;
break
}}return result
}});mindplot.Designer=new Class({Extends:Events,initialize:function(options,divElement){$assert(options,"options must be defined");
$assert(options.zoom,"zoom must be defined");
$assert(divElement,"divElement must be defined");
mindplot.Messages.init(options.locale);
this._options=options;
divElement.setStyles(options.size);
var commandContext=new mindplot.CommandContext(this);
if(!$defined(options.collab)||options.collab=="standalone"){this._actionDispatcher=new mindplot.StandaloneActionDispatcher(commandContext)
}else{this._actionDispatcher=new mindplot.BrixActionDispatcher(commandContext)
}this._actionDispatcher.addEvent("modelUpdate",function(event){this.fireEvent("modelUpdate",event)
}.bind(this));
mindplot.ActionDispatcher.setInstance(this._actionDispatcher);
this._model=new mindplot.DesignerModel(options);
var screenManager=new mindplot.ScreenManager(divElement);
this._workspace=new mindplot.Workspace(screenManager,this._model.getZoom());
this._eventBussDispatcher=new mindplot.layout.EventBusDispatcher(this.getModel());
if(!this.isReadOnly()){this._registerMouseEvents();
mindplot.DesignerKeyboard.register(this);
this._dragManager=this._buildDragManager(this._workspace)
}this._registerWheelEvents();
this._relPivot=new mindplot.RelationshipPivot(this._workspace,this);
this.setViewPort(options.viewPort);
mindplot.TopicEventDispatcher.configure(this.isReadOnly());
this._clipboard=[]
},deactivateKeyboard:function(){mindplot.DesignerKeyboard.getInstance().deactivate();
this.deselectAll()
},_registerWheelEvents:function(){var workspace=this._workspace;
var screenManager=workspace.getScreenManager();
$(document).addEvent("mousewheel",function(event){var coords=screenManager.getContainer().getCoordinates();
var isOutsideContainer=event.client.y<coords.top||event.client.y>coords.bottom||event.client.x<coords.left||event.client.x>coords.right;
if(!isOutsideContainer){if(event.wheel>0){this.zoomIn(1.05)
}else{this.zoomOut(1.05)
}event.preventDefault()
}}.bind(this))
},activateKeyboard:function(){mindplot.DesignerKeyboard.getInstance().activate()
},addEvent:function(type,listener){if(type==mindplot.TopicEvent.EDIT||type==mindplot.TopicEvent.CLICK){var editor=mindplot.TopicEventDispatcher.getInstance();
editor.addEvent(type,listener)
}else{this.parent(type,listener)
}},_registerMouseEvents:function(){var workspace=this._workspace;
var screenManager=workspace.getScreenManager();
screenManager.addEvent("update",function(){var topics=this.getModel().getTopics();
topics.each(function(object){object.closeEditors()
});
if(this._cleanScreen){this._cleanScreen()
}}.bind(this));
screenManager.addEvent("click",function(event){this.onObjectFocusEvent(null,event)
}.bind(this));
screenManager.addEvent("dblclick",function(event){if(workspace.isWorkspaceEventsEnabled()){var mousePos=screenManager.getWorkspaceMousePosition(event);
var centralTopic=this.getModel().getCentralTopic();
var model=this._createChildModel(centralTopic,mousePos);
this._actionDispatcher.addTopics([model],[centralTopic.getId()])
}}.bind(this));
function noopHandler(evt){evt.stopPropagation();
evt.preventDefault()
}},_buildDragManager:function(workspace){var designerModel=this.getModel();
var dragConnector=new mindplot.DragConnector(designerModel,this._workspace);
var dragManager=new mindplot.DragManager(workspace,this._eventBussDispatcher);
var topics=designerModel.getTopics();
dragManager.addEvent("startdragging",function(){for(var i=0;
i<topics.length;
i++){topics[i].setMouseEventsEnabled(false)
}});
dragManager.addEvent("dragging",function(event,dragTopic){dragTopic.updateFreeLayout(event);
if(!dragTopic.isFreeLayoutOn(event)){dragConnector.checkConnection(dragTopic);
if(!dragTopic.isVisible()&&dragTopic.isConnected()){dragTopic.setVisibility(true)
}}});
dragManager.addEvent("enddragging",function(event,dragTopic){for(var i=0;
i<topics.length;
i++){topics[i].setMouseEventsEnabled(true)
}dragTopic.applyChanges(workspace)
});
return dragManager
},setViewPort:function(size){this._workspace.setViewPort(size);
var model=this.getModel();
this._workspace.setZoom(model.getZoom(),true)
},_buildNodeGraph:function(model,readOnly){var topic=mindplot.NodeGraph.create(model,{readOnly:readOnly});
this.getModel().addTopic(topic);
if(!readOnly){topic.addEvent("mousedown",function(event){this.onObjectFocusEvent(topic,event)
}.bind(this));
if(topic.getType()!=mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE){this._dragManager.add(topic)
}}var isConnected=model.isConnected();
if(isConnected){var targetTopicModel=model.getParent();
var targetTopic=null;
var topics=this.getModel().getTopics();
for(var i=0;
i<topics.length;
i++){var t=topics[i];
if(t.getModel()==targetTopicModel){targetTopic=t;
model.disconnect();
break
}}$assert(targetTopic,"Could not find a topic to connect");
topic.connectTo(targetTopic,this._workspace)
}topic.addEvent("ontblur",function(){var topics=this.getModel().filterSelectedTopics();
var rels=this.getModel().filterSelectedRelationships();
if(topics.length==0||rels.length==0){this.fireEvent("onblur")
}}.bind(this));
topic.addEvent("ontfocus",function(){var topics=this.getModel().filterSelectedTopics();
var rels=this.getModel().filterSelectedRelationships();
if(topics.length==1||rels.length==1){this.fireEvent("onfocus")
}}.bind(this));
return topic
},onObjectFocusEvent:function(currentObject,event){var topics=this.getModel().getTopics();
topics.each(function(topic){topic.closeEditors()
});
var model=this.getModel();
var objects=model.getEntities();
objects.each(function(object){if(!$defined(event)||(!event.control&&!event.meta)){if(object.isOnFocus()&&object!=currentObject){object.setOnFocus(false)
}}})
},selectAll:function(){var model=this.getModel();
var objects=model.getEntities();
objects.each(function(object){object.setOnFocus(true)
})
},deselectAll:function(){var objects=this.getModel().getEntities();
objects.each(function(object){object.setOnFocus(false)
})
},setZoom:function(zoom){if(zoom>1.9||zoom<0.3){$notify($msg("ZOOM_IN_ERROR"));
return
}this.getModel().setZoom(zoom);
this._workspace.setZoom(zoom)
},zoomOut:function(factor){if(!factor){factor=1.2
}var model=this.getModel();
var scale=model.getZoom()*factor;
if(scale<=1.9){model.setZoom(scale);
this._workspace.setZoom(scale)
}else{$notify($msg("ZOOM_ERROR"))
}},zoomIn:function(factor){if(!factor){factor=1.2
}var model=this.getModel();
var scale=model.getZoom()/factor;
if(scale>=0.3){model.setZoom(scale);
this._workspace.setZoom(scale)
}else{$notify($msg("ZOOM_ERROR"))
}},copyToClipboard:function(){var topics=this.getModel().filterSelectedTopics();
if(topics.length<=0){$notify($msg("AT_LEAST_ONE_TOPIC_MUST_BE_SELECTED"));
return
}topics=topics.filter(function(topic){return !topic.isCentralTopic()
});
this._clipboard=topics.map(function(topic){var nodeModel=topic.getModel().deepCopy();
var pos=nodeModel.getPosition();
nodeModel.setPosition(pos.x+(60*Math.sign(pos.x)),pos.y+30);
return nodeModel
});
$notify($msg("SELECTION_COPIED_TO_CLIPBOARD"))
},pasteClipboard:function(){if(this._clipboard.length==0){$notify($msg("CLIPBOARD_IS_EMPTY"));
return
}this._actionDispatcher.addTopics(this._clipboard);
this._clipboard=[]
},getModel:function(){return this._model
},shrinkSelectedBranch:function(){var nodes=this.getModel().filterSelectedTopics();
if(nodes.length<=0||nodes.length!=1){$notify($msg("ONLY_ONE_TOPIC_MUST_BE_SELECTED_COLLAPSE"));
return
}var topic=nodes[0];
this._actionDispatcher.shrinkBranch([topic.getId()],!topic.areChildrenShrunken())
},createChildForSelectedNode:function(){var nodes=this.getModel().filterSelectedTopics();
if(nodes.length<=0){$notify($msg("ONE_TOPIC_MUST_BE_SELECTED"));
return
}if(nodes.length!=1){$notify($msg("ONLY_ONE_TOPIC_MUST_BE_SELECTED"));
return
}var parentTopic=nodes[0];
var parentTopicId=parentTopic.getId();
var childModel=this._createChildModel(parentTopic);
this._actionDispatcher.addTopics([childModel],[parentTopicId])
},_createChildModel:function(topic,mousePos){var model=topic.getModel();
var mindmap=model.getMindmap();
var childModel=mindmap.createNode();
var layoutManager=this._eventBussDispatcher.getLayoutManager();
var result=layoutManager.predict(topic.getId(),null,mousePos);
childModel.setOrder(result.order);
var position=result.position;
childModel.setPosition(position.x,position.y);
return childModel
},addDraggedNode:function(event,model){$assert(event,"event can not be null");
$assert(model,"model can not be null");
model.setPosition(1000,1000);
this._actionDispatcher.addTopics([model]);
var topic=this.getModel().findTopicById(model.getId());
topic.fireEvent("mousedown",event)
},createSiblingForSelectedNode:function(){var nodes=this.getModel().filterSelectedTopics();
if(nodes.length<=0){$notify($msg("ONE_TOPIC_MUST_BE_SELECTED"));
return
}if(nodes.length>1){$notify($msg("ONLY_ONE_TOPIC_MUST_BE_SELECTED"));
return
}var topic=nodes[0];
if(!topic.getOutgoingConnectedTopic()){this.createChildForSelectedNode()
}else{var parentTopic=topic.getOutgoingConnectedTopic();
var siblingModel=this._createSiblingModel(topic);
if(parentTopic.getType()==mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE){siblingModel.setOrder(topic.getOrder()+2)
}var parentTopicId=parentTopic.getId();
this._actionDispatcher.addTopics([siblingModel],[parentTopicId])
}},_createSiblingModel:function(topic){var result=null;
var parentTopic=topic.getOutgoingConnectedTopic();
if(parentTopic!=null){var model=topic.getModel();
var mindmap=model.getMindmap();
result=mindmap.createNode();
var order=topic.getOrder()+1;
result.setOrder(order);
result.setPosition(10,10)
}return result
},showRelPivot:function(event){var nodes=this.getModel().filterSelectedTopics();
if(nodes.length<=0){$notify($msg("RELATIONSHIP_COULD_NOT_BE_CREATED"));
return
}var screen=this._workspace.getScreenManager();
var pos=screen.getWorkspaceMousePosition(event);
this._relPivot.start(nodes[0],pos)
},getMindmapProperties:function(){return{zoom:this.getModel().getZoom()}
},loadMap:function(mindmapModel){$assert(mindmapModel,"mindmapModel can not be null");
this._mindmap=mindmapModel;
var size={width:25,height:25};
var layoutManager=new mindplot.layout.LayoutManager(mindmapModel.getCentralTopic().getId(),size);
layoutManager.addEvent("change",function(event){var id=event.getId();
var topic=this.getModel().findTopicById(id);
topic.setPosition(event.getPosition());
topic.setOrder(event.getOrder())
}.bind(this));
this._eventBussDispatcher.setLayoutManager(layoutManager);
var branches=mindmapModel.getBranches();
for(var i=0;
i<branches.length;
i++){var nodeModel=branches[i];
var nodeGraph=this._nodeModelToNodeGraph(nodeModel);
nodeGraph.setBranchVisibility(true)
}var relationships=mindmapModel.getRelationships();
for(var j=0;
j<relationships.length;
j++){this._relationshipModelToRelationship(relationships[j])
}var centralTopic=this.getModel().getCentralTopic();
this.goToNode(centralTopic);
mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.DoLayout);
this.fireEvent("loadSuccess")
},getMindmap:function(){return this._mindmap
},undo:function(){this._actionDispatcher._actionRunner.undo()
},redo:function(){this._actionDispatcher._actionRunner.redo()
},isReadOnly:function(){return this._options.readOnly
},_nodeModelToNodeGraph:function(nodeModel){$assert(nodeModel,"Node model can not be null");
var children=nodeModel.getChildren().slice();
children=children.sort(function(a,b){return a.getOrder()-b.getOrder()
});
var nodeGraph=this._buildNodeGraph(nodeModel,this.isReadOnly());
nodeGraph.setVisibility(false);
this._workspace.appendChild(nodeGraph);
for(var i=0;
i<children.length;
i++){var child=children[i];
if($defined(child)){this._nodeModelToNodeGraph(child)
}}return nodeGraph
},_relationshipModelToRelationship:function(model){$assert(model,"Node model can not be null");
var result=this._buildRelationshipShape(model);
var sourceTopic=result.getSourceTopic();
sourceTopic.addRelationship(result);
var targetTopic=result.getTargetTopic();
targetTopic.addRelationship(result);
result.setVisibility(sourceTopic.isVisible()&&targetTopic.isVisible());
this._workspace.appendChild(result);
return result
},_addRelationship:function(model){var mindmap=this.getMindmap();
mindmap.addRelationship(model);
return this._relationshipModelToRelationship(model)
},_deleteRelationship:function(rel){var sourceTopic=rel.getSourceTopic();
sourceTopic.deleteRelationship(rel);
var targetTopic=rel.getTargetTopic();
targetTopic.deleteRelationship(rel);
this.getModel().removeRelationship(rel);
this._workspace.removeChild(rel);
var mindmap=this.getMindmap();
mindmap.deleteRelationship(rel.getModel())
},_buildRelationshipShape:function(model){var dmodel=this.getModel();
var sourceTopicId=model.getFromNode();
var sourceTopic=dmodel.findTopicById(sourceTopicId);
var targetTopicId=model.getToNode();
var targetTopic=dmodel.findTopicById(targetTopicId);
var result=new mindplot.Relationship(sourceTopic,targetTopic,model);
result.addEvent("ontblur",function(){var topics=this.getModel().filterSelectedTopics();
var rels=this.getModel().filterSelectedRelationships();
if(topics.length==0||rels.length==0){this.fireEvent("onblur")
}}.bind(this));
result.addEvent("ontfocus",function(){var topics=this.getModel().filterSelectedTopics();
var rels=this.getModel().filterSelectedRelationships();
if(topics.length==1||rels.length==1){this.fireEvent("onfocus")
}}.bind(this));
dmodel.addRelationship(result);
return result
},_removeTopic:function(node){if(!node.isCentralTopic()){var parent=node._parent;
node.disconnect(this._workspace);
while(node.getChildren().length>0){this._removeTopic(node.getChildren()[0])
}this._workspace.removeChild(node);
this.getModel().removeTopic(node);
var model=node.getModel();
model.deleteNode();
if($defined(parent)){this.goToNode(parent)
}}},deleteSelectedEntities:function(){var topics=this.getModel().filterSelectedTopics();
var relation=this.getModel().filterSelectedRelationships();
if(topics.length<=0&&relation.length<=0){$notify($msg("ENTITIES_COULD_NOT_BE_DELETED"));
return
}else{if(topics.length==1&&topics[0].isCentralTopic()){$notify($msg("CENTRAL_TOPIC_CAN_NOT_BE_DELETED"));
return
}}var topicIds=topics.filter(function(topic){return !topic.isCentralTopic()
}).map(function(topic){return topic.getId()
});
var relIds=relation.map(function(rel){return rel.getId()
});
if(topicIds.length>0||relIds.length>0){this._actionDispatcher.deleteEntities(topicIds,relIds)
}},changeFontFamily:function(font){var topicsIds=this.getModel().filterTopicsIds();
if(topicsIds.length>0){this._actionDispatcher.changeFontFamilyToTopic(topicsIds,font)
}},changeFontStyle:function(){var topicsIds=this.getModel().filterTopicsIds();
if(topicsIds.length>0){this._actionDispatcher.changeFontStyleToTopic(topicsIds)
}},changeFontColor:function(color){$assert(color,"color can not be null");
var topicsIds=this.getModel().filterTopicsIds();
if(topicsIds.length>0){this._actionDispatcher.changeFontColorToTopic(topicsIds,color)
}},changeBackgroundColor:function(color){var validateFunc=function(topic){return topic.getShapeType()!=mindplot.model.TopicShape.LINE
};
var validateError="Color can not be set to line topics.";
var topicsIds=this.getModel().filterTopicsIds(validateFunc,validateError);
if(topicsIds.length>0){this._actionDispatcher.changeBackgroundColorToTopic(topicsIds,color)
}},changeBorderColor:function(color){var validateFunc=function(topic){return topic.getShapeType()!=mindplot.model.TopicShape.LINE
};
var validateError="Color can not be set to line topics.";
var topicsIds=this.getModel().filterTopicsIds(validateFunc,validateError);
if(topicsIds.length>0){this._actionDispatcher.changeBorderColorToTopic(topicsIds,color)
}},changeFontSize:function(size){var topicsIds=this.getModel().filterTopicsIds();
if(topicsIds.length>0){this._actionDispatcher.changeFontSizeToTopic(topicsIds,size)
}},changeTopicShape:function(shape){var validateFunc=function(topic){return !(topic.getType()==mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE&&shape==mindplot.model.TopicShape.LINE)
};
var validateError="Central Topic shape can not be changed to line figure.";
var topicsIds=this.getModel().filterTopicsIds(validateFunc,validateError);
if(topicsIds.length>0){this._actionDispatcher.changeShapeTypeToTopic(topicsIds,shape)
}},changeFontWeight:function(){var topicsIds=this.getModel().filterTopicsIds();
if(topicsIds.length>0){this._actionDispatcher.changeFontWeightToTopic(topicsIds)
}},addIconType:function(iconType){var topicsIds=this.getModel().filterTopicsIds();
if(topicsIds.length>0){this._actionDispatcher.addFeatureToTopic(topicsIds[0],mindplot.TopicFeature.Icon.id,{id:iconType})
}},addLink:function(){var model=this.getModel();
var topic=model.selectedTopic();
if(topic){topic.showLinkEditor()
}},addNote:function(){var model=this.getModel();
var topic=model.selectedTopic();
if(topic){topic.showNoteEditor()
}},goToNode:function(node){node.setOnFocus(true);
this.onObjectFocusEvent(node)
},getWorkSpace:function(){return this._workspace
}});mindplot.ScreenManager=new Class({initialize:function(divElement){$assert(divElement,"can not be null");
this._divContainer=divElement;
this._padding={x:0,y:0};
this._clickEvents=[];
this._divContainer.addEvent("click",function(event){event.stopPropagation()
}.bind(this));
this._divContainer.addEvent("dblclick",function(event){event.stopPropagation();
event.preventDefault()
})
},setScale:function(scale){$assert(scale,"Screen scale can not be null");
this._scale=scale
},addEvent:function(event,listener){if(event=="click"){this._clickEvents.push(listener)
}else{this._divContainer.addEvent(event,listener)
}},removeEvent:function(event,listener){if(event=="click"){this._clickEvents.remove(listener)
}else{this._divContainer.removeEvent(event,listener)
}},fireEvent:function(type,event){if(type=="click"){this._clickEvents.each(function(listener){listener(type,event)
})
}else{this._divContainer.fireEvent(type,event)
}},_getElementPosition:function(elem){var elementPosition=elem.getPosition();
var x=elementPosition.x;
var y=elementPosition.y;
x=x-this._padding.x;
y=y-this._padding.y;
x=x/this._scale;
y=y/this._scale;
return{x:x,y:y}
},getWorkspaceIconPosition:function(e){var image=e.getImage();
var elementPosition=image.getPosition();
var imageSize=e.getSize();
var iconGroup=e.getGroup();
var group=iconGroup.getNativeElement();
var coordOrigin=group.getCoordOrigin();
var groupSize=group.getSize();
var coordSize=group.getCoordSize();
var scale={x:coordSize.width/parseInt(groupSize.width),y:coordSize.height/parseInt(groupSize.height)};
var x=(elementPosition.x-coordOrigin.x-(parseInt(imageSize.width)/2))/scale.x;
var y=(elementPosition.y-coordOrigin.y-(parseInt(imageSize.height)/2))/scale.y;
var groupPosition=iconGroup.getPosition();
x=x+groupPosition.x;
y=y+groupPosition.y;
var topic=iconGroup.getTopic();
var topicPosition=this._getElementPosition(topic);
topicPosition.x=topicPosition.x-(parseInt(topic.getSize().width)/2);
return{x:x+topicPosition.x,y:y+topicPosition.y}
},getWorkspaceMousePosition:function(event){var x=event.client.x;
var y=event.client.y;
var containerPosition=this.getContainer().getPosition();
x=x-containerPosition.x;
y=y-containerPosition.y;
x=x*this._scale;
y=y*this._scale;
x=x+this._padding.x;
y=y+this._padding.y;
return new core.Point(x,y)
},getContainer:function(){return this._divContainer
},setOffset:function(x,y){this._padding.x=x;
this._padding.y=y
}});mindplot.Workspace=new Class({initialize:function(screenManager,zoom){$assert(screenManager,"Div container can not be null");
$assert(zoom,"zoom container can not be null");
this._zoom=zoom;
this._screenManager=screenManager;
var divContainer=screenManager.getContainer();
this._screenWidth=parseInt(divContainer.getStyle("width"));
this._screenHeight=parseInt(divContainer.getStyle("height"));
var workspace=this._createWorkspace();
this._workspace=workspace;
workspace.addItAsChildTo(divContainer);
this.setZoom(zoom,true);
this._registerDragEvents();
this._eventsEnabled=true
},_createWorkspace:function(){var coordOriginX=-(this._screenWidth/2);
var coordOriginY=-(this._screenHeight/2);
var workspaceProfile={width:this._screenWidth+"px",height:this._screenHeight+"px",coordSizeWidth:this._screenWidth,coordSizeHeight:this._screenHeight,coordOriginX:coordOriginX,coordOriginY:coordOriginY,fillColor:"transparent",strokeWidth:0};
web2d.peer.Toolkit.init();
return new web2d.Workspace(workspaceProfile)
},appendChild:function(shape){if($defined(shape.addToWorkspace)){shape.addToWorkspace(this)
}else{this._workspace.appendChild(shape)
}},removeChild:function(shape){if($defined(shape.removeFromWorkspace)){shape.removeFromWorkspace(this)
}else{this._workspace.removeChild(shape)
}},addEvent:function(type,listener){this._workspace.addEvent(type,listener)
},removeEvent:function(type,listener){$assert(type,"type can not be null");
$assert(listener,"listener can not be null");
this._workspace.removeEvent(type,listener)
},getSize:function(){return this._workspace.getCoordSize()
},setZoom:function(zoom,center){this._zoom=zoom;
var workspace=this._workspace;
var coordWidth=zoom*this._screenWidth;
var coordHeight=zoom*this._screenHeight;
workspace.setCoordSize(coordWidth,coordHeight);
if(this._viewPort){this._viewPort.width=this._viewPort.width*zoom;
this._viewPort.height=this._viewPort.height*zoom
}var coordOriginX;
var coordOriginY;
if(center){if(this._viewPort){coordOriginX=-(this._viewPort.width/2);
coordOriginY=-(this._viewPort.height/2)
}else{coordOriginX=-(coordWidth/2);
coordOriginY=-(coordHeight/2)
}}else{var coordOrigin=workspace.getCoordOrigin();
coordOriginX=coordOrigin.x;
coordOriginY=coordOrigin.y
}workspace.setCoordOrigin(coordOriginX,coordOriginY);
this._screenManager.setOffset(coordOriginX,coordOriginY);
this._screenManager.setScale(zoom);
this._screenManager.fireEvent("update")
},getScreenManager:function(){return this._screenManager
},enableWorkspaceEvents:function(value){this._eventsEnabled=value
},isWorkspaceEventsEnabled:function(){return this._eventsEnabled
},dumpNativeChart:function(){return this._workspace.dumpNativeChart()
},_registerDragEvents:function(){var workspace=this._workspace;
var screenManager=this._screenManager;
var mWorkspace=this;
var mouseDownListener=function(event){if(!$defined(workspace._mouseMoveListener)){if(mWorkspace.isWorkspaceEventsEnabled()){mWorkspace.enableWorkspaceEvents(false);
var mouseDownPosition=screenManager.getWorkspaceMousePosition(event);
var originalCoordOrigin=workspace.getCoordOrigin();
var wasDragged=false;
workspace._mouseMoveListener=function(event){var currentMousePosition=screenManager.getWorkspaceMousePosition(event);
var offsetX=currentMousePosition.x-mouseDownPosition.x;
var coordOriginX=-offsetX+originalCoordOrigin.x;
var offsetY=currentMousePosition.y-mouseDownPosition.y;
var coordOriginY=-offsetY+originalCoordOrigin.y;
workspace.setCoordOrigin(coordOriginX,coordOriginY);
if(Browser.firefox){window.document.body.style.cursor="-moz-grabbing"
}else{window.document.body.style.cursor="move"
}event.preventDefault();
screenManager.fireEvent("update");
wasDragged=true
}.bind(this);
screenManager.addEvent("mousemove",workspace._mouseMoveListener);
workspace._mouseUpListener=function(event){screenManager.removeEvent("mousemove",workspace._mouseMoveListener);
screenManager.removeEvent("mouseup",workspace._mouseUpListener);
workspace._mouseUpListener=null;
workspace._mouseMoveListener=null;
window.document.body.style.cursor="default";
var coordOrigin=workspace.getCoordOrigin();
screenManager.setOffset(coordOrigin.x,coordOrigin.y);
mWorkspace.enableWorkspaceEvents(true);
if(!wasDragged){screenManager.fireEvent("click")
}};
screenManager.addEvent("mouseup",workspace._mouseUpListener)
}}else{workspace._mouseUpListener()
}};
screenManager.addEvent("mousedown",mouseDownListener)
},setViewPort:function(size){this._viewPort=size
}});mindplot.ShirinkConnector=new Class({initialize:function(topic){var ellipse=new web2d.Elipse(mindplot.Topic.prototype.INNER_RECT_ATTRIBUTES);
this._ellipse=ellipse;
ellipse.setFill("rgb(62,118,179)");
ellipse.setSize(mindplot.Topic.CONNECTOR_WIDTH,mindplot.Topic.CONNECTOR_WIDTH);
ellipse.addEvent("click",function(event){var model=topic.getModel();
var collapse=!model.areChildrenShrunken();
var topicId=topic.getId();
var actionDispatcher=mindplot.ActionDispatcher.getInstance();
actionDispatcher.shrinkBranch([topicId],collapse);
event.stopPropagation()
});
ellipse.addEvent("mousedown",function(event){event.stopPropagation()
});
ellipse.addEvent("dblclick",function(event){event.stopPropagation()
});
ellipse.addEvent("mouseover",function(event){ellipse.setFill("rgb(153, 0, 255)")
});
ellipse.addEvent("mouseout",function(event){var color=topic.getBackgroundColor();
this.setFill(color)
}.bind(this));
ellipse.setCursor("default");
this._fillColor="#f7f7f7";
var model=topic.getModel();
this.changeRender(model.areChildrenShrunken())
},changeRender:function(isShrink){var elipse=this._ellipse;
if(isShrink){elipse.setStroke("2","solid")
}else{elipse.setStroke("1","solid")
}},setVisibility:function(value){this._ellipse.setVisibility(value)
},setOpacity:function(opacity){this._ellipse.setOpacity(opacity)
},setFill:function(color){this._fillColor=color;
this._ellipse.setFill(color)
},setAttribute:function(name,value){this._ellipse.setAttribute(name,value)
},addToWorkspace:function(group){group.appendChild(this._ellipse)
},setPosition:function(x,y){this._ellipse.setPosition(x,y)
},moveToBack:function(){this._ellipse.moveToBack()
},moveToFront:function(){this._ellipse.moveToFront()
}});mindplot.DesignerKeyboard=new Class({Extends:Keyboard,Static:{register:function(designer){this._instance=new mindplot.DesignerKeyboard(designer);
this._instance.activate()
},getInstance:function(){return this._instance
}},initialize:function(designer){$assert(designer,"designer can not be null");
this.parent({defaultEventType:"keydown"});
this._registerEvents(designer)
},_registerEvents:function(designer){var model=designer.getModel();
var keyboardEvents={"backspace":function(event){event.preventDefault();
event.stopPropagation();
designer.deleteSelectedEntities()
}.bind(this),"space":function(){designer.shrinkSelectedBranch()
}.bind(this),"f2":function(){var node=model.selectedTopic();
if(node){node.showTextEditor()
}}.bind(this),"delete":function(event){designer.deleteSelectedEntities();
event.preventDefault();
event.stopPropagation()
}.bind(this),"enter":function(){designer.createSiblingForSelectedNode()
}.bind(this),"insert":function(event){designer.createChildForSelectedNode();
event.preventDefault();
event.stopPropagation()
}.bind(this),"tab":function(event){designer.createChildForSelectedNode();
event.preventDefault();
event.stopPropagation()
}.bind(this),"-":function(){designer.createChildForSelectedNode()
}.bind(this),"meta+enter":function(event){event.preventDefault();
event.stopPropagation();
designer.createChildForSelectedNode()
}.bind(this),"ctrl+z":function(event){event.preventDefault(event);
event.stopPropagation();
designer.undo()
}.bind(this),"meta+z":function(event){event.preventDefault();
event.stopPropagation();
designer.undo()
}.bind(this),"ctrl+c":function(event){event.preventDefault(event);
event.stopPropagation();
designer.copyToClipboard()
}.bind(this),"meta+c":function(event){event.preventDefault();
event.stopPropagation();
designer.copyToClipboard()
}.bind(this),"ctrl+v":function(event){event.preventDefault(event);
event.stopPropagation();
designer.pasteClipboard()
}.bind(this),"meta+v":function(event){event.preventDefault();
event.stopPropagation();
designer.pasteClipboard()
}.bind(this),"ctrl+z+shift":function(event){event.preventDefault();
event.stopPropagation();
designer.redo()
}.bind(this),"meta+z+shift":function(event){event.preventDefault();
event.stopPropagation();
designer.redo()
}.bind(this),"ctrl+y":function(event){event.preventDefault();
event.stopPropagation();
designer.redo()
}.bind(this),"meta+y":function(event){event.preventDefault();
event.stopPropagation();
designer.redo()
}.bind(this),"ctrl+a":function(event){event.preventDefault();
event.stopPropagation();
designer.selectAll()
},"ctrl+b":function(event){event.preventDefault();
event.stopPropagation();
designer.changeFontWeight()
},"meta+b":function(event){event.preventDefault();
event.stopPropagation();
designer.changeFontWeight()
},"ctrl+s":function(event){event.preventDefault();
event.stopPropagation();
$("save").fireEvent("click")
},"meta+s":function(event){event.preventDefault();
event.stopPropagation();
$("save").fireEvent("click")
},"ctrl+i":function(event){event.preventDefault();
event.stopPropagation();
designer.changeFontStyle()
},"meta+i":function(event){event.preventDefault();
event.stopPropagation();
designer.changeFontStyle()
},"meta+shift+a":function(event){event.preventDefault();
event.stopPropagation();
designer.deselectAll()
},"ctrl+shift+a":function(event){event.preventDefault();
event.stopPropagation();
designer.deselectAll()
},"meta+a":function(event){event.preventDefault();
event.stopPropagation();
designer.selectAll()
},"right":function(event){var node=model.selectedTopic();
if(node){if(node.isCentralTopic()){this._goToSideChild(designer,node,"RIGHT")
}else{if(node.getPosition().x<0){this._goToParent(designer,node)
}else{if(!node.areChildrenShrunken()){this._goToChild(designer,node)
}}}}else{var centralTopic=model.getCentralTopic();
this._goToNode(designer,centralTopic)
}event.preventDefault();
event.stopPropagation()
}.bind(this),"left":function(event){var node=model.selectedTopic();
if(node){if(node.isCentralTopic()){this._goToSideChild(designer,node,"LEFT")
}else{if(node.getPosition().x>0){this._goToParent(designer,node)
}else{if(!node.areChildrenShrunken()){this._goToChild(designer,node)
}}}}else{var centralTopic=model.getCentralTopic();
this._goToNode(designer,centralTopic)
}event.preventDefault();
event.stopPropagation()
}.bind(this),"up":function(event){var node=model.selectedTopic();
if(node){if(!node.isCentralTopic()){this._goToBrother(designer,node,"UP")
}}else{var centralTopic=model.getCentralTopic();
this._goToNode(designer,centralTopic)
}event.preventDefault();
event.stopPropagation()
}.bind(this),"down":function(event){var node=model.selectedTopic();
if(node){if(!node.isCentralTopic()){this._goToBrother(designer,node,"DOWN")
}}else{var centralTopic=model.getCentralTopic();
this._goToNode(designer,centralTopic)
}event.preventDefault();
event.stopPropagation()
}.bind(this)};
this.addEvents(keyboardEvents);
var regex=/^(?:shift|control|ctrl|alt|meta)$/;
var modifiers=["shift","control","alt","meta"];
var excludes=["esc","capslock","tab","f1","f3","f4","f5","f6","f7","f8","f9","f10","f11","f12","backspace","down","up","left","right","control"];
if(!Browser.Platform.mac){excludes.push("alt")
}$(document).addEvent("keydown",function(event){var keys=[];
modifiers.each(function(mod){if(event[mod]){keys.push(mod)
}});
if(!regex.test(event.key)){keys.push(event.key)
}var key=keys.join("+");
var isRegistered=false;
for(var eKey in keyboardEvents){if(eKey==key){isRegistered=true;
break
}}if(!isRegistered&&!excludes.contains(key)&&!excludes.contains(event.key)&&!event.meta&&!event.control){var nodes=designer.getModel().filterSelectedTopics();
if(nodes.length>0){var pressKey=event.key;
if(modifiers.contains(event.key)){pressKey=""
}nodes[0].showTextEditor(pressKey);
event.stopPropagation()
}}})
},_goToBrother:function(designer,node,direction){var parent=node.getParent();
if(parent){var brothers=parent.getChildren();
var target=node;
var y=node.getPosition().y;
var x=node.getPosition().x;
var dist=null;
for(var i=0;
i<brothers.length;
i++){var sameSide=(x*brothers[i].getPosition().x)>=0;
if(brothers[i]!=node&&sameSide){var brother=brothers[i];
var brotherY=brother.getPosition().y;
if(direction=="DOWN"&&brotherY>y){var distancia=y-brotherY;
if(distancia<0){distancia=distancia*(-1)
}if(dist==null||dist>distancia){dist=distancia;
target=brothers[i]
}}else{if(direction=="UP"&&brotherY<y){var distance=y-brotherY;
if(distance<0){distance=distance*(-1)
}if(dist==null||dist>distance){dist=distance;
target=brothers[i]
}}}}}this._goToNode(designer,target)
}},_goToSideChild:function(designer,node,side){var children=node.getChildren();
if(children.length>0){var target=children[0];
var top=null;
for(var i=0;
i<children.length;
i++){var child=children[i];
var childY=child.getPosition().y;
if(side=="LEFT"&&child.getPosition().x<0){if(top==null||childY<top){target=child;
top=childY
}}if(side=="RIGHT"&&child.getPosition().x>0){if(top==null||childY<top){target=child;
top=childY
}}}this._goToNode(designer,target)
}},_goToParent:function(designer,node){var parent=node.getParent();
if(parent){this._goToNode(designer,parent)
}},_goToChild:function(designer,node){var children=node.getChildren();
if(children.length>0){var target=children[0];
var top=target.getPosition().y;
for(var i=0;
i<children.length;
i++){var child=children[i];
if(child.getPosition().y<top){top=child.getPosition().y;
target=child
}}this._goToNode(designer,target)
}},_goToNode:function(designer,node){designer.deselectAll();
node.setOnFocus(true)
}});mindplot.TopicStyle=new Class({Static:{_getStyles:function(topic){$assert(topic,"topic can not be null");
var result;
if(topic.isCentralTopic()){result=mindplot.TopicStyle.STYLES.CENTRAL_TOPIC
}else{var targetTopic=topic.getOutgoingConnectedTopic();
if($defined(targetTopic)){if(targetTopic.isCentralTopic()){result=mindplot.TopicStyle.STYLES.MAIN_TOPIC
}else{result=mindplot.TopicStyle.STYLES.SUB_TOPIC
}}else{result=mindplot.TopicStyle.STYLES.ISOLATED_TOPIC
}}return result
},defaultText:function(topic){var msgKey=this._getStyles(topic).msgKey;
return $msg(msgKey)
},defaultFontStyle:function(topic){return this._getStyles(topic).fontStyle
},defaultBackgroundColor:function(topic){return this._getStyles(topic).backgroundColor
},defaultBorderColor:function(topic){return this._getStyles(topic).borderColor
},getInnerPadding:function(topic){return this._getStyles(topic).innerPadding
},defaultShapeType:function(topic){return this._getStyles(topic).shapeType
}}});
mindplot.TopicStyle.STYLES={CENTRAL_TOPIC:{borderColor:"rgb(57,113,177)",backgroundColor:"rgb(80,157,192)",fontStyle:{font:"Verdana",size:10,style:"normal",weight:"bold",color:"#ffffff"},msgKey:"CENTRAL_TOPIC",innerPadding:11,shapeType:mindplot.model.TopicShape.ROUNDED_RECT},MAIN_TOPIC:{borderColor:"rgb(2,59,185)",backgroundColor:"rgb(224,229,239)",fontStyle:{font:"Arial",size:8,style:"normal",weight:"normal",color:"rgb(82,92,97)"},msgKey:"MAIN_TOPIC",innerPadding:3,shapeType:mindplot.model.TopicShape.LINE},SUB_TOPIC:{borderColor:"rgb(2,59,185)",backgroundColor:"rgb(224,229,239)",fontStyle:{font:"Arial",size:6,style:"normal",weight:"normal",color:"rgb(82,92,97)"},msgKey:"SUB_TOPIC",innerPadding:3,shapeType:mindplot.model.TopicShape.LINE},ISOLATED_TOPIC:{borderColor:"rgb(2,59,185)",backgroundColor:"rgb(224,229,239)",fontStyle:{font:"Verdana",size:8,style:"normal",weight:"normal",color:"rgb(82,92,97)"},msgKey:"ISOLATED_TOPIC",innerPadding:4,shapeType:mindplot.model.TopicShape.LINE}};mindplot.NodeGraph=new Class({initialize:function(nodeModel,options){$assert(nodeModel,"model can not be null");
this._options=options;
this._mouseEvents=true;
this.setModel(nodeModel);
this._onFocus=false;
this._event=new Events();
this._size={width:50,height:20}
},isReadOnly:function(){return this._options.readOnly
},getType:function(){var model=this.getModel();
return model.getType()
},setId:function(id){$assert(typeof topic.getId()=="number","id is not a number:"+id);
this.getModel().setId(id)
},_set2DElement:function(elem2d){this._elem2d=elem2d
},get2DElement:function(){$assert(this._elem2d,"NodeGraph has not been initialized properly");
return this._elem2d
},setPosition:function(point,fireEvent){throw"Unsupported operation"
},addEvent:function(type,listener){var elem=this.get2DElement();
elem.addEvent(type,listener)
},removeEvent:function(type,listener){var elem=this.get2DElement();
elem.removeEvent(type,listener)
},fireEvent:function(type,event){var elem=this.get2DElement();
elem.fireEvent(type,event)
},setMouseEventsEnabled:function(isEnabled){this._mouseEvents=isEnabled
},isMouseEventsEnabled:function(){return this._mouseEvents
},getSize:function(){return this._size
},setSize:function(size){this._size.width=parseInt(size.width);
this._size.height=parseInt(size.height)
},getModel:function(){$assert(this._model,"Model has not been initialized yet");
return this._model
},setModel:function(model){$assert(model,"Model can not be null");
this._model=model
},getId:function(){return this._model.getId()
},setOnFocus:function(focus){if(this._onFocus!=focus){this._onFocus=focus;
var outerShape=this.getOuterShape();
if(focus){outerShape.setFill(mindplot.Topic.OUTER_SHAPE_ATTRIBUTES_FOCUS.fillColor);
outerShape.setOpacity(1)
}else{outerShape.setFill(mindplot.Topic.OUTER_SHAPE_ATTRIBUTES.fillColor);
outerShape.setOpacity(0)
}this.setCursor("move");
this.closeEditors();
this.fireEvent(focus?"ontfocus":"ontblur",this)
}},isOnFocus:function(){return this._onFocus
},dispose:function(workspace){this.setOnFocus(false);
workspace.removeChild(this)
},createDragNode:function(layoutManager){var dragShape=this._buildDragShape();
return new mindplot.DragTopic(dragShape,this,layoutManager)
},_buildDragShape:function(){$assert(false,"_buildDragShape must be implemented by all nodes.")
},getPosition:function(){var model=this.getModel();
return model.getPosition()
}});
mindplot.NodeGraph.create=function(nodeModel,options){$assert(nodeModel,"Model can not be null");
var type=nodeModel.getType();
$assert(type,"Node model type can not be null");
var result;
if(type==mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE){result=new mindplot.CentralTopic(nodeModel,options)
}else{if(type==mindplot.model.INodeModel.MAIN_TOPIC_TYPE){result=new mindplot.MainTopic(nodeModel,options)
}else{$assert(false,"unsupported node type:"+type)
}}return result
};mindplot.Topic=new Class({Extends:mindplot.NodeGraph,initialize:function(model,options){this.parent(model,options);
this._children=[];
this._parent=null;
this._relationships=[];
this._isInWorkspace=false;
this._buildTopicShape();
var pos=model.getPosition();
if(pos!=null&&this.isCentralTopic()){this.setPosition(pos)
}if(!this.isReadOnly()){this._registerEvents()
}},_registerEvents:function(){this.setMouseEventsEnabled(true);
this.addEvent("click",function(event){event.stopPropagation()
});
this.addEvent("dblclick",function(event){this._getTopicEventDispatcher().show(this);
event.stopPropagation()
}.bind(this))
},setShapeType:function(type){this._setShapeType(type,true)
},getParent:function(){return this._parent
},_setShapeType:function(type,updateModel){var model=this.getModel();
if($defined(updateModel)&&updateModel){model.setShapeType(type)
}var oldInnerShape=this.getInnerShape();
if(oldInnerShape!=null){this._removeInnerShape();
var innerShape=this.getInnerShape();
var size=this.getSize();
this.setSize(size,true);
var group=this.get2DElement();
group.appendChild(innerShape);
var text=this.getTextShape();
text.moveToFront();
var iconGroup=this.getIconGroup();
if($defined(iconGroup)){iconGroup.moveToFront()
}var connector=this.getShrinkConnector();
if($defined(connector)){connector.moveToFront()
}}},getShapeType:function(){var model=this.getModel();
var result=model.getShapeType();
if(!$defined(result)){result=mindplot.TopicStyle.defaultShapeType(this)
}return result
},_removeInnerShape:function(){var group=this.get2DElement();
var innerShape=this.getInnerShape();
group.removeChild(innerShape);
this._innerShape=null;
return innerShape
},getInnerShape:function(){if(!$defined(this._innerShape)){this._innerShape=this._buildShape(mindplot.Topic.INNER_RECT_ATTRIBUTES,this.getShapeType());
var bgColor=this.getBackgroundColor();
this._setBackgroundColor(bgColor,false);
var brColor=this.getBorderColor();
this._setBorderColor(brColor,false);
if(!this.isCentralTopic()&&!this.isReadOnly()){this._innerShape.setCursor("move")
}else{this._innerShape.setCursor("default")
}}return this._innerShape
},_buildShape:function(attributes,shapeType){$assert(attributes,"attributes can not be null");
$assert(shapeType,"shapeType can not be null");
var result;
if(shapeType==mindplot.model.TopicShape.RECTANGLE){result=new web2d.Rect(0,attributes)
}else{if(shapeType==mindplot.model.TopicShape.IMAGE){var model=this.getModel();
var url=model.getImageUrl();
var size=model.getImageSize();
result=new web2d.Image();
result.setHref(url);
result.setSize(size.width,size.height);
result.getSize=function(){return model.getImageSize()
};
result.setPosition=function(){}
}else{if(shapeType==mindplot.model.TopicShape.ELLIPSE){result=new web2d.Rect(0.9,attributes)
}else{if(shapeType==mindplot.model.TopicShape.ROUNDED_RECT){result=new web2d.Rect(0.3,attributes)
}else{if(shapeType==mindplot.model.TopicShape.LINE){result=new web2d.Line({strokeColor:"#495879",strokeWidth:1});
result.setSize=function(width,height){this.size={width:width,height:height};
result.setFrom(0,height);
result.setTo(width,height);
var stokeColor=mindplot.ConnectionLine.getStrokeColor();
result.setStroke(1,"solid",stokeColor)
};
result.getSize=function(){return this.size
};
result.setPosition=function(){};
result.setFill=function(){};
result.setStroke=function(){}
}else{$assert(false,"Unsupported figure shapeType:"+shapeType)
}}}}}result.setPosition(0,0);
return result
},setCursor:function(type){var innerShape=this.getInnerShape();
innerShape.setCursor(type);
var outerShape=this.getOuterShape();
outerShape.setCursor(type);
var textShape=this.getTextShape();
textShape.setCursor(type)
},getOuterShape:function(){if(!$defined(this._outerShape)){var rect=this._buildShape(mindplot.Topic.OUTER_SHAPE_ATTRIBUTES,mindplot.model.TopicShape.ROUNDED_RECT);
rect.setPosition(-2,-3);
rect.setOpacity(0);
this._outerShape=rect
}return this._outerShape
},getTextShape:function(){if(!$defined(this._text)){this._text=this._buildTextShape(false);
var text=this.getText();
this._setText(text,false)
}return this._text
},getOrBuildIconGroup:function(){if(!$defined(this._iconsGroup)){this._iconsGroup=this._buildIconGroup();
var group=this.get2DElement();
group.appendChild(this._iconsGroup.getNativeElement());
this._iconsGroup.moveToFront()
}return this._iconsGroup
},getIconGroup:function(){return this._iconsGroup
},_buildIconGroup:function(){var textHeight=this.getTextShape().getFontHeight();
var result=new mindplot.IconGroup(this.getId(),textHeight);
var padding=mindplot.TopicStyle.getInnerPadding(this);
result.setPosition(padding,padding);
var model=this.getModel();
var featuresModel=model.getFeatures();
for(var i=0;
i<featuresModel.length;
i++){var featureModel=featuresModel[i];
var icon=mindplot.TopicFeature.createIcon(this,featureModel,this.isReadOnly());
result.addIcon(icon,featureModel.getType()==mindplot.TopicFeature.Icon.id&&!this.isReadOnly())
}return result
},addFeature:function(featureModel){var iconGroup=this.getOrBuildIconGroup();
this.closeEditors();
var model=this.getModel();
model.addFeature(featureModel);
var result=mindplot.TopicFeature.createIcon(this,featureModel,this.isReadOnly());
iconGroup.addIcon(result,featureModel.getType()==mindplot.TopicFeature.Icon.id&&!this.isReadOnly());
this._adjustShapes();
return result
},findFeatureById:function(id){var model=this.getModel();
return model.findFeatureById(id)
},removeFeature:function(featureModel){$assert(featureModel,"featureModel could not be null");
var model=this.getModel();
model.removeFeature(featureModel);
var iconGroup=this.getIconGroup();
if($defined(iconGroup)){iconGroup.removeIconByModel(featureModel)
}this._adjustShapes()
},addRelationship:function(relationship){this._relationships.push(relationship)
},deleteRelationship:function(relationship){this._relationships.erase(relationship)
},getRelationships:function(){return this._relationships
},_buildTextShape:function(readOnly){var result=new web2d.Text();
var family=this.getFontFamily();
var size=this.getFontSize();
var weight=this.getFontWeight();
var style=this.getFontStyle();
result.setFont(family,size,style,weight);
var color=this.getFontColor();
result.setColor(color);
if(!readOnly){if(!this.isCentralTopic()){result.setCursor("move")
}else{result.setCursor("default")
}}return result
},setFontFamily:function(value,updateModel){var textShape=this.getTextShape();
textShape.setFontFamily(value);
if($defined(updateModel)&&updateModel){var model=this.getModel();
model.setFontFamily(value)
}this._adjustShapes(updateModel)
},setFontSize:function(value,updateModel){var textShape=this.getTextShape();
textShape.setSize(value);
if($defined(updateModel)&&updateModel){var model=this.getModel();
model.setFontSize(value)
}this._adjustShapes(updateModel)
},setFontStyle:function(value,updateModel){var textShape=this.getTextShape();
textShape.setStyle(value);
if($defined(updateModel)&&updateModel){var model=this.getModel();
model.setFontStyle(value)
}this._adjustShapes(updateModel)
},setFontWeight:function(value,updateModel){var textShape=this.getTextShape();
textShape.setWeight(value);
if($defined(updateModel)&&updateModel){var model=this.getModel();
model.setFontWeight(value)
}this._adjustShapes()
},getFontWeight:function(){var model=this.getModel();
var result=model.getFontWeight();
if(!$defined(result)){var font=mindplot.TopicStyle.defaultFontStyle(this);
result=font.weight
}return result
},getFontFamily:function(){var model=this.getModel();
var result=model.getFontFamily();
if(!$defined(result)){var font=mindplot.TopicStyle.defaultFontStyle(this);
result=font.font
}return result
},getFontColor:function(){var model=this.getModel();
var result=model.getFontColor();
if(!$defined(result)){var font=mindplot.TopicStyle.defaultFontStyle(this);
result=font.color
}return result
},getFontStyle:function(){var model=this.getModel();
var result=model.getFontStyle();
if(!$defined(result)){var font=mindplot.TopicStyle.defaultFontStyle(this);
result=font.style
}return result
},getFontSize:function(){var model=this.getModel();
var result=model.getFontSize();
if(!$defined(result)){var font=mindplot.TopicStyle.defaultFontStyle(this);
result=font.size
}return result
},setFontColor:function(value,updateModel){var textShape=this.getTextShape();
textShape.setColor(value);
if($defined(updateModel)&&updateModel){var model=this.getModel();
model.setFontColor(value)
}},_setText:function(text,updateModel){var textShape=this.getTextShape();
textShape.setText(text==null?mindplot.TopicStyle.defaultText(this):text);
if($defined(updateModel)&&updateModel){var model=this.getModel();
model.setText(text)
}},setText:function(text){if(!text||text.trim().length==0){text=null
}this._setText(text,true);
this._adjustShapes()
},getText:function(){var model=this.getModel();
var result=model.getText();
if(!$defined(result)){result=mindplot.TopicStyle.defaultText(this)
}return result
},setBackgroundColor:function(color){this._setBackgroundColor(color,true)
},_setBackgroundColor:function(color,updateModel){var innerShape=this.getInnerShape();
innerShape.setFill(color);
var connector=this.getShrinkConnector();
if(connector){connector.setFill(color)
}if($defined(updateModel)&&updateModel){var model=this.getModel();
model.setBackgroundColor(color)
}},getBackgroundColor:function(){var model=this.getModel();
var result=model.getBackgroundColor();
if(!$defined(result)){result=mindplot.TopicStyle.defaultBackgroundColor(this)
}return result
},setBorderColor:function(color){this._setBorderColor(color,true)
},_setBorderColor:function(color,updateModel){var innerShape=this.getInnerShape();
innerShape.setAttribute("strokeColor",color);
var connector=this.getShrinkConnector();
if(connector){connector.setAttribute("strokeColor",color)
}if($defined(updateModel)&&updateModel){var model=this.getModel();
model.setBorderColor(color)
}},getBorderColor:function(){var model=this.getModel();
var result=model.getBorderColor();
if(!$defined(result)){result=mindplot.TopicStyle.defaultBorderColor(this)
}return result
},_buildTopicShape:function(){var groupAttributes={width:100,height:100,coordSizeWidth:100,coordSizeHeight:100};
var group=new web2d.Group(groupAttributes);
this._set2DElement(group);
var outerShape=this.getOuterShape();
var innerShape=this.getInnerShape();
var textShape=this.getTextShape();
group.appendChild(outerShape);
group.appendChild(innerShape);
group.appendChild(textShape);
var model=this.getModel();
if(model.getFeatures().length!=0){this.getOrBuildIconGroup()
}var shrinkConnector=this.getShrinkConnector();
if($defined(shrinkConnector)){shrinkConnector.addToWorkspace(group)
}this._registerDefaultListenersToElement(group,this)
},_registerDefaultListenersToElement:function(elem,topic){var mouseOver=function(event){if(topic.isMouseEventsEnabled()){topic.handleMouseOver(event)
}};
elem.addEvent("mouseover",mouseOver);
var outout=function(event){if(topic.isMouseEventsEnabled()){topic.handleMouseOut(event)
}};
elem.addEvent("mouseout",outout);
elem.addEvent("mousedown",function(event){if(!this.isReadOnly()){var value=true;
if((event.meta&&Browser.Platform.mac)||(event.control&&!Browser.Platform.mac)){value=!this.isOnFocus();
event.stopPropagation();
event.preventDefault()
}topic.setOnFocus(value)
}var eventDispatcher=this._getTopicEventDispatcher();
eventDispatcher.process(mindplot.TopicEvent.CLICK,this);
event.stopPropagation()
}.bind(this))
},areChildrenShrunken:function(){var model=this.getModel();
return model.areChildrenShrunken()
},isCollapsed:function(){var result=false;
var current=this.getParent();
while(current&&!result){result=current.areChildrenShrunken();
current=current.getParent()
}return result
},setChildrenShrunken:function(value){var model=this.getModel();
model.setChildrenShrunken(value);
var shrinkConnector=this.getShrinkConnector();
if($defined(shrinkConnector)){shrinkConnector.changeRender(value)
}var elements=this._flatten2DElements(this);
var fade=new mindplot.util.FadeEffect(elements,!value);
fade.addEvent("complete",function(){});
fade.start();
mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.NodeShrinkEvent,model)
},getShrinkConnector:function(){var result=this._connector;
if(this._connector==null){this._connector=new mindplot.ShirinkConnector(this);
this._connector.setVisibility(false);
result=this._connector
}return result
},handleMouseOver:function(){var outerShape=this.getOuterShape();
outerShape.setOpacity(1)
},handleMouseOut:function(){var outerShape=this.getOuterShape();
if(!this.isOnFocus()){outerShape.setOpacity(0)
}},showTextEditor:function(text){this._getTopicEventDispatcher().show(this,{text:text})
},showNoteEditor:function(){var topicId=this.getId();
var model=this.getModel();
var editorModel={getValue:function(){var notes=model.findFeatureByType(mindplot.TopicFeature.Note.id);
var result;
if(notes.length>0){result=notes[0].getText()
}return result
},setValue:function(value){var dispatcher=mindplot.ActionDispatcher.getInstance();
var notes=model.findFeatureByType(mindplot.TopicFeature.Note.id);
if(!$defined(value)){var featureId=notes[0].getId();
dispatcher.removeFeatureFromTopic(topicId,featureId)
}else{if(notes.length>0){dispatcher.changeFeatureToTopic(topicId,notes[0].getId(),{text:value})
}else{dispatcher.addFeatureToTopic(topicId,mindplot.TopicFeature.Note.id,{text:value})
}}}};
var editor=new mindplot.widget.NoteEditor(editorModel);
this.closeEditors();
editor.show()
},showLinkEditor:function(){var topicId=this.getId();
var model=this.getModel();
var editorModel={getValue:function(){var links=model.findFeatureByType(mindplot.TopicFeature.Link.id);
var result;
if(links.length>0){result=links[0].getUrl()
}return result
},setValue:function(value){var dispatcher=mindplot.ActionDispatcher.getInstance();
var links=model.findFeatureByType(mindplot.TopicFeature.Link.id);
if(!$defined(value)){var featureId=links[0].getId();
dispatcher.removeFeatureFromTopic(topicId,featureId)
}else{if(links.length>0){dispatcher.changeFeatureToTopic(topicId,links[0].getId(),{url:value})
}else{dispatcher.addFeatureToTopic(topicId,mindplot.TopicFeature.Link.id,{url:value})
}}}};
this.closeEditors();
var editor=new mindplot.widget.LinkEditor(editorModel);
editor.show()
},closeEditors:function(){this._getTopicEventDispatcher().close(true)
},_getTopicEventDispatcher:function(){return mindplot.TopicEventDispatcher.getInstance()
},setPosition:function(point){$assert(point,"position can not be null");
point.x=Math.ceil(point.x);
point.y=Math.ceil(point.y);
var model=this.getModel();
model.setPosition(point.x,point.y);
var size=this.getSize();
var cx=point.x-(size.width/2);
var cy=point.y-(size.height/2);
this._elem2d.setPosition(cx,cy);
this._updateConnectionLines();
this.invariant()
},getOutgoingLine:function(){return this._outgoingLine
},getIncomingLines:function(){var result=[];
var children=this.getChildren();
for(var i=0;
i<children.length;
i++){var node=children[i];
var line=node.getOutgoingLine();
if($defined(line)){result.push(line)
}}return result
},getOutgoingConnectedTopic:function(){var result=null;
var line=this.getOutgoingLine();
if($defined(line)){result=line.getTargetTopic()
}return result
},_updateConnectionLines:function(){var outgoingLine=this.getOutgoingLine();
if($defined(outgoingLine)){outgoingLine.redraw()
}var incomingLines=this.getIncomingLines();
for(var i=0;
i<incomingLines.length;
i++){incomingLines[i].redraw()
}for(var j=0;
j<this._relationships.length;
j++){this._relationships[j].redraw()
}},setBranchVisibility:function(value){var current=this;
var parent=this;
while(parent!=null&&!parent.isCentralTopic()){current=parent;
parent=current.getParent()
}current.setVisibility(value)
},setVisibility:function(value){this._setTopicVisibility(value);
this._setChildrenVisibility(value);
this._setRelationshipLinesVisibility(value);
var outgoingLine=this.getOutgoingLine();
if(outgoingLine){outgoingLine.setVisibility(value)
}},moveToBack:function(){for(var j=0;
j<this._relationships.length;
j++){this._relationships[j].moveToBack()
}var connector=this.getShrinkConnector();
if($defined(connector)){connector.moveToBack()
}this.get2DElement().moveToBack()
},moveToFront:function(){this.get2DElement().moveToFront();
var connector=this.getShrinkConnector();
if($defined(connector)){connector.moveToFront()
}for(var j=0;
j<this._relationships.length;
j++){this._relationships[j].moveToFront()
}},isVisible:function(){var elem=this.get2DElement();
return elem.isVisible()
},_setRelationshipLinesVisibility:function(value){this._relationships.each(function(relationship){relationship.setVisibility(value)
})
},_setTopicVisibility:function(value){var elem=this.get2DElement();
elem.setVisibility(value);
if(this.getIncomingLines().length>0){var connector=this.getShrinkConnector();
if($defined(connector)){connector.setVisibility(value)
}}var textShape=this.getTextShape();
textShape.setVisibility(this.getShapeType()!=mindplot.model.TopicShape.IMAGE?value:false)
},setOpacity:function(opacity){var elem=this.get2DElement();
elem.setOpacity(opacity);
var connector=this.getShrinkConnector();
if($defined(connector)){connector.setOpacity(opacity)
}var textShape=this.getTextShape();
textShape.setOpacity(opacity)
},_setChildrenVisibility:function(isVisible){var children=this.getChildren();
var model=this.getModel();
isVisible=isVisible?!model.areChildrenShrunken():isVisible;
for(var i=0;
i<children.length;
i++){var child=children[i];
child.setVisibility(isVisible);
var outgoingLine=child.getOutgoingLine();
outgoingLine.setVisibility(isVisible)
}},invariant:function(){var line=this._outgoingLine;
var model=this.getModel();
var isConnected=model.isConnected();
if((isConnected&&!line)||(!isConnected&&line)){}},setSize:function(size,force){$assert(size,"size can not be null");
$assert($defined(size.width),"size seem not to be a valid element");
size={width:Math.ceil(size.width),height:Math.ceil(size.height)};
var oldSize=this.getSize();
var hasSizeChanged=oldSize.width!=size.width||oldSize.height!=size.height;
if(hasSizeChanged||force){mindplot.NodeGraph.prototype.setSize.call(this,size);
var outerShape=this.getOuterShape();
var innerShape=this.getInnerShape();
outerShape.setSize(size.width+4,size.height+6);
innerShape.setSize(size.width,size.height);
this._updatePositionOnChangeSize(oldSize,size);
if(hasSizeChanged){mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.NodeResizeEvent,{node:this.getModel(),size:size})
}}},_updatePositionOnChangeSize:function(){$assert(false,"this method must be overwrited.")
},disconnect:function(workspace){var outgoingLine=this.getOutgoingLine();
if($defined(outgoingLine)){$assert(workspace,"workspace can not be null");
this._outgoingLine=null;
var targetTopic=outgoingLine.getTargetTopic();
targetTopic.removeChild(this);
var childModel=this.getModel();
childModel.disconnect();
this._parent=null;
outgoingLine.removeFromWorkspace(workspace);
mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.NodeDisconnectEvent,this.getModel());
var model=this.getModel();
if(!model.getText()){var text=this.getText();
this._setText(text,false)
}if(!model.getFontSize()){var size=this.getFontSize();
this.setFontSize(size,false)
}if(targetTopic.getChildren().length==0){var connector=targetTopic.getShrinkConnector();
if($defined(connector)){connector.setVisibility(false)
}}}},getOrder:function(){var model=this.getModel();
return model.getOrder()
},setOrder:function(value){var model=this.getModel();
model.setOrder(value)
},connectTo:function(targetTopic,workspace){$assert(!this._outgoingLine,"Could not connect an already connected node");
$assert(targetTopic!=this,"Circular connection are not allowed");
$assert(targetTopic,"Parent Graph can not be null");
$assert(workspace,"Workspace can not be null");
targetTopic.appendChild(this);
this._parent=targetTopic;
var targetModel=targetTopic.getModel();
var childModel=this.getModel();
childModel.connectTo(targetModel);
var outgoingLine=new mindplot.ConnectionLine(this,targetTopic);
outgoingLine.setVisibility(false);
this._outgoingLine=outgoingLine;
workspace.appendChild(outgoingLine);
this.updateTopicShape(targetTopic);
var model=this.getModel();
if(!model.getText()){var text=this.getText();
this._setText(text,false)
}if(!model.getFontSize()){var size=this.getFontSize();
this.setFontSize(size,false)
}this.getTextShape();
var connector=targetTopic.getShrinkConnector();
if($defined(connector)){connector.setVisibility(true)
}outgoingLine.redraw();
if(this.isInWorkspace()){mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.NodeConnectEvent,{parentNode:targetTopic.getModel(),childNode:this.getModel()})
}},appendChild:function(child){var children=this.getChildren();
children.push(child)
},removeChild:function(child){var children=this.getChildren();
children.erase(child)
},getChildren:function(){var result=this._children;
if(!$defined(result)){this._children=[];
result=this._children
}return result
},removeFromWorkspace:function(workspace){var elem2d=this.get2DElement();
workspace.removeChild(elem2d);
var line=this.getOutgoingLine();
if($defined(line)){workspace.removeChild(line)
}this._isInWorkspace=false;
mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.NodeRemoved,this.getModel())
},addToWorkspace:function(workspace){var elem=this.get2DElement();
workspace.appendChild(elem);
if(!this.isInWorkspace()){if(!this.isCentralTopic()){mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.NodeAdded,this.getModel())
}if(this.getModel().isConnected()){mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.NodeConnectEvent,{parentNode:this.getOutgoingConnectedTopic().getModel(),childNode:this.getModel()})
}}this._isInWorkspace=true;
this._adjustShapes()
},isInWorkspace:function(){return this._isInWorkspace
},createDragNode:function(layoutManager){var result=this.parent(layoutManager);
var targetTopic=this.getOutgoingConnectedTopic();
if($defined(targetTopic)){result.connectTo(targetTopic);
result.setVisibility(false)
}this._getTopicEventDispatcher().close();
return result
},_adjustShapes:function(){if(this._isInWorkspace){var textShape=this.getTextShape();
if(this.getShapeType()!=mindplot.model.TopicShape.IMAGE){var textWidth=textShape.getWidth();
var textHeight=textShape.getHeight();
textHeight=textHeight!=0?textHeight:20;
var topicPadding=mindplot.TopicStyle.getInnerPadding(this);
var iconGroup=this.getOrBuildIconGroup();
var fontHeight=this.getTextShape().getFontHeight();
iconGroup.setPosition(topicPadding,topicPadding);
iconGroup.seIconSize(fontHeight,fontHeight);
var iconsWidth=iconGroup.getSize().width;
if(iconsWidth!=0){iconsWidth=iconsWidth+(textHeight/4)
}var height=textHeight+(topicPadding*2);
var width=textWidth+iconsWidth+(topicPadding*2);
this.setSize({width:width,height:height});
textShape.setPosition(topicPadding+iconsWidth,topicPadding)
}else{var size=this.getModel().getImageSize();
this.setSize(size)
}}},_flatten2DElements:function(topic){var result=[];
var children=topic.getChildren();
for(var i=0;
i<children.length;
i++){var child=children[i];
result.push(child);
result.push(child.getOutgoingLine());
var relationships=child.getRelationships();
result=result.concat(relationships);
var innerChilds=this._flatten2DElements(child);
result=result.concat(innerChilds)
}return result
},isChildTopic:function(childTopic){var result=(this.getId()==childTopic.getId());
if(!result){var children=this.getChildren();
for(var i=0;
i<children.length;
i++){var parent=children[i];
result=parent.isChildTopic(childTopic);
if(result){break
}}}return result
},isCentralTopic:function(){return this.getModel().getType()==mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE
}});
mindplot.Topic.CONNECTOR_WIDTH=6;
mindplot.Topic.OUTER_SHAPE_ATTRIBUTES={fillColor:"rgb(252,235,192)",stroke:"1 dot rgb(241,163,39)",x:0,y:0};
mindplot.Topic.OUTER_SHAPE_ATTRIBUTES_FOCUS={fillColor:"rgb(244,184,45)",x:0,y:0};
mindplot.Topic.INNER_RECT_ATTRIBUTES={stroke:"2 solid"};mindplot.CentralTopic=new Class({Extends:mindplot.Topic,initialize:function(model,options){this.parent(model,options)
},_registerEvents:function(){this.parent();
this.addEvent("mousedown",function(event){event.stopPropagation()
})
},workoutIncomingConnectionPoint:function(){return this.getPosition()
},setCursor:function(type){type=(type=="move")?"default":type;
this.parent(type)
},updateTopicShape:function(){},_updatePositionOnChangeSize:function(){var zeroPoint=new core.Point(0,0);
this.setPosition(zeroPoint)
},getShrinkConnector:function(){return null
},workoutOutgoingConnectionPoint:function(targetPosition){$assert(targetPosition,"targetPoint can not be null");
var pos=this.getPosition();
var isAtRight=mindplot.util.Shape.isAtRight(targetPosition,pos);
var size=this.getSize();
return mindplot.util.Shape.calculateRectConnectionPoint(pos,size,!isAtRight)
}});mindplot.MainTopic=new Class({Extends:mindplot.Topic,initialize:function(model,options){this.parent(model,options)
},INNER_RECT_ATTRIBUTES:{stroke:"0.5 solid #009900"},_buildDragShape:function(){var innerShape=this._buildShape(this.INNER_RECT_ATTRIBUTES,this.getShapeType());
var size=this.getSize();
innerShape.setSize(size.width,size.height);
innerShape.setPosition(0,0);
innerShape.setOpacity(0.5);
innerShape.setCursor("default");
innerShape.setVisibility(true);
var brColor=this.getBorderColor();
innerShape.setAttribute("strokeColor",brColor);
var bgColor=this.getBackgroundColor();
innerShape.setAttribute("fillColor",bgColor);
var groupAttributes={width:100,height:100,coordSizeWidth:100,coordSizeHeight:100};
var group=new web2d.Group(groupAttributes);
group.appendChild(innerShape);
if(this.getShapeType()!=mindplot.model.TopicShape.IMAGE){var textShape=this._buildTextShape(true);
var text=this.getText();
textShape.setText(text);
textShape.setOpacity(0.5);
group.appendChild(textShape)
}return group
},updateTopicShape:function(targetTopic,workspace){var model=this.getModel();
var shapeType=model.getShapeType();
if(!targetTopic.isCentralTopic()){if(!$defined(shapeType)){shapeType=this.getShapeType();
this._setShapeType(shapeType,false)
}}},disconnect:function(workspace){this.parent(workspace);
var size=this.getSize();
var model=this.getModel();
var shapeType=model.getShapeType();
if(!$defined(shapeType)){shapeType=this.getShapeType();
this._setShapeType(mindplot.model.TopicShape.ROUNDED_RECT,false)
}var innerShape=this.getInnerShape();
innerShape.setVisibility(true)
},_updatePositionOnChangeSize:function(oldSize,newSize){var xOffset=Math.round((newSize.width-oldSize.width)/2);
var pos=this.getPosition();
if($defined(pos)){if(pos.x>0){pos.x=pos.x+xOffset
}else{pos.x=pos.x-xOffset
}this.setPosition(pos)
}},workoutIncomingConnectionPoint:function(sourcePosition){$assert(sourcePosition,"sourcePoint can not be null");
var pos=this.getPosition();
var size=this.getSize();
var isAtRight=mindplot.util.Shape.isAtRight(sourcePosition,pos);
var result=mindplot.util.Shape.calculateRectConnectionPoint(pos,size,isAtRight);
if(this.getShapeType()==mindplot.model.TopicShape.LINE){result.y=result.y+(this.getSize().height/2)
}var offset=mindplot.Topic.CONNECTOR_WIDTH/2;
if(this.getPosition().x>0){result.x=result.x+offset
}else{result.x=result.x-offset
}result.x=Math.ceil(result.x);
result.y=Math.ceil(result.y);
return result
},workoutOutgoingConnectionPoint:function(targetPosition){$assert(targetPosition,"targetPoint can not be null");
var pos=this.getPosition();
var isAtRight=mindplot.util.Shape.isAtRight(targetPosition,pos);
var size=this.getSize();
var result;
if(this.getShapeType()==mindplot.model.TopicShape.LINE){result=new core.Point();
var groupPosition=this._elem2d.getPosition();
var innerShareSize=this.getInnerShape().getSize();
if(innerShareSize){var magicCorrectionNumber=0.3;
if(!isAtRight){result.x=groupPosition.x+innerShareSize.width-magicCorrectionNumber
}else{result.x=groupPosition.x+magicCorrectionNumber
}result.y=groupPosition.y+innerShareSize.height
}else{if(!isAtRight){result.x=pos.x+(size.width/2)
}else{result.x=pos.x-(size.width/2)
}result.y=pos.y+(size.height/2)
}}else{result=mindplot.util.Shape.calculateRectConnectionPoint(pos,size,isAtRight,true)
}return result
}});mindplot.DragTopic=new Class({initialize:function(dragShape,draggedNode,layoutManger){$assert(dragShape,"Rect can not be null.");
$assert(draggedNode,"draggedNode can not be null.");
$assert(layoutManger,"layoutManger can not be null.");
this._elem2d=dragShape;
this._order=null;
this._draggedNode=draggedNode;
this._layoutManager=layoutManger;
this._position=new core.Point();
this._isInWorkspace=false;
this._isFreeLayoutEnabled=false
},setOrder:function(order){this._order=order
},setPosition:function(x,y){var position={x:x,y:y};
if(this.isFreeLayoutOn()&&this.isConnected()){var _layoutManager=this._layoutManager;
var par=this.getConnectedToTopic();
position=_layoutManager.predict(par.getId(),this._draggedNode.getId(),position,true).position
}this._position.setValue(position.x,position.y);
var draggedNode=this._draggedNode;
var size=draggedNode.getSize();
var cx=position.x-(position.x>0?0:size.width);
var cy=Math.ceil(position.y-(size.height/2));
this._elem2d.setPosition(cx,cy);
if(this.isConnected()&&!this.isFreeLayoutOn()){var parent=this.getConnectedToTopic();
var predict=this._layoutManager.predict(parent.getId(),this._draggedNode.getId(),this.getPosition());
if(this._order!=predict.order){var dragPivot=this._getDragPivot();
var pivotPosition=predict.position;
dragPivot.connectTo(parent,pivotPosition);
this.setOrder(predict.order)
}}},updateFreeLayout:function(event){var isFreeEnabled=(event.meta&&Browser.Platform.mac)||(event.control&&!Browser.Platform.mac);
if(this.isFreeLayoutOn()!=isFreeEnabled){var dragPivot=this._getDragPivot();
dragPivot.setVisibility(!isFreeEnabled);
this._isFreeLayoutEnabled=isFreeEnabled
}},setVisibility:function(value){var dragPivot=this._getDragPivot();
dragPivot.setVisibility(value)
},isVisible:function(){var dragPivot=this._getDragPivot();
return dragPivot.isVisible()
},getInnerShape:function(){return this._elem2d
},disconnect:function(workspace){var dragPivot=this._getDragPivot();
dragPivot.disconnect(workspace)
},connectTo:function(parent){$assert(parent,"Parent connection node can not be null.");
var predict=designer._eventBussDispatcher._layoutManager.predict(parent.getId(),this._draggedNode.getId(),this.getPosition());
var dragPivot=this._getDragPivot();
var position=predict.position;
dragPivot.connectTo(parent,position);
dragPivot.setVisibility(true);
this.setOrder(predict.order)
},getDraggedTopic:function(){return this._draggedNode
},removeFromWorkspace:function(workspace){workspace.removeChild(this._elem2d);
this._isInWorkspace=false;
var dragPivot=this._getDragPivot();
dragPivot.setVisibility(false)
},isInWorkspace:function(){return this._isInWorkspace
},addToWorkspace:function(workspace){workspace.appendChild(this._elem2d);
var dragPivot=this._getDragPivot();
dragPivot.addToWorkspace(workspace);
this._isInWorkspace=true
},_getDragPivot:function(){return mindplot.DragTopic.__getDragPivot()
},getPosition:function(){return this._position
},isDragTopic:function(){return true
},applyChanges:function(workspace){$assert(workspace,"workspace can not be null");
var actionDispatcher=mindplot.ActionDispatcher.getInstance();
var draggedTopic=this.getDraggedTopic();
var topicId=draggedTopic.getId();
var position=this.getPosition();
if(!this.isFreeLayoutOn()){var order=null;
var parent=null;
var isDragConnected=this.isConnected();
if(isDragConnected){var targetTopic=this.getConnectedToTopic();
order=this._order;
parent=targetTopic
}actionDispatcher.dragTopic(topicId,position,order,parent)
}else{actionDispatcher.moveTopic(topicId,position)
}},getConnectedToTopic:function(){var dragPivot=this._getDragPivot();
return dragPivot.getTargetTopic()
},isConnected:function(){return this.getConnectedToTopic()!=null
},isFreeLayoutOn:function(){return false
}});
mindplot.DragTopic.PIVOT_SIZE={width:50,height:6};
mindplot.DragTopic.init=function(workspace){$assert(workspace,"workspace can not be null");
var pivot=mindplot.DragTopic.__getDragPivot();
workspace.appendChild(pivot)
};
mindplot.DragTopic.__getDragPivot=function(){var result=mindplot.DragTopic._dragPivot;
if(!$defined(result)){result=new mindplot.DragPivot();
mindplot.DragTopic._dragPivot=result
}return result
};mindplot.DragManager=new Class({initialize:function(workspace,eventDispatcher){this._workspace=workspace;
this._designerModel=workspace;
this._listeners={};
this._isDragInProcess=false;
this._eventDispatcher=eventDispatcher;
mindplot.DragTopic.init(this._workspace)
},add:function(node){var workspace=this._workspace;
var screen=workspace.getScreenManager();
var dragManager=this;
var mouseDownListener=function(event){if(workspace.isWorkspaceEventsEnabled()){workspace.enableWorkspaceEvents(false);
var layoutManager=this._eventDispatcher.getLayoutManager();
var dragNode=node.createDragNode(layoutManager);
var mouseMoveListener=dragManager._buildMouseMoveListener(workspace,dragNode,dragManager);
screen.addEvent("mousemove",mouseMoveListener);
var mouseUpListener=dragManager._buildMouseUpListener(workspace,node,dragNode,dragManager);
screen.addEvent("mouseup",mouseUpListener);
window.document.body.style.cursor="move"
}}.bind(this);
node.addEvent("mousedown",mouseDownListener)
},remove:function(node){var nodes=this._topics;
var contained=false;
var index=-1;
for(var i=0;
i<nodes.length;
i++){if(nodes[i]==node){contained=true;
index=i
}}},_buildMouseMoveListener:function(workspace,dragNode,dragManager){var screen=workspace.getScreenManager();
var result=function(event){if(!this._isDragInProcess){var startDragListener=dragManager._listeners["startdragging"];
startDragListener(event,dragNode);
workspace.appendChild(dragNode);
this._isDragInProcess=true
}var pos=screen.getWorkspaceMousePosition(event);
dragNode.setPosition(pos.x,pos.y);
var dragListener=dragManager._listeners["dragging"];
if($defined(dragListener)){dragListener(event,dragNode)
}event.preventDefault()
}.bind(this);
dragManager._mouseMoveListener=result;
return result
},_buildMouseUpListener:function(workspace,node,dragNode,dragManager){var screen=workspace.getScreenManager();
var result=function(event){$assert(dragNode.isDragTopic,"dragNode must be an DragTopic");
screen.removeEvent("mousemove",dragManager._mouseMoveListener);
screen.removeEvent("mouseup",dragManager._mouseUpListener);
dragManager._mouseMoveListener=null;
dragManager._mouseUpListener=null;
workspace.enableWorkspaceEvents(true);
window.document.body.style.cursor="default";
if(this._isDragInProcess){var endDragListener=dragManager._listeners["enddragging"];
endDragListener(event,dragNode);
dragNode.removeFromWorkspace(workspace);
this._isDragInProcess=false
}}.bind(this);
dragManager._mouseUpListener=result;
return result
},addEvent:function(type,listener){this._listeners[type]=listener
}});mindplot.DragPivot=new Class({initialize:function(){this._position=new core.Point();
this._size=mindplot.DragTopic.PIVOT_SIZE;
this._straightLine=this._buildStraightLine();
this._curvedLine=this._buildCurvedLine();
this._dragPivot=this._buildRect();
this._connectRect=this._buildRect();
this._targetTopic=null;
this._isVisible=false
},isVisible:function(){return this._isVisible
},getTargetTopic:function(){return this._targetTopic
},_buildStraightLine:function(){var line=new web2d.CurvedLine();
line.setStyle(web2d.CurvedLine.SIMPLE_LINE);
line.setStroke(1,"solid","#CC0033");
line.setOpacity(0.4);
line.setVisibility(false);
return line
},_buildCurvedLine:function(){var line=new web2d.CurvedLine();
line.setStyle(web2d.CurvedLine.SIMPLE_LINE);
line.setStroke(1,"solid","#CC0033");
line.setOpacity(0.4);
line.setVisibility(false);
return line
},_redrawLine:function(){$assert(this.getTargetTopic(),"Illegal invocation. Target node can not be null");
var pivotRect=this._getPivotRect();
var targetTopic=this.getTargetTopic();
var position=this._position;
var size=this._size;
var targetPosition=targetTopic.getPosition();
var line=this._getConnectionLine();
var isAtRight=mindplot.util.Shape.isAtRight(targetPosition,position);
var pivotPoint=mindplot.util.Shape.calculateRectConnectionPoint(position,size,isAtRight);
line.setFrom(pivotPoint.x,pivotPoint.y);
var cx=position.x-(parseInt(size.width)/2);
var cy=position.y-(parseInt(size.height)/2);
pivotRect.setPosition(cx,cy);
var targetPoint=targetTopic.workoutIncomingConnectionPoint(pivotPoint);
line.setTo(targetPoint.x,targetPoint.y)
},setPosition:function(point){this._position=point;
this._redrawLine()
},getPosition:function(){return this._position
},_buildRect:function(){var size=this._size;
var rectAttributes={fillColor:"#CC0033",opacity:0.4,width:size.width,height:size.height,strokeColor:"#FF9933"};
var rect=new web2d.Rect(0,rectAttributes);
rect.setVisibility(false);
return rect
},_getPivotRect:function(){return this._dragPivot
},getSize:function(){var elem2d=this._getPivotRect();
return elem2d.getSize()
},setVisibility:function(value){if(this.isVisible()!=value){var pivotRect=this._getPivotRect();
pivotRect.setVisibility(value);
var connectRect=this._connectRect;
connectRect.setVisibility(value);
var line=this._getConnectionLine();
if(line){line.setVisibility(value)
}this._isVisible=value
}},_getConnectionLine:function(){var result=null;
var parentTopic=this._targetTopic;
if(parentTopic){if(parentTopic.getType()==mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE){result=this._straightLine
}else{result=this._curvedLine
}}return result
},addToWorkspace:function(workspace){var pivotRect=this._getPivotRect();
workspace.appendChild(pivotRect);
var connectToRect=this._connectRect;
workspace.appendChild(connectToRect);
var straighLine=this._straightLine;
straighLine.setVisibility(false);
workspace.appendChild(straighLine);
straighLine.moveToBack();
var curvedLine=this._curvedLine;
curvedLine.setVisibility(false);
workspace.appendChild(curvedLine);
curvedLine.moveToBack();
var connectRect=this._connectRect;
connectRect.setVisibility(false);
workspace.appendChild(connectRect);
connectRect.moveToBack()
},removeFromWorkspace:function(workspace){var shape=this._getPivotRect();
workspace.removeChild(shape);
var connectToRect=this._connectRect;
workspace.removeChild(connectToRect);
if($defined(this._straightLine)){workspace.removeChild(this._straightLine)
}if($defined(this._curvedLine)){workspace.removeChild(this._curvedLine)
}},connectTo:function(targetTopic,position){$assert(!this._outgoingLine,"Could not connect an already connected node");
$assert(targetTopic!=this,"Circular connection are not allowed");
$assert(position,"position can not be null");
$assert(targetTopic,"parent can not be null");
this._position=position;
this._targetTopic=targetTopic;
var connectRect=this._connectRect;
var targetSize=targetTopic.getSize();
var width=targetSize.width+4;
var height=targetSize.height+4;
connectRect.setSize(width,height);
var targetPosition=targetTopic.getPosition();
var cx=Math.ceil(targetPosition.x-(width/2));
var cy=Math.ceil(targetPosition.y-(height/2));
connectRect.setPosition(cx,cy);
var pivotRect=this._getPivotRect();
pivotRect.moveToFront();
pivotRect.setPosition(position.x,position.y);
this._redrawLine()
},disconnect:function(workspace){$assert(workspace,"workspace can not be null.");
$assert(this._targetTopic,"There are not connected topic.");
this.setVisibility(false);
this._targetTopic=null
}});mindplot.ConnectionLine=new Class({initialize:function(sourceNode,targetNode,lineType){$assert(targetNode,"parentNode node can not be null");
$assert(sourceNode,"childNode node can not be null");
$assert(sourceNode!=targetNode,"Circular connection");
this._targetTopic=targetNode;
this._sourceTopic=sourceNode;
var line;
var ctrlPoints=this._getCtrlPoints(sourceNode,targetNode);
if(targetNode.getType()==mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE){line=this._createLine(lineType,mindplot.ConnectionLine.CURVED);
if(line.getType()=="CurvedLine"){line.setSrcControlPoint(ctrlPoints[0]);
line.setDestControlPoint(ctrlPoints[1])
}}else{line=this._createLine(lineType,mindplot.ConnectionLine.SIMPLE_CURVED);
if(line.getType()=="CurvedLine"){line.setSrcControlPoint(ctrlPoints[0]);
line.setDestControlPoint(ctrlPoints[1])
}}var strokeColor=mindplot.ConnectionLine.getStrokeColor();
line.setStroke(1,"solid",strokeColor,1);
line.setFill(strokeColor,1);
this._line2d=line
},_getCtrlPoints:function(sourceNode,targetNode){var srcPos=sourceNode.workoutOutgoingConnectionPoint(targetNode.getPosition());
var destPos=targetNode.workoutIncomingConnectionPoint(sourceNode.getPosition());
var deltaX=(srcPos.x-destPos.x)/3;
return[new core.Point(deltaX,0),new core.Point(-deltaX,0)]
},_createLine:function(lineType,defaultStyle){if(!$defined(lineType)){lineType=defaultStyle
}lineType=parseInt(lineType);
this._lineType=lineType;
var line=null;
switch(lineType){case mindplot.ConnectionLine.POLYLINE:line=new web2d.PolyLine();
break;
case mindplot.ConnectionLine.CURVED:line=new web2d.CurvedLine();
break;
case mindplot.ConnectionLine.SIMPLE_CURVED:line=new web2d.CurvedLine();
line.setStyle(web2d.CurvedLine.SIMPLE_LINE);
break;
default:line=new web2d.Line();
break
}return line
},setVisibility:function(value){this._line2d.setVisibility(value)
},isVisible:function(){return this._line2d.isVisible()
},setOpacity:function(opacity){this._line2d.setOpacity(opacity)
},redraw:function(){var line2d=this._line2d;
var sourceTopic=this._sourceTopic;
var sourcePosition=sourceTopic.getPosition();
var targetTopic=this._targetTopic;
var targetPosition=targetTopic.getPosition();
var sPos,tPos;
sPos=sourceTopic.workoutOutgoingConnectionPoint(targetPosition);
tPos=targetTopic.workoutIncomingConnectionPoint(sourcePosition);
line2d.setFrom(tPos.x,tPos.y);
line2d.setTo(sPos.x,sPos.y);
if(line2d.getType()=="CurvedLine"){var ctrlPoints=this._getCtrlPoints(this._sourceTopic,this._targetTopic);
line2d.setSrcControlPoint(ctrlPoints[0]);
line2d.setDestControlPoint(ctrlPoints[1])
}this._positionateConnector(targetTopic)
},_positionateConnector:function(targetTopic){var targetPosition=targetTopic.getPosition();
var offset=mindplot.Topic.CONNECTOR_WIDTH/2;
var targetTopicSize=targetTopic.getSize();
var y,x;
if(targetTopic.getShapeType()==mindplot.model.TopicShape.LINE){y=targetTopicSize.height
}else{y=targetTopicSize.height/2
}y=y-offset;
var connector=targetTopic.getShrinkConnector();
if($defined(connector)){if(Math.sign(targetPosition.x)>0){x=targetTopicSize.width;
connector.setPosition(x,y)
}else{x=-mindplot.Topic.CONNECTOR_WIDTH
}connector.setPosition(x,y)
}},setStroke:function(color,style,opacity){this._line2d.setStroke(null,null,color,opacity)
},addToWorkspace:function(workspace){workspace.appendChild(this._line2d);
this._line2d.moveToBack()
},removeFromWorkspace:function(workspace){workspace.removeChild(this._line2d)
},getTargetTopic:function(){return this._targetTopic
},getSourceTopic:function(){return this._sourceTopic
},getLineType:function(){return this._lineType
},getLine:function(){return this._line2d
},getModel:function(){return this._model
},setModel:function(model){this._model=model
},getType:function(){return"ConnectionLine"
},getId:function(){return this._model.getId()
},moveToBack:function(){this._line2d.moveToBack()
},moveToFront:function(){this._line2d.moveToFront()
}});
mindplot.ConnectionLine.getStrokeColor=function(){return"#495879"
};
mindplot.ConnectionLine.SIMPLE=0;
mindplot.ConnectionLine.POLYLINE=1;
mindplot.ConnectionLine.CURVED=2;
mindplot.ConnectionLine.SIMPLE_CURVED=3;mindplot.Relationship=new Class({Extends:mindplot.ConnectionLine,Static:{getStrokeColor:function(){return"#9b74e6"
},type:"Relationship"},initialize:function(sourceNode,targetNode,model){$assert(sourceNode,"sourceNode can not be null");
$assert(targetNode,"targetNode can not be null");
this.parent(sourceNode,targetNode,model.getLineType());
this.setModel(model);
var strokeColor=mindplot.Relationship.getStrokeColor();
this._line2d.setIsSrcControlPointCustom(false);
this._line2d.setIsDestControlPointCustom(false);
this._line2d.setCursor("pointer");
this._line2d.setStroke(1,"solid",strokeColor);
this._line2d.setDashed(4,2);
this._focusShape=this._createLine(this.getLineType(),mindplot.ConnectionLine.SIMPLE_CURVED);
this._focusShape.setStroke(2,"solid","#3f96ff");
var ctrlPoints=this._line2d.getControlPoints();
this._focusShape.setSrcControlPoint(ctrlPoints[0]);
this._focusShape.setDestControlPoint(ctrlPoints[1]);
this._focusShape.setVisibility(false);
this._onFocus=false;
this._isInWorkspace=false;
this._controlPointsController=new mindplot.ControlPoint();
this._startArrow=new web2d.Arrow();
this._startArrow.setStrokeColor(strokeColor);
this._startArrow.setStrokeWidth(2);
this.setShowStartArrow(true);
if(this._showEndArrow){this._endArrow=new web2d.Arrow();
this._endArrow.setStrokeColor(strokeColor);
this._endArrow.setStrokeWidth(2)
}if($defined(model.getSrcCtrlPoint())){var srcPoint=model.getSrcCtrlPoint().clone();
this.setSrcControlPoint(srcPoint)
}if($defined(model.getDestCtrlPoint())){var destPoint=model.getDestCtrlPoint().clone();
this.setDestControlPoint(destPoint)
}},setStroke:function(color,style,opacity){this.parent(color,style,opacity);
this._startArrow.setStrokeColor(color)
},redraw:function(){var line2d=this._line2d;
var sourceTopic=this._sourceTopic;
var sourcePosition=sourceTopic.getPosition();
var targetTopic=this._targetTopic;
var targetPosition=targetTopic.getPosition();
var sPos,tPos;
this._line2d.setStroke(2);
var ctrlPoints=this._line2d.getControlPoints();
if(!this._line2d.isDestControlPointCustom()&&!this._line2d.isSrcControlPointCustom()){var defaultPoints=mindplot.util.Shape.calculateDefaultControlPoints(sourcePosition,targetPosition);
ctrlPoints[0].x=defaultPoints[0].x;
ctrlPoints[0].y=defaultPoints[0].y;
ctrlPoints[1].x=defaultPoints[1].x;
ctrlPoints[1].y=defaultPoints[1].y
}var spoint=new core.Point();
spoint.x=parseInt(ctrlPoints[0].x)+parseInt(sourcePosition.x);
spoint.y=parseInt(ctrlPoints[0].y)+parseInt(sourcePosition.y);
var tpoint=new core.Point();
tpoint.x=parseInt(ctrlPoints[1].x)+parseInt(targetPosition.x);
tpoint.y=parseInt(ctrlPoints[1].y)+parseInt(targetPosition.y);
sPos=mindplot.util.Shape.calculateRelationShipPointCoordinates(sourceTopic,spoint);
tPos=mindplot.util.Shape.calculateRelationShipPointCoordinates(targetTopic,tpoint);
line2d.setFrom(sPos.x,sPos.y);
line2d.setTo(tPos.x,tPos.y);
line2d.moveToFront();
this._positionArrows();
this._positionateConnector(targetTopic);
if(this.isOnFocus()){this._refreshShape()
}this._focusShape.moveToBack();
this._controlPointsController.redraw()
},_positionArrows:function(){var tpos=this._line2d.getTo();
var spos=this._line2d.getFrom();
this._startArrow.setFrom(spos.x,spos.y);
this._startArrow.moveToBack();
if(this._endArrow){this._endArrow.setFrom(tpos.x,tpos.y);
this._endArrow.moveToBack()
}if(this._line2d.getType()=="CurvedLine"){var controlPoints=this._line2d.getControlPoints();
this._startArrow.setControlPoint(controlPoints[0]);
if(this._endArrow){this._endArrow.setControlPoint(controlPoints[1])
}}else{this._startArrow.setControlPoint(this._line2d.getTo());
if(this._endArrow){this._endArrow.setControlPoint(this._line2d.getFrom())
}}if(this._showEndArrow){this._endArrow.setVisibility(this.isVisible())
}this._startArrow.setVisibility(this.isVisible()&&this._showStartArrow)
},addToWorkspace:function(workspace){workspace.appendChild(this._focusShape);
workspace.appendChild(this._controlPointsController);
this._controlPointControllerListener=this._initializeControlPointController.bind(this);
this._line2d.addEvent("click",this._controlPointControllerListener);
this._isInWorkspace=true;
workspace.appendChild(this._startArrow);
if(this._endArrow){workspace.appendChild(this._endArrow)
}this.parent(workspace);
this._positionArrows();
this.redraw()
},_initializeControlPointController:function(){this.setOnFocus(true)
},removeFromWorkspace:function(workspace){workspace.removeChild(this._focusShape);
workspace.removeChild(this._controlPointsController);
this._line2d.removeEvent("click",this._controlPointControllerListener);
this._isInWorkspace=false;
workspace.removeChild(this._startArrow);
if(this._endArrow){workspace.removeChild(this._endArrow)
}this.parent(workspace)
},getType:function(){return mindplot.Relationship.type
},setOnFocus:function(focus){if(this.isOnFocus()!=focus){if(focus){this._refreshShape();
this._controlPointsController.setLine(this)
}this._focusShape.setVisibility(focus);
this._controlPointsController.setVisibility(focus);
this._onFocus=focus;
this.fireEvent(focus?"ontfocus":"ontblur",this)
}},_refreshShape:function(){var sPos=this._line2d.getFrom();
var tPos=this._line2d.getTo();
var ctrlPoints=this._line2d.getControlPoints();
this._focusShape.setFrom(sPos.x,sPos.y);
this._focusShape.setTo(tPos.x,tPos.y);
var shapeCtrlPoints=this._focusShape.getControlPoints();
shapeCtrlPoints[0].x=ctrlPoints[0].x;
shapeCtrlPoints[0].y=ctrlPoints[0].y;
shapeCtrlPoints[1].x=ctrlPoints[1].x;
shapeCtrlPoints[1].y=ctrlPoints[1].y;
this._focusShape.updateLine()
},addEvent:function(type,listener){if(type=="onfocus"){type="mousedown"
}var line=this._line2d;
line.addEvent(type,listener)
},isOnFocus:function(){return this._onFocus
},isInWorkspace:function(){return this._isInWorkspace
},setVisibility:function(value){this.parent(value);
if(this._showEndArrow){this._endArrow.setVisibility(this._showEndArrow)
}this._startArrow.setVisibility(this._showStartArrow&&value)
},setOpacity:function(opacity){this.parent(opacity);
if(this._showEndArrow){this._endArrow.setOpacity(opacity)
}if(this._showStartArrow){this._startArrow.setOpacity(opacity)
}},setShowEndArrow:function(visible){this._showEndArrow=visible;
if(this._isInWorkspace){this.redraw()
}},setShowStartArrow:function(visible){this._showStartArrow=visible;
if(this._isInWorkspace){this.redraw()
}},setFrom:function(x,y){$assert($defined(x),"x must be defined");
$assert($defined(y),"y must be defined");
this._line2d.setFrom(x,y);
this._startArrow.setFrom(x,y)
},setTo:function(x,y){$assert($defined(x),"x must be defined");
$assert($defined(y),"y must be defined");
this._line2d.setTo(x,y);
if(this._endArrow){this._endArrow.setFrom(x,y)
}},setSrcControlPoint:function(control){this._line2d.setSrcControlPoint(control);
this._startArrow.setControlPoint(control)
},setDestControlPoint:function(control){this._line2d.setDestControlPoint(control);
if(this._showEndArrow){this._endArrow.setControlPoint(control)
}},getControlPoints:function(){return this._line2d.getControlPoints()
},isSrcControlPointCustom:function(){return this._line2d.isSrcControlPointCustom()
},isDestControlPointCustom:function(){return this._line2d.isDestControlPointCustom()
},setIsSrcControlPointCustom:function(isCustom){this._line2d.setIsSrcControlPointCustom(isCustom)
},setIsDestControlPointCustom:function(isCustom){this._line2d.setIsDestControlPointCustom(isCustom)
},getId:function(){return this._model.getId()
},fireEvent:function(type,event){var elem=this._line2d;
elem.fireEvent(type,event)
}});mindplot.DragConnector=new Class({initialize:function(designerModel,workspace){$assert(designerModel,"designerModel can not be null");
$assert(workspace,"workspace can not be null");
this._designerModel=designerModel;
this._workspace=workspace
},checkConnection:function(dragTopic){var topics=this._designerModel.getTopics();
var candidates=this._searchConnectionCandidates(dragTopic);
var currentConnection=dragTopic.getConnectedToTopic();
if(currentConnection&&(candidates.length==0||candidates[0]!=currentConnection)){dragTopic.disconnect(this._workspace)
}if(!dragTopic.isConnected()&&candidates.length>0){dragTopic.connectTo(candidates[0])
}},_searchConnectionCandidates:function(dragTopic){var topics=this._designerModel.getTopics();
var draggedNode=dragTopic.getDraggedTopic();
var dragTopicWidth=dragTopic.getSize?dragTopic.getSize().width:0;
var xMouseGap=dragTopic.getPosition().x>0?0:dragTopicWidth;
var sPos={x:dragTopic.getPosition().x-xMouseGap,y:dragTopic.getPosition().y};
topics=topics.filter(function(topic){var result=draggedNode!=topic;
result=result&&topic!=draggedNode;
result=result&&!topic.areChildrenShrunken()&&!topic.isCollapsed();
result=result&&!draggedNode.isChildTopic(topic);
return result
});
topics=topics.filter(function(topic){var tpos=topic.getPosition();
var txborder=tpos.x+(topic.getSize().width/2)*Math.sign(sPos.x);
var distance=(sPos.x-txborder)*Math.sign(sPos.x);
return distance>0&&(distance<mindplot.DragConnector.MAX_VERTICAL_CONNECTION_TOLERANCE)
});
var currentConnection=dragTopic.getConnectedToTopic();
topics=topics.sort(function(a,b){var aPos=a.getPosition();
var bPos=b.getPosition();
var av=this._isVerticallyAligned(a.getSize(),aPos,sPos);
var bv=this._isVerticallyAligned(b.getSize(),bPos,sPos);
return this._proximityWeight(av,a,sPos,currentConnection)-this._proximityWeight(bv,b,sPos,currentConnection)
}.bind(this));
return topics
},_proximityWeight:function(isAligned,target,sPos,currentConnection){var tPos=target.getPosition();
return(isAligned?0:200)+Math.abs(tPos.x-sPos.x)+Math.abs(tPos.y-sPos.y)+(currentConnection==target?0:100)
},_isVerticallyAligned:function(targetSize,targetPosition,sourcePosition){return Math.abs(sourcePosition.y-targetPosition.y)<targetSize.height/2
}});
mindplot.DragConnector.MAX_VERTICAL_CONNECTION_TOLERANCE=80;mindplot.TextEditor=new Class({initialize:function(topic){this._topic=topic
},_buildEditor:function(){this._size={width:500,height:100};
var result=new Element("div");
result.setStyles({position:"absolute",display:"none",zIndex:"8",width:"500px",height:"100px"});
var inputContainer=new Element("div");
inputContainer.setStyles({border:"none",overflow:"auto"});
inputContainer.inject(result);
var inputText=new Element("input",{type:"text",tabindex:"-1",value:""});
inputText.setStyles({border:"none",background:"transparent"});
inputText.inject(inputContainer);
var spanContainer=new Element("div");
spanContainer.setStyle("visibility","hidden");
spanContainer.inject(result);
var spanElem=new Element("span",{tabindex:"-1"});
spanElem.setStyle("white-space","nowrap");
spanElem.setStyle("nowrap","nowrap");
spanElem.inject(spanContainer);
return result
},_registerEvents:function(divElem){var inputElem=this._getTextareaElem();
var spanElem=this._getSpanElem();
divElem.addEvent("keydown",function(event){switch(event.key){case"esc":this.close(false);
break;
case"enter":this.close(true);
break;
default:spanElem.innerHTML=inputElem.value;
var size=inputElem.value.length+1;
inputElem.size=size;
if(spanElem.offsetWidth>(parseInt(divElem.style.width)-100)){divElem.style.width=(spanElem.offsetWidth+100)+"px"
}break
}event.stopPropagation()
}.bind(this));
divElem.addEvent("click",function(event){event.stopPropagation()
});
divElem.addEvent("dblclick",function(event){event.stopPropagation()
});
divElem.addEvent("mousedown",function(event){event.stopPropagation()
})
},isVisible:function(){return $defined(this._containerElem)&&this._containerElem.getStyle("display")=="block"
},_updateModel:function(){if(this._topic.getText()!=this._getText()){var text=this._getText();
var topicId=this._topic.getId();
var actionDispatcher=mindplot.ActionDispatcher.getInstance();
actionDispatcher.changeTextToTopic([topicId],text)
}},show:function(text){if(!this.isVisible()){var editorElem=this._buildEditor();
editorElem.inject($(document.body));
this._containerElem=editorElem;
this._registerEvents(editorElem);
this._showEditor(text)
}},_showEditor:function(defaultText){var topic=this._topic;
topic.getTextShape().setVisibility(false);
var nodeText=topic.getTextShape();
var font=nodeText.getFont();
font.size=nodeText.getHtmlFontSize();
font.color=nodeText.getColor();
this._setStyle(font);
var text=$defined(defaultText)?defaultText:topic.getText();
this._setText(text);
var displayFunc=function(){var textShape=this._topic.getTextShape();
textShape.positionRelativeTo(this._containerElem,{position:{x:"left",y:"top"},edge:{x:"left",y:"top"}});
this._containerElem.setStyle("display","block");
var elemSize=topic.getSize();
this._setEditorSize(elemSize.width,elemSize.height);
var textareaElem=this._getTextareaElem();
textareaElem.focus();
this._positionCursor(textareaElem,!$defined(defaultText))
}.bind(this);
displayFunc.delay(10)
},_setStyle:function(fontStyle){var inputField=this._getTextareaElem();
var spanField=this._getSpanElem();
if(!$defined(fontStyle.font)){fontStyle.font="Arial"
}if(!$defined(fontStyle.style)){fontStyle.style="normal"
}if(!$defined(fontStyle.weight)){fontStyle.weight="normal"
}if(!$defined(fontStyle.size)){fontStyle.size=12
}inputField.style.fontSize=fontStyle.size+"px";
inputField.style.fontFamily=fontStyle.font;
inputField.style.fontStyle=fontStyle.style;
inputField.style.fontWeight=fontStyle.weight;
inputField.style.color=fontStyle.color;
spanField.style.fontFamily=fontStyle.font;
spanField.style.fontStyle=fontStyle.style;
spanField.style.fontWeight=fontStyle.weight;
spanField.style.fontSize=fontStyle.size+"px"
},_setText:function(text){var inputField=this._getTextareaElem();
inputField.size=text.length+1;
this._containerElem.style.width=(inputField.size*parseInt(inputField.style.fontSize)+100)+"px";
var spanField=this._getSpanElem();
spanField.innerHTML=text;
inputField.value=text
},_getText:function(){return this._getTextareaElem().value
},_getTextareaElem:function(){return this._containerElem.getElement("input")
},_getSpanElem:function(){return this._containerElem.getElement("span")
},_setEditorSize:function(width,height){var textShape=this._topic.getTextShape();
var scale=web2d.peer.utils.TransformUtil.workoutScale(textShape._peer);
this._size={width:width*scale.width,height:height*scale.height};
this._containerElem.style.width=this._size.width*2+"px";
this._containerElem.style.height=this._size.height+"px"
},_positionCursor:function(inputElem,selectText){if(inputElem.createTextRange){var range=inputElem.createTextRange();
var pos=inputElem.value.length;
if(!selectText){range.select();
range.move("character",pos)
}else{range.move("character",pos);
range.select()
}}else{if(!selectText){inputElem.setSelectionRange(0,inputElem.value.length)
}}},close:function(update){if(this.isVisible()){if(!$defined(update)||update){this._updateModel()
}this._topic.getTextShape().setVisibility(true);
this._containerElem.dispose();
this._containerElem=null
}}});mindplot.MultilineTextEditor=new Class({Extends:Events,initialize:function(){this._topic=null;
this._timeoutId=-1
},_buildEditor:function(){var result=new Element("div");
result.setStyles({position:"absolute",display:"none",zIndex:"8",overflow:"hidden",border:"0 none"});
var textareaElem=new Element("textarea",{tabindex:"-1",value:"",wrap:"off"});
textareaElem.setStyles({border:"1px gray dashed",background:"rgba(98, 135, 167, .3)",outline:"0 none",resize:"none",overflow:"hidden"});
textareaElem.inject(result);
return result
},_registerEvents:function(containerElem){var textareaElem=this._getTextareaElem();
textareaElem.addEvent("keydown",function(event){switch(event.key){case"esc":this.close(false);
break;
case"enter":if(event.meta||event.control){var text=textareaElem.value;
var cursorPosition=text.length;
if(textareaElem.selectionStart){cursorPosition=textareaElem.selectionStart
}var head=text.substring(0,cursorPosition);
var tail="";
if(cursorPosition<text.length){tail=text.substring(cursorPosition,text.length)
}textareaElem.value=head+"\n"+tail;
if(textareaElem.setSelectionRange){textareaElem.focus();
textareaElem.setSelectionRange(cursorPosition+1,cursorPosition+1)
}else{if(textareaElem.createTextRange){var range=textareaElem.createTextRange();
range.moveStart("character",cursorPosition+1);
range.select()
}}}else{this.close(true)
}break
}event.stopPropagation()
}.bind(this));
textareaElem.addEvent("keypress",function(event){event.stopPropagation()
});
textareaElem.addEvent("keyup",function(event){var text=this._getTextareaElem().value;
this.fireEvent("input",[event,text]);
this._adjustEditorSize()
}.bind(this));
containerElem.addEvent("click",function(event){event.stopPropagation()
});
containerElem.addEvent("dblclick",function(event){event.stopPropagation()
});
containerElem.addEvent("mousedown",function(event){event.stopPropagation()
})
},_adjustEditorSize:function(){if(this.isVisible()){var textElem=this._getTextareaElem();
var lines=textElem.value.split("\n");
var maxLineLength=1;
lines.each(function(line){if(maxLineLength<line.length){maxLineLength=line.length
}});
textElem.setAttribute("cols",maxLineLength);
textElem.setAttribute("rows",lines.length);
this._containerElem.setStyles({width:(maxLineLength+3)+"em",height:textElem.getSize().height})
}},isVisible:function(){return $defined(this._containerElem)&&this._containerElem.getStyle("display")=="block"
},_updateModel:function(){if(this._topic.getText()!=this._getText()){var text=this._getText();
var topicId=this._topic.getId();
var actionDispatcher=mindplot.ActionDispatcher.getInstance();
actionDispatcher.changeTextToTopic([topicId],text)
}},show:function(topic,text){if(this._topic){this.close(false)
}this._topic=topic;
if(!this.isVisible()){var containerElem=this._buildEditor();
containerElem.inject($(document.body));
this._containerElem=containerElem;
this._registerEvents(containerElem);
this._showEditor(text)
}},_showEditor:function(defaultText){var topic=this._topic;
topic.getTextShape().setVisibility(false);
var nodeText=topic.getTextShape();
var font=nodeText.getFont();
font.size=nodeText.getHtmlFontSize();
font.color=nodeText.getColor();
this._setStyle(font);
var displayFunc=function(){var textShape=this._topic.getTextShape();
textShape.positionRelativeTo(this._containerElem,{position:{x:"left",y:"top"},edge:{x:"left",y:"top"}});
this._containerElem.setStyle("display","block");
var text=$defined(defaultText)?defaultText:topic.getText();
this._setText(text);
var inputElem=this._getTextareaElem();
this._positionCursor(inputElem,!$defined(defaultText))
}.bind(this);
this._timeoutId=displayFunc.delay(10)
},_setStyle:function(fontStyle){var inputField=this._getTextareaElem();
if(!$defined(fontStyle.font)){fontStyle.font="Arial"
}if(!$defined(fontStyle.style)){fontStyle.style="normal"
}if(!$defined(fontStyle.weight)){fontStyle.weight="normal"
}if(!$defined(fontStyle.size)){fontStyle.size=12
}var style={fontSize:fontStyle.size+"px",fontFamily:fontStyle.font,fontStyle:fontStyle.style,fontWeight:fontStyle.weight,color:fontStyle.color};
inputField.setStyles(style);
this._containerElem.setStyles(style)
},_setText:function(text){var textareaElem=this._getTextareaElem();
textareaElem.value=text;
this._adjustEditorSize()
},_getText:function(){return this._getTextareaElem().value
},_getTextareaElem:function(){return this._containerElem.getElement("textarea")
},_positionCursor:function(textareaElem,selectText){textareaElem.focus();
if(selectText){if(textareaElem.createTextRange){var rang=textareaElem.createTextRange();
rang.select();
rang.move("character",textareaElem.value.length)
}else{textareaElem.setSelectionRange(0,textareaElem.value.length)
}}else{if(textareaElem.createTextRange){var range=textareaElem.createTextRange();
range.move("character",textareaElem.value.length)
}else{textareaElem.selectionStart=textareaElem.value.length
}}},close:function(update){if(this.isVisible()&&this._topic){clearTimeout(this._timeoutId);
if(!$defined(update)||update){this._updateModel()
}this._topic.getTextShape().setVisibility(true);
this._containerElem.dispose();
this._containerElem=null;
this._timeoutId=-1
}this._topic=null
}});mindplot.TextEditorFactory={};
mindplot.TextEditorFactory.getTextEditorFromName=function(name){var editorClass=null;
if(name=="RichTextEditor"){editorClass=mindplot.RichTextEditor
}else{editorClass=mindplot.TextEditor
}return editorClass
};mindplot.util.Shape={isAtRight:function(sourcePoint,targetPoint){$assert(sourcePoint,"Source can not be null");
$assert(targetPoint,"Target can not be null");
return sourcePoint.x<targetPoint.x
},calculateRectConnectionPoint:function(rectCenterPoint,rectSize,isAtRight){$assert(rectCenterPoint,"rectCenterPoint can  not be null");
$assert(rectSize,"rectSize can  not be null");
$assert($defined(isAtRight),"isRight can  not be null");
var result=new core.Point();
var correctionHardcode=2;
if(isAtRight){result.setValue(rectCenterPoint.x-(rectSize.width/2)+correctionHardcode,rectCenterPoint.y)
}else{result.setValue(parseFloat(rectCenterPoint.x)+(rectSize.width/2)-correctionHardcode,rectCenterPoint.y)
}return result
},calculateRelationShipPointCoordinates:function(topic,controlPoint){var size=topic.getSize();
var position=topic.getPosition();
var div=(position.x-controlPoint.x);
div=(Math.abs(div)>0.1?div:0.1);
var m=(position.y-controlPoint.y)/div;
var y,x;
var gap=5;
if(controlPoint.y>position.y+(size.height/2)){y=position.y+(size.height/2)+gap;
x=position.x-((position.y-y)/m);
if(x>position.x+(size.width/2)){x=position.x+(size.width/2)
}else{if(x<position.x-(size.width/2)){x=position.x-(size.width/2)
}}}else{if(controlPoint.y<position.y-(size.height/2)){y=position.y-(size.height/2)-gap;
x=position.x-((position.y-y)/m);
if(x>position.x+(size.width/2)){x=position.x+(size.width/2)
}else{if(x<position.x-(size.width/2)){x=position.x-(size.width/2)
}}}else{if(controlPoint.x<(position.x-size.width/2)){x=position.x-(size.width/2)-gap;
y=position.y-(m*(position.x-x))
}else{x=position.x+(size.width/2)+gap;
y=position.y-(m*(position.x-x))
}}}return new core.Point(x,y)
},calculateDefaultControlPoints:function(srcPos,tarPos){var y=srcPos.y-tarPos.y;
var x=srcPos.x-tarPos.x;
var div=(Math.abs(x)>0.1?x:0.1);
var m=y/div;
var l=Math.sqrt(y*y+x*x)/3;
var fix=1;
if(srcPos.x>tarPos.x){fix=-1
}var x1=srcPos.x+Math.sqrt(l*l/(1+(m*m)))*fix;
var y1=m*(x1-srcPos.x)+srcPos.y;
var x2=tarPos.x+Math.sqrt(l*l/(1+(m*m)))*fix*-1;
var y2=m*(x2-tarPos.x)+tarPos.y;
return[new core.Point(-srcPos.x+x1,-srcPos.y+y1),new core.Point(-tarPos.x+x2,-tarPos.y+y2)]
}};mindplot.util.FadeEffect=new Class({Extends:Fx,initialize:function(elements,isVisible){this.parent({duration:3000,frames:15,transition:"linear"});
this._isVisible=isVisible;
this._element=elements;
this.addEvent("complete",function(){this._element.each(function(elem){if(elem){elem.setVisibility(isVisible)
}})
})
},start:function(){this.parent(this._isVisible?0:1,this._isVisible?1:0)
},set:function(now){this._element.each(function(elem){if(elem){elem.setOpacity(now)
}});
return this
}});mindplot.persistence.ModelCodeName={BETA:"beta",PELA:"pela",TANGO:"tango"};mindplot.persistence.XMLSerializer_Pela=new Class({toXML:function(mindmap){$assert(mindmap,"Can not save a null mindmap");
var document=core.Utils.createDocument();
var mapElem=document.createElement("map");
var name=mindmap.getId();
if($defined(name)){mapElem.setAttribute("name",name)
}var version=mindmap.getVersion();
if($defined(version)){mapElem.setAttribute("version",version)
}document.appendChild(mapElem);
var topics=mindmap.getBranches();
for(var i=0;
i<topics.length;
i++){var topic=topics[i];
var topicDom=this._topicToXML(document,topic);
mapElem.appendChild(topicDom)
}var relationships=mindmap.getRelationships();
if(relationships.length>0){for(var j=0;
j<relationships.length;
j++){var relationship=relationships[j];
if(mindmap.findNodeById(relationship.getFromNode())!==null&&mindmap.findNodeById(relationship.getToNode())!==null){var relationDom=this._relationshipToXML(document,relationship);
mapElem.appendChild(relationDom)
}}}return document
},_topicToXML:function(document,topic){var parentTopic=document.createElement("topic");
if(topic.getType()==mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE){parentTopic.setAttribute("central","true")
}else{var pos=topic.getPosition();
parentTopic.setAttribute("position",pos.x+","+pos.y);
var order=topic.getOrder();
if(typeof order==="number"&&isFinite(order)){parentTopic.setAttribute("order",order)
}}var text=topic.getText();
if($defined(text)){this._noteTextToXML(document,parentTopic,text)
}var shape=topic.getShapeType();
if($defined(shape)){parentTopic.setAttribute("shape",shape);
if(shape==mindplot.model.TopicShape.IMAGE){parentTopic.setAttribute("image",topic.getImageSize().width+","+topic.getImageSize().height+":"+topic.getImageUrl())
}}if(topic.areChildrenShrunken()){parentTopic.setAttribute("shrink","true")
}var id=topic.getId();
parentTopic.setAttribute("id",id);
var font="";
var fontFamily=topic.getFontFamily();
font+=(fontFamily?fontFamily:"")+";";
var fontSize=topic.getFontSize();
font+=(fontSize?fontSize:"")+";";
var fontColor=topic.getFontColor();
font+=(fontColor?fontColor:"")+";";
var fontWeight=topic.getFontWeight();
font+=(fontWeight?fontWeight:"")+";";
var fontStyle=topic.getFontStyle();
font+=(fontStyle?fontStyle:"")+";";
if($defined(fontFamily)||$defined(fontSize)||$defined(fontColor)||$defined(fontWeight)||$defined(fontStyle)){parentTopic.setAttribute("fontStyle",font)
}var bgColor=topic.getBackgroundColor();
if($defined(bgColor)){parentTopic.setAttribute("bgColor",bgColor)
}var brColor=topic.getBorderColor();
if($defined(brColor)){parentTopic.setAttribute("brColor",brColor)
}var metadata=topic.getMetadata();
if($defined(metadata)){parentTopic.setAttribute("metadata",metadata)
}var features=topic.getFeatures();
for(var i=0;
i<features.length;
i++){var feature=features[i];
var featureType=feature.getType();
var featureDom=document.createElement(featureType);
var attributes=feature.getAttributes();
for(var key in attributes){var value=attributes[key];
if(key=="text"){var cdata=document.createCDATASection(value);
featureDom.appendChild(cdata)
}else{featureDom.setAttribute(key,value)
}}parentTopic.appendChild(featureDom)
}var childTopics=topic.getChildren();
for(var j=0;
j<childTopics.length;
j++){var childTopic=childTopics[j];
var childDom=this._topicToXML(document,childTopic);
parentTopic.appendChild(childDom)
}return parentTopic
},_noteTextToXML:function(document,elem,text){if(text.indexOf("\n")==-1){elem.setAttribute("text",text)
}else{var textDom=document.createElement("text");
var cdata=document.createCDATASection(text);
textDom.appendChild(cdata);
elem.appendChild(textDom)
}},_relationshipToXML:function(document,relationship){var result=document.createElement("relationship");
result.setAttribute("srcTopicId",relationship.getFromNode());
result.setAttribute("destTopicId",relationship.getToNode());
var lineType=relationship.getLineType();
result.setAttribute("lineType",lineType);
if(lineType==mindplot.ConnectionLine.CURVED||lineType==mindplot.ConnectionLine.SIMPLE_CURVED){if($defined(relationship.getSrcCtrlPoint())){var srcPoint=relationship.getSrcCtrlPoint();
result.setAttribute("srcCtrlPoint",Math.round(srcPoint.x)+","+Math.round(srcPoint.y))
}if($defined(relationship.getDestCtrlPoint())){var destPoint=relationship.getDestCtrlPoint();
result.setAttribute("destCtrlPoint",Math.round(destPoint.x)+","+Math.round(destPoint.y))
}}result.setAttribute("endArrow",relationship.getEndArrow());
result.setAttribute("startArrow",relationship.getStartArrow());
return result
},loadFromDom:function(dom,mapId){$assert(dom,"dom can not be null");
$assert(mapId,"mapId can not be null");
var rootElem=dom.documentElement;
$assert(rootElem.tagName==mindplot.persistence.XMLSerializer_Pela.MAP_ROOT_NODE,"This seem not to be a map document.");
this._idsMap=new Hash();
var version=rootElem.getAttribute("version");
var mindmap=new mindplot.model.Mindmap(mapId,version);
var children=rootElem.childNodes;
for(var i=0;
i<children.length;
i++){var child=children[i];
if(child.nodeType==1){switch(child.tagName){case"topic":var topic=this._deserializeNode(child,mindmap);
mindmap.addBranch(topic);
break;
case"relationship":var relationship=this._deserializeRelationship(child,mindmap);
if(relationship!=null){mindmap.addRelationship(relationship)
}break
}}}this._idsMap=null;
mindmap.setId(mapId);
return mindmap
},_deserializeNode:function(domElem,mindmap){var type=(domElem.getAttribute("central")!=null)?mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE:mindplot.model.INodeModel.MAIN_TOPIC_TYPE;
var id=domElem.getAttribute("id");
if($defined(id)){id=parseInt(id)
}if(this._idsMap.has(id)){id=null
}else{this._idsMap.set(id,domElem)
}var topic=mindmap.createNode(type,id);
var text=domElem.getAttribute("text");
if($defined(text)&&text){topic.setText(text)
}var fontStyle=domElem.getAttribute("fontStyle");
if($defined(fontStyle)&&fontStyle){var font=fontStyle.split(";");
if(font[0]){topic.setFontFamily(font[0])
}if(font[1]){topic.setFontSize(font[1])
}if(font[2]){topic.setFontColor(font[2])
}if(font[3]){topic.setFontWeight(font[3])
}if(font[4]){topic.setFontStyle(font[4])
}}var shape=domElem.getAttribute("shape");
if($defined(shape)){topic.setShapeType(shape);
if(shape==mindplot.model.TopicShape.IMAGE){var image=domElem.getAttribute("image");
var size=image.substring(0,image.indexOf(":"));
var url=image.substring(image.indexOf(":")+1,image.length);
topic.setImageUrl(url);
var split=size.split(",");
topic.setImageSize(split[0],split[1])
}}var bgColor=domElem.getAttribute("bgColor");
if($defined(bgColor)){topic.setBackgroundColor(bgColor)
}var borderColor=domElem.getAttribute("brColor");
if($defined(borderColor)){topic.setBorderColor(borderColor)
}var order=domElem.getAttribute("order");
if($defined(order)&&order!="NaN"){topic.setOrder(parseInt(order))
}var isShrink=domElem.getAttribute("shrink");
if($defined(isShrink)){topic.setChildrenShrunken(isShrink)
}var position=domElem.getAttribute("position");
if($defined(position)){var pos=position.split(",");
topic.setPosition(pos[0],pos[1])
}var metadata=domElem.getAttribute("metadata");
if($defined(metadata)){topic.setMetadata(metadata)
}var children=domElem.childNodes;
for(var i=0;
i<children.length;
i++){var child=children[i];
if(child.nodeType==Node.ELEMENT_NODE){if(child.tagName=="topic"){var childTopic=this._deserializeNode(child,mindmap);
childTopic.connectTo(topic)
}else{if(mindplot.TopicFeature.isSupported(child.tagName)){var namedNodeMap=child.attributes;
var attributes={};
for(var j=0;
j<namedNodeMap.length;
j++){var attribute=namedNodeMap.item(j);
attributes[attribute.name]=attribute.value
}var textAttr=this._deserializeTextAttr(child);
if(textAttr){attributes["text"]=textAttr
}var featureType=child.tagName;
var feature=mindplot.TopicFeature.createModel(featureType,attributes);
topic.addFeature(feature)
}else{if(child.tagName=="text"){var nodeText=this._deserializeNodeText(child);
topic.setText(nodeText)
}}}}}return topic
},_deserializeTextAttr:function(domElem){var value=domElem.getAttribute("text");
if(!$defined(value)){var children=domElem.childNodes;
for(var i=0;
i<children.length;
i++){var child=children[i];
if(child.nodeType==Node.CDATA_SECTION_NODE){value=child.nodeValue
}}}else{value=unescape(value);
if(value==""){value=" "
}}return value
},_deserializeNodeText:function(domElem){var children=domElem.childNodes;
var value=null;
for(var i=0;
i<children.length;
i++){var child=children[i];
if(child.nodeType==Node.CDATA_SECTION_NODE){value=child.nodeValue
}}return value
},_deserializeRelationship:function(domElement,mindmap){var srcId=domElement.getAttribute("srcTopicId");
var destId=domElement.getAttribute("destTopicId");
var lineType=domElement.getAttribute("lineType");
var srcCtrlPoint=domElement.getAttribute("srcCtrlPoint");
var destCtrlPoint=domElement.getAttribute("destCtrlPoint");
var endArrow=domElement.getAttribute("endArrow");
var startArrow=domElement.getAttribute("startArrow");
if(srcId==destId){return null
}if(mindmap.findNodeById(srcId)==null||mindmap.findNodeById(destId)==null){return null
}var model=mindmap.createRelationship(srcId,destId);
model.setLineType(lineType);
if($defined(srcCtrlPoint)&&srcCtrlPoint!=""){model.setSrcCtrlPoint(core.Point.fromString(srcCtrlPoint))
}if($defined(destCtrlPoint)&&destCtrlPoint!=""){model.setDestCtrlPoint(core.Point.fromString(destCtrlPoint))
}model.setEndArrow("false");
model.setStartArrow("true");
return model
}});
mindplot.persistence.XMLSerializer_Pela.MAP_ROOT_NODE="map";mindplot.persistence.XMLSerializer_Tango=new Class({Extends:mindplot.persistence.XMLSerializer_Pela});mindplot.persistence.Pela2TangoMigrator=new Class({initialize:function(pelaSerializer){this._pelaSerializer=pelaSerializer;
this._tangoSerializer=new mindplot.persistence.XMLSerializer_Tango()
},toXML:function(mindmap){return this._tangoSerializer.toXML(mindmap)
},loadFromDom:function(dom,mapId){$assert($defined(mapId),"mapId can not be null");
var mindmap=this._pelaSerializer.loadFromDom(dom,mapId);
mindmap.setVersion(mindplot.persistence.ModelCodeName.TANGO);
this._fixOrder(mindmap);
this._fixPosition(mindmap);
return mindmap
},_fixOrder:function(mindmap){var centralNode=mindmap.getBranches()[0];
var children=centralNode.getChildren();
var leftNodes=[];
var rightNodes=[];
for(var i=0;
i<children.length;
i++){var child=children[i];
var position=child.getPosition();
if(position.x<0){leftNodes.push(child)
}else{rightNodes.push(child)
}}rightNodes.sort(function(a,b){return a.getOrder()>b.getOrder()
});
leftNodes.sort(function(a,b){return a.getOrder()>b.getOrder()
});
for(i=0;
i<rightNodes.length;
i++){rightNodes[i].setOrder(i*2)
}for(i=0;
i<leftNodes.length;
i++){leftNodes[i].setOrder(i*2+1)
}},_fixPosition:function(mindmap){var centralNode=mindmap.getBranches()[0];
var children=centralNode.getChildren();
for(var i=0;
i<children.length;
i++){var child=children[i];
var position=child.getPosition();
this._fixNodePosition(child,position)
}},_fixNodePosition:function(node,parentPosition){var position=node.getPosition();
if(!position){position={x:parentPosition.x+30,y:parentPosition.y};
node.setPosition(position.x,position.y)
}var children=node.getChildren();
for(var i=0;
i<children.length;
i++){var child=children[i];
this._fixNodePosition(child,position)
}}});mindplot.persistence.XMLSerializer_Beta=new Class({toXML:function(mindmap){$assert(mindmap,"Can not save a null mindmap");
var document=core.Utils.createDocument();
var mapElem=document.createElement("map");
var name=mindmap.getId();
if($defined(name)){mapElem.setAttribute("name",name)
}document.appendChild(mapElem);
var topics=mindmap.getBranches();
for(var i=0;
i<topics.length;
i++){var topic=topics[i];
var topicDom=this._topicToXML(document,topic);
mapElem.appendChild(topicDom)
}return document
},_topicToXML:function(document,topic){var parentTopic=document.createElement("topic");
if(topic.getType()==mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE){parentTopic.setAttribute("central",true)
}else{var parent=topic.getParent();
if(parent==null||parent.getType()==mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE){var pos=topic.getPosition();
parentTopic.setAttribute("position",pos.x+","+pos.y)
}else{var order=topic.getOrder();
parentTopic.setAttribute("order",order)
}}var text=topic.getText();
if($defined(text)){parentTopic.setAttribute("text",text)
}var shape=topic.getShapeType();
if($defined(shape)){parentTopic.setAttribute("shape",shape)
}if(topic.areChildrenShrunken()){parentTopic.setAttribute("shrink",true)
}var font="";
var fontFamily=topic.getFontFamily();
font+=(fontFamily?fontFamily:"")+";";
var fontSize=topic.getFontSize();
font+=(fontSize?fontSize:"")+";";
var fontColor=topic.getFontColor();
font+=(fontColor?fontColor:"")+";";
var fontWeight=topic.getFontWeight();
font+=(fontWeight?fontWeight:"")+";";
var fontStyle=topic.getFontStyle();
font+=(fontStyle?fontStyle:"")+";";
if($defined(fontFamily)||$defined(fontSize)||$defined(fontColor)||$defined(fontWeight)||$defined(fontStyle)){parentTopic.setAttribute("fontStyle",font)
}var bgColor=topic.getBackgroundColor();
if($defined(bgColor)){parentTopic.setAttribute("bgColor",bgColor)
}var brColor=topic.getBorderColor();
if($defined(brColor)){parentTopic.setAttribute("brColor",brColor)
}var i;
var icons=topic.getIcons();
for(i=0;
i<icons.length;
i++){var icon=icons[i];
var iconDom=this._iconToXML(document,icon);
parentTopic.appendChild(iconDom)
}var links=topic.getLinks();
for(i=0;
i<links.length;
i++){var link=links[i];
var linkDom=this._linkToXML(document,link);
parentTopic.appendChild(linkDom)
}var notes=topic.getNotes();
for(i=0;
i<notes.length;
i++){var note=notes[i];
var noteDom=this._noteToXML(document,note);
parentTopic.appendChild(noteDom)
}var childTopics=topic.getChildren();
for(i=0;
i<childTopics.length;
i++){var childTopic=childTopics[i];
var childDom=this._topicToXML(document,childTopic);
parentTopic.appendChild(childDom)
}return parentTopic
},_iconToXML:function(document,icon){var iconDom=document.createElement("icon");
iconDom.setAttribute("id",icon.getIconType());
return iconDom
},_linkToXML:function(document,link){var linkDom=document.createElement("link");
linkDom.setAttribute("url",link.getUrl());
return linkDom
},_noteToXML:function(document,note){var noteDom=document.createElement("note");
noteDom.setAttribute("text",note.getText());
return noteDom
},loadFromDom:function(dom,mapId){$assert(dom,"Dom can not be null");
$assert(mapId,"mapId can not be null");
var documentElement=dom.documentElement;
$assert(documentElement.nodeName!="parsererror","Error while parsing: '"+documentElement.childNodes[0].nodeValue);
$assert(documentElement.tagName==mindplot.persistence.XMLSerializer_Beta.MAP_ROOT_NODE,"This seem not to be a map document. Root Tag: '"+documentElement.tagName);
var version=documentElement.getAttribute("version");
version=!$defined(version)?mindplot.persistence.ModelCodeName.BETA:version;
var mindmap=new mindplot.model.Mindmap(mapId,version);
var children=documentElement.childNodes;
for(var i=0;
i<children.length;
i++){var child=children[i];
if(child.nodeType==1){var topic=this._deserializeNode(child,mindmap);
mindmap.addBranch(topic)
}}mindmap.setId(mapId);
return mindmap
},_deserializeNode:function(domElem,mindmap){var type=(domElem.getAttribute("central")!=null)?mindplot.model.INodeModel.CENTRAL_TOPIC_TYPE:mindplot.model.INodeModel.MAIN_TOPIC_TYPE;
var topic=mindmap.createNode(type);
var text=domElem.getAttribute("text");
if($defined(text)){topic.setText(text)
}var order=domElem.getAttribute("order");
if($defined(order)){topic.setOrder(parseInt(order))
}var shape=domElem.getAttribute("shape");
if($defined(shape)){topic.setShapeType(shape)
}var isShrink=domElem.getAttribute("shrink");
if($defined(isShrink)){topic.setChildrenShrunken(isShrink)
}var fontStyle=domElem.getAttribute("fontStyle");
if($defined(fontStyle)){var font=fontStyle.split(";");
if(font[0]){topic.setFontFamily(font[0])
}if(font[1]){topic.setFontSize(font[1])
}if(font[2]){topic.setFontColor(font[2])
}if(font[3]){topic.setFontWeight(font[3])
}if(font[4]){topic.setFontStyle(font[4])
}}var bgColor=domElem.getAttribute("bgColor");
if($defined(bgColor)){topic.setBackgroundColor(bgColor)
}var borderColor=domElem.getAttribute("brColor");
if($defined(borderColor)){topic.setBorderColor(borderColor)
}var position=domElem.getAttribute("position");
if($defined(position)){var pos=position.split(",");
topic.setPosition(pos[0],pos[1])
}var children=domElem.childNodes;
for(var i=0;
i<children.length;
i++){var child=children[i];
if(child.nodeType==1){$assert(child.tagName=="topic"||child.tagName=="icon"||child.tagName=="link"||child.tagName=="note","Illegal node type:"+child.tagName);
if(child.tagName=="topic"){var childTopic=this._deserializeNode(child,mindmap);
childTopic.connectTo(topic)
}else{if(child.tagName=="icon"){var icon=this._deserializeIcon(child,topic);
topic.addFeature(icon)
}else{if(child.tagName=="link"){var link=this._deserializeLink(child,topic);
topic.addFeature(link)
}else{if(child.tagName=="note"){var note=this._deserializeNote(child,topic);
topic.addFeature(note)
}}}}}}return topic
},_deserializeIcon:function(domElem){var icon=domElem.getAttribute("id");
icon=icon.replace("images/","icons/legacy/");
return mindplot.TopicFeature.createModel(mindplot.TopicFeature.Icon.id,{id:icon})
},_deserializeLink:function(domElem){return mindplot.TopicFeature.createModel(mindplot.TopicFeature.Link.id,{url:domElem.getAttribute("url")})
},_deserializeNote:function(domElem){var text=domElem.getAttribute("text");
return mindplot.TopicFeature.createModel(mindplot.TopicFeature.Note.id,{text:text==null?" ":text})
}});
mindplot.persistence.XMLSerializer_Beta.MAP_ROOT_NODE="map";mindplot.persistence.Beta2PelaMigrator=new Class({initialize:function(betaSerializer){this._betaSerializer=betaSerializer;
this._pelaSerializer=new mindplot.persistence.XMLSerializer_Pela()
},toXML:function(mindmap){return this._pelaSerializer.toXML(mindmap)
},loadFromDom:function(dom,mapId){$assert($defined(mapId),"mapId can not be null");
var mindmap=this._betaSerializer.loadFromDom(dom,mapId);
mindmap.setVersion(mindplot.persistence.ModelCodeName.PELA);
var branches=mindmap.getBranches();
branches.each(function(model){this._fixPosition(model)
}.bind(this));
return mindmap
},_fixPosition:function(parentModel){var parentPos=parentModel.getPosition();
var isRight=parentPos.x>0;
parentModel.getChildren().each(function(child){if(!child.getPosition()){child.setPosition(parentPos.x+(50*isRight?1:-1),parentPos.y)
}this._fixPosition(child)
}.bind(this))
}});mindplot.persistence.XMLSerializerFactory={};
mindplot.persistence.XMLSerializerFactory.getSerializerFromMindmap=function(mindmap){return mindplot.persistence.XMLSerializerFactory.getSerializer(mindmap.getVersion())
};
mindplot.persistence.XMLSerializerFactory.getSerializerFromDocument=function(domDocument){var rootElem=domDocument.documentElement;
return mindplot.persistence.XMLSerializerFactory.getSerializer(rootElem.getAttribute("version"))
};
mindplot.persistence.XMLSerializerFactory.getSerializer=function(version){if(!$defined(version)){version=mindplot.persistence.ModelCodeName.BETA
}var codeNames=mindplot.persistence.XMLSerializerFactory._codeNames;
var found=false;
var serializer=null;
for(var i=0;
i<codeNames.length;
i++){if(!found){found=codeNames[i].codeName==version;
if(found){serializer=new (codeNames[i].serializer)()
}}else{var migrator=codeNames[i].migrator;
serializer=new migrator(serializer)
}}return serializer
};
mindplot.persistence.XMLSerializerFactory._codeNames=[{codeName:mindplot.persistence.ModelCodeName.BETA,serializer:mindplot.persistence.XMLSerializer_Beta,migrator:function(){}},{codeName:mindplot.persistence.ModelCodeName.PELA,serializer:mindplot.persistence.XMLSerializer_Pela,migrator:mindplot.persistence.Beta2PelaMigrator},{codeName:mindplot.persistence.ModelCodeName.TANGO,serializer:mindplot.persistence.XMLSerializer_Tango,migrator:mindplot.persistence.Pela2TangoMigrator}];mindplot.PersistenceManager=new Class({Static:{loadFromDom:function(mapId,mapDom){$assert(mapId,"mapId can not be null");
$assert(mapDom,"mapDom can not be null");
var serializer=mindplot.persistence.XMLSerializerFactory.getSerializerFromDocument(mapDom);
return serializer.loadFromDom(mapDom,mapId)
}},initialize:function(){},save:function(mindmap,editorProperties,saveHistory,events){$assert(mindmap,"mindmap can not be null");
$assert(editorProperties,"editorProperties can not be null");
var mapId=mindmap.getId();
$assert(mapId,"mapId can not be null");
var serializer=mindplot.persistence.XMLSerializerFactory.getSerializerFromMindmap(mindmap);
var domMap=serializer.toXML(mindmap);
var mapXml=core.Utils.innerXML(domMap);
var pref=JSON.encode(editorProperties);
try{this.saveMapXml(mapId,mapXml,pref,saveHistory,events)
}catch(e){console.log(e);
events.onError()
}},load:function(mapId){$assert(mapId,"mapId can not be null");
var domDocument=this.loadMapDom(mapId);
return mindplot.PersistenceManager.loadFromDom(mapId,domDocument)
},discardChanges:function(mapId){throw"Method must be implemented"
},loadMapDom:function(mapId){throw"Method must be implemented"
},saveMapXml:function(mapId,mapXml,pref,saveHistory,events){throw"Method must be implemented"
}});
mindplot.PersistenceManager.init=function(instance){mindplot.PersistenceManager._instance=instance
};
mindplot.PersistenceManager.getInstance=function(){return mindplot.PersistenceManager._instance
};mindplot.RESTPersistenceManager=new Class({Extends:mindplot.PersistenceManager,initialize:function(saveUrl,revertUrl){this.parent();
$assert(saveUrl,"saveUrl can not be null");
$assert(revertUrl,"revertUrl can not be null");
this.saveUrl=saveUrl;
this.revertUrl=revertUrl
},saveMapXml:function(mapId,mapXml,pref,saveHistory,events){var data={id:mapId,xml:mapXml,properties:pref};
var request=new Request({url:this.saveUrl.replace("{id}",mapId)+"?minor="+!saveHistory,method:"put",onSuccess:function(responseText,responseXML){events.onSuccess()
},onException:function(headerName,value){events.onError()
},onFailure:function(xhr){var responseText=xhr.responseText;
var error=null;
var contentType=this.getHeader("Content-Type");
if(contentType!=null&&contentType.indexOf("application/json")!=-1){try{error=JSON.decode(responseText)
}catch(e){throw"Unexpected error saving. Error response is not json object:"+responseText
}}events.onError(error)
},headers:{"Content-Type":"application/json","Accept":"application/json"},emulation:false,urlEncoded:false});
request.put(JSON.encode(data))
},discardChanges:function(mapId){var request=new Request({url:this.revertUrl.replace("{id}",mapId),async:false,method:"post",onSuccess:function(){},onException:function(){},onFailure:function(){},headers:{"Content-Type":"application/json","Accept":"application/json"},emulation:false,urlEncoded:false});
request.post()
}});mindplot.LocalStorageManager=new Class({Extends:mindplot.PersistenceManager,initialize:function(){this.parent()
},saveMapXml:function(mapId,mapXml,pref,saveHistory,events){localStorage.setItem(mapId+"-xml",mapXml);
events.onSuccess()
},discardChanges:function(mapId){localStorage.removeItem(mapId+"-xml")
},loadMapDom:function(mapId){var xml=localStorage.getItem(mapId+"-xml");
if(xml==null){var xmlRequest=new Request({url:"samples/"+mapId+".xml",method:"get",async:false,onSuccess:function(responseText){xml=responseText
}});
xmlRequest.send();
if(xml==null){throw new Error("Map could not be loaded")
}}var parser=new DOMParser();
return parser.parseFromString(xml,"text/xml")
}});mindplot.EditorProperties=new Class({initialize:function(){this._zoom=0;
this._position=0
},setZoom:function(zoom){this._zoom=zoom
},getZoom:function(){return this._zoom
},asProperties:function(){return"zoom="+this._zoom+"\n"
}});mindplot.IconGroup=new Class({initialize:function(topicId,iconSize){$assert($defined(topicId),"topicId can not be null");
$assert($defined(iconSize),"iconSize can not be null");
this._icons=[];
this._group=new web2d.Group({width:0,height:iconSize,x:0,y:0,coordSizeWidth:0,coordSizeHeight:100});
this._removeTip=new mindplot.IconGroup.RemoveTip(this._group,topicId);
this.seIconSize(iconSize,iconSize);
this._registerListeners()
},setPosition:function(x,y){this._group.setPosition(x,y)
},getPosition:function(){return this._group.getPosition()
},getNativeElement:function(){return this._group
},getSize:function(){return this._group.getSize()
},seIconSize:function(width,height){this._iconSize={width:width,height:height};
this._resize(this._icons.length)
},addIcon:function(icon,remove){$defined(icon,"icon is not defined");
icon.setGroup(this);
this._icons.push(icon);
this._resize(this._icons.length);
this._positionIcon(icon,this._icons.length-1);
var imageShape=icon.getImage();
this._group.appendChild(imageShape);
if(remove){this._removeTip.decorate(this._topicId,icon)
}},_findIconFromModel:function(iconModel){var result=null;
this._icons.each(function(icon){var elModel=icon.getModel();
if(elModel.getId()==iconModel.getId()){result=icon
}},this);
if(result==null){throw new Error("Icon can no be found:"+iconModel.getId()+", Icons:"+this._icons)
}return result
},removeIconByModel:function(featureModel){$assert(featureModel,"featureModel can not be null");
var icon=this._findIconFromModel(featureModel);
this._removeIcon(icon)
},_removeIcon:function(icon){$assert(icon,"icon can not be null");
this._removeTip.close(0);
this._group.removeChild(icon.getImage());
this._icons.erase(icon);
this._resize(this._icons.length);
this._icons.each(function(elem,i){this._positionIcon(elem,i)
}.bind(this))
},moveToFront:function(){this._group.moveToFront()
},_registerListeners:function(){this._group.addEvent("click",function(event){event.stopPropagation()
});
this._group.addEvent("dblclick",function(event){event.stopPropagation()
})
},_resize:function(iconsLength){this._group.setSize(iconsLength*this._iconSize.width,this._iconSize.height);
var iconSize=mindplot.Icon.SIZE+(mindplot.IconGroup.ICON_PADDING*2);
this._group.setCoordSize(iconsLength*iconSize,iconSize)
},_positionIcon:function(icon,order){var iconSize=mindplot.Icon.SIZE+(mindplot.IconGroup.ICON_PADDING*2);
icon.getImage().setPosition(iconSize*order+mindplot.IconGroup.ICON_PADDING,mindplot.IconGroup.ICON_PADDING)
}});
mindplot.IconGroup.ICON_PADDING=5;
mindplot.IconGroup.RemoveTip=new Class({initialize:function(container){$assert(container,"group can not be null");
this._fadeElem=container
},show:function(topicId,icon){$assert(icon,"icon can not be null");
if(this._activeIcon!=icon){if(this._activeIcon){this.close(0)
}var pos=icon.getPosition();
var widget=this._buildWeb2d();
widget.addEvent("click",function(){icon.remove()
});
widget.addEvent("mouseover",function(){this.show(topicId,icon)
}.bind(this));
widget.addEvent("mouseout",function(){this.hide()
}.bind(this));
widget.setPosition(pos.x+80,pos.y-50);
this._fadeElem.appendChild(widget);
this._activeIcon=icon;
this._widget=widget
}else{clearTimeout(this._closeTimeoutId)
}},hide:function(){this.close(200)
},close:function(delay){if(this._closeTimeoutId){clearTimeout(this._closeTimeoutId)
}if(this._activeIcon){var widget=this._widget;
var close=function(){this._activeIcon=null;
this._fadeElem.removeChild(widget);
this._widget=null;
this._closeTimeoutId=null
}.bind(this);
if(!$defined(delay)||delay==0){close()
}else{this._closeTimeoutId=close.delay(delay)
}}},_buildWeb2d:function(){var result=new web2d.Group({width:10,height:10,x:0,y:0,coordSizeWidth:10,coordSizeHeight:10});
var outerRect=new web2d.Rect(0,{x:0,y:0,width:10,height:10,stroke:"0",fillColor:"black"});
result.appendChild(outerRect);
outerRect.setCursor("pointer");
var innerRect=new web2d.Rect(0,{x:1,y:1,width:8,height:8,stroke:"1 solid white",fillColor:"gray"});
result.appendChild(innerRect);
var line=new web2d.Line({stroke:"1 solid white"});
line.setFrom(1,1);
line.setTo(9,9);
result.appendChild(line);
var line2=new web2d.Line({stroke:"1 solid white"});
line2.setFrom(1,9);
line2.setTo(9,1);
result.appendChild(line2);
result.addEvent("mouseover",function(){innerRect.setFill("#CC0033")
});
result.addEvent("mouseout",function(){innerRect.setFill("gray")
});
result.setSize(50,50);
return result
},decorate:function(topicId,icon){if(!icon.__remove){icon.addEvent("mouseover",function(){this.show(topicId,icon)
}.bind(this));
icon.addEvent("mouseout",function(){this.hide()
}.bind(this));
icon.__remove=true
}}});mindplot.Icon=new Class({initialize:function(url){$assert(url,"topic can not be null");
this._image=new web2d.Image();
this._image.setHref(url);
this._image.setSize(mindplot.Icon.SIZE,mindplot.Icon.SIZE)
},getImage:function(){return this._image
},setGroup:function(group){this._group=group
},getGroup:function(){return this._group
},getSize:function(){return this._image.getSize()
},getPosition:function(){return this._image.getPosition()
},addEvent:function(type,fnc){this._image.addEvent(type,fnc)
},remove:function(){throw"Unsupported operation"
}});
mindplot.Icon.SIZE=90;mindplot.LinkIcon=new Class({Extends:mindplot.Icon,initialize:function(topic,linkModel,readOnly){$assert(topic,"topic can not be null");
$assert(linkModel,"linkModel can not be null");
this.parent(mindplot.LinkIcon.IMAGE_URL);
this._linksModel=linkModel;
this._topic=topic;
this._readOnly=readOnly;
this._registerEvents()
},_registerEvents:function(){this._image.setCursor("pointer");
if(!this._readOnly){this.addEvent("click",function(event){this._topic.showLinkEditor();
event.stopPropagation()
}.bind(this))
}this._tip=new mindplot.widget.LinkIconTooltip(this)
},getModel:function(){return this._linksModel
}});
mindplot.LinkIcon.IMAGE_URL="images/links.png";mindplot.NoteIcon=new Class({Extends:mindplot.Icon,initialize:function(topic,noteModel,readOnly){$assert(topic,"topic can not be null");
this.parent(mindplot.NoteIcon.IMAGE_URL);
this._linksModel=noteModel;
this._topic=topic;
this._readOnly=readOnly;
this._registerEvents()
},_registerEvents:function(){this._image.setCursor("pointer");
if(!this._readOnly){this.addEvent("click",function(event){this._topic.showNoteEditor();
event.stopPropagation()
}.bind(this))
}this._tip=new mindplot.widget.FloatingTip(this.getImage()._peer._native,{content:function(){var result=new Element("div");
result.setStyles({padding:"5px"});
var title=new Element("div",{text:$msg("NOTE")});
title.setStyles({"font-weight":"bold",color:"black","padding-bottom":"5px",width:"100px"});
title.inject(result);
var text=new Element("div",{text:this._linksModel.getText()});
text.setStyles({"white-space":"pre-wrap","word-wrap":"break-word"});
text.inject(result);
return result
}.bind(this),html:true,position:"bottom",arrowOffset:10,center:true,arrowSize:15,offset:{x:10,y:20},className:"notesTip"})
},getModel:function(){return this._linksModel
}});
mindplot.NoteIcon.IMAGE_URL="images/notes.png";mindplot.ActionIcon=new Class({Extends:mindplot.Icon,initialize:function(topic,url){this.parent(url);
this._node=topic
},getNode:function(){return this._node
},setPosition:function(x,y){var size=this.getSize();
this.getImage().setPosition(x-size.width/2,y-size.height/2)
},addEvent:function(event,fn){this.getImage().addEvent(event,fn)
},addToGroup:function(group){group.appendChild(this.getImage())
},setVisibility:function(visible){this.getImage().setVisibility(visible)
},isVisible:function(){return this.getImage().isVisible()
},setCursor:function(cursor){return this.getImage().setCursor(cursor)
},moveToBack:function(cursor){return this.getImage().moveToBack(cursor)
},moveToFront:function(cursor){return this.getImage().moveToFront(cursor)
}});mindplot.ImageIcon=new Class({Extends:mindplot.Icon,initialize:function(topic,iconModel,readOnly){$assert(iconModel,"iconModel can not be null");
$assert(topic,"topic can not be null");
this._topicId=topic.getId();
this._featureModel=iconModel;
var iconType=iconModel.getIconType();
var imgUrl=this._getImageUrl(iconType);
this.parent(imgUrl);
if(!readOnly){var image=this.getImage();
image.addEvent("click",function(){var iconType=iconModel.getIconType();
var newIconType=this._getNextFamilyIconId(iconType);
iconModel.setIconType(newIconType);
var imgUrl=this._getImageUrl(newIconType);
this._image.setHref(imgUrl)
}.bind(this));
this._image.setCursor("pointer")
}},_getImageUrl:function(iconId){return"icons/"+iconId+".png"
},getModel:function(){return this._featureModel
},_getNextFamilyIconId:function(iconId){var familyIcons=this._getFamilyIcons(iconId);
$assert(familyIcons!=null,"Family Icon not found!");
var result=null;
for(var i=0;
i<familyIcons.length&&result==null;
i++){if(familyIcons[i]==iconId){if(i==(familyIcons.length-1)){result=familyIcons[0]
}else{result=familyIcons[i+1]
}break
}}return result
},_getFamilyIcons:function(iconId){$assert(iconId!=null,"id must not be null");
$assert(iconId.indexOf("_")!=-1,"Invalid icon id (it must contain '_')");
var result=null;
for(var i=0;
i<mindplot.ImageIcon.prototype.ICON_FAMILIES.length;
i++){var family=mindplot.ImageIcon.prototype.ICON_FAMILIES[i];
var iconFamilyId=iconId.substr(0,iconId.indexOf("_"));
if(family.id==iconFamilyId){result=family.icons;
break
}}return result
},remove:function(){var actionDispatcher=mindplot.ActionDispatcher.getInstance();
var featureId=this._featureModel.getId();
var topicId=this._topicId;
actionDispatcher.removeFeatureFromTopic(topicId,featureId)
}});
mindplot.ImageIcon.prototype.ICON_FAMILIES=[{"id":"face","icons":["face_plain","face_sad","face_crying","face_smile","face_surprise","face_wink"]},{"id":"funy","icons":["funy_angel","funy_devilish","funy_glasses","funy_grin","funy_kiss","funy_monkey"]},{"id":"conn","icons":["conn_connect","conn_disconnect"]},{"id":"sport","icons":["sport_basketball","sport_football","sport_golf","sport_raquet","sport_shuttlecock","sport_soccer","sport_tennis"]},{"id":"bulb","icons":["bulb_light_on","bulb_light_off"]},{"id":"thumb","icons":["thumb_thumb_up","thumb_thumb_down"]},{"id":"tick","icons":["tick_tick","tick_cross"]},{"id":"onoff","icons":["onoff_clock","onoff_clock_red","onoff_add","onoff_delete","onoff_status_offline","onoff_status_online"]},{"id":"money","icons":["money_money","money_dollar","money_euro","money_pound","money_yen","money_coins","money_ruby"]},{"id":"time","icons":["time_calendar","time_clock","time_hourglass"]},{"id":"chart","icons":["chart_bar","chart_line","chart_curve","chart_pie","chart_organisation"]},{"id":"sign","icons":["sign_warning","sign_info","sign_stop","sign_help","sign_cancel"]},{"id":"hard","icons":["hard_cd","hard_computer","hard_controller","hard_driver_disk","hard_ipod","hard_keyboard","hard_mouse","hard_printer"]},{"id":"soft","icons":["soft_bug","soft_cursor","soft_database_table","soft_database","soft_feed","soft_folder_explore","soft_rss","soft_penguin"]},{"id":"arrow","icons":["arrow_up","arrow_down","arrow_left","arrow_right"]},{"id":"arrowc","icons":["arrowc_rotate_anticlockwise","arrowc_rotate_clockwise","arrowc_turn_left","arrowc_turn_right"]},{"id":"people","icons":["people_group","people_male1","people_male2","people_female1","people_female2"]},{"id":"mail","icons":["mail_envelop","mail_mailbox","mail_edit","mail_list"]},{"id":"flag","icons":["flag_blue","flag_green","flag_orange","flag_pink","flag_purple","flag_yellow"]},{"id":"bullet","icons":["bullet_black","bullet_blue","bullet_green","bullet_orange","bullet_red","bullet_pink","bullet_purple"]},{"id":"tag","icons":["tag_blue","tag_green","tag_orange","tag_red","tag_pink","tag_yellow"]},{"id":"object","icons":["object_bell","object_clanbomber","object_key","object_pencil","object_phone","object_magnifier","object_clip","object_music","object_star","object_wizard","object_house","object_cake","object_camera","object_palette","object_rainbow"]},{"id":"weather","icons":["weather_clear-night","weather_clear","weather_few-clouds-night","weather_few-clouds","weather_overcast","weather_severe-alert","weather_showers-scattered","weather_showers","weather_snow","weather_storm"]}];mindplot.model.FeatureModel=new Class({Static:{_nextUUID:function(){if(!$defined(mindplot.model.FeatureModel._uuid)){mindplot.model.FeatureModel._uuid=0
}mindplot.model.FeatureModel._uuid=mindplot.model.FeatureModel._uuid+1;
return mindplot.model.FeatureModel._uuid
}},initialize:function(type){$assert(type,"type can not be null");
this._id=mindplot.model.FeatureModel._nextUUID();
this._type=type;
this._attributes={};
this["is"+type.camelCase()+"Model"]=function(){return true
}},getAttributes:function(){return Object.clone(this._attributes)
},setAttributes:function(attributes){for(key in attributes){this["set"+key.capitalize()](attributes[key])
}},setAttribute:function(key,value){$assert(key,"key id can not be null");
this._attributes[key]=value
},getAttribute:function(key){$assert(key,"key id can not be null");
return this._attributes[key]
},getId:function(){return this._id
},setId:function(id){this._id=id
},getType:function(){return this._type
}});mindplot.model.IconModel=new Class({Extends:mindplot.model.FeatureModel,initialize:function(attributes){this.parent(mindplot.model.IconModel.FEATURE_TYPE);
this.setIconType(attributes.id)
},getIconType:function(){return this.getAttribute("id")
},setIconType:function(iconType){$assert(iconType,"iconType id can not be null");
this.setAttribute("id",iconType)
}});
mindplot.model.IconModel.FEATURE_TYPE="icon";mindplot.model.LinkModel=new Class({Extends:mindplot.model.FeatureModel,initialize:function(attributes){this.parent(mindplot.model.LinkModel.FEATURE_TYPE);
this.setUrl(attributes.url)
},getUrl:function(){return this.getAttribute("url")
},setUrl:function(url){$assert(url,"url can not be null");
var fixedUrl=this._fixUrl(url);
this.setAttribute("url",fixedUrl);
var type=fixedUrl.contains("mailto:")?"mail":"url";
this.setAttribute("urlType",type)
},_fixUrl:function(url){var result=url;
if(!result.contains("http://")&&!result.contains("https://")&&!result.contains("mailto://")){result="http://"+result
}return result
},setUrlType:function(urlType){$assert(urlType,"urlType can not be null");
this.setAttribute("urlType",urlType)
}});
mindplot.model.LinkModel.FEATURE_TYPE="link";mindplot.model.NoteModel=new Class({Extends:mindplot.model.FeatureModel,initialize:function(attributes){this.parent(mindplot.model.NoteModel.FEATURE_TYPE);
var noteText=attributes.text?attributes.text:" ";
this.setText(noteText)
},getText:function(){return this.getAttribute("text")
},setText:function(text){$assert(text,"text can not be null");
this.setAttribute("text",text)
}});
mindplot.model.NoteModel.FEATURE_TYPE="note";mindplot.Command=new Class({initialize:function(){this._id=mindplot.Command._nextUUID()
},execute:function(commandContext){throw"execute must be implemented."
},undoExecute:function(commandContext){throw"undo must be implemented."
},getId:function(){return this._id
}});
mindplot.Command._nextUUID=function(){if(!$defined(mindplot.Command._uuid)){mindplot.Command._uuid=1
}mindplot.Command._uuid=mindplot.Command._uuid+1;
return mindplot.Command._uuid
};mindplot.DesignerActionRunner=new Class({initialize:function(commandContext,notifier){$assert(commandContext,"commandContext can not be null");
this._undoManager=new mindplot.DesignerUndoManager();
this._context=commandContext;
this._notifier=notifier
},execute:function(command){$assert(command,"command can not be null");
command.execute(this._context);
this._undoManager.enqueue(command);
this.fireChangeEvent();
mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.DoLayout)
},undo:function(){this._undoManager.execUndo(this._context);
this.fireChangeEvent();
mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.DoLayout)
},redo:function(){this._undoManager.execRedo(this._context);
this.fireChangeEvent();
mindplot.EventBus.instance.fireEvent(mindplot.EventBus.events.DoLayout)
},fireChangeEvent:function(){var event=this._undoManager.buildEvent();
this._notifier.fireEvent("modelUpdate",event)
}});mindplot.DesignerUndoManager=new Class({initialize:function(fireChange){this._undoQueue=[];
this._redoQueue=[];
this._baseId=0
},enqueue:function(command){$assert(command,"Command can  not be null");
var length=this._undoQueue.length;
if(command.discardDuplicated&&length>0){var lastItem=this._undoQueue[length-1];
if(lastItem.discardDuplicated!=command.discardDuplicated){this._undoQueue.push(command)
}}else{this._undoQueue.push(command)
}this._redoQueue=[]
},execUndo:function(commandContext){if(this._undoQueue.length>0){var command=this._undoQueue.pop();
this._redoQueue.push(command);
command.undoExecute(commandContext)
}},execRedo:function(commandContext){if(this._redoQueue.length>0){var command=this._redoQueue.pop();
this._undoQueue.push(command);
command.execute(commandContext)
}},buildEvent:function(){return{undoSteps:this._undoQueue.length,redoSteps:this._redoQueue.length}
},markAsChangeBase:function(){var undoLength=this._undoQueue.length;
if(undoLength>0){var command=this._undoQueue[undoLength-1];
this._baseId=command.getId()
}else{this._baseId=0
}},hasBeenChanged:function(){var result=true;
var undoLength=this._undoQueue.length;
if(undoLength==0&&this._baseId==0){result=false
}else{if(undoLength>0){var command=this._undoQueue[undoLength-1];
result=(this._baseId!=command.getId())
}}return result
}});mindplot.ControlPoint=new Class({initialize:function(){var control1=new web2d.Elipse({width:6,height:6,stroke:"1 solid #6589de",fillColor:"gray",visibility:false});
control1.setCursor("pointer");
var control2=new web2d.Elipse({width:6,height:6,stroke:"1 solid #6589de",fillColor:"gray",visibility:false});
control2.setCursor("pointer");
this._controlPointsController=[control1,control2];
this._controlLines=[new web2d.Line({strokeColor:"#6589de",strokeWidth:1,opacity:0.3}),new web2d.Line({strokeColor:"#6589de",strokeWidth:1,opacity:0.3})];
this._isBinded=false;
this._controlPointsController[0].addEvent("mousedown",function(event){(this._mouseDown.bind(this))(event,mindplot.ControlPoint.FROM)
}.bind(this));
this._controlPointsController[0].addEvent("click",function(event){(this._mouseClick.bind(this))(event)
}.bind(this));
this._controlPointsController[0].addEvent("dblclick",function(event){(this._mouseClick.bind(this))(event)
}.bind(this));
this._controlPointsController[1].addEvent("mousedown",function(event){(this._mouseDown.bind(this))(event,mindplot.ControlPoint.TO)
}.bind(this));
this._controlPointsController[1].addEvent("click",function(event){(this._mouseClick.bind(this))(event)
}.bind(this));
this._controlPointsController[1].addEvent("dblclick",function(event){(this._mouseClick.bind(this))(event)
}.bind(this))
},setSide:function(side){this._side=side
},setLine:function(line){if($defined(this._line)){this._removeLine()
}this._line=line;
this._createControlPoint();
this._endPoint=[];
this._orignalCtrlPoint=[];
this._orignalCtrlPoint[0]=this._controls[0].clone();
this._orignalCtrlPoint[1]=this._controls[1].clone();
this._endPoint[0]=this._line.getLine().getFrom().clone();
this._endPoint[1]=this._line.getLine().getTo().clone()
},redraw:function(){if($defined(this._line)){this._createControlPoint()
}},_createControlPoint:function(){this._controls=this._line.getLine().getControlPoints();
var pos=this._line.getLine().getFrom();
this._controlPointsController[0].setPosition(this._controls[mindplot.ControlPoint.FROM].x+pos.x,this._controls[mindplot.ControlPoint.FROM].y+pos.y-3);
this._controlLines[0].setFrom(pos.x,pos.y);
this._controlLines[0].setTo(this._controls[mindplot.ControlPoint.FROM].x+pos.x+3,this._controls[mindplot.ControlPoint.FROM].y+pos.y);
pos=this._line.getLine().getTo();
this._controlLines[1].setFrom(pos.x,pos.y);
this._controlLines[1].setTo(this._controls[mindplot.ControlPoint.TO].x+pos.x+3,this._controls[mindplot.ControlPoint.TO].y+pos.y);
this._controlPointsController[1].setPosition(this._controls[mindplot.ControlPoint.TO].x+pos.x,this._controls[mindplot.ControlPoint.TO].y+pos.y-3)
},_removeLine:function(){},_mouseDown:function(event,point){if(!this._isBinded){this._isBinded=true;
this._mouseMoveFunction=function(event){(this._mouseMoveEvent.bind(this))(event,point)
}.bind(this);
this._workspace.getScreenManager().addEvent("mousemove",this._mouseMoveFunction);
this._mouseUpFunction=function(event){(this._mouseUp.bind(this))(event,point)
}.bind(this);
this._workspace.getScreenManager().addEvent("mouseup",this._mouseUpFunction)
}event.preventDefault();
event.stop();
return false
},_mouseMoveEvent:function(event,point){var screen=this._workspace.getScreenManager();
var pos=screen.getWorkspaceMousePosition(event);
var topic=null;
if(point==0){var cords=mindplot.util.Shape.calculateRelationShipPointCoordinates(this._line.getSourceTopic(),pos);
this._line.setFrom(cords.x,cords.y);
this._line.setSrcControlPoint(new core.Point(pos.x-cords.x,pos.y-cords.y))
}else{var cords=mindplot.util.Shape.calculateRelationShipPointCoordinates(this._line.getTargetTopic(),pos);
this._line.setTo(cords.x,cords.y);
this._line.setDestControlPoint(new core.Point(pos.x-cords.x,pos.y-cords.y))
}this._controls[point].x=(pos.x-cords.x);
this._controls[point].y=(pos.y-cords.y);
this._controlPointsController[point].setPosition(pos.x-5,pos.y-3);
this._controlLines[point].setFrom(cords.x,cords.y);
this._controlLines[point].setTo(pos.x-2,pos.y);
this._line.getLine().updateLine(point)
},_mouseUp:function(event,point){this._workspace.getScreenManager().removeEvent("mousemove",this._mouseMoveFunction);
this._workspace.getScreenManager().removeEvent("mouseup",this._mouseUpFunction);
var actionDispatcher=mindplot.ActionDispatcher.getInstance();
actionDispatcher.moveControlPoint(this,point);
this._isBinded=false
},_mouseClick:function(event){event.preventDefault();
event.stop();
return false
},setVisibility:function(visible){if(visible){this._controlLines[0].moveToFront();
this._controlLines[1].moveToFront();
this._controlPointsController[0].moveToFront();
this._controlPointsController[1].moveToFront()
}this._controlPointsController[0].setVisibility(visible);
this._controlPointsController[1].setVisibility(visible);
this._controlLines[0].setVisibility(visible);
this._controlLines[1].setVisibility(visible)
},addToWorkspace:function(workspace){this._workspace=workspace;
workspace.appendChild(this._controlPointsController[0]);
workspace.appendChild(this._controlPointsController[1]);
workspace.appendChild(this._controlLines[0]);
workspace.appendChild(this._controlLines[1])
},removeFromWorkspace:function(workspace){this._workspace=null;
workspace.removeChild(this._controlPointsController[0]);
workspace.removeChild(this._controlPointsController[1]);
workspace.removeChild(this._controlLines[0]);
workspace.removeChild(this._controlLines[1])
},getControlPoint:function(index){return this._controls[index]
},getOriginalEndPoint:function(index){return this._endPoint[index]
},getOriginalCtrlPoint:function(index){return this._orignalCtrlPoint[index]
}});
mindplot.ControlPoint.FROM=0;
mindplot.ControlPoint.TO=1;mindplot.EditorOptions={LayoutManager:"OriginalLayout",textEditor:"TextEditor"};mindplot.RelationshipPivot=new Class({initialize:function(workspace,designer){$assert(workspace,"workspace can not be null");
$assert(designer,"designer can not be null");
this._workspace=workspace;
this._designer=designer;
this._mouseMoveEvent=this._mouseMove.bind(this);
this._onClickEvent=this._cleanOnMouseClick.bind(this);
this._onTopicClick=this._connectOnFocus.bind(this)
},start:function(sourceTopic,targetPos){$assert(sourceTopic,"sourceTopic can not be null");
$assert(targetPos,"targetPos can not be null");
this.dispose();
this._sourceTopic=sourceTopic;
if(sourceTopic!=null){this._workspace.enableWorkspaceEvents(false);
var sourcePos=sourceTopic.getPosition();
var strokeColor=mindplot.Relationship.getStrokeColor();
this._pivot=new web2d.CurvedLine();
this._pivot.setStyle(web2d.CurvedLine.SIMPLE_LINE);
this._pivot.setFrom(sourcePos.x,sourcePos.y);
this._pivot.setTo(targetPos.x,targetPos.y);
this._pivot.setStroke(2,"solid",strokeColor);
this._pivot.setDashed(4,2);
this._startArrow=new web2d.Arrow();
this._startArrow.setStrokeColor(strokeColor);
this._startArrow.setStrokeWidth(2);
this._startArrow.setFrom(sourcePos.x,sourcePos.y);
this._workspace.appendChild(this._pivot);
this._workspace.appendChild(this._startArrow);
this._workspace.addEvent("mousemove",this._mouseMoveEvent);
this._workspace.addEvent("click",this._onClickEvent);
var model=this._designer.getModel();
var topics=model.getTopics();
topics.each(function(topic){topic.addEvent("ontfocus",this._onTopicClick)
}.bind(this))
}},dispose:function(){var workspace=this._workspace;
if(this._isActive()){workspace.removeEvent("mousemove",this._mouseMoveEvent);
workspace.removeEvent("click",this._onClickEvent);
var model=this._designer.getModel();
var topics=model.getTopics();
topics.each(function(topic){topic.removeEvent("ontfocus",this._onTopicClick)
}.bind(this));
workspace.removeChild(this._pivot);
workspace.removeChild(this._startArrow);
workspace.enableWorkspaceEvents(true);
this._sourceTopic=null;
this._pivot=null;
this._startArrow=null
}},_mouseMove:function(event){var screen=this._workspace.getScreenManager();
var pos=screen.getWorkspaceMousePosition(event);
var gapDistance=Math.sign(pos.x-this._sourceTopic.getPosition().x)*5;
this._pivot.setTo(pos.x-gapDistance,pos.y);
var controlPoints=this._pivot.getControlPoints();
this._startArrow.setFrom(pos.x-gapDistance,pos.y);
this._startArrow.setControlPoint(controlPoints[1]);
event.stopPropagation();
return false
},_cleanOnMouseClick:function(event){this.dispose();
event.stopPropagation()
},_connectOnFocus:function(targetTopic){var sourceTopic=this._sourceTopic;
var mindmap=this._designer.getMindmap();
if(targetTopic.getId()!=sourceTopic.getId()){var relModel=mindmap.createRelationship(targetTopic.getId(),sourceTopic.getId());
this._designer._actionDispatcher.addRelationship(relModel)
}this.dispose()
},_isActive:function(){return this._pivot!=null
}});mindplot.TopicFeature={Icon:{id:mindplot.model.IconModel.FEATURE_TYPE,model:mindplot.model.IconModel,icon:mindplot.ImageIcon},Link:{id:mindplot.model.LinkModel.FEATURE_TYPE,model:mindplot.model.LinkModel,icon:mindplot.LinkIcon},Note:{id:mindplot.model.NoteModel.FEATURE_TYPE,model:mindplot.model.NoteModel,icon:mindplot.NoteIcon},isSupported:function(id){return mindplot.TopicFeature._featuresMetadataById.some(function(elem){return elem.id==id
})
},createModel:function(type,attributes){$assert(type,"type can not be null");
$assert(attributes,"attributes can not be null");
var model=mindplot.TopicFeature._featuresMetadataById.filter(function(elem){return elem.id==type
})[0].model;
return new model(attributes)
},createIcon:function(topic,model,readOnly){$assert(topic,"topic can not be null");
$assert(model,"model can not be null");
var icon=mindplot.TopicFeature._featuresMetadataById.filter(function(elem){return elem.id==model.getType()
})[0].icon;
return new icon(topic,model,readOnly)
}};
mindplot.TopicFeature._featuresMetadataById=[mindplot.TopicFeature.Icon,mindplot.TopicFeature.Link,mindplot.TopicFeature.Note];mindplot.commands.GenericFunctionCommand=new Class({Extends:mindplot.Command,initialize:function(commandFunc,topicsIds,value){$assert(commandFunc,"commandFunc must be defined");
$assert($defined(topicsIds),"topicsIds must be defined");
this.parent();
this._value=value;
this._topicsId=topicsIds;
this._commandFunc=commandFunc;
this._oldValues=[]
},execute:function(commandContext){if(!this.applied){var topics=null;
try{topics=commandContext.findTopics(this._topicsId)
}catch(e){if(this._commandFunc.commandType!="changeTextToTopic"){throw e
}}if(topics!=null){topics.each(function(topic){var oldValue=this._commandFunc(topic,this._value);
this._oldValues.push(oldValue)
}.bind(this))
}this.applied=true
}else{throw"Command can not be applied two times in a row."
}},undoExecute:function(commandContext){if(this.applied){var topics=commandContext.findTopics(this._topicsId);
topics.each(function(topic,index){this._commandFunc(topic,this._oldValues[index])
}.bind(this));
this.applied=false;
this._oldValues=[]
}else{throw"undo can not be applied."
}}});mindplot.commands.DeleteCommand=new Class({Extends:mindplot.Command,initialize:function(topicIds,relIds){$assert($defined(relIds),"topicIds can not be null");
this.parent();
this._relIds=relIds;
this._topicIds=topicIds;
this._deletedTopicModels=[];
this._deletedRelModel=[];
this._parentTopicIds=[]
},execute:function(commandContext){var topics=this._filterChildren(this._topicIds,commandContext);
if(topics.length>0){topics.each(function(topic){topic.closeEditors();
var model=topic.getModel();
var relationships=this._collectInDepthRelationships(topic);
this._deletedRelModel.append(relationships.map(function(rel){return rel.getModel().clone()
}));
relationships.each(function(relationship){commandContext.deleteRelationship(relationship)
});
var clonedModel=model.clone();
this._deletedTopicModels.push(clonedModel);
var outTopic=topic.getOutgoingConnectedTopic();
var outTopicId=null;
if(outTopic!=null){outTopicId=outTopic.getId()
}this._parentTopicIds.push(outTopicId);
commandContext.deleteTopic(topic)
},this)
}var rels=commandContext.findRelationships(this._relIds);
if(rels.length>0){rels.each(function(rel){this._deletedRelModel.push(rel.getModel().clone());
commandContext.deleteRelationship(rel)
},this)
}},undoExecute:function(commandContext){this._deletedTopicModels.each(function(model){commandContext.createTopic(model)
},this);
this._deletedTopicModels.each(function(topicModel,index){var topics=commandContext.findTopics(topicModel.getId());
var parentId=this._parentTopicIds[index];
if(parentId){var parentTopics=commandContext.findTopics(parentId);
commandContext.connect(topics[0],parentTopics[0])
}},this);
this._deletedRelModel.each(function(model){commandContext.addRelationship(model)
}.bind(this));
this._deletedTopicModels.each(function(topicModel){var topics=commandContext.findTopics(topicModel.getId());
topics[0].setBranchVisibility(true)
},this);
if(this._deletedTopicModels.length>0){var firstTopic=this._deletedTopicModels[0];
var topic=commandContext.findTopics(firstTopic.getId())[0];
topic.setOnFocus(true)
}this._deletedTopicModels=[];
this._parentTopicIds=[];
this._deletedRelModel=[]
},_filterChildren:function(topicIds,commandContext){var topics=commandContext.findTopics(topicIds);
var result=[];
topics.each(function(topic){var parent=topic.getParent();
var found=false;
while(parent!=null&&!found){found=topicIds.contains(parent.getId());
if(found){break
}parent=parent.getParent()
}if(!found){result.push(topic)
}});
return result
},_collectInDepthRelationships:function(topic){var result=[];
result.append(topic.getRelationships());
var children=topic.getChildren();
var rels=children.map(function(topic){return this._collectInDepthRelationships(topic)
},this);
result.append(rels.flatten());
return result
}});mindplot.commands.DragTopicCommand=new Class({Extends:mindplot.Command,initialize:function(topicId,position,order,parentTopic){$assert(topicId,"topicId must be defined");
this._topicsId=topicId;
if($defined(parentTopic)){this._parentId=parentTopic.getId()
}this.parent();
this._position=position;
this._order=order
},execute:function(commandContext){var topic=commandContext.findTopics(this._topicsId)[0];
topic.setVisibility(false);
var origParentTopic=topic.getOutgoingConnectedTopic();
var origOrder=topic.getOrder();
var origPosition=topic.getPosition();
if($defined(origParentTopic)&&origParentTopic!=this._parentId){commandContext.disconnect(topic)
}if(this._order!=null){topic.setOrder(this._order)
}else{if(this._position!=null){commandContext.moveTopic(topic,this._position)
}else{$assert("Illegal command state exception.")
}}if(origParentTopic!=this._parentId){if($defined(this._parentId)){var parentTopic=commandContext.findTopics(this._parentId)[0];
commandContext.connect(topic,parentTopic)
}this._parentId=null;
if($defined(origParentTopic)){this._parentId=origParentTopic.getId()
}}topic.setVisibility(true);
this._order=origOrder;
this._position=origPosition
},undoExecute:function(commandContext){this.execute(commandContext)
}});mindplot.commands.AddTopicCommand=new Class({Extends:mindplot.Command,initialize:function(models,parentTopicsId){$assert(models,"models can not be null");
$assert(parentTopicsId==null||parentTopicsId.length==models.length,"parents and models must have the same size");
this.parent();
this._models=models;
this._parentsIds=parentTopicsId
},execute:function(commandContext){this._models.each(function(model,index){var topic=commandContext.createTopic(model);
if(this._parentsIds){var parentId=this._parentsIds[index];
if($defined(parentId)){var parentTopic=commandContext.findTopics(parentId)[0];
commandContext.connect(topic,parentTopic)
}}var designer=commandContext._designer;
designer.onObjectFocusEvent(topic);
topic.setOnFocus(true);
topic.setVisibility(true)
}.bind(this))
},undoExecute:function(commandContext){this._models.each(function(model){var topicId=model.getId();
var topic=commandContext.findTopics(topicId)[0];
commandContext.deleteTopic(topic)
}.bind(this))
}});mindplot.commands.ChangeFeatureToTopicCommand=new Class({Extends:mindplot.Command,initialize:function(topicId,featureId,attributes){$assert($defined(topicId),"topicId can not be null");
$assert($defined(featureId),"featureId can not be null");
$assert($defined(attributes),"attributes can not be null");
this.parent();
this._topicId=topicId;
this._featureId=featureId;
this._attributes=attributes
},execute:function(commandContext){var topic=commandContext.findTopics(this._topicId)[0];
var feature=topic.findFeatureById(this._featureId);
var oldAttributes=feature.getAttributes();
feature.setAttributes(this._attributes);
this._attributes=oldAttributes
},undoExecute:function(commandContext){this.execute(commandContext)
}});mindplot.commands.RemoveFeatureFromTopicCommand=new Class({Extends:mindplot.Command,initialize:function(topicId,featureId){$assert($defined(topicId),"topicId can not be null");
$assert(featureId,"iconModel can not be null");
this.parent();
this._topicId=topicId;
this._featureId=featureId;
this._oldFeature=null
},execute:function(commandContext){var topic=commandContext.findTopics(this._topicId)[0];
var feature=topic.findFeatureById(this._featureId);
topic.removeFeature(feature);
this._oldFeature=feature
},undoExecute:function(commandContext){var topic=commandContext.findTopics(this._topicId)[0];
topic.addFeature(this._oldFeature);
this._oldFeature=null
}});mindplot.commands.AddFeatureToTopicCommand=new Class({Extends:mindplot.Command,initialize:function(topicId,featureType,attributes){$assert($defined(topicId),"topicId can not be null");
$assert(featureType,"featureType can not be null");
$assert(attributes,"attributes can not be null");
this.parent();
this._topicId=topicId;
this._featureType=featureType;
this._attributes=attributes;
this._featureModel=null
},execute:function(commandContext){var topic=commandContext.findTopics(this._topicId)[0];
if(!this._featureModel){var model=topic.getModel();
this._featureModel=model.createFeature(this._featureType,this._attributes)
}topic.addFeature(this._featureModel)
},undoExecute:function(commandContext){var topic=commandContext.findTopics(this._topicId)[0];
topic.removeFeature(this._featureModel)
}});mindplot.commands.AddRelationshipCommand=new Class({Extends:mindplot.Command,initialize:function(model){$assert(model,"Relationship model can not be null");
this.parent();
this._model=model
},execute:function(commandContext){var relationship=commandContext.addRelationship(this._model);
relationship.setOnFocus(true)
},undoExecute:function(commandContext){var rel=commandContext.findRelationships(this._model.getId());
commandContext.deleteRelationship(rel[0])
}});mindplot.commands.MoveControlPointCommand=new Class({Extends:mindplot.Command,initialize:function(ctrlPointController,point){$assert(ctrlPointController,"line can not be null");
$assert($defined(point),"point can not be null");
this.parent();
this._ctrlPointControler=ctrlPointController;
this._line=ctrlPointController._line;
this._controlPoint=this._ctrlPointControler.getControlPoint(point).clone();
this._oldControlPoint=this._ctrlPointControler.getOriginalCtrlPoint(point).clone();
this._originalEndPoint=this._ctrlPointControler.getOriginalEndPoint(point).clone();
switch(point){case 0:this._wasCustom=this._line.getLine().isSrcControlPointCustom();
this._endPoint=this._line.getLine().getFrom().clone();
break;
case 1:this._wasCustom=this._line.getLine().isDestControlPointCustom();
this._endPoint=this._line.getLine().getTo().clone();
break
}this._point=point
},execute:function(commandContext){var model=this._line.getModel();
switch(this._point){case 0:model.setSrcCtrlPoint(this._controlPoint.clone());
this._line.setFrom(this._endPoint.x,this._endPoint.y);
this._line.setIsSrcControlPointCustom(true);
this._line.setSrcControlPoint(this._controlPoint.clone());
break;
case 1:model.setDestCtrlPoint(this._controlPoint.clone());
this._wasCustom=this._line.getLine().isDestControlPointCustom();
this._line.setTo(this._endPoint.x,this._endPoint.y);
this._line.setIsDestControlPointCustom(true);
this._line.setDestControlPoint(this._controlPoint.clone());
break
}if(this._line.isOnFocus()){this._line._refreshShape();
this._ctrlPointControler.setLine(this._line)
}this._line.getLine().updateLine(this._point)
},undoExecute:function(commandContext){var line=this._line;
var model=line.getModel();
switch(this._point){case 0:if($defined(this._oldControlPoint)){line.setFrom(this._originalEndPoint.x,this._originalEndPoint.y);
model.setSrcCtrlPoint(this._oldControlPoint.clone());
line.setSrcControlPoint(this._oldControlPoint.clone());
line.setIsSrcControlPointCustom(this._wasCustom)
}break;
case 1:if($defined(this._oldControlPoint)){line.setTo(this._originalEndPoint.x,this._originalEndPoint.y);
model.setDestCtrlPoint(this._oldControlPoint.clone());
line.setDestControlPoint(this._oldControlPoint.clone());
line.setIsDestControlPointCustom(this._wasCustom)
}break
}this._line.getLine().updateLine(this._point);
if(this._line.isOnFocus()){this._ctrlPointControler.setLine(line);
line._refreshShape()
}}});mindplot.collaboration.CollaborationManager=new Class({initialize:function(){this.collaborativeModelReady=false;
this.collaborativeModelReady=null
},setCollaborativeFramework:function(framework){this._collaborativeFramework=framework
},buildMindmap:function(){return this._collaborativeFramework.buildMindmap()
},getCollaborativeFramework:function(){return this._collaborativeFramework
}});
mindplot.collaboration.CollaborationManager.getInstance=function(){if(!$defined(mindplot.collaboration.CollaborationManager.__collaborationManager)){mindplot.collaboration.CollaborationManager.__collaborationManager=new mindplot.collaboration.CollaborationManager()
}return mindplot.collaboration.CollaborationManager.__collaborationManager
};
mindplot.collaboration.CollaborationManager.getInstance();mindplot.collaboration.framework.AbstractCollaborativeFramework=new Class({initialize:function(model){$assert(model,"model can not be null");
this._model=model;
this._actionDispatcher=null
},getModel:function(){return this._model
},buildMindmap:function(){var cmind=this.getModel();
var mmind=new mindplot.model.Mindmap();
cmind.copyTo(mmind);
return mmind
},_findTopic:function(nodes,id){var result;
for(var i=0;
i<nodes.length;
i++){var node=nodes[i];
if(node.getId()==id){result=node
}else{var children=node.getChildren();
result=this._findTopic(children,id)
}if(result!=null){break
}}return result
},getTopic:function(id){$assert($defined(id),"id can not be null");
var branches=this.getModel().getBranches();
var result=this._findTopic(branches,id);
$assert(result,"Could not find topic:"+id);
return result
},getActionDispatcher:function(){if(this._actionDispatcher==null){var context=mindplot.ActionDispatcher.getInstance()._commandContext;
this._actionDispatcher=new mindplot.StandaloneActionDispatcher(context)
}return this._actionDispatcher
}});mindplot.collaboration.framework.AbstractCollaborativeModelFactory=new Class({createNewMindmap:function(){throw"Unsupported operation"
},buildMindmap:function(model){throw"Unsupported operation"
}});mindplot.widget.ToolbarNotifier=new Class({initialize:function(){var container=$("headerNotifier");
if(container){this._effect=new Fx.Elements(container,{onComplete:function(){container.setStyle("display","none")
}.bind(this),link:"cancel",duration:8000,transition:Fx.Transitions.Expo.easeInOut})
}},logError:function(userMsg){this.logMessage(userMsg,mindplot.widget.ToolbarNotifier.MsgKind.ERROR)
},hide:function(){},logMessage:function(msg,fade){$assert(msg,"msg can not be null");
var container=$("headerNotifier");
if(container){container.set("text",msg);
container.setStyle("display","block");
container.position({relativeTo:$("header"),position:"upperCenter",edge:"centerTop"});
if(!$defined(fade)||fade){this._effect.start({0:{opacity:[1,0]}})
}else{container.setStyle("opacity","1");
this._effect.pause()
}}}});
mindplot.widget.ToolbarNotifier.MsgKind={INFO:1,WARNING:2,ERROR:3,FATAL:4};
var toolbarNotifier=new mindplot.widget.ToolbarNotifier();
$notify=toolbarNotifier.logMessage.bind(toolbarNotifier);mindplot.widget.ToolbarItem=new Class({Implements:[Events],initialize:function(buttonId,fn,options){$assert(buttonId,"buttonId can not be null");
$assert(fn,"fn can not be null");
this._buttonId=buttonId;
this._fn=fn;
this._options=options;
this._enable=false;
this.enable()
},_registerTip:function(){return new mindplot.widget.FloatingTip($(this._buttonId),{html:false,position:"bottom",arrowOffset:5,center:true,arrowSize:5,showDelay:500,hideDelay:0,className:"toolbarTip",motionOnShow:false,motionOnHide:false,motion:0,distance:0,preventHideOnOver:false})
},getButtonElem:function(){var elem=$(this._buttonId);
$assert(elem,"Could not find element for "+this._buttonId);
return elem
}.protect(),getButtonId:function(){return this._buttonId
},show:function(){this.fireEvent("show")
},hide:function(){this.fireEvent("hide")
},isTopicAction:function(){return this._options.topicAction
},isRelAction:function(){return this._options.relAction
},disable:function(){var elem=this.getButtonElem();
if(this._enable){elem.removeEvent("click",this._fn);
elem.removeClass("buttonOn");
elem.addClass("buttonOff");
this._enable=false
}},enable:function(){var elem=this.getButtonElem();
if(!this._enable){elem.addEvent("click",this._fn);
elem.removeClass("buttonOff");
elem.addClass("buttonOn");
this._enable=true
}},getTip:function(){return this._tip
}.protect()});mindplot.widget.ToolbarPaneItem=new Class({Extends:mindplot.widget.ToolbarItem,initialize:function(buttonId,model){$assert(buttonId,"buttonId can not be null");
$assert(model,"model can not be null");
this._model=model;
var fn=function(){if(this.isVisible()){this.hide()
}else{this.show()
}}.bind(this);
this.parent(buttonId,fn,{topicAction:true,relAction:false});
this._panelElem=this._init();
this._visible=false
},_init:function(){var panelElem=this.buildPanel();
panelElem.setStyle("cursor","default");
var buttonElem=this.getButtonElem();
var item=this;
this._tip=new mindplot.widget.FloatingTip(buttonElem,{html:true,position:"bottom",arrowOffset:5,center:true,arrowSize:7,showDelay:0,hideDelay:0,content:function(){return item._updateSelectedItem()
}.bind(this),className:"toolbarPaneTip",motionOnShow:false,motionOnHide:false,motion:0,distance:0,showOn:"xxxx",hideOn:"xxxx",preventHideOnOver:true,offset:{x:-4,y:0}});
this._tip.addEvent("hide",function(){this._visible=false
}.bind(this));
this._tip.addEvent("show",function(){this._visible=true
}.bind(this));
return panelElem
},getModel:function(){return this._model
},getPanelElem:function(){return this._panelElem
}.protect(),show:function(){if(!this.isVisible()){this.parent();
this._tip.show(this.getButtonElem());
this.getButtonElem().className="buttonExtActive"
}},hide:function(){if(this.isVisible()){this.parent();
this._tip.hide(this.getButtonElem());
this.getButtonElem().className="buttonExtOn"
}},isVisible:function(){return this._visible
},disable:function(){this.hide();
var elem=this.getButtonElem();
if(this._enable){elem.removeEvent("click",this._fn);
elem.removeClass("buttonExtOn");
elem.removeClass("buttonOn");
elem.addClass("buttonExtOff");
this._enable=false
}},enable:function(){var elem=this.getButtonElem();
if(!this._enable){elem.addEvent("click",this._fn);
elem.removeClass("buttonExtOff");
elem.addClass("buttonExtOn");
this._enable=true
}},buildPanel:function(){throw"Method must be implemented"
}.protect()});mindplot.widget.NoteEditor=new Class({Extends:MooDialog,initialize:function(model){$assert(model,"model can not be null");
var panel=this._buildPanel(model);
this.parent({closeButton:true,destroyOnClose:true,title:$msg("NOTE"),onInitialize:function(wrapper){wrapper.setStyle("opacity",0);
this.fx=new Fx.Morph(wrapper,{duration:600,transition:Fx.Transitions.Bounce.easeOut})
},onBeforeOpen:function(){this.overlay=new Overlay(this.options.inject,{duration:this.options.duration});
if(this.options.closeOnOverlayClick){this.overlay.addEvent("click",this.close.bind(this))
}this.overlay.open();
this.fx.start({"margin-top":[-200,-100],opacity:[0,1]}).chain(function(){this.fireEvent("show")
}.bind(this))
},onBeforeClose:function(){this.fx.start({"margin-top":[-100,0],opacity:0}).chain(function(){this.fireEvent("hide")
}.bind(this));
this.overlay.destroy()
}});
this.setContent(panel)
},_buildPanel:function(model){var result=new Element("div");
var form=new Element("form",{"action":"none","id":"noteFormId"});
var textArea=new Element("textarea",{placeholder:$msg("WRITE_YOUR_TEXT_HERE"),required:true,autofocus:"autofocus"});
if(model.getValue()!=null){textArea.value=model.getValue()
}textArea.setStyles({"width":"100%","height":80,resize:"none"});
textArea.inject(form);
form.addEvent("submit",function(event){event.preventDefault();
event.stopPropagation();
if(textArea.value){model.setValue(textArea.value)
}this.close()
}.bind(this));
var buttonContainer=new Element("div").setStyles({paddingTop:5,textAlign:"right"});
var okButton=new Element("input",{type:"submit",value:$msg("ACCEPT"),"class":"btn-primary"});
okButton.addClass("button");
okButton.inject(buttonContainer);
if($defined(model.getValue())){var rmButton=new Element("input",{type:"button",value:$msg("REMOVE"),"class":"btn-primary"});
rmButton.setStyle("margin","5px");
rmButton.addClass("button");
rmButton.inject(buttonContainer);
rmButton.addEvent("click",function(){model.setValue(null);
this.close()
}.bind(this));
buttonContainer.inject(form)
}var cButton=new Element("input",{type:"button",value:$msg("CANCEL"),"class":"btn-secondary"});
cButton.setStyle("margin","5px");
cButton.addClass("button");
cButton.inject(buttonContainer);
cButton.addEvent("click",function(){this.close()
}.bind(this));
buttonContainer.inject(form);
result.addEvent("keydown",function(event){event.stopPropagation()
});
form.inject(result);
return result
},show:function(){this.open()
}});mindplot.widget.LinkEditor=new Class({Extends:MooDialog,initialize:function(model){$assert(model,"model can not be null");
var panel=this._buildPanel(model);
this.parent({closeButton:true,destroyOnClose:true,title:$msg("LINK"),onInitialize:function(wrapper){wrapper.setStyle("opacity",0);
this.fx=new Fx.Morph(wrapper,{duration:600,transition:Fx.Transitions.Bounce.easeOut})
},onBeforeOpen:function(){this.overlay=new Overlay(this.options.inject,{duration:this.options.duration});
if(this.options.closeOnOverlayClick){this.overlay.addEvent("click",this.close.bind(this))
}this.overlay.open();
this.fx.start({"margin-top":[-200,-100],opacity:[0,1]}).chain(function(){this.fireEvent("show")
}.bind(this))
},onBeforeClose:function(){this.fx.start({"margin-top":[-100,0],opacity:0}).chain(function(){this.fireEvent("hide")
}.bind(this));
this.overlay.destroy()
}});
this.setContent(panel)
},_buildPanel:function(model){var result=new Element("div");
result.setStyle("padding-top","15px");
var form=new Element("form",{"action":"none","id":"linkFormId"});
var select=new Element("select");
select.setStyles({margin:"5px"});
new Element("option",{text:"URL"}).inject(select);
select.inject(form);
var input=new Element("input",{placeholder:"http://www.example.com/",type:Browser.ie?"text":"url",required:true,autofocus:"autofocus"});
if(model.getValue()!=null){input.value=model.getValue()
}input.setStyles({width:"55%",margin:"0px 10px"});
input.inject(form);
var openButton=new Element("input",{type:"button",value:$msg("OPEN_LINK")});
openButton.inject(form);
openButton.addEvent("click",function(){window.open(input.value,"_blank","status=1,width=700,height=450,resize=1")
});
form.addEvent("submit",function(event){event.stopPropagation();
event.preventDefault();
if(input.value!=null&&input.value.trim()!=""){model.setValue(input.value)
}this.close()
}.bind(this));
var buttonContainer=new Element("div").setStyles({paddingTop:5,textAlign:"center"});
var okButton=new Element("input",{type:"submit",value:$msg("ACCEPT"),"class":"btn-primary"});
okButton.addClass("button");
okButton.inject(buttonContainer);
if($defined(model.getValue())){var rmButton=new Element("input",{type:"button",value:$msg("REMOVE"),"class":"btn-primary"});
rmButton.setStyle("margin","5px");
rmButton.addClass("button");
rmButton.inject(buttonContainer);
rmButton.addEvent("click",function(event){model.setValue(null);
event.stopPropagation();
this.close()
}.bind(this));
buttonContainer.inject(form)
}var cButton=new Element("input",{type:"button",value:$msg("CANCEL"),"class":"btn-secondary"});
cButton.setStyle("margin","5px");
cButton.addClass("button");
cButton.inject(buttonContainer);
cButton.addEvent("click",function(){this.close()
}.bind(this));
buttonContainer.inject(form);
result.addEvent("keydown",function(event){event.stopPropagation()
});
form.inject(result);
return result
},show:function(){this.open()
}});mindplot.widget.FloatingTip=new Class({Implements:[Options,Events],options:{position:"top",center:true,content:"title",html:false,balloon:true,arrowSize:6,arrowOffset:6,distance:7,motion:40,motionOnShow:true,motionOnHide:true,showOn:"mouseenter",hideOn:"mouseleave",showDelay:500,hideDelay:250,className:"floating-tip",offset:{x:0,y:0},preventHideOnOver:true,fx:{"duration":"short"}},initialize:function(element,options){this.setOptions(options);
this.boundShow=function(){this.show(element)
}.bind(this);
this.boundHide=function(){this.hide(element)
}.bind(this);
if(!["top","right","bottom","left","inside"].contains(this.options.position)){this.options.position="top"
}this.attach(element)
},attach:function(element){if(element.retrieve("hasEvents")!==null){return
}element.addEvent(this.options.showOn,this.boundShow);
element.addEvent(this.options.hideOn,this.boundHide);
element.store("hasEvents",true)
},show:function(element){var old=element.retrieve("floatingtip");
if(old){if(old.getStyle("opacity")==1){clearTimeout(old.retrieve("timeout"));
return this
}}var tip=this._create(element);
if(tip==null){return this
}element.store("floatingtip",tip);
this._animate(tip,"in");
if(this.options.preventHideOnOver){tip.addEvent(this.options.showOn,this.boundShow);
tip.addEvent(this.options.hideOn,this.boundHide)
}this.fireEvent("show",[tip,element]);
return this
},hide:function(element){var tip=element.retrieve("floatingtip");
if(!tip){if(this.options.position=="inside"){try{element=element.getParent().getParent();
tip=element.retrieve("floatingtip")
}catch(x){}if(!tip){return this
}}else{return this
}}this._animate(tip,"out");
this.fireEvent("hide",[tip,element]);
return this
},_create:function(elem){var o=this.options;
var oc=o.content;
var opos=o.position;
if(oc=="title"){oc="floatingtitle";
if(!elem.get("floatingtitle")){elem.setProperty("floatingtitle",elem.get("title"))
}elem.set("title","")
}var cnt=(typeof(oc)=="string"?elem.get(oc):oc(elem));
var cwr=new Element("div").addClass(o.className).setStyle("margin",0);
var tip=new Element("div").addClass(o.className+"-wrapper").setStyles({"margin":0,"padding":0,"z-index":cwr.getStyle("z-index")}).adopt(cwr);
if(cnt){if(o.html){cnt.inject(cwr)
}else{cwr.set("text",cnt)
}}else{return null
}var body=document.id(document.body);
tip.setStyles({"position":"absolute","opacity":0,"top":0,"left":0}).inject(body);
if(o.balloon&&!Browser.ie6){var trg=new Element("div").addClass(o.className+"-triangle").setStyles({"margin":0,"padding":0});
var trgSt={"border-color":cwr.getStyle("background-color"),"border-width":o.arrowSize,"border-style":"solid","width":0,"height":0};
switch(opos){case"inside":case"top":trgSt["border-bottom-width"]=0;
break;
case"right":trgSt["border-left-width"]=0;
trgSt["float"]="left";
cwr.setStyle("margin-left",o.arrowSize);
break;
case"bottom":trgSt["border-top-width"]=0;
break;
case"left":trgSt["border-right-width"]=0;
if(Browser.ie7){trgSt["position"]="absolute";
trgSt["right"]=0
}else{trgSt["float"]="right"
}cwr.setStyle("margin-right",o.arrowSize);
break
}switch(opos){case"inside":case"top":case"bottom":trgSt["border-left-color"]=trgSt["border-right-color"]="transparent";
trgSt["margin-left"]=o.center?tip.getSize().x/2-o.arrowSize:o.arrowOffset;
break;
case"left":case"right":trgSt["border-top-color"]=trgSt["border-bottom-color"]="transparent";
trgSt["margin-top"]=o.center?tip.getSize().y/2-o.arrowSize:o.arrowOffset;
break
}trg.setStyles(trgSt).inject(tip,(opos=="top"||opos=="inside")?"bottom":"top")
}var tipSz=tip.getSize();
var trgC=elem.getCoordinates(body);
trgC.right=trgC.right==null?trgC.left:trgC.right;
trgC.bottom=trgC.bottom==null?trgC.top:trgC.bottom;
trgC.height=!$defined(trgC.height)?0:trgC.height;
trgC.width=!$defined(trgC.width)?0:trgC.width;
var pos={x:trgC.left+o.offset.x,y:trgC.top+o.offset.y};
if(opos=="inside"){tip.setStyles({"width":tip.getStyle("width"),"height":tip.getStyle("height")});
elem.setStyle("position","relative").adopt(tip);
pos={x:o.offset.x,y:o.offset.y}
}else{switch(opos){case"top":pos.y-=tipSz.y+o.distance;
break;
case"right":pos.x+=trgC.width+o.distance;
break;
case"bottom":pos.y+=trgC.height+o.distance;
break;
case"left":pos.x-=tipSz.x+o.distance;
break
}}if(o.center){switch(opos){case"top":case"bottom":pos.x+=(trgC.width/2-tipSz.x/2);
break;
case"left":case"right":pos.y+=(trgC.height/2-tipSz.y/2);
break;
case"inside":pos.x+=(trgC.width/2-tipSz.x/2);
pos.y+=(trgC.height/2-tipSz.y/2);
break
}}tip.set("morph",o.fx).store("position",pos);
tip.setStyles({"top":pos.y,"left":pos.x});
return tip
},_animate:function(tip,d){clearTimeout(tip.retrieve("timeout"));
tip.store("timeout",(function(t){var o=this.options,din=(d=="in");
var m={"opacity":din?1:0};
if((o.motionOnShow&&din)||(o.motionOnHide&&!din)){var pos=t.retrieve("position");
if(!pos){return
}switch(o.position){case"inside":case"top":m["top"]=din?[pos.y-o.motion,pos.y]:pos.y-o.motion;
break;
case"right":m["left"]=din?[pos.x+o.motion,pos.x]:pos.x+o.motion;
break;
case"bottom":m["top"]=din?[pos.y+o.motion,pos.y]:pos.y+o.motion;
break;
case"left":m["left"]=din?[pos.x-o.motion,pos.x]:pos.x-o.motion;
break
}}t.morph(m);
if(!din){t.get("morph").chain(function(){this.dispose()
}.bind(t))
}}).delay((d=="in")?this.options.showDelay:this.options.hideDelay,this,tip));
return this
}});mindplot.widget.LinkIconTooltip=new Class({Extends:mindplot.widget.FloatingTip,initialize:function(linkIcon){$assert(linkIcon,"linkIcon can not be null");
this.parent(linkIcon.getImage()._peer._native,{content:this._buildContent.pass(linkIcon,this),html:true,position:"bottom",arrowOffset:10,center:true,arrowSize:15,offset:{x:10,y:20},className:"linkTip"})
},_buildContent:function(linkIcon){var result=new Element("div");
result.setStyles({padding:"5px",width:"100%"});
var title=new Element("div",{text:$msg("LINK")});
title.setStyles({"font-weight":"bold",color:"black","padding-bottom":"5px",width:"100px"});
title.inject(result);
var text=new Element("div",{text:"URL: "+linkIcon.getModel().getUrl()});
text.setStyles({"white-space":"pre-wrap","word-wrap":"break-word"});
text.inject(result);
var imgContainer=new Element("div");
imgContainer.setStyles({width:"100%",textAlign:"right","padding-bottom":"5px","padding-top":"5px"});
var img=new Element("img",{src:"http://open.thumbshots.org/image.pxf?url="+linkIcon.getModel().getUrl(),img:linkIcon.getModel().getUrl(),alt:linkIcon.getModel().getUrl()});
img.setStyles({padding:"5px"});
var link=new Element("a",{href:linkIcon.getModel().getUrl(),alt:"Open in new window ...",target:"_blank"});
img.inject(link);
link.inject(imgContainer);
imgContainer.inject(result);
return result
}});mindplot.widget.KeyboardShortcutTooltip=new Class({Extends:mindplot.widget.FloatingTip,initialize:function(buttonElem,text){$assert(buttonElem,"buttonElem can not be null");
$assert(text,"text can not be null");
this._text=text;
var children=buttonElem.getChildren();
var tipElemId=buttonElem.id+"Tip";
var tipDiv=new Element("div",{id:tipElemId});
children[0].inject(tipDiv);
tipDiv.inject(buttonElem);
this.parent(tipDiv,{content:this._buildContent.pass(buttonElem,this),html:true,position:"bottom",arrowOffset:10,center:true,arrowSize:3,offset:{x:0,y:-2},className:"keyboardShortcutTip",preventHideOnOver:false,motionOnShow:false,motionOnHide:false,fx:{"duration":"100"}});
tipDiv.addEvent("click",function(e){tipDiv.fireEvent("mouseleave",e)
})
},_buildContent:function(){var result=new Element("div");
result.setStyles({padding:"3px 0px",width:"100%"});
var textContainer=new Element("div",{text:this._text});
textContainer.setStyles({width:"100%",textAlign:"center","font-weight":"bold"});
textContainer.inject(result);
return result
}});mindplot.widget.ColorPalettePanel=new Class({Extends:mindplot.widget.ToolbarPaneItem,initialize:function(buttonId,model,baseUrl){this._baseUrl=baseUrl;
this.parent(buttonId,model);
$assert($defined(baseUrl),"baseUrl can not be null")
},_load:function(){if(!mindplot.widget.ColorPalettePanel._panelContent){Asset.css(this._baseUrl+"/colorPalette.css",{id:"colorPaletteStyle",title:"colorPalette"});
var result;
var request=new Request({url:this._baseUrl+"/colorPalette.html",method:"get",async:false,onRequest:function(){},onSuccess:function(responseText){result=responseText
},onFailure:function(){result="<div>Sorry, your request failed :(</div>"
}});
request.send();
mindplot.widget.ColorPalettePanel._panelContent=result
}return mindplot.widget.ColorPalettePanel._panelContent
},buildPanel:function(){var content=new Element("div",{"class":"toolbarPanel","id":this._buttonId+"colorPalette"});
content.innerHTML=this._load();
var colorCells=content.getElements("div[class=palette-colorswatch]");
var model=this.getModel();
colorCells.each(function(elem){elem.addEvent("click",function(){var color=elem.getStyle("background-color");
model.setValue(color);
this.hide()
}.bind(this))
}.bind(this));
return content
},_updateSelectedItem:function(){var panelElem=this.getPanelElem();
var tdCells=panelElem.getElements("td[class='palette-cell palette-cell-selected']");
tdCells.each(function(elem){elem.className="palette-cell"
});
var colorCells=panelElem.getElements("div[class=palette-colorswatch]");
var model=this.getModel();
var modelValue=model.getValue();
colorCells.each(function(elem){var color=elem.getStyle("background-color");
if(modelValue!=null&&modelValue[0]=="r"){modelValue=modelValue.rgbToHex()
}if(modelValue!=null&&modelValue.toUpperCase()==color.toUpperCase()){elem.parentNode.className="palette-cell palette-cell-selected"
}});
return panelElem
}});mindplot.widget.ListToolbarPanel=new Class({Extends:mindplot.widget.ToolbarPaneItem,initialize:function(buttonId,model){this.parent(buttonId,model);
this._initPanel()
},_initPanel:function(){var menuElems=this.getPanelElem().getElements("div");
menuElems.each(function(elem){elem.addEvent("click",function(event){event.stopPropagation();
this.hide();
var value=$defined(elem.getAttribute("model"))?elem.getAttribute("model"):elem.id;
this.getModel().setValue(value)
}.bind(this))
}.bind(this))
},_updateSelectedItem:function(){var panelElem=this.getPanelElem();
var menuElems=panelElem.getElements("div");
var value=this.getModel().getValue();
menuElems.each(function(elem){var elemValue=$defined(elem.getAttribute("model"))?elem.getAttribute("model"):elem.id;
$assert(elemValue,"elemValue can not be null");
if(elemValue==value){elem.className="toolbarPanelLinkSelectedLink"
}else{elem.className="toolbarPanelLink"
}});
return panelElem
}});mindplot.widget.FontFamilyPanel=new Class({Extends:mindplot.widget.ListToolbarPanel,initialize:function(buttonId,model){this.parent(buttonId,model)
},buildPanel:function(){var content=new Element("div",{"class":"toolbarPanel","id":"fontFamilyPanel"});
content.innerHTML=""+'<div id="times" model="Times" class="toolbarPanelLink" style="font-family:times;">Times</div>'+'<div id="arial"  model="Arial" style="font-family:arial;">Arial</div>'+'<div id="tahoma" model="Tahoma" style="font-family:tahoma;">Tahoma</div>'+'<div id="verdana" model="Verdana" style="font-family:verdana;">Verdana</div>';
return content
}});mindplot.widget.FontSizePanel=new Class({Extends:mindplot.widget.ListToolbarPanel,initialize:function(buttonId,model){this.parent(buttonId,model)
},buildPanel:function(){var content=new Element("div",{"class":"toolbarPanel","id":"fontSizePanel"});
content.innerHTML=""+'<div id="small" model="6" style="font-size:8px">Small</div>'+'<div id="normal" model="8" style="font-size:12px">Normal</div>'+'<div id="large" model="10" style="font-size:15px">Large</div>'+'<div id="huge"  model="15" style="font-size:24px">Huge</div>';
return content
}});mindplot.widget.TopicShapePanel=new Class({Extends:mindplot.widget.ListToolbarPanel,initialize:function(buttonId,model){this.parent(buttonId,model)
},buildPanel:function(){var content=new Element("div",{"class":"toolbarPanel","id":"topicShapePanel"});
content.innerHTML=""+'<div id="rectagle" model="rectagle"><img src="images/shape-rectangle.png" alt="Rectangle"></div>'+'<div id="rounded_rectagle" model="rounded rectagle" ><img src="images/shape-rectangle-round.png" alt="Rounded Rectangle"></div>'+'<div id="line" model="line"><img src="images/shape-line.png" alt="Line"></div>'+'<div id="elipse" model="elipse"><img src="images/shape-circle.png"></div>';
return content
}});mindplot.widget.IconPanel=new Class({Extends:mindplot.widget.ToolbarPaneItem,initialize:function(buttonId,model){this.parent(buttonId,model)
},_updateSelectedItem:function(){return this.getPanelElem()
},buildPanel:function(){var content=new Element("div",{"class":"toolbarPanel","id":"IconsPanel"});
content.setStyles({width:253,height:210,padding:5});
content.addEvent("click",function(event){event.stopPropagation()
});
var count=0;
for(var i=0;
i<mindplot.ImageIcon.prototype.ICON_FAMILIES.length;
i=i+1){var familyIcons=mindplot.ImageIcon.prototype.ICON_FAMILIES[i].icons;
for(var j=0;
j<familyIcons.length;
j=j+1){var familyContent;
if((count%12)==0){familyContent=new Element("div").inject(content)
}var iconId=familyIcons[j];
var img=new Element("img",{id:iconId,src:mindplot.ImageIcon.prototype._getImageUrl(iconId)});
img.setStyles({width:16,height:16,padding:"0px 2px",cursor:"pointer"}).inject(familyContent);
var panel=this;
var model=this.getModel();
img.addEvent("click",function(event){model.setValue(this.id);
panel.hide()
}.bind(img));
count=count+1
}}return content
}});mindplot.widget.IMenu=new Class({initialize:function(designer,containerId,mapId){$assert(designer,"designer can not be null");
$assert(containerId,"containerId can not be null");
this._designer=designer;
this._toolbarElems=[];
this._containerId=containerId;
this._mapId=mapId;
this._mindmapUpdated=false;
this._designer.addEvent("modelUpdate",function(){this.setRequireChange(true)
}.bind(this))
},clear:function(){this._toolbarElems.each(function(item){item.hide()
})
},discardChanges:function(){this.setRequireChange(false);
var persistenceManager=mindplot.PersistenceManager.getInstance();
var mindmap=designer.getMindmap();
persistenceManager.discardChanges(mindmap.getId());
window.location.reload()
},save:function(saveElem,designer,saveHistory){var mindmap=designer.getMindmap();
var mindmapProp=designer.getMindmapProperties();
if(saveHistory){$notify($msg("SAVING"));
saveElem.setStyle("cursor","wait")
}else{console.log("Saving without history ...")
}var menu=this;
var persistenceManager=mindplot.PersistenceManager.getInstance();
persistenceManager.save(mindmap,mindmapProp,saveHistory,{onSuccess:function(){if(saveHistory){saveElem.setStyle("cursor","pointer");
$notify($msg("SAVE_COMPLETE"))
}menu.setRequireChange(false)
},onError:function(error){if(saveHistory){saveElem.setStyle("cursor","pointer");
var msg=error?error.globalErrors:null;
if(!msg){msg=$msg("SAVE_COULD_NOT_BE_COMPLETED")
}$notify(msg)
}}})
},isSaveRequired:function(){return this._mindmapUpdated
},setRequireChange:function(value){this._mindmapUpdated=value
}});mindplot.widget.Menu=new Class({Extends:mindplot.widget.IMenu,initialize:function(designer,containerId,mapId,readOnly,baseUrl){this.parent(designer,containerId,mapId);
baseUrl=!$defined(baseUrl)?"":baseUrl+"/";
var widgetsBaseUrl=baseUrl+"css/widget";
$(this._containerId).addEvent("click",function(event){event.stopPropagation();
return false
});
$(this._containerId).addEvent("dblclick",function(event){event.stopPropagation();
return false
});
var designerModel=designer.getModel();
var path=_servlet_context;
var fontFamilyBtn=$("fontFamily");
if(fontFamilyBtn){var fontFamilyModel={getValue:function(){var nodes=designerModel.filterSelectedTopics();
var result=null;
for(var i=0;
i<nodes.length;
i++){var fontFamily=nodes[i].getFontFamily();
if(result!=null&&result!=fontFamily){result=null;
break
}result=fontFamily
}return result
},setValue:function(value){designer.changeFontFamily(value)
}};
this._toolbarElems.push(new mindplot.widget.FontFamilyPanel("fontFamily",fontFamilyModel));
this._registerTooltip("fontFamily",$msg("FONT_FAMILY"))
}var fontSizeBtn=$("fontSize");
if(fontSizeBtn){var fontSizeModel={getValue:function(){var nodes=designerModel.filterSelectedTopics();
var result=null;
for(var i=0;
i<nodes.length;
i++){var fontSize=nodes[i].getFontSize();
if(result!=null&&result!=fontSize){result=null;
break
}result=fontSize
}return result
},setValue:function(value){designer.changeFontSize(value)
}};
this._toolbarElems.push(new mindplot.widget.FontSizePanel("fontSize",fontSizeModel));
this._registerTooltip("fontSize",$msg("FONT_SIZE"))
}var topicShapeBtn=$("topicShape");
if(topicShapeBtn){var topicShapeModel={getValue:function(){var nodes=designerModel.filterSelectedTopics();
var result=null;
for(var i=0;
i<nodes.length;
i++){var shapeType=nodes[i].getShapeType();
if(result!=null&&result!=shapeType){result=null;
break
}result=shapeType
}return result
},setValue:function(value){designer.changeTopicShape(value)
}};
this._toolbarElems.push(new mindplot.widget.TopicShapePanel("topicShape",topicShapeModel));
this._registerTooltip("topicShape",$msg("TOPIC_SHAPE"))
}var topicIconBtn=$("topicIcon");
if(topicIconBtn){var topicIconModel={getValue:function(){return null
},setValue:function(value){designer.addIconType(value)
}};
this._toolbarElems.push(new mindplot.widget.IconPanel("topicIcon",topicIconModel));
this._registerTooltip("topicIcon",$msg("TOPIC_ICON"))
}var topicColorBtn=$("topicColor");
if(topicColorBtn){var topicColorModel={getValue:function(){var nodes=designerModel.filterSelectedTopics();
var result=null;
for(var i=0;
i<nodes.length;
i++){var color=nodes[i].getBackgroundColor();
if(result!=null&&result!=color){result=null;
break
}result=color
}return result
},setValue:function(hex){designer.changeBackgroundColor(hex)
}};
this._toolbarElems.push(new mindplot.widget.ColorPalettePanel("topicColor",topicColorModel,widgetsBaseUrl));
this._registerTooltip("topicColor",$msg("TOPIC_COLOR"))
}var topicBorderBtn=$("topicBorder");
if(topicBorderBtn){var borderColorModel={getValue:function(){var nodes=designerModel.filterSelectedTopics();
var result=null;
for(var i=0;
i<nodes.length;
i++){var color=nodes[i].getBorderColor();
if(result!=null&&result!=color){result=null;
break
}result=color
}return result
},setValue:function(hex){designer.changeBorderColor(hex)
}};
this._toolbarElems.push(new mindplot.widget.ColorPalettePanel("topicBorder",borderColorModel,widgetsBaseUrl));
this._registerTooltip("topicBorder",$msg("TOPIC_BORDER_COLOR"))
}var fontColorBtn=$("fontColor");
if(fontColorBtn){var fontColorModel={getValue:function(){var result=null;
var nodes=designerModel.filterSelectedTopics();
for(var i=0;
i<nodes.length;
i++){var color=nodes[i].getFontColor();
if(result!=null&&result!=color){result=null;
break
}result=color
}return result
},setValue:function(hex){designer.changeFontColor(hex)
}};
this._toolbarElems.push(new mindplot.widget.ColorPalettePanel("fontColor",fontColorModel,baseUrl));
this._registerTooltip("fontColor",$msg("FONT_COLOR"))
}this._addButton("export",false,false,function(){var reqDialog=new MooDialog.Request(path+"/c/iframeWrapper.htm?url="+path+"/c/maps/"+mapId+"/exportf",null,{"class":"modalDialog exportModalDialog",closeButton:true,destroyOnClose:true,title:$msg("EXPORT")});
reqDialog.setRequestOptions({onRequest:function(){reqDialog.setContent($msg("LOADING"))
}});
MooDialog.Request.active=reqDialog
});
this._registerTooltip("export",$msg("EXPORT"));
this._addButton("print",false,false,function(){window.open(baseUrl+"c/maps/"+mapId+"/print")
});
this._registerTooltip("print",$msg("PRINT"));
this._addButton("zoomIn",false,false,function(){designer.zoomIn()
});
this._registerTooltip("zoomIn",$msg("ZOOM_IN"));
this._addButton("zoomOut",false,false,function(){designer.zoomOut()
});
this._registerTooltip("zoomOut",$msg("ZOOM_OUT"));
var undoButton=this._addButton("undoEdition",false,false,function(){designer.undo()
});
if(undoButton){undoButton.disable()
}this._registerTooltip("undoEdition",$msg("UNDO"),"meta+Z");
var redoButton=this._addButton("redoEdition",false,false,function(){designer.redo()
});
if(redoButton){redoButton.disable()
}this._registerTooltip("redoEdition",$msg("REDO"),"meta+shift+Z");
if(redoButton&&undoButton){designer.addEvent("modelUpdate",function(event){if(event.undoSteps>0){undoButton.enable()
}else{undoButton.disable()
}if(event.redoSteps>0){redoButton.enable()
}else{redoButton.disable()
}}.bind(this))
}this._addButton("addTopic",true,false,function(){designer.createChildForSelectedNode()
});
this._registerTooltip("addTopic",$msg("ADD_TOPIC"),"Enter");
this._addButton("deleteTopic",true,true,function(){designer.deleteSelectedEntities()
});
this._registerTooltip("deleteTopic",$msg("TOPIC_DELETE"),"Delete");
this._addButton("topicLink",true,false,function(){designer.addLink()
});
this._registerTooltip("topicLink",$msg("TOPIC_LINK"));
this._addButton("topicRelation",true,false,function(event){designer.showRelPivot(event)
});
this._registerTooltip("topicRelation",$msg("TOPIC_RELATIONSHIP"));
this._addButton("topicNote",true,false,function(){designer.addNote()
});
this._registerTooltip("topicNote",$msg("TOPIC_NOTE"));
this._addButton("fontBold",true,false,function(){designer.changeFontWeight()
});
this._registerTooltip("fontBold",$msg("FONT_BOLD"),"meta+B");
this._addButton("fontItalic",true,false,function(){designer.changeFontStyle()
});
this._registerTooltip("fontItalic",$msg("FONT_ITALIC"),"meta+I");
var saveElem=$("save");
if(saveElem){this._addButton("save",false,false,function(){this.save(saveElem,designer,true)
}.bind(this));
this._registerTooltip("save",$msg("SAVE"),"meta+S");
if(!readOnly){$(window).addEvent("beforeunload",function(){if(this.isSaveRequired()){this.save(saveElem,designer,false)
}}.bind(this));
(function(){if(this.isSaveRequired()){this.save(saveElem,designer,false)
}}.bind(this)).periodical(30000)
}}var discardElem=$("discard");
if(discardElem){this._addButton("discard",false,false,function(){this.discardChanges()
}.bind(this));
this._registerTooltip("discard",$msg("DISCARD_CHANGES"))
}var tagElem=$("tagIt");
if(tagElem){this._addButton("tagIt",false,false,function(){var reqDialog=new MooDialog.Request(path+"/c/tags?mapId="+mapId,null,{"class":"modalDialog tagItModalDialog",closeButton:true,destroyOnClose:true,title:"Tags"});
reqDialog.setRequestOptions({onRequest:function(){reqDialog.setContent($msg("LOADING"))
}})
});
this._registerTooltip("tagIt","Tag")
}var shareElem=$("shareIt");
if(shareElem){this._addButton("shareIt",false,false,function(){var reqDialog=new MooDialog.Request(path+"/c/iframeWrapper?url="+path+"/c/maps/"+mapId+"/sharef",null,{"class":"modalDialog shareModalDialog",closeButton:true,destroyOnClose:true,title:$msg("COLLABORATE")});
reqDialog.setRequestOptions({onRequest:function(){reqDialog.setContent($msg("LOADING"))
}});
MooDialog.Request.active=reqDialog
});
this._registerTooltip("shareIt",$msg("COLLABORATE"))
}var publishElem=$("publishIt");
if(publishElem){this._addButton("publishIt",false,false,function(){var reqDialog=new MooDialog.Request(path+"/c/iframeWrapper?url="+path+"/c/maps/"+mapId+"/publishf",null,{"class":"modalDialog publishModalDialog",closeButton:true,destroyOnClose:true,title:$msg("PUBLISH")});
reqDialog.setRequestOptions({onRequest:function(){reqDialog.setContent($msg("LOADING"))
}});
MooDialog.Request.active=reqDialog
});
this._registerTooltip("publishIt",$msg("PUBLISH"))
}var historyElem=$("history");
if(historyElem){this._addButton("history",false,false,function(){var reqDialog=new MooDialog.Request(path+"/c/iframeWrapper?url="+path+"/c/maps/"+mapId+"/historyf",null,{"class":"modalDialog historyModalDialog",closeButton:true,destroyOnClose:true,title:$msg("HISTORY")});
reqDialog.setRequestOptions({onRequest:function(){reqDialog.setContent($msg("LOADING"))
}})
});
this._registerTooltip("history",$msg("HISTORY"))
}this._registerEvents(designer);
var keyboardShortcut=$("keyboardShortcuts");
if(keyboardShortcut){keyboardShortcut.addEvent("click",function(event){var reqDialog=new MooDialog.Request(path+"/c/keyboard",null,{"class":"modalDialog keyboardModalDialog",closeButton:true,destroyOnClose:true,title:$msg("SHORTCUTS")});
reqDialog.setRequestOptions({onRequest:function(){reqDialog.setContent($msg("LOADING"))
}});
MooDialog.Request.active=reqDialog;
event.preventDefault()
})
}},_registerEvents:function(designer){this._toolbarElems.each(function(elem){elem.addEvent("show",function(){this.clear()
}.bind(this))
}.bind(this));
designer.addEvent("onblur",function(){var topics=designer.getModel().filterSelectedTopics();
var rels=designer.getModel().filterSelectedRelationships();
this._toolbarElems.each(function(button){var isTopicAction=button.isTopicAction();
var isRelAction=button.isRelAction();
if(isTopicAction||isRelAction){if((isTopicAction&&topics.length!=0)||(isRelAction&&rels.length!=0)){button.enable()
}else{button.disable()
}}})
}.bind(this));
designer.addEvent("onfocus",function(){var topics=designer.getModel().filterSelectedTopics();
var rels=designer.getModel().filterSelectedRelationships();
this._toolbarElems.each(function(button){var isTopicAction=button.isTopicAction();
var isRelAction=button.isRelAction();
if(isTopicAction||isRelAction){if(isTopicAction&&topics.length>0){button.enable()
}if(isRelAction&&rels.length>0){button.enable()
}}})
}.bind(this))
},_addButton:function(buttonId,topic,rel,fn){var result=null;
if($(buttonId)){var button=new mindplot.widget.ToolbarItem(buttonId,function(event){fn(event);
this.clear()
}.bind(this),{topicAction:topic,relAction:rel});
this._toolbarElems.push(button);
result=button
}return result
},_registerTooltip:function(buttonId,text,shortcut){if($(buttonId)){var tooltip=text;
if(shortcut){shortcut=Browser.Platform.mac?shortcut.replace("meta+","�?"):shortcut.replace("meta+","ctrl+");
tooltip=tooltip+" ("+shortcut+")"
}new mindplot.widget.KeyboardShortcutTooltip($(buttonId),tooltip)
}}});mindplot.layout.EventBusDispatcher=new Class({initialize:function(){this.registerBusEvents()
},setLayoutManager:function(layoutManager){this._layoutManager=layoutManager
},registerBusEvents:function(){mindplot.EventBus.instance.addEvent(mindplot.EventBus.events.NodeAdded,this._nodeAdded.bind(this));
mindplot.EventBus.instance.addEvent(mindplot.EventBus.events.NodeRemoved,this._nodeRemoved.bind(this));
mindplot.EventBus.instance.addEvent(mindplot.EventBus.events.NodeResizeEvent,this._nodeResizeEvent.bind(this));
mindplot.EventBus.instance.addEvent(mindplot.EventBus.events.NodeMoveEvent,this._nodeMoveEvent.bind(this));
mindplot.EventBus.instance.addEvent(mindplot.EventBus.events.NodeDisconnectEvent,this._nodeDisconnectEvent.bind(this));
mindplot.EventBus.instance.addEvent(mindplot.EventBus.events.NodeConnectEvent,this._nodeConnectEvent.bind(this));
mindplot.EventBus.instance.addEvent(mindplot.EventBus.events.NodeShrinkEvent,this._nodeShrinkEvent.bind(this));
mindplot.EventBus.instance.addEvent(mindplot.EventBus.events.DoLayout,this._doLayout.bind(this))
},_nodeResizeEvent:function(args){this._layoutManager.updateNodeSize(args.node.getId(),args.size)
},_nodeMoveEvent:function(args){this._layoutManager.moveNode(args.node.getId(),args.position)
},_nodeDisconnectEvent:function(node){this._layoutManager.disconnectNode(node.getId())
},_nodeConnectEvent:function(args){this._layoutManager.connectNode(args.parentNode.getId(),args.childNode.getId(),args.childNode.getOrder())
},_nodeShrinkEvent:function(node){this._layoutManager.updateShrinkState(node.getId(),node.areChildrenShrunken())
},_nodeAdded:function(node){if(node.getId()!=0){this._layoutManager.addNode(node.getId(),{width:10,height:10},node.getPosition());
this._layoutManager.updateShrinkState(node.getId(),node.areChildrenShrunken())
}},_nodeRemoved:function(node){this._layoutManager.removeNode(node.getId())
},_doLayout:function(){this._layoutManager.layout(true)
},getLayoutManager:function(){return this._layoutManager
}});mindplot.layout.ChangeEvent=new Class({initialize:function(id){$assert(!isNaN(id),"id can not be null");
this._id=id;
this._position=null;
this._order=null
},getId:function(){return this._id
},getOrder:function(){return this._order
},getPosition:function(){return this._position
},setOrder:function(value){$assert(!isNaN(value),"value can not be null");
this._order=value
},setPosition:function(value){$assert(value,"value can not be null");
this._position=value
},toString:function(){return"[order:"+this.getOrder()+", position: {"+this.getPosition().x+","+this.getPosition().y+"}]"
}});mindplot.layout.LayoutManager=new Class({Extends:Events,initialize:function(rootNodeId,rootSize){$assert($defined(rootNodeId),"rootNodeId can not be null");
$assert(rootSize,"rootSize can not be null");
var position=position||{x:0,y:0};
this._treeSet=new mindplot.layout.RootedTreeSet();
this._layout=new mindplot.layout.OriginalLayout(this._treeSet);
var rootNode=this._layout.createNode(rootNodeId,rootSize,position,"root");
this._treeSet.setRoot(rootNode);
this._events=[]
},updateNodeSize:function(id,size){$assert($defined(id),"id can not be null");
var node=this._treeSet.find(id);
node.setSize(size)
},updateShrinkState:function(id,value){$assert($defined(id),"id can not be null");
$assert($defined(value),"value can not be null");
var node=this._treeSet.find(id);
node.setShrunken(value);
return this
},find:function(id){return this._treeSet.find(id)
},moveNode:function(id,position){$assert($defined(id),"id cannot be null");
$assert($defined(position),"position cannot be null");
$assert($defined(position.x),"x can not be null");
$assert($defined(position.y),"y can not be null");
var node=this._treeSet.find(id);
node.setPosition(position)
},connectNode:function(parentId,childId,order){$assert($defined(parentId),"parentId cannot be null");
$assert($defined(childId),"childId cannot be null");
$assert($defined(order),"order cannot be null");
this._layout.connectNode(parentId,childId,order);
return this
},disconnectNode:function(id){$assert($defined(id),"id can not be null");
this._layout.disconnectNode(id);
return this
},addNode:function(id,size,position){$assert($defined(id),"id can not be null");
var result=this._layout.createNode(id,size,position,"topic");
this._treeSet.add(result);
return this
},removeNode:function(id){$assert($defined(id),"id can not be null");
var node=this._treeSet.find(id);
if(this._treeSet.getParent(node)){this.disconnectNode(id)
}this._treeSet.remove(id);
return this
},predict:function(parentId,nodeId,position,free){$assert($defined(parentId),"parentId can not be null");
var parent=this._treeSet.find(parentId);
var node=nodeId?this._treeSet.find(nodeId):null;
var sorter=parent.getSorter();
var result=sorter.predict(this._treeSet,parent,node,position,free);
return{order:result[0],position:result[1]}
},dump:function(){console.log(this._treeSet.dump())
},plot:function(containerId,size){$assert(containerId,"containerId cannot be null");
size=size||{width:200,height:200};
var squaresize=10;
var canvas=Raphael(containerId,size.width,size.height);
canvas.drawGrid(0,0,size.width,size.height,size.width/squaresize,size.height/squaresize);
this._treeSet.plot(canvas);
return canvas
},layout:function(fireEvents){this._layout.layout();
this._collectChanges();
if(!$(fireEvents)||fireEvents){this._flushEvents()
}return this
},_flushEvents:function(){this._events.each(function(event){this.fireEvent("change",event)
},this);
this._events=[]
},_collectChanges:function(nodes){if(!nodes){nodes=this._treeSet.getTreeRoots()
}nodes.each(function(node){if(node.hasOrderChanged()||node.hasPositionChanged()){var id=node.getId();
var event=this._events.some(function(event){return event.id==id
});
if(!event){event=new mindplot.layout.ChangeEvent(id)
}event.setOrder(node.getOrder());
event.setPosition(node.getPosition());
node.resetPositionState();
node.resetOrderState();
node.resetFreeState();
this._events.push(event)
}this._collectChanges(this._treeSet.getChildren(node))
},this)
}});mindplot.layout.Node=new Class({initialize:function(id,size,position,sorter){$assert(typeof id==="number"&&isFinite(id),"id can not be null");
$assert(size,"size can not be null");
$assert(position,"position can not be null");
$assert(sorter,"sorter can not be null");
this._id=id;
this._sorter=sorter;
this._properties={};
this.setSize(size);
this.setPosition(position);
this.setShrunken(false)
},getId:function(){return this._id
},setFree:function(value){this._setProperty("free",value)
},isFree:function(){return this._getProperty("free")
},hasFreeChanged:function(){return this._isPropertyChanged("free")
},hasFreeDisplacementChanged:function(){return this._isPropertyChanged("freeDisplacement")
},setShrunken:function(value){this._setProperty("shrink",value)
},areChildrenShrunken:function(){return this._getProperty("shrink")
},setOrder:function(order){$assert(typeof order==="number"&&isFinite(order),"Order can not be null. Value:"+order);
this._setProperty("order",order)
},resetPositionState:function(){var prop=this._properties["position"];
if(prop){prop.hasChanged=false
}},resetOrderState:function(){var prop=this._properties["order"];
if(prop){prop.hasChanged=false
}},resetFreeState:function(){var prop=this._properties["freeDisplacement"];
if(prop){prop.hasChanged=false
}},getOrder:function(){return this._getProperty("order")
},hasOrderChanged:function(){return this._isPropertyChanged("order")
},hasPositionChanged:function(){return this._isPropertyChanged("position")
},hasSizeChanged:function(){return this._isPropertyChanged("size")
},getPosition:function(){return this._getProperty("position")
},setSize:function(size){$assert($defined(size),"Size can not be null");
this._setProperty("size",Object.clone(size))
},getSize:function(){return this._getProperty("size")
},setFreeDisplacement:function(displacement){$assert($defined(displacement),"Position can not be null");
$assert($defined(displacement.x),"x can not be null");
$assert($defined(displacement.y),"y can not be null");
var oldDisplacement=this.getFreeDisplacement();
var newDisplacement={x:oldDisplacement.x+displacement.x,y:oldDisplacement.y+displacement.y};
this._setProperty("freeDisplacement",Object.clone(newDisplacement))
},resetFreeDisplacement:function(){this._setProperty("freeDisplacement",{x:0,y:0})
},getFreeDisplacement:function(){var freeDisplacement=this._getProperty("freeDisplacement");
return(freeDisplacement||{x:0,y:0})
},setPosition:function(position){$assert($defined(position),"Position can not be null");
$assert($defined(position.x),"x can not be null");
$assert($defined(position.y),"y can not be null");
var currentPos=this.getPosition();
if(currentPos==null||Math.abs(currentPos.x-position.x)>2||Math.abs(currentPos.y-position.y)>2){this._setProperty("position",position)
}},_setProperty:function(key,value){var prop=this._properties[key];
if(!prop){prop={hasChanged:false,value:null,oldValue:null}
}if(JSON.encode(prop.value)!=JSON.encode(value)){prop.oldValue=prop.value;
prop.value=value;
prop.hasChanged=true
}this._properties[key]=prop
},_getProperty:function(key){var prop=this._properties[key];
return $defined(prop)?prop.value:null
},_isPropertyChanged:function(key){var prop=this._properties[key];
return prop?prop.hasChanged:false
},getSorter:function(){return this._sorter
},toString:function(){return"[id:"+this.getId()+", order:"+this.getOrder()+", position: {"+this.getPosition().x+","+this.getPosition().y+"}, size: {"+this.getSize().width+","+this.getSize().height+"}, shrink:"+this.areChildrenShrunken()+"]"
}});mindplot.layout.RootedTreeSet=new Class({initialize:function(){this._rootNodes=[]
},setRoot:function(root){$assert(root,"root can not be null");
this._rootNodes.push(this._decodate(root))
},getTreeRoots:function(){return this._rootNodes
},_decodate:function(node){node._children=[];
return node
},add:function(node){$assert(node,"node can not be null");
$assert(!this.find(node.getId(),false),"node already exits with this id. Id:"+node.getId());
$assert(!node._children,"node already added");
this._rootNodes.push(this._decodate(node))
},remove:function(nodeId){$assert($defined(nodeId),"nodeId can not be null");
var node=this.find(nodeId);
this._rootNodes.erase(node)
},connect:function(parentId,childId){$assert($defined(parentId),"parent can not be null");
$assert($defined(childId),"child can not be null");
var parent=this.find(parentId);
var child=this.find(childId,true);
$assert(!child._parent,"node already connected. Id:"+child.getId()+",previous:"+child._parent);
parent._children.push(child);
child._parent=parent;
this._rootNodes.erase(child)
},disconnect:function(nodeId){$assert($defined(nodeId),"nodeId can not be null");
var node=this.find(nodeId);
$assert(node._parent,"Node is not connected");
node._parent._children.erase(node);
this._rootNodes.push(node);
node._parent=null
},find:function(id,validate){$assert($defined(id),"id can not be null");
var graphs=this._rootNodes;
var result=null;
for(var i=0;
i<graphs.length;
i++){var node=graphs[i];
result=this._find(id,node);
if(result){break
}}validate=!$defined(validate)?true:validate;
$assert(validate?result:true,"node could not be found id:"+id+"\n,RootedTreeSet"+this.dump());
return result
},_find:function(id,parent){if(parent.getId()==id){return parent
}var result=null;
var children=parent._children;
for(var i=0;
i<children.length;
i++){var child=children[i];
result=this._find(id,child);
if(result){break
}}return result
},getChildren:function(node){$assert(node,"node cannot be null");
return node._children
},getRootNode:function(node){$assert(node,"node cannot be null");
var parent=this.getParent(node);
if($defined(parent)){return this.getRootNode(parent)
}return node
},getAncestors:function(node){$assert(node,"node cannot be null");
return this._getAncestors(this.getParent(node),[])
},_getAncestors:function(node,ancestors){var result=ancestors;
if(node){result.push(node);
this._getAncestors(this.getParent(node),result)
}return result
},getSiblings:function(node){$assert(node,"node cannot be null");
if(!$defined(node._parent)){return[]
}var siblings=node._parent._children.filter(function(child){return child!=node
});
return siblings
},hasSinglePathToSingleLeaf:function(node){$assert(node,"node cannot be null");
return this._hasSinglePathToSingleLeaf(node)
},_hasSinglePathToSingleLeaf:function(node){var children=this.getChildren(node);
if(children.length==1){return this._hasSinglePathToSingleLeaf(children[0])
}return children.length==0
},isStartOfSubBranch:function(node){return this.getSiblings(node).length>0&&this.getChildren(node).length==1
},isLeaf:function(node){$assert(node,"node cannot be null");
return this.getChildren(node).length==0
},getParent:function(node){$assert(node,"node cannot be null");
return node._parent
},dump:function(){var branches=this._rootNodes;
var result="";
for(var i=0;
i<branches.length;
i++){var branch=branches[i];
result+=this._dump(branch,"")
}return result
},_dump:function(node,indent){var result=indent+node+"\n";
var children=this.getChildren(node);
for(var i=0;
i<children.length;
i++){var child=children[i];
result+=this._dump(child,indent+"   ")
}return result
},plot:function(canvas){var branches=this._rootNodes;
for(var i=0;
i<branches.length;
i++){var branch=branches[i];
this._plot(canvas,branch)
}},_plot:function(canvas,node,root){var children=this.getChildren(node);
var cx=node.getPosition().x+canvas.width/2-node.getSize().width/2;
var cy=node.getPosition().y+canvas.height/2-node.getSize().height/2;
var rect=canvas.rect(cx,cy,node.getSize().width,node.getSize().height);
var order=node.getOrder()==null?"r":node.getOrder();
var text=canvas.text(node.getPosition().x+canvas.width/2,node.getPosition().y+canvas.height/2,node.getId()+"["+order+"]");
text.attr("fill","#FFF");
var fillColor=this._rootNodes.contains(node)?"#000":(node.isFree()?"#abc":"#c00");
rect.attr("fill",fillColor);
var rectPosition={x:rect.attr("x")-canvas.width/2+rect.attr("width")/2,y:rect.attr("y")-canvas.height/2+rect.attr("height")/2};
var rectSize={width:rect.attr("width"),height:rect.attr("height")};
rect.click(function(){console.log("[id:"+node.getId()+", order:"+node.getOrder()+", position:("+rectPosition.x+","+rectPosition.y+"), size:"+rectSize.width+"x"+rectSize.height+", freeDisplacement:("+node.getFreeDisplacement().x+","+node.getFreeDisplacement().y+")]")
});
text.click(function(){console.log("[id:"+node.getId()+", order:"+node.getOrder()+", position:("+rectPosition.x+","+rectPosition.y+"), size:"+rectSize.width+"x"+rectSize.height+", freeDisplacement:("+node.getFreeDisplacement().x+","+node.getFreeDisplacement().y+")]")
});
for(var i=0;
i<children.length;
i++){var child=children[i];
this._plot(canvas,child)
}},updateBranchPosition:function(node,position){var oldPos=node.getPosition();
node.setPosition(position);
var xOffset=oldPos.x-position.x;
var yOffset=oldPos.y-position.y;
var children=this.getChildren(node);
children.each(function(child){this.shiftBranchPosition(child,xOffset,yOffset)
}.bind(this))
},shiftBranchPosition:function(node,xOffset,yOffset){var position=node.getPosition();
node.setPosition({x:position.x+xOffset,y:position.y+yOffset});
var children=this.getChildren(node);
children.each(function(child){this.shiftBranchPosition(child,xOffset,yOffset)
}.bind(this))
},getSiblingsInVerticalDirection:function(node,yOffset){var parent=this.getParent(node);
var siblings=this.getSiblings(node).filter(function(sibling){var sameSide=node.getPosition().x>parent.getPosition().x?sibling.getPosition().x>parent.getPosition().x:sibling.getPosition().x<parent.getPosition().x;
var orderOK=yOffset<0?sibling.getOrder()<node.getOrder():sibling.getOrder()>node.getOrder();
return orderOK&&sameSide
});
if(yOffset<0){siblings.reverse()
}return siblings
},getBranchesInVerticalDirection:function(node,yOffset){var rootNode=this.getRootNode(node);
var branches=this.getChildren(rootNode).filter(function(child){return this._find(node.getId(),child)
},this);
var branch=branches[0];
var rootDescendants=this.getSiblings(branch).filter(function(sibling){var sameSide=node.getPosition().x>rootNode.getPosition().x?sibling.getPosition().x>rootNode.getPosition().x:sibling.getPosition().x<rootNode.getPosition().x;
var sameDirection=yOffset<0?sibling.getOrder()<branch.getOrder():sibling.getOrder()>branch.getOrder();
return sameSide&&sameDirection
},this);
return rootDescendants
}});mindplot.layout.ChildrenSorterStrategy=new Class({initialize:function(){},computeChildrenIdByHeights:function(treeSet,node){throw"Method must be implemented"
},computeOffsets:function(treeSet,node){throw"Method must be implemented"
},insert:function(treeSet,parent,child,order){throw"Method must be implemented"
},detach:function(treeSet,node){throw"Method must be implemented"
},predict:function(treeSet,parent,node,position,free){throw"Method must be implemented"
},verify:function(treeSet,node){throw"Method must be implemented"
},getChildDirection:function(treeSet,node){throw"Method must be implemented"
},toString:function(){throw"Method must be implemented: print name"
}});mindplot.layout.AbstractBasicSorter=new Class({Extends:mindplot.layout.ChildrenSorterStrategy,computeChildrenIdByHeights:function(treeSet,node){var result={};
this._computeChildrenHeight(treeSet,node,result);
return result
},_getVerticalPadding:function(){return mindplot.layout.AbstractBasicSorter.INTERNODE_VERTICAL_PADDING
},_computeChildrenHeight:function(treeSet,node,heightCache){var height=node.getSize().height+(this._getVerticalPadding()*2);
var result;
var children=treeSet.getChildren(node);
if(children.length==0||node.areChildrenShrunken()){result=height
}else{var childrenHeight=0;
children.each(function(child){childrenHeight+=this._computeChildrenHeight(treeSet,child,heightCache)
},this);
result=Math.max(height,childrenHeight)
}if(heightCache){heightCache[node.getId()]=result
}return result
},_getSortedChildren:function(treeSet,node){var result=treeSet.getChildren(node);
result.sort(function(a,b){return a.getOrder()-b.getOrder()
});
return result
},_getRelativeDirection:function(reference,position){var offset=position.x-reference.x;
return offset>=0?1:-1
}});
mindplot.layout.AbstractBasicSorter.INTERNODE_VERTICAL_PADDING=5;
mindplot.layout.AbstractBasicSorter.INTERNODE_HORIZONTAL_PADDING=30;mindplot.layout.BalancedSorter=new Class({Extends:mindplot.layout.AbstractBasicSorter,initialize:function(){},predict:function(graph,parent,node,position,free){if(free){$assert($defined(position),"position cannot be null for predict in free positioning");
$assert($defined(node),"node cannot be null for predict in free positioning");
var rootNode=graph.getRootNode(parent);
var direction=this._getRelativeDirection(rootNode.getPosition(),node.getPosition());
var limitXPos=parent.getPosition().x+direction*(parent.getSize().width/2+node.getSize().width/2+mindplot.layout.BalancedSorter.INTERNODE_HORIZONTAL_PADDING);
var xPos=direction>0?(position.x>=limitXPos?position.x:limitXPos):(position.x<=limitXPos?position.x:limitXPos);
return[0,{x:xPos,y:position.y}]
}var rootNode=graph.getRootNode(parent);
if(node){$assert($defined(position),"position cannot be null for predict in dragging");
var nodeDirection=this._getRelativeDirection(rootNode.getPosition(),node.getPosition());
var positionDirection=this._getRelativeDirection(rootNode.getPosition(),position);
var siblings=graph.getSiblings(node);
var sameParent=parent==graph.getParent(node);
if(siblings.length==0&&nodeDirection==positionDirection&&sameParent){return[node.getOrder(),node.getPosition()]
}}if(!position){var right=this._getChildrenForOrder(parent,graph,0);
var left=this._getChildrenForOrder(parent,graph,1)
}var order=position?(position.x>rootNode.getPosition().x?0:1):((right.length-left.length)>0?1:0);
var direction=order%2==0?1:-1;
var children=this._getChildrenForOrder(parent,graph,order).filter(function(child){return child!=node
});
if(children.length==0){return[order,{x:parent.getPosition().x+direction*(parent.getSize().width/2+mindplot.layout.BalancedSorter.INTERNODE_HORIZONTAL_PADDING*2),y:parent.getPosition().y}]
}var result=null;
var last=children.getLast();
position=position||{x:last.getPosition().x,y:last.getPosition().y+1};
children.each(function(child,index){var cpos=child.getPosition();
if(position.y>cpos.y){yOffset=child==last?child.getSize().height+mindplot.layout.BalancedSorter.INTERNODE_VERTICAL_PADDING*2:(children[index+1].getPosition().y-child.getPosition().y)/2;
result=[child.getOrder()+2,{x:cpos.x,y:cpos.y+yOffset}]
}});
if(!result){var first=children[0];
result=[position.x>0?0:1,{x:first.getPosition().x,y:first.getPosition().y-first.getSize().height-mindplot.layout.BalancedSorter.INTERNODE_VERTICAL_PADDING*2}]
}return result
},insert:function(treeSet,parent,child,order){var children=this._getChildrenForOrder(parent,treeSet,order);
if(children.length==0){child.setOrder(order%2);
return
}var max=0;
for(var i=0;
i<children.length;
i++){var node=children[i];
max=Math.max(max,node.getOrder());
if(node.getOrder()>=order){max=Math.max(max,node.getOrder()+2);
node.setOrder(node.getOrder()+2)
}}var newOrder=order>(max+1)?(max+2):order;
child.setOrder(newOrder)
},detach:function(treeSet,node){var parent=treeSet.getParent(node);
var children=this._getChildrenForOrder(parent,treeSet,node.getOrder());
children.each(function(child,index){if(child.getOrder()>node.getOrder()){child.setOrder(child.getOrder()-2)
}});
node.setOrder(node.getOrder()%2==0?0:1)
},computeOffsets:function(treeSet,node){$assert(treeSet,"treeSet can no be null.");
$assert(node,"node can no be null.");
var children=this._getSortedChildren(treeSet,node);
var heights=children.map(function(child){return{id:child.getId(),order:child.getOrder(),width:child.getSize().width,height:this._computeChildrenHeight(treeSet,child)}
},this).reverse();
var totalPHeight=0;
var totalNHeight=0;
heights.each(function(elem){if(elem.order%2==0){totalPHeight+=elem.height
}else{totalNHeight+=elem.height
}});
var psum=totalPHeight/2;
var nsum=totalNHeight/2;
var ysum=0;
var result={};
for(var i=0;
i<heights.length;
i++){var direction=heights[i].order%2?-1:1;
if(direction>0){psum=psum-heights[i].height;
ysum=psum
}else{nsum=nsum-heights[i].height;
ysum=nsum
}var yOffset=ysum+heights[i].height/2;
var xOffset=direction*(node.getSize().width/2+heights[i].width/2+ +mindplot.layout.BalancedSorter.INTERNODE_HORIZONTAL_PADDING);
$assert(!isNaN(xOffset),"xOffset can not be null");
$assert(!isNaN(yOffset),"yOffset can not be null");
result[heights[i].id]={x:xOffset,y:yOffset}
}return result
},verify:function(treeSet,node){var children=this._getChildrenForOrder(node,treeSet,node.getOrder());
var factor=node.getOrder()%2==0?2:1;
for(var i=0;
i<children.length;
i++){var order=i==0&&factor==1?1:(factor*i);
$assert(children[i].getOrder()==order,"Missing order elements. Missing order: "+(i*factor)+". Parent:"+node.getId()+",Node:"+children[i].getId())
}},getChildDirection:function(treeSet,child){return child.getOrder()%2==0?1:-1
},toString:function(){return"Balanced Sorter"
},_getChildrenForOrder:function(parent,graph,order){return this._getSortedChildren(graph,parent).filter(function(child){return child.getOrder()%2==order%2
})
},_getVerticalPadding:function(){return mindplot.layout.BalancedSorter.INTERNODE_VERTICAL_PADDING
}});
mindplot.layout.BalancedSorter.INTERNODE_VERTICAL_PADDING=5;
mindplot.layout.BalancedSorter.INTERNODE_HORIZONTAL_PADDING=30;mindplot.layout.SymmetricSorter=new Class({Extends:mindplot.layout.AbstractBasicSorter,initialize:function(){},predict:function(graph,parent,node,position,free){var self=this;
var rootNode=graph.getRootNode(parent);
if(free){$assert($defined(position),"position cannot be null for predict in free positioning");
$assert($defined(node),"node cannot be null for predict in free positioning");
var direction=this._getRelativeDirection(rootNode.getPosition(),parent.getPosition());
var limitXPos=parent.getPosition().x+direction*(parent.getSize().width/2+node.getSize().width/2+mindplot.layout.SymmetricSorter.INTERNODE_HORIZONTAL_PADDING);
var xPos=direction>0?(position.x>=limitXPos?position.x:limitXPos):(position.x<=limitXPos?position.x:limitXPos);
return[0,{x:xPos,y:position.y}]
}if(!node){var parentDirection=self._getRelativeDirection(rootNode.getPosition(),parent.getPosition());
var position={x:parent.getPosition().x+parentDirection*(parent.getSize().width+mindplot.layout.SymmetricSorter.INTERNODE_HORIZONTAL_PADDING),y:parent.getPosition().y};
return[graph.getChildren(parent).length,position]
}$assert($defined(position),"position cannot be null for predict in dragging");
var nodeDirection=this._getRelativeDirection(rootNode.getPosition(),node.getPosition());
var positionDirection=this._getRelativeDirection(rootNode.getPosition(),position);
var siblings=graph.getSiblings(node);
var sameParent=parent==graph.getParent(node);
if(siblings.length==0&&nodeDirection==positionDirection&&sameParent){return[node.getOrder(),node.getPosition()]
}var parentChildren=graph.getChildren(parent);
if(parentChildren.length==0){var position={x:parent.getPosition().x+positionDirection*(parent.getSize().width+mindplot.layout.SymmetricSorter.INTERNODE_HORIZONTAL_PADDING),y:parent.getPosition().y};
return[0,position]
}else{var result=null;
var last=parentChildren.getLast();
for(var i=0;
i<parentChildren.length;
i++){var parentChild=parentChildren[i];
var nodeAfter=(i+1)==parentChild.length?null:parentChildren[i+1];
if(!nodeAfter&&position.y>parentChild.getPosition().y){var order=(graph.getParent(node)&&graph.getParent(node).getId()==parent.getId())?last.getOrder():last.getOrder()+1;
var position={x:parentChild.getPosition().x,y:parentChild.getPosition().y+parentChild.getSize().height+mindplot.layout.SymmetricSorter.INTERNODE_VERTICAL_PADDING*2};
return[order,position]
}if(nodeAfter&&position.y>parentChild.getPosition().y&&position.y<nodeAfter.getPosition().y){if(nodeAfter.getId()==node.getId()||parentChild.getId()==node.getId()){return[node.getOrder(),node.getPosition()]
}else{var order=position.y>node.getPosition().y?nodeAfter.getOrder()-1:parentChild.getOrder()+1;
var position={x:parentChild.getPosition().x,y:parentChild.getPosition().y+(nodeAfter.getPosition().y-parentChild.getPosition().y)/2};
return[order,position]
}}}}var first=parentChildren[0];
var position={x:first.getPosition().x,y:first.getPosition().y-first.getSize().height-mindplot.layout.SymmetricSorter.INTERNODE_VERTICAL_PADDING*2};
return[0,position]
},insert:function(treeSet,parent,child,order){var children=this._getSortedChildren(treeSet,parent);
$assert(order<=children.length,"Order must be continues and can not have holes. Order:"+order);
for(var i=order;
i<children.length;
i++){var node=children[i];
node.setOrder(i+1)
}child.setOrder(order)
},detach:function(treeSet,node){var parent=treeSet.getParent(node);
var children=this._getSortedChildren(treeSet,parent);
var order=node.getOrder();
$assert(children[order]===node,"Node seems not to be in the right position");
for(var i=node.getOrder()+1;
i<children.length;
i++){var child=children[i];
child.setOrder(child.getOrder()-1)
}node.setOrder(0)
},computeOffsets:function(treeSet,node){$assert(treeSet,"treeSet can no be null.");
$assert(node,"node can no be null.");
var children=this._getSortedChildren(treeSet,node);
var heights=children.map(function(child){return{id:child.getId(),order:child.getOrder(),position:child.getPosition(),width:child.getSize().width,height:this._computeChildrenHeight(treeSet,child)}
},this).reverse();
var totalHeight=0;
heights.each(function(elem){totalHeight+=elem.height
});
var ysum=totalHeight/2;
var result={};
for(var i=0;
i<heights.length;
i++){ysum=ysum-heights[i].height;
var childNode=treeSet.find(heights[i].id);
var direction=this.getChildDirection(treeSet,childNode);
var yOffset=ysum+heights[i].height/2;
var xOffset=direction*(heights[i].width/2+node.getSize().width/2+mindplot.layout.SymmetricSorter.INTERNODE_HORIZONTAL_PADDING);
$assert(!isNaN(xOffset),"xOffset can not be null");
$assert(!isNaN(yOffset),"yOffset can not be null");
result[heights[i].id]={x:xOffset,y:yOffset}
}return result
},verify:function(treeSet,node){var children=this._getSortedChildren(treeSet,node);
for(var i=0;
i<children.length;
i++){$assert(children[i].getOrder()==i,"missing order elements")
}},getChildDirection:function(treeSet,child){$assert(treeSet,"treeSet can no be null.");
$assert(treeSet.getParent(child),"This should not happen");
var result;
var rootNode=treeSet.getRootNode(child);
if(treeSet.getParent(child)==rootNode){result=Math.sign(rootNode.getPosition().x)
}else{var parent=treeSet.getParent(child);
var grandParent=treeSet.getParent(parent);
var sorter=grandParent.getSorter();
result=sorter.getChildDirection(treeSet,parent)
}return result
},toString:function(){return"Symmetric Sorter"
},_getVerticalPadding:function(){return mindplot.layout.SymmetricSorter.INTERNODE_VERTICAL_PADDING
}});
mindplot.layout.SymmetricSorter.INTERNODE_VERTICAL_PADDING=5;
mindplot.layout.SymmetricSorter.INTERNODE_HORIZONTAL_PADDING=30;mindplot.layout.GridSorter=new Class({Extends:mindplot.layout.AbstractBasicSorter,computeOffsets:function(treeSet,node){$assert(treeSet,"treeSet can no be null.");
$assert(node,"node can no be null.");
$assert("order can no be null.");
var children=this._getSortedChildren(treeSet,node);
var heights=children.map(function(child){return{id:child.getId(),height:this._computeChildrenHeight(treeSet,child)}
}.bind(this));
var result={};
for(var i=0;
i<heights.length;
i++){var even=i%2==0?1:-1;
var zeroHeight=i==0?0:heights[0].height/2*even;
var middleHeight=0;
for(var j=i-2;
j>0;
j=j-2){middleHeight+=heights[j].height*even
}var finalHeight=i==0?0:heights[i].height/2*even;
var yOffset=zeroHeight+middleHeight+finalHeight;
var xOffset=node.getSize().width+mindplot.layout.GridSorter.GRID_HORIZONTAR_SIZE;
$assert(!isNaN(xOffset),"xOffset can not be null");
$assert(!isNaN(yOffset),"yOffset can not be null");
result[heights[i].id]={x:xOffset,y:yOffset}
}return result
},toString:function(){return"Grid Sorter"
}});
mindplot.layout.GridSorter.GRID_HORIZONTAR_SIZE=20;
mindplot.layout.GridSorter.INTER_NODE_VERTICAL_DISTANCE=50;mindplot.layout.OriginalLayout=new Class({initialize:function(treeSet){this._treeSet=treeSet
},createNode:function(id,size,position,type){$assert($defined(id),"id can not be null");
$assert(size,"size can not be null");
$assert(position,"position can not be null");
$assert(type,"type can not be null");
var strategy=type==="root"?mindplot.layout.OriginalLayout.BALANCED_SORTER:mindplot.layout.OriginalLayout.SYMMETRIC_SORTER;
return new mindplot.layout.Node(id,size,position,strategy)
},connectNode:function(parentId,childId,order){var parent=this._treeSet.find(parentId);
var child=this._treeSet.find(childId);
var sorter=parent.getSorter();
sorter.insert(this._treeSet,parent,child,order);
this._treeSet.connect(parentId,childId);
sorter.verify(this._treeSet,parent)
},disconnectNode:function(nodeId){var node=this._treeSet.find(nodeId);
var parent=this._treeSet.getParent(node);
$assert(parent,"Node already disconnected");
node.setFree(false);
node.resetFreeDisplacement();
var sorter=parent.getSorter();
sorter.detach(this._treeSet,node);
this._treeSet.disconnect(nodeId);
parent.getSorter().verify(this._treeSet,parent)
},layout:function(){var roots=this._treeSet.getTreeRoots();
roots.each(function(node){var sorter=node.getSorter();
var heightById=sorter.computeChildrenIdByHeights(this._treeSet,node);
this._layoutChildren(node,heightById);
this._fixOverlapping(node,heightById)
},this)
},_layoutChildren:function(node,heightById){var nodeId=node.getId();
var children=this._treeSet.getChildren(node);
var parent=this._treeSet.getParent(node);
var childrenOrderMoved=children.some(function(child){return child.hasOrderChanged()
});
var childrenSizeChanged=children.some(function(child){return child.hasSizeChanged()
});
var newBranchHeight=heightById[nodeId];
var parentHeightChanged=$defined(parent)?parent._heightChanged:false;
var heightChanged=node._branchHeight!=newBranchHeight;
node._heightChanged=heightChanged||parentHeightChanged;
if(childrenOrderMoved||childrenSizeChanged||heightChanged||parentHeightChanged){var sorter=node.getSorter();
var offsetById=sorter.computeOffsets(this._treeSet,node);
var parentPosition=node.getPosition();
children.each(function(child){var offset=offsetById[child.getId()];
var childFreeDisplacement=child.getFreeDisplacement();
var direction=node.getSorter().getChildDirection(this._treeSet,child);
if((direction>0&&childFreeDisplacement.x<0)||(direction<0&&childFreeDisplacement.x>0)){child.resetFreeDisplacement();
child.setFreeDisplacement({x:-childFreeDisplacement.x,y:childFreeDisplacement.y})
}offset.x+=child.getFreeDisplacement().x;
offset.y+=child.getFreeDisplacement().y;
var parentX=parentPosition.x;
var parentY=parentPosition.y;
var newPos={x:parentX+offset.x,y:parentY+offset.y+this._calculateAlignOffset(node,child,heightById)};
this._treeSet.updateBranchPosition(child,newPos)
}.bind(this));
node._branchHeight=newBranchHeight
}children.each(function(child){this._layoutChildren(child,heightById)
},this)
},_calculateAlignOffset:function(node,child,heightById){if(child.isFree()){return 0
}var offset=0;
var nodeHeight=node.getSize().height;
var childHeight=child.getSize().height;
if(this._treeSet.isStartOfSubBranch(child)&&this._branchIsTaller(child,heightById)){if(this._treeSet.hasSinglePathToSingleLeaf(child)){offset=heightById[child.getId()]/2-(childHeight+child.getSorter()._getVerticalPadding()*2)/2
}else{offset=this._treeSet.isLeaf(child)?0:-(childHeight-nodeHeight)/2
}}else{if(nodeHeight>childHeight){if(this._treeSet.getSiblings(child).length>0){offset=0
}else{offset=nodeHeight/2-childHeight/2
}}else{if(childHeight>nodeHeight){if(this._treeSet.getSiblings(child).length>0){offset=0
}else{offset=-(childHeight/2-nodeHeight/2)
}}}}return offset
},_branchIsTaller:function(node,heightById){return heightById[node.getId()]>(node.getSize().height+node.getSorter()._getVerticalPadding()*2)
},_fixOverlapping:function(node,heightById){var children=this._treeSet.getChildren(node);
if(node.isFree()){this._shiftBranches(node,heightById)
}children.each(function(child){this._fixOverlapping(child,heightById)
},this)
},_shiftBranches:function(node,heightById){var shiftedBranches=[node];
var siblingsToShift=this._treeSet.getSiblingsInVerticalDirection(node,node.getFreeDisplacement().y);
var last=node;
siblingsToShift.each(function(sibling){var overlappingOccurs=shiftedBranches.some(function(shiftedBranch){return this._branchesOverlap(shiftedBranch,sibling,heightById)
},this);
if(!sibling.isFree()||overlappingOccurs){var sAmount=node.getFreeDisplacement().y;
this._treeSet.shiftBranchPosition(sibling,0,sAmount);
shiftedBranches.push(sibling)
}},this);
var branchesToShift=this._treeSet.getBranchesInVerticalDirection(node,node.getFreeDisplacement().y).filter(function(branch){return !shiftedBranches.contains(branch)
});
branchesToShift.each(function(branch){var bAmount=node.getFreeDisplacement().y;
this._treeSet.shiftBranchPosition(branch,0,bAmount);
shiftedBranches.push(branch);
last=branch
},this)
},_branchesOverlap:function(branchA,branchB,heightById){if(branchA==branchB){return false
}var topA=branchA.getPosition().y-heightById[branchA.getId()]/2;
var bottomA=branchA.getPosition().y+heightById[branchA.getId()]/2;
var topB=branchB.getPosition().y-heightById[branchB.getId()]/2;
var bottomB=branchB.getPosition().y+heightById[branchB.getId()]/2;
return !(topA>=bottomB||bottomA<=topB)
}});
mindplot.layout.OriginalLayout.SYMMETRIC_SORTER=new mindplot.layout.SymmetricSorter();
mindplot.layout.OriginalLayout.BALANCED_SORTER=new mindplot.layout.BalancedSorter();mindplot.EventBus=new Class({Implements:Events,initialize:function(){}});
mindplot.EventBus.events={NodeResizeEvent:"NodeResizeEvent",NodeMoveEvent:"NodeMoveEvent",NodeShrinkEvent:"NodeShrinkEvent",NodeConnectEvent:"NodeConnectEvent",NodeDisconnectEvent:"NodeDisconnectEvent",NodeAdded:"NodeAdded",NodeRemoved:"NodeRemoved",DoLayout:"DoLayout"};
mindplot.EventBus.instance=new mindplot.EventBus();mindplot.Messages.BUNDLES["en"]={"ZOOM_IN":"Zoom In","ZOOM_OUT":"Zoom Out","TOPIC_SHAPE":"Topic Shape","TOPIC_ADD":"Add Topic","TOPIC_DELETE":"Delete Topic","TOPIC_ICON":"Add Icon","TOPIC_LINK":"Add Link","TOPIC_RELATIONSHIP":"Relationship","TOPIC_COLOR":"Topic Color","TOPIC_BORDER_COLOR":"Topic Border Color","TOPIC_NOTE":"Add Note","FONT_FAMILY":"Font Type","FONT_SIZE":"Text Size","FONT_BOLD":"Text Bold","FONT_ITALIC":"Text Italic","UNDO":"Undo","REDO":"Redo","INSERT":"Insert","SAVE":"Save","NOTE":"Note","ADD_TOPIC":"Add Topic","LOADING":"Loading ...","EXPORT":"Export","PRINT":"Print","PUBLISH":"Publish","COLLABORATE":"Share","HISTORY":"History","DISCARD_CHANGES":"Discard Changes","FONT_COLOR":"Text Color","SAVING":"Saving ...","SAVE_COMPLETE":"Save Complete","ZOOM_IN_ERROR":"Zoom too high.","ZOOM_ERROR":"No more zoom can be applied.","ONLY_ONE_TOPIC_MUST_BE_SELECTED":"Could not create a topic. Only one topic must be selected.","ONE_TOPIC_MUST_BE_SELECTED":"Could not create a topic. One topic must be selected.","ONLY_ONE_TOPIC_MUST_BE_SELECTED_COLLAPSE":"Children can not be collapsed. One topic must be selected.","SAVE_COULD_NOT_BE_COMPLETED":"Save could not be completed. Try latter.","UNEXPECTED_ERROR_LOADING":"We're sorry, an unexpected error has occurred.\nTry again reloading the editor.If the problem persists, contact us to support@wisemapping.com.","MAIN_TOPIC":"Main Topic","SUB_TOPIC":"Sub Topic","ISOLATED_TOPIC":"Isolated Topic","CENTRAL_TOPIC":"Central Topic","SHORTCUTS":"Keyboard Shortcuts","ENTITIES_COULD_NOT_BE_DELETED":"Could not delete topic or relation. At least one map entity must be selected.","AT_LEAST_ONE_TOPIC_MUST_BE_SELECTED":"At least one topic must be selected.","CLIPBOARD_IS_EMPTY":"Nothing to copy. Clipboard is empty.","CENTRAL_TOPIC_CAN_NOT_BE_DELETED":"Central topic can not be deleted.","RELATIONSHIP_COULD_NOT_BE_CREATED":"Relationship could not be created. A parent relationship topic must be selected first.","SELECTION_COPIED_TO_CLIPBOARD":"Topics copied to the clipboard","WRITE_YOUR_TEXT_HERE":"Write your note here ...","REMOVE":"Remove","ACCEPT":"Accept","CANCEL":"Cancel","LINK":"Link","OPEN_LINK":"Open URL","MODEL":"Model","REASONING_SCOPE_RELOAD":"Reload reasoning scope","DUMMY":""};mindplot.Messages.BUNDLES["es"]={"DISCARD_CHANGES":"Descartar Cambios","SAVE":"Guardar","INSERT":"Insertar","ZOOM_IN":"Acercar","ZOOM_OUT":"Alejar","TOPIC_BORDER_COLOR":"Color del Borde","TOPIC_SHAPE":"Forma del Tópico","TOPIC_ADD":"Agregar Tópico","TOPIC_DELETE":"Borrar Tópico","TOPIC_ICON":"Agregar Icono","TOPIC_LINK":"Agregar Enlace","TOPIC_NOTE":"Agregar Nota","TOPIC_COLOR":"Color Tópico","TOPIC_RELATIONSHIP":"Relación","FONT_FAMILY":"Tipo de Fuente","FONT_SIZE":"Tamaño de Texto","FONT_BOLD":"Negrita","FONT_ITALIC":"Italica","FONT_COLOR":"Color de Texto","UNDO":"Rehacer","NOTE":"Nota","LOADING":"Cargando ...","PRINT":"Imprimir","PUBLISH":"Publicar","REDO":"Deshacer","ADD_TOPIC":"Agregar Tópico","COLLABORATE":"Compartir","EXPORT":"Exportar","HISTORY":"History","SAVE_COMPLETE":"Grabado Completo","SAVING":"Grabando ...","ONE_TOPIC_MUST_BE_SELECTED":"No ha sido posible crear un nuevo tópico. Al menos un tópico debe ser seleccionado.","ONLY_ONE_TOPIC_MUST_BE_SELECTED":"No ha sido posible crear un nuevo tópico. Sólo un tópico debe ser seleccionado.","SAVE_COULD_NOT_BE_COMPLETED":"Grabación no pudo ser completada. Intentelo mas tarde.","UNEXPECTED_ERROR_LOADING":"Lo sentimos, un error inesperado ha ocurrido. Intentelo nuevamente recargando el editor. Si el problema persiste, contactenos a support@wisemapping.com.","ZOOM_ERROR":"No es posible aplicar mas zoom.","ZOOM_IN_ERROR":"El zoom es muy alto.","MAIN_TOPIC":"Tópico Principal","SUB_TOPIC":"Tópico Secundario","ISOLATED_TOPIC":"Tópico Aislado","CENTRAL_TOPIC":"Tópico Central","ONLY_ONE_TOPIC_MUST_BE_SELECTED_COLLAPSE":"Tópicos hijos no pueden ser colapsados. Sólo un tópico debe ser seleccionado.","SHORTCUTS":"Accesos directos","ENTITIES_COULD_NOT_BE_DELETED":"El tópico o la relación no pudo ser borrada. Debe selecionar al menos una.","AT_LEAST_ONE_TOPIC_MUST_BE_SELECTED":"Al menos un tópico debe ser seleccionado.","CLIPBOARD_IS_EMPTY":"Nada que copiar. Clipboard está vacio.","CENTRAL_TOPIC_CAN_NOT_BE_DELETED":"El tópico central no puede ser borrado.","RELATIONSHIP_COULD_NOT_BE_CREATED":"La relación no pudo ser creada. Una relación padre debe ser seleccionada primero.","SELECTION_COPIED_TO_CLIPBOARD":"Tópicos copiados al clipboard","WRITE_YOUR_TEXT_HERE":"Escribe tu nota aquí ...","REMOVE":"Borrar","ACCEPT":"Aceptar","CANCEL":"Cancelar","LINK":"Enlace","OPEN_LINK":"Abrir Enlace","DUMMY":""};mindplot.Messages.BUNDLES["fr"]={"ZOOM_IN":"Agrandir affichage","ZOOM_OUT":"Réduire affichage","TOPIC_SHAPE":"Forme du noeud","TOPIC_ADD":"Ajouter un noeud","TOPIC_DELETE":"Supprimer le noeud","TOPIC_ICON":"Ajouter une icône","TOPIC_LINK":"Ajouter un lien","TOPIC_RELATIONSHIP":"Relation du noeud","TOPIC_COLOR":"Couleur du noeud","TOPIC_BORDER_COLOR":"Couleur de bordure du noeud","TOPIC_NOTE":"Ajouter une note","FONT_FAMILY":"Type de police","FONT_SIZE":"Taille de police","FONT_BOLD":"Caractères gras","FONT_ITALIC":"Caractères italiques","UNDO":"Annuler","REDO":"Refaire","INSERT":"Insérer","SAVE":"Enregistrer","NOTE":"Note","ADD_TOPIC":"Ajouter un noeud","LOADING":"Chargement ...","EXPORT":"Exporter","PRINT":"Imprimer","PUBLISH":"Publier","COLLABORATE":"Partager","HISTORY":"Historique","DISCARD_CHANGES":"Annuler les changements","FONT_COLOR":"Couleur de police","SAVING":"Enregistrement ...","SAVE_COMPLETE":"Enregistrement terminé","ZOOM_IN_ERROR":"Zoom trop grand.","ZOOM_ERROR":"Impossible de zoomer plus.","ONLY_ONE_TOPIC_MUST_BE_SELECTED":"Impossible de créer un noeud. Un seul noeud doit être sélectionné.","ONE_TOPIC_MUST_BE_SELECTED":"Impossible de créer un noeud. Un noeud parent doit être sélectionné au préalable.","ONLY_ONE_TOPIC_MUST_BE_SELECTED_COLLAPSE":"Un noeud enfant ne peut pas être réduit. Un noeud doit être sélectionné.","SAVE_COULD_NOT_BE_COMPLETED":"Enregistrement impossible. Essayer ultérieurement.","UNEXPECTED_ERROR_LOADING":"Nous sommes désolés, une erreur vient de survenir.\nEssayez de recharger l'éditeur. Si le problème persiste, contactez-nous : support@wisemapping.com.","MAIN_TOPIC":"Noeud titre principal","SUB_TOPIC":"Noeud sous-titre","ISOLATED_TOPIC":"Noeud isolé","CENTRAL_TOPIC":"Noeud racine","SHORTCUTS":"Raccourcis clavier","ENTITIES_COULD_NOT_BE_DELETED":"Impossible d'effacer un noeud ou une relation. Au moins un objet de la carte doit être sélectionné.","AT_LEAST_ONE_TOPIC_MUST_BE_SELECTED":"Au moins un objet de la carte doit être sélectionné.","CLIPBOARD_IS_EMPTY":"Rien à copier. Presse-papier vide.","CENTRAL_TOPIC_CAN_NOT_BE_DELETED":"Le noeud racine ne peut pas être effacé.","RELATIONSHIP_COULD_NOT_BE_CREATED":"Impossible de créer relation. Un noeud parent doit être sélectionné au préalable.","SELECTION_COPIED_TO_CLIPBOARD":"Noeuds sélectionnés copiés dans le presse-papiers.","ACCEPT":"Accepter","CANCEL":"Annuler","REMOVE":"Supprimer","WRITE_YOUR_TEXT_HERE":"Écrivez votre texte ici ...","LINK":"Lien","DUMMY":""};mindplot.Messages.BUNDLES["pt_br"]={"ZOOM_IN":"Ampliar","ZOOM_OUT":"Reduzir","TOPIC_SHAPE":"Forma do T\u00f3pico","TOPIC_ADD":"Adicionar T\u00f3pico","TOPIC_DELETE":"Deletar T\u00f3pico","TOPIC_ICON":"Adicionar \u00cdcone","TOPIC_LINK":"Adicionar Link","TOPIC_RELATIONSHIP":"Relacionamento","TOPIC_COLOR":"Cor do T\u00f3pico","TOPIC_BORDER_COLOR":"Cor da Borda do T\u00f3pico","TOPIC_NOTE":"Adicionar Nota","FONT_FAMILY":"Tipo de Fonte","FONT_SIZE":"Tamanho da Fonte","FONT_BOLD":"Fonte Negrito","FONT_ITALIC":"Fonte It\u00e1lico","UNDO":"Desfazer","REDO":"Refazer","INSERT":"Inserir","SAVE":"Salvar","NOTE":"Nota","ADD_TOPIC":"Adicionar T\u00f3pico","LOADING":"Carregando ...","EXPORT":"Exportar","PRINT":"Imprimir","PUBLISH":"Publicar","COLLABORATE":"Colaborar","HISTORY":"Hist\u00f3ria","DISCARD_CHANGES":"Descartar Altera\u00e7\u00f5es","FONT_COLOR":"Cor da Fonte","SAVING":"Salvando ...","SAVE_COMPLETE":"Salvamento Completo","ZOOM_IN_ERROR":"Zoom excessivo.","ZOOM_ERROR":"N\u00e3o \u00e9 poss\u00edvel aplicar mais zoom.","ONLY_ONE_TOPIC_MUST_BE_SELECTED":"N\u00e3o foi poss\u00edvel criar t\u00f3pico. Apenas um t\u00f3pico deve ser selecionado.","ONE_TOPIC_MUST_BE_SELECTED":"N\u00e3o foi poss\u00edvel criar t\u00f3pico. Um t\u00f3pico deve ser selecionado.","SAVE_COULD_NOT_BE_COMPLETED":"Salvamento n\u00e3o pode ser completado. Tente novamente mais tarde.","UNEXPECTED_ERROR_LOADING":"Ocorreu um erro inesperado.\nTente recarregar novamente o editor. Se o problema persistir, contacte-nos em support@wisemapping.com.","MAIN_TOPIC":"T\u00f3pico Principal","SUB_TOPIC":"Sub T\u00f3pico","ISOLATED_TOPIC":"T\u00f3pico Isolado","CENTRAL_TOPIC":"T\u00f3pico Central","SHORTCUTS":"Atalho","ENTITIES_COULD_NOT_BE_DELETED":"O tópico ou a relação não pode ser apagado. Seleccionar pelo menos um.","AT_LEAST_ONE_TOPIC_MUST_BE_SELECTED":"Pelo menos um tópico deve ser selecionado","CLIPBOARD_IS_EMPTY":"Nada para copiar. Clipboard está vazio.","CENTRAL_TOPIC_CAN_NOT_BE_DELETED":"O tópico central não pode ser apagado.","RELATIONSHIP_COULD_NOT_BE_CREATED":"A relação não pode ser criada. Uma relação pai deve ser selecionada primeiro.","SELECTION_COPIED_TO_CLIPBOARD":"Tópicos copiados ao clipboard.","ONLY_ONE_TOPIC_MUST_BE_SELECTED_COLLAPSE":"Tópicos filhos não podem ser colapsados. Só um tópico deve ser selecionado.","DUMMY":""};mindplot.Messages.BUNDLES["zh_cn"]={"ZOOM_IN":"放大","ZOOM_OUT":"缩小","TOPIC_SHAPE":"节点外形","TOPIC_ADD":"添加节点","TOPIC_DELETE":"删除节点","TOPIC_ICON":"加入图标","TOPIC_LINK":"添加链接","TOPIC_RELATIONSHIP":"关系","TOPIC_COLOR":"节点颜色","TOPIC_BORDER_COLOR":"边框颜色","TOPIC_NOTE":"添加注释","FONT_FAMILY":"字体","FONT_SIZE":"文字大小","FONT_BOLD":"粗体","FONT_ITALIC":"斜体","UNDO":"撤销","REDO":"重做","INSERT":"插入","SAVE":"保存","NOTE":"注释","ADD_TOPIC":"添加节点","LOADING":"载入中……","EXPORT":"导出","PRINT":"打印","PUBLISH":"公开","COLLABORATE":"共享","HISTORY":"历史","DISCARD_CHANGES":"清除改变","FONT_COLOR":"文本颜色","SAVING":"保存中……","SAVE_COMPLETE":"完成保存","ZOOM_IN_ERROR":"缩放过多。","ZOOM_ERROR":"不能再缩放。","ONLY_ONE_TOPIC_MUST_BE_SELECTED":"不能创建节点。仅能选择一个节点。","ONE_TOPIC_MUST_BE_SELECTED":"不能创建节点。必须选择一个节点。","ONLY_ONE_TOPIC_MUST_BE_SELECTED_COLLAPSE":"子节点不能折叠。必须选择一个节点。","SAVE_COULD_NOT_BE_COMPLETED":"保存未完成。稍后再试。","UNEXPECTED_ERROR_LOADING":"抱歉，突遭错误，我们无法处理你的请求。\n尝试重新装载编辑器。如果问题依然存在请联系support@wisemapping.com。","MAIN_TOPIC":"主节点","SUB_TOPIC":"子节点","ISOLATED_TOPIC":"独立节点","CENTRAL_TOPIC":"中心节点","SHORTCUTS":"快捷键","ENTITIES_COULD_NOT_BE_DELETED":"不能删除节点或者关系。至少应选择一个对象。","AT_LEAST_ONE_TOPIC_MUST_BE_SELECTED":"至少应选择一个节点。","CLIPBOARD_IS_EMPTY":"无法拷贝。 粘贴板是空的。","CENTRAL_TOPIC_CAN_NOT_BE_DELETED":"不能删除根节点。","RELATIONSHIP_COULD_NOT_BE_CREATED":"不能创建关系。 应先选择创建关系的一对上级节点。","SELECTION_COPIED_TO_CLIPBOARD":"节点已拷贝到粘贴板。","DUMMY":""};mindplot.Messages.BUNDLES["zh_tw"]={"ZOOM_IN":"放大","ZOOM_OUT":"縮小","TOPIC_SHAPE":"節點外形","TOPIC_ADD":"添加節點","TOPIC_DELETE":"刪除節點","TOPIC_ICON":"加入圖示","TOPIC_LINK":"添加鏈接","TOPIC_RELATIONSHIP":"關係","TOPIC_COLOR":"節點顏色","TOPIC_BORDER_COLOR":"邊框顏色","TOPIC_NOTE":"添加注釋","FONT_FAMILY":"字體","FONT_SIZE":"文字大小","FONT_BOLD":"粗體","FONT_ITALIC":"斜體","UNDO":"撤銷","REDO":"重做","INSERT":"插入","SAVE":"保存","NOTE":"注釋","ADD_TOPIC":"添加節點","LOADING":"載入中……","EXPORT":"導出","PRINT":"列印","PUBLISH":"公開","COLLABORATE":"共用","HISTORY":"歷史","DISCARD_CHANGES":"清除改變","FONT_COLOR":"文本顏色","SAVING":"保存中……","SAVE_COMPLETE":"完成保存","ZOOM_IN_ERROR":"縮放過多。","ZOOM_ERROR":"不能再縮放。","ONLY_ONE_TOPIC_MUST_BE_SELECTED":"不能創建節點。僅能選擇一個節點。","ONE_TOPIC_MUST_BE_SELECTED":"不能創建節點。必須選擇一個節點。","ONLY_ONE_TOPIC_MUST_BE_SELECTED_COLLAPSE":"子節點不能折疊。必須選擇一個節點。","SAVE_COULD_NOT_BE_COMPLETED":"保存未完成。稍後再試。","UNEXPECTED_ERROR_LOADING":"抱歉，突遭錯誤，我們無法處理你的請求。\n嘗試重新裝載編輯器。如果問題依然存在請聯繫support@wisemapping.com。","MAIN_TOPIC":"主節點","SUB_TOPIC":"子節點","ISOLATED_TOPIC":"獨立節點","CENTRAL_TOPIC":"中心節點","SHORTCUTS":"快捷鍵","ENTITIES_COULD_NOT_BE_DELETED":"不能刪除節點或者關係。至少應選擇一個對象。","AT_LEAST_ONE_TOPIC_MUST_BE_SELECTED":"至少應選擇一個節點。","CLIPBOARD_IS_EMPTY":"無法拷貝。 粘貼板是空的。","CENTRAL_TOPIC_CAN_NOT_BE_DELETED":"不能刪除根節點。","RELATIONSHIP_COULD_NOT_BE_CREATED":"不能創建關係。 應先選擇創建關係的一對上級節點。","SELECTION_COPIED_TO_CLIPBOARD":"節點已拷貝到粘貼板。","DUMMY":""};