var web2d={};
web2d.peer={svg:{}};
web2d.peer.utils={};web2d.peer.utils.EventUtils={broadcastChangeEvent:function(elementPeer,type){var listeners=elementPeer.getChangeEventListeners(type);
if(core.Utils.isDefined(listeners)){for(var i=0;
i<listeners.length;
i++){var listener=listeners[i];
listener.call(elementPeer,null)
}}var children=elementPeer.getChildren();
for(var i=0;
i<children.length;
i++){var child=children[i];
web2d.peer.utils.EventUtils.broadcastChangeEvent(child,type)
}}};web2d.peer.utils.TransformUtil={workoutScale:function(elementPeer){var current=elementPeer.getParent();
var width=1;
var height=1;
while(current){var coordSize=current.getCoordSize();
var size=current.getSize();
width=width*(parseInt(size.width)/coordSize.width);
height=height*(parseInt(size.height)/coordSize.height);
current=current.getParent()
}return{width:width,height:height}
}};web2d.peer.svg.ElementPeer=function(svgElement){this._native=svgElement;
this._dblClickListeners=new Hash();
this._size={width:1,height:1};
this._changeListeners={}
};
web2d.peer.svg.ElementPeer.prototype.svgNamespace="http://www.w3.org/2000/svg";
web2d.peer.svg.ElementPeer.prototype.linkNamespace="http://www.w3.org/1999/xlink";
web2d.peer.svg.ElementPeer.prototype.setChildren=function(children){this._children=children
};
web2d.peer.svg.ElementPeer.prototype.getChildren=function(){var result=this._children;
if(!core.Utils.isDefined(result)){result=[];
this._children=result
}return result
};
web2d.peer.svg.ElementPeer.prototype.getParent=function(){return this._parent
};
web2d.peer.svg.ElementPeer.prototype.setParent=function(parent){this._parent=parent
};
web2d.peer.svg.ElementPeer.prototype.appendChild=function(elementPeer){elementPeer.setParent(this);
var children=this.getChildren();
children.include(elementPeer);
this._native.appendChild(elementPeer._native);
web2d.peer.utils.EventUtils.broadcastChangeEvent(this,"strokeStyle")
};
web2d.peer.svg.ElementPeer.prototype.removeChild=function(elementPeer){elementPeer.setParent(null);
var children=this.getChildren();
var length=children.length;
children.remove(elementPeer);
var newLength=children.length;
if(newLength>=length){throw"Could not remove the element."
}this._native.removeChild(elementPeer._native)
};
web2d.peer.svg.ElementPeer.prototype.addEventListener=function(type,listener){if(type=="dblclick"){var dblListener=function(e){if(e.detail>=2){listener.call(this,e)
}};
this._dblClickListeners[listener]=dblListener;
this._native.addEventListener(type,dblListener,false)
}else{this._native.addEventListener(type,listener,false)
}};
web2d.peer.svg.ElementPeer.prototype.removeEventListener=function(type,listener){if(type=="dblclick"){var dblClickListener=this._dblClickListeners[listener];
if(dblClickListener==null){throw"Could not find listener to remove"
}type="click";
this._native.removeEventListener(type,dblClickListener,false);
delete this._dblClickListeners[listener]
}else{this._native.removeEventListener(type,listener,false)
}};
web2d.peer.svg.ElementPeer.prototype.setSize=function(width,height){if(core.Utils.isDefined(width)&&this._size.width!=parseInt(width)){this._size.width=parseInt(width);
this._native.setAttribute("width",parseInt(width))
}if(core.Utils.isDefined(height)&&this._size.height!=parseInt(height)){this._size.height=parseInt(height);
this._native.setAttribute("height",parseInt(height))
}web2d.peer.utils.EventUtils.broadcastChangeEvent(this,"strokeStyle")
};
web2d.peer.svg.ElementPeer.prototype.getSize=function(){return{width:this._size.width,height:this._size.height}
};
web2d.peer.svg.ElementPeer.prototype.setFill=function(color,opacity){if(core.Utils.isDefined(color)){this._native.setAttribute("fill",color)
}if(core.Utils.isDefined(opacity)){this._native.setAttribute("fill-opacity",opacity)
}};
web2d.peer.svg.ElementPeer.prototype.getFill=function(){var color=this._native.getAttribute("fill");
var opacity=this._native.getAttribute("fill-opacity");
return{color:color,opacity:Number(opacity)}
};
web2d.peer.svg.ElementPeer.prototype.getStroke=function(){var vmlStroke=this._native;
var color=vmlStroke.getAttribute("stroke");
var dashstyle=this._stokeStyle;
var opacity=vmlStroke.getAttribute("stroke-opacity");
var width=vmlStroke.getAttribute("stroke-width");
return{color:color,style:dashstyle,opacity:opacity,width:width}
};
web2d.peer.svg.ElementPeer.prototype.__stokeStyleToStrokDasharray={solid:[],dot:[1,3],dash:[4,3],longdash:[10,2],dashdot:[5,3,1,3]};
web2d.peer.svg.ElementPeer.prototype.setStroke=function(width,style,color,opacity){if(core.Utils.isDefined(width)){this._native.setAttribute("stroke-width",width+"px")
}if(core.Utils.isDefined(color)){this._native.setAttribute("stroke",color)
}if(core.Utils.isDefined(style)){var dashArrayPoints=this.__stokeStyleToStrokDasharray[style];
var scale=1/web2d.peer.utils.TransformUtil.workoutScale(this).width;
var strokeWidth=this._native.getAttribute("stroke-width");
strokeWidth=parseFloat(strokeWidth);
var scaledPoints=[];
for(var i=0;
i<dashArrayPoints.length;
i++){scaledPoints[i]=dashArrayPoints[i]*strokeWidth;
scaledPoints[i]=(scaledPoints[i]*scale)+"px"
}this._stokeStyle=style
}if(core.Utils.isDefined(opacity)){this._native.setAttribute("stroke-opacity",opacity)
}};
web2d.peer.svg.ElementPeer.prototype.setVisibility=function(isVisible){this._native.setAttribute("visibility",(isVisible)?"visible":"hidden")
};
web2d.peer.svg.ElementPeer.prototype.isVisible=function(){var visibility=this._native.getAttribute("visibility");
return !(visibility=="hidden")
};
web2d.peer.svg.ElementPeer.prototype.updateStrokeStyle=function(){var strokeStyle=this._stokeStyle;
if(this.getParent()){if(strokeStyle&&strokeStyle!="solid"){this.setStroke(null,strokeStyle)
}}};
web2d.peer.svg.ElementPeer.prototype.attachChangeEventListener=function(type,listener){var listeners=this.getChangeEventListeners(type);
if(!core.Utils.isDefined(listener)){throw"Listener can not be null"
}listeners.push(listener)
};
web2d.peer.svg.ElementPeer.prototype.getChangeEventListeners=function(type){var listeners=this._changeListeners[type];
if(!core.Utils.isDefined(listeners)){listeners=[];
this._changeListeners[type]=listeners
}return listeners
};
web2d.peer.svg.ElementPeer.prototype.moveToFront=function(){this._native.parentNode.appendChild(this._native)
};
web2d.peer.svg.ElementPeer.prototype.moveToBack=function(){this._native.parentNode.insertBefore(this._native,this._native.parentNode.firstChild)
};
web2d.peer.svg.ElementPeer.prototype.setCursor=function(type){this._native.style.cursor=type
};web2d.peer.svg.ElipsePeer=function(){var svgElement=window.document.createElementNS(this.svgNamespace,"ellipse");
web2d.peer.svg.ElementPeer.call(this,svgElement);
this.attachChangeEventListener("strokeStyle",web2d.peer.svg.ElementPeer.prototype.updateStrokeStyle);
this._position={x:0,y:0}
};
objects.extend(web2d.peer.svg.ElipsePeer,web2d.peer.svg.ElementPeer);
web2d.peer.svg.ElipsePeer.prototype.setSize=function(width,height){web2d.peer.svg.ElipsePeer.superClass.setSize.call(this,width,height);
if(core.Utils.isDefined(width)){this._native.setAttribute("rx",width/2)
}if(core.Utils.isDefined(height)){this._native.setAttribute("ry",height/2)
}var pos=this.getPosition();
this.setPosition(pos.x,pos.y)
};
web2d.peer.svg.ElipsePeer.prototype.setPosition=function(cx,cy){var size=this.getSize();
cx=cx+size.width/2;
cy=cy+size.height/2;
if(core.Utils.isDefined(cx)){this._native.setAttribute("cx",cx)
}if(core.Utils.isDefined(cy)){this._native.setAttribute("cy",cy)
}};
web2d.peer.svg.ElipsePeer.prototype.getPosition=function(){return this._position
};web2d.peer.svg.Font=function(){this._size=10;
this._style="normal";
this._weight="normal"
};
web2d.peer.svg.Font.prototype.init=function(args){if(core.Utils.isDefined(args.size)){this._size=parseInt(args.size)
}if(core.Utils.isDefined(args.style)){this._style=args.style
}if(core.Utils.isDefined(args.weight)){this._weight=args.weight
}};
web2d.peer.svg.Font.prototype.getHtmlSize=function(scale){var result=0;
if(this._size==6){result=this._size*scale.height*43/32
}if(this._size==8){result=this._size*scale.height*42/32
}else{if(this._size==10){result=this._size*scale.height*42/32
}else{if(this._size==15){result=this._size*scale.height*42/32
}else{result=this._size*scale.height*42/32
}}}return result
};
web2d.peer.svg.Font.prototype.getGraphSize=function(scale){return this._size*43/32
};
web2d.peer.svg.Font.prototype.getSize=function(){return parseInt(this._size)
};
web2d.peer.svg.Font.prototype.getStyle=function(){return this._style
};
web2d.peer.svg.Font.prototype.getWeight=function(){return this._weight
};
web2d.peer.svg.Font.prototype.setSize=function(size){this._size=size
};
web2d.peer.svg.Font.prototype.setStyle=function(style){this._style=style
};
web2d.peer.svg.Font.prototype.setWeight=function(weight){this._weight=weight
};
web2d.peer.svg.Font.prototype.getWidthMargin=function(){var result=0;
if(this._size==10||this._size==6){result=4
}return result
};web2d.peer.svg.ArialFont=function(){web2d.peer.svg.Font.call(this);
this._fontFamily="Arial"
};
objects.extend(web2d.peer.svg.ArialFont,web2d.peer.svg.Font);
web2d.peer.svg.ArialFont.prototype.getFontFamily=function(){return this._fontFamily
};
web2d.peer.svg.ArialFont.prototype.getFont=function(){return web2d.Font.ARIAL
};web2d.peer.svg.PolyLinePeer=function(){var svgElement=window.document.createElementNS(this.svgNamespace,"polyline");
web2d.peer.svg.ElementPeer.call(this,svgElement);
this.setFill("none");
this.breakDistance=10
};
objects.extend(web2d.peer.svg.PolyLinePeer,web2d.peer.svg.ElementPeer);
web2d.peer.svg.PolyLinePeer.prototype.setFrom=function(x1,y1){this._x1=x1;
this._y1=y1;
this._updatePath()
};
web2d.peer.svg.PolyLinePeer.prototype.setTo=function(x2,y2){this._x2=x2;
this._y2=y2;
this._updatePath()
};
web2d.peer.svg.PolyLinePeer.prototype.setStrokeWidth=function(width){this._native.setAttribute("stroke-width",width)
};
web2d.peer.svg.PolyLinePeer.prototype.setColor=function(color){this._native.setAttribute("stroke",color)
};
web2d.peer.svg.PolyLinePeer.prototype.setStyle=function(style){this._style=style;
this._updatePath()
};
web2d.peer.svg.PolyLinePeer.prototype.getStyle=function(){return this._style
};
web2d.peer.svg.PolyLinePeer.prototype._updatePath=function(){if(this._style=="Curved"){this._updateMiddleCurvePath()
}else{if(this._style=="Straight"){this._updateStraightPath()
}else{this._updateCurvePath()
}}};
web2d.peer.svg.PolyLinePeer.prototype._updateStraightPath=function(){if(core.Utils.isDefined(this._x1)&&core.Utils.isDefined(this._x2)&&core.Utils.isDefined(this._y1)&&core.Utils.isDefined(this._y2)){var path=web2d.PolyLine.buildStraightPath(this.breakDistance,this._x1,this._y1,this._x2,this._y2);
this._native.setAttribute("points",path)
}};
web2d.peer.svg.PolyLinePeer.prototype._updateMiddleCurvePath=function(){var x1=this._x1;
var y1=this._y1;
var x2=this._x2;
var y2=this._y2;
if(core.Utils.isDefined(x1)&&core.Utils.isDefined(x2)&&core.Utils.isDefined(y1)&&core.Utils.isDefined(y2)){var diff=x2-x1;
var middlex=(diff/2)+x1;
var signx=1;
var signy=1;
if(diff<0){signx=-1
}if(y2<y1){signy=-1
}var path=x1+", "+y1+" "+(middlex-10*signx)+", "+y1+" "+middlex+", "+(y1+10*signy)+" "+middlex+", "+(y2-10*signy)+" "+(middlex+10*signx)+", "+y2+" "+x2+", "+y2;
this._native.setAttribute("points",path)
}};
web2d.peer.svg.PolyLinePeer.prototype._updateCurvePath=function(){if(core.Utils.isDefined(this._x1)&&core.Utils.isDefined(this._x2)&&core.Utils.isDefined(this._y1)&&core.Utils.isDefined(this._y2)){var path=web2d.PolyLine.buildCurvedPath(this.breakDistance,this._x1,this._y1,this._x2,this._y2);
this._native.setAttribute("points",path)
}};web2d.peer.svg.CurvedLinePeer=function(){var svgElement=window.document.createElementNS(this.svgNamespace,"path");
web2d.peer.svg.ElementPeer.call(this,svgElement);
this._style={fill:"#495879"};
this._updateStyle();
this._customControlPoint_1=false;
this._customControlPoint_2=false;
this._control1=new core.Point();
this._control2=new core.Point();
this._lineStyle=true
};
objects.extend(web2d.peer.svg.CurvedLinePeer,web2d.peer.svg.ElementPeer);
web2d.peer.svg.CurvedLinePeer.prototype.setSrcControlPoint=function(control){this._customControlPoint_1=true;
var change=this._control1.x!=control.x||this._control1.y!=control.y;
if(core.Utils.isDefined(control.x)){this._control1=control;
this._control1.x=parseInt(this._control1.x);
this._control1.y=parseInt(this._control1.y)
}if(change){this._updatePath()
}};
web2d.peer.svg.CurvedLinePeer.prototype.setDestControlPoint=function(control){this._customControlPoint_2=true;
var change=this._control2.x!=control.x||this._control2.y!=control.y;
if(core.Utils.isDefined(control.x)){this._control2=control;
this._control2.x=parseInt(this._control2.x);
this._control2.y=parseInt(this._control2.y)
}if(change){this._updatePath()
}};
web2d.peer.svg.CurvedLinePeer.prototype.isSrcControlPointCustom=function(){return this._customControlPoint_1
};
web2d.peer.svg.CurvedLinePeer.prototype.isDestControlPointCustom=function(){return this._customControlPoint_2
};
web2d.peer.svg.CurvedLinePeer.prototype.setIsSrcControlPointCustom=function(isCustom){this._customControlPoint_1=isCustom
};
web2d.peer.svg.CurvedLinePeer.prototype.setIsDestControlPointCustom=function(isCustom){this._customControlPoint_2=isCustom
};
web2d.peer.svg.CurvedLinePeer.prototype.getControlPoints=function(){return[this._control1,this._control2]
};
web2d.peer.svg.CurvedLinePeer.prototype.setFrom=function(x1,y1){var change=this._x1!=parseInt(x1)||this._y1!=parseInt(y1);
this._x1=parseInt(x1);
this._y1=parseInt(y1);
if(change){this._updatePath()
}};
web2d.peer.svg.CurvedLinePeer.prototype.setTo=function(x2,y2){var change=this._x2!=parseInt(x2)||this._y2!=parseInt(y2);
this._x2=parseInt(x2);
this._y2=parseInt(y2);
if(change){this._updatePath()
}};
web2d.peer.svg.CurvedLinePeer.prototype.getFrom=function(){return new core.Point(this._x1,this._y1)
};
web2d.peer.svg.CurvedLinePeer.prototype.getTo=function(){return new core.Point(this._x2,this._y2)
};
web2d.peer.svg.CurvedLinePeer.prototype.setStrokeWidth=function(width){this._style["stroke-width"]=width;
this._updateStyle()
};
web2d.peer.svg.CurvedLinePeer.prototype.setColor=function(color){this._style.stroke=color;
this._style.fill=color;
this._updateStyle()
};
web2d.peer.svg.CurvedLinePeer.prototype.updateLine=function(avoidControlPointFix){this._updatePath(avoidControlPointFix)
};
web2d.peer.svg.CurvedLinePeer.prototype.setLineStyle=function(style){this._lineStyle=style;
if(this._lineStyle){this._style.fill=this._fill
}else{this._fill=this._style.fill;
this._style.fill="none"
}this._updateStyle();
this.updateLine()
};
web2d.peer.svg.CurvedLinePeer.prototype.getLineStyle=function(){return this._lineStyle
};
web2d.peer.svg.CurvedLinePeer.prototype.setShowEndArrow=function(visible){this._showEndArrow=visible;
this.updateLine()
};
web2d.peer.svg.CurvedLinePeer.prototype.isShowEndArrow=function(){return this._showEndArrow
};
web2d.peer.svg.CurvedLinePeer.prototype.setShowStartArrow=function(visible){this._showStartArrow=visible;
this.updateLine()
};
web2d.peer.svg.CurvedLinePeer.prototype.isShowStartArrow=function(){return this._showStartArrow
};
web2d.peer.svg.CurvedLinePeer.prototype._updatePath=function(avoidControlPointFix){if(core.Utils.isDefined(this._x1)&&core.Utils.isDefined(this._y1)&&core.Utils.isDefined(this._x2)&&core.Utils.isDefined(this._y2)){this._calculateAutoControlPoints(avoidControlPointFix);
var path="M"+this._x1+","+this._y1+" C"+(this._control1.x+this._x1)+","+(this._control1.y+this._y1)+" "+(this._control2.x+this._x2)+","+(this._control2.y+this._y2)+" "+this._x2+","+this._y2+(this._lineStyle?" "+(this._control2.x+this._x2)+","+(this._control2.y+this._y2+3)+" "+(this._control1.x+this._x1)+","+(this._control1.y+this._y1+5)+" "+this._x1+","+(this._y1+7)+" Z":"");
this._native.setAttribute("d",path)
}};
web2d.peer.svg.CurvedLinePeer.prototype._updateStyle=function(){var style="";
for(var key in this._style){style+=key+":"+this._style[key]+" "
}this._native.setAttribute("style",style)
};
web2d.peer.svg.CurvedLinePeer.prototype._calculateAutoControlPoints=function(avoidControlPointFix){var defaultpoints=core.Utils.calculateDefaultControlPoints(new core.Point(this._x1,this._y1),new core.Point(this._x2,this._y2));
if(!this._customControlPoint_1&&!(core.Utils.isDefined(avoidControlPointFix)&&avoidControlPointFix==0)){this._control1.x=defaultpoints[0].x;
this._control1.y=defaultpoints[0].y
}if(!this._customControlPoint_2&&!(core.Utils.isDefined(avoidControlPointFix)&&avoidControlPointFix==1)){this._control2.x=defaultpoints[1].x;
this._control2.y=defaultpoints[1].y
}};
web2d.peer.svg.CurvedLinePeer.prototype.setDashed=function(length,spacing){if(core.Utils.isDefined(length)&&core.Utils.isDefined(spacing)){this._native.setAttribute("stroke-dasharray",length+","+spacing)
}else{this._native.setAttribute("stroke-dasharray","")
}};web2d.peer.svg.ArrowPeer=function(){var svgElement=window.document.createElementNS(this.svgNamespace,"path");
web2d.peer.svg.ElementPeer.call(this,svgElement);
this._style={};
this._controlPoint=new core.Point();
this._fromPoint=new core.Point()
};
objects.extend(web2d.peer.svg.ArrowPeer,web2d.peer.svg.ElementPeer);
web2d.peer.svg.ArrowPeer.prototype.setFrom=function(x,y){this._fromPoint.x=x;
this._fromPoint.y=y;
this._redraw()
};
web2d.peer.svg.ArrowPeer.prototype.setControlPoint=function(point){this._controlPoint=point;
this._redraw()
};
web2d.peer.svg.ArrowPeer.prototype.setStrokeColor=function(color){this.setStroke(null,null,color,null)
};
web2d.peer.svg.ArrowPeer.prototype.setStrokeWidth=function(width){this.setStroke(width)
};
web2d.peer.svg.ArrowPeer.prototype.setDashed=function(isDashed,length,spacing){if(core.Utils.isDefined(isDashed)&&isDashed&&core.Utils.isDefined(length)&&core.Utils.isDefined(spacing)){this._native.setAttribute("stroke-dasharray",length+","+spacing)
}else{this._native.setAttribute("stroke-dasharray","")
}};
web2d.peer.svg.ArrowPeer.prototype._updateStyle=function(){var style="";
for(var key in this._style){style+=key+":"+this._style[key]+" "
}this._native.setAttribute("style",style)
};
web2d.peer.svg.ArrowPeer.prototype._redraw=function(){var x,y,xp,yp;
if(this._controlPoint.y==0){this._controlPoint.y=1
}var y0=this._controlPoint.y;
var x0=this._controlPoint.x;
var x2=x0+y0;
var y2=y0-x0;
var x3=x0-y0;
var y3=y0+x0;
var m=y2/x2;
var mp=y3/x3;
var l=6;
var pow=Math.pow;
x=(x2==0?0:Math.sqrt(pow(l,2)/(1+pow(m,2))));
x*=Math.sign(x2);
y=(x2==0?l*Math.sign(y2):m*x);
xp=(x3==0?0:Math.sqrt(pow(l,2)/(1+pow(mp,2))));
xp*=Math.sign(x3);
yp=(x3==0?l*Math.sign(y3):mp*xp);
var path="M"+this._fromPoint.x+","+this._fromPoint.y+" L"+(x+this._fromPoint.x)+","+(y+this._fromPoint.y)+"M"+this._fromPoint.x+","+this._fromPoint.y+" L"+(xp+this._fromPoint.x)+","+(yp+this._fromPoint.y);
this._native.setAttribute("d",path)
};web2d.peer.svg.TextPeer=function(){var svgElement=window.document.createElementNS(this.svgNamespace,"text");
web2d.peer.svg.ElementPeer.call(this,svgElement);
this._native.setAttribute("focusable","true");
this._position={x:0,y:0};
this._font=new web2d.Font("Arial",this)
};
objects.extend(web2d.peer.svg.TextPeer,web2d.peer.svg.ElementPeer);
web2d.peer.svg.TextPeer.prototype.appendChild=function(element){this._native.appendChild(element._native)
};
web2d.peer.svg.TextPeer.prototype.setText=function(text){text=core.Utils.escapeInvalidTags(text);
var child=this._native.firstChild;
if(core.Utils.isDefined(child)){this._native.removeChild(child)
}this._text=text;
var textNode=window.document.createTextNode(text);
this._native.appendChild(textNode)
};
web2d.peer.svg.TextPeer.prototype.getText=function(){return this._text
};
web2d.peer.svg.TextPeer.prototype.setPosition=function(x,y){this._position={x:x,y:y};
var height=this._font.getSize();
if(core.Utils.isDefined(this._parent)&&core.Utils.isDefined(this._native.getBBox)){height=this.getHeight()
}var size=parseInt(height);
this._native.setAttribute("y",y+size*3/4);
this._native.setAttribute("x",x)
};
web2d.peer.svg.TextPeer.prototype.getPosition=function(){return this._position
};
web2d.peer.svg.TextPeer.prototype.setFont=function(font,size,style,weight){if(core.Utils.isDefined(font)){this._font=new web2d.Font(font,this)
}if(core.Utils.isDefined(style)){this._font.setStyle(style)
}if(core.Utils.isDefined(weight)){this._font.setWeight(weight)
}if(core.Utils.isDefined(size)){this._font.setSize(size)
}this._updateFontStyle()
};
web2d.peer.svg.TextPeer.prototype._updateFontStyle=function(){this._native.setAttribute("font-family",this._font.getFontFamily());
this._native.setAttribute("font-size",this._font.getGraphSize());
this._native.setAttribute("font-style",this._font.getStyle());
this._native.setAttribute("font-weight",this._font.getWeight());
var scale=this._font.getFontScale();
this._native.xFontScale=scale.toFixed(1)
};
web2d.peer.svg.TextPeer.prototype.setColor=function(color){this._native.setAttribute("fill",color)
};
web2d.peer.svg.TextPeer.prototype.getColor=function(){return this._native.getAttribute("fill")
};
web2d.peer.svg.TextPeer.prototype.setTextSize=function(size){this._font.setSize(size);
this._updateFontStyle()
};
web2d.peer.svg.TextPeer.prototype.setContentSize=function(width,height){this._native.xTextSize=width.toFixed(1)+","+height.toFixed(1)
};
web2d.peer.svg.TextPeer.prototype.setStyle=function(style){this._font.setStyle(style);
this._updateFontStyle()
};
web2d.peer.svg.TextPeer.prototype.setWeight=function(weight){this._font.setWeight(weight);
this._updateFontStyle()
};
web2d.peer.svg.TextPeer.prototype.setFontFamily=function(family){var oldFont=this._font;
this._font=new web2d.Font(family,this);
this._font.setSize(oldFont.getSize());
this._font.setStyle(oldFont.getStyle());
this._font.setWeight(oldFont.getWeight());
this._updateFontStyle()
};
web2d.peer.svg.TextPeer.prototype.getFont=function(){return{font:this._font.getFont(),size:parseInt(this._font.getSize()),style:this._font.getStyle(),weight:this._font.getWeight()}
};
web2d.peer.svg.TextPeer.prototype.setSize=function(size){this._font.setSize(size);
this._updateFontStyle()
};
web2d.peer.svg.TextPeer.prototype.getWidth=function(){var computedWidth=this._native.getBBox().width;
var width=parseInt(computedWidth);
width=width+this._font.getWidthMargin();
return width
};
web2d.peer.svg.TextPeer.prototype.getHeight=function(){var computedHeight=this._native.getBBox().height;
return parseInt(computedHeight)
};
web2d.peer.svg.TextPeer.prototype.getHtmlFontSize=function(){return this._font.getHtmlSize()
};web2d.peer.svg.WorkspacePeer=function(element){this._element=element;
var svgElement=window.document.createElementNS(this.svgNamespace,"svg");
web2d.peer.svg.ElementPeer.call(this,svgElement);
this._native.setAttribute("focusable","true");
this._native.setAttribute("id","workspace")
};
objects.extend(web2d.peer.svg.WorkspacePeer,web2d.peer.svg.ElementPeer);
web2d.peer.svg.WorkspacePeer.prototype.setCoordSize=function(width,height){var viewBox=this._native.getAttribute("viewBox");
var coords=[0,0,0,0];
if(viewBox!=null){coords=viewBox.split(/ /)
}if(core.Utils.isDefined(width)){coords[2]=width
}if(core.Utils.isDefined(height)){coords[3]=height
}this._native.setAttribute("viewBox",coords.join(" "));
this._native.setAttribute("preserveAspectRatio","none");
web2d.peer.utils.EventUtils.broadcastChangeEvent(this,"strokeStyle")
};
web2d.peer.svg.WorkspacePeer.prototype.getCoordSize=function(){var viewBox=this._native.getAttribute("viewBox");
var coords=[1,1,1,1];
if(viewBox!=null){coords=viewBox.split(/ /)
}return{width:coords[2],height:coords[3]}
};
web2d.peer.svg.WorkspacePeer.prototype.setCoordOrigin=function(x,y){var viewBox=this._native.getAttribute("viewBox");
var coords=[0,0,0,0];
if(viewBox!=null){coords=viewBox.split(/ /)
}if(core.Utils.isDefined(x)){coords[0]=x
}if(core.Utils.isDefined(y)){coords[1]=y
}this._native.setAttribute("viewBox",coords.join(" "))
};
web2d.peer.svg.WorkspacePeer.prototype.appendChild=function(child){web2d.peer.svg.WorkspacePeer.superClass.appendChild.call(this,child);
web2d.peer.utils.EventUtils.broadcastChangeEvent(child,"onChangeCoordSize")
};
web2d.peer.svg.WorkspacePeer.prototype.getCoordOrigin=function(child){var viewBox=this._native.getAttribute("viewBox");
var coords=[1,1,1,1];
if(viewBox!=null){coords=viewBox.split(/ /)
}var x=parseFloat(coords[0]);
var y=parseFloat(coords[1]);
return{x:x,y:y}
};
web2d.peer.svg.WorkspacePeer.prototype.getPosition=function(){return{x:0,y:0}
};web2d.peer.svg.GroupPeer=function(){var svgElement=window.document.createElementNS(this.svgNamespace,"g");
web2d.peer.svg.ElementPeer.call(this,svgElement);
this._native.setAttribute("preserveAspectRatio","none");
this._coordSize={width:1,height:1};
this._native.setAttribute("focusable","true");
this._position={x:0,y:0};
this._coordOrigin={x:0,y:0}
};
objects.extend(web2d.peer.svg.GroupPeer,web2d.peer.svg.ElementPeer);
web2d.peer.svg.GroupPeer.prototype.setCoordSize=function(width,height){var change=this._coordSize.width!=width||this._coordSize.height!=height;
this._coordSize.width=width;
this._coordSize.height=height;
if(change){this.updateTransform()
}web2d.peer.utils.EventUtils.broadcastChangeEvent(this,"strokeStyle")
};
web2d.peer.svg.GroupPeer.prototype.getCoordSize=function(){return{width:this._coordSize.width,height:this._coordSize.height}
};
web2d.peer.svg.GroupPeer.prototype.updateTransform=function(){var sx=this._size.width/this._coordSize.width;
var sy=this._size.height/this._coordSize.height;
var cx=this._position.x-this._coordOrigin.x*sx;
var cy=this._position.y-this._coordOrigin.y*sy;
this._native.setAttribute("transform","translate("+cx+","+cy+") scale("+sx+","+sy+")")
};
web2d.peer.svg.GroupPeer.prototype.setCoordOrigin=function(x,y){var change=x!=this._coordOrigin.x||y!=this._coordOrigin.y;
if(core.Utils.isDefined(x)){this._coordOrigin.x=x
}if(core.Utils.isDefined(y)){this._coordOrigin.y=y
}if(change){this.updateTransform()
}};
web2d.peer.svg.GroupPeer.prototype.setSize=function(width,height){var change=width!=this._size.width||height!=this._size.height;
web2d.peer.svg.GroupPeer.superClass.setSize.call(this,width,height);
if(change){this.updateTransform()
}};
web2d.peer.svg.GroupPeer.prototype.setPosition=function(x,y){var change=x!=this._position.x||y!=this._position.y;
if(core.Utils.isDefined(x)){this._position.x=parseInt(x)
}if(core.Utils.isDefined(y)){this._position.y=parseInt(y)
}if(change){this.updateTransform()
}};
web2d.peer.svg.GroupPeer.prototype.getPosition=function(){return{x:this._position.x,y:this._position.y}
};
web2d.peer.svg.GroupPeer.prototype.appendChild=function(child){web2d.peer.svg.GroupPeer.superClass.appendChild.call(this,child);
web2d.peer.utils.EventUtils.broadcastChangeEvent(child,"onChangeCoordSize")
};
web2d.peer.svg.GroupPeer.prototype.getCoordOrigin=function(){return{x:this._coordOrigin.x,y:this._coordOrigin.y}
};web2d.peer.svg.RectPeer=function(arc){var svgElement=window.document.createElementNS(this.svgNamespace,"rect");
web2d.peer.svg.ElementPeer.call(this,svgElement);
this._arc=arc;
this.attachChangeEventListener("strokeStyle",web2d.peer.svg.ElementPeer.prototype.updateStrokeStyle)
};
objects.extend(web2d.peer.svg.RectPeer,web2d.peer.svg.ElementPeer);
web2d.peer.svg.RectPeer.prototype.setPosition=function(x,y){if(core.Utils.isDefined(x)){this._native.setAttribute("x",parseInt(x))
}if(core.Utils.isDefined(y)){this._native.setAttribute("y",parseInt(y))
}};
web2d.peer.svg.RectPeer.prototype.getPosition=function(){var x=this._native.getAttribute("x");
var y=this._native.getAttribute("y");
return{x:parseInt(x),y:parseInt(y)}
};
web2d.peer.svg.RectPeer.prototype.setSize=function(width,height){web2d.peer.svg.RectPeer.superClass.setSize.call(this,width,height);
var min=width<height?width:height;
if(core.Utils.isDefined(this._arc)){var arc=(min/2)*this._arc;
this._native.setAttribute("rx",arc);
this._native.setAttribute("ry",arc)
}};web2d.peer.svg.ImagePeer=function(){var svgElement=window.document.createElementNS(this.svgNamespace,"image");
web2d.peer.svg.ElementPeer.call(this,svgElement);
this._position={x:0,y:0};
this._href=""
};
objects.extend(web2d.peer.svg.ImagePeer,web2d.peer.svg.ElementPeer);
web2d.peer.svg.ImagePeer.prototype.setPosition=function(x,y){this._position={x:x,y:y};
this._native.setAttribute("y",y);
this._native.setAttribute("x",x)
};
web2d.peer.svg.ImagePeer.prototype.getPosition=function(){return this._position
};
web2d.peer.svg.ImagePeer.prototype.setHref=function(url){this._native.setAttributeNS(this.linkNamespace,"href",url);
this._href=url
};
web2d.peer.svg.ImagePeer.prototype.getHref=function(){return this._href
};web2d.peer.svg.TimesFont=function(){web2d.peer.svg.Font.call(this);
this._fontFamily="times"
};
objects.extend(web2d.peer.svg.TimesFont,web2d.peer.svg.Font);
web2d.peer.svg.TimesFont.prototype.getFontFamily=function(){return this._fontFamily
};
web2d.peer.svg.TimesFont.prototype.getFont=function(){return web2d.Font.TIMES
};web2d.peer.svg.LinePeer=function(){var svgElement=window.document.createElementNS(this.svgNamespace,"line");
web2d.peer.svg.ElementPeer.call(this,svgElement);
this.attachChangeEventListener("strokeStyle",web2d.peer.svg.ElementPeer.prototype.updateStrokeStyle)
};
objects.extend(web2d.peer.svg.LinePeer,web2d.peer.svg.ElementPeer);
web2d.peer.svg.LinePeer.prototype.setFrom=function(x1,y1){this._x1=x1;
this._y1=y1;
this._native.setAttribute("x1",x1);
this._native.setAttribute("y1",y1)
};
web2d.peer.svg.LinePeer.prototype.setTo=function(x2,y2){this._x2=x2;
this._y2=y2;
this._native.setAttribute("x2",x2);
this._native.setAttribute("y2",y2)
};
web2d.peer.svg.LinePeer.prototype.getFrom=function(){return new core.Point(this._x1,this._y1)
};
web2d.peer.svg.LinePeer.prototype.getTo=function(){return new core.Point(this._x2,this._y2)
};
web2d.peer.svg.LinePeer.prototype.setArrowStyle=function(startStyle,endStyle){if(core.Utils.isDefined(startStyle)){}if(core.Utils.isDefined(endStyle)){}};web2d.peer.svg.TahomaFont=function(){web2d.peer.svg.Font.call(this);
this._fontFamily="tahoma"
};
objects.extend(web2d.peer.svg.TahomaFont,web2d.peer.svg.Font);
web2d.peer.svg.TahomaFont.prototype.getFontFamily=function(){return this._fontFamily
};
web2d.peer.svg.TahomaFont.prototype.getFont=function(){return web2d.Font.TAHOMA
};web2d.peer.svg.VerdanaFont=function(){web2d.peer.svg.Font.call(this);
this._fontFamily="verdana"
};
objects.extend(web2d.peer.svg.VerdanaFont,web2d.peer.svg.Font);
web2d.peer.svg.VerdanaFont.prototype.getFontFamily=function(){return this._fontFamily
};
web2d.peer.svg.VerdanaFont.prototype.getFont=function(){return web2d.Font.VERDANA
};web2d.Element=function(peer,attributes){this._peer=peer;
if(peer==null){throw"Element peer can not be null"
}this._dispatcherByEventType=new Hash({});
if(core.Utils.isDefined(attributes)){this._initialize(attributes)
}};
web2d.Element.prototype._SIGNATURE_MULTIPLE_ARGUMENTS=-1;
web2d.Element.prototype._initialize=function(attributes){var batchExecute={};
for(var key in attributes){var funcName=this._attributeNameToFuncName(key,"set");
var funcArgs=batchExecute[funcName];
if(!core.Utils.isDefined(funcArgs)){funcArgs=[]
}var signature=this._propertyNameToSignature[key];
var argPositions=signature[1];
if(argPositions!=this._SIGNATURE_MULTIPLE_ARGUMENTS){funcArgs[argPositions]=attributes[key]
}else{funcArgs=attributes[key].split(" ")
}batchExecute[funcName]=funcArgs
}for(var key in batchExecute){var func=this[key];
if(!core.Utils.isDefined(func)){throw"Could not find function: "+key
}func.apply(this,batchExecute[key])
}};
web2d.Element.prototype.setSize=function(width,height){this._peer.setSize(width,height)
};
web2d.Element.prototype.setPosition=function(cx,cy){this._peer.setPosition(cx,cy)
};
web2d.Element.prototype._supportedEvents=["click","dblclick","mousemove","mouseout","mouseover","mousedown","mouseup"];
web2d.Element.prototype.addEventListener=function(type,listener){if(!this._supportedEvents.include(type)){throw"Unsupported event type: "+type
}if(!this._dispatcherByEventType[type]){this._dispatcherByEventType[type]=new web2d.EventDispatcher(this);
var eventListener=this._dispatcherByEventType[type].eventListener;
this._peer.addEventListener(type,eventListener)
}this._dispatcherByEventType[type].addListener(type,listener)
};
web2d.Element.prototype.removeEventListener=function(type,listener){var dispatcher=this._dispatcherByEventType[type];
if(dispatcher==null){throw"There is no listener previously registered"
}var result=dispatcher.removeListener(type,listener);
if(dispatcher.getListenersCount()<=0){this._peer.removeEventListener(type,dispatcher.eventListener);
this._dispatcherByEventType[type]=null
}};
web2d.Element.prototype.getType=function(){throw"Not implemeneted yet. This method must be implemented by all the inherited objects."
};
web2d.Element.prototype.getFill=function(){return this._peer.getFill()
};
web2d.Element.prototype.setFill=function(color,opacity){this._peer.setFill(color,opacity)
};
web2d.Element.prototype.getPosition=function(){return this._peer.getPosition()
};
web2d.Element.prototype.setStroke=function(width,style,color,opacity){if(style!=null&&style!=undefined&&style!="dash"&&style!="dot"&&style!="solid"&&style!="longdash"&&style!="dashdot"){throw"Unsupported stroke style: '"+style+"'"
}this._peer.setStroke(width,style,color,opacity)
};
web2d.Element.prototype._propertyNameToSignature={size:["size",-1],width:["size",0,"width"],height:["size",1,"height"],position:["position",-1],x:["position",0,"x"],y:["position",1,"y"],stroke:["stroke",-1],strokeWidth:["stroke",0,"width"],strokeStyle:["stroke",1,"style"],strokeColor:["stroke",2,"color"],strokeOpacity:["stroke",3,"opacity"],fill:["fill",-1],fillColor:["fill",0,"color"],fillOpacity:["fill",1,"opacity"],coordSize:["coordSize",-1],coordSizeWidth:["coordSize",0,"width"],coordSizeHeight:["coordSize",1,"height"],coordOrigin:["coordOrigin",-1],coordOriginX:["coordOrigin",0,"x"],coordOriginY:["coordOrigin",1,"y"],visibility:["visibility",0],opacity:["opacity",0]};
web2d.Element.prototype._attributeNameToFuncName=function(attributeKey,prefix){var signature=this._propertyNameToSignature[attributeKey];
if(!core.Utils.isDefined(signature)){throw"Unsupported attribute: "+attributeKey
}var firstLetter=signature[0].charAt(0);
return prefix+firstLetter.toUpperCase()+signature[0].substring(1)
};
web2d.Element.prototype.setAttribute=function(key,value){var funcName=this._attributeNameToFuncName(key,"set");
var signature=this._propertyNameToSignature[key];
if(signature==null){throw"Could not find the signature for:"+key
}var argPositions=signature[1];
var args=[];
if(argPositions!==this._SIGNATURE_MULTIPLE_ARGUMENTS){args[argPositions]=value
}else{if(typeof value=="array"){args=value
}else{var strValue=String(value);
args=strValue.split(" ")
}}var setter=this[funcName];
if(setter==null){throw"Could not find the function name:"+funcName
}setter.apply(this,args)
};
web2d.Element.prototype.getAttribute=function(key){var funcName=this._attributeNameToFuncName(key,"get");
var signature=this._propertyNameToSignature[key];
if(signature==null){throw"Could not find the signature for:"+key
}var getter=this[funcName];
if(getter==null){throw"Could not find the function name:"+funcName
}var getterResult=getter.apply(this,[]);
var attibuteName=signature[2];
if(!core.Utils.isDefined(attibuteName)){throw"Could not find attribute mapping for:"+key
}var result=getterResult[attibuteName];
if(!core.Utils.isDefined(result)){throw"Could not find attribute with name:"+attibuteName
}return result
};
web2d.Element.prototype.setOpacity=function(opacity){this._peer.setStroke(null,null,null,opacity);
this._peer.setFill(null,opacity)
};
web2d.Element.prototype.setVisibility=function(isVisible){this._peer.setVisibility(isVisible)
};
web2d.Element.prototype.isVisible=function(){return this._peer.isVisible()
};
web2d.Element.prototype.moveToFront=function(){this._peer.moveToFront()
};
web2d.Element.prototype.moveToBack=function(){this._peer.moveToBack()
};
web2d.Element.prototype.getStroke=function(){return this._peer.getStroke()
};
web2d.Element.prototype.setCursor=function(type){this._peer.setCursor(type)
};
web2d.Element.prototype.getParent=function(){return this._peer.getParent()
};web2d.Elipse=function(attributes){var peer=web2d.peer.Toolkit.createElipse();
var defaultAttributes={width:40,height:40,x:5,y:5,stroke:"1 solid black",fillColor:"blue"};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}web2d.Element.call(this,peer,defaultAttributes)
};
objects.extend(web2d.Elipse,web2d.Element);
web2d.Elipse.prototype.getType=function(){return"Elipse"
};
web2d.Elipse.prototype.getSize=function(){return this._peer.getSize()
};web2d.EventDispatcher=function(element){this._listeners=[];
var dispatcher=this;
this.eventListener=function(event){for(var i=0;
i<dispatcher._listeners.length;
i++){if(dispatcher._listeners[i]!=null){dispatcher._listeners[i].call(element,event||window.event)
}}}
};
web2d.EventDispatcher.prototype.addListener=function(type,listener){if(!core.Utils.isDefined(listener)){throw"Listener can not be null."
}this._listeners.include(listener)
};
web2d.EventDispatcher.prototype.removeListener=function(type,listener){if(!core.Utils.isDefined(listener)){throw"Listener can not be null."
}var length=this._listeners.length;
this._listeners.remove(listener);
var newLength=this._listeners.length;
if(newLength>=length){throw"There is not listener to remove"
}};
web2d.EventDispatcher.prototype.getListenersCount=function(){return this._listeners.length
};web2d.Font=function(fontFamily,textPeer){var font="web2d.peer.Toolkit.create"+fontFamily+"Font();";
this._peer=eval(font);
this._textPeer=textPeer
};
web2d.Font.prototype.getHtmlSize=function(){var scale=web2d.peer.utils.TransformUtil.workoutScale(this._textPeer);
return this._peer.getHtmlSize(scale)
};
web2d.Font.prototype.getGraphSize=function(){var scale=web2d.peer.utils.TransformUtil.workoutScale(this._textPeer);
return this._peer.getGraphSize(scale)
};
web2d.Font.prototype.getFontScale=function(){return web2d.peer.utils.TransformUtil.workoutScale(this._textPeer).height
};
web2d.Font.prototype.getSize=function(){return this._peer.getSize()
};
web2d.Font.prototype.getStyle=function(){return this._peer.getStyle()
};
web2d.Font.prototype.getWeight=function(){return this._peer.getWeight()
};
web2d.Font.prototype.getFontFamily=function(){return this._peer.getFontFamily()
};
web2d.Font.prototype.setSize=function(size){return this._peer.setSize(size)
};
web2d.Font.prototype.setStyle=function(style){return this._peer.setStyle(style)
};
web2d.Font.prototype.setWeight=function(weight){return this._peer.setWeight(weight)
};
web2d.Font.prototype.getFont=function(){return this._peer.getFont()
};
web2d.Font.prototype.getWidthMargin=function(){return this._peer.getWidthMargin()
};
web2d.Font.ARIAL="Arial";
web2d.Font.TIMES="Times";
web2d.Font.TAHOMA="Tahoma";
web2d.Font.VERDANA="Verdana";web2d.Group=function(attributes){var peer=web2d.peer.Toolkit.createGroup();
var defaultAttributes={width:50,height:50,x:50,y:50,coordOrigin:"0 0",coordSize:"50 50"};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}web2d.Element.call(this,peer,defaultAttributes)
};
objects.extend(web2d.Group,web2d.Element);
web2d.Group.prototype.removeChild=function(element){if(!core.Utils.isDefined(element)){throw"Child element can not be null"
}if(element==this){throw"It's not posible to add the group as a child of itself"
}var elementType=element.getType();
if(elementType==null){throw"It seems not to be an element ->"+element
}this._peer.removeChild(element._peer)
};
web2d.Group.prototype.appendChild=function(element){if(!core.Utils.isDefined(element)){throw"Child element can not be null"
}if(element==this){throw"It's not posible to add the group as a child of itself"
}var elementType=element.getType();
if(elementType==null){throw"It seems not to be an element ->"+element
}if(elementType=="Workspace"){throw"A group can not have a workspace as a child"
}this._peer.appendChild(element._peer)
};
web2d.Group.prototype.getType=function(){return"Group"
};
web2d.Group.prototype.setCoordSize=function(width,height){this._peer.setCoordSize(width,height)
};
web2d.Group.prototype.getCoordSize=function(){return this.peer.getCoordSize()
};
web2d.Group.prototype.setCoordOrigin=function(x,y){this._peer.setCoordOrigin(x,y)
};
web2d.Group.prototype.getCoordOrigin=function(){return this._peer.getCoordOrigin()
};
web2d.Group.prototype.getSize=function(){return this._peer.getSize()
};
web2d.Group.prototype.setFill=function(color,opacity){throw"Unsupported operation. Fill can not be set to a group"
};
web2d.Group.prototype.setStroke=function(width,style,color,opacity){throw"Unsupported operation. Stroke can not be set to a group"
};
web2d.Group.prototype.getCoordSize=function(){return this._peer.getCoordSize()
};
web2d.Group.prototype.appendDomChild=function(DomElement){if(!core.Utils.isDefined(DomElement)){throw"Child element can not be null"
}if(DomElement==this){throw"It's not posible to add the group as a child of itself"
}this._peer._native.appendChild(DomElement)
};web2d.Image=function(attributes){var peer=web2d.peer.Toolkit.createImage();
web2d.Element.call(this,peer,attributes)
};
objects.extend(web2d.Image,web2d.Element);
web2d.Image.prototype.getType=function(){return"Image"
};
web2d.Image.prototype.setHref=function(href){this._peer.setHref(href)
};
web2d.Image.prototype.getHref=function(){return this._peer.getHref()
};
web2d.Image.prototype.getSize=function(){return this._peer.getSize()
};web2d.Line=function(attributes){var peer=web2d.peer.Toolkit.createLine();
var defaultAttributes={strokeColor:"#495879",strokeWidth:1,strokeOpacity:1};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}web2d.Element.call(this,peer,defaultAttributes)
};
objects.extend(web2d.Line,web2d.Element);
web2d.Line.prototype.getType=function(){return"Line"
};
web2d.Line.prototype.setFrom=function(x,y){this._peer.setFrom(x,y)
};
web2d.Line.prototype.setTo=function(x,y){this._peer.setTo(x,y)
};
web2d.Line.prototype.getFrom=function(){return this._peer.getFrom()
};
web2d.Line.prototype.getTo=function(){return this._peer.getTo()
};
web2d.Line.prototype.setArrowStyle=function(startStyle,endStyle){this._peer.setArrowStyle(startStyle,endStyle)
};
web2d.Line.prototype.setPosition=function(cx,cy){throw"Unsupported operation"
};
web2d.Line.prototype.setSize=function(width,height){throw"Unsupported operation"
};
web2d.Line.prototype.setFill=function(color,opacity){throw"Unsupported operation"
};web2d.PolyLine=function(attributes){var peer=web2d.peer.Toolkit.createPolyLine();
var defaultAttributes={strokeColor:"blue",strokeWidth:1,strokeStyle:"solid",strokeOpacity:1};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}web2d.Element.call(this,peer,defaultAttributes)
};
objects.extend(web2d.PolyLine,web2d.Element);
web2d.PolyLine.prototype.getType=function(){return"PolyLine"
};
web2d.PolyLine.prototype.setFrom=function(x,y){this._peer.setFrom(x,y)
};
web2d.PolyLine.prototype.setTo=function(x,y){this._peer.setTo(x,y)
};
web2d.PolyLine.prototype.setStyle=function(style){this._peer.setStyle(style)
};
web2d.PolyLine.prototype.getStyle=function(){return this._peer.getStyle()
};
web2d.PolyLine.buildCurvedPath=function(dist,x1,y1,x2,y2){var signx=1;
var signy=1;
if(x2<x1){signx=-1
}if(y2<y1){signy=-1
}var path;
if(Math.abs(y1-y2)>2){var middlex=x1+((x2-x1>0)?dist:-dist);
path=x1.toFixed(1)+", "+y1.toFixed(1)+" "+middlex.toFixed(1)+", "+y1.toFixed(1)+" "+middlex.toFixed(1)+", "+(y2-5*signy).toFixed(1)+" "+(middlex+5*signx).toFixed(1)+", "+y2.toFixed(1)+" "+x2.toFixed(1)+", "+y2.toFixed(1)
}else{path=x1.toFixed(1)+", "+y1.toFixed(1)+" "+x2.toFixed(1)+", "+y2.toFixed(1)
}return path
};
web2d.PolyLine.buildStraightPath=function(dist,x1,y1,x2,y2){var middlex=x1+((x2-x1>0)?dist:-dist);
return x1+", "+y1+" "+middlex+", "+y1+" "+middlex+", "+y2+" "+x2+", "+y2
};web2d.CurvedLine=function(attributes){var peer=web2d.peer.Toolkit.createCurvedLine();
var defaultAttributes={strokeColor:"blue",strokeWidth:1,strokeStyle:"solid",strokeOpacity:1};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}web2d.Element.call(this,peer,defaultAttributes)
};
objects.extend(web2d.CurvedLine,web2d.Element);
web2d.CurvedLine.prototype.getType=function(){return"CurvedLine"
};
web2d.CurvedLine.prototype.setFrom=function(x,y){this._peer.setFrom(x,y)
};
web2d.CurvedLine.prototype.setTo=function(x,y){this._peer.setTo(x,y)
};
web2d.CurvedLine.prototype.getFrom=function(){return this._peer.getFrom()
};
web2d.CurvedLine.prototype.getTo=function(){return this._peer.getTo()
};
web2d.CurvedLine.prototype.setShowEndArrow=function(visible){this._peer.setShowEndArrow(visible)
};
web2d.CurvedLine.prototype.isShowEndArrow=function(){return this._peer.isShowEndArrow()
};
web2d.CurvedLine.prototype.setShowStartArrow=function(visible){this._peer.setShowStartArrow(visible)
};
web2d.CurvedLine.prototype.isShowStartArrow=function(){return this._peer.isShowStartArrow()
};
web2d.CurvedLine.prototype.setSrcControlPoint=function(control){this._peer.setSrcControlPoint(control)
};
web2d.CurvedLine.prototype.setDestControlPoint=function(control){this._peer.setDestControlPoint(control)
};
web2d.CurvedLine.prototype.getControlPoints=function(){return this._peer.getControlPoints()
};
web2d.CurvedLine.prototype.isSrcControlPointCustom=function(){return this._peer.isSrcControlPointCustom()
};
web2d.CurvedLine.prototype.isDestControlPointCustom=function(){return this._peer.isDestControlPointCustom()
};
web2d.CurvedLine.prototype.setIsSrcControlPointCustom=function(isCustom){this._peer.setIsSrcControlPointCustom(isCustom)
};
web2d.CurvedLine.prototype.setIsDestControlPointCustom=function(isCustom){this._peer.setIsDestControlPointCustom(isCustom)
};
web2d.CurvedLine.prototype.updateLine=function(avoidControlPointFix){return this._peer.updateLine(avoidControlPointFix)
};
web2d.CurvedLine.prototype.setStyle=function(style){this._peer.setLineStyle(style)
};
web2d.CurvedLine.prototype.getStyle=function(){return this._peer.getLineStyle()
};
web2d.CurvedLine.prototype.setDashed=function(length,spacing){this._peer.setDashed(length,spacing)
};
web2d.CurvedLine.SIMPLE_LINE=false;
web2d.CurvedLine.NICE_LINE=true;web2d.Arrow=function(attributes){var peer=web2d.peer.Toolkit.createArrow();
var defaultAttributes={strokeColor:"black",strokeWidth:1,strokeStyle:"solid",strokeOpacity:1};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}web2d.Element.call(this,peer,defaultAttributes)
};
objects.extend(web2d.Arrow,web2d.Element);
web2d.Arrow.prototype.getType=function(){return"Arrow"
};
web2d.Arrow.prototype.setFrom=function(x,y){this._peer.setFrom(x,y)
};
web2d.Arrow.prototype.setControlPoint=function(point){this._peer.setControlPoint(point)
};
web2d.Arrow.prototype.setStrokeColor=function(color){this._peer.setStrokeColor(color)
};
web2d.Arrow.prototype.setStrokeWidth=function(width){this._peer.setStrokeWidth(width)
};
web2d.Arrow.prototype.setDashed=function(isDashed,length,spacing){this._peer.setDashed(isDashed,length,spacing)
};
web2d.Arrow.prototype.reDraw=function(){this._peer._redraw()
};web2d.Rect=function(arc,attributes){if(arc&&arc>1){throw"Arc must be 0<=arc<=1"
}if(arguments.length<=0){var rx=0;
var ry=0
}var peer=web2d.peer.Toolkit.createRect(arc);
var defaultAttributes={width:40,height:40,x:5,y:5,stroke:"1 solid black",fillColor:"green"};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}web2d.Element.call(this,peer,defaultAttributes)
};
objects.extend(web2d.Rect,web2d.Element);
web2d.Rect.prototype.getType=function(){return"Rect"
};
web2d.Rect.prototype.getSize=function(){return this._peer.getSize()
};web2d.Text=function(attributes){var peer=web2d.peer.Toolkit.createText();
web2d.Element.call(this,peer,attributes)
};
objects.extend(web2d.Text,web2d.Element);
web2d.Text.prototype.getType=function(){return"Text"
};
web2d.Text.prototype.setText=function(text){this._peer.setText(text)
};
web2d.Text.prototype.setTextSize=function(width,height){this._peer.setContentSize(width,height)
};
web2d.Text.prototype.getText=function(){return this._peer.getText()
};
web2d.Text.prototype.setFont=function(font,size,style,weight){this._peer.setFont(font,size,style,weight)
};
web2d.Text.prototype.setColor=function(color){this._peer.setColor(color)
};
web2d.Text.prototype.getColor=function(){return this._peer.getColor()
};
web2d.Text.prototype.setStyle=function(style){this._peer.setStyle(style)
};
web2d.Text.prototype.setWeight=function(weight){this._peer.setWeight(weight)
};
web2d.Text.prototype.setFontFamily=function(family){this._peer.setFontFamily(family)
};
web2d.Text.prototype.getFont=function(){return this._peer.getFont()
};
web2d.Text.prototype.setSize=function(size){this._peer.setSize(size)
};
web2d.Text.prototype.getHtmlFontSize=function(){return this._peer.getHtmlFontSize()
};
web2d.Text.prototype.getWidth=function(){return this._peer.getWidth()
};
web2d.Text.prototype.getHeight=function(){return parseInt(this._peer.getHeight())
};web2d.peer.ToolkitSVG={init:function(){},createWorkspace:function(element){return new web2d.peer.svg.WorkspacePeer(element)
},createGroup:function(element){return new web2d.peer.svg.GroupPeer()
},createElipse:function(){return new web2d.peer.svg.ElipsePeer()
},createLine:function(){return new web2d.peer.svg.LinePeer()
},createPolyLine:function(){return new web2d.peer.svg.PolyLinePeer()
},createCurvedLine:function(){return new web2d.peer.svg.CurvedLinePeer()
},createArrow:function(){return new web2d.peer.svg.ArrowPeer()
},createText:function(){return new web2d.peer.svg.TextPeer()
},createImage:function(){return new web2d.peer.svg.ImagePeer()
},createRect:function(arc){return new web2d.peer.svg.RectPeer(arc)
},createArialFont:function(){return new web2d.peer.svg.ArialFont()
},createTimesFont:function(){return new web2d.peer.svg.TimesFont()
},createVerdanaFont:function(){return new web2d.peer.svg.VerdanaFont()
},createTahomaFont:function(){return new web2d.peer.svg.TahomaFont()
}};
web2d.peer.Toolkit=web2d.peer.ToolkitSVG;web2d.Workspace=function(attributes){this._htmlContainer=this._createDivContainer();
var peer=web2d.peer.Toolkit.createWorkspace(this._htmlContainer);
var defaultAttributes={width:"200px",height:"200px",stroke:"1px solid #edf1be",fillColor:"white",coordOrigin:"0 0",coordSize:"200 200"};
for(var key in attributes){defaultAttributes[key]=attributes[key]
}web2d.Element.call(this,peer,defaultAttributes);
this._htmlContainer.appendChild(this._peer._native);
this._disableTextSelection()
};
objects.extend(web2d.Workspace,web2d.Element);
web2d.Workspace.prototype._disableTextSelection=function(){var contaier=this._htmlContainer;
function disabletext(e){return false
}function reEnable(){return true
}contaier.onselectstart=new Function("return false");
if(core.Utils.isDefined(window.sidebar)){contaier.onmousedown=disabletext;
contaier.onclick=reEnable
}};
web2d.Workspace.prototype.getType=function(){return"Workspace"
};
web2d.Workspace.prototype.appendChild=function(element){if(!core.Utils.isDefined(element)){throw"Child element can not be null"
}var elementType=element.getType();
if(elementType==null){throw"It seems not to be an element ->"+element
}if(elementType=="Workspace"){throw"A workspace can not have a workspace as a child"
}this._peer.appendChild(element._peer)
};
web2d.Workspace.prototype.addItAsChildTo=function(element){if(!core.Utils.isDefined(element)){throw"Workspace div container can not be null"
}element.appendChild(this._htmlContainer)
};
web2d.Workspace.prototype._createDivContainer=function(domElement){var container=window.document.createElement("div");
container.id="workspaceContainer";
container.style.overflow="hidden";
container.style.position="relative";
container.style.top="0px";
container.style.left="0px";
container.style.height="688px";
container.style.border="1px solid red";
return container
};
web2d.Workspace.prototype.setSize=function(width,height){if(core.Utils.isDefined(width)){this._htmlContainer.style.width=width
}if(core.Utils.isDefined(height)){this._htmlContainer.style.height=height
}this._peer.setSize(width,height)
};
web2d.Workspace.prototype.setCoordSize=function(width,height){this._peer.setCoordSize(width,height)
};
web2d.Workspace.prototype.setCoordOrigin=function(x,y){this._peer.setCoordOrigin(x,y)
};
web2d.Workspace.prototype.getCoordOrigin=function(){return this._peer.getCoordOrigin()
};
web2d.Workspace.prototype._getHtmlContainer=function(){return this._htmlContainer
};
web2d.Workspace.prototype.setFill=function(color,opacity){this._htmlContainer.style.backgroundColor=color;
if(opacity||opacity===0){throw"Unsupported operation. Opacity not supported."
}};
web2d.Workspace.prototype.getFill=function(){var color=this._htmlContainer.style.backgroundColor;
return{color:color}
};
web2d.Workspace.prototype.getSize=function(){var width=this._htmlContainer.style.width;
var height=this._htmlContainer.style.height;
return{width:width,height:height}
};
web2d.Workspace.prototype.setStroke=function(width,style,color,opacity){if(style!="solid"){throw"Not supported style stroke style:"+style
}this._htmlContainer.style.border=width+" "+style+" "+color;
if(opacity||opacity===0){throw"Unsupported operation. Opacity not supported."
}};
web2d.Workspace.prototype.getCoordSize=function(){return this._peer.getCoordSize()
};
web2d.Workspace.prototype.removeChild=function(element){if(!core.Utils.isDefined(element)){throw"Child element can not be null"
}if(element==this){throw"It's not posible to add the group as a child of itself"
}var elementType=element.getType();
if(elementType==null){throw"It seems not to be an element ->"+element
}this._peer.removeChild(element._peer)
};
web2d.Workspace.prototype.dumpNativeChart=function(){var elem=this._htmlContainer;
return elem.innerHTML
};