'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactBootstrap = require('react-bootstrap');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DefaultInput = function (_React$Component) {
    (0, _inherits3.default)(DefaultInput, _React$Component);

    function DefaultInput(props) {
        (0, _classCallCheck3.default)(this, DefaultInput);
        return (0, _possibleConstructorReturn3.default)(this, (0, _getPrototypeOf2.default)(DefaultInput).call(this, props));
    }

    (0, _createClass3.default)(DefaultInput, [{
        key: 'focus',
        value: function focus() {
            ReactDOM.findDOMNode(this.input).focus();
        }
    }, {
        key: 'getInputDOMNode',
        value: function getInputDOMNode() {
            return ReactDOM.findDOMNode(this.input);
        }
    }, {
        key: 'render',
        value: function render() {
            switch (this.props.type) {
                case 'radio':
                    return this._renderRadio();
                case 'checkbox':
                    return this._renderCheckbox();
                case 'select':
                    return this._renderSelect();
                case 'textarea':
                    return this._renderTextArea();
                default:
                    return this._renderInput();
            }
        }
    }, {
        key: '_renderCheckbox',
        value: function _renderCheckbox() {
            var _this2 = this;

            return _react2.default.createElement(
                _reactBootstrap.Checkbox,
                (0, _extends3.default)({ ref: function ref(c) {
                        return _this2.input = c;
                    } }, this.props),
                this.props.label
            );
        }
    }, {
        key: '_renderRadio',
        value: function _renderRadio() {
            var _this3 = this;

            return _react2.default.createElement(
                _reactBootstrap.Radio,
                (0, _extends3.default)({ ref: function ref(c) {
                        return _this3.input = c;
                    } }, this.props),
                this.props.label
            );
        }
    }, {
        key: '_renderSelect',
        value: function _renderSelect() {
            var _this4 = this;

            return _react2.default.createElement(
                _reactBootstrap.FormGroup,
                { bsSize: 'small', validationState: this.props.validation },
                this._renderLabel(),
                _react2.default.createElement(
                    _reactBootstrap.FormControl,
                    (0, _extends3.default)({ componentClass: 'select', ref: function ref(c) {
                            return _this4.input = c;
                        } }, this.props),
                    this.props.children
                ),
                this.props.validation && _react2.default.createElement(_reactBootstrap.FormControl.Feedback, null),
                this._renderHelp()
            );
        }
    }, {
        key: '_renderLabel',
        value: function _renderLabel() {
            return this.props.label ? _react2.default.createElement(
                _reactBootstrap.ControlLabel,
                null,
                this.props.label
            ) : null;
        }
    }, {
        key: '_renderTextArea',
        value: function _renderTextArea() {
            var _this5 = this;

            return _react2.default.createElement(
                _reactBootstrap.FormGroup,
                { bsSize: 'small', validationState: this.props.validation },
                this._renderLabel(),
                _react2.default.createElement(_reactBootstrap.FormControl, (0, _extends3.default)({ componentClass: 'textarea', style: { height: 'auto' }, ref: function ref(c) {
                        return _this5.input = c;
                    } }, this.props)),
                this.props.validation && _react2.default.createElement(_reactBootstrap.FormControl.Feedback, null),
                this._renderHelp()
            );
        }
    }, {
        key: '_renderHelp',
        value: function _renderHelp() {
            return this.props.help ? _react2.default.createElement(
                HelpBlock,
                null,
                this.props.help
            ) : null;
        }
    }, {
        key: '_renderInput',
        value: function _renderInput() {
            var _this6 = this;

            return _react2.default.createElement(
                _reactBootstrap.FormGroup,
                { bsSize: 'small', validationState: this.props.validation },
                this._renderLabel(),
                _react2.default.createElement(_reactBootstrap.FormControl, (0, _extends3.default)({ ref: function ref(c) {
                        return _this6.input = c;
                    }, componentClass: 'input' }, this.props)),
                this.props.validation && _react2.default.createElement(_reactBootstrap.FormControl.Feedback, null),
                this._renderHelp()
            );
        }
    }]);
    return DefaultInput;
}(_react2.default.Component);

DefaultInput.propTypes = {
    type: _react2.default.PropTypes.string,
    label: _react2.default.PropTypes.string,
    value: _react2.default.PropTypes.any,
    onChange: _react2.default.PropTypes.func,
    help: _react2.default.PropTypes.string,
    validation: _react2.default.PropTypes.oneOf(['success', 'warning', 'error'])
};
DefaultInput.defaultProps = {
    type: 'text'
};
exports.default = DefaultInput;