'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof2 = require('babel-runtime/helpers/typeof');

var _typeof3 = _interopRequireDefault(_typeof2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _jsonld = require('jsonld');

var _jsonld2 = _interopRequireDefault(_jsonld);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var JsonLdObjectUtils = function () {
    function JsonLdObjectUtils() {
        (0, _classCallCheck3.default)(this, JsonLdObjectUtils);
    }

    (0, _createClass3.default)(JsonLdObjectUtils, null, [{
        key: 'getFirstObject',
        value: function getFirstObject(subject, predicate) {
            var values = _jsonld2.default.getValues(subject, predicate);

            if (values.length === 0) {
                //throw "Subject "  + subject[@id] + " does not have any value of property " + predicate;
                return null;
            }
            return values[0];
        }
    }, {
        key: 'compareValues',
        value: function compareValues(jsonLdValue1, jsonLdValue2) {
            jsonLdValue1 = (typeof jsonLdValue1 === 'undefined' ? 'undefined' : (0, _typeof3.default)(jsonLdValue1)) === 'object' ? jsonLdValue1 : { '@value': jsonLdValue1 };
            jsonLdValue2 = (typeof jsonLdValue2 === 'undefined' ? 'undefined' : (0, _typeof3.default)(jsonLdValue2)) === 'object' ? jsonLdValue2 : { '@value': jsonLdValue2 };

            return _jsonld2.default.compareValues(jsonLdValue1, jsonLdValue2);
        }
    }]);
    return JsonLdObjectUtils;
}();

exports.default = JsonLdObjectUtils;