'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _Constants = require('../constants/Constants');

var _Constants2 = _interopRequireDefault(_Constants);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DefaultFormGenerator = function () {
    function DefaultFormGenerator() {
        (0, _classCallCheck3.default)(this, DefaultFormGenerator);
    }

    (0, _createClass3.default)(DefaultFormGenerator, null, [{
        key: 'generateForm',


        /**
         * Generates default form for the wizard framework.
         *
         * The form consists of a single step, which contains one text area for the description.
         *
         * @param rootQuestion Optional, contains root question with data for the default form template
         */
        value: function generateForm(rootQuestion) {
            var formTemplate = require('./defaultForm');
            // Deep copy of the form template to prevent modifications
            formTemplate = JSON.parse((0, _stringify2.default)(formTemplate));
            if (!rootQuestion) {
                return formTemplate;
            }
            var form = formTemplate['@graph'][0],
                formStep = form[_Constants2.default.HAS_SUBQUESTION][0],
                stepQuestion = formStep[_Constants2.default.HAS_SUBQUESTION][0],
                questionAnswer = stepQuestion[_Constants2.default.HAS_ANSWER],
                step = rootQuestion.subQuestions ? rootQuestion.subQuestions[0] : null;
            form['@id'] = rootQuestion.uri;
            if (!step) {
                return formTemplate;
            }
            formStep['@id'] = step.uri;
            var question = step.subQuestions ? step.subQuestions[0] : null;
            if (!question) {
                return formTemplate;
            }
            stepQuestion['@id'] = question.uri;
            var answer = question.answers ? question.answers[0] : {};
            questionAnswer['@id'] = answer.uri;
            questionAnswer[_Constants2.default.HAS_DATA_VALUE] = answer.textValue;
            return formTemplate;
        }
    }]);
    return DefaultFormGenerator;
}();

exports.default = DefaultFormGenerator;
;