'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getIterator2 = require("babel-runtime/core-js/get-iterator");

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _jsonldUtils = require("jsonld-utils");

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _jsonld = require("jsonld");

var _jsonld2 = _interopRequireDefault(_jsonld);

var _Constants = require("../constants/Constants");

var _Constants2 = _interopRequireDefault(_Constants);

var _Utils = require("./Utils");

var _Utils2 = _interopRequireDefault(_Utils);

var _JsonObjectMap = require("./JsonObjectMap");

var _JsonObjectMap2 = _interopRequireDefault(_JsonObjectMap);

var _JsonLdObjectUtils = require("./JsonLdObjectUtils");

var _JsonLdObjectUtils2 = _interopRequireDefault(_JsonLdObjectUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FormUtils = function () {
    function FormUtils() {
        (0, _classCallCheck3.default)(this, FormUtils);
    }

    (0, _createClass3.default)(FormUtils, null, [{
        key: "isForm",
        value: function isForm(structure) {
            return _jsonldUtils2.default.hasValue(structure, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.FORM);
        }
    }, {
        key: "isWizardStep",
        value: function isWizardStep(structure) {
            return _jsonldUtils2.default.hasValue(structure, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.WIZARD_STEP);
        }
    }, {
        key: "isSection",
        value: function isSection(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.QUESTION_SECTION);
        }
    }, {
        key: "isAnswerable",
        value: function isAnswerable(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.ANSWERABLE);
        }
    }, {
        key: "isTypeahead",
        value: function isTypeahead(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.QUESTION_TYPEAHEAD);
        }
    }, {
        key: "getPossibleValuesQuery",
        value: function getPossibleValuesQuery(question) {
            return _jsonldUtils2.default.getJsonAttValue(question, _Constants2.default.HAS_OPTIONS_QUERY);
        }
    }, {
        key: "isDisabled",
        value: function isDisabled(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.DISABLED);
        }
    }, {
        key: "isHidden",
        value: function isHidden(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.HIDDEN);
        }
    }, {
        key: "isTextarea",
        value: function isTextarea(question, answerValue) {
            return answerValue && answerValue.length > _Constants2.default.INPUT_LENGTH_THRESHOLD || _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.TEXTAREA);
        }
    }, {
        key: "isCalendar",
        value: function isCalendar(question) {
            return FormUtils.isDate(question) || FormUtils.isTime(question) || FormUtils.isDateTime(question);
        }
    }, {
        key: "isDate",
        value: function isDate(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.DATE);
        }
    }, {
        key: "isTime",
        value: function isTime(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.TIME);
        }
    }, {
        key: "isDateTime",
        value: function isDateTime(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.DATETIME);
        }
    }, {
        key: "isCheckbox",
        value: function isCheckbox(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.CHECKBOX);
        }
    }, {
        key: "isMaskedInput",
        value: function isMaskedInput(question) {
            return _jsonldUtils2.default.hasValue(question, _Constants2.default.LAYOUT_CLASS, _Constants2.default.LAYOUT.MASKED_INPUT);
        }
    }, {
        key: "resolveValue",
        value: function resolveValue(answer) {
            if (!answer) {
                return null;
            }
            if (answer[_Constants2.default.HAS_OBJECT_VALUE]) {
                return answer[_Constants2.default.HAS_OBJECT_VALUE]['@id'];
            } else {
                return _jsonldUtils2.default.getJsonAttValue(answer, _Constants2.default.HAS_DATA_VALUE);
            }
        }
    }, {
        key: "resolveValueObject",
        value: function resolveValueObject(answer) {
            if (!answer) {
                return null;
            }
            if (answer[_Constants2.default.HAS_OBJECT_VALUE]) {
                return _Utils2.default.asArray(answer[_Constants2.default.HAS_OBJECT_VALUE])[0];
            }
            if (answer[_Constants2.default.HAS_DATA_VALUE]) {
                return _Utils2.default.asArray(answer[_Constants2.default.HAS_DATA_VALUE])[0];
            }
            return null;
        }
    }, {
        key: "isRelevant",
        value: function isRelevant(question) {

            if (!question[_Constants2.default.IS_RELEVANT_IF]) {
                return true;
            }

            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = (0, _getIterator3.default)(_Utils2.default.asArray(question[_Constants2.default.IS_RELEVANT_IF])), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var cond = _step.value;


                    if (FormUtils.testCondition(cond)) {
                        return true;
                    }
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }

            return false;
        }
    }, {
        key: "testCondition",
        value: function testCondition(condition) {

            var questionsWithValidAnswer = condition[_Constants2.default.HAS_VALID_ANSWER],
                acceptedAnswerValues = condition[_Constants2.default.ACCEPTS_ANSWER_VALUE],
                testedQuestion = condition[_Constants2.default.HAS_TESTED_QUESTION];

            // valid answers
            if (questionsWithValidAnswer) {
                var _iteratorNormalCompletion2 = true;
                var _didIteratorError2 = false;
                var _iteratorError2 = undefined;

                try {
                    for (var _iterator2 = (0, _getIterator3.default)(_Utils2.default.asArray(questionsWithValidAnswer)), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                        var question = _step2.value;

                        return true; //TODO not implemented
                    }
                } catch (err) {
                    _didIteratorError2 = true;
                    _iteratorError2 = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion2 && _iterator2.return) {
                            _iterator2.return();
                        }
                    } finally {
                        if (_didIteratorError2) {
                            throw _iteratorError2;
                        }
                    }
                }
            }

            // concrete values
            if (acceptedAnswerValues && testedQuestion) {
                var question = _JsonObjectMap2.default.getObject(testedQuestion["@id"]);
                var _iteratorNormalCompletion3 = true;
                var _didIteratorError3 = false;
                var _iteratorError3 = undefined;

                try {
                    for (var _iterator3 = (0, _getIterator3.default)(_Utils2.default.asArray(acceptedAnswerValues)), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
                        var expValue = _step3.value;

                        var answers = _jsonld2.default.getValues(question, _Constants2.default.HAS_ANSWER);

                        if (answers.length === 0) {
                            return false;
                        }
                        var qValue = FormUtils.resolveValueObject(answers[0]);

                        if (_JsonLdObjectUtils2.default.compareValues(qValue, expValue)) {
                            return true;
                        }
                    }
                } catch (err) {
                    _didIteratorError3 = true;
                    _iteratorError3 = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion3 && _iterator3.return) {
                            _iterator3.return();
                        }
                    } finally {
                        if (_didIteratorError3) {
                            throw _iteratorError3;
                        }
                    }
                }
            }
            return false;
        }
    }]);
    return FormUtils;
}();

exports.default = FormUtils;