module.exports =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./s-forms.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./components/Answer.jsx":
/*!*******************************!*\
  !*** ./components/Answer.jsx ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _answer_CheckboxAnswer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./answer/CheckboxAnswer */ "./components/answer/CheckboxAnswer.jsx");
/* harmony import */ var _answer_DateTimeAnswer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./answer/DateTimeAnswer */ "./components/answer/DateTimeAnswer.jsx");
/* harmony import */ var _answer_InputAnswer__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./answer/InputAnswer */ "./components/answer/InputAnswer.jsx");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _answer_MaskedInputAnswer__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./answer/MaskedInputAnswer */ "./components/answer/MaskedInputAnswer.jsx");
/* harmony import */ var _answer_SelectAnswer__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./answer/SelectAnswer */ "./components/answer/SelectAnswer.jsx");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _util_Utils__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../util/Utils */ "./util/Utils.js");
/* harmony import */ var _answer_TypeaheadAnswer__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./answer/TypeaheadAnswer */ "./components/answer/TypeaheadAnswer.jsx");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../contexts/FormGenContext */ "./contexts/FormGenContext.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _Question__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./Question */ "./components/Question.jsx");







function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

















var Answer = function Answer(props) {
  var formGenContext = react__WEBPACK_IMPORTED_MODULE_6___default.a.useContext(_contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_18__["FormGenContext"]);

  var _React$useContext = react__WEBPACK_IMPORTED_MODULE_6___default.a.useContext(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_19__["ConfigurationContext"]),
      options = _React$useContext.options;

  var onValueChange = function onValueChange(value) {
    var change = _objectSpread({}, props.answer);

    _setValue(change, value);

    props.onChange(props.index, change);
  };

  var _setValue = function _setValue(change, value) {
    if (value === null) {
      change[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].HAS_OBJECT_VALUE] = null;
      change[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].HAS_DATA_VALUE] = null;
    } else if (props.answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].HAS_OBJECT_VALUE] || _util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isTypeahead(props.question)) {
      change[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].HAS_OBJECT_VALUE] = {
        '@id': value
      };
    } else {
      change[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].HAS_DATA_VALUE] = {
        '@value': value
      };
    }
  };

  var _hasOptions = function _hasOptions(item) {
    return item[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].HAS_OPTION] && item[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].HAS_OPTION].length !== 0;
  };

  var _renderTypeahead = function _renderTypeahead(value, label, title) {
    var queryHash = _util_Utils__WEBPACK_IMPORTED_MODULE_15__["default"].getStringHash(_util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].getPossibleValuesQuery(props.question));
    var options = formGenContext.getOptions(queryHash) || [];
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(_answer_TypeaheadAnswer__WEBPACK_IMPORTED_MODULE_16__["default"], {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      options: options
    });
  };

  var _renderSelect = function _renderSelect(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(_answer_SelectAnswer__WEBPACK_IMPORTED_MODULE_13__["default"], {
      question: props.question,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange
    });
  };

  var _renderDateTimePicker = function _renderDateTimePicker(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(_answer_DateTimeAnswer__WEBPACK_IMPORTED_MODULE_9__["default"], {
      question: props.question,
      value: value,
      title: title,
      label: label,
      onChange: onValueChange
    });
  };

  var _renderCheckbox = function _renderCheckbox(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(_answer_CheckboxAnswer__WEBPACK_IMPORTED_MODULE_8__["default"], {
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      question: props.question
    });
  };

  var _renderMaskedInput = function _renderMaskedInput(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(_answer_MaskedInputAnswer__WEBPACK_IMPORTED_MODULE_12__["default"], {
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      question: props.question,
      answer: props.answer
    });
    return null;
  };

  var _renderRegularInput = function _renderRegularInput(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(_answer_InputAnswer__WEBPACK_IMPORTED_MODULE_10__["default"], {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange
    });
  };

  var _renderSparqlInput = function _renderSparqlInput(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(_answer_InputAnswer__WEBPACK_IMPORTED_MODULE_10__["default"], {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      sparql: true
    });
  };

  var _renderTurtleInput = function _renderTurtleInput(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(_answer_InputAnswer__WEBPACK_IMPORTED_MODULE_10__["default"], {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      turtle: true
    });
  };

  var _getLabel = function _getLabel(question) {
    var label = jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default.a.getLocalized(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].RDFS_LABEL], options.intl);
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("div", {
      className: "question-header"
    }, label, _Question__WEBPACK_IMPORTED_MODULE_20__["default"].renderIcons(props.question, options, props.onCommentChange, props.showIcon));
  };

  var question = props.question;
  var value = _util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].resolveValue(props.answer);

  var label = _getLabel(question);

  var title = jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default.a.getLocalized(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].RDFS_COMMENT], options.intl);
  var component;

  if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isTypeahead(question)) {
    component = _renderTypeahead(value, label, title);
  } else if (_hasOptions(question)) {
    component = _renderSelect(value, label, title);
  } else if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isCalendar(question)) {
    component = _renderDateTimePicker(value, label, title);
  } else if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isCheckbox(question)) {
    component = _renderCheckbox(value, label, title);
  } else if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isMaskedInput(question)) {
    component = _renderMaskedInput(value, label, title);
  } else if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isSparqlInput(question)) {
    component = _renderSparqlInput(value, label, title);
  } else if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isTurtleInput(question)) {
    component = _renderTurtleInput(value, label, title);
  } else {
    component = _renderRegularInput(value, label, title);
  }

  return component;
};

Answer.propTypes = {
  answer: prop_types__WEBPACK_IMPORTED_MODULE_7___default.a.object.isRequired,
  question: prop_types__WEBPACK_IMPORTED_MODULE_7___default.a.object.isRequired,
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_7___default.a.func.isRequired,
  onCommentChange: prop_types__WEBPACK_IMPORTED_MODULE_7___default.a.func.isRequired,
  index: prop_types__WEBPACK_IMPORTED_MODULE_7___default.a.number,
  icons: prop_types__WEBPACK_IMPORTED_MODULE_7___default.a.object
};
/* harmony default export */ __webpack_exports__["default"] = (Answer);

/***/ }),

/***/ "./components/DefaultInput.jsx":
/*!*************************************!*\
  !*** ./components/DefaultInput.jsx ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DefaultInput; });
/* harmony import */ var core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.number.constructor */ "core-js/modules/es.number.constructor");
/* harmony import */ var core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "@babel/runtime/helpers/extends");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__);











function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var DefaultInput = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7___default()(DefaultInput, _React$Component);

  var _super = _createSuper(DefaultInput);

  function DefaultInput(props) {
    var _this;

    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5___default()(this, DefaultInput);

    _this = _super.call(this, props);
    _this.state = {
      cursorPosition: 0
    };
    return _this;
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6___default()(DefaultInput, [{
    key: "focus",
    value: function focus() {
      react_dom__WEBPACK_IMPORTED_MODULE_11___default.a.findDOMNode(this.input).focus();
    }
  }, {
    key: "getInputDOMNode",
    value: function getInputDOMNode() {
      return react_dom__WEBPACK_IMPORTED_MODULE_11___default.a.findDOMNode(this.input);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState, snapshot) {
      if (this.fieldDidShrink(prevProps) || this.fieldDidExpand(prevProps)) {
        this.updateFieldCursorPosition();
      }
    }
  }, {
    key: "fieldDidExpand",
    value: function fieldDidExpand(prevProps) {
      return this.props.type === "textarea" && prevProps.type !== "textarea";
    }
  }, {
    key: "fieldDidShrink",
    value: function fieldDidShrink(prevProps) {
      return this.props.type === "text" && prevProps.type !== "text";
    }
  }, {
    key: "updateFieldCursorPosition",
    value: function updateFieldCursorPosition() {
      this.focus();
      this.getInputDOMNode().setSelectionRange(this.state.cursorPosition, this.state.cursorPosition);
    }
  }, {
    key: "saveCursorPosition",
    value: function saveCursorPosition(e) {
      this.props.onChange(e);
      this.setState({
        cursorPosition: e.target.selectionStart
      });
    }
  }, {
    key: "render",
    value: function render() {
      switch (this.props.type) {
        case 'radio':
          return this._renderRadio();

        case 'checkbox':
          return this._renderCheckbox();

        case 'select':
          return this._renderSelect();

        case 'textarea':
          return this._renderTextArea();

        default:
          return this._renderInput();
      }
    }
  }, {
    key: "_renderCheckbox",
    value: function _renderCheckbox() {
      var _this2 = this;

      // TODO change control id to hash of label
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["Form"].Group, {
        size: "small",
        controlId: Math.floor(Math.random() * Number.MAX_SAFE_INTEGER)
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["Form"].Check, _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_4___default()({
        type: "checkbox",
        ref: function ref(c) {
          return _this2.input = c;
        }
      }, this.props, {
        label: this.props.label
      })));
    }
  }, {
    key: "_renderRadio",
    value: function _renderRadio() {
      var _this3 = this;

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["FormGroup"], {
        size: "small"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["Form"].Check, _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_4___default()({
        type: "radio",
        ref: function ref(c) {
          return _this3.input = c;
        }
      }, this.props, {
        label: this.props.label
      })));
    }
  }, {
    key: "_renderSelect",
    value: function _renderSelect() {
      var _this4 = this;

      // TODO validation
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["FormGroup"], {
        size: "small"
      }, this._renderLabel(), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["FormControl"], _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_4___default()({
        as: "select",
        ref: function ref(c) {
          return _this4.input = c;
        }
      }, this.props), this.props.children), this.props.validation && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["FormControl"].Feedback, null), this._renderHelp());
    }
  }, {
    key: "_renderLabel",
    value: function _renderLabel() {
      return this.props.label ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["Form"].Label, null, this.props.label) : null;
    }
  }, {
    key: "_renderTextArea",
    value: function _renderTextArea() {
      var _this5 = this;

      // TODO validation
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["FormGroup"], {
        size: "small"
      }, this._renderLabel(), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["FormControl"], _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_4___default()({
        ref: function ref(c) {
          return _this5.input = c;
        },
        as: "textarea"
      }, this.props, {
        onChange: function onChange(e) {
          return _this5.saveCursorPosition(e);
        }
      })), this.props.validation && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["FormControl"].Feedback, null), this._renderHelp());
    }
  }, {
    key: "_renderHelp",
    value: function _renderHelp() {
      return this.props.help ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["FormText"], null, this.props.help) : null;
    }
  }, {
    key: "_renderInput",
    value: function _renderInput() {
      var _this6 = this;

      // TODO validation
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["FormGroup"], {
        size: "small"
      }, this._renderLabel(), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["FormControl"], _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_4___default()({
        ref: function ref(c) {
          return _this6.input = c;
        },
        as: "input"
      }, this.props, {
        onChange: function onChange(e) {
          return _this6.saveCursorPosition(e);
        }
      })), this.props.validation && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["FormControl"].Feedback, null), this._renderHelp());
    }
  }]);

  return DefaultInput;
}(react__WEBPACK_IMPORTED_MODULE_10___default.a.Component);


DefaultInput.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.string,
  label: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.object,
  value: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.any,
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.func,
  help: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.string,
  validation: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.oneOf(['success', 'warning', 'error'])
};
DefaultInput.defaultProps = {
  type: 'text'
};

/***/ }),

/***/ "./components/FormManager.jsx":
/*!************************************!*\
  !*** ./components/FormManager.jsx ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_concat__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.concat */ "core-js/modules/es.array.concat");
/* harmony import */ var core_js_modules_es_array_concat__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_every__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.every */ "core-js/modules/es.array.every");
/* harmony import */ var core_js_modules_es_array_every__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_every__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "@babel/runtime/helpers/assertThisInitialized");
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _model_QuestionAnswerProcessor__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../model/QuestionAnswerProcessor */ "./model/QuestionAnswerProcessor.js");
/* harmony import */ var _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../contexts/FormQuestionsContext */ "./contexts/FormQuestionsContext.js");
/* harmony import */ var _wizard_Wizard__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./wizard/Wizard */ "./components/wizard/Wizard.jsx");
/* harmony import */ var _s_forms__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../s-forms */ "./s-forms.js");
/* harmony import */ var _FormWindow__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./FormWindow */ "./components/FormWindow.jsx");
/* harmony import */ var react_bootstrap_Card__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! react-bootstrap/Card */ "react-bootstrap/Card");
/* harmony import */ var react_bootstrap_Card__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap_Card__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var _Question__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./Question */ "./components/Question.jsx");



















function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_16___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_16___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_15___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }










var FormManager = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_14___default()(FormManager, _React$Component);

  var _super = _createSuper(FormManager);

  function FormManager() {
    var _this;

    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11___default()(this, FormManager);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default()(_this), "getFormData", function () {
      var data = _this.context.getData();

      var formQuestionsData = _this.context.getFormQuestionsData();

      return _model_QuestionAnswerProcessor__WEBPACK_IMPORTED_MODULE_19__["default"].buildQuestionAnswerModel(data, formQuestionsData);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default()(_this), "getFormQuestionsData", function () {
      return _this.context.getFormQuestionsData();
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default()(_this), "onStepChange", function (question, index, change) {
      _this.context.updateFormQuestionsData(index, _objectSpread(_objectSpread({}, question), change));
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default()(_this), "renderWizardlessForm", function () {
      var formQuestionsData = _this.context.getFormQuestionsData();

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default.a.createElement(react_bootstrap_Card__WEBPACK_IMPORTED_MODULE_24___default.a, {
        className: "p-3"
      }, formQuestionsData.map(function (q, i) {
        return _this._mapQuestion(q, i);
      }));
    });

    return _this;
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12___default()(FormManager, [{
    key: "_mapQuestion",
    value: function _mapQuestion(question, index) {
      var _this2 = this;

      var component = this.props.mapComponent(question, _Question__WEBPACK_IMPORTED_MODULE_25__["default"]);
      return react__WEBPACK_IMPORTED_MODULE_18___default.a.createElement(component, {
        key: question['@id'],
        question: question,
        onChange: function onChange(index, change) {
          return _this2.onStepChange(question, index, change);
        },
        index: index
      });
    }
  }, {
    key: "render",
    value: function render() {
      var modalView = this.props.modalView;
      var formQuestionsData = this.context.getFormQuestionsData();

      if (!formQuestionsData.length) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default.a.createElement(react_bootstrap_Card__WEBPACK_IMPORTED_MODULE_24___default.a, {
          className: "p-3 font-italic"
        }, "There are no questions available...");
      }

      var isWizardless = formQuestionsData.every(function (question) {
        return !_s_forms__WEBPACK_IMPORTED_MODULE_22__["FormUtils"].isWizardStep(question);
      });

      if (modalView) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default.a.createElement(_FormWindow__WEBPACK_IMPORTED_MODULE_23__["default"], null, isWizardless ? this.renderWizardlessForm() : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default.a.createElement(_wizard_Wizard__WEBPACK_IMPORTED_MODULE_21__["default"], null));
      }

      return isWizardless ? this.renderWizardlessForm() : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default.a.createElement(_wizard_Wizard__WEBPACK_IMPORTED_MODULE_21__["default"], null);
    }
  }]);

  return FormManager;
}(react__WEBPACK_IMPORTED_MODULE_18___default.a.Component);

FormManager.contextType = _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_20__["FormQuestionsContext"];
/* harmony default export */ __webpack_exports__["default"] = (FormManager);

/***/ }),

/***/ "./components/FormWindow.jsx":
/*!***********************************!*\
  !*** ./components/FormWindow.jsx ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "@babel/runtime/helpers/extends");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");





var FormWindow = react__WEBPACK_IMPORTED_MODULE_1___default.a.forwardRef(function (props, ref) {
  var _React$useContext = react__WEBPACK_IMPORTED_MODULE_1___default.a.useContext(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_4__["ConfigurationContext"]),
      options = _React$useContext.options;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Modal"], _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default()({
    size: "xl",
    animation: true
  }, options.modalProps), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Modal"].Header, {
    closeButton: true
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Modal"].Title, null, options.modalProps.title)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Modal"].Body, {
    className: "overflow-hidden p-0"
  }, props.children));
});
FormWindow.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.element.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (FormWindow);

/***/ }),

/***/ "./components/HelpIcon.jsx":
/*!*********************************!*\
  !*** ./components/HelpIcon.jsx ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _styles_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../styles/icons */ "./styles/icons/index.js");






var HelpIcon = function HelpIcon(props) {
  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])("right"),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0___default()(_useState, 2),
      overlayPlacement = _useState2[0],
      setOverlayPlacement = _useState2[1];

  var getOverlayPlacement = function getOverlayPlacement(el) {
    if (!el) return;

    if (el.getBoundingClientRect().x > window.innerWidth / 2) {
      setOverlayPlacement("left");
    } else setOverlayPlacement("right");
  };

  var tooltip = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Tooltip"], {
    id: "help-tooltip",
    className: "tooltip-content"
  }, props.text);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", {
    ref: function ref(el) {
      return getOverlayPlacement(el);
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["OverlayTrigger"], {
    placement: props.overlayPlacement || overlayPlacement,
    overlay: tooltip
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", {
    className: props.iconClassContainer,
    style: {
      position: props.absolutePosition ? 'absolute' : null
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_styles_icons__WEBPACK_IMPORTED_MODULE_4__["QuestionCircle"], {
    className: props.iconClass
  }))));
};

HelpIcon.propTypes = {
  text: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.string.isRequired,
  iconClassContainer: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.string,
  iconClass: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.string,
  overlayPlacement: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.string,
  absolutePosition: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.bool
};
HelpIcon.defaultProps = {
  iconClassContainer: '',
  iconClass: '',
  absolutePosition: true
};
/* harmony default export */ __webpack_exports__["default"] = (HelpIcon);

/***/ }),

/***/ "./components/IconOverlay.jsx":
/*!************************************!*\
  !*** ./components/IconOverlay.jsx ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _LinkIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./LinkIcon */ "./components/LinkIcon.jsx");






var IconOverlay = function IconOverlay(props) {
  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])("right"),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0___default()(_useState, 2),
      overlayPlacement = _useState2[0],
      setOverlayPlacement = _useState2[1];

  var getOverlayPlacement = function getOverlayPlacement(el) {
    if (!el) return;

    if (el.getBoundingClientRect().x > window.innerWidth / 2) {
      setOverlayPlacement("left");
    } else setOverlayPlacement("right");
  };

  var tooltip = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["Tooltip"], {
    className: "tooltip-content",
    id: props.id
  }, props.tooltipContent);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", {
    ref: function ref(el) {
      return getOverlayPlacement(el);
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["OverlayTrigger"], {
    overlay: tooltip,
    placement: props.overlayPlacement || overlayPlacement
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", null, props.children)));
};

IconOverlay.propTypes = {
  tooltipContent: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.object.isRequired, prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string.isRequired]),
  id: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string.isRequired,
  overlayPlacement: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.string,
  absolutePosition: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.bool
};
IconOverlay.defaultProps = {
  iconClassContainer: '',
  iconClass: '',
  absolutePosition: true
};
/* harmony default export */ __webpack_exports__["default"] = (IconOverlay);

/***/ }),

/***/ "./components/LinkIcon.jsx":
/*!*********************************!*\
  !*** ./components/LinkIcon.jsx ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _styles_icons_ExternalLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../styles/icons/ExternalLink */ "./styles/icons/ExternalLink.jsx");
/* harmony import */ var _IconOverlay__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IconOverlay */ "./components/IconOverlay.jsx");





var LinkIcon = function LinkIcon(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_IconOverlay__WEBPACK_IMPORTED_MODULE_3__["default"], {
    tooltipContent: props.url['@id'] || props.url,
    id: "url-tooltip"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", {
    href: props.url['@id'] || props.url,
    target: "_blank",
    className: props.iconClassContainer
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_styles_icons_ExternalLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
    className: props.iconClass
  })));
};

LinkIcon.propTypes = {
  url: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string.isRequired, prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object.isRequired]),
  iconClassContainer: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string,
  iconClass: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string,
  overlayPlacement: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string,
  absolutePosition: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.bool
};
LinkIcon.defaultProps = {
  iconClassContainer: '',
  iconClass: '',
  absolutePosition: true
};
/* harmony default export */ __webpack_exports__["default"] = (LinkIcon);

/***/ }),

/***/ "./components/MaskedInput.jsx":
/*!************************************!*\
  !*** ./components/MaskedInput.jsx ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return MaskedInput; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "@babel/runtime/helpers/objectWithoutProperties");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "@babel/runtime/helpers/assertThisInitialized");
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var inputmask_core__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! inputmask-core */ "inputmask-core");
/* harmony import */ var inputmask_core__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(inputmask_core__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _util_MaskMapper__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../util/MaskMapper */ "./util/MaskMapper.js");
/* harmony import */ var _util_MaskMapper__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(_util_MaskMapper__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");

















function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_15___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_14___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_14___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_13___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var KEYCODE_Z = 90;
var KEYCODE_Y = 89;

function isUndo(e) {
  return e.ctrlKey && e.keyCode === KEYCODE_Z;
}

function isRedo(e) {
  return e.ctrlKey && e.keyCode === KEYCODE_Y;
} // Copied from https://github.com/insin/react-maskedinput


function getSelection(el) {
  var start;
  var end;
  var rangeEl;
  var clone;

  if (el.selectionStart !== undefined) {
    start = el.selectionStart;
    end = el.selectionEnd;
  } else {
    try {
      el.focus();
      rangeEl = el.createTextRange();
      clone = rangeEl.duplicate();
      rangeEl.moveToBookmark(document.selection.createRange().getBookmark());
      clone.setEndPoint('EndToStart', rangeEl);
      start = clone.text.length;
      end = start + rangeEl.text.length;
    } catch (e) {
      /* not focused or not visible */
    }
  }

  return {
    start,
    end
  };
}

function setSelection(el, selection) {
  var rangeEl;

  try {
    if (el.selectionStart !== undefined) {
      el.focus();
      el.setSelectionRange(selection.start, selection.end);
    } else {
      el.focus();
      rangeEl = el.createTextRange();
      rangeEl.collapse(true);
      rangeEl.moveStart('character', selection.start);
      rangeEl.moveEnd('character', selection.end - selection.start);
      rangeEl.select();
    }
  } catch (e) {
    /* not focused or not visible */
  }
}

var MaskedInput = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_12___default()(MaskedInput, _React$Component);

  var _super = _createSuper(MaskedInput);

  function MaskedInput(_props) {
    var _this;

    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_9___default()(this, MaskedInput);

    _this = _super.call(this, _props);

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_15___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_11___default()(_this), "_updatePattern", function (props) {
      _this.mask.setPattern(_util_MaskMapper__WEBPACK_IMPORTED_MODULE_20___default.a.mapMask(props.mask), {
        value: _this.mask.getRawValue(),
        selection: getSelection(_this.input)
      });
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_15___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_11___default()(_this), "_updateMaskSelection", function () {
      _this.mask.selection = getSelection(_this.input);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_15___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_11___default()(_this), "_updateInputSelection", function () {
      setSelection(_this.input, _this.mask.selection);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_15___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_11___default()(_this), "_onChange", function (e) {
      var maskValue = _this.mask.getValue();

      if (e.target.value !== maskValue) {
        // Cut or delete operations will have shortened the value
        if (e.target.value.length < maskValue.length) {
          var sizeDiff = maskValue.length - e.target.value.length;

          _this._updateMaskSelection();

          _this.mask.selection.end = _this.mask.selection.start + sizeDiff;

          _this.mask.backspace();
        }

        var value = _this._getDisplayValue();

        e.target.value = value;

        if (value) {
          _this._updateInputSelection();
        }
      }

      if (_this.props.onChange) {
        _this.props.onChange(e);
      }
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_15___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_11___default()(_this), "_onKeyDown", function (e) {
      if (isUndo(e)) {
        e.preventDefault();

        if (_this.mask.undo()) {
          e.target.value = _this._getDisplayValue();

          _this._updateInputSelection();

          if (_this.props.onChange) {
            _this.props.onChange(e);
          }
        }
      } else if (isRedo(e)) {
        e.preventDefault();

        if (_this.mask.redo()) {
          e.target.value = _this._getDisplayValue();

          _this._updateInputSelection();

          if (_this.props.onChange) {
            _this.props.onChange(e);
          }
        }
      } else if (e.key === 'Backspace') {
        e.preventDefault();

        _this._updateMaskSelection();

        if (_this.mask.backspace()) {
          var value = _this._getDisplayValue();

          e.target.value = value;

          if (value) {
            _this._updateInputSelection();
          }

          if (_this.props.onChange) {
            _this.props.onChange(e);
          }
        }
      }
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_15___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_11___default()(_this), "_onKeyPress", function (e) {
      // Ignore modified key presses
      // Ignore enter key to allow form submission
      if (e.metaKey || e.altKey || e.ctrlKey || e.key === 'Enter') {
        return;
      }

      e.preventDefault();

      _this._updateMaskSelection();

      if (_this.mask.input(e.key)) {
        e.target.value = _this.mask.getValue();

        _this._updateInputSelection();

        if (_this.props.onChange) {
          _this.props.onChange(e);
        }
      }
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_15___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_11___default()(_this), "_onPaste", function (e) {
      e.preventDefault();

      _this._updateMaskSelection(); // getData value needed for IE also works in FF & Chrome


      if (_this.mask.paste(e.clipboardData.getData('Text'))) {
        e.target.value = _this.mask.getValue(); // Timeout needed for IE

        setTimeout(_this._updateInputSelection, 0);

        if (_this.props.onChange) {
          _this.props.onChange(e);
        }
      }
    });

    _this.mask = new inputmask_core__WEBPACK_IMPORTED_MODULE_19___default.a({
      pattern: _util_MaskMapper__WEBPACK_IMPORTED_MODULE_20___default.a.mapMask(_props.mask),
      value: _props.value,
      formatCharacters: _props.formatCharacters,
      placeholderChar: _props.placeholderChar || '_'
    });
    return _this;
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_10___default()(MaskedInput, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.mask !== this.props.mask) {
        this._updatePattern(this.props);
      }

      if (prevProps.mask !== this.props.mask && prevProps.value !== this.props.mask) {
        // if we get a new value and a new mask at the same time
        // check if the mask.value is still the initial value
        // - if so use the nextProps value
        // - otherwise the `this.mask` has a value for us (most likely from paste action)
        if (this.mask.getValue() === this.mask.emptyValue) {
          this.mask.setPattern(_util_MaskMapper__WEBPACK_IMPORTED_MODULE_20___default.a.mapMask(this.props.mask), {
            value: this.props.value
          });
        } else {
          this.mask.setPattern(_util_MaskMapper__WEBPACK_IMPORTED_MODULE_20___default.a.mapMask(this.props.mask), {
            value: this.mask.getRawValue()
          });
        }
      } else if (prevProps.mask !== this.props.mask) {
        this.mask.setPattern(_util_MaskMapper__WEBPACK_IMPORTED_MODULE_20___default.a.mapMask(this.props.mask), {
          value: this.mask.getRawValue()
        });
      } else if (prevProps.value !== this.props.value) {
        this.mask.setValue(this.props.value);
      }

      if (prevProps.mask !== this.props.mask && this.mask.selection.start) {
        this._updateInputSelection();
      }
    }
  }, {
    key: "_getDisplayValue",
    value: function _getDisplayValue() {
      var value = this.mask.getValue();
      return value === this.mask.emptyValue ? '' : value;
    }
  }, {
    key: "focus",
    value: function focus() {
      this.input.focus();
    }
  }, {
    key: "blur",
    value: function blur() {
      this.input.blur();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          size = _this$props.size,
          placeholder = _this$props.placeholder,
          props = _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_8___default()(_this$props, ["size", "placeholder"]),
          patternLength = this.mask.pattern.length;

      return react__WEBPACK_IMPORTED_MODULE_16___default.a.createElement(this.context.inputComponent, _objectSpread(_objectSpread({}, props), {}, {
        ref: function ref(r) {
          if (r) {
            _this2.input = r.input ? react_dom__WEBPACK_IMPORTED_MODULE_18___default.a.findDOMNode(r.input) : r;
          }
        },
        maxLength: patternLength,
        onChange: this._onChange,
        onKeyDown: this._onKeyDown,
        onKeyPress: this._onKeyPress,
        onPaste: this._onPaste,
        placeholder: placeholder || this.mask.emptyValue,
        size: size || patternLength,
        value: this._getDisplayValue(),
        type: 'text'
      }));
    }
  }]);

  return MaskedInput;
}(react__WEBPACK_IMPORTED_MODULE_16___default.a.Component);


MaskedInput.contextType = _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_21__["ConfigurationContext"];
MaskedInput.propTypes = {
  mask: prop_types__WEBPACK_IMPORTED_MODULE_17___default.a.string.isRequired
};
MaskedInput.defaultProps = {
  value: ''
};

/***/ }),

/***/ "./components/MediaContent.jsx":
/*!*************************************!*\
  !*** ./components/MediaContent.jsx ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return MediaContent; });
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");










function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var MediaContent = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6___default()(MediaContent, _React$Component);

  var _super = _createSuper(MediaContent);

  function MediaContent() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4___default()(this, MediaContent);

    return _super.apply(this, arguments);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5___default()(MediaContent, [{
    key: "render",
    value: function render() {
      var mediaContent = jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default.a.getJsonAttValue(this.props.question, _constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].HAS_MEDIA_CONTENT);

      if (!mediaContent) {
        return null;
      }

      return this._renderDangerously(mediaContent);
    }
  }, {
    key: "_renderDangerously",
    value: function _renderDangerously(mediaContent) {
      if (Array.isArray(mediaContent)) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("div", {
          className: "col-6"
        }, mediaContent.map(function (src) {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("div", {
            key: 'media-' + src,
            className: "row embed-responsive-21by9 media-content-video-container mb-3"
          }, MediaContent.iframe(src));
        }));
      } else {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("div", {
          className: "row"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("div", {
          className: "col-6 embed-responsive-21by9 media-content-video-container mb-3"
        }, MediaContent.iframe(mediaContent)));
      }
    }
  }], [{
    key: "iframe",
    value: function iframe(src) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("iframe", {
        src: src,
        className: "embed-responsive-item",
        allowFullScreen: true
      });
    }
  }]);

  return MediaContent;
}(react__WEBPACK_IMPORTED_MODULE_9___default.a.Component);


MediaContent.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_10___default.a.object.isRequired
};

/***/ }),

/***/ "./components/PrefixIcon.jsx":
/*!***********************************!*\
  !*** ./components/PrefixIcon.jsx ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");











function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var PrefixIcon = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7___default()(PrefixIcon, _React$Component);

  var _super = _createSuper(PrefixIcon);

  function PrefixIcon(props) {
    var _this;

    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5___default()(this, PrefixIcon);

    _this = _super.call(this, props);
    _this.state = {
      show: props.show,
      prefixes: props.prefixes
    };
    return _this;
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6___default()(PrefixIcon, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var p = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_12__["Popover"], {
        id: "prefixes",
        title: "Prefixes"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_12__["ListGroup"], null, this.state.prefixes.sort(function (l, r) {
        var res = l[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].PREFIX] < r[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].PREFIX];
        if (res) return -1;
        return 1;
      }).map(function (p) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_12__["ListGroupItem"], {
          key: p[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].PREFIX]
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement("strong", null, p[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].PREFIX]), ": ", p[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].NAMESPACE]);
      })));
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_12__["OverlayTrigger"], {
        trigger: "click",
        placement: "right",
        overlay: p
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement("span", {
        className: this.props.iconClass,
        onClick: function onClick() {
          return _this2.setState({
            show: !_this2.state.show
          });
        }
      }, this.props.children));
    }
  }]);

  return PrefixIcon;
}(react__WEBPACK_IMPORTED_MODULE_10___default.a.Component);

PrefixIcon.propTypes = {
  prefixes: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.array.isRequired,
  children: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.element.isRequired,
  iconClass: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.string,
  show: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.bool
};
PrefixIcon.defaultProps = {
  iconClass: '',
  show: false
};
/* harmony default export */ __webpack_exports__["default"] = (PrefixIcon);

/***/ }),

/***/ "./components/Question.jsx":
/*!*********************************!*\
  !*** ./components/Question.jsx ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Question; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.find */ "core-js/modules/es.array.find");
/* harmony import */ var core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.number.constructor */ "core-js/modules/es.number.constructor");
/* harmony import */ var core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "@babel/runtime/helpers/assertThisInitialized");
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _Answer__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Answer */ "./components/Answer.jsx");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _HelpIcon__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./HelpIcon */ "./components/HelpIcon.jsx");
/* harmony import */ var _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../util/JsonLdObjectMap */ "./util/JsonLdObjectMap.js");
/* harmony import */ var _model_QuestionAnswerProcessor__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../model/QuestionAnswerProcessor */ "./model/QuestionAnswerProcessor.js");
/* harmony import */ var _model_ValidatorFactory__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../model/ValidatorFactory */ "./model/ValidatorFactory.js");
/* harmony import */ var _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../util/JsonLdObjectUtils */ "./util/JsonLdObjectUtils.js");
/* harmony import */ var _PrefixIcon__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./PrefixIcon */ "./components/PrefixIcon.jsx");
/* harmony import */ var _MediaContent__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./MediaContent */ "./components/MediaContent.jsx");
/* harmony import */ var _styles_icons__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../styles/icons */ "./styles/icons/index.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! classnames */ "classnames");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_33___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_33__);
/* harmony import */ var _comment_QuestionCommentIcon__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./comment/QuestionCommentIcon */ "./components/comment/QuestionCommentIcon.jsx");
/* harmony import */ var _LinkIcon__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./LinkIcon */ "./components/LinkIcon.jsx");


















function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_15___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_15___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_14___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }



















 // TODO Remove once the pretty layout is tested

var PRETTY_ANSWERABLE_LAYOUT = true;

var Question = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_13___default()(Question, _React$Component);

  var _super = _createSuper(Question);

  function Question(props) {
    var _this;

    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10___default()(this, Question);

    _this = _super.call(this, props);

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12___default()(_this), "onAnswerChange", function (answerIndex, change) {
      // is answerable section
      if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isSection(_this.props.question)) {
        var expanded = !!_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].resolveValue(change);

        _this.setState({
          expanded: expanded
        });
      }

      _this._onChange(_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_ANSWER, answerIndex, change);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12___default()(_this), "onSubQuestionChange", function (subQuestionIndex, change) {
      _this._onChange(_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_SUBQUESTION, subQuestionIndex, change);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12___default()(_this), "onCommentChange", function (commentIndex, change) {
      _this._onChange(_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_COMMENT, commentIndex, change);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12___default()(_this), "toggleCollapse", function () {
      if (_this.props.collapsible) {
        var question = _this.props.question;

        if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isAnswerable(question) && _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isSection(question)) {
          if (!_this._getFirstAnswerValue()) {
            // prevent expanding/collapsing when the checkbox is not checked
            return;
          }
        }

        _this.setState({
          expanded: !_this.state.expanded
        });
      }
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12___default()(_this), "_onMouseEnterHandler", function () {
      _this.setState({
        showIcon: true
      });
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12___default()(_this), "_onMouseLeaveHandler", function () {
      _this.setState({
        showIcon: false
      });
    });

    _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_25__["default"].putObject(props.question['@id'], props.question);
    _this.state = {
      validator: null,
      expanded: !_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isCollapsed(props.question),
      showIcon: false
    };
    return _this;
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11___default()(Question, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setState({
        validator: _model_ValidatorFactory__WEBPACK_IMPORTED_MODULE_27__["default"].createValidator(this.props.question, this.context.options.intl)
      });
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var question = this.props.question;

      if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isSection(question) && _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isAnswerable(question)) {
        var answerValue = this._getFirstAnswerValue();

        if (this.state.expanded && !answerValue) {
          // close expanded answerable section that does not have positive answer
          this.setState({
            expanded: false
          });
        }
      }
    }
  }, {
    key: "_onChange",
    value: function _onChange(att, valueIndex, newValue) {
      var newState = _objectSpread({}, this.props.question);

      newState[att][valueIndex] = newValue;

      if (att === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_ANSWER) {
        var result = this.state.validator(newValue);
        newState = _objectSpread(_objectSpread({}, newState), result);
      }

      _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_25__["default"].putObject(newState['@id'], newState);
      this.props.onChange(this.props.index, newState);
    }
  }, {
    key: "render",
    value: function render() {
      var question = this.props.question;
      var options = this.context.options;

      if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isHidden(question)) {
        return null;
      }

      if (!_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isRelevant(question)) {
        return null;
      }

      if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isAnswerable(question) && !_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isSection(question)) {
        if (PRETTY_ANSWERABLE_LAYOUT) {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
            id: question['@id']
          }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
            className: "panel-title answerable-question"
          }, this.renderAnswers()), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
            className: "answerable-subquestions"
          }, this.renderSubQuestions()));
        } else {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
            id: question['@id']
          }, this.renderAnswers(), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
            className: "ml-4 mt-n2"
          }, this.renderSubQuestions()));
        }
      }

      if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isSection(question)) {
        var _this$props = this.props,
            collapsible = _this$props.collapsible,
            withoutCard = _this$props.withoutCard;

        var categoryClass = Question._getQuestionCategoryClass(question);

        if (withoutCard) {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", null, this._renderQuestionContent());
        }

        var label = jsonld_utils__WEBPACK_IMPORTED_MODULE_19___default.a.getLocalized(question[jsonld_utils__WEBPACK_IMPORTED_MODULE_19___default.a.RDFS_LABEL], this.context.options.intl);
        var headerClassName = classnames__WEBPACK_IMPORTED_MODULE_33___default()(_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isEmphasised(question) ? Question.getEmphasizedClass(question) : 'section-background', collapsible ? 'cursor-pointer' : '', Question.getEmphasizedOnRelevantClass(question));

        if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isAnswerable(question)) {
          return this.renderAnswerableSection();
        }

        var cardBody = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Card"].Body, {
          className: classnames__WEBPACK_IMPORTED_MODULE_33___default()('p-3', categoryClass)
        }, this._renderQuestionContent()); // TODO change defaultActiveKey to label when expanded + add eventKey to Accordion.Collapse

        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Accordion"], {
          defaultActiveKey: !this.state.expanded ? label : undefined
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Card"], {
          className: "mb-3"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Accordion"].Toggle, {
          as: react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Card"].Header,
          onClick: this.toggleCollapse,
          className: headerClassName + " question-header",
          onMouseEnter: this._onMouseEnterHandler,
          onMouseLeave: this._onMouseLeaveHandler
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("h6", {
          className: "d-inline",
          id: question['@id']
        }, collapsible && this._renderCollapseToggle(), label), this.renderQuestionIcons(), this.renderHeaderExtension()), collapsible ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Accordion"].Collapse, null, cardBody) : {
          cardBody
        }));
      } else {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", null, this._renderQuestionContent());
      }
    }
  }, {
    key: "_renderQuestionContent",
    value: function _renderQuestionContent() {
      var content = [];

      if (this.state.expanded) {
        content.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_MediaContent__WEBPACK_IMPORTED_MODULE_30__["default"], {
          key: this.props.question['@id'] + '-media',
          question: this.props.question
        }));
      }

      content.push(this.renderAnswers());
      content.push(this.renderSubQuestions());
      return content;
    }
  }, {
    key: "renderQuestionIcons",
    value: function renderQuestionIcons() {
      var question = this.props.question;
      var options = this.context.options;
      return Question.renderIcons(question, options, this.onCommentChange, this.state.showIcon);
    }
  }, {
    key: "renderHeaderExtension",
    value: function renderHeaderExtension() {
      return;
    }
  }, {
    key: "renderAnswerableSection",
    value: function renderAnswerableSection() {
      var question = this.props.question;
      var collapsible = this.props.collapsible;

      var categoryClass = Question._getQuestionCategoryClass(question);

      var headerClassNames = [_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isEmphasised(question) ? Question.getEmphasizedClass(question) : 'section-background', this.state.expanded ? 'section-expanded' : 'section-collapsed', Question.getEmphasizedOnRelevantClass(question)];

      if (collapsible && this._getFirstAnswerValue()) {
        headerClassNames.push('cursor-pointer');
      }

      var cardBody = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Card"].Body, {
        className: classnames__WEBPACK_IMPORTED_MODULE_33___default()('p-3', categoryClass)
      }, this.renderSubQuestions());
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Accordion"], {
        activeKey: this.state.expanded ? question['@id'] : undefined,
        className: "answerable-section"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Card"], {
        className: "mb-3"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Card"].Header, {
        onClick: this.toggleCollapse,
        className: classnames__WEBPACK_IMPORTED_MODULE_33___default()(headerClassNames)
      }, this.renderAnswers()), collapsible ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Accordion"].Collapse, {
        eventKey: question['@id']
      }, cardBody) : {
        cardBody
      }));
    }
  }, {
    key: "renderAnswers",
    value: function renderAnswers() {
      var question = this.props.question,
          children = [],
          answers = this._getAnswers(),
          options = this.context.options;

      var cls;
      var isTextarea;

      for (var i = 0, len = answers.length; i < len; i++) {
        isTextarea = _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isTextarea(question, _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].resolveValue(answers[i])) || _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isSparqlInput(question) || _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isTurtleInput(question);
        cls = classnames__WEBPACK_IMPORTED_MODULE_33___default()('answer', Question._getQuestionCategoryClass(question), Question.getEmphasizedOnRelevantClass(question));
        children.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
          key: 'row-item-' + i,
          className: cls,
          id: question['@id'],
          onMouseEnter: this._onMouseEnterHandler,
          onMouseLeave: this._onMouseLeaveHandler
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
          className: "answer-content",
          style: this._getAnswerWidthStyle()
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_Answer__WEBPACK_IMPORTED_MODULE_21__["default"], {
          index: i,
          answer: answers[i],
          question: question,
          onChange: this.onAnswerChange,
          onCommentChange: this.onCommentChange,
          showIcon: this.state.showIcon
        })), this._renderUnits(), this._renderPrefixes()));
      }

      return children;
    }
  }, {
    key: "_getAnswers",
    value: function _getAnswers() {
      var question = this.props.question;

      if (!question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_ANSWER]) {
        question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_ANSWER] = [];
      }

      if (!Array.isArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_ANSWER])) {
        question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_ANSWER] = [question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_ANSWER]];
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_ANSWER].length === 0) {
        if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isSection(question) && !_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isAnswerable(question) || _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isWizardStep(question)) {
          question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_ANSWER] = [];
        } else {
          question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_ANSWER] = [_model_QuestionAnswerProcessor__WEBPACK_IMPORTED_MODULE_26__["default"].generateAnswer(question)];
        }
      }

      return question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_ANSWER];
    }
  }, {
    key: "_getAnswerWidthStyle",
    value: function _getAnswerWidthStyle() {
      var length = Number(this.props.question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_INITIAL_INPUT_LENGTH]);

      if (!length) {
        return {};
      }

      return {
        flexGrow: 0,
        maxWidth: 'none',
        width: "calc(".concat(length, "ch + 1.5rem + 2px)")
      };
    }
  }, {
    key: "_renderCollapseToggle",
    value: function _renderCollapseToggle() {
      var options = this.context.options;
      var title = this.state.expanded ? options.i18n['section.collapse'] : options.i18n['section.expand'];
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("span", {
        onClick: this.toggleCollapse,
        title: title
      }, this.state.expanded ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_styles_icons__WEBPACK_IMPORTED_MODULE_31__["CaretSquareUp"], {
        title: title
      }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_styles_icons__WEBPACK_IMPORTED_MODULE_31__["CaretSquareDown"], {
        title: title
      }));
    }
  }, {
    key: "_renderPrefixes",
    value: function _renderPrefixes() {
      var question = this.props.question;
      return question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_DECLARED_PREFIX] && question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_DECLARED_PREFIX].length ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_PrefixIcon__WEBPACK_IMPORTED_MODULE_29__["default"], {
        prefixes: question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_DECLARED_PREFIX],
        iconClass: 'help-icon-checkbox'
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_styles_icons__WEBPACK_IMPORTED_MODULE_31__["InfoCircle"], null)) : null;
    }
  }, {
    key: "_renderUnits",
    value: function _renderUnits() {
      var question = this.props.question;
      return question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_UNIT] ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
        className: "has-unit-label"
      }, question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_UNIT]) : null;
    }
  }, {
    key: "renderSubQuestions",
    value: function renderSubQuestions() {
      var children = [];

      var subQuestions = this._getSubQuestions();

      for (var i = 0; i < subQuestions.length; i++) {
        var question = subQuestions[i];
        var component = this.context.mapComponent(question, Question);
        var element = react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(component, {
          key: 'sub-question-' + i,
          question: question,
          onChange: this.onSubQuestionChange,
          index: i
        });
        children.push(element);
      }

      return children;
    }
  }, {
    key: "_getSubQuestions",
    value: function _getSubQuestions() {
      var question = this.props.question;

      if (!question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_SUBQUESTION]) {
        question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_SUBQUESTION] = [];
      }

      if (!Array.isArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_SUBQUESTION])) {
        question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_SUBQUESTION] = [question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_SUBQUESTION]];
      } // sort by label


      _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_28__["default"].orderByLocalizedLabels(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_SUBQUESTION], this.context.options.intl); // sort by property

      _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_28__["default"].orderPreservingToplogicalSort(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_SUBQUESTION], _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_PRECEDING_QUESTION);
      return question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HAS_SUBQUESTION];
    }
  }, {
    key: "_getFirstAnswerValue",
    value: function _getFirstAnswerValue() {
      return _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].resolveValue(this._getAnswers()[0]);
    }
  }], [{
    key: "_getAnswerClass",
    value: function _getAnswerClass(question, isTextarea) {
      var columns = isTextarea ? 'col-12' : _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].GENERATED_ROW_SIZE === 1 ? 'col-6' : 'col-' + _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].COLUMN_COUNT / _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].GENERATED_ROW_SIZE;
      return columns;
    }
  }, {
    key: "_getQuestionCategoryClass",
    value: function _getQuestionCategoryClass(question) {
      var layoutCategory = _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].getCategory(question);
      return layoutCategory ? 'question-' + layoutCategory : '';
    }
  }, {
    key: "getEmphasizedClass",
    value: function getEmphasizedClass(question) {
      return _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isEmphasised(question) ? 'bg-warning' : '';
    }
  }, {
    key: "getEmphasizedOnRelevantClass",
    value: function getEmphasizedOnRelevantClass(question) {
      if (jsonld_utils__WEBPACK_IMPORTED_MODULE_19___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].LAYOUT.EMPHASISE_ON_RELEVANT)) {
        return 'emphasise-on-relevant';
      }

      return '';
    }
  }, {
    key: "getIconComponent",
    value: function getIconComponent(icon, question, options, onCommentChange, showIcon) {
      var iconClassname;

      if (icon && (icon.behavior === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICON_BEHAVIOR.ON_HOVER || icon.behavior === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICON_BEHAVIOR.ENABLE)) {
        if (icon.behavior === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICON_BEHAVIOR.ENABLE) {
          showIcon = true;
          iconClassname = "";
        } else iconClassname = "emphasise-on-relevant-icon";

        if (icon.id === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICONS.QUESTION_HELP && question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HELP_DESCRIPTION]) {
          if (showIcon) {
            return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
              className: iconClassname
            }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_HelpIcon__WEBPACK_IMPORTED_MODULE_24__["default"], {
              text: jsonld_utils__WEBPACK_IMPORTED_MODULE_19___default.a.getLocalized(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].HELP_DESCRIPTION], options.intl),
              absolutePosition: false
            }));
          }

          return null;
        }

        if (icon.id === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICONS.QUESTION_LINK && question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].SOURCE]) {
          if (showIcon) {
            return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
              className: iconClassname
            }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_LinkIcon__WEBPACK_IMPORTED_MODULE_35__["default"], {
              url: question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].SOURCE]
            }));
          }

          return null;
        }

        if (icon.id === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICONS.QUESTION_COMMENTS) {
          if (showIcon) {
            return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
              className: iconClassname
            }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_comment_QuestionCommentIcon__WEBPACK_IMPORTED_MODULE_34__["default"], {
              question: question,
              onChange: onCommentChange
            }));
          }

          return null;
        }

        return null;
      }
    }
  }, {
    key: "getIconComponentFromName",
    value: function getIconComponentFromName(iconName, question, options, onCommentChange, showIcon) {
      var iconList = options.icons ? options.icons : _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].DEFAULT_OPTIONS.icons;
      var icon = this.getIconFromIconList(iconList, iconName);
      return this.getIconComponent(icon, question, options, onCommentChange, showIcon);
    }
  }, {
    key: "renderQuestionHelp",
    value: function renderQuestionHelp(question, options, onCommentChange, showIcon) {
      return this.getIconComponentFromName(_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICONS.QUESTION_HELP, question, options, onCommentChange, showIcon);
    }
  }, {
    key: "renderQuestionLink",
    value: function renderQuestionLink(question, options, onCommentChange, showIcon) {
      return this.getIconComponentFromName(_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICONS.QUESTION_LINK, question, options, onCommentChange, showIcon);
    }
  }, {
    key: "renderIcons",
    value: function renderIcons(question, options, onCommentChange, showIcon) {
      var icons;
      if (options.icons) icons = options.icons;else icons = _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].DEFAULT_OPTIONS.icons;
      var iconsArray = [];
      var renderQuestionHelp = Question.renderQuestionHelp(question, options, onCommentChange, showIcon);
      var renderQuestionComments = Question.renderQuestionComments(question, options, onCommentChange, showIcon);
      var renderQuestionLink = Question.renderQuestionLink(question, options, onCommentChange, showIcon);

      for (var i = 0; i < icons.length; i++) {
        if (icons[i].id === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICONS.QUESTION_COMMENTS) {
          iconsArray.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("li", {
            key: i,
            className: "icon-list-item"
          }, renderQuestionComments));
        }

        if (icons[i].id === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICONS.QUESTION_HELP) {
          iconsArray.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("li", {
            key: i,
            className: "icon-list-item"
          }, renderQuestionHelp));
        }

        if (icons[i].id === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICONS.QUESTION_LINK) {
          iconsArray.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("li", {
            key: i,
            className: "icon-list-item"
          }, renderQuestionLink));
        }
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("ol", {
        className: "icon-list-items"
      }, iconsArray);
    }
  }]);

  return Question;
}(react__WEBPACK_IMPORTED_MODULE_17___default.a.Component);

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(Question, "getIconFromIconList", function (iconList, iconName) {
  if (iconList) return iconList.find(function (icon) {
    return icon.id === iconName;
  });
  return null;
});

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(Question, "renderQuestionComments", function (question, options, onCommentChange, showIcon) {
  return Question.getIconComponentFromName(_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["default"].ICONS.QUESTION_COMMENTS, question, options, onCommentChange, showIcon);
});


Question.contextType = _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_32__["ConfigurationContext"];
Question.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_20___default.a.object.isRequired,
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_20___default.a.func.isRequired,
  index: prop_types__WEBPACK_IMPORTED_MODULE_20___default.a.number,
  withoutCard: prop_types__WEBPACK_IMPORTED_MODULE_20___default.a.bool,
  collapsible: prop_types__WEBPACK_IMPORTED_MODULE_20___default.a.bool // Whether the section is collapsible (if the question is a section)

};
Question.defaultProps = {
  withoutCard: false,
  collapsible: true
};

/***/ }),

/***/ "./components/SForms.jsx":
/*!*******************************!*\
  !*** ./components/SForms.jsx ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description */ "core-js/modules/es.symbol.description");
/* harmony import */ var core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_from__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.from */ "core-js/modules/es.array.from");
/* harmony import */ var core_js_modules_es_array_from__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.iterator */ "core-js/modules/es.array.iterator");
/* harmony import */ var core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.slice */ "core-js/modules/es.array.slice");
/* harmony import */ var core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_some__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.some */ "core-js/modules/es.array.some");
/* harmony import */ var core_js_modules_es_array_some__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_some__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator */ "core-js/modules/web.dom-collections.iterator");
/* harmony import */ var core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/regenerator */ "@babel/runtime/regenerator");
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! regenerator-runtime/runtime */ "regenerator-runtime/runtime");
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "@babel/runtime/helpers/asyncToGenerator");
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../contexts/FormGenContext */ "./contexts/FormGenContext.js");
/* harmony import */ var _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../contexts/FormQuestionsContext */ "./contexts/FormQuestionsContext.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _model_FormGenerator__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../model/FormGenerator */ "./model/FormGenerator.js");
/* harmony import */ var _FormManager__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./FormManager */ "./components/FormManager.jsx");
/* harmony import */ var _s_forms__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../s-forms */ "./s-forms.js");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_21__);














function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }










var SForms = Object(react__WEBPACK_IMPORTED_MODULE_13__["forwardRef"])(function (props, ref) {
  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_13__["useState"])(true),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12___default()(_useState, 2),
      loading = _useState2[0],
      setLoading = _useState2[1];

  var _useState3 = Object(react__WEBPACK_IMPORTED_MODULE_13__["useState"])(null),
      _useState4 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12___default()(_useState3, 2),
      formProperties = _useState4[0],
      setFormProperties = _useState4[1];

  var _useState5 = Object(react__WEBPACK_IMPORTED_MODULE_13__["useState"])(null),
      _useState6 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12___default()(_useState5, 2),
      form = _useState6[0],
      setForm = _useState6[1];

  Object(react__WEBPACK_IMPORTED_MODULE_13__["useEffect"])(function () {
    var initialiseSForms = /*#__PURE__*/function () {
      var _ref = _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11___default()( /*#__PURE__*/_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_9___default.a.mark(function _callee() {
        var intl, _yield$FormGenerator$, _yield$FormGenerator$2, formProperties, structure;

        return _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_9___default.a.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                intl = props.options.intl;
                _context.next = 3;
                return _model_FormGenerator__WEBPACK_IMPORTED_MODULE_18__["default"].constructForm(props.form, intl);

              case 3:
                _yield$FormGenerator$ = _context.sent;
                _yield$FormGenerator$2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12___default()(_yield$FormGenerator$, 2);
                formProperties = _yield$FormGenerator$2[0];
                structure = _yield$FormGenerator$2[1];

                if (formProperties.formQuestions.some(function (step) {
                  return _s_forms__WEBPACK_IMPORTED_MODULE_20__["FormUtils"].isWizardStep(step);
                })) {
                  formProperties.formQuestions[0].visited = true;
                }

                setFormProperties(formProperties);
                setForm(structure);
                setLoading(false);

              case 11:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function initialiseSForms() {
        return _ref.apply(this, arguments);
      };
    }();

    initialiseSForms();
  }, [props.form]);

  if (loading) {
    return props.loader || /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_13___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_21__["Card"], {
      className: "p-3 font-italic"
    }, "Loading SForms...");
  }

  var _getComponentMappingFunction = function _getComponentMappingFunction(components, form) {
    return function (question, defaultComponent) {
      if (!components) {
        return defaultComponent;
      }

      var _iterator = _createForOfIteratorHelper(components),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = _step.value,
              component = _step$value.component,
              mapRule = _step$value.mapRule;

          if (mapRule(question, form)) {
            return component;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return defaultComponent;
    };
  };

  var _mapComponent = _getComponentMappingFunction(props.componentMapRules, form);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_13___default.a.createElement(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_17__["ConfigurationContextProvider"], {
    components: props.components,
    componentsOptions: props.componentsOptions,
    mapComponent: _mapComponent,
    options: props.options
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_13___default.a.createElement(_contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_15__["FormGenContextProvider"], {
    fetchTypeAheadValues: props.fetchTypeAheadValues
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_13___default.a.createElement(_contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_16__["FormQuestionsProvider"], {
    data: form,
    formQuestions: formProperties.formQuestions,
    isFormValid: props.isFormValid
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_13___default.a.createElement(_FormManager__WEBPACK_IMPORTED_MODULE_19__["default"], {
    ref: ref,
    modalView: props.options && props.options.modalView,
    mapComponent: _mapComponent
  }))));
});
SForms.propTypes = {
  form: prop_types__WEBPACK_IMPORTED_MODULE_14___default.a.object.isRequired,
  options: prop_types__WEBPACK_IMPORTED_MODULE_14___default.a.object.isRequired,
  componentMapRules: prop_types__WEBPACK_IMPORTED_MODULE_14___default.a.array,
  components: prop_types__WEBPACK_IMPORTED_MODULE_14___default.a.object,
  componentsOptions: prop_types__WEBPACK_IMPORTED_MODULE_14___default.a.object,
  fetchTypeAheadValues: prop_types__WEBPACK_IMPORTED_MODULE_14___default.a.func,
  isFormValid: prop_types__WEBPACK_IMPORTED_MODULE_14___default.a.func,
  loader: prop_types__WEBPACK_IMPORTED_MODULE_14___default.a.element
};
/* harmony default export */ __webpack_exports__["default"] = (SForms);

/***/ }),

/***/ "./components/answer/CheckboxAnswer.jsx":
/*!**********************************************!*\
  !*** ./components/answer/CheckboxAnswer.jsx ***!
  \**********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");









function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }







var InputPropertiesResolver = /*#__PURE__*/function () {
  function InputPropertiesResolver() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_6___default()(this, InputPropertiesResolver);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_7___default()(InputPropertiesResolver, null, [{
    key: "resolveValidationProperties",
    value: function resolveValidationProperties(question) {
      var props = {};

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_11__["default"].HAS_VALID_ANSWER] === false) {
        props['validation'] = 'error';
        props['help'] = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_11__["default"].HAS_VALIDATION_MESSAGE];
      }

      return props;
    }
  }]);

  return InputPropertiesResolver;
}();

var CheckboxAnswer = function CheckboxAnswer(props) {
  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_8__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_12__["ConfigurationContext"]),
      inputComponent = _useContext.inputComponent,
      componentsOptions = _useContext.componentsOptions;

  var question = props.question;
  return react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(inputComponent, _objectSpread(_objectSpread({}, InputPropertiesResolver.resolveValidationProperties(question)), {}, {
    type: 'checkbox',
    label: props.label,
    title: props.title,
    checked: props.value === true || props.value === 'true',
    onChange: function onChange(e) {
      props.onChange(e.target.checked);
    },
    disabled: componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_10__["default"].isDisabled(question)
  }));
};

CheckboxAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.object.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.string, prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.bool]),
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.func.isRequired,
  mouseHover: prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.bool
};
/* harmony default export */ __webpack_exports__["default"] = (CheckboxAnswer);

/***/ }),

/***/ "./components/answer/DateTimeAnswer.jsx":
/*!**********************************************!*\
  !*** ./components/answer/DateTimeAnswer.jsx ***!
  \**********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.number.constructor */ "core-js/modules/es.number.constructor");
/* harmony import */ var core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_datepicker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-datepicker */ "react-datepicker");
/* harmony import */ var react_datepicker__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_datepicker__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! date-fns */ "date-fns");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(date_fns__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _util_Utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/Utils */ "./util/Utils.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");











var DateTimeAnswer = function DateTimeAnswer(props) {
  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_9__["ConfigurationContext"]),
      componentsOptions = _useContext.componentsOptions;

  var dateFormat = _util_Utils__WEBPACK_IMPORTED_MODULE_6__["default"].resolveDateTimeFormat(props.question, props.value, componentsOptions.dateTimeAnswer);
  var isDate = _util_FormUtils__WEBPACK_IMPORTED_MODULE_7__["default"].isDate(props.question);
  var isTime = _util_FormUtils__WEBPACK_IMPORTED_MODULE_7__["default"].isTime(props.question); // workaround because it is not possible to construct Date only with time

  var value;

  if (isTime && props.value) {
    value = new Date("0 ".concat(props.value));
  } else {
    value = props.value ? new Date(props.value) : null;
  } // DatePicker does not know dateFormat "x", translate to datetime


  var datePickerFormat = dateFormat === 'x' ? componentsOptions.dateTimeAnswer.dateTimeFormat : dateFormat;

  var onChange = function onChange(date) {
    if (dateFormat === _constants_Constants__WEBPACK_IMPORTED_MODULE_8__["default"].DATETIME_NUMBER_FORMAT) {
      props.onChange(Number(date));
    } else {
      props.onChange(Object(date_fns__WEBPACK_IMPORTED_MODULE_5__["format"])(date, dateFormat));
    }
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["FormGroup"], {
    size: "small"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Form"].Label, {
    className: 'w-100'
  }, props.label), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_datepicker__WEBPACK_IMPORTED_MODULE_2___default.a, {
    selected: value,
    placeholderText: datePickerFormat.toUpperCase(),
    onChange: onChange,
    showTimeSelect: !isDate,
    showTimeSelectOnly: isTime,
    timeFormat: "HH:mm",
    timeIntervals: 1,
    timeCaption: "Time",
    dateFormat: datePickerFormat,
    className: "form-control",
    disabled: componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_7__["default"].isDisabled(props.question)
  }));
};

DateTimeAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.object.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.string, prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.number]),
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (DateTimeAnswer);

/***/ }),

/***/ "./components/answer/InputAnswer.jsx":
/*!*******************************************!*\
  !*** ./components/answer/InputAnswer.jsx ***!
  \*******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.index-of */ "core-js/modules/es.array.index-of");
/* harmony import */ var core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.slice */ "core-js/modules/es.array.slice");
/* harmony import */ var core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var yasgui_yasqe__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! yasgui-yasqe */ "yasgui-yasqe");
/* harmony import */ var yasgui_yasqe__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(yasgui_yasqe__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _triply_yasgui_build_yasgui_min_css__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @triply/yasgui/build/yasgui.min.css */ "@triply/yasgui/build/yasgui.min.css");
/* harmony import */ var _triply_yasgui_build_yasgui_min_css__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_triply_yasgui_build_yasgui_min_css__WEBPACK_IMPORTED_MODULE_17__);











var _this = undefined;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }










var NUMERIC_DATATYPES = [_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.INT, _constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.INTEGER, _constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.NON_NEGATIVE_INTEGER, _constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.NON_POSITIVE_INTEGER, _constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.NEGATIVE_INTEGER, _constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.POSITIVE_INTEGER];
var DECLARED_PREFIXES = 'http://onto.fel.cvut.cz/ontologies/form-spin/has-declared-prefix';
var NUMBER_RULES = {};
NUMBER_RULES[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.NON_NEGATIVE_INTEGER] = {
  min: 0
};
NUMBER_RULES[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.NON_POSITIVE_INTEGER] = {
  max: 0
};
NUMBER_RULES[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.NEGATIVE_INTEGER] = {
  max: -1
};
NUMBER_RULES[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.POSITIVE_INTEGER] = {
  min: 1
};
var tokenTypes = {
  'string-2': 'prefixed',
  atom: 'var'
};

var InputPropertiesResolver = /*#__PURE__*/function () {
  function InputPropertiesResolver() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8___default()(this, InputPropertiesResolver);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9___default()(InputPropertiesResolver, null, [{
    key: "_resolveInputType",
    value: function _resolveInputType(question, value) {
      if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isSparqlInput(question) || _util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isTurtleInput(question) || _util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isTextarea(question, value)) {
        return 'textarea';
      } else if (InputPropertiesResolver._isNumeric(question)) {
        return 'number';
      }

      return 'text';
    }
  }, {
    key: "_isNumeric",
    value: function _isNumeric(question) {
      for (var i = 0, len = NUMERIC_DATATYPES.length; i < len; i++) {
        if (jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].HAS_DATATYPE, NUMERIC_DATATYPES[i])) {
          return true;
        }
      }

      return false;
    }
  }, {
    key: "resolveInputProperties",
    value: function resolveInputProperties(question, value, componentsOptions) {
      var props = {};
      props.type = InputPropertiesResolver._resolveInputType(question, value);

      switch (props['type']) {
        case 'textarea':
          props.rows = 5;
          break;

        case 'number':
          props = _objectSpread(_objectSpread(_objectSpread({}, props), InputPropertiesResolver._resolveNumberRestrictions(question)), this._resolveStepRestriction(question));
          break;

        default:
          break;
      }

      props.disabled = componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isDisabled(question);

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].HAS_VALID_ANSWER] === false) {
        props.validation = 'error';
        props.help = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].HAS_VALIDATION_MESSAGE];
      }

      return props;
    }
  }, {
    key: "_resolveStepRestriction",
    value: function _resolveStepRestriction(question) {
      var restriction = {};

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].STEP] !== undefined) {
        restriction['step'] = jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default.a.getJsonAttValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].STEP);
      }

      return restriction;
    }
  }, {
    key: "_resolveNumberRestrictions",
    value: function _resolveNumberRestrictions(question) {
      var restriction = {};
      Object.getOwnPropertyNames(NUMBER_RULES).forEach(function (key) {
        if (jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].HAS_DATATYPE, key)) {
          restriction = _objectSpread(_objectSpread({}, restriction), NUMBER_RULES[key]);
        }
      });

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.MIN_INCLUSIVE] !== undefined) {
        restriction['min'] = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.MIN_INCLUSIVE];
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.MIN_EXCLUSIVE] !== undefined) {
        restriction['min'] = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.MIN_EXCLUSIVE] + 1;
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.MAX_EXCLUSIVE] !== undefined) {
        restriction['max'] = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.MAX_EXCLUSIVE] - 1;
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.MAX_INCLUSIVE] !== undefined) {
        restriction['max'] = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].XSD.MAX_INCLUSIVE];
      }

      return restriction;
    }
  }]);

  return InputPropertiesResolver;
}();

var InputAnswer = function InputAnswer(props) {
  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_10__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_16__["ConfigurationContext"]),
      inputComponent = _useContext.inputComponent,
      componentsOptions = _useContext.componentsOptions;

  var question = props.question;
  var answer = props.answer;
  var value = props.value; // When the value is an object_value, but the layout does not specify neither typeahead nor select,
  // show at least the value's label

  if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].HAS_OBJECT_VALUE] && answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].HAS_OBJECT_VALUE][jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default.a.RDFS_LABEL]) {
    value = jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default.a.getJsonAttValue(answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].HAS_OBJECT_VALUE], jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default.a.RDFS_LABEL);
  }

  return react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(inputComponent, _objectSpread(_objectSpread({}, InputPropertiesResolver.resolveInputProperties(question, value, componentsOptions)), {}, {
    label: props.label,
    title: props.title,
    value: value == null ? '' : value,
    onChange: function onChange(e) {
      props.onChange(e.target.value);
      if (props.sparql || props.turtle) _this.hide();
    },
    onFocus: function onFocus(e) {
      if (props.sparql) {
        var yasqe = yasgui_yasqe__WEBPACK_IMPORTED_MODULE_15___default.a.fromTextArea(e.target);
        yasqe.setValue(value);
        yasqe.on('change', function () {
          props.onChange(yasqe.getValue());
        });

        yasgui_yasqe__WEBPACK_IMPORTED_MODULE_15___default.a.Autocompleters.prefixes.appendPrefixIfNeeded = function (yasqe, completerName) {
          if (!yasqe.autocompleters.getTrie(completerName)) return; // no prefixed defined. just stop

          if (!yasqe.options.autocompleters || yasqe.options.autocompleters.indexOf(completerName) === -1) return; //this autocompleter is disabled

          var cur = yasqe.getCursor();
          var token = yasqe.getTokenAt(cur);

          if (tokenTypes[token.type] === 'prefixed') {
            var colonIndex = token.string.indexOf(':');

            if (colonIndex !== -1) {
              // check previous token isnt PREFIX, or a '<'(which would mean we are in a uri)
              //			const firstTokenString = yasqe.getNextNonWsToken(cur.line).string.toUpperCase();
              var lastNonWsTokenString = yasqe.getPreviousNonWsToken(cur.line, token).string.toUpperCase();
              var previousToken = yasqe.getTokenAt({
                line: cur.line,
                ch: token.start
              }); // needs to be null (beginning of line), or whitespace

              if (lastNonWsTokenString !== 'PREFIX' && (previousToken.type === 'ws' || previousToken.type == null)) {
                // check whether it isnt defined already (saves us from looping
                // through the array)
                var currentPrefix = token.string.substring(0, colonIndex + 1);
                var queryPrefixes = yasqe.getPrefixesFromQuery();

                if (queryPrefixes[currentPrefix.slice(0, -1)] == null) {
                  // ok, so it isnt added yet!
                  if (props.question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].HAS_DECLARED_PREFIX] && props.question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].HAS_DECLARED_PREFIX].filter(function (p) {
                    return p[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].PREFIX] === currentPrefix.slice(0, -1);
                  }).length) {
                    var prefix = props.question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].HAS_DECLARED_PREFIX].filter(function (p) {
                      return p[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].PREFIX] === currentPrefix.slice(0, -1);
                    });
                    var px = {};
                    px[prefix[0][_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].PREFIX]] = prefix[0][_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["default"].NAMESPACE];
                    yasqe.addPrefixes(px);
                  } else {
                    var completions = yasqe.autocompleters.getTrie(completerName).autoComplete(currentPrefix);

                    if (completions.length > 0) {
                      yasqe.addPrefixes(completions[0]);
                    }
                  }
                }
              }
            }
          }
        };
      } else if (props.turtle) {
        console.log('TTL');
        var yate = yasgui_yasqe__WEBPACK_IMPORTED_MODULE_15___default.a.fromTextArea(e.target);
        yate.setValue(value);
        yate.on('change', function () {
          props.onChange(yate.getValue());
        });
      }
    }
  }));
};

InputAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.object.isRequired,
  answer: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.object.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.string, prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.number]),
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (InputAnswer);

/***/ }),

/***/ "./components/answer/MaskedInputAnswer.jsx":
/*!*************************************************!*\
  !*** ./components/answer/MaskedInputAnswer.jsx ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _InputAnswer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./InputAnswer */ "./components/answer/InputAnswer.jsx");
/* harmony import */ var _util_Logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/Logger */ "./util/Logger.js");
/* harmony import */ var _MaskedInput__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../MaskedInput */ "./components/MaskedInput.jsx");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");










var MaskedInputAnswer = function MaskedInputAnswer(props) {
  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_8__["ConfigurationContext"]),
      componentsOptions = _useContext.componentsOptions;

  var question = props.question;
  var value = props.value;
  var mask = jsonld_utils__WEBPACK_IMPORTED_MODULE_1___default.a.getJsonAttValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].INPUT_MASK);

  if (!mask) {
    _util_Logger__WEBPACK_IMPORTED_MODULE_6__["default"].warn('Input mask not provided. Falling back to regular input.');
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_InputAnswer__WEBPACK_IMPORTED_MODULE_5__["default"], props);
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_MaskedInput__WEBPACK_IMPORTED_MODULE_7__["default"], {
    mask: mask,
    value: value,
    label: props.label,
    title: props.title,
    placeholder: mask,
    onChange: function onChange(e) {
      return props.onChange(e.target.value);
    },
    disabled: componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_4__["default"].isDisabled(question)
  });
};

MaskedInputAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.object.isRequired,
  answer: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.object.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.string, prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.number]),
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (MaskedInputAnswer);

/***/ }),

/***/ "./components/answer/OptimizedMenuList.jsx":
/*!*************************************************!*\
  !*** ./components/answer/OptimizedMenuList.jsx ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.index-of */ "core-js/modules/es.array.index-of");
/* harmony import */ var core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_window__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-window */ "react-window");
/* harmony import */ var react_window__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_window__WEBPACK_IMPORTED_MODULE_2__);



var HEIGHT = 40;
/**
 * Uses react-window to optimize menu list in react-select in case it has a lot of options.
 */

var OptimizedMenuList = function OptimizedMenuList(props) {
  var options = props.options,
      children = props.children,
      maxHeight = props.maxHeight,
      getValue = props.getValue;
  var selectedValues = getValue();
  var initialOffset = selectedValues && selectedValues[0] ? options.indexOf(selectedValues[0]) * HEIGHT : 0;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_window__WEBPACK_IMPORTED_MODULE_2__["FixedSizeList"], {
    height: maxHeight,
    itemCount: children["length"],
    itemSize: HEIGHT,
    initialScrollOffset: initialOffset,
    width: "" // 100% width

  }, function (_ref) {
    var index = _ref.index,
        style = _ref.style;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", {
      className: "option-wrapper",
      style: style
    }, children[index]);
  });
};

/* harmony default export */ __webpack_exports__["default"] = (OptimizedMenuList);

/***/ }),

/***/ "./components/answer/SelectAnswer.jsx":
/*!********************************************!*\
  !*** ./components/answer/SelectAnswer.jsx ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return SelectAnswer; });
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");










function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var SelectAnswer = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6___default()(SelectAnswer, _React$Component);

  var _super = _createSuper(SelectAnswer);

  function SelectAnswer() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4___default()(this, SelectAnswer);

    return _super.apply(this, arguments);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5___default()(SelectAnswer, [{
    key: "_generateSelectOptions",
    value: function _generateSelectOptions(options) {
      var rendered = [];
      options.sort(function (a, b) {
        var aLabel = jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default.a.getJsonAttValue(a, _constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].RDFS_LABEL),
            bLabel = jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default.a.getJsonAttValue(b, _constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].RDFS_LABEL);

        if (aLabel < bLabel) {
          return -1;
        }

        if (aLabel > bLabel) {
          return 1;
        }

        return 0;
      });

      for (var i = 0; i < options.length; i++) {
        rendered.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("option", {
          value: jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default.a.getJsonAttValue(options[i], _constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].RDFS_LABEL),
          key: 'opt-' + i
        }, jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default.a.getJsonAttValue(options[i], _constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].RDFS_LABEL)));
      }

      return rendered;
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var question = this.props.question;
      return react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement(this.context.inputComponent, {
        type: 'select',
        label: this.props.label,
        value: this.props.value,
        title: this.props.title,
        onChange: function onChange(e) {
          _this.props.onChange(e.target.value);
        },
        disabled: this.context.componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_13__["default"].isDisabled(question)
      }, this._generateSelectOptions(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].HAS_OPTION]));
    }
  }]);

  return SelectAnswer;
}(react__WEBPACK_IMPORTED_MODULE_9___default.a.Component);


SelectAnswer.contextType = _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_14__["ConfigurationContext"];
SelectAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.object.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.string,
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.func.isRequired
};

/***/ }),

/***/ "./components/answer/TypeaheadAnswer.jsx":
/*!***********************************************!*\
  !*** ./components/answer/TypeaheadAnswer.jsx ***!
  \***********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description */ "core-js/modules/es.symbol.description");
/* harmony import */ var core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "@babel/runtime/helpers/extends");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/regenerator */ "@babel/runtime/regenerator");
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! regenerator-runtime/runtime */ "regenerator-runtime/runtime");
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "@babel/runtime/helpers/asyncToGenerator");
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react-select */ "react-select");
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_select__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _util_Utils__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../util/Utils */ "./util/Utils.js");
/* harmony import */ var _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../util/JsonLdObjectUtils */ "./util/JsonLdObjectUtils.js");
/* harmony import */ var _util_Logger__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../util/Logger */ "./util/Logger.js");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var _contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../contexts/FormGenContext */ "./contexts/FormGenContext.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _OptimizedMenuList__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./OptimizedMenuList */ "./components/answer/OptimizedMenuList.jsx");














function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_8___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }















var processTypeaheadOptions = function processTypeaheadOptions(options, intl) {
  if (!options) {
    return [];
  } // sort by label


  options.sort(_util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_20__["default"].getCompareLocalizedLabelFunction(intl)); // sort by property

  _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_20__["default"].orderPreservingToplogicalSort(options, _constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].HAS_PRECEDING_VALUE);
  return jsonld_utils__WEBPACK_IMPORTED_MODULE_14___default.a.processTypeaheadOptions(options, intl);
};

var TypeaheadAnswer = function TypeaheadAnswer(props) {
  var queryHash = _util_Utils__WEBPACK_IMPORTED_MODULE_19__["default"].getStringHash(_util_FormUtils__WEBPACK_IMPORTED_MODULE_18__["default"].getPossibleValuesQuery(props.question));
  var formGenContext = Object(react__WEBPACK_IMPORTED_MODULE_13__["useContext"])(_contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_23__["FormGenContext"]);
  var configurationContext = Object(react__WEBPACK_IMPORTED_MODULE_13__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_24__["ConfigurationContext"]);
  var intl = configurationContext.options.intl;

  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_13__["useState"])(true),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12___default()(_useState, 2),
      isLoading = _useState2[0],
      setLoading = _useState2[1];

  var _useState3 = Object(react__WEBPACK_IMPORTED_MODULE_13__["useState"])(processTypeaheadOptions(props.options, intl)),
      _useState4 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12___default()(_useState3, 2),
      options = _useState4[0],
      setOptions = _useState4[1];

  Object(react__WEBPACK_IMPORTED_MODULE_13__["useEffect"])(function () {
    var isCancelled = false;
    var question = props.question;

    function loadFormOptions() {
      return _loadFormOptions.apply(this, arguments);
    }

    function _loadFormOptions() {
      _loadFormOptions = _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11___default()( /*#__PURE__*/_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_9___default.a.mark(function _callee() {
        var _options;

        return _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_9___default.a.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return formGenContext.loadFormOptions(queryHash, _util_FormUtils__WEBPACK_IMPORTED_MODULE_18__["default"].getPossibleValuesQuery(question));

              case 3:
                _options = _context.sent;

                if (!isCancelled) {
                  setLoading(false);
                  setOptions(processTypeaheadOptions(_options, intl));
                }

                _context.next = 10;
                break;

              case 7:
                _context.prev = 7;
                _context.t0 = _context["catch"](0);
                _util_Logger__WEBPACK_IMPORTED_MODULE_21__["default"].error("An error has occurred during loadFormOptions for query hash: ".concat(queryHash));

              case 10:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[0, 7]]);
      }));
      return _loadFormOptions.apply(this, arguments);
    }

    if (!question[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].HAS_OPTION] && _util_FormUtils__WEBPACK_IMPORTED_MODULE_18__["default"].getPossibleValuesQuery(question)) {
      loadFormOptions();
    } else {
      setLoading(false);
      setOptions(processTypeaheadOptions(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].HAS_OPTION], intl));
    }

    return function () {
      isCancelled = true;
    };
  }, []);
  Object(react__WEBPACK_IMPORTED_MODULE_13__["useEffect"])(function () {
    setOptions(processTypeaheadOptions(props.question[_constants_Constants__WEBPACK_IMPORTED_MODULE_17__["default"].HAS_OPTION], intl));
  }, [intl]);

  var onOptionSelected = function onOptionSelected(option) {
    props.onChange(option ? option.id : null);
  };

  var Option = react_select__WEBPACK_IMPORTED_MODULE_15__["components"].Option;

  var DescriptionOption = function DescriptionOption(props) {
    var innerProps = _objectSpread(_objectSpread({}, props.innerProps), {}, {
      title: props.data.description
    });

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_13___default.a.createElement(Option, _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7___default()({}, props, {
      title: props.data.description,
      innerProps: innerProps
    }));
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_13___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_22__["FormGroup"], {
    size: "small"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_13___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_22__["Form"].Label, null, props.label), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_13___default.a.createElement(react_select__WEBPACK_IMPORTED_MODULE_15___default.a, {
    options: options,
    isSearchable: true,
    isLoading: isLoading,
    isClearable: true,
    isDisabled: isLoading || configurationContext.componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_18__["default"].isDisabled(props.question),
    value: options.filter(function (option) {
      return option.id === props.value;
    }),
    placeholder: '',
    getOptionLabel: function getOptionLabel(option) {
      return option.name;
    },
    getOptionValue: function getOptionValue(option) {
      return option.id;
    },
    onChange: onOptionSelected,
    components: {
      MenuList: _OptimizedMenuList__WEBPACK_IMPORTED_MODULE_25__["default"],
      Option: DescriptionOption
    }
  }));
};

TypeaheadAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_16___default.a.object.isRequired,
  answer: prop_types__WEBPACK_IMPORTED_MODULE_16___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_16___default.a.object.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_16___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_16___default.a.string,
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_16___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (TypeaheadAnswer);

/***/ }),

/***/ "./components/comment/CommentForm.jsx":
/*!********************************************!*\
  !*** ./components/comment/CommentForm.jsx ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_string_trim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.string.trim */ "core-js/modules/es.string.trim");
/* harmony import */ var core_js_modules_es_string_trim__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _styles_icons_ArrowRight__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../styles/icons/ArrowRight */ "./styles/icons/ArrowRight.jsx");







var CommentForm = function CommentForm(props) {
  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(''),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1___default()(_useState, 2),
      commentValue = _useState2[0],
      setCommentValue = _useState2[1];

  var formInputRef = Object(react__WEBPACK_IMPORTED_MODULE_2__["useRef"])(null);
  Object(react__WEBPACK_IMPORTED_MODULE_2__["useEffect"])(function () {
    formInputRef.current.focus();
  }, []);

  var onValueChange = function onValueChange(e) {
    setCommentValue(e.target.value);
  };

  var submitHandler = function submitHandler(e) {
    e.preventDefault();
    props.onChange(commentValue);
    setCommentValue('');
  };

  var onKeyUpHandler = function onKeyUpHandler(e) {
    if (e.key === 'Enter' && e.ctrlKey && commentValue.trim()) submitHandler(e);
  };

  var onClickHandler = function onClickHandler(e) {
    e.stopPropagation();
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Form"], {
    onSubmit: submitHandler,
    className: "comment-form",
    onKeyUp: onKeyUpHandler,
    onClick: onClickHandler
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Form"].Group, {
    className: "mb-3",
    controlId: "formBasicComment"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Col"], {
    className: "col-lg-12"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Row"], {
    className: "col-lg-12"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Form"].Control, {
    name: "comment",
    as: "textarea",
    placeholder: "Write your comments here  (Ctrl+Enter to confirm)",
    required: true,
    value: commentValue,
    onChange: onValueChange,
    ref: formInputRef
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Row"], {
    className: "send-comment-arrow col-lg-12"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Button"], {
    className: "comment-button",
    variant: "primary",
    type: "submit"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_styles_icons_ArrowRight__WEBPACK_IMPORTED_MODULE_5__["default"], null))))));
};

CommentForm.propTypes = {
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (CommentForm);

/***/ }),

/***/ "./components/comment/CommentList.jsx":
/*!********************************************!*\
  !*** ./components/comment/CommentList.jsx ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_reverse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.reverse */ "core-js/modules/es.array.reverse");
/* harmony import */ var core_js_modules_es_array_reverse__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_reverse__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _CommentView__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CommentView */ "./components/comment/CommentView.jsx");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");








var CommentList = function CommentList(props) {
  var addComments = function addComments() {
    return props.comment.map(function (comment, index) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("div", {
        key: index,
        className: "comment-list-items"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_CommentView__WEBPACK_IMPORTED_MODULE_4__["default"], {
        commentValue: comment[_constants_Constants__WEBPACK_IMPORTED_MODULE_6__["default"].HAS_COMMENT_VALUE],
        author: comment[_constants_Constants__WEBPACK_IMPORTED_MODULE_6__["default"].HAS_AUTHOR] ? comment[_constants_Constants__WEBPACK_IMPORTED_MODULE_6__["default"].HAS_AUTHOR] : null,
        timestamp: comment[_constants_Constants__WEBPACK_IMPORTED_MODULE_6__["default"].HAS_TIMESTAMP]
      }));
    });
  };

  var renderSortedComments = function renderSortedComments() {
    return addComments().sort(function (a, b) {
      return new Date(a.HAS_TIMESTAMP).getTime() - new Date(b.HAS_TIMESTAMP).getTime();
    }).reverse();
  };

  return renderSortedComments();
};

CommentList.propTypes = {
  comment: prop_types__WEBPACK_IMPORTED_MODULE_5___default.a.array.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (CommentList);

/***/ }),

/***/ "./components/comment/CommentView.jsx":
/*!********************************************!*\
  !*** ./components/comment/CommentView.jsx ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.find */ "core-js/modules/es.array.find");
/* harmony import */ var core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_object_values__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.object.values */ "core-js/modules/es.object.values");
/* harmony import */ var core_js_modules_es_object_values__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_values__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_regexp_exec__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.regexp.exec */ "core-js/modules/es.regexp.exec");
/* harmony import */ var core_js_modules_es_regexp_exec__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_string_replace__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.string.replace */ "core-js/modules/es.string.replace");
/* harmony import */ var core_js_modules_es_string_replace__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var javascript_time_ago__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! javascript-time-ago */ "javascript-time-ago");
/* harmony import */ var javascript_time_ago__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(javascript_time_ago__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var javascript_time_ago_locale_en__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! javascript-time-ago/locale/en */ "javascript-time-ago/locale/en");
/* harmony import */ var javascript_time_ago_locale_en__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(javascript_time_ago_locale_en__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _LinkIcon__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../LinkIcon */ "./components/LinkIcon.jsx");
/* harmony import */ var _IconOverlay__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../IconOverlay */ "./components/IconOverlay.jsx");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);














var UNKNOWN_AUTHOR = "Unknown author";

var CommentView = function CommentView(props) {
  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_7__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_10__["ConfigurationContext"]),
      options = _useContext.options;

  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_7__["useState"])(false),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_6___default()(_useState, 2),
      showIRI = _useState2[0],
      setShowIRI = _useState2[1];

  javascript_time_ago__WEBPACK_IMPORTED_MODULE_8___default.a.addLocale(javascript_time_ago_locale_en__WEBPACK_IMPORTED_MODULE_9___default.a);
  var time = new javascript_time_ago__WEBPACK_IMPORTED_MODULE_8___default.a('en-US');

  var getAuthorLabel = function getAuthorLabel() {
    var users = options.users;
    var currentUser = users.find(function (c) {
      return c.id === options.currentUser;
    });

    if (props.author) {
      if (currentUser.label) {
        return currentUser.label;
      } else {
        return getAuthorIRIAbbreviation();
      }
    }

    return UNKNOWN_AUTHOR;
  };

  var getAuthorIRIAbbreviation = function getAuthorIRIAbbreviation() {
    var fullAuthor = props.author['@id'];
    return fullAuthor.replace(/.*[#\/]/, '... ');
  };

  var getAuthorIRI = function getAuthorIRI() {
    if (props.author) {
      return Object.values(props.author).toString();
    }

    return UNKNOWN_AUTHOR;
  };

  var renderAuthor = function renderAuthor() {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_7___default.a.Fragment, null, showIRI ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_7___default.a.Fragment, null, getAuthorLabel(), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default.a.createElement(_LinkIcon__WEBPACK_IMPORTED_MODULE_11__["default"], {
      iconClassContainer: "emphasise-on-relevant-icon",
      url: getAuthorIRI()
    })) : getAuthorLabel());
  };

  var renderTimeAgo = function renderTimeAgo() {
    var getTimeAgoFormat = function getTimeAgoFormat() {
      return time.format(parseInt(props.timestamp));
    };

    var getUTCFormat = function getUTCFormat() {
      return new Date(parseInt(props.timestamp)).toUTCString();
    };

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default.a.createElement(_IconOverlay__WEBPACK_IMPORTED_MODULE_12__["default"], {
      id: "exact-time-overlay",
      tooltipContent: getUTCFormat()
    }, getTimeAgoFormat());
  };

  var onMouseAuthorEventHandler = function onMouseAuthorEventHandler() {
    setShowIRI(!showIRI);
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default.a.createElement("div", {
    className: "comment-content"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default.a.createElement("div", {
    className: "row"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default.a.createElement("span", {
    className: "col-auto comment-author",
    onMouseEnter: onMouseAuthorEventHandler,
    onMouseLeave: onMouseAuthorEventHandler
  }, renderAuthor()), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default.a.createElement("span", {
    className: "col-auto text-muted comment-timestamp"
  }, renderTimeAgo())), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default.a.createElement("div", {
    className: "row"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default.a.createElement("span", {
    className: "col comment-value"
  }, props.commentValue)));
};

CommentView.propTypes = {
  author: prop_types__WEBPACK_IMPORTED_MODULE_13___default.a.object.isRequired,
  timestamp: prop_types__WEBPACK_IMPORTED_MODULE_13___default.a.string.isRequired,
  commentValue: prop_types__WEBPACK_IMPORTED_MODULE_13___default.a.string.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (CommentView);

/***/ }),

/***/ "./components/comment/QuestionCommentIcon.jsx":
/*!****************************************************!*\
  !*** ./components/comment/QuestionCommentIcon.jsx ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "@babel/runtime/helpers/extends");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _styles_icons_CommentBubble__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../styles/icons/CommentBubble */ "./styles/icons/CommentBubble.jsx");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _CommentList__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CommentList */ "./components/comment/CommentList.jsx");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _CommentForm__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./CommentForm */ "./components/comment/CommentForm.jsx");













var QuestionCommentIcon = function QuestionCommentIcon(props) {
  var context = Object(react__WEBPACK_IMPORTED_MODULE_4__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_10__["ConfigurationContext"]);
  var target = Object(react__WEBPACK_IMPORTED_MODULE_4__["useRef"])(null);

  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_4__["useState"])(false),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_3___default()(_useState, 2),
      show = _useState2[0],
      setShow = _useState2[1];

  var _useState3 = Object(react__WEBPACK_IMPORTED_MODULE_4__["useState"])("right"),
      _useState4 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_3___default()(_useState3, 2),
      overlayPlacement = _useState4[0],
      setOverlayPlacement = _useState4[1];

  var hideOverlay = function hideOverlay() {
    setShow(false);
  }; // TODO make util function


  var _getComments = function _getComments() {
    var question = props.question;

    if (!question[_constants_Constants__WEBPACK_IMPORTED_MODULE_9__["default"].HAS_COMMENT]) {
      question[_constants_Constants__WEBPACK_IMPORTED_MODULE_9__["default"].HAS_COMMENT] = [];
    }

    if (!Array.isArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_9__["default"].HAS_COMMENT])) {
      question[_constants_Constants__WEBPACK_IMPORTED_MODULE_9__["default"].HAS_COMMENT] = [question[_constants_Constants__WEBPACK_IMPORTED_MODULE_9__["default"].HAS_COMMENT]];
    }

    return question[_constants_Constants__WEBPACK_IMPORTED_MODULE_9__["default"].HAS_COMMENT];
  };

  var onCommentValueChangeHandler = function onCommentValueChangeHandler(value) {
    var change = {};

    _setComment(change, value);

    props.onChange(getCommentsLength(), change);
  };

  var _setComment = function _setComment(change, value) {
    if (context.options.currentUser) {
      change[_constants_Constants__WEBPACK_IMPORTED_MODULE_9__["default"].HAS_AUTHOR] = {
        "@id": context.options.currentUser
      };
    }

    change[_constants_Constants__WEBPACK_IMPORTED_MODULE_9__["default"].HAS_COMMENT_VALUE] = value;
    change[_constants_Constants__WEBPACK_IMPORTED_MODULE_9__["default"].HAS_TIMESTAMP] = Date.now().toString();
  };

  var onClickHandler = function onClickHandler(e) {
    e.preventDefault();
    e.stopPropagation();
    setShow(!show);
  };

  var getCommentsLength = function getCommentsLength() {
    return _getComments().length;
  };

  var getOverlayPlacement = function getOverlayPlacement(el) {
    if (!el) return;

    if (el.getBoundingClientRect().x > window.innerWidth / 2) {
      setOverlayPlacement("left");
    } else setOverlayPlacement("right");
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("div", {
    ref: function ref(el) {
      return getOverlayPlacement(el);
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("span", {
    ref: target,
    onClick: onClickHandler
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(_styles_icons_CommentBubble__WEBPACK_IMPORTED_MODULE_5__["default"], null), getCommentsLength() > 0 ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_6__["Badge"], {
    className: "comment-badge",
    pill: true,
    variant: "primary"
  }, getCommentsLength()) : null), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_6__["Overlay"], {
    target: target.current,
    show: show,
    placement: overlayPlacement,
    rootClose: true,
    onHide: hideOverlay
  }, function (overlayProps) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_6__["Tooltip"], _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_2___default()({
      className: "comment-tooltip"
    }, overlayProps), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("span", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(_CommentForm__WEBPACK_IMPORTED_MODULE_11__["default"], {
      onChange: onCommentValueChangeHandler
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(_CommentList__WEBPACK_IMPORTED_MODULE_7__["default"], {
      comment: _getComments()
    })));
  }));
};

QuestionCommentIcon.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_8___default.a.object.isRequired,
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_8___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (QuestionCommentIcon);

/***/ }),

/***/ "./components/wizard/HorizontalWizardNav.jsx":
/*!***************************************************!*\
  !*** ./components/wizard/HorizontalWizardNav.jsx ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _Question__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Question */ "./components/Question.jsx");









var HorizontalWizardNav = function HorizontalWizardNav(_ref) {
  var steps = _ref.steps,
      onNavigate = _ref.onNavigate,
      currentStep = _ref.currentStep;

  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_6__["ConfigurationContext"]),
      options = _useContext.options;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["Card"].Header, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["Nav"], {
    variant: "tabs",
    activeKey: currentStep,
    onSelect: function onSelect(key) {
      return onNavigate(parseInt(key));
    }
  }, steps.map(function (step, index) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["NavItem"], {
      key: 'nav' + index,
      id: 'wizard-nav-' + index,
      className: _Question__WEBPACK_IMPORTED_MODULE_7__["default"].getEmphasizedClass(step)
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["NavLink"], {
      eventKey: index,
      active: index === currentStep,
      disabled: !_util_FormUtils__WEBPACK_IMPORTED_MODULE_5__["default"].isRelevant(step)
    }, jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default.a.getLocalized(step[jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default.a.RDFS_LABEL], options.intl)));
  })));
};

HorizontalWizardNav.propTypes = {
  currentStep: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.number.isRequired,
  steps: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.array.isRequired,
  onNavigate: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (HorizontalWizardNav);

/***/ }),

/***/ "./components/wizard/VerticalWizardNav.jsx":
/*!*************************************************!*\
  !*** ./components/wizard/VerticalWizardNav.jsx ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _Question__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Question */ "./components/Question.jsx");









var VerticalWizardNav = function VerticalWizardNav(_ref) {
  var steps = _ref.steps,
      onNavigate = _ref.onNavigate,
      currentStep = _ref.currentStep;

  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_5__["ConfigurationContext"]),
      options = _useContext.options;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", {
    className: "wizard-nav col-2 p-0"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["ListGroup"], null, steps.map(function (step, index) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["ListGroupItem"], {
      hidden: !_util_FormUtils__WEBPACK_IMPORTED_MODULE_6__["default"].isRelevant(step),
      key: 'nav' + index,
      onClick: function onClick() {
        return onNavigate(index);
      },
      id: 'wizard-nav-' + index,
      action: true,
      active: index === currentStep ? 'active' : '',
      variant: 'default',
      className: _Question__WEBPACK_IMPORTED_MODULE_7__["default"].getEmphasizedClass(step)
    }, jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default.a.getLocalized(step[jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default.a.RDFS_LABEL], options.intl));
  })));
};

VerticalWizardNav.propTypes = {
  currentStep: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.number.isRequired,
  steps: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.array.isRequired,
  onNavigate: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (VerticalWizardNav);

/***/ }),

/***/ "./components/wizard/Wizard.jsx":
/*!**************************************!*\
  !*** ./components/wizard/Wizard.jsx ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_find_index__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.find-index */ "core-js/modules/es.array.find-index");
/* harmony import */ var core_js_modules_es_array_find_index__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_find_index__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _WizardStep__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./WizardStep */ "./components/wizard/WizardStep.jsx");
/* harmony import */ var _HorizontalWizardNav__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./HorizontalWizardNav */ "./components/wizard/HorizontalWizardNav.jsx");
/* harmony import */ var _VerticalWizardNav__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./VerticalWizardNav */ "./components/wizard/VerticalWizardNav.jsx");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../contexts/FormQuestionsContext */ "./contexts/FormQuestionsContext.js");
/* harmony import */ var _util_Utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../util/Utils */ "./util/Utils.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");












var findStepByQuestionId = function findStepByQuestionId(stepData, id) {
  var findQuestionTraversal = function findQuestionTraversal(question, index) {
    if (!question) {
      return -1;
    }

    if (question['@id'] === id) {
      return index;
    }

    var subQuestions = _util_Utils__WEBPACK_IMPORTED_MODULE_9__["default"].asArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_10__["default"].HAS_SUBQUESTION]);
    return subQuestions.findIndex(function (q, index) {
      return findQuestionTraversal(q, index) !== -1;
    });
  };

  return stepData.findIndex(function (step, index) {
    return findQuestionTraversal(step, index) !== -1;
  });
};

var Wizard = function Wizard() {
  var formQuestionsContext = react__WEBPACK_IMPORTED_MODULE_2___default.a.useContext(_contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_8__["FormQuestionsContext"]);

  var _React$useContext = react__WEBPACK_IMPORTED_MODULE_2___default.a.useContext(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_7__["ConfigurationContext"]),
      options = _React$useContext.options,
      mapComponent = _React$useContext.mapComponent;

  var startingStep = 0;

  if (options.startingQuestionId) {
    startingStep = findStepByQuestionId(formQuestionsContext.getFormQuestionsData(), options.startingQuestionId);

    if (startingStep === -1) {
      console.warn("Question with id ".concat(options.startingQuestionId, " not found!"));
      startingStep = 0;
    }
  } else if (options.startingStep) {
    startingStep = options.startingStep < formQuestionsContext.getFormQuestionsData().length ? options.startingStep : 0;
  }

  var _React$useState = react__WEBPACK_IMPORTED_MODULE_2___default.a.useState(startingStep),
      _React$useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1___default()(_React$useState, 2),
      currentStep = _React$useState2[0],
      setCurrentStep = _React$useState2[1];

  var _React$useState3 = react__WEBPACK_IMPORTED_MODULE_2___default.a.useState(false),
      _React$useState4 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1___default()(_React$useState3, 2),
      scrolledToStartingQuestionId = _React$useState4[0],
      setScrolledToStartingQuestionId = _React$useState4[1];

  Object(react__WEBPACK_IMPORTED_MODULE_2__["useEffect"])(function () {
    if (options.startingQuestionId && !scrolledToStartingQuestionId) {
      var element = document.getElementById(options.startingQuestionId);

      if (element) {
        element.scrollIntoView();
        element.classList.add('text-danger');
        setScrolledToStartingQuestionId(true);
      }
    }
  });

  var onNextStep = function onNextStep() {
    var stepData = formQuestionsContext.getFormQuestionsData();

    if (currentStep !== stepData.length - 1) {
      stepData[currentStep + 1].visited = true;
      setCurrentStep(function (prevCurrentStep) {
        return prevCurrentStep + 1;
      });
    }
  };

  var onPreviousStep = function onPreviousStep() {
    if (currentStep === 0) {
      return;
    }

    setCurrentStep(function (prevCurrentStep) {
      return prevCurrentStep - 1;
    });
  };

  var navigate = function navigate(stepIndex) {
    var stepData = formQuestionsContext.getFormQuestionsData();

    if (stepIndex === currentStep || stepIndex >= stepData.length) {
      return;
    } // Can we jump forward?


    if (stepIndex > currentStep && !stepData[stepIndex].visited && !options.enableForwardSkip) {
      return;
    }

    setCurrentStep(stepIndex);
  };

  var renderNav = function renderNav() {
    var formQuestionsData = formQuestionsContext.getFormQuestionsData();
    return options.horizontalWizardNav ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_HorizontalWizardNav__WEBPACK_IMPORTED_MODULE_5__["default"], {
      currentStep: currentStep,
      steps: formQuestionsData,
      onNavigate: navigate
    }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_VerticalWizardNav__WEBPACK_IMPORTED_MODULE_6__["default"], {
      currentStep: currentStep,
      steps: formQuestionsData,
      onNavigate: navigate
    });
  };

  var initComponent = function initComponent() {
    var stepData = formQuestionsContext.getFormQuestionsData();
    var step = stepData[currentStep];
    var stepComponent = mapComponent(step, _WizardStep__WEBPACK_IMPORTED_MODULE_4__["default"]);
    return react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(stepComponent, {
      options: options,
      key: 'step' + currentStep,
      step: step,
      onNextStep: onNextStep,
      onPreviousStep: onPreviousStep,
      mapComponent: mapComponent,
      stepIndex: currentStep,
      isFirstStep: currentStep === 0,
      isLastStep: currentStep === formQuestionsContext.getFormQuestionsData().length - 1
    });
  };

  var nav = null;

  if (formQuestionsContext.getFormQuestionsData().length > 1) {
    nav = renderNav();
  }

  var isHorizontal = options.horizontalWizardNav;
  var cardClassname = isHorizontal ? '' : 'flex-row p-3';
  var containerClassname = isHorizontal ? 'card-body p-3' : nav ? 'col-10 p-0 pl-3' : 'col-12 p-0';
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Card"], {
    className: cardClassname
  }, nav, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("div", {
    className: containerClassname
  }, initComponent()));
};

/* harmony default export */ __webpack_exports__["default"] = (Wizard);

/***/ }),

/***/ "./components/wizard/WizardStep.jsx":
/*!******************************************!*\
  !*** ./components/wizard/WizardStep.jsx ***!
  \******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return WizardStep; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "@babel/runtime/helpers/assertThisInitialized");
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../contexts/FormQuestionsContext */ "./contexts/FormQuestionsContext.js");
/* harmony import */ var _Question__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../Question */ "./components/Question.jsx");
/* harmony import */ var _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../util/JsonLdObjectMap */ "./util/JsonLdObjectMap.js");
















function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_14___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_13___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_13___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_12___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }










var WizardStep = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_11___default()(WizardStep, _React$Component);

  var _super = _createSuper(WizardStep);

  function WizardStep(props) {
    var _this;

    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8___default()(this, WizardStep);

    _this = _super.call(this, props);

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_14___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_10___default()(_this), "onNextStep", function () {
      _this.context.updateFormQuestionsData(_this.props.stepIndex, _this.context.getFormQuestionsData());

      _this.props.onNextStep();
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_14___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_10___default()(_this), "onPreviousStep", function () {
      _this.props.onPreviousStep();
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_14___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_10___default()(_this), "onCommentChange", function (commentIndex, change) {
      _this._onChange(_constants_Constants__WEBPACK_IMPORTED_MODULE_19__["default"].HAS_COMMENT, commentIndex, change);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_14___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_10___default()(_this), "_renderWizardStepButtons", function () {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_15___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_16__["ButtonToolbar"], {
        className: "m-3 float-right"
      }, !_this.props.isFirstStep && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_15___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_16__["Button"], {
        className: "mr-2",
        onClick: _this.onPreviousStep,
        variant: "primary",
        size: "sm"
      }, _this.props.options.i18n['wizard.previous']), !_this.props.isLastStep && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_15___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_16__["Button"], {
        onClick: _this.onNextStep,
        variant: "primary",
        size: "sm"
      }, _this.props.options.i18n['wizard.next']));
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_14___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_10___default()(_this), "onChange", function (index, change) {
      _this.context.updateFormQuestionsData(_this.props.stepIndex || index, _objectSpread(_objectSpread({}, _this.props.step), change));
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_14___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_10___default()(_this), "_onMouseEnterHandler", function () {
      _this.setState({
        showIcon: true
      });
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_14___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_10___default()(_this), "_onMouseLeaveHandler", function () {
      _this.setState({
        showIcon: false
      });
    });

    _this.state = {
      showIcon: false
    };
    return _this;
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9___default()(WizardStep, [{
    key: "_onChange",
    value: function _onChange(att, valueIndex, newValue) {
      var newState = _objectSpread({}, this.props.step);

      newState[att][valueIndex] = newValue;
      _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_22__["default"].putObject(newState['@id'], newState);
      this.onChange(this.props.index, newState);
    }
  }, {
    key: "render",
    value: function render() {
      var categoryClass = _Question__WEBPACK_IMPORTED_MODULE_21__["default"]._getQuestionCategoryClass(this.props.step);

      var question = this.context.getFormQuestionsData([this.props.stepIndex]);
      var options = this.props.options;
      var questionComponent = this.props.mapComponent(this.props.step, _Question__WEBPACK_IMPORTED_MODULE_21__["default"]);
      var questionElement = react__WEBPACK_IMPORTED_MODULE_15___default.a.createElement(questionComponent, {
        question: this.props.step,
        onChange: this.onChange,
        withoutCard: true,
        index: this.props.stepIndex
      });
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_15___default.a.createElement("div", {
        className: "wizard-step"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_15___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_16__["Card"], {
        className: "wizard-step-content"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_15___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_16__["Card"].Header, {
        className: "bg-primary text-white question-header",
        as: "h6",
        id: this.props.step['@id'],
        onMouseEnter: this._onMouseEnterHandler,
        onMouseLeave: this._onMouseLeaveHandler
      }, jsonld_utils__WEBPACK_IMPORTED_MODULE_17___default.a.getLocalized(this.props.step[jsonld_utils__WEBPACK_IMPORTED_MODULE_17___default.a.RDFS_LABEL], this.props.options.intl), _Question__WEBPACK_IMPORTED_MODULE_21__["default"].renderIcons(question, options, this.onCommentChange, this.state.showIcon)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_15___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_16__["Card"].Body, {
        className: categoryClass
      }, questionElement)), this.props.options.wizardStepButtons && this._renderWizardStepButtons());
    }
  }]);

  return WizardStep;
}(react__WEBPACK_IMPORTED_MODULE_15___default.a.Component);


WizardStep.contextType = _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_20__["FormQuestionsContext"];
WizardStep.propTypes = {
  options: prop_types__WEBPACK_IMPORTED_MODULE_18___default.a.object.isRequired,
  step: prop_types__WEBPACK_IMPORTED_MODULE_18___default.a.object.isRequired,
  onNextStep: prop_types__WEBPACK_IMPORTED_MODULE_18___default.a.func,
  onPreviousStep: prop_types__WEBPACK_IMPORTED_MODULE_18___default.a.func,
  mapComponent: prop_types__WEBPACK_IMPORTED_MODULE_18___default.a.func,
  stepIndex: prop_types__WEBPACK_IMPORTED_MODULE_18___default.a.number.isRequired,
  isFirstStep: prop_types__WEBPACK_IMPORTED_MODULE_18___default.a.bool,
  isLastStep: prop_types__WEBPACK_IMPORTED_MODULE_18___default.a.bool
};

/***/ }),

/***/ "./constants/Constants.js":
/*!********************************!*\
  !*** ./constants/Constants.js ***!
  \********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Constants; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_2__);




var Constants = function Constants() {
  _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, Constants);
};

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "COLUMN_COUNT", 12);

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "INPUT_LENGTH_THRESHOLD", 50);

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "DATETIME_NUMBER_FORMAT", 'x');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "FORM", 'http://onto.fel.cvut.cz/ontologies/documentation/form');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_SUBQUESTION", 'http://onto.fel.cvut.cz/ontologies/documentation/has_related_question');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_ANSWER", 'http://onto.fel.cvut.cz/ontologies/documentation/has_answer');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_OPTION", 'http://onto.fel.cvut.cz/ontologies/form/has-possible-value');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_OPTIONS_QUERY", 'http://onto.fel.cvut.cz/ontologies/form/has-possible-values-query');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_VALUE_TYPE", 'http://onto.fel.cvut.cz/ontologies/form/has-value-type');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "IS_DISABLED", 'http://onto.fel.cvut.cz/ontologies/aviation/form-376/is-disabled');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "INPUT_MASK", 'http://onto.fel.cvut.cz/ontologies/form/has-input-mask');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "LAYOUT_CLASS", 'http://onto.fel.cvut.cz/ontologies/form-layout/has-layout-class');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "LAYOUT", {
  FORM: 'form',
  QUESTION_SECTION: 'section',
  WIZARD_STEP: 'wizard-step',
  DATE: 'date',
  TIME: 'time',
  DATETIME: 'datetime',
  TEXT: 'text',
  TEXTAREA: 'textarea',
  CHECKBOX: 'checkbox',
  QUESTION_TYPEAHEAD: 'type-ahead',
  MASKED_INPUT: 'masked-input',
  ANSWERABLE: 'answerable',
  SPARQL: 'sparql',
  TURTLE: 'ttl',
  DISABLED: 'disabled',
  HIDDEN: 'hidden',
  COLLAPSED: 'collapsed',
  EMPHASISED: 'emphasised',
  EMPHASISE_ON_RELEVANT: 'emphasise-on-relevant',
  CATEGORY: ['category-1', 'category-2', 'category-3', 'category-4', 'category-5']
});

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_INITIAL_INPUT_LENGTH", 'http://onto.fel.cvut.cz/ontologies/form-layout/has-initial-input-length');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "VALUE_TYPE_CODE", 'code');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "VALUE_TYPE_TEXT", 'text');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "GENERATED_ROW_SIZE", 1);

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_QUESTION_ORIGIN", 'http://onto.fel.cvut.cz/ontologies/form/has-question-origin');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_ANSWER_ORIGIN", 'http://onto.fel.cvut.cz/ontologies/form/has-answer-origin');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_DATA_VALUE", 'http://onto.fel.cvut.cz/ontologies/documentation/has_data_value');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_OBJECT_VALUE", 'http://onto.fel.cvut.cz/ontologies/documentation/has_object_value');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HELP_DESCRIPTION", 'http://purl.org/dc/elements/1.1/description');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "SOURCE", 'http://purl.org/dc/elements/1.1/source');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "XSD", {
  MAX_EXCLUSIVE: 'http://www.w3.org/2001/XMLSchema#maxExclusive',
  MAX_INCLUSIVE: 'http://www.w3.org/2001/XMLSchema#maxInclusive',
  MIN_EXCLUSIVE: 'http://www.w3.org/2001/XMLSchema#minExclusive',
  MIN_INCLUSIVE: 'http://www.w3.org/2001/XMLSchema#minInclusive',
  INT: 'http://www.w3.org/2001/XMLSchema#int',
  INTEGER: 'http://www.w3.org/2001/XMLSchema#integer',
  NEGATIVE_INTEGER: 'http://www.w3.org/2001/XMLSchema#negativeInteger',
  NON_NEGATIVE_INTEGER: 'http://www.w3.org/2001/XMLSchema#nonNegativeInteger',
  NON_POSITIVE_INTEGER: 'http://www.w3.org/2001/XMLSchema#nonPositiveInteger',
  POSITIVE_INTEGER: 'http://www.w3.org/2001/XMLSchema#positiveInteger',
  BOOLEAN: 'http://www.w3.org/2001/XMLSchema#boolean'
});

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "STEP", 'http://onto.fel.cvut.cz/ontologies/form/step');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "ACCEPTS_ANSWER_VALUE", 'http://onto.fel.cvut.cz/ontologies/form/accepts-answer-value');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "ACCEPTS", 'http://onto.fel.cvut.cz/ontologies/form/accepts');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_DATATYPE", 'http://onto.fel.cvut.cz/ontologies/form/has-datatype');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_LAYOUT_CLASS", 'http://onto.fel.cvut.cz/ontologies/form/has-layout-class');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_POSSIBLE_VALUES_QUERY", 'http://onto.fel.cvut.cz/ontologies/form/has-possible-values-query');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_REQUIRED_VALUE", 'http://onto.fel.cvut.cz/ontologies/form/has-required-value');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_TESTED_QUESTION", 'http://onto.fel.cvut.cz/ontologies/form/has-tested-question');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_TESTED_FORM", 'http://onto.fel.cvut.cz/ontologies/form/has-tested-form');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_UNIT", 'http://onto.fel.cvut.cz/ontologies/form/has-unit');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_VALID_ANSWER", 'http://onto.fel.cvut.cz/ontologies/form/has-valid-answer');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "IS_RELEVANT_IF", 'http://onto.fel.cvut.cz/ontologies/form/is-relevant-if');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "ACCEPTS_VALIDATION_VALUE", 'http://onto.fel.cvut.cz/ontologies/form/accepts-validation-value');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_VALIDATION_MESSAGE", 'http://onto.fel.cvut.cz/ontologies/form/has-validation-message');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "NEGATIVE_CONDITION", 'http://onto.fel.cvut.cz/ontologies/form/negative-condition');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "REQUIRES_ANSWER", 'http://onto.fel.cvut.cz/ontologies/form/requires-answer');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "REQUIRES_ANSWER_DESCRIPTION_IF", 'http://onto.fel.cvut.cz/ontologies/form/requires-answer-description-if');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "REQUIRES_ANSWER_IF", 'http://onto.fel.cvut.cz/ontologies/form/requires-answer-if');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "REQUIRES_ANSWER_VALUE", 'http://onto.fel.cvut.cz/ontologies/form/requires-answer-value');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "REQUIRES_DESCRIPTION", 'http://onto.fel.cvut.cz/ontologies/form/requires-description');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_PRECEDING_QUESTION", 'http://onto.fel.cvut.cz/ontologies/form/has-preceding-question');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_PRECEDING_VALUE", 'http://onto.fel.cvut.cz/ontologies/form/has-preceding-value');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_MEDIA_CONTENT", 'http://onto.fel.cvut.cz/ontologies/form/has-media-content');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "CONDITION", 'http://onto.fel.cvut.cz/ontologies/form/condition');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "OR_CONDITION", 'http://onto.fel.cvut.cz/ontologies/form/or-condition');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_SUB_CONDITION", 'http://onto.fel.cvut.cz/ontologies/form/has-sub-condition');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_PATTERN", 'http://onto.fel.cvut.cz/ontologies/form-lt/has-pattern');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_DECLARED_PREFIX", 'http://onto.fel.cvut.cz/ontologies/form-spin/has-declared-prefix');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "PREFIX", 'http://www.w3.org/ns/shacl#prefix');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "NAMESPACE", 'http://www.w3.org/ns/shacl#namespace');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_COMMENT", 'http://onto.fel.cvut.cz/ontologies/form/has-comment');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_COMMENT_VALUE", 'http://onto.fel.cvut.cz/ontologies/form/has-comment-value');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_AUTHOR", 'http://onto.fel.cvut.cz/ontologies/form/has-author');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "HAS_TIMESTAMP", 'http://onto.fel.cvut.cz/ontologies/form/has-timestamp');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "NOT_ANSWERED_QUESTION", 'http://onto.fel.cvut.cz/ontologies/form/not-answered-question');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "ANSWERED_QUESTION", 'http://onto.fel.cvut.cz/ontologies/form/answered-question');

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "RDFS_LABEL", jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.RDFS_LABEL);

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "RDFS_COMMENT", jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.RDFS_COMMENT);

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "DEFAULT_HAS_CHILD", jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.DEFAULT_HAS_CHILD);

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "ICONS", {
  QUESTION_COMMENTS: "questionComments",
  QUESTION_HELP: "questionHelp",
  QUESTION_LINK: "questionLink"
});

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "ICON_BEHAVIOR", {
  ENABLE: "enable",
  DISABLE: "disable",
  ON_HOVER: "onHover"
});

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(Constants, "DEFAULT_OPTIONS", {
  icons: [{
    id: Constants.ICONS.QUESTION_HELP,
    behavior: Constants.ICON_BEHAVIOR.ENABLE
  }, {
    id: Constants.ICONS.QUESTION_COMMENTS,
    behavior: Constants.ICON_BEHAVIOR.ON_HOVER
  }, {
    id: Constants.ICONS.QUESTION_LINK,
    behavior: Constants.ICON_BEHAVIOR.ON_HOVER
  }]
});



/***/ }),

/***/ "./contexts/ConfigurationContext.js":
/*!******************************************!*\
  !*** ./contexts/ConfigurationContext.js ***!
  \******************************************/
/*! exports provided: ConfigurationContext, ConfigurationContextProvider */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConfigurationContext", function() { return ConfigurationContext; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConfigurationContextProvider", function() { return ConfigurationContextProvider; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "@babel/runtime/helpers/objectWithoutProperties");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);








function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_5___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var ConfigurationContext = react__WEBPACK_IMPORTED_MODULE_7___default.a.createContext({});
var defaultProps = {
  components: {
    inputComponent: __webpack_require__(/*! ../components/DefaultInput */ "./components/DefaultInput.jsx").default
  },
  componentsOptions: {
    dateTimeAnswer: {
      dateFormat: 'yyyy-MM-dd',
      timeFormat: 'HH:mm:ss',
      dateTimeFormat: 'yyyy-MM-dd HH:mm:ss'
    },
    readOnly: false
  },
  options: {
    intl: {
      locale: 'en'
    },
    i18n: {
      'wizard.next': 'Next',
      'wizard.previous': 'Previous',
      'section.collapse': 'Collapse',
      'section.expand': 'Expand'
    },
    modalView: false,
    modalProps: {},
    horizontalWizardNav: true,
    wizardStepButtons: true,
    enableForwardSkip: false,
    startingStep: 0
  }
};

var ConfigurationContextProvider = function ConfigurationContextProvider(_ref) {
  var children = _ref.children,
      props = _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_6___default()(_ref, ["children"]);

  var values = Object(react__WEBPACK_IMPORTED_MODULE_7__["useMemo"])(function () {
    return {
      inputComponent: props.components && props.components.inputComponent || defaultProps.components.inputComponent,
      componentsOptions: _objectSpread(_objectSpread({}, defaultProps.componentsOptions), props.componentsOptions),
      options: _objectSpread(_objectSpread({}, defaultProps.options), props.options),
      mapComponent: props.mapComponent
    };
  }, [props]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default.a.createElement(ConfigurationContext.Provider, {
    value: values
  }, children);
};

ConfigurationContextProvider.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_8___default.a.element.isRequired,
  components: prop_types__WEBPACK_IMPORTED_MODULE_8___default.a.object,
  mapComponent: prop_types__WEBPACK_IMPORTED_MODULE_8___default.a.func,
  options: prop_types__WEBPACK_IMPORTED_MODULE_8___default.a.object
};


/***/ }),

/***/ "./contexts/FormGenContext.js":
/*!************************************!*\
  !*** ./contexts/FormGenContext.js ***!
  \************************************/
/*! exports provided: FormGenContext, FormGenContextProvider */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FormGenContext", function() { return FormGenContext; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FormGenContextProvider", function() { return FormGenContextProvider; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.promise */ "core-js/modules/es.promise");
/* harmony import */ var core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "@babel/runtime/helpers/extends");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/regenerator */ "@babel/runtime/regenerator");
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! regenerator-runtime/runtime */ "regenerator-runtime/runtime");
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "@babel/runtime/helpers/asyncToGenerator");
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "@babel/runtime/helpers/objectWithoutProperties");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! jsonld */ "jsonld");
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(jsonld__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _util_Logger__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../util/Logger */ "./util/Logger.js");















function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_9___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var FormGenContext = react__WEBPACK_IMPORTED_MODULE_14___default.a.createContext({});

var FormGenContextProvider = function FormGenContextProvider(_ref) {
  var children = _ref.children,
      props = _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_13___default()(_ref, ["children"]);

  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_14__["useState"])({}),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_12___default()(_useState, 2),
      options = _useState2[0],
      setOptions = _useState2[1];

  var loadFormOptions = /*#__PURE__*/function () {
    var _ref2 = _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_11___default()( /*#__PURE__*/_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_8___default.a.mark(function _callee(id, query) {
      var option, data;
      return _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_8___default.a.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              option = options[id];

              if (!(option && option.length)) {
                _context.next = 3;
                break;
              }

              return _context.abrupt("return", option);

            case 3:
              _context.next = 5;
              return props.fetchTypeAheadValues(query);

            case 5:
              data = _context.sent;

              if (!data.length) {
                _context.next = 8;
                break;
              }

              return _context.abrupt("return", new Promise(function (resolve) {
                jsonld__WEBPACK_IMPORTED_MODULE_16___default.a.frame(data, {}, null, function (err, framed) {
                  var option = framed['@graph'];
                  setOptions(function (prevState) {
                    return _objectSpread(_objectSpread({}, prevState), {}, {
                      [id]: option
                    });
                  });
                  return resolve(option);
                });
              }));

            case 8:
              _util_Logger__WEBPACK_IMPORTED_MODULE_17__["default"].warn("No data received when loading options using id ".concat(id));
              return _context.abrupt("return", []);

            case 10:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function loadFormOptions(_x, _x2) {
      return _ref2.apply(this, arguments);
    };
  }();

  var getOptions = function getOptions(id) {
    return options[id] || [];
  };

  var values = Object(react__WEBPACK_IMPORTED_MODULE_14__["useMemo"])(function () {
    return {
      loadFormOptions,
      getOptions
    };
  }, [loadFormOptions, getOptions]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_14___default.a.createElement(FormGenContext.Provider, _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7___default()({
    value: values
  }, props), children);
};

FormGenContextProvider.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_15___default.a.element.isRequired,
  fetchTypeAheadValues: prop_types__WEBPACK_IMPORTED_MODULE_15___default.a.func
};


/***/ }),

/***/ "./contexts/FormQuestionsContext.js":
/*!******************************************!*\
  !*** ./contexts/FormQuestionsContext.js ***!
  \******************************************/
/*! exports provided: FormQuestionsContext, FormQuestionsProvider */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FormQuestionsContext", function() { return FormQuestionsContext; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FormQuestionsProvider", function() { return FormQuestionsProvider; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "@babel/runtime/helpers/extends");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "@babel/runtime/helpers/toConsumableArray");
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");










function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var INITIAL_DATA = {};
var INITIAL_FORM_QUESTIONS_DATA = [];
var FormQuestionsContext = react__WEBPACK_IMPORTED_MODULE_9___default.a.createContext({});

var FormQuestionsProvider = function FormQuestionsProvider(props) {
  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_9__["useState"])(props.data || INITIAL_DATA),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_8___default()(_useState, 2),
      data = _useState2[0],
      setData = _useState2[1];

  var _useState3 = Object(react__WEBPACK_IMPORTED_MODULE_9__["useState"])(props.formQuestions || INITIAL_FORM_QUESTIONS_DATA),
      _useState4 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_8___default()(_useState3, 2),
      formQuestionsData = _useState4[0],
      setFormQuestionsData = _useState4[1];

  Object(react__WEBPACK_IMPORTED_MODULE_9__["useEffect"])(function () {
    if (props.isFormValid) {
      var isValid = _util_FormUtils__WEBPACK_IMPORTED_MODULE_11__["default"].isValid(data);
      props.isFormValid(isValid);
    }
  }, []);
  Object(react__WEBPACK_IMPORTED_MODULE_9__["useEffect"])(function () {
    setData(props.data || INITIAL_DATA);
    setFormQuestionsData(props.formQuestions || INITIAL_FORM_QUESTIONS_DATA);
  }, [props.data, props.formQuestions]);

  var updateData = function updateData(update) {
    if (!update) return;
    setData(_objectSpread(_objectSpread({}, data), update));
  };

  var updateFormQuestionsData = function updateFormQuestionsData(index, update) {
    if (!update || index < 0 || index >= formQuestionsData.length) return;

    var newFormQuestionsData = _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_6___default()(formQuestionsData);

    newFormQuestionsData[index] = _objectSpread(_objectSpread({}, newFormQuestionsData[index]), update);
    setFormQuestionsData(newFormQuestionsData);

    if (props.isFormValid) {
      var isValid = _util_FormUtils__WEBPACK_IMPORTED_MODULE_11__["default"].isValid(data);
      props.isFormValid(isValid);
    }
  };

  var getData = function getData() {
    return data;
  };

  var getFormQuestionsData = function getFormQuestionsData(index) {
    return index === null || index === undefined ? formQuestionsData : formQuestionsData[index];
  };

  var values = Object(react__WEBPACK_IMPORTED_MODULE_9__["useMemo"])(function () {
    return {
      updateData,
      updateFormQuestionsData,
      getData,
      getFormQuestionsData
    };
  }, [getFormQuestionsData, getData]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement(FormQuestionsContext.Provider, _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5___default()({
    value: values
  }, props), props.children);
};

FormQuestionsProvider.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_10___default.a.element.isRequired,
  data: prop_types__WEBPACK_IMPORTED_MODULE_10___default.a.object.isRequired,
  formQuestions: prop_types__WEBPACK_IMPORTED_MODULE_10___default.a.array.isRequired,
  isFormValid: prop_types__WEBPACK_IMPORTED_MODULE_10___default.a.func
};


/***/ }),

/***/ "./model/DefaultFormGenerator.js":
/*!***************************************!*\
  !*** ./model/DefaultFormGenerator.js ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DefaultFormGenerator; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);



var DefaultFormGenerator = /*#__PURE__*/function () {
  function DefaultFormGenerator() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, DefaultFormGenerator);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(DefaultFormGenerator, null, [{
    key: "generateForm",

    /**
     * Generates default form for the wizard framework.
     *
     * The form consists of a single step, which contains one text area for the description.
     */
    value: function generateForm() {
      var formTemplate = __webpack_require__(/*! ./defaultForm */ "./model/defaultForm.js"); // Deep copy of the form template to prevent modifications


      formTemplate = JSON.parse(JSON.stringify(formTemplate));
      return formTemplate;
    }
  }]);

  return DefaultFormGenerator;
}();



/***/ }),

/***/ "./model/FormGenerator.js":
/*!********************************!*\
  !*** ./model/FormGenerator.js ***!
  \********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return FormGenerator; });
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.find */ "core-js/modules/es.array.find");
/* harmony import */ var core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.promise */ "core-js/modules/es.promise");
/* harmony import */ var core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! jsonld */ "jsonld");
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(jsonld__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _DefaultFormGenerator__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./DefaultFormGenerator */ "./model/DefaultFormGenerator.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _util_Logger__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../util/Logger */ "./util/Logger.js");
/* harmony import */ var _util_JsonLdFramingUtils__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../util/JsonLdFramingUtils */ "./util/JsonLdFramingUtils.js");
/* harmony import */ var _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../util/JsonLdObjectUtils */ "./util/JsonLdObjectUtils.js");
/* harmony import */ var _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../util/JsonLdObjectMap */ "./util/JsonLdObjectMap.js");




















var FormGenerator = /*#__PURE__*/function () {
  function FormGenerator() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_9___default()(this, FormGenerator);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_10___default()(FormGenerator, null, [{
    key: "constructDefaultForm",

    /**
     * Generates a default form with one-step wizard.
     *
     * @param intl Preferred language of questions
     *
     * @return Form definition (a one-step wizard with one question) and form data
     */
    value: function constructDefaultForm(intl) {
      var defaultFormData = _DefaultFormGenerator__WEBPACK_IMPORTED_MODULE_13__["default"].generateForm();

      var _FormGenerator$_const = FormGenerator._constructFormQuestions(defaultFormData, intl),
          _FormGenerator$_const2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_8___default()(_FormGenerator$_const, 2),
          formQuestions = _FormGenerator$_const2[0],
          form = _FormGenerator$_const2[1];

      return [formQuestions, {
        root: form
      }];
    }
    /**
     * Generates form definition from the specified data-enriched template.
     *
     * @param structure The form structure in JSON-LD
     * @param intl Preferred language of questions
     *
     * @return Promise with generated form definition and form data
     */

  }, {
    key: "constructForm",
    value: function constructForm(structure, intl) {
      return new Promise(function (resolve) {
        return jsonld__WEBPACK_IMPORTED_MODULE_11___default.a.flatten(structure, {}, null, function (err, structure) {
          var formProperties;
          var form;

          if (err) {
            _util_Logger__WEBPACK_IMPORTED_MODULE_15__["default"].error(err);
          }

          try {
            var _FormGenerator$_const3 = FormGenerator._constructFormQuestions(structure, intl),
                _FormGenerator$_const4 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_8___default()(_FormGenerator$_const3, 2),
                formQuestions = _FormGenerator$_const4[0],
                rootForm = _FormGenerator$_const4[1];

            form = rootForm;
            formProperties = {
              formQuestions
            };
          } catch (e) {
            var _FormGenerator$constr = FormGenerator.constructDefaultForm(intl),
                _FormGenerator$constr2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_8___default()(_FormGenerator$constr, 2),
                _formQuestions = _FormGenerator$constr2[0],
                _rootForm = _FormGenerator$constr2[1];

            form = _rootForm;
            formProperties = {
              formQuestions: _formQuestions
            };
          }

          return resolve([formProperties, form]);
        });
      });
    }
  }, {
    key: "_constructFormQuestions",
    value: function _constructFormQuestions(structure, intl) {
      var form;
      var formElements;
      var id2ObjectMap;
      var formQuestions = [];

      if (structure['@graph'][0]['@id'] !== undefined) {
        id2ObjectMap = _util_JsonLdFramingUtils__WEBPACK_IMPORTED_MODULE_16__["default"].expandStructure(structure); //TODO make as callback

        Object.keys(id2ObjectMap).map(function (key) {
          _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_18__["default"].putObject(key, id2ObjectMap[key]);
        });
      } else {
        console.warn('default form is constructed.');
      }

      form = structure['@graph'].find(function (item) {
        return _util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isForm(item);
      });
      formElements = form[_constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].HAS_SUBQUESTION];

      if (!formElements) {
        _util_Logger__WEBPACK_IMPORTED_MODULE_15__["default"].error('Could not find any questions in the received data.');
        throw 'No questions in the form';
      }

      formQuestions = formElements.filter(function (item) {
        if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isWizardStep(item) && !_util_FormUtils__WEBPACK_IMPORTED_MODULE_14__["default"].isHidden(item)) {
          return true;
        }

        _util_Logger__WEBPACK_IMPORTED_MODULE_15__["default"].warn('Item is not a wizard step: ' + item);
        return false;
      });

      if (!formQuestions.length) {
        _util_Logger__WEBPACK_IMPORTED_MODULE_15__["default"].log('Could not find any wizard steps in the received data. Building form without steps');
        form[_constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].HAS_SUBQUESTION].forEach(function (question) {
          return formQuestions.push(question);
        });
      } // sort by label


      formQuestions.sort(_util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_17__["default"].getCompareLocalizedLabelFunction(intl)); // sort by property

      _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_17__["default"].orderPreservingToplogicalSort(formQuestions, _constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].HAS_PRECEDING_QUESTION);
      return [formQuestions, {
        root: form
      }];
    }
  }]);

  return FormGenerator;
}();



/***/ }),

/***/ "./model/QuestionAnswerProcessor.js":
/*!******************************************!*\
  !*** ./model/QuestionAnswerProcessor.js ***!
  \******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return QuestionAnswerProcessor; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");





var QuestionAnswerProcessor = /*#__PURE__*/function () {
  function QuestionAnswerProcessor() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, QuestionAnswerProcessor);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(QuestionAnswerProcessor, null, [{
    key: "buildQuestionAnswerModel",

    /**
     * Builds question answer model from the specified wizard data.
     * @param wizardData Global wizard data
     * @param stepData Data from individual wizard steps
     */
    value: function buildQuestionAnswerModel(wizardData, stepData) {
      var question = {
        subQuestions: []
      };
      var processedQuestion;

      if (wizardData) {
        question.uri = wizardData.root['@id'];
        question.origin = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(wizardData.root, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_QUESTION_ORIGIN, '@id');
      }

      if (stepData) {
        for (var i = 0; i < stepData.length; i++) {
          // This will skip questions corresponding to empty steps in the wizard
          processedQuestion = QuestionAnswerProcessor.processQuestionAnswerHierarchy(stepData[i]);

          if (processedQuestion) {
            question.subQuestions.push(processedQuestion);
          }
        }
      }

      return question;
    }
    /**
     * Transforms the QA hierarchy from JSON-LD-based structure to the object model-based one.
     * @param rootQuestion
     */

  }, {
    key: "processQuestionAnswerHierarchy",
    value: function processQuestionAnswerHierarchy(rootQuestion) {
      if (!rootQuestion) {
        return null;
      }

      return QuestionAnswerProcessor._processQuestion(rootQuestion);
    }
  }, {
    key: "_processQuestion",
    value: function _processQuestion(question) {
      var result = {};
      result.uri = question['@id'];
      result.origin = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_QUESTION_ORIGIN, '@id');

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_SUBQUESTION]) {
        result.subQuestions = [];

        for (var i = 0; i < question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_SUBQUESTION].length; i++) {
          result.subQuestions.push(QuestionAnswerProcessor._processQuestion(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_SUBQUESTION][i]));
        }
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_ANSWER]) {
        result.answers = [];

        if (!Array.isArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_ANSWER])) {
          question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_ANSWER] = [question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_ANSWER]];
        }

        for (var _i = 0; _i < question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_ANSWER].length; _i++) {
          result.answers.push(QuestionAnswerProcessor.processAnswer(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_ANSWER][_i]));
        }
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_COMMENT]) {
        result.comments = [];

        if (!Array.isArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_COMMENT])) {
          question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_COMMENT] = [question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_COMMENT]];
        }

        for (var _i2 = 0; _i2 < question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_COMMENT].length; _i2++) {
          result.comments.push(QuestionAnswerProcessor.processComment(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_COMMENT][_i2]));
        }
      }

      return result;
    }
  }, {
    key: "processComment",
    value: function processComment(comment) {
      var result = {};
      result.author = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(comment, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_AUTHOR, '@id');
      result.value = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(comment, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_COMMENT_VALUE);
      result.timestamp = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(comment, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_TIMESTAMP, '@id');
      return result;
    }
  }, {
    key: "processAnswer",
    value: function processAnswer(answer) {
      var result = {};
      result.uri = answer['@id'];
      result.origin = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_ANSWER_ORIGIN, '@id');

      if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_OBJECT_VALUE]) {
        result.codeValue = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_OBJECT_VALUE, '@id');
      } else {
        result.textValue = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_DATA_VALUE);
      }

      return result;
    }
    /**
     * Generates an empty answer for the specified question
     * @param question
     */

  }, {
    key: "generateAnswer",
    value: function generateAnswer(question) {
      var answer = {};
      answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_DATA_VALUE] = '';
      return answer;
    }
  }]);

  return QuestionAnswerProcessor;
}();



/***/ }),

/***/ "./model/ValidatorFactory.js":
/*!***********************************!*\
  !*** ./model/ValidatorFactory.js ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ValidatorFactory; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");



/**
 * Created by blcha on 4.11.16.
 */




var ValidatorFactory = /*#__PURE__*/function () {
  function ValidatorFactory() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, ValidatorFactory);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(ValidatorFactory, null, [{
    key: "createValidator",
    value: function createValidator(question, intl) {
      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].REQUIRES_ANSWER]) {
        if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_4__["default"].isCheckbox(question)) {
          //TODO revise
          return ValidatorFactory._generateRequiresAnswerCheckBoxValidator(question, intl);
        }

        return ValidatorFactory._generateRequiresAnswerValidator(question, intl);
      } else {
        return function () {
          var result = {};
          result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_VALID_ANSWER] = true;
          delete result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_VALIDATION_MESSAGE];
          return result;
        };
      }
    }
  }, {
    key: "_generateRequiresAnswerValidator",
    value: function _generateRequiresAnswerValidator(question, intl) {
      return function (answer) {
        var val = null;

        if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_DATA_VALUE]) {
          val = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_DATA_VALUE);
        } else if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_OBJECT_VALUE]) {
          val = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_OBJECT_VALUE, '@id');
        }

        var isValid = val !== null && val !== undefined && val !== '';
        var result = {};
        result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_VALID_ANSWER] = isValid;
        result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_VALIDATION_MESSAGE] = isValid ? null : jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getLocalized(question[jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.RDFS_LABEL], intl) + ' is missing a value.';
        return result;
      };
    }
  }, {
    key: "_generateRequiresAnswerCheckBoxValidator",
    value: function _generateRequiresAnswerCheckBoxValidator(question, intl) {
      return function (answer) {
        var val = null;

        if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_DATA_VALUE]) {
          val = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_DATA_VALUE);
        } else if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_OBJECT_VALUE]) {
          val = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_OBJECT_VALUE, '@id');
        }

        var isValid = val !== null && val !== undefined && val !== '' && val !== false;
        var result = {};
        result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_VALID_ANSWER] = isValid;
        result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].HAS_VALIDATION_MESSAGE] = isValid ? null : jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getLocalized(question[jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.RDFS_LABEL], intl) + ' must be checked.';
        return result;
      };
    }
  }]);

  return ValidatorFactory;
}();



/***/ }),

/***/ "./model/defaultForm.js":
/*!******************************!*\
  !*** ./model/defaultForm.js ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = {
  '@graph': [{
    '@type': 'http://onto.fel.cvut.cz/ontologies/documentation/question',
    'http://onto.fel.cvut.cz/ontologies/form-layout/has-layout-class': 'form',
    'http://onto.fel.cvut.cz/ontologies/documentation/has_related_question': [{
      'http://onto.fel.cvut.cz/ontologies/form-layout/has-layout-class': ['wizard-step', 'section'],
      'http://www.w3.org/2000/01/rdf-schema#label': [{
        '@language': 'en',
        '@value': 'Description'
      }, {
        '@language': 'cs',
        '@value': 'Popis'
      }],
      'http://onto.fel.cvut.cz/ontologies/documentation/has_related_question': [{
        '@type': 'http://onto.fel.cvut.cz/ontologies/documentation/question',
        'http://onto.fel.cvut.cz/ontologies/form-layout/has-layout-class': ['textarea'],
        'http://www.w3.org/2000/01/rdf-schema#label': [{
          '@language': 'en',
          '@value': 'Description'
        }, {
          '@language': 'cs',
          '@value': 'Popis'
        }],
        'http://onto.fel.cvut.cz/ontologies/documentation/has_answer': {
          '@type': 'http://onto.fel.cvut.cz/ontologies/documentation/answer',
          'http://onto.fel.cvut.cz/ontologies/documentation/has_data_value': ''
        }
      }]
    }]
  }]
};

/***/ }),

/***/ "./s-forms.js":
/*!********************!*\
  !*** ./s-forms.js ***!
  \********************/
/*! exports provided: default, Constants, JsonLdObjectUtils, JsonLdFramingUtils, JsonLdObjectMap, FormUtils, Question, Answer, HelpIcon, ConfigurationContext, FormQuestionsContext, WizardStep */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_SForms__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/SForms */ "./components/SForms.jsx");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants/Constants */ "./constants/Constants.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Constants", function() { return _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"]; });

/* harmony import */ var _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util/JsonLdObjectUtils */ "./util/JsonLdObjectUtils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonLdObjectUtils", function() { return _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_2__["default"]; });

/* harmony import */ var _util_JsonLdFramingUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./util/JsonLdFramingUtils */ "./util/JsonLdFramingUtils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonLdFramingUtils", function() { return _util_JsonLdFramingUtils__WEBPACK_IMPORTED_MODULE_3__["default"]; });

/* harmony import */ var _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./util/JsonLdObjectMap */ "./util/JsonLdObjectMap.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonLdObjectMap", function() { return _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_4__["default"]; });

/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./util/FormUtils */ "./util/FormUtils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FormUtils", function() { return _util_FormUtils__WEBPACK_IMPORTED_MODULE_5__["default"]; });

/* harmony import */ var _components_Question__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./components/Question */ "./components/Question.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Question", function() { return _components_Question__WEBPACK_IMPORTED_MODULE_6__["default"]; });

/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConfigurationContext", function() { return _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_7__["ConfigurationContext"]; });

/* harmony import */ var _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./contexts/FormQuestionsContext */ "./contexts/FormQuestionsContext.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FormQuestionsContext", function() { return _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_8__["FormQuestionsContext"]; });

/* harmony import */ var _components_Answer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/Answer */ "./components/Answer.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Answer", function() { return _components_Answer__WEBPACK_IMPORTED_MODULE_9__["default"]; });

/* harmony import */ var _components_HelpIcon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./components/HelpIcon */ "./components/HelpIcon.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "HelpIcon", function() { return _components_HelpIcon__WEBPACK_IMPORTED_MODULE_10__["default"]; });

/* harmony import */ var _components_wizard_WizardStep__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./components/wizard/WizardStep */ "./components/wizard/WizardStep.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "WizardStep", function() { return _components_wizard_WizardStep__WEBPACK_IMPORTED_MODULE_11__["default"]; });













/* harmony default export */ __webpack_exports__["default"] = (_components_SForms__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./styles/icons/ArrowRight.jsx":
/*!*************************************!*\
  !*** ./styles/icons/ArrowRight.jsx ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var ArrowRight = function ArrowRight() {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: "24",
    height: "24",
    viewBox: "0 0 24 24"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("path", {
    d: "M6.185 4.843l11.927 7.157-11.927 7.157 2.982-7.157-2.982-7.157zm-4.185-4.843l5 12-5 12 20-12-20-12z"
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (ArrowRight);

/***/ }),

/***/ "./styles/icons/CaretSquareDown.jsx":
/*!******************************************!*\
  !*** ./styles/icons/CaretSquareDown.jsx ***!
  \******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var CaretSquareDown = function CaretSquareDown(_ref) {
  var title = _ref.title;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("svg", {
    className: "caret-square-down",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg",
    width: "24",
    height: "28",
    viewBox: "0 0 24 28"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("title", null, title || ''), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("path", {
    d: "M17.891 10.547c0.172 0.328 0.141 0.734-0.078 1.031l-5 7c-0.187 0.266-0.484 0.422-0.812 0.422s-0.625-0.156-0.812-0.422l-5-7c-0.219-0.297-0.25-0.703-0.078-1.031 0.172-0.344 0.516-0.547 0.891-0.547h10c0.375 0 0.719 0.203 0.891 0.547zM20 21.5v-15c0-0.266-0.234-0.5-0.5-0.5h-15c-0.266 0-0.5 0.234-0.5 0.5v15c0 0.266 0.234 0.5 0.5 0.5h15c0.266 0 0.5-0.234 0.5-0.5zM24 6.5v15c0 2.484-2.016 4.5-4.5 4.5h-15c-2.484 0-4.5-2.016-4.5-4.5v-15c0-2.484 2.016-4.5 4.5-4.5h15c2.484 0 4.5 2.016 4.5 4.5z"
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (CaretSquareDown);

/***/ }),

/***/ "./styles/icons/CaretSquareUp.jsx":
/*!****************************************!*\
  !*** ./styles/icons/CaretSquareUp.jsx ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var CaretSquareUp = function CaretSquareUp(_ref) {
  var title = _ref.title;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("svg", {
    className: "caret-square-up",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg",
    width: "24",
    height: "28",
    viewBox: "0 0 24 28"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("title", null, title || ''), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("path", {
    d: "M17.891 17.453c-0.172 0.344-0.516 0.547-0.891 0.547h-10c-0.375 0-0.719-0.203-0.891-0.547-0.172-0.328-0.141-0.734 0.078-1.031l5-7c0.187-0.266 0.484-0.422 0.812-0.422s0.625 0.156 0.812 0.422l5 7c0.219 0.297 0.25 0.703 0.078 1.031zM20 21.5v-15c0-0.266-0.234-0.5-0.5-0.5h-15c-0.266 0-0.5 0.234-0.5 0.5v15c0 0.266 0.234 0.5 0.5 0.5h15c0.266 0 0.5-0.234 0.5-0.5zM24 6.5v15c0 2.484-2.016 4.5-4.5 4.5h-15c-2.484 0-4.5-2.016-4.5-4.5v-15c0-2.484 2.016-4.5 4.5-4.5h15c2.484 0 4.5 2.016 4.5 4.5z"
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (CaretSquareUp);

/***/ }),

/***/ "./styles/icons/CommentBubble.jsx":
/*!****************************************!*\
  !*** ./styles/icons/CommentBubble.jsx ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var CommentBubble = function CommentBubble() {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("svg", {
    className: "question-comment",
    version: "1.1",
    id: "Capa_1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 60 60",
    width: "24",
    height: "28"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("path", {
    d: "M30,1.5c-16.542,0-30,12.112-30,27c0,5.204,1.646,10.245,4.768,14.604c-0.591,6.537-2.175,11.39-4.475,13.689 c-0.304,0.304-0.38,0.769-0.188,1.153C0.275,58.289,0.625,58.5,1,58.5c0.046,0,0.092-0.003,0.139-0.01 c0.405-0.057,9.813-1.411,16.618-5.339C21.621,54.71,25.737,55.5,30,55.5c16.542,0,30-12.112,30-27S46.542,1.5,30,1.5z M16,32.5 c-2.206,0-4-1.794-4-4s1.794-4,4-4s4,1.794,4,4S18.206,32.5,16,32.5z M30,32.5c-2.206,0-4-1.794-4-4s1.794-4,4-4s4,1.794,4,4 S32.206,32.5,30,32.5z M44,32.5c-2.206,0-4-1.794-4-4s1.794-4,4-4s4,1.794,4,4S46.206,32.5,44,32.5z"
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (CommentBubble);

/***/ }),

/***/ "./styles/icons/ExternalLink.jsx":
/*!***************************************!*\
  !*** ./styles/icons/ExternalLink.jsx ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var ExternalLink = function ExternalLink() {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("svg", {
    className: "external-link-icon",
    width: "24",
    height: "16",
    viewBox: "0 0 16 16",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("path", {
    d: "M5,2 C5.55228,2 6,2.44772 6,3 C6,3.55228 5.55228,4 5,4 L4,4 L4,12 L12,12 L12,11 C12,10.4477 12.4477,10 13,10 C13.5523,10 14,10.4477 14,11 L14,12 C14,13.1046 13.1046,14 12,14 L4,14 C2.89543,14 2,13.1046 2,12 L2,4 C2,2.89543 2.89543,2 4,2 L5,2 Z M15,1 L15,5.99814453 C15,6.55043453 14.5523,6.99814453 14,6.99814453 C13.4477,6.99814453 13,6.55043453 13,5.99814453 L13,4.41419 L8.71571,8.69846 C8.32519,9.08899 7.69202,9.08899 7.3015,8.69846 C6.91097,8.30794 6.91097,7.67477 7.3015,7.28425 L11.5858,3 L9.99619141,3 C9.44391141,3 8.99619141,2.55228 8.99619141,2 C8.99619141,1.44772 9.44391141,1 9.99619141,1 L15,1 Z"
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (ExternalLink);

/***/ }),

/***/ "./styles/icons/InfoCircle.jsx":
/*!*************************************!*\
  !*** ./styles/icons/InfoCircle.jsx ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var InfoCircle = function InfoCircle() {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("svg", {
    className: "info-circle",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg",
    width: "24",
    height: "28",
    viewBox: "0 0 24 28"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("title", null, "info-circle"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("path", {
    d: "M16 21.5v-2.5c0-0.281-0.219-0.5-0.5-0.5h-1.5v-8c0-0.281-0.219-0.5-0.5-0.5h-5c-0.281 0-0.5 0.219-0.5 0.5v2.5c0 0.281 0.219 0.5 0.5 0.5h1.5v5h-1.5c-0.281 0-0.5 0.219-0.5 0.5v2.5c0 0.281 0.219 0.5 0.5 0.5h7c0.281 0 0.5-0.219 0.5-0.5zM14 7.5v-2.5c0-0.281-0.219-0.5-0.5-0.5h-3c-0.281 0-0.5 0.219-0.5 0.5v2.5c0 0.281 0.219 0.5 0.5 0.5h3c0.281 0 0.5-0.219 0.5-0.5zM24 14c0 6.625-5.375 12-12 12s-12-5.375-12-12 5.375-12 12-12 12 5.375 12 12z"
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (InfoCircle);

/***/ }),

/***/ "./styles/icons/QuestionCircle.jsx":
/*!*****************************************!*\
  !*** ./styles/icons/QuestionCircle.jsx ***!
  \*****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var QuestionCircle = function QuestionCircle() {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("svg", {
    className: "question-circle",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg",
    width: "24",
    height: "28",
    viewBox: "0 0 24 28"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("path", {
    d: "M14 21.5v-3c0-0.281-0.219-0.5-0.5-0.5h-3c-0.281 0-0.5 0.219-0.5 0.5v3c0 0.281 0.219 0.5 0.5 0.5h3c0.281 0 0.5-0.219 0.5-0.5zM18 11c0-2.859-3-5-5.688-5-2.547 0-4.453 1.094-5.797 3.328-0.141 0.219-0.078 0.5 0.125 0.656l2.063 1.563c0.078 0.063 0.187 0.094 0.297 0.094 0.141 0 0.297-0.063 0.391-0.187 0.734-0.938 1.047-1.219 1.344-1.437 0.266-0.187 0.781-0.375 1.344-0.375 1 0 1.922 0.641 1.922 1.328 0 0.812-0.422 1.219-1.375 1.656-1.109 0.5-2.625 1.797-2.625 3.313v0.562c0 0.281 0.219 0.5 0.5 0.5h3c0.281 0 0.5-0.219 0.5-0.5v0c0-0.359 0.453-1.125 1.188-1.547 1.188-0.672 2.812-1.578 2.812-3.953zM24 14c0 6.625-5.375 12-12 12s-12-5.375-12-12 5.375-12 12-12 12 5.375 12 12z"
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (QuestionCircle);

/***/ }),

/***/ "./styles/icons/index.js":
/*!*******************************!*\
  !*** ./styles/icons/index.js ***!
  \*******************************/
/*! exports provided: CaretSquareUp, CaretSquareDown, InfoCircle, QuestionCircle */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CaretSquareUp__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CaretSquareUp */ "./styles/icons/CaretSquareUp.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CaretSquareUp", function() { return _CaretSquareUp__WEBPACK_IMPORTED_MODULE_0__["default"]; });

/* harmony import */ var _CaretSquareDown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CaretSquareDown */ "./styles/icons/CaretSquareDown.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CaretSquareDown", function() { return _CaretSquareDown__WEBPACK_IMPORTED_MODULE_1__["default"]; });

/* harmony import */ var _InfoCircle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InfoCircle */ "./styles/icons/InfoCircle.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "InfoCircle", function() { return _InfoCircle__WEBPACK_IMPORTED_MODULE_2__["default"]; });

/* harmony import */ var _QuestionCircle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./QuestionCircle */ "./styles/icons/QuestionCircle.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCircle", function() { return _QuestionCircle__WEBPACK_IMPORTED_MODULE_3__["default"]; });






/***/ }),

/***/ "./util/FormUtils.js":
/*!***************************!*\
  !*** ./util/FormUtils.js ***!
  \***************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return FormUtils; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description */ "core-js/modules/es.symbol.description");
/* harmony import */ var core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.find */ "core-js/modules/es.array.find");
/* harmony import */ var core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_from__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.from */ "core-js/modules/es.array.from");
/* harmony import */ var core_js_modules_es_array_from__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.iterator */ "core-js/modules/es.array.iterator");
/* harmony import */ var core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.slice */ "core-js/modules/es.array.slice");
/* harmony import */ var core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator */ "core-js/modules/web.dom-collections.iterator");
/* harmony import */ var core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! jsonld */ "jsonld");
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(jsonld__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Utils */ "./util/Utils.js");
/* harmony import */ var _JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./JsonLdObjectMap */ "./util/JsonLdObjectMap.js");
/* harmony import */ var _JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./JsonLdObjectUtils */ "./util/JsonLdObjectUtils.js");














function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }








var FormUtils = /*#__PURE__*/function () {
  function FormUtils() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11___default()(this, FormUtils);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12___default()(FormUtils, null, [{
    key: "isForm",
    value: function isForm(structure) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(structure, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.FORM);
    }
  }, {
    key: "isWizardStep",
    value: function isWizardStep(structure) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(structure, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.WIZARD_STEP);
    }
  }, {
    key: "isSection",
    value: function isSection(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.QUESTION_SECTION);
    }
  }, {
    key: "isAnswerable",
    value: function isAnswerable(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.ANSWERABLE);
    }
  }, {
    key: "isTypeahead",
    value: function isTypeahead(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.QUESTION_TYPEAHEAD);
    }
  }, {
    key: "getPossibleValuesQuery",
    value: function getPossibleValuesQuery(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.getJsonAttValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_OPTIONS_QUERY);
    }
  }, {
    key: "isDisabled",
    value: function isDisabled(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.DISABLED);
    }
  }, {
    key: "isHidden",
    value: function isHidden(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.HIDDEN);
    }
  }, {
    key: "isTextarea",
    value: function isTextarea(question, answerValue) {
      return answerValue && answerValue.length > _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].INPUT_LENGTH_THRESHOLD && !FormUtils.isTypeahead(question) || jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.TEXTAREA);
    }
  }, {
    key: "isText",
    value: function isText(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.TEXT);
    }
  }, {
    key: "isCalendar",
    value: function isCalendar(question) {
      return FormUtils.isDate(question) || FormUtils.isTime(question) || FormUtils.isDateTime(question);
    }
  }, {
    key: "isDate",
    value: function isDate(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.DATE);
    }
  }, {
    key: "isTime",
    value: function isTime(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.TIME);
    }
  }, {
    key: "isDateTime",
    value: function isDateTime(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.DATETIME);
    }
  }, {
    key: "isCheckbox",
    value: function isCheckbox(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.CHECKBOX);
    }
  }, {
    key: "isMaskedInput",
    value: function isMaskedInput(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.MASKED_INPUT);
    }
  }, {
    key: "isSparqlInput",
    value: function isSparqlInput(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.SPARQL);
    }
  }, {
    key: "isTurtleInput",
    value: function isTurtleInput(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.TURTLE);
    }
  }, {
    key: "isCollapsed",
    value: function isCollapsed(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.COLLAPSED);
    }
  }, {
    key: "isEmphasised",
    value: function isEmphasised(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.EMPHASISED);
    }
  }, {
    key: "getCategory",
    value: function getCategory(question) {
      return _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT.CATEGORY.find(function (c) {
        return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].LAYOUT_CLASS, c);
      });
    }
  }, {
    key: "resolveValue",
    value: function resolveValue(answer) {
      if (!answer) {
        return null;
      }

      if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_OBJECT_VALUE]) {
        return answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_OBJECT_VALUE]['@id'];
      } else {
        return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_DATA_VALUE);
      }
    }
  }, {
    key: "resolveValueObject",
    value: function resolveValueObject(answer) {
      if (!answer) {
        return null;
      }

      if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_OBJECT_VALUE]) {
        return _Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_OBJECT_VALUE])[0];
      }

      if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_DATA_VALUE]) {
        return _Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_DATA_VALUE])[0];
      }

      return null;
    }
  }, {
    key: "isRelevant",
    value: function isRelevant(question) {
      if (!question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].IS_RELEVANT_IF]) {
        return true;
      }

      var _iterator = _createForOfIteratorHelper(_Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].IS_RELEVANT_IF])),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var cond = _step.value;

          if (!FormUtils.testCondition(cond)) {
            return false;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return true;
    }
  }, {
    key: "hasValidationLogic",
    value: function hasValidationLogic(question) {
      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].REQUIRES_ANSWER_VALUE]) {
        return true;
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].REQUIRES_ANSWER]) {
        return true;
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].REQUIRES_ANSWER_IF]) {
        return true;
      }

      return false;
    }
  }, {
    key: "isValid",
    value: function isValid(question) {
      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_VALID_ANSWER] === false) {
        return false;
      }

      var _iterator2 = _createForOfIteratorHelper(_Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_SUBQUESTION])),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var subQ = _step2.value;

          if (this.isValid(subQ) === false) {
            return false;
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      return true;
    }
  }, {
    key: "testOrCondition",
    value: function testOrCondition(condition) {
      var hasSubCondition = condition[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_SUB_CONDITION];

      if (!hasSubCondition) {
        console.warn('Or condition does not have any sub-condition !');
      }

      var _iterator3 = _createForOfIteratorHelper(this._getMappedObjectsArray(hasSubCondition)),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var subC = _step3.value;

          if (this.testCondition(subC)) {
            return true;
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      return false;
    }
  }, {
    key: "testCondition",
    value: function testCondition(condition) {
      var isOrCondition = condition[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_SUB_CONDITION];
      var acceptedValidationsValues = condition[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].ACCEPTS_VALIDATION_VALUE];
      var acceptedAnswerValues = condition[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].ACCEPTS_ANSWER_VALUE];
      var accepts = condition[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].ACCEPTS];
      var testedQuestions = condition[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_TESTED_QUESTION];
      var question;

      if (isOrCondition) {
        return this.testOrCondition(condition);
      }

      if (acceptedValidationsValues && acceptedAnswerValues) {
        console.warn('Support for validation and requirement constraints at same time is not implemented !');
      } // any answer within all subquestions


      if (accepts && testedQuestions) {
        var arr = _Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(accepts);

        if (arr.length !== 1) {
          console.warn('Support for multiple accepts values is not implemented !');
        }

        if (arr[0]['@id'] === _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].ANSWERED_QUESTION) {
          if (acceptedAnswerValues || acceptedValidationsValues) {
            console.warn('Support for accepted answer/validations values is not implemented !');
          }

          var _iterator4 = _createForOfIteratorHelper(this._getMappedObjectsArray(testedQuestions)),
              _step4;

          try {
            for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
              var q = _step4.value;

              if (!this.hasAnswer(q)) {
                return false;
              }
            }
          } catch (err) {
            _iterator4.e(err);
          } finally {
            _iterator4.f();
          }

          return true;
        }

        console.warn('No support to accept question of type ' + arr[0]['@id'] + ' !');
      } // valid answers


      if (acceptedValidationsValues && testedQuestions) {
        var _arr = _Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(acceptedValidationsValues);

        if (_arr.length !== 1 || _arr[0] !== true && _arr[0] !== 'true') {
          console.warn('Validation values other than "true" are not implemented !');
        }

        var _iterator5 = _createForOfIteratorHelper(_Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(testedQuestions)),
            _step5;

        try {
          for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
            var _q = _step5.value;
            question = _JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_17__["default"].getObject(_q['@id']);

            if (question === undefined) {
              console.warn('Questions is not loaded in an object map.');
              return true;
            }

            if (this.isValid(question) === false) {
              return false;
            }
          }
        } catch (err) {
          _iterator5.e(err);
        } finally {
          _iterator5.f();
        }

        return true;
      } // concrete values


      if (acceptedAnswerValues && testedQuestions) {
        question = _JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_17__["default"].getObject(testedQuestions['@id']);

        var _iterator6 = _createForOfIteratorHelper(_Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(acceptedAnswerValues)),
            _step6;

        try {
          for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
            var expValue = _step6.value;

            if (!question) {
              console.warn('Question is not defined.');
              return true;
            }

            if (!question.hasOwnProperty(_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_ANSWER)) {
              //console.warn('Question does not have answer value defined.');
              return false;
            }

            var answers = jsonld__WEBPACK_IMPORTED_MODULE_14___default.a.getValues(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_ANSWER);

            if (answers.length === 0) {
              return false;
            }

            var qValue = FormUtils.resolveValueObject(answers[0]);

            if (qValue && expValue && qValue.hasOwnProperty('@value') && expValue.hasOwnProperty('@id') && qValue['@value'] == expValue['@id']) {
              // TODO remove !, this is temporary fix as type-ahead component returns data-value instead of
              // code-value
              return true;
            }

            if (_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_18__["default"].compareValues(qValue, expValue)) {
              return true;
            }
          }
        } catch (err) {
          _iterator6.e(err);
        } finally {
          _iterator6.f();
        }
      }

      return false;
    } //returns array of valid object while ignoring

  }, {
    key: "_getMappedObjectsArray",
    value: function _getMappedObjectsArray(jsonObjects, objectType) {
      return _Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(jsonObjects).map(function (o) {
        var obj = _JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_17__["default"].getObject(o['@id']);

        if (obj === undefined) {
          var ot = objectType ? objectType : 'Object';
          console.warn((objectType ? objectType : 'Object') + ' "' + o['@id'] + '"' + ' is not loaded in an object map.');
          return null;
        }

        return obj;
      }).filter(function (o) {
        return o !== null;
      });
    }
  }, {
    key: "hasAnswer",
    value: function hasAnswer(question) {
      if (!question) {
        return false;
      }

      if (question.hasOwnProperty(_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_ANSWER)) {
        var answers = jsonld__WEBPACK_IMPORTED_MODULE_14___default.a.getValues(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_ANSWER);

        if (answers.length) {
          var qValue = FormUtils.resolveValueObject(answers[0]);

          if (qValue) {
            if (qValue['@value'] || qValue['@id']) {
              return true;
            }
          }
        }
      }

      var _iterator7 = _createForOfIteratorHelper(_Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["default"].HAS_SUBQUESTION])),
          _step7;

      try {
        for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
          var subQ = _step7.value;

          if (FormUtils.hasAnswer(subQ)) {
            return true;
          }
        }
      } catch (err) {
        _iterator7.e(err);
      } finally {
        _iterator7.f();
      }

      return false;
    }
  }]);

  return FormUtils;
}();



/***/ }),

/***/ "./util/JsonLdFramingUtils.js":
/*!************************************!*\
  !*** ./util/JsonLdFramingUtils.js ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return JsonLdFramingUtils; });
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.iterator */ "core-js/modules/es.array.iterator");
/* harmony import */ var core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_set__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.set */ "core-js/modules/es.set");
/* harmony import */ var core_js_modules_es_set__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_set__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_esnext_set_add_all__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/esnext.set.add-all */ "core-js/modules/esnext.set.add-all");
/* harmony import */ var core_js_modules_esnext_set_add_all__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_add_all__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_esnext_set_delete_all__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/esnext.set.delete-all */ "core-js/modules/esnext.set.delete-all");
/* harmony import */ var core_js_modules_esnext_set_delete_all__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_delete_all__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_esnext_set_difference__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/esnext.set.difference */ "core-js/modules/esnext.set.difference");
/* harmony import */ var core_js_modules_esnext_set_difference__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_difference__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_esnext_set_every__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/esnext.set.every */ "core-js/modules/esnext.set.every");
/* harmony import */ var core_js_modules_esnext_set_every__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_every__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_esnext_set_filter__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/esnext.set.filter */ "core-js/modules/esnext.set.filter");
/* harmony import */ var core_js_modules_esnext_set_filter__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_filter__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_esnext_set_find__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/esnext.set.find */ "core-js/modules/esnext.set.find");
/* harmony import */ var core_js_modules_esnext_set_find__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_find__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_esnext_set_intersection__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/esnext.set.intersection */ "core-js/modules/esnext.set.intersection");
/* harmony import */ var core_js_modules_esnext_set_intersection__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_intersection__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_esnext_set_is_disjoint_from__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/esnext.set.is-disjoint-from */ "core-js/modules/esnext.set.is-disjoint-from");
/* harmony import */ var core_js_modules_esnext_set_is_disjoint_from__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_is_disjoint_from__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_esnext_set_is_subset_of__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/esnext.set.is-subset-of */ "core-js/modules/esnext.set.is-subset-of");
/* harmony import */ var core_js_modules_esnext_set_is_subset_of__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_is_subset_of__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_esnext_set_is_superset_of__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/esnext.set.is-superset-of */ "core-js/modules/esnext.set.is-superset-of");
/* harmony import */ var core_js_modules_esnext_set_is_superset_of__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_is_superset_of__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_esnext_set_join__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/esnext.set.join */ "core-js/modules/esnext.set.join");
/* harmony import */ var core_js_modules_esnext_set_join__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_join__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_esnext_set_map__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/esnext.set.map */ "core-js/modules/esnext.set.map");
/* harmony import */ var core_js_modules_esnext_set_map__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_map__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_esnext_set_reduce__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/esnext.set.reduce */ "core-js/modules/esnext.set.reduce");
/* harmony import */ var core_js_modules_esnext_set_reduce__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_reduce__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_esnext_set_some__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/esnext.set.some */ "core-js/modules/esnext.set.some");
/* harmony import */ var core_js_modules_esnext_set_some__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_some__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_esnext_set_symmetric_difference__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/esnext.set.symmetric-difference */ "core-js/modules/esnext.set.symmetric-difference");
/* harmony import */ var core_js_modules_esnext_set_symmetric_difference__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_symmetric_difference__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_esnext_set_union__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/esnext.set.union */ "core-js/modules/esnext.set.union");
/* harmony import */ var core_js_modules_esnext_set_union__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_union__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator */ "core-js/modules/web.dom-collections.iterator");
/* harmony import */ var core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! jsonld */ "jsonld");
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(jsonld__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./Utils */ "./util/Utils.js");






























var formShape = {
  root: {
    [_constants_Constants__WEBPACK_IMPORTED_MODULE_27__["default"].HAS_LAYOUT_CLASS]: _constants_Constants__WEBPACK_IMPORTED_MODULE_27__["default"].FORM
  },
  expandProperties: [_constants_Constants__WEBPACK_IMPORTED_MODULE_27__["default"].HAS_SUBQUESTION, _constants_Constants__WEBPACK_IMPORTED_MODULE_27__["default"].IS_RELEVANT_IF, _constants_Constants__WEBPACK_IMPORTED_MODULE_27__["default"].HAS_ANSWER, _constants_Constants__WEBPACK_IMPORTED_MODULE_27__["default"].HAS_DECLARED_PREFIX, _constants_Constants__WEBPACK_IMPORTED_MODULE_27__["default"].HAS_OPTION, _constants_Constants__WEBPACK_IMPORTED_MODULE_27__["default"].HAS_COMMENT]
};

var JsonLdFramingUtils = /*#__PURE__*/function () {
  function JsonLdFramingUtils() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_23___default()(this, JsonLdFramingUtils);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_24___default()(JsonLdFramingUtils, null, [{
    key: "customFrame",
    //TODO revise

    /**
     * Performs JSON-LD custom framing using shapes. Shape is declaration of the JSON-LD framing
     * in a language that is incompatible with JSON-LD specification.
     *
     * @param input the JSON-LD input to framing by a shape.
     * @param shape the JSON-LD custom frame configuration using shapes.
     * @param callback(err, framed) called once the operation completes.
     */
    value: function customFrame(input, shape, callback) {
      if (arguments.length < 2) {
        return jsonld__WEBPACK_IMPORTED_MODULE_26___default.a.nextTick(function () {
          callback(new TypeError('Could not frame, too few arguments.'));
        });
      }

      if (shape === null) {
        //TODO remove
        shape = formShape;
      }

      var flattened = null;
      var err = null;

      var flattenedCallback = function flattenedCallback(e, f) {
        flattened = f;
        err = e;
      };

      jsonld__WEBPACK_IMPORTED_MODULE_26___default.a.flatten(input, null, null, flattenedCallback);
    }
  }, {
    key: "expandStructure",
    value: function expandStructure(structure) {
      var root;
      var id2objectMap = {}; // mapping @id -> object

      structure['@graph'].forEach(function (item) {
        id2objectMap[item['@id']] = item;

        if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_28__["default"].isForm(item)) {
          root = item;
        }
      });

      try {
        this._expandGraph(root, formShape, id2objectMap);
      } catch (e) {
        console.error("Error '" + e + "' occured, while trying to apply frame-ing with custom shape.");
      }

      return id2objectMap;
    }
  }, {
    key: "_expandGraph",
    value: function _expandGraph(parentNode, shape, id2ObjectMap) {
      var _this = this;

      var childArray;
      var child;
      var childId;
      shape.expandProperties.forEach(function (prop) {
        if (parentNode.hasOwnProperty(prop)) {
          parentNode[prop] = _Utils__WEBPACK_IMPORTED_MODULE_29__["default"].asArray(parentNode[prop]);
          childArray = parentNode[prop];

          for (var i = 0; i < childArray.length; i++) {
            childId = _this._getId(childArray[i]);
            child = id2ObjectMap[childId];

            if (child !== undefined) {
              childArray[i] = child; //console.log(childId + " expanded.");

              _this._expandGraph(child, shape, id2ObjectMap);
            } else {
              console.warn('object with @id ' + childId + ' was not defined in input data.');
            }
          }
        }
      });
    }
  }, {
    key: "_getId",
    value: function _getId(jsonObject) {
      if (typeof jsonObject === 'string') {
        return jsonObject;
      }

      return jsonObject['@id'];
    }
  }]);

  return JsonLdFramingUtils;
}();

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_25___default()(JsonLdFramingUtils, "compressStructure", function (rootNode) {
  var object2IdMap = []; // mapping object -> id

  var idIncluded = new Set();
  object2IdMap = JsonLdFramingUtils._compressGraph(rootNode, object2IdMap, idIncluded);
  object2IdMap = object2IdMap.sort(function (a, b) {
    if (a['@id'] && b['@id']) {
      return a['@id'].localeCompare(b['@id']);
    }

    return 0;
  });
  return object2IdMap;
});

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_25___default()(JsonLdFramingUtils, "_compressGraph", function (parentNode, object2IdMap, idIncluded) {
  if (!idIncluded.has(parentNode['@id'])) {
    object2IdMap.push(parentNode);
    idIncluded.add(parentNode['@id']);
  }

  formShape.expandProperties.forEach(function (prop) {
    if (parentNode.hasOwnProperty(prop)) {
      var childArray = parentNode[prop];

      for (var i = 0; i < childArray.length; i++) {
        var child = childArray[i];

        if (child !== undefined) {
          childArray[i] = child;
          object2IdMap = JsonLdFramingUtils._compressGraph(child, object2IdMap, idIncluded);
          parentNode[prop][i] = {
            '@id': child['@id']
          };
        }
      }
    }
  });
  return object2IdMap;
});



/***/ }),

/***/ "./util/JsonLdObjectMap.js":
/*!*********************************!*\
  !*** ./util/JsonLdObjectMap.js ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return JsonLdObjectMap; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__);




var JsonLdObjectMap = /*#__PURE__*/function () {
  function JsonLdObjectMap() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, JsonLdObjectMap);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(JsonLdObjectMap, null, [{
    key: "putObject",
    value: function putObject(id, question) {
      JsonLdObjectMap.objectMap[id] = question;
    }
  }, {
    key: "getObject",
    value: function getObject(id) {
      return JsonLdObjectMap.objectMap[id];
    }
  }]);

  return JsonLdObjectMap;
}();

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(JsonLdObjectMap, "objectMap", {});



/***/ }),

/***/ "./util/JsonLdObjectUtils.js":
/*!***********************************!*\
  !*** ./util/JsonLdObjectUtils.js ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return JsonLdObjectUtils; });
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! jsonld */ "jsonld");
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(jsonld__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Utils */ "./util/Utils.js");
/* harmony import */ var tsort__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! tsort */ "tsort");
/* harmony import */ var tsort__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(tsort__WEBPACK_IMPORTED_MODULE_9__);











var JsonLdObjectUtils = /*#__PURE__*/function () {
  function JsonLdObjectUtils() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4___default()(this, JsonLdObjectUtils);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5___default()(JsonLdObjectUtils, null, [{
    key: "getFirstObject",
    value: function getFirstObject(subject, predicate) {
      var values = jsonld__WEBPACK_IMPORTED_MODULE_6___default.a.getValues(subject, predicate);

      if (values.length === 0) {
        //throw "Subject "  + subject[@id] + " does not have any value of property " + predicate;
        return null;
      }

      return values[0];
    }
  }, {
    key: "compareValues",
    value: function compareValues(jsonLdValue1, jsonLdValue2) {
      jsonLdValue1 = typeof jsonLdValue1 === 'object' ? jsonLdValue1 : {
        '@value': jsonLdValue1
      };
      jsonLdValue2 = typeof jsonLdValue2 === 'object' ? jsonLdValue2 : {
        '@value': jsonLdValue2
      }; // TODO remove: workaround for bad persistance of boolean values -- { @value: "true" } instead of { @value: true }

      if (jsonLdValue1 && jsonLdValue1['@value'] && jsonLdValue2 && jsonLdValue2['@value']) {
        var strValue1 = typeof jsonLdValue1['@value'] === 'string' ? jsonLdValue1['@value'] : JSON.stringify(jsonLdValue1['@value']);
        var strValue2 = typeof jsonLdValue2['@value'] === 'string' ? jsonLdValue2['@value'] : JSON.stringify(jsonLdValue2['@value']);

        if (strValue1 === strValue2) {
          return true;
        }
      }

      return jsonld__WEBPACK_IMPORTED_MODULE_6___default.a.compareValues(jsonLdValue1, jsonLdValue2);
    }
    /**
     * Sorts the specified JSON-LD data using a topological sort over partially ordered set defined by gtProperty.
     *
     * This is useful for situations where each item only knows its immediate neighbour in the list.
     * @param data The data to sort, should be an array
     * @param gtProperty Property specifying that an item is greater than another item. It is used for comparison.
     *
     */

  }, {
    key: "toplogicalSort",
    value: function toplogicalSort(data, gtProperty) {
      var swapped;

      do {
        swapped = false;

        for (var i = 0; i < data.length; i++) {
          for (var j = i; j < data.length; j++) {
            if (data[i][gtProperty]) {
              var gtId = typeof data[i][gtProperty] === 'object' ? data[i][gtProperty]['@id'] : data[i][gtProperty];

              if (gtId === data[j]['@id']) {
                var tmp = data[i];
                data[i] = data[j];
                data[j] = tmp;
                swapped = true;
                break;
              }
            }
          }
        }
      } while (swapped);

      return data;
    }
    /**
     * Sorts the specified JSON-LD data using a topological sort over partially ordered set defined by gtProperty,
     * while preserving original order.
     *
     * This is useful for situations where each item only knows its immediate neighbour in the list.
     * @param data The data to sort, should be an array
     * @param gtProperty Property specifying that an item is greater than another item. It is used for comparison.
     *
     */

  }, {
    key: "orderPreservingToplogicalSort",
    value: function orderPreservingToplogicalSort(data, gtProperty) {
      var graph = tsort__WEBPACK_IMPORTED_MODULE_9___default()();
      var id2ObjectMap = {};

      var _loop = function _loop(i) {
        var currentId = data[i]['@id'];
        graph.add(currentId);
        id2ObjectMap[currentId] = data[i];
        _Utils__WEBPACK_IMPORTED_MODULE_8__["default"].asArray(data[i][gtProperty]).map(function (val) {
          return typeof val === 'object' ? val['@id'] : val;
        }).map(function (val) {
          return [val, currentId];
        }).forEach(function (edge) {
          return graph.add(edge);
        });
      };

      for (var i = 0; i < data.length; i++) {
        _loop(i);
      }

      var sortedIds = graph.sort();

      for (var _i = 0; _i < sortedIds.length; _i++) {
        data[_i] = id2ObjectMap[sortedIds[_i]];
      }

      return data;
    }
  }, {
    key: "getCompareLocalizedLabelFunction",
    value: function getCompareLocalizedLabelFunction(intl) {
      return function (a, b) {
        var aLabel = jsonld_utils__WEBPACK_IMPORTED_MODULE_7___default.a.getLocalized(a[jsonld_utils__WEBPACK_IMPORTED_MODULE_7___default.a.RDFS_LABEL], intl);
        var bLabel = jsonld_utils__WEBPACK_IMPORTED_MODULE_7___default.a.getLocalized(b[jsonld_utils__WEBPACK_IMPORTED_MODULE_7___default.a.RDFS_LABEL], intl);

        if (aLabel < bLabel) {
          return -1;
        } else if (aLabel > bLabel) {
          return 1;
        }

        return 0;
      };
    }
  }, {
    key: "orderByLocalizedLabels",
    value: function orderByLocalizedLabels(data, intl) {
      return data.sort(JsonLdObjectUtils.getCompareLocalizedLabelFunction(intl));
    }
  }]);

  return JsonLdObjectUtils;
}();



/***/ }),

/***/ "./util/Logger.js":
/*!************************!*\
  !*** ./util/Logger.js ***!
  \************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Logger; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);



var Logger = /*#__PURE__*/function () {
  function Logger() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, Logger);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(Logger, null, [{
    key: "log",
    value: function log(msg) {
      console.log(msg);
    }
  }, {
    key: "warn",
    value: function warn(msg) {
      if (console.warn) {
        console.warn(msg);
      } else {
        console.log('WARNING: ' + msg);
      }
    }
  }, {
    key: "error",
    value: function error(msg) {
      if (console.error) {
        console.error(msg);
      } else {
        console.log('ERROR: ' + msg);
      }
    }
  }]);

  return Logger;
}();



/***/ }),

/***/ "./util/MaskMapper.js":
/*!****************************!*\
  !*** ./util/MaskMapper.js ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports) {

var REPLACEMENTS = {
  D: '1',
  M: '1',
  Y: '1',
  h: '1',
  m: '1',
  s: '1'
};
module.exports = {
  /**
   * Attempts to map regular mask (e.g. date) to the format supported by inputmask-core.
   *
   * E.g. it maps (DD-MM-YYYY) to 11-11-1111.
   *
   * If an unsupported mask character is encountered, it is simply skipped. Datetime masks are processed according to
   * ISO 8601 acronyms (e.g. M for month and m for minute).
   * @param mask The mask to map
   */
  mapMask(mask) {
    if (!mask) {
      return mask;
    }

    var result = '',
        character;

    for (var i = 0, len = mask.length; i < len; i++) {
      character = mask.charAt(i);
      result += REPLACEMENTS[character] ? REPLACEMENTS[character] : character;
    }

    return result;
  }

};

/***/ }),

/***/ "./util/Utils.js":
/*!***********************!*\
  !*** ./util/Utils.js ***!
  \***********************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Utils; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _FormUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./FormUtils */ "./util/FormUtils.js");





var Utils = /*#__PURE__*/function () {
  function Utils() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, Utils);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(Utils, null, [{
    key: "getStringHash",

    /**
     * Calculates a simple hash of the specified string, much like usual Java implementations.
     * @param str The string to compute has for
     * @return {number}
     */
    value: function getStringHash(str) {
      var hash = 0;
      var strlen = str ? str.length : 0;

      if (strlen === 0) {
        return hash;
      }

      for (var i = 0; i < strlen; i++) {
        hash = (hash << 5) - hash + str.charCodeAt(i);
        hash = hash & hash; // Convert to 32bit integer
      }

      return hash;
    }
    /**
     * Resolves which format of date/time/datetime value should be used in the datetime picker.
     * @param question Question with format info
     * @param originalValue Value read from answer, not processed by the rendered component
     * @param options Object with datetime formats
     * @return {*} Format from Configuration
     */

  }, {
    key: "resolveDateTimeFormat",
    value: function resolveDateTimeFormat(question, originalValue, options) {
      if (typeof originalValue === 'number') {
        return _constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].DATETIME_NUMBER_FORMAT;
      }

      if (_FormUtils__WEBPACK_IMPORTED_MODULE_3__["default"].isDate(question)) {
        return options.dateFormat;
      } else if (_FormUtils__WEBPACK_IMPORTED_MODULE_3__["default"].isTime(question)) {
        return options.timeFormat;
      }

      return options.dateTimeFormat;
    }
    /**
     * Wraps passed object into new array if it is not array already.
     * @param object_or_array An object or array.
     * @returns {*} New array containing passed object or passed array.
     */

  }, {
    key: "asArray",
    value: function asArray(object_or_array) {
      if (!object_or_array) {
        return [];
      }

      if (object_or_array.constructor === Array) {
        return object_or_array;
      }

      return [object_or_array];
    }
  }]);

  return Utils;
}();



/***/ }),

/***/ "@babel/runtime/helpers/assertThisInitialized":
/*!***************************************************************!*\
  !*** external "@babel/runtime/helpers/assertThisInitialized" ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/assertThisInitialized");

/***/ }),

/***/ "@babel/runtime/helpers/asyncToGenerator":
/*!**********************************************************!*\
  !*** external "@babel/runtime/helpers/asyncToGenerator" ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/asyncToGenerator");

/***/ }),

/***/ "@babel/runtime/helpers/classCallCheck":
/*!********************************************************!*\
  !*** external "@babel/runtime/helpers/classCallCheck" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/classCallCheck");

/***/ }),

/***/ "@babel/runtime/helpers/createClass":
/*!*****************************************************!*\
  !*** external "@babel/runtime/helpers/createClass" ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/createClass");

/***/ }),

/***/ "@babel/runtime/helpers/defineProperty":
/*!********************************************************!*\
  !*** external "@babel/runtime/helpers/defineProperty" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/defineProperty");

/***/ }),

/***/ "@babel/runtime/helpers/extends":
/*!*************************************************!*\
  !*** external "@babel/runtime/helpers/extends" ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/extends");

/***/ }),

/***/ "@babel/runtime/helpers/getPrototypeOf":
/*!********************************************************!*\
  !*** external "@babel/runtime/helpers/getPrototypeOf" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/getPrototypeOf");

/***/ }),

/***/ "@babel/runtime/helpers/inherits":
/*!**************************************************!*\
  !*** external "@babel/runtime/helpers/inherits" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/inherits");

/***/ }),

/***/ "@babel/runtime/helpers/objectWithoutProperties":
/*!*****************************************************************!*\
  !*** external "@babel/runtime/helpers/objectWithoutProperties" ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/objectWithoutProperties");

/***/ }),

/***/ "@babel/runtime/helpers/possibleConstructorReturn":
/*!*******************************************************************!*\
  !*** external "@babel/runtime/helpers/possibleConstructorReturn" ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/possibleConstructorReturn");

/***/ }),

/***/ "@babel/runtime/helpers/slicedToArray":
/*!*******************************************************!*\
  !*** external "@babel/runtime/helpers/slicedToArray" ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/slicedToArray");

/***/ }),

/***/ "@babel/runtime/helpers/toConsumableArray":
/*!***********************************************************!*\
  !*** external "@babel/runtime/helpers/toConsumableArray" ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/toConsumableArray");

/***/ }),

/***/ "@babel/runtime/regenerator":
/*!*********************************************!*\
  !*** external "@babel/runtime/regenerator" ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/regenerator");

/***/ }),

/***/ "@triply/yasgui/build/yasgui.min.css":
/*!******************************************************!*\
  !*** external "@triply/yasgui/build/yasgui.min.css" ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@triply/yasgui/build/yasgui.min.css");

/***/ }),

/***/ "classnames":
/*!*****************************!*\
  !*** external "classnames" ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("classnames");

/***/ }),

/***/ "core-js/modules/es.array.concat":
/*!**************************************************!*\
  !*** external "core-js/modules/es.array.concat" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.concat");

/***/ }),

/***/ "core-js/modules/es.array.every":
/*!*************************************************!*\
  !*** external "core-js/modules/es.array.every" ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.every");

/***/ }),

/***/ "core-js/modules/es.array.filter":
/*!**************************************************!*\
  !*** external "core-js/modules/es.array.filter" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.filter");

/***/ }),

/***/ "core-js/modules/es.array.find":
/*!************************************************!*\
  !*** external "core-js/modules/es.array.find" ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.find");

/***/ }),

/***/ "core-js/modules/es.array.find-index":
/*!******************************************************!*\
  !*** external "core-js/modules/es.array.find-index" ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.find-index");

/***/ }),

/***/ "core-js/modules/es.array.for-each":
/*!****************************************************!*\
  !*** external "core-js/modules/es.array.for-each" ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.for-each");

/***/ }),

/***/ "core-js/modules/es.array.from":
/*!************************************************!*\
  !*** external "core-js/modules/es.array.from" ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.from");

/***/ }),

/***/ "core-js/modules/es.array.index-of":
/*!****************************************************!*\
  !*** external "core-js/modules/es.array.index-of" ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.index-of");

/***/ }),

/***/ "core-js/modules/es.array.iterator":
/*!****************************************************!*\
  !*** external "core-js/modules/es.array.iterator" ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.iterator");

/***/ }),

/***/ "core-js/modules/es.array.map":
/*!***********************************************!*\
  !*** external "core-js/modules/es.array.map" ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.map");

/***/ }),

/***/ "core-js/modules/es.array.reverse":
/*!***************************************************!*\
  !*** external "core-js/modules/es.array.reverse" ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.reverse");

/***/ }),

/***/ "core-js/modules/es.array.slice":
/*!*************************************************!*\
  !*** external "core-js/modules/es.array.slice" ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.slice");

/***/ }),

/***/ "core-js/modules/es.array.some":
/*!************************************************!*\
  !*** external "core-js/modules/es.array.some" ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.some");

/***/ }),

/***/ "core-js/modules/es.array.sort":
/*!************************************************!*\
  !*** external "core-js/modules/es.array.sort" ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.sort");

/***/ }),

/***/ "core-js/modules/es.number.constructor":
/*!********************************************************!*\
  !*** external "core-js/modules/es.number.constructor" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.number.constructor");

/***/ }),

/***/ "core-js/modules/es.object.get-own-property-descriptors":
/*!*************************************************************************!*\
  !*** external "core-js/modules/es.object.get-own-property-descriptors" ***!
  \*************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.object.get-own-property-descriptors");

/***/ }),

/***/ "core-js/modules/es.object.to-string":
/*!******************************************************!*\
  !*** external "core-js/modules/es.object.to-string" ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.object.to-string");

/***/ }),

/***/ "core-js/modules/es.object.values":
/*!***************************************************!*\
  !*** external "core-js/modules/es.object.values" ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.object.values");

/***/ }),

/***/ "core-js/modules/es.promise":
/*!*********************************************!*\
  !*** external "core-js/modules/es.promise" ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.promise");

/***/ }),

/***/ "core-js/modules/es.reflect.construct":
/*!*******************************************************!*\
  !*** external "core-js/modules/es.reflect.construct" ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.reflect.construct");

/***/ }),

/***/ "core-js/modules/es.regexp.exec":
/*!*************************************************!*\
  !*** external "core-js/modules/es.regexp.exec" ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.regexp.exec");

/***/ }),

/***/ "core-js/modules/es.regexp.to-string":
/*!******************************************************!*\
  !*** external "core-js/modules/es.regexp.to-string" ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.regexp.to-string");

/***/ }),

/***/ "core-js/modules/es.set":
/*!*****************************************!*\
  !*** external "core-js/modules/es.set" ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.set");

/***/ }),

/***/ "core-js/modules/es.string.replace":
/*!****************************************************!*\
  !*** external "core-js/modules/es.string.replace" ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.string.replace");

/***/ }),

/***/ "core-js/modules/es.string.trim":
/*!*************************************************!*\
  !*** external "core-js/modules/es.string.trim" ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.string.trim");

/***/ }),

/***/ "core-js/modules/es.symbol":
/*!********************************************!*\
  !*** external "core-js/modules/es.symbol" ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.symbol");

/***/ }),

/***/ "core-js/modules/es.symbol.description":
/*!********************************************************!*\
  !*** external "core-js/modules/es.symbol.description" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.symbol.description");

/***/ }),

/***/ "core-js/modules/esnext.set.add-all":
/*!*****************************************************!*\
  !*** external "core-js/modules/esnext.set.add-all" ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.add-all");

/***/ }),

/***/ "core-js/modules/esnext.set.delete-all":
/*!********************************************************!*\
  !*** external "core-js/modules/esnext.set.delete-all" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.delete-all");

/***/ }),

/***/ "core-js/modules/esnext.set.difference":
/*!********************************************************!*\
  !*** external "core-js/modules/esnext.set.difference" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.difference");

/***/ }),

/***/ "core-js/modules/esnext.set.every":
/*!***************************************************!*\
  !*** external "core-js/modules/esnext.set.every" ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.every");

/***/ }),

/***/ "core-js/modules/esnext.set.filter":
/*!****************************************************!*\
  !*** external "core-js/modules/esnext.set.filter" ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.filter");

/***/ }),

/***/ "core-js/modules/esnext.set.find":
/*!**************************************************!*\
  !*** external "core-js/modules/esnext.set.find" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.find");

/***/ }),

/***/ "core-js/modules/esnext.set.intersection":
/*!**********************************************************!*\
  !*** external "core-js/modules/esnext.set.intersection" ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.intersection");

/***/ }),

/***/ "core-js/modules/esnext.set.is-disjoint-from":
/*!**************************************************************!*\
  !*** external "core-js/modules/esnext.set.is-disjoint-from" ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.is-disjoint-from");

/***/ }),

/***/ "core-js/modules/esnext.set.is-subset-of":
/*!**********************************************************!*\
  !*** external "core-js/modules/esnext.set.is-subset-of" ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.is-subset-of");

/***/ }),

/***/ "core-js/modules/esnext.set.is-superset-of":
/*!************************************************************!*\
  !*** external "core-js/modules/esnext.set.is-superset-of" ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.is-superset-of");

/***/ }),

/***/ "core-js/modules/esnext.set.join":
/*!**************************************************!*\
  !*** external "core-js/modules/esnext.set.join" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.join");

/***/ }),

/***/ "core-js/modules/esnext.set.map":
/*!*************************************************!*\
  !*** external "core-js/modules/esnext.set.map" ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.map");

/***/ }),

/***/ "core-js/modules/esnext.set.reduce":
/*!****************************************************!*\
  !*** external "core-js/modules/esnext.set.reduce" ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.reduce");

/***/ }),

/***/ "core-js/modules/esnext.set.some":
/*!**************************************************!*\
  !*** external "core-js/modules/esnext.set.some" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.some");

/***/ }),

/***/ "core-js/modules/esnext.set.symmetric-difference":
/*!******************************************************************!*\
  !*** external "core-js/modules/esnext.set.symmetric-difference" ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.symmetric-difference");

/***/ }),

/***/ "core-js/modules/esnext.set.union":
/*!***************************************************!*\
  !*** external "core-js/modules/esnext.set.union" ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.union");

/***/ }),

/***/ "core-js/modules/web.dom-collections.for-each":
/*!***************************************************************!*\
  !*** external "core-js/modules/web.dom-collections.for-each" ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/web.dom-collections.for-each");

/***/ }),

/***/ "core-js/modules/web.dom-collections.iterator":
/*!***************************************************************!*\
  !*** external "core-js/modules/web.dom-collections.iterator" ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/web.dom-collections.iterator");

/***/ }),

/***/ "date-fns":
/*!***************************!*\
  !*** external "date-fns" ***!
  \***************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("date-fns");

/***/ }),

/***/ "inputmask-core":
/*!*********************************!*\
  !*** external "inputmask-core" ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("inputmask-core");

/***/ }),

/***/ "javascript-time-ago":
/*!**************************************!*\
  !*** external "javascript-time-ago" ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("javascript-time-ago");

/***/ }),

/***/ "javascript-time-ago/locale/en":
/*!************************************************!*\
  !*** external "javascript-time-ago/locale/en" ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("javascript-time-ago/locale/en");

/***/ }),

/***/ "jsonld":
/*!*************************!*\
  !*** external "jsonld" ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("jsonld");

/***/ }),

/***/ "jsonld-utils":
/*!*******************************!*\
  !*** external "jsonld-utils" ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("jsonld-utils");

/***/ }),

/***/ "prop-types":
/*!*****************************!*\
  !*** external "prop-types" ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("prop-types");

/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "react" ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react");

/***/ }),

/***/ "react-bootstrap":
/*!**********************************!*\
  !*** external "react-bootstrap" ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-bootstrap");

/***/ }),

/***/ "react-bootstrap/Card":
/*!***************************************!*\
  !*** external "react-bootstrap/Card" ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-bootstrap/Card");

/***/ }),

/***/ "react-datepicker":
/*!***********************************!*\
  !*** external "react-datepicker" ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-datepicker");

/***/ }),

/***/ "react-dom":
/*!****************************!*\
  !*** external "react-dom" ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-dom");

/***/ }),

/***/ "react-select":
/*!*******************************!*\
  !*** external "react-select" ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-select");

/***/ }),

/***/ "react-window":
/*!*******************************!*\
  !*** external "react-window" ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-window");

/***/ }),

/***/ "regenerator-runtime/runtime":
/*!**********************************************!*\
  !*** external "regenerator-runtime/runtime" ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("regenerator-runtime/runtime");

/***/ }),

/***/ "tsort":
/*!************************!*\
  !*** external "tsort" ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("tsort");

/***/ }),

/***/ "yasgui-yasqe":
/*!*******************************!*\
  !*** external "yasgui-yasqe" ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("yasgui-yasqe");

/***/ })

/******/ });