'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactBootstrap = require('react-bootstrap');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HelpIcon = function HelpIcon(props) {
    var tooltip = _react2.default.createElement(
        _reactBootstrap.Tooltip,
        { id: 'help-tooltip' },
        props.text
    );
    return _react2.default.createElement(
        _reactBootstrap.OverlayTrigger,
        { placement: 'right', overlay: tooltip },
        _react2.default.createElement(_reactBootstrap.Glyphicon, { glyph: props.glyph ? props.glyph : 'question-sign', className: props.iconClass })
    );
};

HelpIcon.propTypes = {
    text: _react2.default.PropTypes.string.isRequired,
    glyph: _react2.default.PropTypes.string,
    iconClass: _react2.default.PropTypes.string
};

HelpIcon.defaultProps = {
    iconClass: ''
};

exports.default = HelpIcon;