export default class Constants {
    static COLUMN_COUNT: number;
    static INPUT_LENGTH_THRESHOLD: number;
    static DATETIME_NUMBER_FORMAT: string;
    /**
     * Contains mainly definition of constants used to parse the form declaration.
     */
    static FORM: string;
    static HAS_SUBQUESTION: string;
    static HAS_ANSWER: string;
    static HAS_OPTION: string;
    static HAS_OPTIONS_QUERY: string;
    static HAS_VALUE_TYPE: string;
    static IS_DISABLED: string;
    static INPUT_MASK: string;
    static LAYOUT_CLASS: string;
    static LAYOUT: {
        FORM: string;
        QUESTION_SECTION: string;
        WIZARD_STEP: string;
        DATE: string;
        TIME: string;
        DATETIME: string;
        TEXT: string;
        TEXTAREA: string;
        CHECKBOX: string;
        QUESTION_TYPEAHEAD: string;
        MASKED_INPUT: string;
        ANSWERABLE: string;
        SPARQL: string;
        TURTLE: string;
        DISABLED: string;
        HIDDEN: string;
        COLLAPSED: string;
        EMPHASISED: string;
        EMPHASISE_ON_RELEVANT: string;
        CATEGORY: string[];
    };
    static HAS_INITIAL_INPUT_LENGTH: string;
    static VALUE_TYPE_CODE: string;
    static VALUE_TYPE_TEXT: string;
    static GENERATED_ROW_SIZE: number;
    static HAS_QUESTION_ORIGIN: string;
    static HAS_ANSWER_ORIGIN: string;
    static HAS_DATA_VALUE: string;
    static HAS_OBJECT_VALUE: string;
    static HELP_DESCRIPTION: string;
    static SOURCE: string;
    static XSD: {
        MAX_EXCLUSIVE: string;
        MAX_INCLUSIVE: string;
        MIN_EXCLUSIVE: string;
        MIN_INCLUSIVE: string;
        INT: string;
        INTEGER: string;
        NEGATIVE_INTEGER: string;
        NON_NEGATIVE_INTEGER: string;
        NON_POSITIVE_INTEGER: string;
        POSITIVE_INTEGER: string;
        BOOLEAN: string;
    };
    static STEP: string;
    static ACCEPTS_ANSWER_VALUE: string;
    static ACCEPTS: string;
    static HAS_DATATYPE: string;
    static HAS_LAYOUT_CLASS: string;
    static HAS_POSSIBLE_VALUES_QUERY: string;
    static HAS_REQUIRED_VALUE: string;
    static HAS_TESTED_QUESTION: string;
    static HAS_TESTED_FORM: string;
    static HAS_UNIT: string;
    static HAS_VALID_ANSWER: string;
    static IS_RELEVANT_IF: string;
    static ACCEPTS_VALIDATION_VALUE: string;
    static HAS_VALIDATION_MESSAGE: string;
    static NEGATIVE_CONDITION: string;
    static REQUIRES_ANSWER: string;
    static REQUIRES_ANSWER_DESCRIPTION_IF: string;
    static REQUIRES_ANSWER_IF: string;
    static REQUIRES_ANSWER_VALUE: string;
    static REQUIRES_DESCRIPTION: string;
    static HAS_PRECEDING_QUESTION: string;
    static HAS_PRECEDING_VALUE: string;
    static HAS_MEDIA_CONTENT: string;
    static CONDITION: string;
    static OR_CONDITION: string;
    static HAS_SUB_CONDITION: string;
    static HAS_PATTERN: string;
    static HAS_DECLARED_PREFIX: string;
    static PREFIX: string;
    static NAMESPACE: string;
    static HAS_COMMENT: string;
    static HAS_COMMENT_VALUE: string;
    static HAS_AUTHOR: string;
    static HAS_TIMESTAMP: string;
    static NOT_ANSWERED_QUESTION: string;
    static ANSWERED_QUESTION: string;
    static RDFS_LABEL: any;
    static RDFS_COMMENT: any;
    static DEFAULT_HAS_CHILD: any;
    static ICONS: {
        QUESTION_COMMENTS: string;
        QUESTION_HELP: string;
        QUESTION_LINK: string;
    };
    static ICON_BEHAVIOR: {
        ENABLE: string;
        DISABLE: string;
        ON_HOVER: string;
    };
    static DEFAULT_OPTIONS: {
        icons: {
            id: string;
            behavior: string;
        }[];
    };
}
