'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = require("babel-runtime/core-js/object/get-prototype-of");

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require("babel-runtime/helpers/possibleConstructorReturn");

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require("babel-runtime/helpers/inherits");

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _reactBootstrap = require("react-bootstrap");

var _jsonldUtils = require("jsonld-utils");

var _jsonldUtils2 = _interopRequireDefault(_jsonldUtils);

var _Answer = require("./Answer");

var _Answer2 = _interopRequireDefault(_Answer);

var _Configuration = require("../model/Configuration");

var _Configuration2 = _interopRequireDefault(_Configuration);

var _Constants = require("../constants/Constants");

var _Constants2 = _interopRequireDefault(_Constants);

var _FormUtils = require("../util/FormUtils");

var _FormUtils2 = _interopRequireDefault(_FormUtils);

var _HelpIcon = require("./HelpIcon");

var _HelpIcon2 = _interopRequireDefault(_HelpIcon);

var _JsonObjectMap = require("../util/JsonObjectMap");

var _JsonObjectMap2 = _interopRequireDefault(_JsonObjectMap);

var _QuestionAnswerProcessor = require("../model/QuestionAnswerProcessor");

var _QuestionAnswerProcessor2 = _interopRequireDefault(_QuestionAnswerProcessor);

var _ValidatorFactory = require("../model/ValidatorFactory");

var _ValidatorFactory2 = _interopRequireDefault(_ValidatorFactory);

var _JsonLdObjectUtils = require("../util/JsonLdObjectUtils");

var _JsonLdObjectUtils2 = _interopRequireDefault(_JsonLdObjectUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Question = function (_React$Component) {
    (0, _inherits3.default)(Question, _React$Component);

    function Question(props) {
        (0, _classCallCheck3.default)(this, Question);

        var _this = (0, _possibleConstructorReturn3.default)(this, (0, _getPrototypeOf2.default)(Question).call(this, props));

        _this.onAnswerChange = function (answerIndex, change) {
            _this._onChange(_Constants2.default.HAS_ANSWER, answerIndex, change);
        };

        _this.onSubQuestionChange = function (subQuestionIndex, change) {
            _this._onChange(_Constants2.default.HAS_SUBQUESTION, subQuestionIndex, change);
        };

        _JsonObjectMap2.default.addObject(props.question["@id"], props.question);
        _this.state = {
            validator: _ValidatorFactory2.default.createValidator(props.question)
        };
        return _this;
    }

    (0, _createClass3.default)(Question, [{
        key: "_onChange",
        value: function _onChange(att, valueIndex, newValue) {
            var newState = (0, _objectAssign2.default)({}, this.props.question);
            newState[att][valueIndex] = newValue;
            if (att === _Constants2.default.HAS_ANSWER) {
                var result = this.state.validator(newValue);
                newState = (0, _objectAssign2.default)(newState, result);
            }

            _JsonObjectMap2.default.addObject(newState["@id"], newState);
            this.props.onChange(this.props.index, newState);
        }
    }, {
        key: "render",
        value: function render() {
            var question = this.props.question;
            if (_FormUtils2.default.isHidden(question)) {
                return null;
            }
            if (!_FormUtils2.default.isRelevant(question)) {
                return null;
            }
            if (_FormUtils2.default.isAnswerable(question)) {
                return _react2.default.createElement(
                    "div",
                    null,
                    this.renderAnswers(),
                    _react2.default.createElement(
                        "div",
                        { style: { padding: '0 0 0 3em' } },
                        this.renderSubQuestions()
                    )
                );
            }
            if (_FormUtils2.default.isSection(question)) {
                if (this.props.withoutPanel) {
                    return _react2.default.createElement(
                        "div",
                        null,
                        this._renderQuestionContent()
                    );
                } else {
                    var label = _jsonldUtils2.default.getLocalized(question[_jsonldUtils2.default.RDFS_LABEL], _Configuration2.default.intl);
                    return _react2.default.createElement(
                        _reactBootstrap.Panel,
                        { header: _react2.default.createElement(
                                "h5",
                                null,
                                label
                            ), bsStyle: "info" },
                        this._renderQuestionContent()
                    );
                }
            } else {
                return _react2.default.createElement(
                    "div",
                    null,
                    this._renderQuestionContent()
                );
            }
        }
    }, {
        key: "_renderQuestionContent",
        value: function _renderQuestionContent() {
            return [this.renderAnswers(), this.renderSubQuestions()];
        }
    }, {
        key: "renderAnswers",
        value: function renderAnswers() {
            var question = this.props.question,
                children = [],
                row = [],
                cls,
                isTextarea;
            var answers = this._getAnswers();
            for (var i = 0, len = answers.length; i < len; i++) {
                isTextarea = _FormUtils2.default.isTextarea(this.props.question, _FormUtils2.default.resolveValue(answers[i]));
                cls = Question._getAnswerClass(isTextarea);
                row.push(_react2.default.createElement(
                    "div",
                    { key: 'row-item-' + i, className: cls },
                    _react2.default.createElement(
                        "div",
                        { className: "row" },
                        _react2.default.createElement(
                            "div",
                            { className: "col-xs-10" },
                            _react2.default.createElement(_Answer2.default, { index: i, answer: answers[i], question: question, onChange: this.onAnswerChange })
                        ),
                        _react2.default.createElement(
                            "div",
                            null,
                            this._renderUnits(),
                            this._renderQuestionHelp()
                        )
                    )
                ));
                if (row.length === _Constants2.default.GENERATED_ROW_SIZE || isTextarea) {
                    children.push(_react2.default.createElement(
                        "div",
                        { className: "row", key: 'question-row-' + i },
                        row
                    ));
                    row = [];
                }
            }
            if (row.length > 0) {
                children.push(_react2.default.createElement(
                    "div",
                    { className: "row", key: 'question-row-' + i },
                    row
                ));
            }
            return children;
        }
    }, {
        key: "_getAnswers",
        value: function _getAnswers() {
            var question = this.props.question;
            if (!question[_Constants2.default.HAS_ANSWER]) {
                if (_FormUtils2.default.isSection(question) && !_FormUtils2.default.isAnswerable(question) || _FormUtils2.default.isWizardStep(question)) {
                    question[_Constants2.default.HAS_ANSWER] = [];
                } else {
                    question[_Constants2.default.HAS_ANSWER] = [_QuestionAnswerProcessor2.default.generateAnswer(question)];
                }
            }
            if (!Array.isArray(question[_Constants2.default.HAS_ANSWER])) {
                question[_Constants2.default.HAS_ANSWER] = [question[_Constants2.default.HAS_ANSWER]];
            }
            return question[_Constants2.default.HAS_ANSWER];
        }
    }, {
        key: "_renderQuestionHelp",
        value: function _renderQuestionHelp() {
            var question = this.props.question,
                helpClass = _FormUtils2.default.isCheckbox(question) ? 'help-icon-checkbox' : 'help-icon-text-input';
            return question[_Constants2.default.HELP_DESCRIPTION] ? _react2.default.createElement(_HelpIcon2.default, {
                text: _jsonldUtils2.default.getLocalized(question[_Constants2.default.HELP_DESCRIPTION], _Configuration2.default.intl),
                iconClass: helpClass }) : null;
        }
    }, {
        key: "_renderUnits",
        value: function _renderUnits() {
            var question = this.props.question;
            return question[_Constants2.default.HAS_UNIT] ? _react2.default.createElement(
                "div",
                { className: "has-unit-label" },
                question[_Constants2.default.HAS_UNIT]
            ) : null;
        }
    }, {
        key: "renderSubQuestions",
        value: function renderSubQuestions() {
            var children = [],
                subQuestions = this._getSubQuestions();
            for (var i = 0, len = subQuestions.length; i < len; i++) {
                children.push(_react2.default.createElement(Question, { key: 'sub-question-' + i, index: i, question: subQuestions[i],
                    onChange: this.onSubQuestionChange }));
            }
            return children;
        }
    }, {
        key: "_getSubQuestions",
        value: function _getSubQuestions() {
            var question = this.props.question;
            if (!question[_Constants2.default.HAS_SUBQUESTION]) {
                question[_Constants2.default.HAS_SUBQUESTION] = [];
            }
            if (!Array.isArray(question[_Constants2.default.HAS_SUBQUESTION])) {
                question[_Constants2.default.HAS_SUBQUESTION] = [question[_Constants2.default.HAS_SUBQUESTION]];
            }

            // sort by label
            question[_Constants2.default.HAS_SUBQUESTION].sort(_JsonLdObjectUtils2.default.getCompareLocalizedLabelFunction(_Configuration2.default.intl));

            // sort by property
            _JsonLdObjectUtils2.default.toplogicalSort(question[_Constants2.default.HAS_SUBQUESTION], _Constants2.default.HAS_PRECEDING_QUESTION);

            return question[_Constants2.default.HAS_SUBQUESTION];
        }
    }], [{
        key: "_getAnswerClass",
        value: function _getAnswerClass(isTextarea) {
            return isTextarea ? 'col-xs-12' : _Constants2.default.GENERATED_ROW_SIZE === 1 ? 'col-xs-5' : 'col-xs-' + _Constants2.default.COLUMN_COUNT / _Constants2.default.GENERATED_ROW_SIZE;
        }
    }]);
    return Question;
}(_react2.default.Component);

Question.propTypes = {
    question: _react2.default.PropTypes.object.isRequired,
    onChange: _react2.default.PropTypes.func.isRequired,
    index: _react2.default.PropTypes.number,
    withoutPanel: _react2.default.PropTypes.bool
};
exports.default = Question;